package net.ibizsys.central.plugin.cs.core.logic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.central.res.SysLogicRuntimeBase;

public abstract class CentralServiceLogicRuntimeBase extends SysLogicRuntimeBase implements ICentralServiceLogicRuntime{

	private static final Log log = LogFactory.getLog(CentralServiceLogicRuntimeBase.class);

	final public static int DEFAULTORDERVALUE = 99999;

	private String strCentralServiceUrl = null;
	
	@Override
	protected void onInit() throws Exception {
		
		if(!StringUtils.hasLength(this.getCentralServiceUrl())) {
			String strCentralServiceUrl = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICEPATH, null);
			if (!StringUtils.hasLength(strCentralServiceUrl)) {
				throw new Exception("未指定CentralStudio服务路径");
			}
			this.setCentralServiceUrl(strCentralServiceUrl);
		}
		
		super.onInit();
	}
	
	protected String getCentralServiceUrl() {
		return this.strCentralServiceUrl;
	}
	
	protected void setCentralServiceUrl(String strCentralServiceUrl) {
		this.strCentralServiceUrl = strCentralServiceUrl;
	}
	
	@Override
	protected Object onExecute(Object[] args, Object logicParam, Object logicParam2) throws Throwable {
		
		if(ObjectUtils.isEmpty(args)) {
			throw new Exception("传入参数无效");
		}
		
		return null;
	}
	

	
}
