package net.ibizsys.central.plugin.cs.core.dataentity.action;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSStudioPluginDataDTO;
import net.ibizsys.centralstudio.util.CentralServiceUtils;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.centralstudio.util.LogLevels;
import net.ibizsys.centralstudio.util.PSModelServiceSession;
import net.ibizsys.centralstudio.util.PSModelServiceUtils;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.runtime.util.ZipUtils;

public abstract class PSRTModelExportActionRuntimeBase extends PSModelImportActionRuntimeBase{

	private static final Log log = LogFactory.getLog(PSRTModelExportActionRuntimeBase.class);
	
	/**
	 * 系统设置：默认运行时模型GIT账户
	 */
	public final static String SETTING_PARAM_RTMODEL_GITUSERNAME = "param.rtmodel.gitusername";
	
	/**
	 * 系统设置：默认运行时模型GIT密码
	 */
	public final static String SETTING_PARAM_RTMODEL_GITPASSWORD = "param.rtmodel.gitpassword";
	
	/**
	 * 系统参数：运行时模型配置
	 */
	public final static String PLUGINPARAM_PSRTMODEL = "psrtmodel";
	
	
	/**
	 * 运行时模型：zip文件
	 */
	public final static String RTMODEL_TYPE_ZIP = "ZIP";
	
	
	/**
	 * 运行时模型：git 仓库
	 */
	public final static String RTMODEL_TYPE_GIT = "GIT";
	
	public final static String RTMODEL_URL = "url";
	
	public final static String RTMODEL_TYPE = "type";
	
	public final static String RTMODEL_BRANCH = "branch";
	
	public final static String RTMODEL_USERNAME = "username";
	
	public final static String RTMODEL_PASSWORD = "password";
	
	protected boolean isImportMode() {
		return false;
	}
	
	@Override
	protected Object onExecute(PSStudioPluginDataDTO psStudioPluginDataDTO) throws Throwable {
		if(isImportMode()) {
			return super.onExecute(psStudioPluginDataDTO);
		}
		
		String strPSDevSlnSysId = psStudioPluginDataDTO.getPSDevSlnSysId();
		if(!StringUtils.hasLength(strPSDevSlnSysId)) {
			throw new Exception("插件数据未指定开发系统");
		}
		
		PSDevSlnSysDTO psDevSlnSysDTO = null;
		try {
			psDevSlnSysDTO = CentralServiceUtils.getInstance().getPSDevSlnSysService().getWithAllRepoInfo(strPSDevSlnSysId);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("获取指定开发系统[%1$s]发生异常，%2$s", strPSDevSlnSysId, ex.getMessage()), ex);
		}
		
		//提取参数 
		Map<String, Object> paramMap = this.getPluginParam(psStudioPluginDataDTO);
		return this.exportPSRTModel(psDevSlnSysDTO, paramMap);
		
	}
	
	protected Object exportPSRTModel(PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
		
		Object psmodelapi = paramMap.get(PLUGINPARAM_PSMODELAPI);
		Map psmodelapiMap = null;
		if(psmodelapi instanceof Map) {
			psmodelapiMap = (Map)psmodelapi;
		}
		if(psmodelapiMap == null) {
			psmodelapiMap = this.getPSModelAPIParams(psDevSlnSysDTO);
		}
		else {
			this.fillPSModelAPIParams(psmodelapiMap, psDevSlnSysDTO);
		}
		
		if (psmodelapiMap == null && !isEnableNoPSModelAPIMode()) {
			throw new Exception("未指定模型API配置");
		}
		
		// 进行PSMODELAPI调用
		PSModelServiceSession psModelServiceSession = null;
		if(psmodelapiMap != null) {
			psModelServiceSession = openPSModelServiceSession(psmodelapiMap);
		}
		
		String strPSSysDevBKTaskId = null;
		try {
			// 开启日志
			if(psModelServiceSession != null) {
				strPSSysDevBKTaskId = PSModelServiceUtils.getInstance().beginPSSysDevBKTask(getPSSysDevBKTaskName(paramMap));
				PSModelServiceUtils.getInstance().updateCurrentPSSysDevBKTask("开始执行");
			}
			
			Object psrtmodel = paramMap.get(PLUGINPARAM_PSRTMODEL);
			Map psrtmodelMap = null;
			if(psrtmodel instanceof Map) {
				psrtmodelMap = (Map)psrtmodel;
			}
			if(psrtmodelMap == null) {
				psrtmodelMap = this.getPSRTModelParams(psDevSlnSysDTO);
			}
			else {
				this.fillPSRTModelParams(psrtmodelMap, psDevSlnSysDTO);
			}
			
			IPSSystemService iPSSystemService = this.getPSRTModelService(psrtmodelMap);

			Object ret = onExportPSRTModel(iPSSystemService, psDevSlnSysDTO, paramMap);

			if(psModelServiceSession != null) {
				PSModelServiceUtils.getInstance().finishCurrentPSSysDevBKTask(null);
				PSModelServiceSession.close(true);
			}
			
			return ret;
			
		} catch (Throwable ex) {

			if(psModelServiceSession != null) {
				if (StringUtils.hasLength(strPSSysDevBKTaskId)) {
					PSModelServiceUtils.getInstance().errorCurrentPSSysDevBKTask(ex.getMessage());
				}
				PSModelServiceSession.close(false);
			}
			
			throw ex;
		}
	}

	
	
	
	protected Map getPSRTModelParams(PSDevSlnSysDTO psDevSlnSysDTO) throws Throwable {
		
		Map<String, Object> params = new HashMap<String, Object>();
		
		String strRTModelUrl = DataTypeUtils.getStringValue(psDevSlnSysDTO.getPSDevCenterSVNPath(), null);
		if(!StringUtils.hasLength(strRTModelUrl)) {
			throw new Exception(String.format("传入开发系统未指定代码仓库地址"));
		}
		
		params.put(RTMODEL_URL, strRTModelUrl);
		params.put(RTMODEL_TYPE, RTMODEL_TYPE_GIT);
		params.put(RTMODEL_USERNAME, this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_RTMODEL_GITUSERNAME));
		params.put(RTMODEL_PASSWORD, this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_RTMODEL_GITPASSWORD));
		params.put(RTMODEL_BRANCH, psDevSlnSysDTO.getPSDevCenterSVNBranch());
		
		return params;
	}
	
	protected void fillPSRTModelParams(Map<String, Object> params, PSDevSlnSysDTO psDevSlnSysDTO) throws Throwable {
		
		
	}
	
	
	protected Object onExportPSRTModel(IPSSystemService iPSSystemService, PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
		throw new Exception("没有实现");
	}
	
	
	protected IPSSystemService getPSRTModelService(Map psrtmodelMap) throws Exception {

		String strRTModelUrl = DataTypeUtils.getStringValue(psrtmodelMap.get("url"), null);
		String strType = DataTypeUtils.getStringValue(psrtmodelMap.get("type"), "zip");
		String strBranch = DataTypeUtils.getStringValue(psrtmodelMap.get("branch"), "master");
		String strGitUserName = DataTypeUtils.getStringValue(psrtmodelMap.get("username"), null);
		String strGitPassword = DataTypeUtils.getStringValue(psrtmodelMap.get("password"), null);

		if (!StringUtils.hasLength(strRTModelUrl)) {
			throw new Exception("未指定运行时模型路径");
		}

		// 签出文件
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("开始下载运行时模型[%1$s]", strRTModelUrl));
		
		String strPath = null;
		if(RTMODEL_TYPE_GIT.equals(strType)) {
			strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
			File folder = new File(strPath);
			folder.mkdirs();
			try {
				CloneCommand cloneCommand = Git.cloneRepository().setURI(strRTModelUrl).setDirectory(folder).setBranch(strBranch);
				if (StringUtils.hasLength(strGitUserName)) {
					if (StringUtils.hasLength(strGitPassword)) {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
					} else {
						cloneCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(strGitUserName, ""));
					}
				}
				cloneCommand.call();
			} catch (Throwable ex) {
				throw new Exception(String.format("获取运行时模型发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		else
			if(RTMODEL_TYPE_ZIP.equals(strType)) {
				String[] items = strRTModelUrl.split("[#]");
				String url = items[0];
				File tempFile = File.createTempFile("resource", ".zip");
				try {
					this.getSystemRuntime().getDefaultWebClient().download(url, tempFile);
				}
				catch (Throwable ex) {
					throw new Exception(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
				}
				
				String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
				File folder = new File(folderPath);
				ZipUtils.unzip(tempFile, folder);
				
				if(items.length == 2 && StringUtils.hasLength(items[1])) {
					folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
				}
				strPath = folder.getAbsolutePath();
			}
			else {
				throw new Exception(String.format("无法识别的运行时模型类型[%1$s]", strType));
			}
		

		
		
		this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("结束下载运行时模型"));
		
		String strModelPath = "";
		File modelFile = new File(String.format("%1$s%2$sibizmodel.yaml", strPath, File.separator));
		if(modelFile.exists()) {
			//从配置文件中提取目录
			try {
				Yaml yaml = new Yaml();
				Map config = yaml.loadAs(new FileInputStream(modelFile) , Map.class);
				if(config != null) {
					String strModelFolder = (String)config.get("modelfolder");
					if(StringUtils.hasLength(strModelFolder)) {
						strModelPath = strPath + File.separator + strModelFolder;
					}
				}
			}
			catch (Throwable ex) {
				throw new Exception(String.format("加载运行时模型配置发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		if(!StringUtils.hasLength(strModelPath)) {
			//未指定直接使用根目录
			strModelPath = strPath;
		}
		
		IPSSystemService iPSSystemService = null;
		try {
			iPSSystemService = this.getPSSystemService(strModelPath);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("加载运行时模型发生异常，%1$s", ex.getMessage()), ex);
		}
		
		return iPSSystemService;
	}
	
	protected IPSSystemService getPSSystemService(String strModelPath) throws Throwable {
		PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
		psModelServiceImpl.setPSModelFolderPath(strModelPath);
		psModelServiceImpl.getPSSystem();
		return psModelServiceImpl;
	}
}
