package net.ibizsys.central.plugin.cs.core.dataentity.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSSysDBColumnDTO;
import net.ibizsys.centralstudio.dto.PSSysDBSchemeDTO;
import net.ibizsys.centralstudio.dto.PSSysDBTableDTO;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.DataTypes;
import net.ibizsys.centralstudio.util.EntityBase;
import net.ibizsys.centralstudio.util.LogLevels;

public class DBSchemaImportActionRuntime extends PSModelImportActionRuntimeBase{

	private static final Log log = LogFactory.getLog(DBSchemaImportActionRuntime.class);
	
	protected static Map<String, Integer> str2intMap = new HashMap<String, Integer>();
	
	private PSSysDBSchemeDTO psSysDBSchemeDTO = null;
	private Map<String, PSSysDBTableDTO> psSysDBTableDTOMap = new HashMap<String, PSSysDBTableDTO>();
	
	static {
		str2intMap.put("BIGINT", DataTypes.BIGINT);
		str2intMap.put("BINARY", DataTypes.BINARY);
		str2intMap.put("BIT", DataTypes.BIT);
		str2intMap.put("CHAR", DataTypes.CHAR);
		str2intMap.put("DATETIME", DataTypes.DATETIME);
		str2intMap.put("DECIMAL", DataTypes.DECIMAL);
		str2intMap.put("BIGDECIMAL", DataTypes.BIGDECIMAL);
		str2intMap.put("FLOAT", DataTypes.FLOAT);
		str2intMap.put("IMAGE", DataTypes.IMAGE);
		str2intMap.put("INT", DataTypes.INT);
		str2intMap.put("MONEY", DataTypes.MONEY);
		str2intMap.put("NCHAR", DataTypes.NCHAR);
		str2intMap.put("NTEXT", DataTypes.NTEXT);
		str2intMap.put("NVARCHAR", DataTypes.NVARCHAR);
		str2intMap.put("NUMERIC", DataTypes.NUMERIC);
		str2intMap.put("REAL", DataTypes.REAL);
		str2intMap.put("SMALLDATETIME", DataTypes.SMALLDATETIME);
		str2intMap.put("SMALLINT", DataTypes.SMALLINT);
		str2intMap.put("SMALLMONEY", DataTypes.SMALLMONEY);
		str2intMap.put("SQL_VARIANT", DataTypes.SQL_VARIANT);
		str2intMap.put("SYSNAME", DataTypes.SYSNAME);
		str2intMap.put("TEXT", DataTypes.TEXT);
		str2intMap.put("TIMESTAMP", DataTypes.TIMESTAMP);
		str2intMap.put("TINYINT", DataTypes.TINYINT);
		str2intMap.put("VARBINARY", DataTypes.VARBINARY);
		str2intMap.put("VARCHAR", DataTypes.VARCHAR);
		str2intMap.put("UNIQUEIDENTIFIER", DataTypes.UNIQUEIDENTIFIER);
		str2intMap.put("DATE", DataTypes.DATE);
		str2intMap.put("TIME", DataTypes.TIME);
		//
		str2intMap.put("VARCHAR2", DataTypes.VARCHAR);
		str2intMap.put("NUMBER", DataTypes.DECIMAL);
		str2intMap.put("BLOB", DataTypes.VARBINARY);
		str2intMap.put("CLOB", DataTypes.TEXT);
		str2intMap.put("MEDIUMTEXT", DataTypes.TEXT);
		
		str2intMap.put("DOUBLE", DataTypes.DECIMAL);
	}



	@Override
	protected Object onImportPSModel(PSDevSlnSysDTO psDevSlnSys, Map<String, Object> paramMap) throws Throwable {
		
		if(paramMap == null) {
			throw new Exception("未指定导入数据源参数");
		}
		
		Map datasourceMap = null;
		Object datasource = paramMap.get("datasource");
		if (datasource instanceof Map) {
			datasourceMap = (Map) datasource;
		}

		if (datasourceMap == null) {
			throw new Exception("未指定数据源配置");
		}
		
		Map psSysDBSchemaMap = null;
		Object pssysdbschema = paramMap.get("pssysdbschema");
		if(pssysdbschema == null) {
			pssysdbschema = paramMap.get("pssysdbscheme");
		}
		if (pssysdbschema instanceof Map) {
			psSysDBSchemaMap = (Map) pssysdbschema;
		}
		else {
			psSysDBSchemaMap = new HashMap<String, Object>();
		}
		
		
		Set<Table> tables = null;
		if(true) {
			String strUrl = DataTypeUtils.getStringValue(datasourceMap.get("url"), null);
			String strUserName = DataTypeUtils.getStringValue(datasourceMap.get("username"), null);
			String strPassword = DataTypeUtils.getStringValue(datasourceMap.get("password"), null);
			String strDriverClassName = DataTypeUtils.getStringValue(datasourceMap.get("driverclassname"), null);
			
			// 对比数据库信息
			ResourceAccessor resourceAccessor = new FileSystemResourceAccessor();

			Database targetDatabase = CommandLineUtils.createDatabaseObject(resourceAccessor, strUrl, strUserName, strPassword, strDriverClassName, "", "", false, false, null, null, null, null, null, null, null);

			String strTypes = "Column,Table,PrimaryKey"; // Column,Table,Index,ForeignKey,Index,PrimaryKey
			SnapshotControl snapshotControl = new SnapshotControl(targetDatabase, strTypes);

			//ObjectQuotingStrategy originalStrategy = targetDatabase.getObjectQuotingStrategy();
			
			try {
				targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
				DatabaseSnapshot databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(CatalogAndSchema.DEFAULT, targetDatabase, snapshotControl);

				tables = databaseSnapshot.get(Table.class);
			//	columns = databaseSnapshot.get(Column.class);
				
				
			}
			catch (Throwable ex) {
				throw new Exception(String.format("获取数据库模型切片发生异常，%1$s", ex.getMessage()), ex);
			}
			finally {
				if(targetDatabase!=null) {
					try {
						targetDatabase.close();
					}
					catch (Throwable ex) {
						log.error(ex);
					}
				}
			}
		}
		
		String strDSLink = DataTypeUtils.getStringValue(psSysDBSchemaMap.get("dslink"), "DEFAULT");
		String strPSSysDBSchemaName = DataTypeUtils.getStringValue(psSysDBSchemaMap.get("name"), "数据源");
		
		
		
		//查询系统数据源
		PSSysDBSchemeDTO psSysDBSchemeDTO = new PSSysDBSchemeDTO();
		psSysDBSchemeDTO.setExistingModel(EntityBase.BOOLEAN_TRUE);
		psSysDBSchemeDTO.setDSLink(strDSLink);
		psSysDBSchemeDTO.setPSSysDBSchemeName(strPSSysDBSchemaName);
		
		try {
			this.psSysDBSchemeDTO = this.getPSSysDBSchemeDTO(psSysDBSchemeDTO);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("建立数据库体系[%1$s]发生异常，%2$s", strDSLink, ex.getMessage()), ex);
		}
		
		if(ObjectUtils.isEmpty(tables)) {
			this.updateCurrentPSSysDevBKTask(LogLevels.INFO, String.format("指定数据源未包含任何数据表对象"));
			return null;
		}
		
		this.syncPSSysDBTableDTOs(tables);
		this.syncPSSysDBColumnDTOs(tables);
		
		return null;
	}
	
	protected List<PSSysDBTableDTO> syncPSSysDBTableDTOs(Set<Table> tables) throws Exception{
		
		List<PSSysDBTableDTO> psSysDBTableDTOList = new ArrayList<PSSysDBTableDTO>();
		
		for(Table table : tables) {
			PSSysDBTableDTO psSysDBTableDTO = new PSSysDBTableDTO();
			psSysDBTableDTO.setPSSysDBSchemeId(this.getPSSysDBSchemeDTO().getPSSysDBSchemeId());
			psSysDBTableDTO.setPSSysDBSchemeName(this.getPSSysDBSchemeDTO().getPSSysDBSchemeName());
			psSysDBTableDTO.setTableType("TABLE");
			psSysDBTableDTO.setPSSysDBTableName(table.getName().toUpperCase());
			psSysDBTableDTO.setCodeName(table.getName());
			
			psSysDBTableDTOList.add(psSysDBTableDTO);
		}
		
		try {
			psSysDBTableDTOList = this.getPSSysDBTableDTOs(this.getPSSysDBSchemeDTO(), psSysDBTableDTOList);
			for(PSSysDBTableDTO psSysDBTableDTO:psSysDBTableDTOList) {
				psSysDBTableDTOMap.put(psSysDBTableDTO.getPSSysDBTableName().toUpperCase(), psSysDBTableDTO);
			}
		}
		catch (Throwable ex) {
			throw new Exception(String.format("建立数据库体系[%1$s]数据表对象发生异常，%2$s", this.getPSSysDBSchemeDTO().getDSLink(), ex.getMessage()), ex);
		}
		
		return psSysDBTableDTOList;
	}
	
	protected List<PSSysDBColumnDTO> syncPSSysDBColumnDTOs(Set<Table> tables) throws Exception{
		
		List<PSSysDBColumnDTO> psSysDBColumnDTOList = new ArrayList<PSSysDBColumnDTO>();
		
		for(Table table : tables) {
			
			PSSysDBTableDTO psSysDBTableDTO = this.getPSSysDBTableDTO(table.getName().toUpperCase());
			
			//循环列
			List<Column> columns = table.getColumns();
			if(!ObjectUtils.isEmpty(columns)) {
				Map<String, Column> pkeyMap = new HashMap<String, Column>();
				
				if(table.getPrimaryKey()!=null && !ObjectUtils.isEmpty(table.getPrimaryKey().getColumns())) {
					for(Column column : table.getPrimaryKey().getColumns()) {
						pkeyMap.put(column.getName().toUpperCase(), column);
					}
				}
				for(Column column : columns) {
					PSSysDBColumnDTO psSysDBColumnDTO = new PSSysDBColumnDTO();
					
					psSysDBColumnDTO.setPSSysDBTableId(psSysDBTableDTO.getPSSysDBTableId());
					psSysDBColumnDTO.setPSSysDBTableName(psSysDBTableDTO.getPSSysDBTableName());
					psSysDBColumnDTO.setPSSysDBColumnName(column.getName().toUpperCase());
					psSysDBColumnDTO.setCodeName(column.getName());
					psSysDBColumnDTO.setOrderValue(column.getOrder());
					
					psSysDBColumnDTO.setDataType(column.getType().toString());
					psSysDBColumnDTO.setAllowEmpty(1);
					
					//判断是否主键
					if(pkeyMap.containsKey(column.getName().toUpperCase())){
						psSysDBColumnDTO.setPKey(1);
						psSysDBColumnDTO.setAllowEmpty(0);
					}
					else {
						psSysDBColumnDTO.setAllowEmpty(column.isNullable()?1:0);
					}
					
					//填充标准数据类型
					String strType = column.getType().toString();
					Integer nLength = null;
					Integer nPrecision = null;
					int nPos = strType.indexOf("(");
					if(nPos != -1) {
						strType = strType.replace(")","");
						strType = strType.replace("(","|");
						String[] items = strType.split("[|]");
						strType = items[0];
						String strLength = items[1];
						if(StringUtils.hasLength(strLength)) {
							items = strLength.split("[,]");
							strLength = items[0];
							String[] items2 = strLength.trim().split("[ ]");
							nLength = Integer.parseInt(items2[0]);
							if(items.length ==2) {
								nPrecision = Integer.parseInt(items[1].trim());
							}
						}
						
						if(nLength != null && nLength <0) {
							nLength = null;
						}
						
						if(nLength!=null) {
							if(nPrecision != null && nPrecision <0) {
								nPrecision = null;
							}
						}
						else {
							nPrecision = null;
						}
					}
					
					psSysDBColumnDTO.setDataType(strType.toUpperCase());
					psSysDBColumnDTO.setLength(nLength);
					psSysDBColumnDTO.setPrecision2(nPrecision);
					
					if(str2intMap.containsKey(strType.toUpperCase())){
						int nStdDataType = str2intMap.get(strType.toUpperCase());
						psSysDBColumnDTO.setStdDataType(nStdDataType);
					}
					else {
						log.warn(String.format("无法识别的数据类型[%1$s]", column.getType().toString()));
						
						this.updateCurrentPSSysDevBKTask(LogLevels.WARN, String.format("无法识别的数据列[%1$s %2$s][%3$s]", psSysDBColumnDTO.getPSSysDBColumnName(), column.getType().toString(), psSysDBColumnDTO.getPSSysDBTableName()));
						
						continue;
					}
					
					psSysDBColumnDTOList.add(psSysDBColumnDTO);
				}
			}
		}
		
		try {
			psSysDBColumnDTOList = this.getPSSysDBColumnDTOs(this.getPSSysDBSchemeDTO(), psSysDBColumnDTOList);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("建立数据库体系[%1$s]数据列对象发生异常，%2$s", this.getPSSysDBSchemeDTO().getDSLink(), ex.getMessage()), ex);
		}
		
		return psSysDBColumnDTOList;
	}
	
	protected PSSysDBSchemeDTO getPSSysDBSchemeDTO() {
		return this.psSysDBSchemeDTO;
	}

	protected PSSysDBTableDTO getPSSysDBTableDTO(String strTableName)throws Exception {
		PSSysDBTableDTO psSysDBTableDTO = psSysDBTableDTOMap.get(strTableName.toUpperCase());
		if(psSysDBTableDTO == null) {
			throw new Exception(String.format("无法获取数据表[%1$s]对应数据对象", strTableName));
		}
		return psSysDBTableDTO;
	}
}
