/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.core.dataentity.action;

import java.io.File;
import java.util.Map;
import net.ibizsys.central.plugin.cs.core.dataentity.action.PSRTModelExportActionRuntimeBase;
import net.ibizsys.centralstudio.dto.PSDevSlnSysDTO;
import net.ibizsys.centralstudio.dto.PSStudioPluginDataDTO;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.runtime.util.ZipUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;

public abstract class CodeGenActionRuntimeBase
extends PSRTModelExportActionRuntimeBase {
    private static final Log log = LogFactory.getLog(CodeGenActionRuntimeBase.class);
    public static final String PLUGINPARAM_TEMPLATE = "template";
    public static final String TEMPLATE_TYPE_ZIP = "ZIP";
    public static final String TEMPLATE_TYPE_GIT = "GIT";
    public static final String TEMPLATE_URL = "url";
    public static final String TEMPLATE_TYPE = "type";
    public static final String TEMPLATE_BRANCH = "branch";
    public static final String TEMPLATE_USERNAME = "username";
    public static final String TEMPLATE_PASSWORD = "password";
    private ThreadLocal<String> templatePathThreadLocal = new ThreadLocal();

    @Override
    protected Object onExecute(PSStudioPluginDataDTO psStudioPluginDataDTO) throws Throwable {
        this.resetSessionParams();
        try {
            Object object = super.onExecute(psStudioPluginDataDTO);
            return object;
        }
        finally {
            this.resetSessionParams();
        }
    }

    protected void resetSessionParams() {
        this.onResetSessionParams();
    }

    protected void onResetSessionParams() {
        this.templatePathThreadLocal.remove();
    }

    @Override
    protected Object onExportPSRTModel(IPSSystemService iPSSystemService, PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
        if (!StringUtils.hasLength((String)this.getTemplatePath())) {
            Object templateParams = paramMap.get(PLUGINPARAM_TEMPLATE);
            if (templateParams instanceof Map) {
                Map templateMap = (Map)templateParams;
                this.setTemplatePath(this.getTemplatePath(templateMap));
            } else {
                throw new Exception(String.format("\u672a\u6307\u5b9a\u6a21\u677f\u53c2\u6570", new Object[0]));
            }
        }
        return super.onExportPSRTModel(iPSSystemService, psDevSlnSysDTO, paramMap);
    }

    protected void prepareTemplatePath(PSDevSlnSysDTO psDevSlnSysDTO, Map<String, Object> paramMap) throws Throwable {
    }

    protected String getTemplatePath(Map templateMap) throws Exception {
        String strTemplateUrl = DataTypeUtils.getStringValue(templateMap.get(TEMPLATE_URL), null);
        String strType = DataTypeUtils.getStringValue(templateMap.get(TEMPLATE_TYPE), (String)"zip");
        String strBranch = DataTypeUtils.getStringValue(templateMap.get(TEMPLATE_BRANCH), (String)"master");
        String strGitUserName = DataTypeUtils.getStringValue(templateMap.get(TEMPLATE_USERNAME), null);
        String strGitPassword = DataTypeUtils.getStringValue(templateMap.get(TEMPLATE_PASSWORD), null);
        if (!StringUtils.hasLength((String)strTemplateUrl)) {
            throw new Exception("\u672a\u6307\u5b9a\u6a21\u677f\u8def\u5f84");
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6[%1$s]", strTemplateUrl));
        String strPath = null;
        if (TEMPLATE_TYPE_GIT.equals(strType)) {
            strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
            File folder = new File(strPath);
            folder.mkdirs();
            try {
                CloneCommand cloneCommand = Git.cloneRepository().setURI(strTemplateUrl).setDirectory(folder).setBranch(strBranch);
                if (StringUtils.hasLength((String)strGitUserName)) {
                    if (StringUtils.hasLength((String)strGitPassword)) {
                        cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                    } else {
                        cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                    }
                }
                cloneCommand.call();
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if (TEMPLATE_TYPE_ZIP.equals(strType)) {
            String[] items = strTemplateUrl.split("[#]");
            String url = items[0];
            File tempFile = File.createTempFile("resource", ".zip");
            try {
                this.getSystemRuntime().getDefaultWebClient().download(url, (Object)tempFile);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
            File folder = new File(folderPath);
            ZipUtils.unzip((File)tempFile, (File)folder);
            if (items.length == 2 && StringUtils.hasLength((String)items[1])) {
                folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
            }
            strPath = folder.getAbsolutePath();
        } else {
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6a21\u677f\u6587\u4ef6\u7c7b\u578b[%1$s]", strType));
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u7ed3\u675f\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", new Object[0]));
        return strPath;
    }

    protected String getTemplatePath() {
        return this.templatePathThreadLocal.get();
    }

    protected void setTemplatePath(String templatePath) {
        this.templatePathThreadLocal.set(templatePath);
    }
}

