/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.cs.core.dataentity.action;

import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.dataentity.action.DEActionRuntimeBase;
import net.ibizsys.centralstudio.util.CentralServiceSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class CentralServiceActionRuntimeBase
extends DEActionRuntimeBase {
    private static final Log log = LogFactory.getLog(CentralServiceActionRuntimeBase.class);
    public static final String SETTING_PARAM_CENTRALSERVICE_URL = "param.centralservice.url";
    public static final String SETTING_PARAM_CENTRALSERVICE_BEARER = "param.centralservice.bearer";
    public static final String SETTING_PARAM_CENTRALSERVICE_SYSTEMID = "param.centralservice.systemid";
    public static final String SETTING_PARAM_CENTRALSERVICE_ORGID = "param.centralservice.orgid";
    private String strCentralServiceUrl = null;
    private String strCentralServiceBearer = null;
    private String strCentralServiceSystemId = null;
    private String strCentralServiceOrgId = null;

    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getCentralServiceUrl())) {
            String strCentralServiceUrl = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_URL, null);
            if (!StringUtils.hasLength((String)strCentralServiceUrl)) {
                throw new Exception("\u672a\u6307\u5b9aCentralStudio\u670d\u52a1\u8def\u5f84");
            }
            this.setCentralServiceUrl(strCentralServiceUrl);
        }
        if (!StringUtils.hasLength((String)this.getCentralServiceBearer())) {
            String strCentralServiceBearer = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_BEARER, null);
            this.setCentralServiceBearer(strCentralServiceBearer);
        }
        if (!StringUtils.hasLength((String)this.getCentralServiceSystemId())) {
            String strCentralServiceSystemId = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_SYSTEMID, null);
            this.setCentralServiceSystemId(strCentralServiceSystemId);
        }
        if (!StringUtils.hasLength((String)this.getCentralServiceOrgId())) {
            String strCentralServiceOrgId = this.getSystemRuntime().getSystemRuntimeSetting().getParam(SETTING_PARAM_CENTRALSERVICE_ORGID, null);
            this.setCentralServiceOrgId(strCentralServiceOrgId);
        }
        super.onInit();
    }

    protected String getCentralServiceUrl() {
        return this.strCentralServiceUrl;
    }

    protected void setCentralServiceUrl(String strCentralServiceUrl) {
        this.strCentralServiceUrl = strCentralServiceUrl;
    }

    protected String getCentralServiceBearer() {
        return this.strCentralServiceBearer;
    }

    protected void setCentralServiceBearer(String strCentralServiceBearer) {
        this.strCentralServiceBearer = strCentralServiceBearer;
    }

    protected String getCentralServiceSystemId() {
        return this.strCentralServiceSystemId;
    }

    protected void setCentralServiceSystemId(String strCentralServiceSystemId) {
        this.strCentralServiceSystemId = strCentralServiceSystemId;
    }

    protected String getCentralServiceOrgId() {
        return this.strCentralServiceOrgId;
    }

    protected void setCentralServiceOrgId(String strCentralServiceOrgId) {
        this.strCentralServiceOrgId = strCentralServiceOrgId;
    }

    protected Object onExecute(Object[] args) throws Throwable {
        boolean bOpenSession = false;
        boolean bOommitFlag = true;
        try {
            CentralServiceSession centralServiceSession = CentralServiceSession.getCurrent((boolean)true);
            if (centralServiceSession == null) {
                centralServiceSession = this.openCentralServiceSession();
                bOpenSession = true;
            }
            Object object = super.onExecute(args);
            return object;
        }
        catch (Throwable ex) {
            bOommitFlag = false;
            throw ex;
        }
        finally {
            if (bOpenSession) {
                CentralServiceSession.close((boolean)bOommitFlag);
            }
        }
    }

    protected CentralServiceSession openCentralServiceSession() throws Exception {
        CentralServiceSession centralServiceSession = CentralServiceSession.open((boolean)true);
        centralServiceSession.setServiceUrl(this.getCentralServiceUrl());
        if (StringUtils.hasLength((String)this.getCentralServiceBearer())) {
            centralServiceSession.setBearer(this.getCentralServiceBearer());
        } else {
            centralServiceSession.setBearer(AuthenticationUser.getCurrentMust().getToken());
        }
        if (StringUtils.hasLength((String)this.getCentralServiceSystemId())) {
            centralServiceSession.setSystemId(this.getCentralServiceSystemId());
        } else {
            centralServiceSession.setSystemId(EmployeeContext.getCurrentMust().getSystemid());
        }
        if (StringUtils.hasLength((String)this.getCentralServiceOrgId())) {
            centralServiceSession.setOrgId(this.getCentralServiceOrgId());
        } else {
            centralServiceSession.setOrgId(EmployeeContext.getCurrentMust().getOrgid());
        }
        return centralServiceSession;
    }
}

