/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.calcite.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.Db2SqlDialect;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;

public class SQLParserUtils {
    static Map<String, SqlParser.Config> ConfigMap = new HashMap<String, SqlParser.Config>();
    static Map<String, SqlDialect> SqlDialectMap = new HashMap<String, SqlDialect>();
    static Map<String, Lex> LexMap = new HashMap<String, Lex>();

    public static SqlDialect getSqlDialect(String strDBType) {
        SqlDialect sqlDialect = SqlDialectMap.get(strDBType = strDBType.toUpperCase());
        if (sqlDialect != null) {
            return sqlDialect;
        }
        switch (strDBType) {
            case "MYSQL5": 
            case "SQLITE": 
            case "MYSQL": {
                return MysqlSqlDialect.DEFAULT;
            }
            case "DB2": {
                return Db2SqlDialect.DEFAULT;
            }
            case "ORACLE": 
            case "PPAS": {
                return OracleSqlDialect.DEFAULT;
            }
            case "POSTGRESQL": {
                return PostgresqlSqlDialect.DEFAULT;
            }
            case "SQLSERVER": {
                return MssqlSqlDialect.DEFAULT;
            }
        }
        return MysqlSqlDialect.DEFAULT;
    }

    public static void setSqlDialect(String strDBType, SqlDialect sqlDialect) {
        SqlDialectMap.put(strDBType.toUpperCase(), sqlDialect);
    }

    public static Lex getLex(String strDBType) {
        Lex lex = LexMap.get(strDBType = strDBType.toUpperCase());
        if (lex != null) {
            return lex;
        }
        switch (strDBType) {
            case "MYSQL5": 
            case "SQLITE": 
            case "MYSQL": {
                return Lex.MYSQL;
            }
            case "ORACLE": 
            case "PPAS": {
                return Lex.ORACLE;
            }
            case "SQLSERVER": {
                return Lex.SQL_SERVER;
            }
        }
        return Lex.MYSQL_ANSI;
    }

    public static void setLex(String strDBType, Lex lex) {
        LexMap.put(strDBType.toUpperCase(), lex);
    }

    public static SqlParser.Config getConfig(String strDBType) {
        SqlParser.Config config = ConfigMap.get(strDBType.toUpperCase());
        if (config != null) {
            return config;
        }
        return ConfigMap.get("");
    }

    public static void setConfig(String strDBType, SqlParser.Config config) {
        ConfigMap.put(strDBType.toUpperCase(), config);
    }

    static {
        ConfigMap.put("MYSQL5", SqlParser.config().withLex(SQLParserUtils.getLex("MYSQL5")));
        ConfigMap.put("MYSQL", ConfigMap.get("MYSQL5"));
        ConfigMap.put("SQLITE", ConfigMap.get("MYSQL5"));
        ConfigMap.put("ORACLE", SqlParser.config().withLex(SQLParserUtils.getLex("ORACLE")));
        ConfigMap.put("PPAS", ConfigMap.get("ORACLE"));
        ConfigMap.put("SQLSERVER", SqlParser.config().withLex(SQLParserUtils.getLex("SQLSERVER")));
        ConfigMap.put("", SqlParser.config().withLex(Lex.MYSQL_ANSI));
    }
}

