/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.calcite.util;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.plugin.calcite.util.SQLCountIfFunction;
import net.ibizsys.central.plugin.calcite.util.SQLFunctionBase;
import net.ibizsys.central.plugin.calcite.util.SQLMultiIfFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionParser {
    private static final Log log = LogFactory.getLog(FunctionParser.class);
    public static final String COUNTIF = "COUNTIF";
    public static final String MULTIIF = "MULTIIF";
    private static Map<String, SQLFunctionBase> SQLFunctionMap = new HashMap<String, SQLFunctionBase>();

    public static SqlCall parseSQL(SqlBasicCall function) {
        SQLFunctionBase sqlFunctionBase = SQLFunctionMap.get(function.getOperator().getName().toUpperCase());
        if (sqlFunctionBase != null) {
            return sqlFunctionBase.parse(function);
        }
        return function;
    }

    static {
        SQLFunctionMap.put(COUNTIF, new SQLCountIfFunction());
        SQLFunctionMap.put(MULTIIF, new SQLMultiIfFunction());
    }
}

