/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.calcite.dataentity.ds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.central.dataentity.ds.DEDQSQLCustomCondParserBase;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.plugin.calcite.util.FunctionParser;
import net.ibizsys.central.plugin.calcite.util.SQLParserUtils;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.Db2SqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalciteDEDQSQLCustomCondParser
extends DEDQSQLCustomCondParserBase {
    private static final Log log = LogFactory.getLog(CalciteDEDQSQLCustomCondParser.class);
    private static final Pattern Regex = Pattern.compile("\\$(\\{.*?\\})");
    private String strColumnNameField = "name";
    private static Random random = new Random();

    protected Pattern getPattern() {
        return Regex;
    }

    protected String getColumnNameField() {
        return this.strColumnNameField;
    }

    protected String onParse(ISearchCustomCond iSearchCustomCond, IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime, ISearchContext iSearchContext) throws Throwable {
        final String strRandomText = String.format("a%06d", random.nextInt(999999));
        StringBuilder aliasSb = new StringBuilder();
        try {
            SqlBasicCall sqlBasicCall;
            SqlParser parser = SqlParser.create((String)iDEDataQueryCodeRuntime.getPSDEDataQueryCode().getQueryCode(), (SqlParser.Config)SQLParserUtils.getConfig(iDEDataQueryCodeRuntime.getDBDialect().getDBType()));
            SqlNode sqlNode = parser.parseQuery();
            SqlSelect sqlSelect = (SqlSelect)sqlNode;
            SqlNode sqlFromNode = sqlSelect.getFrom();
            if (sqlFromNode instanceof SqlBasicCall && (sqlBasicCall = (SqlBasicCall)sqlFromNode).getOperator() instanceof SqlAsOperator) {
                aliasSb.append(((SqlNode)sqlBasicCall.getOperandList().get(1)).toString());
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u89e3\u6790\u67e5\u8be2\u4ee3\u7801\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        String strAlias = aliasSb.toString();
        String text = iSearchCustomCond.getCustomCond();
        Matcher matcher = this.getPattern().matcher(text);
        LinkedHashMap<String, String> replaceContentMap = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String json = matcher.group(1);
            try {
                Map map = JsonUtils.asMap((Object)json);
                Object columnName = map.get(this.getColumnNameField());
                if (columnName == null) continue;
                String strExpression = null;
                String strColumnName = columnName.toString();
                IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(strColumnName, true);
                if (iPSDEDataQueryCodeExp == null) {
                    IPSDEField iPSDEField = iDEDataQueryCodeRuntime.getDataEntityRuntime().getPSDEField(strColumnName, false);
                    if (iPSDEField == null) {
                        throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", iDEDataQueryCodeRuntime.getDataEntityRuntime().getName(), strColumnName));
                    }
                    strExpression = String.format("%1$s.%2$s", strAlias, strColumnName);
                } else {
                    strExpression = iPSDEDataQueryCodeExp.getExpression();
                }
                strExpression = String.format("%1$s%2$s", strRandomText, strExpression);
                replaceContentMap.put(String.format("$%1$s", json), strExpression);
            }
            catch (Throwable throwable) {
                log.error((Object)String.format("PQL\u81ea\u5b9a\u4e49\u6761\u4ef6\u89e3\u6790Json\u53d1\u751f\u5f02\u5e38\uff0c%1$s", throwable.getMessage()), throwable);
            }
        }
        if (replaceContentMap.size() > 0) {
            for (Map.Entry entry : replaceContentMap.entrySet()) {
                text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        String query = "SELECT 1 FROM t1 where " + text;
        try {
            SqlParser sqlParser = SqlParser.create((String)query, (SqlParser.Config)SQLParserUtils.getConfig(iDEDataQueryCodeRuntime.getDBDialect().getDBType()));
            SqlNode sqlNode = sqlParser.parseQuery();
            SqlSelect sqlSelect = (SqlSelect)sqlNode;
            SqlNode sqlWhereNode = sqlSelect.getWhere();
            final ArrayList columnList = new ArrayList();
            SqlNode replacedNode = (SqlNode)sqlWhereNode.accept((SqlVisitor)new SqlShuttle(){

                public SqlNode visit(SqlCall sqlCall) {
                    if (sqlCall instanceof SqlBasicCall) {
                        SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlCall;
                        SqlCall sqlCall2 = FunctionParser.parseSQL(sqlBasicCall);
                        return super.visit(sqlCall2);
                    }
                    return super.visit(sqlCall);
                }

                public @Nullable SqlNode visit(SqlIdentifier id) {
                    if (id.names.size() != 2) {
                        columnList.add(id);
                    } else {
                        if (((String)id.names.get(0)).indexOf(strRandomText) == 0) {
                            return super.visit(id.setName(0, ((String)id.names.get(0)).substring(strRandomText.length())));
                        }
                        columnList.add(id);
                    }
                    return super.visit(id);
                }
            });
            if (columnList.size() > 0) {
                throw new Exception(String.format("\u4e0d\u80fd\u76f4\u63a5\u4f7f\u7528\u5217[%1$s]", ((SqlIdentifier)columnList.get(0)).toString()));
            }
            return replacedNode.toSqlString(Db2SqlDialect.DEFAULT).getSql();
        }
        catch (Throwable throwable) {
            throw new Exception(String.format("\u89e3\u6790\u81ea\u5b9a\u4e49\u6761\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", throwable.getMessage()), throwable);
        }
    }
}

