/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.ai.sysutil;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.cloud.core.sysutil.SysUtilRuntimeBase;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.central.plugin.ai.addin.ISysAIFactoryUtilRTAddin;
import net.ibizsys.central.plugin.ai.agent.DefaultAIChatProvider;
import net.ibizsys.central.plugin.ai.agent.EntityAIChatProvider;
import net.ibizsys.central.plugin.ai.agent.IAIChatAgent;
import net.ibizsys.central.plugin.ai.agent.IAIChatProvider;
import net.ibizsys.central.plugin.ai.agent.IAIPipelineAgent;
import net.ibizsys.central.plugin.ai.agent.IAIPipelineProvider;
import net.ibizsys.central.plugin.ai.agent.IAIWorkerAgent;
import net.ibizsys.central.plugin.ai.agent.IAIWorkerProvider;
import net.ibizsys.central.plugin.ai.agent.PSAppDEACModeAIChatProvider;
import net.ibizsys.central.plugin.ai.sysutil.ISysAIFactoryUtilRuntime;
import net.ibizsys.central.plugin.ai.sysutil.ISysAIFactoryUtilRuntimeContext;
import net.ibizsys.central.res.ISysFileResourceRuntime;
import net.ibizsys.central.res.ISysResourceRuntime;
import net.ibizsys.central.res.ISysSCMResourceRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDEACMode;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysAIFactoryUtilRuntimeBase
extends SysUtilRuntimeBase
implements ISysAIFactoryUtilRuntime {
    private static final Log log = LogFactory.getLog(SysAIFactoryUtilRuntimeBase.class);
    public static final String AICHATAGENTMODE_DEFAULT = "DEFAULT";
    public static final String AICHATAGENTMODE_PSAPPDEACMODE = "PSAPPDEACMODE";
    public static final String AICHATAGENTMODE_ENTITY = "ENTITY";
    private ISysAIFactoryUtilRuntimeContext iSysAIFactoryUtilRuntimeContext = new ISysAIFactoryUtilRuntimeContext(){

        @Override
        public ISysAIFactoryUtilRuntime getSysAIFactoryUtilRuntime() {
            return SysAIFactoryUtilRuntimeBase.this.getSelf();
        }

        @Override
        public String getConfigContent(Object data, String strConfigId, boolean bTryMode) throws Throwable {
            return SysAIFactoryUtilRuntimeBase.this.getSelf().getConfigContent(data, strConfigId, bTryMode);
        }
    };
    private Map<String, IAIPipelineProvider> aiPipelineProviderMap = null;
    private Map<String, IAIWorkerProvider> aiWorkerProviderMap = null;
    private Map<String, IAIChatProvider> aiChatProviderMap = null;
    private Map<String, IAIWorkerAgent> aiWorkerAgentMap = new ConcurrentHashMap<String, IAIWorkerAgent>();
    private Map<String, IAIChatAgent> aiChatAgentMap = new ConcurrentHashMap<String, IAIChatAgent>();
    private ISysFileResourceRuntime configSysFileResourceRuntime = null;
    private boolean bConfigFromResource = false;
    private String strDefautConfigPath = null;

    protected void onInstall() throws Exception {
        super.onInstall();
        this.aiPipelineProviderMap = this.getAddins(IAIPipelineProvider.class, "AIPIPELINE:");
        this.aiWorkerProviderMap = this.getAddins(IAIWorkerProvider.class, "AIWORKER:");
        this.aiChatProviderMap = this.getAddins(IAIChatProvider.class, "AICHAT:");
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.prepareConfig();
    }

    protected void prepareConfig() throws Exception {
        if (this.getPSSysUtil().getPSSysResource() == null) {
            log.warn((Object)String.format("AI\u5de5\u5382\u7ec4\u4ef6[%1$s]\u672a\u6307\u5b9a\u914d\u7f6e\u8d44\u6e90", this.getName()));
            return;
        }
        ISysResourceRuntime iSysResourceRuntime = this.getSystemRuntime().getSysResourceRuntime(this.getPSSysUtil().getPSSysResource());
        if (iSysResourceRuntime instanceof ISysFileResourceRuntime) {
            this.setConfigFromResource(false);
            this.setConfigSysFileResourceRuntime((ISysFileResourceRuntime)iSysResourceRuntime);
        }
    }

    private SysAIFactoryUtilRuntimeBase getSelf() {
        return this;
    }

    protected ISysAIFactoryUtilRuntimeContext getSysAIFactoryUtilRuntimeContext() {
        return this.iSysAIFactoryUtilRuntimeContext;
    }

    protected void prepareAddinRepo() throws Exception {
        this.prepareAddinRepo(this.getSysAIFactoryUtilRuntimeContext(), ISysAIFactoryUtilRTAddin.class, String.format("%1$s:", this.getFullUniqueTag()));
    }

    @Override
    public IAIPipelineAgent getAIPipelineAgent(final Object aiPipelineAgentData) {
        return (IAIPipelineAgent)this.executeAction("\u83b7\u53d6AI\u6d41\u6c34\u7ebf\u4ee3\u7406", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                Object item;
                Object realRealAIPipelineAgentData = SysAIFactoryUtilRuntimeBase.this.getRealAIPipelineAgentData(aiPipelineAgentData);
                String strAIPipelineAgentTag = SysAIFactoryUtilRuntimeBase.this.getAIPipelineAgentTag(realRealAIPipelineAgentData);
                ActionSession actionSession = ActionSessionManager.getCurrentSession();
                String strCacheTag = String.format("CACHE_%1$s_%2$s", IAIPipelineAgent.class.getName(), strAIPipelineAgentTag);
                if (actionSession != null && (item = actionSession.getActionParam(strCacheTag)) != null) {
                    return (IAIPipelineAgent)item;
                }
                IAIPipelineAgent iAIPipelineAgent = SysAIFactoryUtilRuntimeBase.this.onGetAIPipelineAgent(realRealAIPipelineAgentData);
                if (actionSession != null) {
                    actionSession.setActionParam(strCacheTag, (Object)iAIPipelineAgent);
                }
                return iAIPipelineAgent;
            }
        }, null);
    }

    protected Object getRealAIPipelineAgentData(Object aiPipelineAgentData) throws Throwable {
        return aiPipelineAgentData;
    }

    protected IAIPipelineAgent onGetAIPipelineAgent(Object aiPipelineAgentData) throws Throwable {
        String strAIPipelineAgentMode = this.getAIPipelineAgentMode(aiPipelineAgentData);
        IAIPipelineProvider iAIPipelineProvider = this.aiPipelineProviderMap.get(strAIPipelineAgentMode);
        if (iAIPipelineProvider == null && iAIPipelineProvider == null) {
            throw new Exception(String.format("AI\u6d41\u6c34\u7ebf[%1$s]\u63d0\u4f9b\u65b9\u65e0\u6548", strAIPipelineAgentMode));
        }
        IAIPipelineAgent iAIPipelineAgent = iAIPipelineProvider.createAIPipelineAgent(aiPipelineAgentData);
        iAIPipelineAgent.init(this.getSysAIFactoryUtilRuntimeContext(), aiPipelineAgentData, strAIPipelineAgentMode);
        return iAIPipelineAgent;
    }

    protected String getAIPipelineAgentTag(Object aiPipelineAgentData) throws Throwable {
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u6d41\u6c34\u7ebf\u4ee3\u7406\u6807\u8bb0", aiPipelineAgentData));
    }

    protected String getAIPipelineAgentMode(Object aiPipelineAgentData) throws Throwable {
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u6d41\u6c34\u7ebf\u4ee3\u7406\u6a21\u5f0f", aiPipelineAgentData));
    }

    protected Object getRealAIWorkerAgentData(Object aiWorkerAgentData) throws Throwable {
        return aiWorkerAgentData;
    }

    @Override
    public IAIWorkerAgent getAIWorkerAgent(final Object aiWorkerAgentData) {
        return (IAIWorkerAgent)this.executeAction("\u83b7\u53d6AI\u5de5\u4f5c\u8005\u4ee3\u7406", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                Object realRealAIWorkerAgentData = SysAIFactoryUtilRuntimeBase.this.getRealAIWorkerAgentData(aiWorkerAgentData);
                String strAIWorkerAgentTag = SysAIFactoryUtilRuntimeBase.this.getAIWorkerAgentTag(realRealAIWorkerAgentData);
                Object item = SysAIFactoryUtilRuntimeBase.this.aiWorkerAgentMap.get(strAIWorkerAgentTag);
                if (item != null) {
                    return (IAIWorkerAgent)item;
                }
                IAIWorkerAgent iAIWorkerAgent = SysAIFactoryUtilRuntimeBase.this.onGetAIWorkerAgent(realRealAIWorkerAgentData);
                SysAIFactoryUtilRuntimeBase.this.aiWorkerAgentMap.put(strAIWorkerAgentTag, iAIWorkerAgent);
                return iAIWorkerAgent;
            }
        }, null);
    }

    protected IAIWorkerAgent onGetAIWorkerAgent(Object aiWorkerAgentData) throws Throwable {
        String strAIWorkerAgentMode = this.getAIWorkerAgentMode(aiWorkerAgentData);
        IAIWorkerProvider iAIWorkerProvider = this.aiWorkerProviderMap.get(strAIWorkerAgentMode);
        if (iAIWorkerProvider == null && iAIWorkerProvider == null) {
            throw new Exception(String.format("AI\u5de5\u4f5c\u8005[%1$s]\u63d0\u4f9b\u65b9\u65e0\u6548", strAIWorkerAgentMode));
        }
        IAIWorkerAgent iAIWorkerAgent = iAIWorkerProvider.createAIWorkerAgent(aiWorkerAgentData);
        iAIWorkerAgent.init(this.getSysAIFactoryUtilRuntimeContext(), aiWorkerAgentData, strAIWorkerAgentMode);
        return iAIWorkerAgent;
    }

    protected String getAIWorkerAgentMode(Object aiWorkerAgentData) throws Throwable {
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u5de5\u4f5c\u8005\u4ee3\u7406\u6a21\u5f0f", aiWorkerAgentData));
    }

    @Override
    public boolean resetAIWorkerAgent(final Object aiWorkerAgentData) {
        return (Boolean)this.executeAction("\u91cd\u7f6eAI\u5de5\u4f5c\u8005\u4ee3\u7406", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                String strAIWorkerAgentTag = SysAIFactoryUtilRuntimeBase.this.getAIWorkerAgentTag(aiWorkerAgentData);
                Object item = SysAIFactoryUtilRuntimeBase.this.aiWorkerAgentMap.remove(strAIWorkerAgentTag);
                return item != null;
            }
        }, null);
    }

    @Override
    public void resetAIWorkerAgents() {
        this.aiWorkerAgentMap.clear();
    }

    protected String getAIWorkerAgentTag(Object aiWorkerAgentData) throws Throwable {
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u5de5\u4f5c\u8005\u4ee3\u7406\u6807\u8bb0", aiWorkerAgentData));
    }

    protected Object getRealAIChatAgentData(Object aiChatAgentData) throws Throwable {
        IEntityDTO iEntityDTO;
        if (aiChatAgentData instanceof IEntityDTO && (iEntityDTO = (IEntityDTO)aiChatAgentData).getDEMethodDTORuntime() != null) {
            return iEntityDTO.getDEMethodDTORuntime();
        }
        return aiChatAgentData;
    }

    @Override
    public IAIChatAgent getAIChatAgent(final Object aiChatAgentData) {
        return (IAIChatAgent)this.executeAction("\u83b7\u53d6AI\u4ea4\u8c08\u4ee3\u7406", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                Object realAIChatAgentData = SysAIFactoryUtilRuntimeBase.this.getRealAIChatAgentData(aiChatAgentData);
                String strAIChatAgentTag = SysAIFactoryUtilRuntimeBase.this.getAIChatAgentTag(realAIChatAgentData);
                Object item = SysAIFactoryUtilRuntimeBase.this.aiChatAgentMap.get(strAIChatAgentTag);
                if (item != null) {
                    return (IAIChatAgent)item;
                }
                IAIChatAgent iAIChatAgent = SysAIFactoryUtilRuntimeBase.this.onGetAIChatAgent(realAIChatAgentData);
                SysAIFactoryUtilRuntimeBase.this.aiChatAgentMap.put(strAIChatAgentTag, iAIChatAgent);
                return iAIChatAgent;
            }
        }, null);
    }

    protected IAIChatAgent onGetAIChatAgent(Object aiChatAgentData) throws Throwable {
        String strAIChatAgentMode = this.getAIChatAgentMode(aiChatAgentData);
        IAIChatProvider iAIChatProvider = this.aiChatProviderMap.get(strAIChatAgentMode);
        if (iAIChatProvider == null && iAIChatProvider == null) {
            throw new Exception(String.format("AI\u4ea4\u8c08[%1$s]\u63d0\u4f9b\u65b9\u65e0\u6548", strAIChatAgentMode));
        }
        IAIChatAgent iAIChatAgent = iAIChatProvider.createAIChatAgent(aiChatAgentData);
        iAIChatAgent.init(this.getSysAIFactoryUtilRuntimeContext(), aiChatAgentData, strAIChatAgentMode);
        return iAIChatAgent;
    }

    @Override
    public boolean resetAIChatAgent(final Object aiChatAgentData) {
        return (Boolean)this.executeAction("\u91cd\u7f6eAI\u4ea4\u8c08\u4ee3\u7406", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                String strAIChatAgentTag = SysAIFactoryUtilRuntimeBase.this.getAIChatAgentTag(aiChatAgentData);
                Object item = SysAIFactoryUtilRuntimeBase.this.aiChatAgentMap.remove(strAIChatAgentTag);
                return item != null;
            }
        }, null);
    }

    @Override
    public void resetAIChatAgents() {
        this.aiChatAgentMap.clear();
    }

    protected String getAIChatAgentMode(Object aiChatAgentData) throws Throwable {
        IDEMethodDTORuntime iDEMethodDTORuntime;
        if (aiChatAgentData instanceof IPSAppDEACMode) {
            return AICHATAGENTMODE_PSAPPDEACMODE;
        }
        if (aiChatAgentData instanceof IDEMethodDTORuntime && PSModelEnums.DEMethodDTOType.DEFAULT.value.equals((iDEMethodDTORuntime = (IDEMethodDTORuntime)aiChatAgentData).getPSDEMethodDTO().getType())) {
            return AICHATAGENTMODE_ENTITY;
        }
        if (aiChatAgentData instanceof String) {
            return AICHATAGENTMODE_DEFAULT;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u4ea4\u8c08\u4ee3\u7406\u6a21\u5f0f", aiChatAgentData));
    }

    protected String getAIChatAgentTag(Object aiChatAgentData) throws Throwable {
        IDEMethodDTORuntime iDEMethodDTORuntime;
        if (aiChatAgentData instanceof IPSAppDEACMode) {
            IPSAppDEACMode iPSAppDEACMode = (IPSAppDEACMode)aiChatAgentData;
            IPSAppDataEntity iPSAppDataEntity = (IPSAppDataEntity)iPSAppDEACMode.getParentPSModelObject(IPSAppDataEntity.class);
            IPSApplication iPSApplication = (IPSApplication)iPSAppDataEntity.getParentPSModelObject(IPSApplication.class);
            return String.format("%1$s|%2$s|%3$s|%4$s", AICHATAGENTMODE_PSAPPDEACMODE, iPSApplication.getCodeName(), iPSAppDataEntity.getCodeName(), iPSAppDEACMode.getCodeName());
        }
        if (aiChatAgentData instanceof IDEMethodDTORuntime && PSModelEnums.DEMethodDTOType.DEFAULT.value.equals((iDEMethodDTORuntime = (IDEMethodDTORuntime)aiChatAgentData).getPSDEMethodDTO().getType())) {
            return String.format("%1$s|%2$s", AICHATAGENTMODE_ENTITY, iDEMethodDTORuntime.getDataEntityRuntime().getFullUniqueTag());
        }
        if (aiChatAgentData instanceof String) {
            return String.format("%1$s|%2$s", AICHATAGENTMODE_DEFAULT, aiChatAgentData);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u4ece\u6570\u636e[%1$s]\u8ba1\u7b97AI\u4ea4\u8c08\u4ee3\u7406\u6807\u8bb0", aiChatAgentData));
    }

    @Override
    public ISysFileResourceRuntime getConfigSysFileResourceRuntime(boolean bTryMode) {
        if (this.configSysFileResourceRuntime != null || bTryMode) {
            return this.configSysFileResourceRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u672a\u6307\u5b9a\u5de5\u5382\u914d\u7f6e\u7cfb\u7edf\u6587\u4ef6\u8d44\u6e90\u8fd0\u884c\u65f6\u5bf9\u8c61", new Object[0]));
    }

    protected void setConfigSysFileResourceRuntime(ISysFileResourceRuntime templSysFileResourceRuntime) {
        this.configSysFileResourceRuntime = templSysFileResourceRuntime;
    }

    public boolean isConfigFromResource() {
        return this.bConfigFromResource;
    }

    protected void setConfigFromResource(boolean bConfigFromResource) {
        this.bConfigFromResource = bConfigFromResource;
    }

    protected String getConfigContent(Object data, String strConfigId, boolean bTryMode) throws Throwable {
        String strConfigPath = null;
        ISysFileResourceRuntime configSysFileResourceRuntime = this.getConfigSysFileResourceRuntime(true);
        if (configSysFileResourceRuntime != null) {
            if (configSysFileResourceRuntime instanceof ISysSCMResourceRuntime) {
                ((ISysSCMResourceRuntime)configSysFileResourceRuntime).checkoutIf(data);
            }
            strConfigPath = configSysFileResourceRuntime.getFile(data).getCanonicalPath();
        } else {
            strConfigPath = this.getDefautConfigPath();
        }
        return this.getConfigContentReal(strConfigPath, strConfigId, bTryMode);
    }

    protected String getConfigContentReal(String strConfigPath, String strConfigId, boolean bTryMode) throws Throwable {
        if (this.isConfigFromResource()) {
            String strFullModelPath = strConfigPath + "/" + strConfigId.replace("\\", "/");
            InputStream is = this.getClass().getResourceAsStream(strFullModelPath);
            if (is != null) {
                return IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            if (bTryMode) {
                return null;
            }
            throw new Exception(String.format("\u6307\u5b9a\u914d\u7f6e[%1$s]\u4e0d\u5b58\u5728", strFullModelPath));
        }
        String strFullModelPath = strConfigPath + File.separator + strConfigId;
        File file = new File(strFullModelPath);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u6307\u5b9a\u914d\u7f6e[%1$s]\u4e0d\u5b58\u5728", strFullModelPath));
    }

    public String getDefautConfigPath() {
        return this.strDefautConfigPath;
    }

    protected void setDefautConfigPath(String strDefautConfigPath) {
        this.strDefautConfigPath = strDefautConfigPath;
    }

    @Override
    public void resetAll() {
        this.executeAction("\u91cd\u7f6eAI\u5de5\u5382", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                SysAIFactoryUtilRuntimeBase.this.onResetAll();
                return null;
            }
        }, null);
    }

    protected void onResetAll() throws Throwable {
        this.aiWorkerAgentMap.clear();
        this.aiChatAgentMap.clear();
        ISysFileResourceRuntime configSysFileResourceRuntime = this.getConfigSysFileResourceRuntime(true);
        if (configSysFileResourceRuntime != null && configSysFileResourceRuntime instanceof ISysSCMResourceRuntime) {
            ((ISysSCMResourceRuntime)configSysFileResourceRuntime).resetAllCheckoutLog();
        }
    }

    static {
        RuntimeObjectFactory.getInstance().registerObjectIf(ISysAIFactoryUtilRTAddin.class, "*:AICHAT:DEFAULT", DefaultAIChatProvider.class);
        RuntimeObjectFactory.getInstance().registerObjectIf(ISysAIFactoryUtilRTAddin.class, "*:AICHAT:PSAPPDEACMODE", PSAppDEACModeAIChatProvider.class);
        RuntimeObjectFactory.getInstance().registerObjectIf(ISysAIFactoryUtilRTAddin.class, "*:AICHAT:ENTITY", EntityAIChatProvider.class);
    }
}

