/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.ai.app;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.app.ApplicationRuntimeException;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.cloud.core.app.IServiceAppRuntime;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRequestMappingAdapter;
import net.ibizsys.central.cloud.core.service.util.MethodHandlerBase;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.plugin.ai.agent.IAIChatAgent;
import net.ibizsys.central.plugin.ai.app.AIApplicationRuntimeBase;
import net.ibizsys.central.util.Inflector;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.app.dataentity.IPSAppDEACMode;
import net.ibizsys.model.app.dataentity.IPSAppDERS;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.AppContext;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public abstract class AIChatApplicationRuntimeBase
extends AIApplicationRuntimeBase {
    private static final Log log = LogFactory.getLog(AIChatApplicationRuntimeBase.class);

    protected void onRegisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        super.onRegisterMapping(iSysServiceAPIRequestMappingAdapter);
        this.registerAIChatCompletionMapping(iSysServiceAPIRequestMappingAdapter);
    }

    protected void registerAIChatCompletionMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        List psAppDataEntityList = this.getPSApplication().getAllPSAppDataEntities();
        if (ObjectUtils.isEmpty((Object)psAppDataEntityList)) {
            return;
        }
        for (IPSAppDataEntity iPSAppDataEntity : psAppDataEntityList) {
            this.registerAIChatCompletionMapping(iPSAppDataEntity, iSysServiceAPIRequestMappingAdapter);
        }
    }

    protected void registerAIChatCompletionMapping(final IPSAppDataEntity iPSAppDataEntity, ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        List psAppDEACModeList = iPSAppDataEntity.getAllPSAppDEACModes();
        if (ObjectUtils.isEmpty((Object)psAppDEACModeList)) {
            return;
        }
        boolean bAIChat = false;
        for (IPSAppDEACMode iPSAppDEACMode : psAppDEACModeList) {
            if (!PSModelEnums.DEACType.CHATCOMPLETION.value.equals(iPSAppDEACMode.getACType())) continue;
            bAIChat = true;
            break;
        }
        if (!bAIChat) {
            return;
        }
        List psAppDERSList = this.getPSApplication().getAllPSAppDERSs();
        if (!ObjectUtils.isEmpty((Object)psAppDERSList)) {
            for (final IPSAppDERS iPSAppDERS : psAppDERSList) {
                if (!iPSAppDERS.getMinorPSAppDataEntityMust().getId().equals(iPSAppDataEntity.getId())) continue;
                String strPath = String.format("%1$s/aichat/%2$s/{pkey}/%3$s", this.getBaseUrl(), Inflector.getInstance().pluralize((Object)iPSAppDERS.getMajorPSAppDataEntityMust().getCodeName()).toLowerCase(), Inflector.getInstance().pluralize((Object)iPSAppDataEntity.getCodeName()).toLowerCase());
                String strPath2 = String.format("%1$s/aichat/**/%2$s/{pkey}/%3$s", this.getBaseUrl(), Inflector.getInstance().pluralize((Object)iPSAppDERS.getMajorPSAppDataEntityMust().getCodeName()).toLowerCase(), Inflector.getInstance().pluralize((Object)iPSAppDataEntity.getCodeName()).toLowerCase());
                String strRequestPath = strPath + "/ssechatcompletion";
                String strRequestPath2 = strPath + "/ssechatcompletion/{key}";
                String strRequestPath3 = strPath2 + "/ssechatcompletion";
                String strRequestPath4 = strPath2 + "/ssechatcompletion/{key}";
                RequestMappingInfo requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{strRequestPath, strRequestPath2, strRequestPath3, strRequestPath4}).methods(new RequestMethod[]{RequestMethod.POST}).build();
                iSysServiceAPIRequestMappingAdapter.registerMapping((IServiceAppRuntime)this, requestMappingInfo, (Object)new MethodHandlerBase(){

                    protected Object onExecute(String pkey, Object requestData, String key, String param, String param2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletRespons) throws Throwable {
                        String strACTag = null;
                        String strQueryString = httpServletRequest.getQueryString();
                        Map map = RestUtils.queryString2Map((String)strQueryString);
                        if (map != null) {
                            strACTag = (String)map.get("srfactag");
                        }
                        return AIChatApplicationRuntimeBase.this.invokeAIChatCompletion(null, iPSAppDERS, pkey, iPSAppDataEntity, strACTag, "SSECHATCOMPLETION", requestData, key, null);
                    }
                }, MethodHandlerBase.getExecuteMethod());
                strRequestPath = strPath + "/ssechatcompletion/histories";
                strRequestPath2 = strPath + "/chatcompletion/histories";
                strRequestPath3 = strPath + "/ssechatcompletion/histories/{key}";
                strRequestPath4 = strPath + "/chatcompletion/histories/{key}";
                String strRequestPath5 = strPath2 + "/ssechatcompletion/histories";
                String strRequestPath6 = strPath2 + "/chatcompletion/histories";
                String strRequestPath7 = strPath2 + "/ssechatcompletion/histories/{key}";
                String strRequestPath8 = strPath2 + "/chatcompletion/histories/{key}";
                RequestMappingInfo requestMappingInfo2 = RequestMappingInfo.paths((String[])new String[]{strRequestPath, strRequestPath2, strRequestPath3, strRequestPath4, strRequestPath5, strRequestPath6, strRequestPath7, strRequestPath8}).methods(new RequestMethod[]{RequestMethod.POST}).build();
                iSysServiceAPIRequestMappingAdapter.registerMapping((IServiceAppRuntime)this, requestMappingInfo2, (Object)new MethodHandlerBase(){

                    protected Object onExecute(String pkey, Object requestData, String key, String param, String param2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletRespons) throws Throwable {
                        String strACTag = null;
                        String strQueryString = httpServletRequest.getQueryString();
                        Map map = RestUtils.queryString2Map((String)strQueryString);
                        if (map != null) {
                            strACTag = (String)map.get("srfactag");
                        }
                        return AIChatApplicationRuntimeBase.this.invokeAIChatCompletion(null, iPSAppDERS, pkey, iPSAppDataEntity, strACTag, "HISTORIES", requestData, key, null);
                    }
                }, MethodHandlerBase.getExecuteMethod());
            }
        }
        String strPath = String.format("%1$s/aichat/%2$s", this.getBaseUrl(), Inflector.getInstance().pluralize((Object)iPSAppDataEntity.getCodeName()).toLowerCase());
        String strRequestPath = strPath + "/ssechatcompletion";
        String strRequestPath2 = strPath + "/ssechatcompletion/{key}";
        RequestMappingInfo requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{strRequestPath, strRequestPath2}).methods(new RequestMethod[]{RequestMethod.POST}).build();
        iSysServiceAPIRequestMappingAdapter.registerMapping((IServiceAppRuntime)this, requestMappingInfo, (Object)new MethodHandlerBase(){

            protected Object onExecute(String pkey, Object requestData, String key, String param, String param2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletRespons) throws Throwable {
                String strACTag = null;
                String strQueryString = httpServletRequest.getQueryString();
                Map map = RestUtils.queryString2Map((String)strQueryString);
                if (map != null) {
                    strACTag = (String)map.get("srfactag");
                }
                return AIChatApplicationRuntimeBase.this.invokeAIChatCompletion(null, null, null, iPSAppDataEntity, strACTag, "SSECHATCOMPLETION", requestData, key, null);
            }
        }, MethodHandlerBase.getExecuteMethod());
        strRequestPath = strPath + "/ssechatcompletion/histories";
        strRequestPath2 = strPath + "/chatcompletion/histories";
        String strRequestPath3 = strPath + "/ssechatcompletion/histories/{key}";
        String strRequestPath4 = strPath + "/chatcompletion/histories/{key}";
        RequestMappingInfo requestMappingInfo3 = RequestMappingInfo.paths((String[])new String[]{strRequestPath, strRequestPath2, strRequestPath3, strRequestPath4}).methods(new RequestMethod[]{RequestMethod.POST}).build();
        iSysServiceAPIRequestMappingAdapter.registerMapping((IServiceAppRuntime)this, requestMappingInfo3, (Object)new MethodHandlerBase(){

            protected Object onExecute(String pkey, Object requestData, String key, String param, String param2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletRespons) throws Throwable {
                String strACTag = null;
                String strQueryString = httpServletRequest.getQueryString();
                Map map = RestUtils.queryString2Map((String)strQueryString);
                if (map != null) {
                    strACTag = (String)map.get("srfactag");
                }
                return AIChatApplicationRuntimeBase.this.invokeAIChatCompletion(null, null, null, iPSAppDataEntity, strACTag, "HISTORIES", requestData, key, null);
            }
        }, MethodHandlerBase.getExecuteMethod());
    }

    protected Object invokeAIChatCompletion(String strScope, IPSAppDERS iPSAppDERS, String strParentKey, IPSAppDataEntity iPSAppDataEntity, String strACTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IDataEntityRuntime parentDataEntityRuntime = null;
        if (iPSAppDERS != null) {
            parentDataEntityRuntime = (IDataEntityRuntime)this.getSystemRuntime().getDataEntityRuntime(iPSAppDERS.getMajorPSAppDataEntityMust().getPSDataEntityMust().getId());
            IAppContext iAppContext = UserContext.getCurrentMust().getAppContext();
            if (iAppContext == null) {
                iAppContext = new AppContext();
                UserContext.getCurrentMust().setAppContext(iAppContext);
            }
            iAppContext.set(iPSAppDERS.getMajorPSAppDataEntityMust().getName(), (Object)strParentKey);
        }
        IDataEntityRuntime iDataEntityRuntime = (IDataEntityRuntime)this.getSystemRuntime().getDataEntityRuntime(iPSAppDataEntity.getPSDataEntityMust().getId());
        if (StringUtils.hasLength((String)strKey)) {
            if (!iDataEntityRuntime.getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), (net.ibizsys.central.dataentity.IDataEntityRuntime)parentDataEntityRuntime, strParentKey, (Object)strKey, null, "READ")) {
                throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("%1$s[%2$s]\u4e0d\u5177\u5907\u64cd\u4f5c\u80fd\u529b[%3$s]", iDataEntityRuntime.getLogicName(), strKey, "READ"), 2);
            }
        } else if (!iDataEntityRuntime.getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), (net.ibizsys.central.dataentity.IDataEntityRuntime)parentDataEntityRuntime, strParentKey, null, null, "CREATE")) {
            throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("%1$s\u4e0d\u5177\u5907\u64cd\u4f5c\u80fd\u529b[%2$s]", iDataEntityRuntime.getLogicName(), "CREATE"), 2);
        }
        IPSAppDEACMode iPSAppDEACMode = null;
        List psAppDEACModeList = iPSAppDataEntity.getAllPSAppDEACModes();
        if (!ObjectUtils.isEmpty((Object)psAppDEACModeList)) {
            for (IPSAppDEACMode item : psAppDEACModeList) {
                if (!strACTag.equalsIgnoreCase(item.getCodeName())) continue;
                iPSAppDEACMode = item;
                break;
            }
        }
        if (iPSAppDEACMode == null) {
            throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("%1$s\u4e0d\u5177\u5907\u4ea4\u4e92\u8865\u5168[%2$s]", iDataEntityRuntime.getLogicName(), strACTag));
        }
        IAIChatAgent iAIChatAgent = this.getSysAIFactoryUtilRuntime().getAIChatAgent(iPSAppDEACMode);
        Object key = iDataEntityRuntime.convertValue(iDataEntityRuntime.getKeyPSDEField().getStdDataType(), strKey);
        if ("SSECHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iAIChatAgent.sseChatCompletion(key, (ChatCompletionRequest)JsonUtils.as((Object)objBody, ChatCompletionRequest.class), null);
        }
        if ("CHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iAIChatAgent.chatCompletion(key, (ChatCompletionRequest)JsonUtils.as((Object)objBody, ChatCompletionRequest.class), null);
        }
        if ("ASYNCCHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iAIChatAgent.asyncChatCompletion(key, (ChatCompletionRequest)JsonUtils.as((Object)objBody, ChatCompletionRequest.class), null);
        }
        if ("HISTORIES".equalsIgnoreCase(strMethodName)) {
            return iAIChatAgent.getHistories(key, objBody, null);
        }
        throw new Exception(String.format("\u672a\u8bc6\u522b\u7684\u8bf7\u6c42\u65b9\u6cd5[%1$s]", strMethodName));
    }
}

