/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.ai.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.sysutil.ISysPortalUtilRuntime;
import net.ibizsys.central.cloud.core.util.ChatMessagesBuilder;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncActionState;
import net.ibizsys.central.plugin.ai.agent.AIAgentBase;
import net.ibizsys.central.plugin.ai.agent.IAIAgentContext;
import net.ibizsys.central.plugin.ai.agent.IAIChatAgent;
import net.ibizsys.central.plugin.ai.agent.IAIChatAgentContext;
import net.ibizsys.central.util.domain.ACDataItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class AIChatAgentBase
extends AIAgentBase
implements IAIChatAgent {
    private static final Log log = LogFactory.getLog(AIChatAgentBase.class);
    private ISysPortalUtilRuntime iSysPortalUtilRuntime = null;
    private IAIChatAgentContext iAIChatAgentContext = new IAIChatAgentContext(){

        @Override
        public String output(String strTemplateId) throws Throwable {
            return this.output(null, strTemplateId);
        }

        @Override
        public String output(Object data, String strTemplateId) throws Throwable {
            return this.output(data, strTemplateId, null);
        }

        @Override
        public String output(Object data, String strTemplateId, String strIndent) throws Throwable {
            String strContent = AIChatAgentBase.this.getContent(data, String.format("template/%1$s", strTemplateId), null);
            if (!StringUtils.hasLength((String)strContent) || !StringUtils.hasLength((String)strIndent)) {
                return strContent;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String[] lines = strContent.replace("\r\n", "\n").replace("\r", "\n").split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(strIndent);
                if (!StringUtils.hasLength((String)lines[i])) continue;
                stringBuilder.append(lines[i]);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean contains(String strTemplateId) {
            try {
                return StringUtils.hasLength((String)AIChatAgentBase.this.getContext().getConfigContent(null, String.format("template/%1$s", strTemplateId), true));
            }
            catch (Throwable ex) {
                return false;
            }
        }
    };

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected IAIAgentContext getAIAgentContext() {
        return this.iAIChatAgentContext;
    }

    @Override
    public String getAgentType() {
        return "AICHAT";
    }

    protected ISysPortalUtilRuntime getSysPortalUtilRuntime() {
        if (this.iSysPortalUtilRuntime == null) {
            this.iSysPortalUtilRuntime = (ISysPortalUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysPortalUtilRuntime.class, false);
        }
        return this.iSysPortalUtilRuntime;
    }

    @Override
    public Page<ACDataItem> fetchACItems(Object objData, Object body, Map<String, Object> params) throws Throwable {
        return null;
    }

    @Override
    public List<ChatMessage> getHistories(Object dataOrKeys, Object body, Map<String, Object> params) throws Throwable {
        return this.onGetHistories(dataOrKeys, body, params);
    }

    protected List<ChatMessage> onGetHistories(Object dataOrKeys, Object body, Map<String, Object> params) throws Throwable {
        Map exTemplParams = null;
        if (params != null && params.containsKey("templparams")) {
            exTemplParams = (Map)params.get("templparams");
        }
        return this.doGetHistories(this.getActiveData(dataOrKeys), body, params, exTemplParams);
    }

    protected List<ChatMessage> doGetHistories(List entityList, Object body, Map<String, Object> params, Map<String, Object> exTemplParams) throws Throwable {
        String strConfigId = this.getHistoriesConfigId();
        if (ObjectUtils.isEmpty((Object)strConfigId)) {
            return new ArrayList<ChatMessage>();
        }
        HashMap<String, Object> templParams = new HashMap<String, Object>();
        if (exTemplParams != null) {
            templParams.putAll(exTemplParams);
        }
        String strContent = this.getContent(entityList, strConfigId, templParams);
        return new ChatMessagesBuilder().xml(strContent).build();
    }

    protected String getHistoriesConfigId() throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected List getActiveData(Object dataOrKeys) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public List<ChatMessage> getSystemMessages(Object dataOrKeys, Map<String, Object> params) throws Throwable {
        return this.onGetSystemMessages(dataOrKeys, params);
    }

    protected List<ChatMessage> onGetSystemMessages(Object dataOrKeys, Map<String, Object> params) throws Throwable {
        Map exTemplParams = null;
        if (params != null && params.containsKey("templparams")) {
            exTemplParams = (Map)params.get("templparams");
        }
        return this.doGetSystemMessages(this.getActiveData(dataOrKeys), params, exTemplParams);
    }

    protected List<ChatMessage> doGetSystemMessages(List entityList, Map<String, Object> params, Map<String, Object> exTemplParams) throws Throwable {
        String strConfigId = this.getSystemMessagesConfigId();
        if (ObjectUtils.isEmpty((Object)strConfigId)) {
            return new ArrayList<ChatMessage>();
        }
        HashMap<String, Object> templParams = new HashMap<String, Object>();
        if (exTemplParams != null) {
            templParams.putAll(exTemplParams);
        }
        String strContent = this.getContent(entityList, strConfigId, templParams);
        return new ChatMessagesBuilder().xml(strContent).build();
    }

    protected String getSystemMessagesConfigId() throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public ChatCompletionResult chatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params) throws Throwable {
        return this.chatCompletion(dataOrKeys, chatCompletionRequest, params, true, false);
    }

    @Override
    public PortalAsyncAction asyncChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params) throws Throwable {
        return this.asyncChatCompletion(dataOrKeys, chatCompletionRequest, params, true, false);
    }

    @Override
    public SseEmitter sseChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params) throws Throwable {
        return this.sseChatCompletion(dataOrKeys, chatCompletionRequest, params, true, false);
    }

    @Override
    public ChatCompletionResult chatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        try {
            return this.onChatCompletion(dataOrKeys, chatCompletionRequest, params, bAppendSystemMessage, bAppendHistories);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSysAIFactoryUtilRuntime(), String.format("\u540c\u6b65\u804a\u5929\u4ea4\u4e92\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ChatCompletionResult onChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        List<ChatMessage> systemMessageList;
        List<ChatMessage> historyList;
        if (bAppendHistories && !ObjectUtils.isEmpty(historyList = this.getHistories(dataOrKeys, null, params))) {
            if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
                historyList.addAll(chatCompletionRequest.getMessages());
                chatCompletionRequest.setMessages(historyList);
            } else {
                chatCompletionRequest.setMessages(historyList);
            }
        }
        if (bAppendSystemMessage && !ObjectUtils.isEmpty(systemMessageList = this.getSystemMessages(dataOrKeys, params))) {
            if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
                systemMessageList.addAll(chatCompletionRequest.getMessages());
                chatCompletionRequest.setMessages(systemMessageList);
            } else {
                chatCompletionRequest.setMessages(systemMessageList);
            }
        }
        return this.getSysAIUtilRuntime().chatCompletion(this.getAIPlatformType(), chatCompletionRequest);
    }

    @Override
    public PortalAsyncAction asyncChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        try {
            return this.onAsyncChatCompletion(dataOrKeys, chatCompletionRequest, params, bAppendSystemMessage, bAppendHistories);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSysAIFactoryUtilRuntime(), String.format("\u5f02\u6b65\u804a\u5929\u4ea4\u4e92\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected PortalAsyncAction onAsyncChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        List<ChatMessage> systemMessageList;
        List<ChatMessage> historyList;
        if (bAppendHistories && !ObjectUtils.isEmpty(historyList = this.getHistories(dataOrKeys, null, params))) {
            if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
                historyList.addAll(chatCompletionRequest.getMessages());
                chatCompletionRequest.setMessages(historyList);
            } else {
                chatCompletionRequest.setMessages(historyList);
            }
        }
        if (bAppendSystemMessage && !ObjectUtils.isEmpty(systemMessageList = this.getSystemMessages(dataOrKeys, params))) {
            if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
                systemMessageList.addAll(chatCompletionRequest.getMessages());
                chatCompletionRequest.setMessages(systemMessageList);
            } else {
                chatCompletionRequest.setMessages(systemMessageList);
            }
        }
        return this.getSysAIUtilRuntime().asyncChatCompletion(this.getAIPlatformType(), chatCompletionRequest);
    }

    @Override
    public SseEmitter sseChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        try {
            return this.onSseChatCompletion(dataOrKeys, chatCompletionRequest, params, bAppendSystemMessage, bAppendHistories);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getSysAIFactoryUtilRuntime(), String.format("SSE\u804a\u5929\u4ea4\u4e92\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected SseEmitter onSseChatCompletion(Object dataOrKeys, ChatCompletionRequest chatCompletionRequest, Map<String, Object> params, boolean bAppendSystemMessage, boolean bAppendHistories) throws Throwable {
        final PortalAsyncAction portalAsyncAction = this.asyncChatCompletion(dataOrKeys, chatCompletionRequest, params, bAppendSystemMessage, bAppendHistories);
        final long nTimeout = 120000L;
        return (SseEmitter)this.getSystemRuntime().sseExecute(new IAction(){

            public Object execute(Object[] args) throws Throwable {
                long nCurrentTime = System.currentTimeMillis();
                ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
                while (true) {
                    PortalAsyncAction last = AIChatAgentBase.this.getSysPortalUtilRuntime().getAsyncAction(portalAsyncAction.getAsyncAcitonId());
                    double fCompletionRate = 0.0;
                    if (last.getCompletionRate() != null) {
                        fCompletionRate = last.getCompletionRate().doubleValue();
                    }
                    actionSession.updateActionStep(last.getStepInfo(), fCompletionRate, last.getActionResult());
                    int nActionState = DataTypeUtils.getIntegerValue((Object)last.getActionState(), (Integer)PortalAsyncActionState.EXECUTING.getValue());
                    if (nActionState == PortalAsyncActionState.FINISHED.getValue()) {
                        return last.getActionResult();
                    }
                    if (nActionState == PortalAsyncActionState.FAILED.getValue()) {
                        throw new Exception(last.getActionResult());
                    }
                    if (System.currentTimeMillis() - nCurrentTime >= nTimeout) {
                        throw new Exception("\u53cd\u9988\u8d85\u65f6");
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex);
                        continue;
                    }
                    break;
                }
            }
        }, null, null, -1L);
    }
}

