/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.ai.agent;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.plugin.ai.agent.AIAgentBase;
import net.ibizsys.central.plugin.ai.agent.AIChatAgentBase;
import net.ibizsys.central.plugin.ai.agent.AIPipelineRunSessionBase;
import net.ibizsys.central.plugin.ai.agent.AIWorkerAgentScriptBase;
import net.ibizsys.central.plugin.ai.agent.IAIAgentContext;
import net.ibizsys.central.plugin.ai.agent.IAIPipelineRunSession;
import net.ibizsys.central.plugin.ai.agent.IAIWorkerAgent;
import net.ibizsys.central.plugin.ai.agent.IAIWorkerAgentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.springframework.util.StringUtils;

public abstract class AIWorkerAgentBase
extends AIAgentBase
implements IAIWorkerAgent {
    private static final Log log = LogFactory.getLog(AIChatAgentBase.class);
    private Map<String, AIWorkerAgentScriptBase> aiWorkerAgentScriptMap = new HashMap<String, AIWorkerAgentScriptBase>();
    private IAIWorkerAgentContext iAIWorkerAgentContext = new IAIWorkerAgentContext(){

        @Override
        public String output(String strTemplateId) throws Throwable {
            return this.output(null, strTemplateId);
        }

        @Override
        public String output(Object data, String strTemplateId) throws Throwable {
            return this.output(data, strTemplateId, null);
        }

        @Override
        public String output(Object data, String strTemplateId, String strIndent) throws Throwable {
            String strContent = AIWorkerAgentBase.this.getContent(data, String.format("template/%1$s", strTemplateId), null);
            if (!StringUtils.hasLength((String)strContent) || !StringUtils.hasLength((String)strIndent)) {
                return strContent;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String[] lines = strContent.replace("\r\n", "\n").replace("\r", "\n").split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(strIndent);
                if (!StringUtils.hasLength((String)lines[i])) continue;
                stringBuilder.append(lines[i]);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean contains(String strTemplateId) {
            try {
                return StringUtils.hasLength((String)AIWorkerAgentBase.this.getContext().getConfigContent(null, String.format("template/%1$s", strTemplateId), true));
            }
            catch (Throwable ex) {
                return false;
            }
        }
    };

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected IAIAgentContext getAIAgentContext() {
        return this.iAIWorkerAgentContext;
    }

    @Override
    public String getAgentType() {
        return "AIWORKER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object finish(IAIPipelineRunSession iAIPipelineRunSession, Object job, Map<String, Object> params) throws Throwable {
        IAIPipelineRunSession lastAIPipelineRunSession = this.getAIPipelineRunSession();
        try {
            this.setAIPipelineRunSession(iAIPipelineRunSession);
            Object object = this.onFinish(iAIPipelineRunSession, job, params);
            return object;
        }
        finally {
            this.setAIPipelineRunSession(lastAIPipelineRunSession);
        }
    }

    protected Object onFinish(IAIPipelineRunSession iAIPipelineRunSession, Object job, Map<String, Object> params) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected AIWorkerAgentScriptBase createAIWorkerAgentScript(String strObjectName, String strScriptCode) throws Throwable {
        return this.createAIWorkerAgentScript(strObjectName, strScriptCode, null);
    }

    protected AIWorkerAgentScriptBase createAIWorkerAgentScript(String strObjectName, String strScriptCode, Class<? extends AIWorkerAgentScriptBase> baseCls) throws Throwable {
        Script obj = null;
        try {
            Class<?> cls = Class.forName(strObjectName);
            obj = (Script)cls.newInstance();
        }
        catch (Exception cls) {
            // empty catch block
        }
        if (obj == null) {
            if (!StringUtils.hasLength((String)strScriptCode)) {
                throw new Exception(String.format("\u5efa\u7acb\u5de5\u4f5c\u8005\u4ee3\u7406\u811a\u672c\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", "\u672a\u4f20\u5165\u811a\u672c\u4ee3\u7801"));
            }
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            if (baseCls == null) {
                compilerConfiguration.setScriptBaseClass(AIWorkerAgentScriptBase.class.getName());
            } else {
                compilerConfiguration.setScriptBaseClass(baseCls.getName());
            }
            try (GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());){
                GroovyShell groovyShell = new GroovyShell((ClassLoader)classLoader, compilerConfiguration);
                obj = groovyShell.parse(strScriptCode);
            }
            catch (Exception ex) {
                throw new Exception(String.format("\u5efa\u7acb\u5de5\u4f5c\u8005\u4ee3\u7406\u811a\u672c\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if (!(obj instanceof AIWorkerAgentScriptBase)) {
            throw new Exception(String.format("\u5efa\u7acb\u5de5\u4f5c\u8005\u4ee3\u7406\u811a\u672c\u5bf9\u8c61[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", obj));
        }
        try {
            AIWorkerAgentScriptBase aiWorkerAgentScriptBase = (AIWorkerAgentScriptBase)obj;
            aiWorkerAgentScriptBase.setOwner(this);
            aiWorkerAgentScriptBase.run();
            return aiWorkerAgentScriptBase;
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u5de5\u4f5c\u8005\u4ee3\u7406\u811a\u672c\u5bf9\u8c61\u8fd0\u884c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected AIWorkerAgentScriptBase getAIWorkerAgentScript(String strTemplateId, String strObjectName, Object jobData) throws Throwable {
        AIWorkerAgentScriptBase aiWorkerAgentScriptBase = this.aiWorkerAgentScriptMap.get(strTemplateId);
        if (aiWorkerAgentScriptBase == null) {
            String strTemplateContent = this.getTemplateContent(strTemplateId, true);
            aiWorkerAgentScriptBase = this.createAIWorkerAgentScript(strObjectName, strTemplateContent);
            this.aiWorkerAgentScriptMap.put(strTemplateId, aiWorkerAgentScriptBase);
        }
        return aiWorkerAgentScriptBase;
    }

    public IAIPipelineRunSession getAIPipelineRunSession() {
        return AIPipelineRunSessionBase.getCurrent();
    }

    public void setAIPipelineRunSession(IAIPipelineRunSession iAIPipelineRunSession) {
        AIPipelineRunSessionBase.setCurrent(iAIPipelineRunSession);
    }
}

