/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.ai.agent;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.cloud.core.sysutil.ISysAIUtilRuntime;
import net.ibizsys.central.plugin.ai.addin.SysAIFactoryUtilRTAddinBase;
import net.ibizsys.central.plugin.ai.agent.IAIAgent;
import net.ibizsys.central.plugin.ai.agent.IAIAgentContext;
import net.ibizsys.central.plugin.ai.sysutil.ISysAIFactoryUtilRuntimeContext;
import net.ibizsys.runtime.IModelRuntimeContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class AIAgentBase
extends SysAIFactoryUtilRTAddinBase
implements IAIAgent {
    private static final Log log = LogFactory.getLog(AIAgentBase.class);
    public static final String TEMPLATE_PARAM_DATA = "data";
    public static final String TEMPLATE_PARAM_CTX = "ctx";
    private String strAgentMode = null;
    private String strConfigPath = null;
    private String strAIPlatformType = "BAICHUAN";
    private ISysAIUtilRuntime iSysAIUtilRuntime = null;
    private Map<String, String> configAliasMap = new HashMap<String, String>();
    private Map<String, String> configContentMap = new HashMap<String, String>();
    private static GStringTemplateEngine engine = new GStringTemplateEngine();
    private Map<String, Template> defaultTemplateCacheMap = new ConcurrentHashMap<String, Template>();

    @Override
    public void init(ISysAIFactoryUtilRuntimeContext ctx, Object addinData, String strAgentMode) throws Exception {
        this.strAgentMode = strAgentMode;
        super.init((IModelRuntimeContext)ctx, addinData);
    }

    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getConfigPath())) {
            this.setConfigPath(String.format("%1$s%2$s%3$s", this.getAgentType(), "/", this.getAgentMode()).toLowerCase());
        }
        super.onInit();
    }

    protected ISysAIUtilRuntime getSysAIUtilRuntime() {
        if (this.iSysAIUtilRuntime == null) {
            this.iSysAIUtilRuntime = (ISysAIUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysAIUtilRuntime.class, false);
        }
        return this.iSysAIUtilRuntime;
    }

    @Override
    public String getAgentMode() {
        return this.strAgentMode;
    }

    public String getConfigPath() {
        return this.strConfigPath;
    }

    protected void setConfigPath(String strConfigPath) {
        this.strConfigPath = strConfigPath;
    }

    public String getAIPlatformType() {
        return this.strAIPlatformType;
    }

    protected void setAIPlatformType(String strAIPlatformType) {
        this.strAIPlatformType = strAIPlatformType;
    }

    protected abstract IAIAgentContext getAIAgentContext();

    protected String getContent(Object data, String strTemplateId, Map<String, Object> params) throws Throwable {
        Template template = this.getTemplate(strTemplateId);
        HashMap<String, Object> engineParams = new HashMap<String, Object>();
        if (params != null) {
            engineParams.putAll(params);
        }
        engineParams.put(TEMPLATE_PARAM_DATA, data);
        engineParams.put(TEMPLATE_PARAM_CTX, this.getAIAgentContext());
        StringWriter sw = new StringWriter();
        template.make(engineParams).writeTo((Writer)sw);
        return sw.toString();
    }

    protected Template getTemplate(String strTemplateId) throws Throwable {
        if (this.isEnableTemplateCache()) {
            Template template = this.getTemplateCacheMap().get(strTemplateId);
            if (template == null) {
                String strTemplateContent = this.getTemplateContent(strTemplateId, false);
                StringReader reader = new StringReader(strTemplateContent);
                template = engine.createTemplate((Reader)reader);
                this.getTemplateCacheMap().put(strTemplateId, template);
            }
            return template;
        }
        String strTemplateContent = this.getTemplateContent(strTemplateId, false);
        StringReader reader = new StringReader(strTemplateContent);
        return engine.createTemplate((Reader)reader);
    }

    protected String getTemplateContent(String strTemplateId, boolean bTryMode) throws Throwable {
        String strContent = this.configContentMap.get(strTemplateId);
        if (strContent != null && strContent.length() == 0) {
            if (!bTryMode) {
                throw new Exception(String.format("\u6307\u5b9a\u914d\u7f6e[%1$s]\u4e0d\u5b58\u5728", strTemplateId));
            }
            return null;
        }
        String strFullConfigId = String.format("%1$s%2$s%3$s", this.getConfigPath(), File.separator, strTemplateId);
        strContent = this.getContext().getConfigContent(null, strFullConfigId, true);
        if (!StringUtils.hasLength((String)strContent)) {
            strContent = "";
        }
        this.configContentMap.put(strTemplateId, strContent);
        if (strContent != null && strContent.length() == 0) {
            if (!bTryMode) {
                throw new Exception(String.format("\u6307\u5b9a\u914d\u7f6e[%1$s]\u4e0d\u5b58\u5728", strFullConfigId));
            }
            return null;
        }
        return strContent;
    }

    protected Map<String, Template> getTemplateCacheMap() {
        return this.defaultTemplateCacheMap;
    }

    protected void registerConfigAlias(String strAlias, String strConfigId) {
        this.configAliasMap.put(strAlias, strConfigId);
    }

    protected boolean unregisterConfigAlias(String strAlias, String strConfigId) {
        return this.configAliasMap.remove(strAlias, strConfigId);
    }

    protected String getRealConfigId(String strConfigId) {
        String strRealConfigId = this.configAliasMap.get(strConfigId);
        if (StringUtils.hasLength((String)strRealConfigId)) {
            return strRealConfigId;
        }
        return strConfigId;
    }

    protected boolean isEnableTemplateCache() {
        return true;
    }
}

