/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSModelService;
import org.springframework.util.StringUtils;

public abstract class PSObjectImplBase
implements IPSModelObjectRuntime {
    public static final String ATTR_GETID = "id";
    public static final String ATTR_GETDYNAMODELFILEPATH = "dynaModelFilePath";
    private IPSModelObjectRuntime parentPSModelObject = null;
    private ObjectNode objectNode = null;
    private IPSModelService iPSModelService = null;
    private ObjectNode originObjectNode = null;

    @Override
    public void init(IPSModelService iPSModelService, IPSModelObjectRuntime parentModel, ObjectNode objectNode) {
        this.iPSModelService = iPSModelService;
        this.parentPSModelObject = parentModel;
        this.originObjectNode = objectNode;
        this.objectNode = iPSModelService.getRealObjectNode(objectNode);
        if (this.objectNode == null) {
            this.objectNode = this.originObjectNode;
        }
        this.onInit();
    }

    protected void onInit() {
    }

    @Override
    public String getId() {
        JsonNode value = this.getObjectNode().get(ATTR_GETID);
        if (value == null) {
            String strId = this.getDynaModelFilePath();
            if (StringUtils.hasLength((String)strId)) {
                return strId;
            }
            strId = this.getCodeName();
            if (StringUtils.hasLength((String)strId)) {
                return strId;
            }
            strId = this.getName();
            if (StringUtils.hasLength((String)strId)) {
                return strId;
            }
            return null;
        }
        return value.asText();
    }

    protected <T> T getPSModelObject(Class<T> cls, ObjectNode objNode, String strTag) {
        return this.getPSModelService().getPSModelObject(this, cls, objNode, strTag);
    }

    protected <T> T getPSModelObject(Class<T> cls, List<T> it, Object objTag, boolean bTryMode) {
        return this.getPSModelService().getPSModelObject(this, cls, it, objTag, bTryMode);
    }

    protected IPSModelService getPSModelService() {
        return this.iPSModelService;
    }

    @Override
    public <T> T getChildPSModelObject(Class<T> cls, ObjectNode objNode, String strTag) {
        return this.getChildPSModelObject(cls, objNode, strTag, false);
    }

    @Override
    public <T> T getParentPSModelObject(Class<T> cls) {
        return this.getParentPSModelObject(cls, false);
    }

    @Override
    public <T> T getChildPSModelObject(Class<T> cls, ObjectNode objNode, String strTag, boolean bTryMode) {
        return this.getPSModelService().getChildPSModelObject(this, cls, objNode, strTag, bTryMode);
    }

    @Override
    public <T> T getParentPSModelObject(Class<T> cls, boolean bTryMode) {
        return this.getPSModelService().getParentPSModelObject(this, cls, bTryMode);
    }

    @Override
    public <T> T getPSModelObject(Class<T> cls, boolean bTryMode) {
        return this.getPSModelService().getPSModelObject(this, cls, bTryMode);
    }

    @Override
    public IPSModelObjectRuntime getParentPSModelObject() {
        return this.parentPSModelObject;
    }

    @Override
    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    @Override
    public String getCodeName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getMemo() {
        return null;
    }

    @Override
    public String getLogicName() {
        return null;
    }

    public String getDeployId() {
        return null;
    }

    public int getExtendMode() {
        return 0;
    }

    @Override
    public String getDynaModelFilePath() {
        JsonNode value = this.getObjectNode().get(ATTR_GETDYNAMODELFILEPATH);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    public boolean isDynaInstModel() {
        return false;
    }

    public static String getString(ObjectNode jsonObject, String strPropertyName, String strDefault) {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return strDefault;
        }
        return valueNode.asText();
    }

    public static boolean getBoolean(ObjectNode jsonObject, String strPropertyName, boolean bDefault) {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return bDefault;
        }
        return valueNode.asBoolean();
    }

    public static int getInt(ObjectNode jsonObject, String strPropertyName, int nDefault) {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return nDefault;
        }
        return valueNode.asInt();
    }

    public static long getLong(ObjectNode jsonObject, String strPropertyName, long nDefault) {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return nDefault;
        }
        return valueNode.asLong();
    }

    public static double getDouble(ObjectNode jsonObject, String strPropertyName, double fDefault) {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return fDefault;
        }
        return valueNode.asDouble();
    }

    public static ArrayNode getArray(ObjectNode jsonObject, String strPropertyName) throws Exception {
        JsonNode valueNode = jsonObject.get(strPropertyName);
        if (valueNode == null) {
            return null;
        }
        if (!(valueNode instanceof ArrayNode)) {
            throw new Exception(String.format("\u65e0\u6cd5\u5c06\u503c[%1$s]\u8f6c\u6362\u4e3aJson\u6570\u7ec4", valueNode.getClass().getCanonicalName()));
        }
        return (ArrayNode)valueNode;
    }
}

