/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.model.wf.IPSWFLink;
import org.springframework.util.StringUtils;

public class PSModelUtils {
    public static String calcUniqueTag(String strTag) {
        if (!StringUtils.hasLength((String)strTag)) {
            return null;
        }
        return strTag.toLowerCase();
    }

    public static String calcUniqueTag(IPSSystemModule iPSSystemModule, String strTag) {
        if (!StringUtils.hasLength((String)strTag)) {
            return null;
        }
        if (iPSSystemModule == null) {
            return strTag.toLowerCase();
        }
        if (iPSSystemModule.getPSSysModelGroup() != null) {
            return String.format("%1$s.%2$s.%3$s", iPSSystemModule.getPSSysModelGroup().getCodeName(), iPSSystemModule.getCodeName(), strTag).toLowerCase();
        }
        return String.format("%1$s.%2$s", iPSSystemModule.getCodeName(), strTag).toLowerCase();
    }

    public static String calcUniqueTag(IPSSysModelGroup iPSSysModelGroup, String strTag) {
        if (!StringUtils.hasLength((String)strTag)) {
            return null;
        }
        if (iPSSysModelGroup == null) {
            return strTag.toLowerCase();
        }
        return String.format("%1$s.%2$s", iPSSysModelGroup.getCodeName(), strTag).toLowerCase();
    }

    public static String calcUniqueTag(IPSModelObject iPSModelObject) {
        return PSModelUtils.calcUniqueTag(iPSModelObject, false);
    }

    public static String calcUniqueTag(IPSModelObject iPSModelObject, boolean bSimple) {
        String strId = PSModelUtils.calcUniqueTag2(iPSModelObject, bSimple);
        if (!StringUtils.hasLength((String)strId)) {
            return null;
        }
        return strId.toLowerCase();
    }

    public static String calcUniqueTag2(IPSModelObject iPSModelObject) {
        return PSModelUtils.calcUniqueTag2(iPSModelObject, false);
    }

    public static String calcUniqueTag2(IPSModelObject iPSModelObject, boolean bSimple) {
        String strId = iPSModelObject.getId();
        if (!StringUtils.hasLength((String)strId)) {
            return null;
        }
        int nPos = strId.indexOf(".json");
        if (nPos != -1 && nPos == strId.length() - 5) {
            strId = strId.substring(0, strId.length() - 5);
            if (iPSModelObject instanceof IPSApplication) {
                strId = strId.substring(0, strId.length() - 9);
            }
        }
        if (!StringUtils.hasLength((String)strId)) {
            return null;
        }
        String[] ids = strId.split("[/]");
        if (ids.length > 1) {
            if (bSimple) {
                return ids[ids.length - 1].toLowerCase();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < ids.length; ++i) {
                if (i % 2 == 0) {
                    sb.append(".");
                    continue;
                }
                sb.append(ids[i]);
            }
            return sb.toString();
        }
        return strId;
    }

    public static String calcFullUniqueTag(IPSModelObject iPSModelObject) {
        return PSModelUtils.calcFullUniqueTag(iPSModelObject, false);
    }

    public static String calcFullUniqueTag(IPSModelObject iPSModelObject, boolean bAppendParentIf) {
        String strId = PSModelUtils.calcFullUniqueTag2(iPSModelObject, bAppendParentIf);
        if (StringUtils.hasLength((String)strId)) {
            return strId.toLowerCase();
        }
        return strId;
    }

    public static String calcFullUniqueTag2(IPSModelObject iPSModelObject) {
        return PSModelUtils.calcFullUniqueTag2(iPSModelObject, false);
    }

    public static String calcFullUniqueTag2(IPSModelObject iPSModelObject, boolean bAppendParentIf) {
        String strId = iPSModelObject.getId();
        if (!StringUtils.hasLength((String)strId)) {
            return null;
        }
        int nPos = strId.indexOf(".json");
        if (nPos != -1 && nPos == strId.length() - 5) {
            strId = strId.substring(0, strId.length() - 5);
            if (iPSModelObject instanceof IPSApplication) {
                strId = strId.substring(0, strId.length() - 9);
            }
        } else {
            IPSWFLink iPSWFLink;
            strId = strId.replace(" ", "_").replace(".", "_");
            if (iPSModelObject instanceof IPSWFLink && StringUtils.hasLength((String)(iPSWFLink = (IPSWFLink)iPSModelObject).getFromPSWFProcessMust().getId())) {
                strId = String.format("%1$s.%2$s", iPSWFLink.getFromPSWFProcessMust().getId().replace(" ", "_").replace(".", "_"), strId);
            }
            String strParentId = null;
            if (bAppendParentIf) {
                IPSModelObject lastPSModelObject = iPSModelObject;
                for (IPSModelObjectRuntime parentPSModelObject = iPSModelObject.getParentPSModelObject(); parentPSModelObject != null; parentPSModelObject = parentPSModelObject.getParentPSModelObject()) {
                    int nPos2;
                    String strId2 = parentPSModelObject.getId();
                    if (StringUtils.hasLength((String)strId2) && (nPos2 = strId2.indexOf(".json")) != -1) {
                        strParentId = PSModelUtils.calcUniqueTag2(parentPSModelObject);
                        break;
                    }
                    if (StringUtils.hasLength((String)parentPSModelObject.getId())) {
                        strId = String.format("%1$s.%2$s", parentPSModelObject.getId().replace(" ", "_").replace(".", "_"), strId);
                    }
                    lastPSModelObject = parentPSModelObject;
                }
            }
            if (!StringUtils.hasLength(strParentId)) {
                return strId;
            }
            return String.format("%1$s.%2$s", strParentId, strId);
        }
        if (!StringUtils.hasLength((String)strId)) {
            return null;
        }
        String[] ids = strId.split("[/]");
        if (ids.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < ids.length; ++i) {
                if (i % 2 == 0) {
                    sb.append(".");
                    continue;
                }
                sb.append(ids[i]);
            }
            return sb.toString();
        }
        return strId;
    }

    public static String getParentId(String strId) {
        String[] items = strId.split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length - 1; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String getSimpleId(String strId) {
        String[] items = strId.split("[.]");
        return items[items.length - 1];
    }
}

