/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSModelService;
import net.ibizsys.model.IPSModelServiceProxy;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.PSModelServiceException;
import net.ibizsys.model.PSObjectImplBase;
import net.ibizsys.model.PSSystemImpl;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.codelist.IPSAppCodeList;
import net.ibizsys.model.app.control.IPSAppCounterRef;
import net.ibizsys.model.app.dataentity.IPSAppDEUIAction;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.app.logic.IPSAppUILogic;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.app.view.IPSAppViewEngine;
import net.ibizsys.model.app.view.IPSAppViewLogic;
import net.ibizsys.model.app.view.IPSAppViewUIAction;
import net.ibizsys.model.app.wf.IPSAppWF;
import net.ibizsys.model.app.wf.IPSAppWFVer;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.IPSControlContainer;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDEFormDetail;
import net.ibizsys.model.control.form.IPSDEFormGroupBase;
import net.ibizsys.model.control.form.IPSDEFormTabPanel;
import net.ibizsys.model.control.panel.IPSPanelItem;
import net.ibizsys.model.control.panel.IPSPanelTabPage;
import net.ibizsys.model.control.panel.IPSPanelTabPanel;
import net.ibizsys.model.control.panel.IPSSysPanelContainer;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEActionLogic;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.priv.IPSDEOPPriv;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.security.IPSSysUniRes;
import net.ibizsys.model.view.IPSUIAction;
import net.ibizsys.model.wf.IPSWFLink;
import net.ibizsys.model.wf.IPSWFProcess;
import net.ibizsys.model.wf.IPSWFVersion;
import net.ibizsys.model.wf.IPSWorkflow;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class PSModelServiceImplBaseBase
implements IPSModelService {
    private static final Log log = LogFactory.getLog(PSModelServiceImplBaseBase.class);
    public static final int DYNAINSTMODE_DISABLE = 0;
    public static final int DYNAINSTMODE_ENABLE = 1;
    public static final int DYNAINSTMODE_ENABLEINST = 2;
    protected static ObjectMapper MAPPER = new ObjectMapper();
    protected Map<Class<?>, IPSModelService> psModelServiceMap = new ConcurrentHashMap();
    private String strPSModelFolderPath = null;
    private String strGroovyFolderPath = null;
    private Map<String, IPSModelObject> psModelObjectMap = new ConcurrentHashMap<String, IPSModelObject>();
    private IPSSystem iPSSystem = null;
    private boolean bHttpMode = false;

    public void setPSModelFolderPath(String strPSModelFolderPath) {
        String strHeader;
        this.strPSModelFolderPath = strPSModelFolderPath;
        this.bHttpMode = false;
        if (StringUtils.hasLength((String)strPSModelFolderPath) && ((strHeader = strPSModelFolderPath.toLowerCase()).indexOf("http://") == 0 || strHeader.indexOf("https://") == 0)) {
            this.bHttpMode = true;
        }
    }

    public String getPSModelFolderPath() {
        return this.strPSModelFolderPath;
    }

    public void setGroovyFolderPath(String strGroovyFolderPath) {
        this.strGroovyFolderPath = strGroovyFolderPath;
    }

    public String getGroovyFolderPath() {
        return this.strGroovyFolderPath;
    }

    public IPSSystem getPSSystem() {
        String strPath;
        IPSModelObject iPSModelObject;
        if (this.iPSSystem == null && (iPSModelObject = this.psModelObjectMap.get(strPath = "PSSYSTEM.json")) == null) {
            ObjectNode realNode;
            try {
                realNode = this.getObjectNode(strPath);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u52a0\u8f7d\u7cfb\u7edf\u6a21\u578b\u6587\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strPath, ex.getMessage()), (Throwable)ex);
                throw new PSModelServiceException((IPSModelService)this, String.format("\u52a0\u8f7d\u7cfb\u7edf\u6a21\u578b\u6587\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strPath, ex.getMessage()), ex);
            }
            IPSSystem t = this.createIPSSystem();
            this.psModelObjectMap.put(strPath, t);
            if (t instanceof IPSModelObjectRuntime) {
                ((IPSModelObjectRuntime)((Object)t)).init(this.getPSModelService(t.getClass(), t), null, realNode);
            }
            this.onInit(t, realNode);
            this.iPSSystem = t;
            return t;
        }
        return this.iPSSystem;
    }

    protected void onInit(IPSSystem t, ObjectNode realNode) {
    }

    protected IPSSystem createIPSSystem() {
        return new PSSystemImpl();
    }

    @Override
    public <T> T getPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode, String strTag) {
        boolean bModelRef = false;
        JsonNode jv = objNode.get("modelref");
        if (jv != null) {
            bModelRef = jv.asBoolean();
        }
        if (bModelRef) {
            IPSAppDataEntity iPSAppDataEntity;
            IPSControlContainer iPSControlContainer;
            jv = objNode.get("path");
            if (jv != null) {
                String strPath = jv.asText();
                return this.getPSModelObject(parentPSModelObject, cls, strPath);
            }
            if (parentPSModelObject == null) {
                throw new PSModelServiceException(this, "\u7236\u5bf9\u8c61\u65e0\u6548");
            }
            if (cls.equals(IPSDEOPPriv.class)) {
                IPSDEOPPriv iPSDEOPPriv;
                IPSAppDataEntity iPSAppDataEntity2;
                IPSDataEntity iPSDataEntity = this.getParentPSModelObject(parentPSModelObject, IPSDataEntity.class, true);
                if (iPSDataEntity == null && (iPSAppDataEntity2 = this.getParentPSModelObject(parentPSModelObject, IPSAppDataEntity.class, true)) != null && (iPSDataEntity = iPSAppDataEntity2.getPSDataEntity()) == null) {
                    return null;
                }
                if (iPSDataEntity != null && (iPSDEOPPriv = iPSDataEntity.getPSDEOPPriv(objNode, true)) != null) {
                    return (T)iPSDEOPPriv;
                }
                return (T)this.getPSSystem().getPSSysDEOPPriv(objNode, false);
            }
            if (IPSUIAction.class.isAssignableFrom(cls)) {
                JsonNode jsonNode = objNode.get("getPSAppDataEntity");
                if (jsonNode != null) {
                    IPSApplication iPSApplication = this.getParentPSModelObject(parentPSModelObject, IPSApplication.class, false);
                    IPSAppDataEntity iPSAppDataEntity3 = iPSApplication.getPSAppDataEntity(jsonNode, false);
                    return (T)iPSAppDataEntity3.getPSAppDEUIAction(objNode, false);
                }
                jsonNode = objNode.get("getPSAppWF");
                if (jsonNode != null) {
                    IPSApplication iPSApplication = this.getParentPSModelObject(parentPSModelObject, IPSApplication.class, false);
                    IPSAppWF iPSAppWF = iPSApplication.getPSAppWF(jsonNode, false);
                    jsonNode = objNode.get("getPSAppWFVer");
                    if (jsonNode != null) {
                        IPSAppWFVer iPSAppWFVer = iPSAppWF.getPSAppWFVer(jsonNode, false);
                        return (T)iPSAppWFVer.getPSAppWFUIAction(objNode, false);
                    }
                    return (T)iPSAppWF.getPSAppWFUIAction(objNode, false);
                }
                IPSApplication iPSApplication = this.getParentPSModelObject(parentPSModelObject, IPSApplication.class, false);
                IPSAppDEUIAction iPSAppDEUIAction = iPSApplication.getPSAppDEUIAction(objNode, true);
                if (iPSAppDEUIAction != null) {
                    return (T)iPSAppDEUIAction;
                }
                if ("getNextPSUIAction".equals(strTag) && objNode.get("id").asText("").indexOf("@") != -1) {
                    return null;
                }
                throw new PSModelServiceException((IPSModelService)this, String.format("\u5e94\u7528[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u754c\u9762\u884c\u4e3a[%2$s]", iPSApplication.getName(), objNode.get("id").textValue()), iPSApplication);
            }
            if (cls.equals(IPSAppUILogic.class)) {
                IPSApplication iPSApplication = this.getParentPSModelObject(parentPSModelObject, IPSApplication.class, false);
                return (T)iPSApplication.getPSAppUILogic(objNode, false);
            }
            if (cls.equals(IPSAppViewEngine.class)) {
                iPSControlContainer = null;
                iPSControlContainer = parentPSModelObject instanceof IPSControlContainer ? (IPSControlContainer)((Object)parentPSModelObject) : this.getParentPSModelObject(parentPSModelObject, IPSControlContainer.class, true);
                while (iPSControlContainer != null) {
                    IPSAppViewEngine iPSAppViewEngine = iPSControlContainer.getPSAppViewEngine(objNode, true);
                    if (iPSAppViewEngine != null) {
                        return (T)iPSAppViewEngine;
                    }
                    iPSControlContainer = this.getParentPSModelObject((IPSModelObjectRuntime)((Object)iPSControlContainer), IPSControlContainer.class, true);
                }
            }
            if (cls.equals(IPSAppViewLogic.class)) {
                iPSControlContainer = null;
                iPSControlContainer = parentPSModelObject instanceof IPSControlContainer ? (IPSControlContainer)((Object)parentPSModelObject) : this.getParentPSModelObject(parentPSModelObject, IPSControlContainer.class, true);
                while (iPSControlContainer != null) {
                    IPSAppViewLogic iPSAppViewLogic = iPSControlContainer.getPSAppViewLogic(objNode, true);
                    if (iPSAppViewLogic != null) {
                        return (T)iPSAppViewLogic;
                    }
                    iPSControlContainer = this.getParentPSModelObject((IPSModelObjectRuntime)((Object)iPSControlContainer), IPSControlContainer.class, true);
                }
            }
            if (cls.equals(IPSAppViewUIAction.class)) {
                iPSControlContainer = null;
                iPSControlContainer = parentPSModelObject instanceof IPSControlContainer ? (IPSControlContainer)((Object)parentPSModelObject) : this.getParentPSModelObject(parentPSModelObject, IPSControlContainer.class, true);
                while (iPSControlContainer != null) {
                    IPSAppViewUIAction iPSAppViewUIAction = iPSControlContainer.getPSAppViewUIAction(objNode, true);
                    if (iPSAppViewUIAction != null) {
                        return (T)iPSAppViewUIAction;
                    }
                    iPSControlContainer = this.getParentPSModelObject((IPSModelObjectRuntime)((Object)iPSControlContainer), IPSControlContainer.class, true);
                }
                if (parentPSModelObject instanceof IPSAppViewUIAction) {
                    return (T)parentPSModelObject;
                }
            }
            if (cls.equals(IPSAppCounterRef.class)) {
                iPSControlContainer = null;
                iPSControlContainer = parentPSModelObject instanceof IPSControlContainer ? (IPSControlContainer)((Object)parentPSModelObject) : this.getParentPSModelObject(parentPSModelObject, IPSControlContainer.class, true);
                while (iPSControlContainer != null) {
                    IPSAppCounterRef iPSAppCounterRef = iPSControlContainer.getPSAppCounterRef(objNode, true);
                    if (iPSAppCounterRef != null) {
                        return (T)iPSAppCounterRef;
                    }
                    iPSControlContainer = this.getParentPSModelObject((IPSModelObjectRuntime)((Object)iPSControlContainer), IPSControlContainer.class, true);
                }
            }
            if (cls.equals(IPSDEField.class)) {
                IPSDataEntity iPSDataEntity = this.getParentPSModelObject(parentPSModelObject, IPSDataEntity.class, false);
                return (T)iPSDataEntity.getPSDEField(objNode, false);
            }
            if (cls.equals(IPSDataEntity.class) && (iPSAppDataEntity = this.getParentPSModelObject(parentPSModelObject, IPSAppDataEntity.class, true)) != null) {
                return (T)iPSAppDataEntity.getPSDataEntityMust();
            }
            if (cls.equals(IPSSysUniRes.class)) {
                return (T)this.getPSSystem().getPSSysUniRes(objNode, false);
            }
            if (cls.equals(IPSWFLink.class) && parentPSModelObject instanceof IPSWFProcess) {
                IPSWFVersion iPSWFVersion = this.getParentPSModelObject(parentPSModelObject, IPSWFVersion.class, false);
                List<IPSWFLink> psWFLinks = iPSWFVersion.getPSWFLinks();
                if (psWFLinks != null) {
                    for (IPSWFLink iPSWFLink : psWFLinks) {
                        if (iPSWFLink.getFromPSWFProcessMust() != parentPSModelObject || !iPSWFLink.getId().equals(objNode.get("id").textValue())) continue;
                        return (T)iPSWFLink;
                    }
                }
                throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6d41\u7a0b\u7248\u672c\u8fde\u63a5[%1$s]", objNode.get("id")));
            }
            if (IPSDEFormDetail.class.isAssignableFrom(cls)) {
                String strTag2;
                IPSDEForm iPSDEForm = this.getParentPSModelObject(parentPSModelObject, IPSDEForm.class, false);
                IPSDEFormDetail dst = this.getPSDEFormDetail(iPSDEForm, strTag2 = this.getPSModelTag(cls, objNode));
                if (dst != null) {
                    return (T)dst;
                }
                throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u8868\u5355\u6210\u5458[%1$s]", strTag2));
            }
            IPSModelObjectRuntime iPSModelObjectRuntime = parentPSModelObject;
            return iPSModelObjectRuntime.getChildPSModelObject(cls, objNode, strTag, false);
        }
        jv = objNode.get("dynaModelFilePath");
        if (jv != null && cls.equals(IPSDEActionLogic.class)) {
            return null;
        }
        if (jv != null) {
            String strPath = jv.asText();
            IPSModelObject iPSModelObject = this.psModelObjectMap.get(strPath);
            if (iPSModelObject == null) {
                T t = this.createPSModelObject(parentPSModelObject, cls, objNode);
                if (!(t instanceof IPSControl)) {
                    this.psModelObjectMap.put(strPath, (IPSModelObject)t);
                }
                if (t instanceof IPSModelObjectRuntime) {
                    if (!(t instanceof IPSControl)) {
                        ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), null, objNode);
                    } else {
                        ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), parentPSModelObject, objNode);
                    }
                }
                return t;
            }
            return (T)iPSModelObject;
        }
        T t = this.createPSModelObject(parentPSModelObject, cls, objNode);
        if (t instanceof IPSModelObjectRuntime) {
            ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), parentPSModelObject, objNode);
        }
        return t;
    }

    protected IPSDEFormDetail getPSDEFormDetail(IPSDEForm iPSDEForm, String strTag) {
        if (iPSDEForm.getPSDEFormPages() != null) {
            for (IPSDEFormDetail iPSDEFormDetail : iPSDEForm.getPSDEFormPages()) {
                IPSDEFormDetail dst = this.getPSDEFormDetail(iPSDEFormDetail, strTag);
                if (dst == null) continue;
                return dst;
            }
        }
        return null;
    }

    protected IPSDEFormDetail getPSDEFormDetail(IPSDEFormDetail parentFormDetail, String strTag) {
        IPSDEFormTabPanel iPSDEFormTabPanel;
        IPSDEFormDetail dst;
        IPSDEFormGroupBase iPSDEFormGroupBase;
        if (strTag.equals(parentFormDetail.getId())) {
            return parentFormDetail;
        }
        if (parentFormDetail instanceof IPSDEFormGroupBase && (iPSDEFormGroupBase = (IPSDEFormGroupBase)parentFormDetail).getPSDEFormDetails() != null) {
            for (IPSDEFormDetail iPSDEFormDetail : iPSDEFormGroupBase.getPSDEFormDetails()) {
                dst = this.getPSDEFormDetail(iPSDEFormDetail, strTag);
                if (dst == null) continue;
                return dst;
            }
        }
        if (parentFormDetail instanceof IPSDEFormTabPanel && (iPSDEFormTabPanel = (IPSDEFormTabPanel)parentFormDetail).getPSDEFormTabPages() != null) {
            for (IPSDEFormDetail iPSDEFormDetail : iPSDEFormTabPanel.getPSDEFormTabPages()) {
                dst = this.getPSDEFormDetail(iPSDEFormDetail, strTag);
                if (dst == null) continue;
                return dst;
            }
        }
        return null;
    }

    protected IPSPanelItem getPSPanelItem(IPSPanelItem parentPanelItem, String strTag) {
        IPSPanelTabPanel iPSPanelTabPanel;
        IPSPanelItem dst;
        IPSSysPanelContainer iPSSysPanelContainer;
        if (strTag.equals(parentPanelItem.getId())) {
            return parentPanelItem;
        }
        if (parentPanelItem instanceof IPSSysPanelContainer && (iPSSysPanelContainer = (IPSSysPanelContainer)parentPanelItem).getPSPanelItems() != null) {
            for (IPSPanelItem iPSPanelItem : iPSSysPanelContainer.getPSPanelItems()) {
                dst = this.getPSPanelItem(iPSPanelItem, strTag);
                if (dst == null) continue;
                return dst;
            }
        }
        if (parentPanelItem instanceof IPSPanelTabPanel && (iPSPanelTabPanel = (IPSPanelTabPanel)parentPanelItem).getPSPanelTabPages() != null) {
            for (IPSPanelTabPage iPSPanelTabPage : iPSPanelTabPanel.getPSPanelTabPages()) {
                dst = this.getPSPanelItem(iPSPanelTabPage, strTag);
                if (dst == null) continue;
                return dst;
            }
        }
        return null;
    }

    public <T> T createPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        return this.onCreatePSModelObject(parentPSModelObject, cls, objNode);
    }

    protected <T> T onCreatePSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        return null;
    }

    @Override
    public <T> T getPSModelObject(IPSModelObjectRuntime relatedPSModelObject, Class<T> cls, List<T> list, Object objKey, boolean bTryMode) {
        if (list == null || objKey == null) {
            if (!bTryMode) {
                if (objKey != null) {
                    String strTag = this.getPSModelTag(cls, objKey);
                    throw new PSModelServiceException((IPSModelService)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b[%1$s]\uff0c\u6807\u8bc6\u4e3a[%2$s]", cls.getSimpleName(), strTag), relatedPSModelObject);
                }
                throw new PSModelServiceException((IPSModelService)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b[%1$s]\uff0c\u6ca1\u6709\u6307\u5b9a\u6807\u8bc6", cls.getSimpleName()), relatedPSModelObject);
            }
            return null;
        }
        String strTag = this.getPSModelTag(cls, objKey);
        for (T t : list) {
            if (!this.testPSModel(cls, t, strTag, objKey)) continue;
            return t;
        }
        if (!bTryMode) {
            throw new PSModelServiceException((IPSModelService)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b[%1$s]\uff0c\u6807\u8bc6\u4e3a[%2$s]", cls.getSimpleName(), strTag), relatedPSModelObject);
        }
        return null;
    }

    protected <T> boolean testPSModel(Class<T> cls, T t, String strTag, Object objKey) {
        boolean bUniqueKey;
        IPSModelObjectRuntime iPSModelObjectRuntime = (IPSModelObjectRuntime)t;
        String strModelTag = iPSModelObjectRuntime.getDynaModelFilePath();
        if (t instanceof IPSControl && strTag.equals(((IPSControl)t).getName())) {
            return true;
        }
        boolean bl = bUniqueKey = strTag.length() == 32;
        if (StringUtils.hasLength((String)strModelTag)) {
            if (strModelTag.equals(strTag)) {
                return true;
            }
            if (bUniqueKey) {
                return PSModelServiceImplBaseBase.genMD5Ex(strModelTag).equals(strTag);
            }
            return false;
        }
        strModelTag = iPSModelObjectRuntime.getId();
        if (StringUtils.hasLength((String)strModelTag)) {
            if (strModelTag.equals(strTag)) {
                return true;
            }
            if (bUniqueKey) {
                return PSModelServiceImplBaseBase.genMD5Ex(strModelTag).equals(strTag);
            }
            return false;
        }
        strModelTag = iPSModelObjectRuntime.getCodeName();
        if (StringUtils.hasLength((String)strModelTag)) {
            return strModelTag.equals(strTag);
        }
        strModelTag = iPSModelObjectRuntime.getName();
        if (StringUtils.hasLength((String)strModelTag)) {
            return strModelTag.equals(strTag);
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b[%1$s][%2$s]\u6807\u8bc6", cls.getSimpleName(), t));
    }

    protected <T> String getPSModelTag(Class<T> cls, Object objKey) {
        if (objKey instanceof String) {
            return (String)objKey;
        }
        if (objKey instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)objKey;
            if (PSObjectImplBase.getBoolean(objectNode, "modelref", false)) {
                String strTag = PSObjectImplBase.getString(objectNode, "path", null);
                if (!StringUtils.hasLength((String)strTag) && !StringUtils.hasLength((String)(strTag = PSObjectImplBase.getString(objectNode, "id", null)))) {
                    throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b[%1$s]\u6807\u8bc6", cls.getSimpleName()));
                }
                return strTag;
            }
            String strTag = PSObjectImplBase.getString(objectNode, "dynaModelFilePath", null);
            if (StringUtils.hasLength((String)strTag)) {
                return strTag;
            }
            strTag = PSObjectImplBase.getString(objectNode, "codeName", null);
            if (StringUtils.hasLength((String)strTag)) {
                return strTag;
            }
            strTag = PSObjectImplBase.getString(objectNode, "name", null);
            if (StringUtils.hasLength((String)strTag)) {
                return strTag;
            }
            throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b[%1$s]\u6807\u8bc6", cls.getSimpleName()));
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b[%1$s]\u6807\u8bc6", cls.getSimpleName()));
    }

    protected IPSModelService getPSModelService(Class<?> cls, Object objPSModel) {
        IPSModelService iPSModelService = this.psModelServiceMap.get(cls);
        if (iPSModelService == null) {
            IPSModelServiceProxy iPSModelServiceProxy = this.createPSModelServiceProxy(cls, objPSModel);
            if (iPSModelServiceProxy != null) {
                iPSModelServiceProxy.init(this, null);
                this.psModelServiceMap.put(cls, iPSModelServiceProxy);
                return iPSModelServiceProxy;
            }
            this.psModelServiceMap.put(cls, this);
            return this;
        }
        return iPSModelService;
    }

    protected IPSModelServiceProxy createPSModelServiceProxy(Class<?> cls, Object objPSModel) {
        return null;
    }

    @Override
    public ObjectNode getRealObjectNode(ObjectNode objectNode) {
        return objectNode;
    }

    @Override
    public <T> T getChildPSModelObject(IPSModelObjectRuntime relatedPSModelObject, Class<T> cls, ObjectNode objNode, String strTag, boolean bTryMode) {
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException((IPSModelService)this, String.format("\u65e0\u6cd5\u4ece\u6a21\u578b[%1$s]\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b[%2$s]\u5b50\u6a21\u578b\uff0c\u6807\u8bc6\u4e3a[%3$s]", relatedPSModelObject, cls, objNode), relatedPSModelObject);
    }

    @Override
    public <T> T getPSModelObject(IPSModelObjectRuntime relatedPSModelObject, Class<T> cls, boolean bTryMode) {
        if (cls.isAssignableFrom(relatedPSModelObject.getClass())) {
            return (T)relatedPSModelObject;
        }
        return this.getParentPSModelObject(relatedPSModelObject, cls, bTryMode);
    }

    @Override
    public <T> T getParentPSModelObject(IPSModelObjectRuntime relatedPSModelObject, Class<T> cls, boolean bTryMode) {
        if (cls.equals(IPSSystem.class)) {
            return (T)this.getPSSystem();
        }
        Object t = this.getParentPSModelObject(relatedPSModelObject, cls);
        if (t == null) {
            if (IPSApplication.class.equals(cls)) {
                int nPos2;
                int nPos;
                if (relatedPSModelObject instanceof IPSApplication) {
                    return (T)relatedPSModelObject;
                }
                String strFilePath = this.getFirstPSModelFilePath(relatedPSModelObject);
                if (StringUtils.hasLength((String)strFilePath) && (nPos = strFilePath.indexOf("PSSYSAPPS/")) != -1 && (nPos2 = strFilePath.indexOf("/", nPos + "PSSYSAPPS/".length())) != -1) {
                    strFilePath = strFilePath.substring(0, nPos2) + "/PSSYSAPP.json";
                    t = this.getCachePSModelObject(strFilePath);
                }
            } else if (IPSDataEntity.class.equals(cls)) {
                int nPos2;
                int nPos;
                if (relatedPSModelObject instanceof IPSDataEntity) {
                    return (T)relatedPSModelObject;
                }
                IPSAppDataEntity iPSAppDataEntity = this.getParentPSModelObject(relatedPSModelObject, IPSAppDataEntity.class, true);
                if (iPSAppDataEntity != null) {
                    return (T)iPSAppDataEntity.getPSDataEntity();
                }
                String strFilePath = this.getFirstPSModelFilePath(relatedPSModelObject);
                if (StringUtils.hasLength((String)strFilePath) && (nPos = strFilePath.indexOf("PSDATAENTITIES/")) != -1 && (nPos2 = strFilePath.indexOf("/", nPos + "PSDATAENTITIES/".length())) != -1) {
                    strFilePath = strFilePath.substring(0, nPos2) + ".json";
                    t = this.getCachePSModelObject(strFilePath);
                }
            } else if (IPSWorkflow.class.equals(cls)) {
                int nPos2;
                int nPos;
                if (relatedPSModelObject instanceof IPSWorkflow) {
                    return (T)relatedPSModelObject;
                }
                String strFilePath = this.getFirstPSModelFilePath(relatedPSModelObject);
                if (StringUtils.hasLength((String)strFilePath) && (nPos = strFilePath.indexOf("PSWORKFLOWS/")) != -1 && (nPos2 = strFilePath.indexOf("/", nPos + "PSWORKFLOWS/".length())) != -1) {
                    strFilePath = strFilePath.substring(0, nPos2) + ".json";
                    t = this.getCachePSModelObject(strFilePath);
                }
            } else if (IPSAppDataEntity.class.equals(cls)) {
                if (relatedPSModelObject instanceof IPSAppDataEntity) {
                    return (T)relatedPSModelObject;
                }
                if (relatedPSModelObject instanceof IPSControl) {
                    return (T)((IPSControl)((Object)relatedPSModelObject)).getPSAppDataEntity();
                }
                if (relatedPSModelObject instanceof IPSAppView) {
                    return (T)((IPSAppView)((Object)relatedPSModelObject)).getPSAppDataEntity();
                }
                IPSControl iPSControl = this.getParentPSModelObject(relatedPSModelObject, IPSControl.class, true);
                if (iPSControl != null) {
                    return (T)iPSControl.getPSAppDataEntity();
                }
                IPSAppView iPSAppView = this.getParentPSModelObject(relatedPSModelObject, IPSAppView.class, true);
                if (iPSAppView != null) {
                    return (T)iPSAppView.getPSAppDataEntity();
                }
            } else if (IPSDEServiceAPI.class.equals(cls)) {
                IPSDEServiceAPIRS iPSDEServiceAPIRS = this.getParentPSModelObject(relatedPSModelObject, IPSDEServiceAPIRS.class, true);
                if (iPSDEServiceAPIRS != null) {
                    return (T)iPSDEServiceAPIRS.getMinorPSDEServiceAPI();
                }
                if (relatedPSModelObject instanceof IPSDEServiceAPIMethod && relatedPSModelObject.getParentPSModelObject() instanceof IPSDEServiceAPIRS) {
                    t = ((IPSDEServiceAPIRS)((Object)relatedPSModelObject.getParentPSModelObject())).getMinorPSDEServiceAPI();
                }
            }
        }
        if (t != null || bTryMode) {
            return t;
        }
        throw new PSModelServiceException((IPSModelService)this, String.format("\u65e0\u6cd5\u4ece\u6a21\u578b[%1$s]\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b[%2$s]\u7236\u6a21\u578b", relatedPSModelObject, cls), relatedPSModelObject);
    }

    public <T> T getParentPSModelObject(IPSModelObjectRuntime relatedPSModelObject, Class<T> cls) {
        if (relatedPSModelObject.getParentPSModelObject() != null) {
            if (cls.isAssignableFrom(relatedPSModelObject.getParentPSModelObject().getClass())) {
                return (T)relatedPSModelObject.getParentPSModelObject();
            }
            return this.getParentPSModelObject(relatedPSModelObject.getParentPSModelObject(), cls);
        }
        return null;
    }

    public String getFirstPSModelFilePath(IPSModelObjectRuntime relatedPSModelObject) {
        String strFilePath = relatedPSModelObject.getDynaModelFilePath();
        if (StringUtils.hasLength((String)strFilePath)) {
            return strFilePath;
        }
        if (relatedPSModelObject.getParentPSModelObject() != null) {
            return this.getFirstPSModelFilePath(relatedPSModelObject.getParentPSModelObject());
        }
        return null;
    }

    protected ObjectNode getObjectNode(String strPath) throws Exception {
        if (this.isModelFromHttp()) {
            String strFullModelPath = this.getPSModelFolderPath() + "/" + strPath.replace("\\", "/");
            long nTime = System.currentTimeMillis();
            URL remoteUrl = new URL(strFullModelPath);
            ObjectNode objNode = (ObjectNode)MAPPER.readTree(remoteUrl.openStream());
            log.debug((Object)String.format("\u83b7\u53d6\u8fdc\u7a0b\u8d44\u6e90[%1$s]\u8017\u65f6[%2$s]", strFullModelPath, System.currentTimeMillis() - nTime));
            return objNode;
        }
        String strFullModelPath = this.getPSModelFolderPath() + File.separator + strPath;
        return (ObjectNode)MAPPER.readTree(new File(strFullModelPath));
    }

    public String getRawContent(String strPath, boolean bTryMode) throws Exception {
        if (this.isModelFromHttp()) {
            throw new Exception("\u4e0d\u652f\u6301\u4ece\u8fdc\u7a0b\u8def\u5f84\u76f4\u63a5\u83b7\u53d6\u5185\u5bb9");
        }
        String strFullModelPath = this.getPSModelFolderPath() + File.separator + strPath;
        File file = new File(strFullModelPath);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u6307\u5b9a\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728", strFullModelPath));
    }

    protected boolean containsObjectNode(String strPath) {
        if (this.isModelFromHttp()) {
            String strFullModelPath = this.getPSModelFolderPath() + "/" + strPath.replace("\\", "/");
            try {
                long nTime = System.currentTimeMillis();
                URL remoteUrl = new URL(strFullModelPath);
                HttpURLConnection urlcon = (HttpURLConnection)remoteUrl.openConnection();
                String message = urlcon.getHeaderField(0);
                log.debug((Object)String.format("\u5224\u65ad\u8fdc\u7a0b\u8d44\u6e90\u662f\u5426\u5b58\u5728[%1$s]\u8017\u65f6[%2$s]", strFullModelPath, System.currentTimeMillis() - nTime));
                return StringUtils.hasText((String)message) && message.startsWith("HTTP/1.1 200");
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5224\u65ad\u8d44\u6e90\u6587\u4ef6[%1$s]\u662f\u5426\u5b58\u5728\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strFullModelPath, ex.getMessage()), (Throwable)ex);
                return false;
            }
        }
        String strFullModelPath = this.getPSModelFolderPath() + File.separator + strPath;
        return new File(strFullModelPath).exists();
    }

    protected <T> T getPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, String strModelPath) {
        IPSModelObject iPSModelObject = this.psModelObjectMap.get(strModelPath);
        if (iPSModelObject == null) {
            ObjectNode realNode = null;
            try {
                realNode = this.getObjectNode(strModelPath);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u52a0\u8f7d\u6a21\u578b\u6587\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strModelPath, ex.getMessage()), (Throwable)ex);
                throw new PSModelServiceException((IPSModelService)this, String.format("\u52a0\u8f7d\u8d44\u6e90\u6587\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strModelPath, ex.getMessage()), ex);
            }
            if (cls.getSimpleName().equals("IPSCodeList") && strModelPath.indexOf("PSSYSAPPS/") == 0) {
                IPSAppCodeList t = this.createPSModelObject(parentPSModelObject, IPSAppCodeList.class, realNode);
                this.psModelObjectMap.put(strModelPath, t);
                if (t instanceof IPSModelObjectRuntime) {
                    ((IPSModelObjectRuntime)((Object)t)).init(this.getPSModelService(t.getClass(), t), parentPSModelObject, realNode);
                }
                return (T)t;
            }
            T t = this.createPSModelObject(parentPSModelObject, cls, realNode);
            if (!(t instanceof IPSControl)) {
                this.psModelObjectMap.put(strModelPath, (IPSModelObject)t);
            }
            if (t instanceof IPSModelObjectRuntime) {
                if (!(t instanceof IPSControl)) {
                    ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), null, realNode);
                } else {
                    ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), parentPSModelObject, realNode);
                }
            }
            return t;
        }
        return (T)iPSModelObject;
    }

    protected IPSModelObject getCachePSModelObject(String strModelPath) {
        return this.psModelObjectMap.get(strModelPath);
    }

    protected void setCachePSModelObject(String strModelPath, IPSModelObject iPSModelObject) {
        this.psModelObjectMap.put(strModelPath, iPSModelObject);
    }

    protected boolean isModelFromHttp() {
        return this.bHttpMode;
    }

    public static final String genMD5Ex(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = new byte[32];
            md.update(text.getBytes("utf-8"));
            md5hash = md.digest();
            return PSModelServiceImplBaseBase.convertToHex(md5hash);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static final String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

