/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSDynaInstService;
import net.ibizsys.model.IPSDynaInstServiceGlobal;
import net.ibizsys.model.IPSDynaInstServiceRuntime;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import org.springframework.util.StringUtils;

public class PSDynaInstServiceGlobal
implements IPSDynaInstServiceGlobal {
    private static IPSDynaInstServiceGlobal instance = new PSDynaInstServiceGlobal();
    private Map<String, String> dynaInstCfgPathMap = new HashMap<String, String>();
    private Map<String, IPSDynaInstService> psDynaInstServicehMap = new HashMap<String, IPSDynaInstService>();
    private IPSSystemService iPSSystemService = null;

    public static IPSDynaInstServiceGlobal getInstance() {
        return instance;
    }

    public static void setInstance(IPSDynaInstServiceGlobal iPSDynaInstServiceGlobal) {
        instance = iPSDynaInstServiceGlobal;
    }

    protected IPSDynaInstService createPSDynaInstService() {
        return new PSModelServiceImpl();
    }

    public void registerPSDynaInst(String strDynaInstId, String strCfgPath) {
        this.dynaInstCfgPathMap.put(strDynaInstId, strCfgPath);
    }

    public String getPSDynaInstPath(String strDynaInstId) {
        return this.dynaInstCfgPathMap.get(strDynaInstId);
    }

    @Override
    public IPSDynaInstService getCachePSDynaInstService(String strPSDynaInstId) {
        return this.psDynaInstServicehMap.get(strPSDynaInstId);
    }

    @Override
    public IPSDynaInstService getPSDynaInstService(String strPSDynaInstId, boolean bReload) throws Exception {
        IPSDynaInstService iPSDynaInstService = null;
        if (!bReload && (iPSDynaInstService = this.psDynaInstServicehMap.get(strPSDynaInstId)) != null) {
            return iPSDynaInstService;
        }
        String strCfgPath = this.dynaInstCfgPathMap.get(strPSDynaInstId);
        if (!StringUtils.hasLength((String)strCfgPath)) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u52a8\u6001\u5b9e\u4f8b[%1$s]\u914d\u7f6e\u8def\u5f84", strPSDynaInstId));
        }
        iPSDynaInstService = this.createPSDynaInstService();
        if (iPSDynaInstService instanceof IPSDynaInstServiceRuntime) {
            IPSDynaInstServiceRuntime iPSModelServiceRuntime = (IPSDynaInstServiceRuntime)((Object)iPSDynaInstService);
            iPSModelServiceRuntime.setPSDynaInstId(strPSDynaInstId);
            iPSModelServiceRuntime.setPSSystemService(this.getPSSystemService());
            iPSModelServiceRuntime.setPSModelFolderPath(strCfgPath);
        }
        iPSDynaInstService.getPSSystem();
        this.psDynaInstServicehMap.put(strPSDynaInstId, iPSDynaInstService);
        return iPSDynaInstService;
    }

    @Override
    public void resetPSDynaInstService(String strPSDynaInstId) {
        this.psDynaInstServicehMap.remove(strPSDynaInstId);
    }

    @Override
    public IPSSystemService getPSSystemService() {
        return this.iPSSystemService;
    }

    public void setPSSystemService(IPSSystemService iPSSystemService) {
        this.iPSSystemService = iPSSystemService;
    }
}

