package net.ibizsys.model.msg;



/**
 * 系统消息模板模型对象接口，标准模型{@link net.ibizsys.centralstudio.dto.PSSysMsgTemplDTO}运行时对象
 *
 */
public interface IPSSysMsgTempl extends net.ibizsys.model.IPSModelObject{

	
	
	/**
	 * 获取代码标识
	 * @return
	 */
	java.lang.String getCodeName();
	
	
	/**
	 * 获取内容
	 * @return
	 */
	java.lang.String getContent();
	
	
	/**
	 * 获取内容多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getContentPSLanguageRes();


	/**
	 * 获取内容多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getContentPSLanguageResMust();
	
	
	/**
	 * 获取内容类型
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.MsgContentType}
	 * @return
	 */
	java.lang.String getContentType();
	
	
	/**
	 * 获取钉钉内容
	 * @return
	 */
	java.lang.String getDDContent();
	
	
	/**
	 * 获取钉钉内容多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getDDPSLanguageRes();


	/**
	 * 获取钉钉内容多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getDDPSLanguageResMust();
	
	
	/**
	 * 获取即时消息内容
	 * @return
	 */
	java.lang.String getIMContent();
	
	
	/**
	 * 获取即时消息多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getIMPSLanguageRes();


	/**
	 * 获取即时消息多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getIMPSLanguageResMust();
	
	
	/**
	 * 获取移动端任务操作路径
	 * @return
	 */
	java.lang.String getMobTaskUrl();
	
	
	/**
	 * 获取动态参数
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSSysMsgTemplDTO#FIELD_MSGTEMPLPARAMS}
	 * @return
	 */
	com.fasterxml.jackson.databind.node.ObjectNode getMsgTemplParams();
	
	
	/**
	 * 获取消息模板标记
	 * @return
	 */
	java.lang.String getMsgTemplTag();
	
	
	/**
	 * 获取消息模板标记2
	 * @return
	 */
	java.lang.String getMsgTemplTag2();
	
	
	/**
	 * 获取消息模板类型
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.MsgTemplType}
	 * @return
	 */
	java.lang.String getMsgTemplType();
	
	
	/**
	 * 获取后台扩展插件
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSSysMsgTemplDTO#FIELD_PSSYSSFPLUGINID}
	 * @return
	 */
	net.ibizsys.model.res.IPSSysSFPlugin getPSSysSFPlugin();


	/**
	 * 获取后台扩展插件，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSSysSFPlugin getPSSysSFPluginMust();
	
	
	/**
	 * 获取系统模块
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSSysMsgTemplDTO#FIELD_PSMODULEID}
	 * @return
	 */
	net.ibizsys.model.system.IPSSystemModule getPSSystemModule();


	/**
	 * 获取系统模块，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.system.IPSSystemModule getPSSystemModuleMust();
	
	
	/**
	 * 获取短消息内容
	 * @return
	 */
	java.lang.String getSMSContent();
	
	
	/**
	 * 获取短消息多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getSMSPSLanguageRes();


	/**
	 * 获取短消息多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getSMSPSLanguageResMust();
	
	
	/**
	 * 获取脚本代码
	 * @return
	 */
	java.lang.String getScriptCode();
	
	
	/**
	 * 获取脚本模式
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.ScriptMode}
	 * @return
	 */
	int getScriptMode();
	
	
	/**
	 * 获取标题多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getSubPSLanguageRes();


	/**
	 * 获取标题多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getSubPSLanguageResMust();
	
	
	/**
	 * 获取标题
	 * @return
	 */
	java.lang.String getSubject();
	
	
	/**
	 * 获取任务操作路径
	 * @return
	 */
	java.lang.String getTaskUrl();
	
	
	/**
	 * 获取消息模板引擎
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.MsgTemplEngine}
	 * @return
	 */
	java.lang.String getTemplEngine();
	
	
	/**
	 * 获取微信内容
	 * @return
	 */
	java.lang.String getWXContent();
	
	
	/**
	 * 获取微信内容多语言资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getWXPSLanguageRes();


	/**
	 * 获取微信内容多语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getWXPSLanguageResMust();
	
	
	/**
	 * 获取是否邮件群组发送
	 * @return
	 */
	boolean isMailGroupSend();
}