package net.ibizsys.model.control.form;



/**
 * 表单按钮成员模型对象接口
 * <P>
 * 扩展父接口类型[BUTTON]
 *
 */
public interface IPSDEFormButton extends net.ibizsys.model.control.form.IPSDEFormDetail
		,net.ibizsys.model.app.view.IPSUIActionItem
		,net.ibizsys.model.control.IPSNavigateParamContainer{

	
	
	/**
	 * 获取按钮行为类型
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_BTNACTIONTYPE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.FormButtonActionType}
	 * @return
	 */
	java.lang.String getActionType();
	
	
	/**
	 * 获取动态标题绑定值项
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_VALUEITEMNAME}
	 * @return
	 */
	java.lang.String getCaptionItemName();
	
	
	/**
	 * 获取界面行为（运行时内联）
	 * @return
	 */
	net.ibizsys.model.view.IPSUIAction getInlinePSUIAction();


	/**
	 * 获取界面行为（运行时内联），不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.view.IPSUIAction getInlinePSUIActionMust();
	
	
	/**
	 * 获取调用表单项更新
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_PSDEFIUPDATEID}
	 * @return
	 */
	net.ibizsys.model.control.form.IPSDEFormItemUpdate getPSDEFormItemUpdate();


	/**
	 * 获取调用表单项更新，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.control.form.IPSDEFormItemUpdate getPSDEFormItemUpdateMust();
	
	
	/**
	 * 获取调用界面行为
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_PSDEUIACTIONID}
	 * @return
	 */
	net.ibizsys.model.view.IPSUIAction getPSUIAction();


	/**
	 * 获取调用界面行为，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.view.IPSUIAction getPSUIActionMust();
	
	
	/**
	 * 获取参数选择视图
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_PICKUPPSDEVIEWID}
	 * @return
	 */
	net.ibizsys.model.app.view.IPSAppView getParamPickupPSAppView();


	/**
	 * 获取参数选择视图，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.app.view.IPSAppView getParamPickupPSAppViewMust();
	
	
	/**
	 * 获取参数选择视图参数
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEFormDetailDTO#FIELD_EDITORPARAMS}
	 * @return
	 */
	com.fasterxml.jackson.databind.node.ObjectNode getParamViewParamJO();
	
	
	/**
	 * 获取操作提示信息
	 * @return
	 */
	java.lang.String getTooltip();
	
	
	/**
	 * 获取界面行为操作目标
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.UIActionTarget}
	 * @return
	 */
	java.lang.String getUIActionTarget();
}