package net.ibizsys.model.dataentity.dr;



/**
 * 实体关系数据组成员模型对象接口，标准模型{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO}运行时对象
 *
 */
public interface IPSDEDRDetail extends net.ibizsys.model.IPSModelObject{

	
	
	/**
	 * 获取标题语言资源
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_CAPPSLANRESID}
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getCapPSLanguageRes();


	/**
	 * 获取标题语言资源，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getCapPSLanguageResMust();
	
	
	/**
	 * 获取标题
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_CAPTION}
	 * @return
	 */
	java.lang.String getCaption();
	
	
	/**
	 * 获取计数项标识
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_COUNTERID}
	 * @return
	 */
	java.lang.String getCounterId();
	
	
	/**
	 * 获取计数器模式
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_COUNTERMODE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.TreeNodeCounterMode}
	 * @return
	 */
	int getCounterMode();
	
	
	/**
	 * 获取成员类型
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_DETAILTYPE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DEDRDetailType}
	 * @return
	 */
	java.lang.String getDetailType();
	
	
	/**
	 * 获取启用模式
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_ENABLEMODE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DEDRDetailEnableMode}
	 * @return
	 */
	java.lang.String getEnableMode();
	
	
	/**
	 * 获取排序值
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_ORDERVALUE}
	 * @return
	 */
	int getOrderValue();
	
	
	/**
	 * 获取原始标题
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_CAPTION}
	 * @return
	 */
	java.lang.String getOriginCaption();
	
	
	/**
	 * 获取关系界面项
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_PSDEDRITEMID}
	 * @return
	 */
	net.ibizsys.model.dataentity.dr.IPSDEDRItem getPSDEDRItem();


	/**
	 * 获取关系界面项，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.dr.IPSDEDRItem getPSDEDRItemMust();
	
	
	/**
	 * 获取成员图标资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSSysImage getPSSysImage();


	/**
	 * 获取成员图标资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSSysImage getPSSysImageMust();
	
	
	/**
	 * 获取启用判断处理逻辑
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_TESTPSDELOGICID}
	 * @return
	 */
	net.ibizsys.model.dataentity.logic.IPSDELogic getTestPSDELogic();


	/**
	 * 获取启用判断处理逻辑，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.logic.IPSDELogic getTestPSDELogicMust();
	
	
	/**
	 * 获取判断输出实体操作标识
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_PSDEOPPRIVID}
	 * @return
	 */
	net.ibizsys.model.dataentity.priv.IPSDEOPPriv getTestPSDEOPPriv();


	/**
	 * 获取判断输出实体操作标识，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.priv.IPSDEOPPriv getTestPSDEOPPrivMust();
	
	
	/**
	 * 获取启用判断脚本
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDEDRDetailDTO#FIELD_TESTCUSTOMCODE}
	 * @return
	 */
	java.lang.String getTestScriptCode();
}