package net.ibizsys.model.app.view;



/**
 * 应用视图消息模型对象接口，标准模型{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO}运行时对象
 * <P>
 * 子接口扩展识别值 {@link #getDynamicMode}
 *
 */
public interface IPSAppViewMsg extends net.ibizsys.model.view.IPSViewMsg
		,net.ibizsys.model.app.IPSApplicationObject
		,net.ibizsys.model.IPSModelSortable{

	
	
	/**
	 * 获取代码标识
	 * @return
	 */
	java.lang.String getCodeName();
	
	
	/**
	 * 获取动态模式
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_DYNAMICMODE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.ViewMsgDynamicMode}
	 * @return
	 */
	int getDynamicMode();
	
	
	/**
	 * 获取显示消息
	 * @return
	 */
	java.lang.String getMessage();
	
	
	/**
	 * 获取消息类型
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_MSGTYPE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.ViewMsgType}
	 * @return
	 */
	java.lang.String getMessageType();
	
	
	/**
	 * 获取应用消息模板
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_PSSYSMSGTEMPLID}
	 * @return
	 */
	net.ibizsys.model.app.msg.IPSAppMsgTempl getPSAppMsgTempl();


	/**
	 * 获取应用消息模板，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.app.msg.IPSAppMsgTempl getPSAppMsgTemplMust();
	
	
	/**
	 * 获取显示位置
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_MSGPOS}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.ViewMsgPos}
	 * @return
	 */
	java.lang.String getPosition();
	
	
	/**
	 * 获取消息删除模式
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_ENABLEREMOVE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.ViewMsgRemoveMode}
	 * @return
	 */
	int getRemoveMode();
	
	
	/**
	 * 获取抬头
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_TITLE}
	 * @return
	 */
	java.lang.String getTitle();
	
	
	/**
	 * 获取抬头语言资源标记
	 * @return
	 */
	java.lang.String getTitleLanResTag();
	
	
	/**
	 * 获取抬头语言资源对象
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_TITLEPSLANRESID}
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getTitlePSLanguageRes();


	/**
	 * 获取抬头语言资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getTitlePSLanguageResMust();
	
	
	/**
	 * 获取是否支持关闭
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSViewMsgDTO#FIELD_ENABLEREMOVE}
	 * @return
	 */
	boolean isEnableRemove();
}