package net.ibizsys.model;

/**
 * 模型枚举集合
 */
public class PSModelEnums {

    /**
     * 工具栏按钮行为类型
     * <P>
     * <ul>
     * <li>UIACTION
     * <P>
     * 界面行为，按钮点击触发界面行为处理
     * <li>UILOGIC
     * <P>
     * 界面逻辑
     * <li>OPENVIEW
     * <P>
     * 打开应用视图
     * <li>OPENDEVIEW
     * <P>
     * 打开实体视图
     * <li>OPENSYSPDTVIEW
     * <P>
     * 打开系统预置视图
     * <li>OPENHTMLPAGE
     * <P>
     * 打开链接
     * <li>DATA_CREATEOBJECT
     * <P>
     * 建立数据
     * <li>DATA_SAVECHANGES
     * <P>
     * 保存变更
     * <li>DATA_CANCELCHANGES
     * <P>
     * 取消变更
     * <li>DATA_REMOVEOBJECT
     * <P>
     * 删除数据
     * <li>DATA_SYNCHRONIZE
     * <P>
     * 同步数据
     * <li>APP_LOGIN
     * <P>
     * 登录操作
     * <li>APP_LOGOUT
     * <P>
     * 登出操作
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum ToolbarButtonActionType{
        UIACTION("UIACTION", "界面行为")
        ,UILOGIC("UILOGIC", "界面逻辑")
        ,OPENVIEW("OPENVIEW", "打开应用视图")
        ,OPENDEVIEW("OPENDEVIEW", "打开实体视图")
        ,OPENSYSPDTVIEW("OPENSYSPDTVIEW", "打开系统预置视图")
        ,OPENHTMLPAGE("OPENHTMLPAGE", "打开链接")
        ,DATA_CREATEOBJECT("DATA_CREATEOBJECT", "建立数据")
        ,DATA_SAVECHANGES("DATA_SAVECHANGES", "保存变更")
        ,DATA_CANCELCHANGES("DATA_CANCELCHANGES", "取消变更")
        ,DATA_REMOVEOBJECT("DATA_REMOVEOBJECT", "删除数据")
        ,DATA_SYNCHRONIZE("DATA_SYNCHRONIZE", "同步数据")
        ,APP_LOGIN("APP_LOGIN", "登录操作")
        ,APP_LOGOUT("APP_LOGOUT", "登出操作")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private ToolbarButtonActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ToolbarButtonActionType from(String value){
            switch(value){
                case "UIACTION":
                    return UIACTION;
                case "UILOGIC":
                    return UILOGIC;
                case "OPENVIEW":
                    return OPENVIEW;
                case "OPENDEVIEW":
                    return OPENDEVIEW;
                case "OPENSYSPDTVIEW":
                    return OPENSYSPDTVIEW;
                case "OPENHTMLPAGE":
                    return OPENHTMLPAGE;
                case "DATA_CREATEOBJECT":
                    return DATA_CREATEOBJECT;
                case "DATA_SAVECHANGES":
                    return DATA_SAVECHANGES;
                case "DATA_CANCELCHANGES":
                    return DATA_CANCELCHANGES;
                case "DATA_REMOVEOBJECT":
                    return DATA_REMOVEOBJECT;
                case "DATA_SYNCHRONIZE":
                    return DATA_SYNCHRONIZE;
                case "APP_LOGIN":
                    return APP_LOGIN;
                case "APP_LOGOUT":
                    return APP_LOGOUT;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索项模式
     * <P>
     * <ul>
     * <li>MODE1
     * <P>
     * 模式1
     * <li>MODE2
     * <P>
     * 模式2
     * <li>MODE3
     * <P>
     * 模式3
     * <li>MODE4
     * <P>
     * 模式4
     * <li>MODE5
     * <P>
     * 模式5
     * <li>MODE6
     * <P>
     * 模式6
     * <li>MODE7
     * <P>
     * 模式7
     * <li>MODE8
     * <P>
     * 模式8
     * <li>MODE9
     * <P>
     * 模式9
     * </ul>     
     */
    public static enum DEFSFMode{
        MODE1("MODE1", "模式1")
        ,MODE2("MODE2", "模式2")
        ,MODE3("MODE3", "模式3")
        ,MODE4("MODE4", "模式4")
        ,MODE5("MODE5", "模式5")
        ,MODE6("MODE6", "模式6")
        ,MODE7("MODE7", "模式7")
        ,MODE8("MODE8", "模式8")
        ,MODE9("MODE9", "模式9")
;
           
        public final String text;
        public final String value;
        
        private DEFSFMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFSFMode from(String value){
            switch(value){
                case "MODE1":
                    return MODE1;
                case "MODE2":
                    return MODE2;
                case "MODE3":
                    return MODE3;
                case "MODE4":
                    return MODE4;
                case "MODE5":
                    return MODE5;
                case "MODE6":
                    return MODE6;
                case "MODE7":
                    return MODE7;
                case "MODE8":
                    return MODE8;
                case "MODE9":
                    return MODE9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表单表单项标签位置
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左边，标签在编辑器左侧
     * <li>TOP
     * <P>
     * 上方，标签在编辑器上方
     * <li>RIGHT
     * <P>
     * 右边，标签在编辑器右侧
     * <li>BOTTOM
     * <P>
     * 下方，标签在编辑器下方
     * <li>NONE
     * <P>
     * 不显示，不输出标签
     * </ul>     
     */
    public static enum LabelPos{
        LEFT("LEFT", "左边")
        ,TOP("TOP", "上方")
        ,RIGHT("RIGHT", "右边")
        ,BOTTOM("BOTTOM", "下方")
        ,NONE("NONE", "不显示")
;
           
        public final String text;
        public final String value;
        
        private LabelPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LabelPos from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "TOP":
                    return TOP;
                case "RIGHT":
                    return RIGHT;
                case "BOTTOM":
                    return BOTTOM;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性界面模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认模式，属性在桌面端应用的默认界面模式，该模式在所在属性中只能被定义一次
     * <li>CUSTOM
     * <P>
     * 用户自定义，自定义的属性界面模式，需要在应用场合显式指定
     * <li>MOBILEDEFAULT
     * <P>
     * 移动端默认模式，属性在移动端端应用的默认界面模式，该模式在所在属性中只能被定义一次
     * <li>APPDEFAULT
     * <P>
     * 应用默认模式，属性针对指定前端应用的默认界面模式，该模式在所在属性中只每个应用只能被定义一次
     * <li>MODE1
     * <P>
     * 模式1，用户扩展模式1，该模式在所在属性中只能被定义一次
     * <li>MODE2
     * <P>
     * 模式2，用户扩展模式2，该模式在所在属性中只能被定义一次
     * <li>MODE3
     * <P>
     * 模式3，用户扩展模式3，该模式在所在属性中只能被定义一次
     * <li>MODE4
     * <P>
     * 模式4，用户扩展模式4，该模式在所在属性中只能被定义一次
     * <li>MODE5
     * <P>
     * 模式5，用户扩展模式5，该模式在所在属性中只能被定义一次
     * <li>MODE6
     * <P>
     * 模式6，用户扩展模式6，该模式在所在属性中只能被定义一次
     * <li>MODE7
     * <P>
     * 模式7，用户扩展模式7，该模式在所在属性中只能被定义一次
     * <li>MODE8
     * <P>
     * 模式8，用户扩展模式8，该模式在所在属性中只能被定义一次
     * <li>MODE9
     * <P>
     * 模式9，用户扩展模式9，该模式在所在属性中只能被定义一次
     * </ul>     
     */
    public static enum DEFUIMode{
        DEFAULT("DEFAULT", "默认模式")
        ,CUSTOM("CUSTOM", "用户自定义")
        ,MOBILEDEFAULT("MOBILEDEFAULT", "移动端默认模式")
        ,APPDEFAULT("APPDEFAULT", "应用默认模式")
        ,MODE1("MODE1", "模式1")
        ,MODE2("MODE2", "模式2")
        ,MODE3("MODE3", "模式3")
        ,MODE4("MODE4", "模式4")
        ,MODE5("MODE5", "模式5")
        ,MODE6("MODE6", "模式6")
        ,MODE7("MODE7", "模式7")
        ,MODE8("MODE8", "模式8")
        ,MODE9("MODE9", "模式9")
;
           
        public final String text;
        public final String value;
        
        private DEFUIMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFUIMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "CUSTOM":
                    return CUSTOM;
                case "MOBILEDEFAULT":
                    return MOBILEDEFAULT;
                case "APPDEFAULT":
                    return APPDEFAULT;
                case "MODE1":
                    return MODE1;
                case "MODE2":
                    return MODE2;
                case "MODE3":
                    return MODE3;
                case "MODE4":
                    return MODE4;
                case "MODE5":
                    return MODE5;
                case "MODE6":
                    return MODE6;
                case "MODE7":
                    return MODE7;
                case "MODE8":
                    return MODE8;
                case "MODE9":
                    return MODE9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面逻辑触发类型
     * <P>
     * <ul>
     * <li>TIMER
     * <P>
     * 定时器触发，定时器定时触发逻辑，需指定定时器时间间隔
     * <li>CTRLEVENT
     * <P>
     * 部件事件触发，指定部件事件触发逻辑，需同时指定部件标识及事件名称
     * <li>VIEWEVENT
     * <P>
     * 视图事件触发，指定视图事件触发逻辑
     * <li>APPEVENT
     * <P>
     * 应用事件触发，指定应用事件触发逻辑
     * <li>ITEMVISIBLE
     * <P>
     * 项显示逻辑，成员项动态显示逻辑，控制成员是否显示
     * <li>ITEMENABLE
     * <P>
     * 项启用逻辑，成员项的动态启用逻辑，控成员及其编辑器启用禁用状态
     * <li>ITEMBLANK
     * <P>
     * 项空输入逻辑，成员项的动态空输入逻辑，控制成员项及其编辑器是否允许空输入
     * <li>ITEMDYNACLASS
     * <P>
     * 项动态样式表，成员项的动态样式表逻辑，控制成员项的样式表
     * <li>RENDER
     * <P>
     * 绘制器，向容器或相关成员指定绘制器，绘制器包括直接面板，面板模型（DSL或运行时模型）以及前端插件
     * <li>ATTRIBUTE
     * <P>
     * 注入属性，向容器或相关成员注入属性
     * <li>CUSTOM
     * <P>
     * 自定义，仅发布逻辑，不挂接任何事件，由其它逻辑驱动或自定义代码调用
     * <li>VUE_DIRECTIVE
     * <P>
     * VUE指令
     * </ul>     
     */
    public static enum UILogicTriggerType{
        TIMER("TIMER", "定时器触发")
        ,CTRLEVENT("CTRLEVENT", "部件事件触发")
        ,VIEWEVENT("VIEWEVENT", "视图事件触发")
        ,APPEVENT("APPEVENT", "应用事件触发")
        ,ITEMVISIBLE("ITEMVISIBLE", "项显示逻辑")
        ,ITEMENABLE("ITEMENABLE", "项启用逻辑")
        ,ITEMBLANK("ITEMBLANK", "项空输入逻辑")
        ,ITEMDYNACLASS("ITEMDYNACLASS", "项动态样式表")
        ,RENDER("RENDER", "绘制器")
        ,ATTRIBUTE("ATTRIBUTE", "注入属性")
        ,CUSTOM("CUSTOM", "自定义")
        ,VUE_DIRECTIVE("VUE_DIRECTIVE", "VUE指令")
;
           
        public final String text;
        public final String value;
        
        private UILogicTriggerType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UILogicTriggerType from(String value){
            switch(value){
                case "TIMER":
                    return TIMER;
                case "CTRLEVENT":
                    return CTRLEVENT;
                case "VIEWEVENT":
                    return VIEWEVENT;
                case "APPEVENT":
                    return APPEVENT;
                case "ITEMVISIBLE":
                    return ITEMVISIBLE;
                case "ITEMENABLE":
                    return ITEMENABLE;
                case "ITEMBLANK":
                    return ITEMBLANK;
                case "ITEMDYNACLASS":
                    return ITEMDYNACLASS;
                case "RENDER":
                    return RENDER;
                case "ATTRIBUTE":
                    return ATTRIBUTE;
                case "CUSTOM":
                    return CUSTOM;
                case "VUE_DIRECTIVE":
                    return VUE_DIRECTIVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为组展开模式
     * <P>
     * <ul>
     * <li>ITEM
     * <P>
     * 按项展开（默认），界面上逐项展开
     * <li>ITEMS
     * <P>
     * 按分组展开，界面上仅提供目录操作，如下拉显示界面行为组的行为集合
     * </ul>     
     */
    public static enum UGExtractMode{
        ITEM("ITEM", "按项展开（默认）")
        ,ITEMS("ITEMS", "按分组展开")
;
           
        public final String text;
        public final String value;
        
        private UGExtractMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UGExtractMode from(String value){
            switch(value){
                case "ITEM":
                    return ITEM;
                case "ITEMS":
                    return ITEMS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为成员项附加内容类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>RAW
     * <P>
     * 直接内容
     * </ul>     
     */
    public static enum UAGroupDetailAppendItemType{
        NONE("NONE", "无")
        ,RAW("RAW", "直接内容")
;
           
        public final String text;
        public final String value;
        
        private UAGroupDetailAppendItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UAGroupDetailAppendItemType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "RAW":
                    return RAW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统服务接口模式，数值项
     * <P>
     * <ul>
     * <li>SOMEDE&nbsp;(0)
     * <P>
     * 实体服务接口（指定实体）（默认）
     * <li>ALLDE&nbsp;(1)
     * <P>
     * 实体服务接口（全部非子系统实体）
     * <li>PREDEFINED&nbsp;(2)
     * <P>
     * 平台预置服务接口
     * <li>CUSTOM&nbsp;(10)
     * <P>
     * 自定义接口
     * </ul>     
     */
    public static enum ServiceAPIMode{
        SOMEDE(0, "实体服务接口（指定实体）（默认）")
        ,ALLDE(1, "实体服务接口（全部非子系统实体）")
        ,PREDEFINED(2, "平台预置服务接口")
        ,CUSTOM(10, "自定义接口")
;
           
        public final String text;
        public final int value;
        
        private ServiceAPIMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceAPIMode from(int value){
            switch(value){
                case 0:
                    return SOMEDE;
                case 1:
                    return ALLDE;
                case 2:
                    return PREDEFINED;
                case 10:
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息缓存范围
     * <P>
     * <ul>
     * <li>GLOBAL
     * <P>
     * 全局
     * </ul>     
     */
    public static enum ViewMsgCacheScope{
        GLOBAL("GLOBAL", "全局")
;
           
        public final String text;
        public final String value;
        
        private ViewMsgCacheScope(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgCacheScope from(String value){
            switch(value){
                case "GLOBAL":
                    return GLOBAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统值转换类型
     * <P>
     * <ul>
     * <li>DIGEST
     * <P>
     * 密码（不可逆）
     * <li>ENCRYPT
     * <P>
     * 加密（可逆）
     * <li>DESTORAGE
     * <P>
     * 实体扩展存储
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TranslatorType{
        DIGEST("DIGEST", "密码（不可逆）")
        ,ENCRYPT("ENCRYPT", "加密（可逆）")
        ,DESTORAGE("DESTORAGE", "实体扩展存储")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TranslatorType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TranslatorType from(String value){
            switch(value){
                case "DIGEST":
                    return DIGEST;
                case "ENCRYPT":
                    return ENCRYPT;
                case "DESTORAGE":
                    return DESTORAGE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性默认值类型
     * <P>
     * <ul>
     * <li>SESSION
     * <P>
     * 用户全局对象，需要同时指定默认值作为参数名称传入
     * <li>APPLICATION
     * <P>
     * 系统全局对象，需要同时指定默认值作为参数名称传入
     * <li>UNIQUEID
     * <P>
     * 唯一编码
     * <li>CONTEXT
     * <P>
     * 网页请求，需要同时指定默认值作为参数名称传入
     * <li>PARAM
     * <P>
     * 数据对象属性，需要同时指定默认值作为参数名称传入
     * <li>OPERATOR
     * <P>
     * 当前操作用户(编号)
     * <li>OPERATORNAME
     * <P>
     * 当前操作用户(名称)
     * <li>CURTIME
     * <P>
     * 当前时间
     * <li>APPDATA
     * <P>
     * 当前应用数据，需要同时指定默认值作为参数名称传入
     * <li>EXPRESSION
     * <P>
     * 表达式，需要同时指定默认值作为计算表达式
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEFDefaultValueType{
        SESSION("SESSION", "用户全局对象")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,UNIQUEID("UNIQUEID", "唯一编码")
        ,CONTEXT("CONTEXT", "网页请求")
        ,PARAM("PARAM", "数据对象属性")
        ,OPERATOR("OPERATOR", "当前操作用户(编号)")
        ,OPERATORNAME("OPERATORNAME", "当前操作用户(名称)")
        ,CURTIME("CURTIME", "当前时间")
        ,APPDATA("APPDATA", "当前应用数据")
        ,EXPRESSION("EXPRESSION", "表达式")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEFDefaultValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFDefaultValueType from(String value){
            switch(value){
                case "SESSION":
                    return SESSION;
                case "APPLICATION":
                    return APPLICATION;
                case "UNIQUEID":
                    return UNIQUEID;
                case "CONTEXT":
                    return CONTEXT;
                case "PARAM":
                    return PARAM;
                case "OPERATOR":
                    return OPERATOR;
                case "OPERATORNAME":
                    return OPERATORNAME;
                case "CURTIME":
                    return CURTIME;
                case "APPDATA":
                    return APPDATA;
                case "EXPRESSION":
                    return EXPRESSION;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 代码表或模式
     * <P>
     * <ul>
     * <li>NUMBERORMODE
     * <P>
     * 数字或处理，多项值按位或处理，一般代码项的值对应字节的位：1、2、4、8等
     * <li>STRINGORMODE
     * <P>
     * 文本或模式，代码项的值使用分隔符号拼接
     * </ul>     
     */
    public static enum DesignCodeListOrMode{
        NUMBERORMODE("NUMBERORMODE", "数字或处理")
        ,STRINGORMODE("STRINGORMODE", "文本或模式")
;
           
        public final String text;
        public final String value;
        
        private DesignCodeListOrMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DesignCodeListOrMode from(String value){
            switch(value){
                case "NUMBERORMODE":
                    return NUMBERORMODE;
                case "STRINGORMODE":
                    return STRINGORMODE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用菜单按钮行为类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无处理
     * <li>APPFUNC
     * <P>
     * 应用功能，按钮点击应用功能处理
     * <li>UIACTION
     * <P>
     * 界面行为，按钮点击触发界面行为处理
     * <li>UILOGIC
     * <P>
     * 界面逻辑
     * <li>OPENVIEW
     * <P>
     * 打开应用视图
     * <li>OPENHTMLPAGE
     * <P>
     * 打开链接
     * <li>APP_LOGOUT
     * <P>
     * 登出操作
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum AppMenuButtonActionType{
        NONE("NONE", "无处理")
        ,APPFUNC("APPFUNC", "应用功能")
        ,UIACTION("UIACTION", "界面行为")
        ,UILOGIC("UILOGIC", "界面逻辑")
        ,OPENVIEW("OPENVIEW", "打开应用视图")
        ,OPENHTMLPAGE("OPENHTMLPAGE", "打开链接")
        ,APP_LOGOUT("APP_LOGOUT", "登出操作")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private AppMenuButtonActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppMenuButtonActionType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "APPFUNC":
                    return APPFUNC;
                case "UIACTION":
                    return UIACTION;
                case "UILOGIC":
                    return UILOGIC;
                case "OPENVIEW":
                    return OPENVIEW;
                case "OPENHTMLPAGE":
                    return OPENHTMLPAGE;
                case "APP_LOGOUT":
                    return APP_LOGOUT;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体视图逻辑类型
     * <P>
     * <ul>
     * <li>TIMER
     * <P>
     * 定时器触发，定时器定时触发逻辑，需指定定时器时间间隔
     * <li>VIEWEVENT
     * <P>
     * 视图事件触发，视图事件触发逻辑，需指定事件名称，如初始化、加载等
     * <li>CTRLEVENT
     * <P>
     * 部件事件触发，指定部件事件触发逻辑，需同时指定部件标识及事件名称
     * <li>ITEMVISIBLE
     * <P>
     * 项显示逻辑，成员项动态显示逻辑，控制成员是否显示
     * <li>ITEMENABLE
     * <P>
     * 项启用逻辑，成员项的动态启用逻辑，控成员及其编辑器启用禁用状态
     * <li>ITEMBLANK
     * <P>
     * 项空输入逻辑，成员项的动态空输入逻辑，控制成员项及其编辑器是否允许空输入
     * <li>ITEMDYNACLASS
     * <P>
     * 项动态样式表，成员项的动态样式表逻辑，控制成员项的样式表
     * <li>RENDER
     * <P>
     * 绘制器，向容器或相关成员指定绘制器，绘制器包括直接面板，面板模型（DSL或运行时模型）以及前端插件
     * <li>ATTRIBUTE
     * <P>
     * 注入属性，向容器或相关成员注入属性
     * <li>CUSTOM
     * <P>
     * 只挂接（外部调用），仅发布逻辑，不挂接任何事件，由其它逻辑驱动或自定义代码调用
     * <li>VUE_DIRECTIVE
     * <P>
     * VUE指令
     * </ul>     
     */
    public static enum ViewLogicTrigger{
        TIMER("TIMER", "定时器触发")
        ,VIEWEVENT("VIEWEVENT", "视图事件触发")
        ,CTRLEVENT("CTRLEVENT", "部件事件触发")
        ,ITEMVISIBLE("ITEMVISIBLE", "项显示逻辑")
        ,ITEMENABLE("ITEMENABLE", "项启用逻辑")
        ,ITEMBLANK("ITEMBLANK", "项空输入逻辑")
        ,ITEMDYNACLASS("ITEMDYNACLASS", "项动态样式表")
        ,RENDER("RENDER", "绘制器")
        ,ATTRIBUTE("ATTRIBUTE", "注入属性")
        ,CUSTOM("CUSTOM", "只挂接（外部调用）")
        ,VUE_DIRECTIVE("VUE_DIRECTIVE", "VUE指令")
;
           
        public final String text;
        public final String value;
        
        private ViewLogicTrigger(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewLogicTrigger from(String value){
            switch(value){
                case "TIMER":
                    return TIMER;
                case "VIEWEVENT":
                    return VIEWEVENT;
                case "CTRLEVENT":
                    return CTRLEVENT;
                case "ITEMVISIBLE":
                    return ITEMVISIBLE;
                case "ITEMENABLE":
                    return ITEMENABLE;
                case "ITEMBLANK":
                    return ITEMBLANK;
                case "ITEMDYNACLASS":
                    return ITEMDYNACLASS;
                case "RENDER":
                    return RENDER;
                case "ATTRIBUTE":
                    return ATTRIBUTE;
                case "CUSTOM":
                    return CUSTOM;
                case "VUE_DIRECTIVE":
                    return VUE_DIRECTIVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流节点参数类型
     * <P>
     * <ul>
     * <li>PREPAREPARAM
     * <P>
     * 准备参数，指定数据流的准备参数
     * <li>MERGEPARAM
     * <P>
     * 合并参数，指定合并数据流的参数
     * <li>AGGREGATEPARAM
     * <P>
     * 聚合参数，指定聚合数据流的参数
     * <li>SORTPARAM
     * <P>
     * 排序参数，指定聚合数据流的参数
     * </ul>     
     */
    public static enum DEDataFlowNodeParamType{
        PREPAREPARAM("PREPAREPARAM", "准备参数")
        ,MERGEPARAM("MERGEPARAM", "合并参数")
        ,AGGREGATEPARAM("AGGREGATEPARAM", "聚合参数")
        ,SORTPARAM("SORTPARAM", "排序参数")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowNodeParamType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowNodeParamType from(String value){
            switch(value){
                case "PREPAREPARAM":
                    return PREPAREPARAM;
                case "MERGEPARAM":
                    return MERGEPARAM;
                case "AGGREGATEPARAM":
                    return AGGREGATEPARAM;
                case "SORTPARAM":
                    return SORTPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 微信菜单功能类型
     * <P>
     * <ul>
     * <li>CLICK&nbsp;(click)
     * <P>
     * 点击推事件
     * <li>VIEW&nbsp;(view)
     * <P>
     * 跳转URL
     * <li>SCANCODE_PUSH&nbsp;(scancode_push)
     * <P>
     * 扫码推事件
     * <li>SCANCODE_WAITMSG&nbsp;(scancode_waitmsg)
     * <P>
     * 扫码推事件（且弹出“消息接收中”提示框）
     * <li>PIC_SYSPHOTO&nbsp;(pic_sysphoto)
     * <P>
     * 弹出系统拍照发图
     * <li>PIC_PHOTO_OR_ALBUM&nbsp;(pic_photo_or_album)
     * <P>
     * 弹出拍照或者相册发图
     * <li>PIC_WEIXIN&nbsp;(pic_weixin)
     * <P>
     * 弹出企业微信相册发图器
     * <li>LOCATION_SELECT&nbsp;(location_select)
     * <P>
     * 弹出地理位置选择器
     * </ul>     
     */
    public static enum WXMenuFuncType{
        CLICK("click", "点击推事件")
        ,VIEW("view", "跳转URL")
        ,SCANCODE_PUSH("scancode_push", "扫码推事件")
        ,SCANCODE_WAITMSG("scancode_waitmsg", "扫码推事件（且弹出“消息接收中”提示框）")
        ,PIC_SYSPHOTO("pic_sysphoto", "弹出系统拍照发图")
        ,PIC_PHOTO_OR_ALBUM("pic_photo_or_album", "弹出拍照或者相册发图")
        ,PIC_WEIXIN("pic_weixin", "弹出企业微信相册发图器")
        ,LOCATION_SELECT("location_select", "弹出地理位置选择器")
;
           
        public final String text;
        public final String value;
        
        private WXMenuFuncType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WXMenuFuncType from(String value){
            switch(value){
                case "click":
                    return CLICK;
                case "view":
                    return VIEW;
                case "scancode_push":
                    return SCANCODE_PUSH;
                case "scancode_waitmsg":
                    return SCANCODE_WAITMSG;
                case "pic_sysphoto":
                    return PIC_SYSPHOTO;
                case "pic_photo_or_album":
                    return PIC_PHOTO_OR_ALBUM;
                case "pic_weixin":
                    return PIC_WEIXIN;
                case "location_select":
                    return LOCATION_SELECT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为参数值类型
     * <P>
     * <ul>
     * <li>INPUTVALUE
     * <P>
     * 输入值（默认），接受指定参数的传入值
     * <li>NONEVALUE
     * <P>
     * 无值（不设置），忽略指定参数的传入值
     * <li>PARAM
     * <P>
     * 数据对象属性，参数值来自传入数据对象的属性，需指定属性键名
     * <li>VALUE
     * <P>
     * 指定值，参数值来自设定的直接值
     * <li>NULLVALUE
     * <P>
     * 空值，参数值设定为空值
     * <li>SESSION
     * <P>
     * 用户全局对象，参数值来自用户上下文对象的属性，需指定属性键名
     * <li>APPLICATION
     * <P>
     * 系统全局对象，参数值来自系统上下文对象的属性，需指定属性键名
     * <li>UNIQUEID
     * <P>
     * 唯一编码，参数值设定为生随机标识
     * <li>CONTEXT
     * <P>
     * 网页请求，参数值来自当前请求的参数对象，需指定属性键名
     * <li>OPERATOR
     * <P>
     * 当前操作用户(编号)，参数值设定为当前用户标识
     * <li>OPERATORNAME
     * <P>
     * 当前操作用户(名称)，参数值设定为当前用户名称
     * <li>CURTIME
     * <P>
     * 当前时间，参数值设定为当前时间
     * <li>APPDATA
     * <P>
     * 当前应用数据，参数值来自应用上下文对象的属性，需指定属性键名
     * <li>EXPRESSION
     * <P>
     * 表达式，参数值来自计算表达式
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEActionParamValueType{
        INPUTVALUE("INPUTVALUE", "输入值（默认）")
        ,NONEVALUE("NONEVALUE", "无值（不设置）")
        ,PARAM("PARAM", "数据对象属性")
        ,VALUE("VALUE", "指定值")
        ,NULLVALUE("NULLVALUE", "空值")
        ,SESSION("SESSION", "用户全局对象")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,UNIQUEID("UNIQUEID", "唯一编码")
        ,CONTEXT("CONTEXT", "网页请求")
        ,OPERATOR("OPERATOR", "当前操作用户(编号)")
        ,OPERATORNAME("OPERATORNAME", "当前操作用户(名称)")
        ,CURTIME("CURTIME", "当前时间")
        ,APPDATA("APPDATA", "当前应用数据")
        ,EXPRESSION("EXPRESSION", "表达式")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEActionParamValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionParamValueType from(String value){
            switch(value){
                case "INPUTVALUE":
                    return INPUTVALUE;
                case "NONEVALUE":
                    return NONEVALUE;
                case "PARAM":
                    return PARAM;
                case "VALUE":
                    return VALUE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "SESSION":
                    return SESSION;
                case "APPLICATION":
                    return APPLICATION;
                case "UNIQUEID":
                    return UNIQUEID;
                case "CONTEXT":
                    return CONTEXT;
                case "OPERATOR":
                    return OPERATOR;
                case "OPERATORNAME":
                    return OPERATORNAME;
                case "CURTIME":
                    return CURTIME;
                case "APPDATA":
                    return APPDATA;
                case "EXPRESSION":
                    return EXPRESSION;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 进入状态模式
     * <P>
     * <ul>
     * <li>ANY
     * <P>
     * 任意
     * <li>SOME
     * <P>
     * 指定
     * </ul>     
     */
    public static enum DEMSEnterMode{
        ANY("ANY", "任意")
        ,SOME("SOME", "指定")
;
           
        public final String text;
        public final String value;
        
        private DEMSEnterMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMSEnterMode from(String value){
            switch(value){
                case "ANY":
                    return ANY;
                case "SOME":
                    return SOME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台工具栏项类型（界面行为组成员）
     * <P>
     * <ul>
     * <li>DEUIACTION
     * <P>
     * 实体界面行为，界面行为
     * </ul>     
     */
    public static enum UAGroupDetailType{
        DEUIACTION("DEUIACTION", "实体界面行为")
;
           
        public final String text;
        public final String value;
        
        private UAGroupDetailType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UAGroupDetailType from(String value){
            switch(value){
                case "DEUIACTION":
                    return DEUIACTION;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统需求项类型
     * <P>
     * <ul>
     * <li>NORMAL
     * <P>
     * 常规
     * </ul>     
     */
    public static enum SysReqItemType{
        NORMAL("NORMAL", "常规")
;
           
        public final String text;
        public final String value;
        
        private SysReqItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysReqItemType from(String value){
            switch(value){
                case "NORMAL":
                    return NORMAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统数据库值函数类型
     * <P>
     * <ul>
     * <li>PS
     * <P>
     * 云平台内置
     * <li>UX
     * <P>
     * 用户扩展
     * </ul>     
     */
    public static enum DBValueFuncType{
        PS("PS", "云平台内置")
        ,UX("UX", "用户扩展")
;
           
        public final String text;
        public final String value;
        
        private DBValueFuncType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBValueFuncType from(String value){
            switch(value){
                case "PS":
                    return PS;
                case "UX":
                    return UX;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台核心产品版本状态，数值项
     * <P>
     * <ul>
     * <li>NOTBUILD&nbsp;(0)
     * <P>
     * 未构建
     * <li>BUILDING&nbsp;(1)
     * <P>
     * 构建中
     * <li>BUILDED&nbsp;(2)
     * <P>
     * 已构建
     * <li>BUILDFAILED&nbsp;(3)
     * <P>
     * 构建失败
     * </ul>     
     */
    public static enum ProductVerState{
        NOTBUILD(0, "未构建")
        ,BUILDING(1, "构建中")
        ,BUILDED(2, "已构建")
        ,BUILDFAILED(3, "构建失败")
;
           
        public final String text;
        public final int value;
        
        private ProductVerState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ProductVerState from(int value){
            switch(value){
                case 0:
                    return NOTBUILD;
                case 1:
                    return BUILDING;
                case 2:
                    return BUILDED;
                case 3:
                    return BUILDFAILED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统数据库表操作
     * <P>
     * <ul>
     * <li>CREATE
     * <P>
     * 建立
     * <li>UPDATE
     * <P>
     * 更新
     * <li>UPSERT
     * <P>
     * 自动建立或更新
     * <li>REPLACE
     * <P>
     * 替换
     * <li>READ
     * <P>
     * 获取
     * <li>DELETE
     * <P>
     * 删除
     * </ul>     
     */
    public static enum DBTableAction{
        CREATE("CREATE", "建立")
        ,UPDATE("UPDATE", "更新")
        ,UPSERT("UPSERT", "自动建立或更新")
        ,REPLACE("REPLACE", "替换")
        ,READ("READ", "获取")
        ,DELETE("DELETE", "删除")
;
           
        public final String text;
        public final String value;
        
        private DBTableAction(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBTableAction from(String value){
            switch(value){
                case "CREATE":
                    return CREATE;
                case "UPDATE":
                    return UPDATE;
                case "UPSERT":
                    return UPSERT;
                case "REPLACE":
                    return REPLACE;
                case "READ":
                    return READ;
                case "DELETE":
                    return DELETE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * AI构建模式，数值项
     * <P>
     * <ul>
     * <li>NOT&nbsp;(0)
     * <P>
     * 不构建
     * <li>USERCONFIRM&nbsp;(1)
     * <P>
     * 构建并等待用户确认
     * <li>AUTOCONFIRM&nbsp;(2)
     * <P>
     * 构建并自动确认
     * </ul>     
     */
    public static enum AIBuildMode{
        NOT(0, "不构建")
        ,USERCONFIRM(1, "构建并等待用户确认")
        ,AUTOCONFIRM(2, "构建并自动确认")
;
           
        public final String text;
        public final int value;
        
        private AIBuildMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AIBuildMode from(int value){
            switch(value){
                case 0:
                    return NOT;
                case 1:
                    return USERCONFIRM;
                case 2:
                    return AUTOCONFIRM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体图表自动分组模式
     * <P>
     * <ul>
     * <li>YEAR
     * <P>
     * 年
     * <li>QUARTER
     * <P>
     * 季度
     * <li>MONTH
     * <P>
     * 月份
     * <li>YEARWEEK
     * <P>
     * 年周
     * <li>DAY
     * <P>
     * 日
     * <li>CODELIST
     * <P>
     * 代码表
     * </ul>     
     */
    public static enum ChartSeriesGroupMode{
        YEAR("YEAR", "年")
        ,QUARTER("QUARTER", "季度")
        ,MONTH("MONTH", "月份")
        ,YEARWEEK("YEARWEEK", "年周")
        ,DAY("DAY", "日")
        ,CODELIST("CODELIST", "代码表")
;
           
        public final String text;
        public final String value;
        
        private ChartSeriesGroupMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartSeriesGroupMode from(String value){
            switch(value){
                case "YEAR":
                    return YEAR;
                case "QUARTER":
                    return QUARTER;
                case "MONTH":
                    return MONTH;
                case "YEARWEEK":
                    return YEARWEEK;
                case "DAY":
                    return DAY;
                case "CODELIST":
                    return CODELIST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试数据项值类型
     * <P>
     * <ul>
     * <li>VALUE
     * <P>
     * 直接值
     * <li>VALUERANGE
     * <P>
     * 值范围，从值范围中随机选取一个
     * <li>NULLVALUE
     * <P>
     * 空值
     * <li>PICKUPVALUE
     * <P>
     * 外键随机值，从引用实体的测试数据中随机选取一个
     * <li>CODELISTVALUE
     * <P>
     * 代码表随机值，从指定的代码表项中随机选取一个
     * </ul>     
     */
    public static enum TestDataItemValueType{
        VALUE("VALUE", "直接值")
        ,VALUERANGE("VALUERANGE", "值范围")
        ,NULLVALUE("NULLVALUE", "空值")
        ,PICKUPVALUE("PICKUPVALUE", "外键随机值")
        ,CODELISTVALUE("CODELISTVALUE", "代码表随机值")
;
           
        public final String text;
        public final String value;
        
        private TestDataItemValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestDataItemValueType from(String value){
            switch(value){
                case "VALUE":
                    return VALUE;
                case "VALUERANGE":
                    return VALUERANGE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "PICKUPVALUE":
                    return PICKUPVALUE;
                case "CODELISTVALUE":
                    return CODELISTVALUE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用首页视图应用选择器模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>DEFAULT&nbsp;(1)
     * <P>
     * 默认
     * </ul>     
     */
    public static enum AppSwitchMode{
        NONE(0, "无")
        ,DEFAULT(1, "默认")
;
           
        public final String text;
        public final int value;
        
        private AppSwitchMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppSwitchMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return DEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统状态协调状态属性
     * <P>
     * <ul>
     * <li>STATE1
     * <P>
     * 状态1
     * <li>STATE2
     * <P>
     * 状态2
     * <li>STATE3
     * <P>
     * 状态3
     * <li>STATE4
     * <P>
     * 状态4
     * <li>STATE5
     * <P>
     * 状态5
     * <li>STATE6
     * <P>
     * 状态6
     * <li>STATE7
     * <P>
     * 状态7
     * <li>STATE8
     * <P>
     * 状态8
     * </ul>     
     */
    public static enum UniState{
        STATE1("STATE1", "状态1")
        ,STATE2("STATE2", "状态2")
        ,STATE3("STATE3", "状态3")
        ,STATE4("STATE4", "状态4")
        ,STATE5("STATE5", "状态5")
        ,STATE6("STATE6", "状态6")
        ,STATE7("STATE7", "状态7")
        ,STATE8("STATE8", "状态8")
;
           
        public final String text;
        public final String value;
        
        private UniState(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UniState from(String value){
            switch(value){
                case "STATE1":
                    return STATE1;
                case "STATE2":
                    return STATE2;
                case "STATE3":
                    return STATE3;
                case "STATE4":
                    return STATE4;
                case "STATE5":
                    return STATE5;
                case "STATE6":
                    return STATE6;
                case "STATE7":
                    return STATE7;
                case "STATE8":
                    return STATE8;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为附加逻辑类型，数值项
     * <P>
     * <ul>
     * <li>INTERNAL&nbsp;(1)
     * <P>
     * 内部逻辑，附加来自当前实体的处理逻辑
     * <li>EXTERNAL&nbsp;(0)
     * <P>
     * 外部逻辑，附加来自指定实体的行为
     * <li>SCRIPT&nbsp;(2)
     * <P>
     * 脚本代码，附加自定义的脚本代码
     * <li>NOTIFY&nbsp;(3)
     * <P>
     * 实体通知，附加当前实体的通知逻辑
     * <li>FILLMAINSTATE&nbsp;(4)
     * <P>
     * 填充实体主状态，填充当前实体的主状态，包括状态控制属性及相关属性设置
     * <li>DATASYNC&nbsp;(5)
     * <P>
     * 实体数据同步，附加当前实体的数据同步逻辑
     * <li>DSTDATAACTION&nbsp;(6)
     * <P>
     * 目标数据操作（指定主关系），对指定主关系的目标数据进行操作
     * <li>DSTDATAACTION2&nbsp;(7)
     * <P>
     * 目标数据操作（指定数据集），对指定数据集的目标数据进行操作
     * <li>SYSLOGIC&nbsp;(8)
     * <P>
     * 系统预置逻辑，附加系统预置逻辑
     * <li>SYSTRANSLATOR&nbsp;(9)
     * <P>
     * 属性值转换，附加系统值转换逻辑
     * <li>SYSSEQUENCE&nbsp;(10)
     * <P>
     * 属性值序列填充，附加系统值序列逻辑
     * <li>CHECKDEFVALUERULE&nbsp;(50)
     * <P>
     * 检查属性值规则，对指定值规则进行校验
     * <li>CHECKMAINSTATE&nbsp;(51)
     * <P>
     * 检查数据主状态（处于），检查数据是否处在指定数据主状态
     * <li>CHECKNOTMAINSTATE&nbsp;(52)
     * <P>
     * 检查数据主状态（不处于），检查数据是否不处于指定数据主状态
     * <li>CHECKDSTDATAEXISTS&nbsp;(53)
     * <P>
     * 检查目标数据存在（指定主关系），检查指定主关系的目标数据存在
     * <li>CHECKDSTDATANOTEXISTS&nbsp;(54)
     * <P>
     * 检查目标数据不存在（指定主关系），检查指定主关系的目标数据不存在
     * <li>CHECKDSTDATAEXISTS2&nbsp;(55)
     * <P>
     * 检查目标数据存在（指定数据集），检查指定数据集的目标数据存在
     * <li>CHECKDSTDATANOTEXISTS2&nbsp;(56)
     * <P>
     * 检查目标数据不存在（指定数据集），检查指定数据集的目标数据不存在
     * </ul>     
     */
    public static enum DEActionLogicType{
        INTERNAL(1, "内部逻辑")
        ,EXTERNAL(0, "外部逻辑")
        ,SCRIPT(2, "脚本代码")
        ,NOTIFY(3, "实体通知")
        ,FILLMAINSTATE(4, "填充实体主状态")
        ,DATASYNC(5, "实体数据同步")
        ,DSTDATAACTION(6, "目标数据操作（指定主关系）")
        ,DSTDATAACTION2(7, "目标数据操作（指定数据集）")
        ,SYSLOGIC(8, "系统预置逻辑")
        ,SYSTRANSLATOR(9, "属性值转换")
        ,SYSSEQUENCE(10, "属性值序列填充")
        ,CHECKDEFVALUERULE(50, "检查属性值规则")
        ,CHECKMAINSTATE(51, "检查数据主状态（处于）")
        ,CHECKNOTMAINSTATE(52, "检查数据主状态（不处于）")
        ,CHECKDSTDATAEXISTS(53, "检查目标数据存在（指定主关系）")
        ,CHECKDSTDATANOTEXISTS(54, "检查目标数据不存在（指定主关系）")
        ,CHECKDSTDATAEXISTS2(55, "检查目标数据存在（指定数据集）")
        ,CHECKDSTDATANOTEXISTS2(56, "检查目标数据不存在（指定数据集）")
;
           
        public final String text;
        public final int value;
        
        private DEActionLogicType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionLogicType from(int value){
            switch(value){
                case 1:
                    return INTERNAL;
                case 0:
                    return EXTERNAL;
                case 2:
                    return SCRIPT;
                case 3:
                    return NOTIFY;
                case 4:
                    return FILLMAINSTATE;
                case 5:
                    return DATASYNC;
                case 6:
                    return DSTDATAACTION;
                case 7:
                    return DSTDATAACTION2;
                case 8:
                    return SYSLOGIC;
                case 9:
                    return SYSTRANSLATOR;
                case 10:
                    return SYSSEQUENCE;
                case 50:
                    return CHECKDEFVALUERULE;
                case 51:
                    return CHECKMAINSTATE;
                case 52:
                    return CHECKNOTMAINSTATE;
                case 53:
                    return CHECKDSTDATAEXISTS;
                case 54:
                    return CHECKDSTDATANOTEXISTS;
                case 55:
                    return CHECKDSTDATAEXISTS2;
                case 56:
                    return CHECKDSTDATANOTEXISTS2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台流程编辑视图类型
     * <P>
     * <ul>
     * <li>DEWFEDITVIEW
     * <P>
     * 实体工作流编辑视图
     * <li>DEWFEDITVIEW2
     * <P>
     * 实体工作流编辑视图（左右关系）
     * <li>DEWFEDITVIEW3
     * <P>
     * 实体工作流视图（分页关系）
     * </ul>     
     */
    public static enum DEWFEditViewType{
        DEWFEDITVIEW("DEWFEDITVIEW", "实体工作流编辑视图")
        ,DEWFEDITVIEW2("DEWFEDITVIEW2", "实体工作流编辑视图（左右关系）")
        ,DEWFEDITVIEW3("DEWFEDITVIEW3", "实体工作流视图（分页关系）")
;
           
        public final String text;
        public final String value;
        
        private DEWFEditViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEWFEditViewType from(String value){
            switch(value){
                case "DEWFEDITVIEW":
                    return DEWFEDITVIEW;
                case "DEWFEDITVIEW2":
                    return DEWFEDITVIEW2;
                case "DEWFEDITVIEW3":
                    return DEWFEDITVIEW3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体接口模式，数值项
     * <P>
     * <ul>
     * <li>MAJOR&nbsp;(1)
     * <P>
     * 主接口，实体服务接口为顶级资源，支持独立提供资源访问能力
     * <li>MINOR&nbsp;(0)
     * <P>
     * 从接口，实体服务接口为非顶级资源，必须作为顶级资源的成员提供能力
     * <li>NESTED&nbsp;(9)
     * <P>
     * 数据传输对象（DTO）嵌套成员，实体服务接口不提供能力，仅作为其它接口传输对象的数据结构成员
     * </ul>     
     */
    public static enum SADEMode{
        MAJOR(1, "主接口")
        ,MINOR(0, "从接口")
        ,NESTED(9, "数据传输对象（DTO）嵌套成员")
;
           
        public final String text;
        public final int value;
        
        private SADEMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEMode from(int value){
            switch(value){
                case 1:
                    return MAJOR;
                case 0:
                    return MINOR;
                case 9:
                    return NESTED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工作流角色类型
     * <P>
     * <ul>
     * <li>USERGROUP
     * <P>
     * 用户组
     * <li>SYSUSERROLE
     * <P>
     * 系统角色
     * <li>CUSTOM
     * <P>
     * 自定义
     * <li>DEDATASET
     * <P>
     * 实体数据集合
     * <li>ORG
     * <P>
     * 当前组织
     * <li>PORG
     * <P>
     * 当前组织父组织
     * <li>ORGSECTOR
     * <P>
     * 当前部门
     * <li>PORGSECTOR
     * <P>
     * 当前部门父部门
     * <li>ORGGROUP
     * <P>
     * 机构组
     * <li>ORGSECTORGROUP
     * <P>
     * 部门组
     * <li>ORGUSERGROUP
     * <P>
     * 机构人员组
     * <li>ORGSECTORUSERGROUP
     * <P>
     * 部门人员组
     * <li>ORGADMIN
     * <P>
     * 当前组织管理员
     * <li>ORGSECTORADMIN
     * <P>
     * 当前部门管理员
     * </ul>     
     */
    public static enum WFRoleType{
        USERGROUP("USERGROUP", "用户组")
        ,SYSUSERROLE("SYSUSERROLE", "系统角色")
        ,CUSTOM("CUSTOM", "自定义")
        ,DEDATASET("DEDATASET", "实体数据集合")
        ,ORG("ORG", "当前组织")
        ,PORG("PORG", "当前组织父组织")
        ,ORGSECTOR("ORGSECTOR", "当前部门")
        ,PORGSECTOR("PORGSECTOR", "当前部门父部门")
        ,ORGGROUP("ORGGROUP", "机构组")
        ,ORGSECTORGROUP("ORGSECTORGROUP", "部门组")
        ,ORGUSERGROUP("ORGUSERGROUP", "机构人员组")
        ,ORGSECTORUSERGROUP("ORGSECTORUSERGROUP", "部门人员组")
        ,ORGADMIN("ORGADMIN", "当前组织管理员")
        ,ORGSECTORADMIN("ORGSECTORADMIN", "当前部门管理员")
;
           
        public final String text;
        public final String value;
        
        private WFRoleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFRoleType from(String value){
            switch(value){
                case "USERGROUP":
                    return USERGROUP;
                case "SYSUSERROLE":
                    return SYSUSERROLE;
                case "CUSTOM":
                    return CUSTOM;
                case "DEDATASET":
                    return DEDATASET;
                case "ORG":
                    return ORG;
                case "PORG":
                    return PORG;
                case "ORGSECTOR":
                    return ORGSECTOR;
                case "PORGSECTOR":
                    return PORGSECTOR;
                case "ORGGROUP":
                    return ORGGROUP;
                case "ORGSECTORGROUP":
                    return ORGSECTORGROUP;
                case "ORGUSERGROUP":
                    return ORGUSERGROUP;
                case "ORGSECTORUSERGROUP":
                    return ORGSECTORUSERGROUP;
                case "ORGADMIN":
                    return ORGADMIN;
                case "ORGSECTORADMIN":
                    return ORGSECTORADMIN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件绘制器类型
     * <P>
     * <ul>
     * <li>LAYOUTPANEL
     * <P>
     * 布局面板
     * <li>LAYOUTPANEL_MODEL
     * <P>
     * 布局面板（模型）
     * <li>PFPLUGIN
     * <P>
     * 前端插件
     * </ul>     
     */
    public static enum ControlRenderType{
        LAYOUTPANEL("LAYOUTPANEL", "布局面板")
        ,LAYOUTPANEL_MODEL("LAYOUTPANEL_MODEL", "布局面板（模型）")
        ,PFPLUGIN("PFPLUGIN", "前端插件")
;
           
        public final String text;
        public final String value;
        
        private ControlRenderType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ControlRenderType from(String value){
            switch(value){
                case "LAYOUTPANEL":
                    return LAYOUTPANEL;
                case "LAYOUTPANEL_MODEL":
                    return LAYOUTPANEL_MODEL;
                case "PFPLUGIN":
                    return PFPLUGIN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体视图触发逻辑类型2
     * <P>
     * <ul>
     * <li>DEUILOGIC
     * <P>
     * 实体界面逻辑，实体定义的界面处理逻辑
     * <li>SYSVIEWLOGIC
     * <P>
     * 系统预置界面逻辑，系统定义的界面处理逻辑
     * <li>DEUIACTION
     * <P>
     * 界面行为，事件触发界面行为处理
     * <li>PFPLUGIN
     * <P>
     * 前端扩展插件，前端模板插件定义的直接代码逻辑
     * <li>SCRIPT
     * <P>
     * 脚本代码，运行时解释执行的脚本代码
     * <li>LAYOUTPANEL
     * <P>
     * 布局面板，指定绘制器部件面板
     * </ul>     
     */
    public static enum TargetUILogic{
        DEUILOGIC("DEUILOGIC", "实体界面逻辑")
        ,SYSVIEWLOGIC("SYSVIEWLOGIC", "系统预置界面逻辑")
        ,DEUIACTION("DEUIACTION", "界面行为")
        ,PFPLUGIN("PFPLUGIN", "前端扩展插件")
        ,SCRIPT("SCRIPT", "脚本代码")
        ,LAYOUTPANEL("LAYOUTPANEL", "布局面板")
;
           
        public final String text;
        public final String value;
        
        private TargetUILogic(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TargetUILogic from(String value){
            switch(value){
                case "DEUILOGIC":
                    return DEUILOGIC;
                case "SYSVIEWLOGIC":
                    return SYSVIEWLOGIC;
                case "DEUIACTION":
                    return DEUIACTION;
                case "PFPLUGIN":
                    return PFPLUGIN;
                case "SCRIPT":
                    return SCRIPT;
                case "LAYOUTPANEL":
                    return LAYOUTPANEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 显示更多模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>CONTENT&nbsp;(1)
     * <P>
     * 受控内容，成员作为显示更多的内容接受容器的管理
     * <li>MANAGE&nbsp;(2)
     * <P>
     * 管理容器，成员作为显示更多管理容器管理子成员的显示状态
     * </ul>     
     */
    public static enum FormDetailShowMoreMode{
        NONE(0, "无")
        ,CONTENT(1, "受控内容")
        ,MANAGE(2, "管理容器")
;
           
        public final String text;
        public final int value;
        
        private FormDetailShowMoreMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormDetailShowMoreMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return CONTENT;
                case 2:
                    return MANAGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云属性联合键值
     * <P>
     * <ul>
     * <li>KEY1
     * <P>
     * 联合键值1
     * <li>KEY2
     * <P>
     * 联合键值2
     * <li>KEY3
     * <P>
     * 联合键值3
     * <li>KEY4
     * <P>
     * 联合键值4
     * <li>KEY5
     * <P>
     * 联合键值5
     * <li>KEY6
     * <P>
     * 联合键值6
     * <li>KEY7
     * <P>
     * 联合键值7
     * <li>KEY8
     * <P>
     * 联合键值8
     * </ul>     
     */
    public static enum UnionKeyValueMode{
        KEY1("KEY1", "联合键值1")
        ,KEY2("KEY2", "联合键值2")
        ,KEY3("KEY3", "联合键值3")
        ,KEY4("KEY4", "联合键值4")
        ,KEY5("KEY5", "联合键值5")
        ,KEY6("KEY6", "联合键值6")
        ,KEY7("KEY7", "联合键值7")
        ,KEY8("KEY8", "联合键值8")
;
           
        public final String text;
        public final String value;
        
        private UnionKeyValueMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UnionKeyValueMode from(String value){
            switch(value){
                case "KEY1":
                    return KEY1;
                case "KEY2":
                    return KEY2;
                case "KEY3":
                    return KEY3;
                case "KEY4":
                    return KEY4;
                case "KEY5":
                    return KEY5;
                case "KEY6":
                    return KEY6;
                case "KEY7":
                    return KEY7;
                case "KEY8":
                    return KEY8;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统状态协同类型
     * <P>
     * <ul>
     * <li>DE
     * <P>
     * 实体
     * </ul>     
     */
    public static enum UniStateType{
        DE("DE", "实体")
;
           
        public final String text;
        public final String value;
        
        private UniStateType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UniStateType from(String value){
            switch(value){
                case "DE":
                    return DE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性组类型
     * <P>
     * <ul>
     * <li>FIELDS
     * <P>
     * 指定属性，指定具体的属性清单
     * <li>FORMITEMS
     * <P>
     * 表单项，指定编辑表单，从表单项中构建属性集合
     * <li>BASEFIELDS
     * <P>
     * 基础属性，指定属性组由基础的属性组成，包括主键、主信息、主状态相关属性、联合主键及存在预定模式的相关属性等
     * <li>AUDITFIELDS
     * <P>
     * 审计属性，指定属性组由启用审计的属性组成
     * </ul>     
     */
    public static enum DEFGroupType{
        FIELDS("FIELDS", "指定属性")
        ,FORMITEMS("FORMITEMS", "表单项")
        ,BASEFIELDS("BASEFIELDS", "基础属性")
        ,AUDITFIELDS("AUDITFIELDS", "审计属性")
;
           
        public final String text;
        public final String value;
        
        private DEFGroupType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFGroupType from(String value){
            switch(value){
                case "FIELDS":
                    return FIELDS;
                case "FORMITEMS":
                    return FORMITEMS;
                case "BASEFIELDS":
                    return BASEFIELDS;
                case "AUDITFIELDS":
                    return AUDITFIELDS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 服务API提供模式，数值项
     * <P>
     * <ul>
     * <li>NOTSUPPORTED&nbsp;(0)
     * <P>
     * 默认不提供
     * <li>SUPPORTED&nbsp;(1)
     * <P>
     * 默认提供
     * </ul>     
     */
    public static enum DEServiceAPIMode{
        NOTSUPPORTED(0, "默认不提供")
        ,SUPPORTED(1, "默认提供")
;
           
        public final String text;
        public final int value;
        
        private DEServiceAPIMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEServiceAPIMode from(int value){
            switch(value){
                case 0:
                    return NOTSUPPORTED;
                case 1:
                    return SUPPORTED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格列类型
     * <P>
     * <ul>
     * <li>DEFGRIDCOLUMN
     * <P>
     * 属性列，绑定属性数据的列
     * <li>UAGRIDCOLUMN
     * <P>
     * 操作列，为行数据提供操作能力的列
     * <li>GROUPGRIDCOLUMN
     * <P>
     * 属性分组列，包含表格列的列，提供列的分组功能
     * </ul>     
     */
    public static enum GridColType{
        DEFGRIDCOLUMN("DEFGRIDCOLUMN", "属性列")
        ,UAGRIDCOLUMN("UAGRIDCOLUMN", "操作列")
        ,GROUPGRIDCOLUMN("GROUPGRIDCOLUMN", "属性分组列")
;
           
        public final String text;
        public final String value;
        
        private GridColType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColType from(String value){
            switch(value){
                case "DEFGRIDCOLUMN":
                    return DEFGRIDCOLUMN;
                case "UAGRIDCOLUMN":
                    return UAGRIDCOLUMN;
                case "GROUPGRIDCOLUMN":
                    return GROUPGRIDCOLUMN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程超时类型
     * <P>
     * <ul>
     * <li>MINUTE
     * <P>
     * 分钟
     * <li>HOUR
     * <P>
     * 小时
     * <li>DAY
     * <P>
     * 天，超时单位为自然日
     * <li>WORKDAY
     * <P>
     * 工作日，超时单位为工作日，需额外指定工作日规则
     * </ul>     
     */
    public static enum WFTimeoutType{
        MINUTE("MINUTE", "分钟")
        ,HOUR("HOUR", "小时")
        ,DAY("DAY", "天")
        ,WORKDAY("WORKDAY", "工作日")
;
           
        public final String text;
        public final String value;
        
        private WFTimeoutType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFTimeoutType from(String value){
            switch(value){
                case "MINUTE":
                    return MINUTE;
                case "HOUR":
                    return HOUR;
                case "DAY":
                    return DAY;
                case "WORKDAY":
                    return WORKDAY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体界面行为触发逻辑类型
     * <P>
     * <ul>
     * <li>DEUILOGIC
     * <P>
     * 实体界面逻辑，实体界面逻辑
     * <li>SYSVIEWLOGIC
     * <P>
     * 系统界面逻辑，系统预置的界面逻辑
     * </ul>     
     */
    public static enum UIActionTargetUILogic{
        DEUILOGIC("DEUILOGIC", "实体界面逻辑")
        ,SYSVIEWLOGIC("SYSVIEWLOGIC", "系统界面逻辑")
;
           
        public final String text;
        public final String value;
        
        private UIActionTargetUILogic(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionTargetUILogic from(String value){
            switch(value){
                case "DEUILOGIC":
                    return DEUILOGIC;
                case "SYSVIEWLOGIC":
                    return SYSVIEWLOGIC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体动态系统模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 不启用
     * <li>ENABLED&nbsp;(1)
     * <P>
     * 启用（默认）
     * <li>SYSTEM&nbsp;(2)
     * <P>
     * 启用（系统），使用系统全局动态扩展，附属实体依附父实体
     * <li>MODELGROUP&nbsp;(3)
     * <P>
     * 启用（系统模型组），使用系统模型组扩展，附属实体依附父实体
     * <li>MODULE&nbsp;(4)
     * <P>
     * 启用（系统模块），使用系统模块扩展，附属实体依附父实体
     * <li>DATAENTITY&nbsp;(5)
     * <P>
     * 启用（实体），每个实体提供独立的动态系统能力，附属实体依附父实体
     * <li>DATA&nbsp;(99)
     * <P>
     * 启用（行数据），为行数据提供动态系统能力，附属实体依附父数据
     * </ul>     
     */
    public static enum DEDynaSysMode{
        DISABLED(0, "不启用")
        ,ENABLED(1, "启用（默认）")
        ,SYSTEM(2, "启用（系统）")
        ,MODELGROUP(3, "启用（系统模型组）")
        ,MODULE(4, "启用（系统模块）")
        ,DATAENTITY(5, "启用（实体）")
        ,DATA(99, "启用（行数据）")
;
           
        public final String text;
        public final int value;
        
        private DEDynaSysMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDynaSysMode from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return ENABLED;
                case 2:
                    return SYSTEM;
                case 3:
                    return MODELGROUP;
                case 4:
                    return MODULE;
                case 5:
                    return DATAENTITY;
                case 99:
                    return DATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体操作标识角色类型
     * <P>
     * <ul>
     * <li>SYSROLE
     * <P>
     * 系统角色，系统的操作用户角色
     * <li>DEROLE
     * <P>
     * 实体角色，当前实体的操作用户角色
     * </ul>     
     */
    public static enum DEOPPrivRoleType{
        SYSROLE("SYSROLE", "系统角色")
        ,DEROLE("DEROLE", "实体角色")
;
           
        public final String text;
        public final String value;
        
        private DEOPPrivRoleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEOPPrivRoleType from(String value){
            switch(value){
                case "SYSROLE":
                    return SYSROLE;
                case "DEROLE":
                    return DEROLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体图表饼图展示南丁格尔图模式
     * <P>
     * <ul>
     * <li>TRUE&nbsp;(true)
     * <P>
     * 是
     * <li>FALSE&nbsp;(false)
     * <P>
     * 否
     * <li>RADIUS&nbsp;(radius)
     * <P>
     * 圆心角及半径，扇区圆心角展现数据的百分比，半径展现数据的大小
     * <li>AREA&nbsp;(area)
     * <P>
     * 仅半径，所有扇区圆心角相同，仅通过半径展现数据大小
     * </ul>     
     */
    public static enum ChartPieRoseType{
        TRUE("true", "是")
        ,FALSE("false", "否")
        ,RADIUS("radius", "圆心角及半径")
        ,AREA("area", "仅半径")
;
           
        public final String text;
        public final String value;
        
        private ChartPieRoseType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartPieRoseType from(String value){
            switch(value){
                case "true":
                    return TRUE;
                case "false":
                    return FALSE;
                case "radius":
                    return RADIUS;
                case "area":
                    return AREA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理类型
     * <P>
     * <ul>
     * <li>START
     * <P>
     * 开始，流程的开始处理节点，一个流程只允许拥有一个开始处理节点，流程启动时将默认进入该节点
     * <li>END
     * <P>
     * 结束，流程的结束处理节点，一个流程允许拥有多个开始处理节点，进入该节点意味流程结束
     * <li>PROCESS
     * <P>
     * 常规处理，流程的功能处理节点，配置调用的实体行为，再通过实体行为完成相应的操作。独立运行的工作流引擎将会回调实体服务接口的方法完成功能
     * <li>INTERACTIVE
     * <P>
     * 交互处理，流程中的用户交互处理节点，进入该节点时流程挂起，需满足相应的条件（用户操作完成）才进入后续处理
     * <li>EMBED
     * <P>
     * 嵌套子流程，流程中的子流程交互处理节点，进入该节点时流程挂起，需满足相应的条件（子流程完成）才进入后续处理
     * <li>PARALLELGATEWAY
     * <P>
     * 并行网关
     * <li>EXCLUSIVEGATEWAY
     * <P>
     * 排它网关
     * <li>INCLUSIVEGATEWAY
     * <P>
     * 包容网关
     * <li>TIMEREVENT
     * <P>
     * 定时触发
     * <li>CALLORGACTIVITY
     * <P>
     * 调用组织流程
     * </ul>     
     */
    public static enum WFProcessType{
        START("START", "开始")
        ,END("END", "结束")
        ,PROCESS("PROCESS", "常规处理")
        ,INTERACTIVE("INTERACTIVE", "交互处理")
        ,EMBED("EMBED", "嵌套子流程")
        ,PARALLELGATEWAY("PARALLELGATEWAY", "并行网关")
        ,EXCLUSIVEGATEWAY("EXCLUSIVEGATEWAY", "排它网关")
        ,INCLUSIVEGATEWAY("INCLUSIVEGATEWAY", "包容网关")
        ,TIMEREVENT("TIMEREVENT", "定时触发")
        ,CALLORGACTIVITY("CALLORGACTIVITY", "调用组织流程")
;
           
        public final String text;
        public final String value;
        
        private WFProcessType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProcessType from(String value){
            switch(value){
                case "START":
                    return START;
                case "END":
                    return END;
                case "PROCESS":
                    return PROCESS;
                case "INTERACTIVE":
                    return INTERACTIVE;
                case "EMBED":
                    return EMBED;
                case "PARALLELGATEWAY":
                    return PARALLELGATEWAY;
                case "EXCLUSIVEGATEWAY":
                    return EXCLUSIVEGATEWAY;
                case "INCLUSIVEGATEWAY":
                    return INCLUSIVEGATEWAY;
                case "TIMEREVENT":
                    return TIMEREVENT;
                case "CALLORGACTIVITY":
                    return CALLORGACTIVITY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑参数文件类型
     * <P>
     * <ul>
     * <li>TEMP
     * <P>
     * 本地临时文件
     * <li>URL
     * <P>
     * 远程文件（Url）
     * <li>STORAGESERVICE
     * <P>
     * 存储服务，本地存储或使用远程存储服务存储
     * </ul>     
     */
    public static enum DELogicParamFileType{
        TEMP("TEMP", "本地临时文件")
        ,URL("URL", "远程文件（Url）")
        ,STORAGESERVICE("STORAGESERVICE", "存储服务")
;
           
        public final String text;
        public final String value;
        
        private DELogicParamFileType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicParamFileType from(String value){
            switch(value){
                case "TEMP":
                    return TEMP;
                case "URL":
                    return URL;
                case "STORAGESERVICE":
                    return STORAGESERVICE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台移动端流程编辑视图类型
     * <P>
     * <ul>
     * <li>DEMOBWFEDITVIEW
     * <P>
     * 实体移动端工作流编辑视图
     * <li>DEMOBWFEDITVIEW3
     * <P>
     * 实体移动端工作流视图（分页关系）
     * </ul>     
     */
    public static enum DEMobWFEditViewType{
        DEMOBWFEDITVIEW("DEMOBWFEDITVIEW", "实体移动端工作流编辑视图")
        ,DEMOBWFEDITVIEW3("DEMOBWFEDITVIEW3", "实体移动端工作流视图（分页关系）")
;
           
        public final String text;
        public final String value;
        
        private DEMobWFEditViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMobWFEditViewType from(String value){
            switch(value){
                case "DEMOBWFEDITVIEW":
                    return DEMOBWFEDITVIEW;
                case "DEMOBWFEDITVIEW3":
                    return DEMOBWFEDITVIEW3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 大数据表列添加模式，数值项
     * <P>
     * <ul>
     * <li>MANUAL&nbsp;(0)
     * <P>
     * 手动添加
     * <li>AUTO_EXCLUDE&nbsp;(1)
     * <P>
     * 自动添加（排除指定）
     * <li>AUTO_INCLUDE&nbsp;(2)
     * <P>
     * 自动添加（选择指定）
     * </ul>     
     */
    public static enum BDTableColMode{
        MANUAL(0, "手动添加")
        ,AUTO_EXCLUDE(1, "自动添加（排除指定）")
        ,AUTO_INCLUDE(2, "自动添加（选择指定）")
;
           
        public final String text;
        public final int value;
        
        private BDTableColMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static BDTableColMode from(int value){
            switch(value){
                case 0:
                    return MANUAL;
                case 1:
                    return AUTO_EXCLUDE;
                case 2:
                    return AUTO_INCLUDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用视图优先权，数值项
     * <P>
     * <ul>
     * <li>DEFAULT&nbsp;(-1)
     * <P>
     * 未定义
     * <li>LEVEL_10&nbsp;(10)
     * <P>
     * 一级
     * <li>LEVEL_20&nbsp;(20)
     * <P>
     * 二级
     * <li>LEVEL_30&nbsp;(30)
     * <P>
     * 三级
     * <li>LEVEL_40&nbsp;(40)
     * <P>
     * 四级
     * <li>LEVEL_50&nbsp;(50)
     * <P>
     * 五级
     * <li>LEVEL_60&nbsp;(60)
     * <P>
     * 六级
     * <li>LEVEL_70&nbsp;(70)
     * <P>
     * 七级
     * <li>LEVEL_80&nbsp;(80)
     * <P>
     * 八级
     * <li>LEVEL_90&nbsp;(90)
     * <P>
     * 九级
     * <li>LEVEL_100&nbsp;(100)
     * <P>
     * 十级
     * </ul>     
     */
    public static enum AppViewPriority{
        DEFAULT(-1, "未定义")
        ,LEVEL_10(10, "一级")
        ,LEVEL_20(20, "二级")
        ,LEVEL_30(30, "三级")
        ,LEVEL_40(40, "四级")
        ,LEVEL_50(50, "五级")
        ,LEVEL_60(60, "六级")
        ,LEVEL_70(70, "七级")
        ,LEVEL_80(80, "八级")
        ,LEVEL_90(90, "九级")
        ,LEVEL_100(100, "十级")
;
           
        public final String text;
        public final int value;
        
        private AppViewPriority(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppViewPriority from(int value){
            switch(value){
                case -1:
                    return DEFAULT;
                case 10:
                    return LEVEL_10;
                case 20:
                    return LEVEL_20;
                case 30:
                    return LEVEL_30;
                case 40:
                    return LEVEL_40;
                case 50:
                    return LEVEL_50;
                case 60:
                    return LEVEL_60;
                case 70:
                    return LEVEL_70;
                case 80:
                    return LEVEL_80;
                case 90:
                    return LEVEL_90;
                case 100:
                    return LEVEL_100;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台部件类型
     * <P>
     * <ul>
     * <li>TOOLBAR
     * <P>
     * 工具栏
     * <li>GRID
     * <P>
     * 数据表格
     * <li>FORM
     * <P>
     * 编辑表单
     * <li>SEARCHFORM
     * <P>
     * 搜索表单
     * <li>DRBAR
     * <P>
     * 数据关系栏
     * <li>VIEWPANEL
     * <P>
     * 单视图面板
     * <li>PICKUPVIEWPANEL
     * <P>
     * 选择视图面板
     * <li>DATAVIEW
     * <P>
     * 数据视图
     * <li>TREEGRID
     * <P>
     * 数据树表格
     * <li>WFEXPBAR
     * <P>
     * 流程导航栏
     * <li>TREEVIEW
     * <P>
     * 树视图
     * <li>TREEEXPBAR
     * <P>
     * 树视图导航栏
     * <li>TABVIEWPANEL
     * <P>
     * 分页视图面板
     * <li>DRTAB
     * <P>
     * 数据关系分页部件
     * <li>CHART
     * <P>
     * 数据图表
     * <li>REPORTPANEL
     * <P>
     * 报表面板
     * <li>LIST
     * <P>
     * 列表
     * <li>MOBMDCTRL
     * <P>
     * 移动端多数据视图
     * <li>MULTIEDITVIEWPANEL
     * <P>
     * 多编辑视图面板
     * <li>WIZARDPANEL
     * <P>
     * 向导面板
     * <li>UPDATEPANEL
     * <P>
     * 更新面板
     * <li>SEARCHBAR
     * <P>
     * 搜索栏
     * <li>DASHBOARD
     * <P>
     * 数据看板
     * <li>CALENDAR
     * <P>
     * 日历部件
     * <li>PANEL
     * <P>
     * 面板部件
     * <li>MAP
     * <P>
     * 地图部件
     * <li>GANTT
     * <P>
     * 甘特部件
     * <li>TREEGRIDEX
     * <P>
     * 树表格（增强）
     * <li>KANBAN
     * <P>
     * 看板
     * <li>CALENDAREXPBAR
     * <P>
     * 日历视图导航栏
     * <li>CHARTEXPBAR
     * <P>
     * 图表视图导航栏
     * <li>DATAVIEWEXPBAR
     * <P>
     * 卡片视图导航栏
     * <li>GANTTEXPBAR
     * <P>
     * 甘特视图导航栏
     * <li>GRIDEXPBAR
     * <P>
     * 表格视图导航栏
     * <li>LISTEXPBAR
     * <P>
     * 列表视图导航栏
     * <li>MAPEXPBAR
     * <P>
     * 地图视图导航栏
     * <li>STATEWIZARDPANEL
     * <P>
     * 状态向导面板
     * <li>APPMENU
     * <P>
     * 应用菜单
     * <li>TABEXPPANEL
     * <P>
     * 分页导航面板
     * <li>CUSTOM
     * <P>
     * 自定义部件
     * </ul>     
     */
    public static enum CtrlType{
        TOOLBAR("TOOLBAR", "工具栏")
        ,GRID("GRID", "数据表格")
        ,FORM("FORM", "编辑表单")
        ,SEARCHFORM("SEARCHFORM", "搜索表单")
        ,DRBAR("DRBAR", "数据关系栏")
        ,VIEWPANEL("VIEWPANEL", "单视图面板")
        ,PICKUPVIEWPANEL("PICKUPVIEWPANEL", "选择视图面板")
        ,DATAVIEW("DATAVIEW", "数据视图")
        ,TREEGRID("TREEGRID", "数据树表格")
        ,WFEXPBAR("WFEXPBAR", "流程导航栏")
        ,TREEVIEW("TREEVIEW", "树视图")
        ,TREEEXPBAR("TREEEXPBAR", "树视图导航栏")
        ,TABVIEWPANEL("TABVIEWPANEL", "分页视图面板")
        ,DRTAB("DRTAB", "数据关系分页部件")
        ,CHART("CHART", "数据图表")
        ,REPORTPANEL("REPORTPANEL", "报表面板")
        ,LIST("LIST", "列表")
        ,MOBMDCTRL("MOBMDCTRL", "移动端多数据视图")
        ,MULTIEDITVIEWPANEL("MULTIEDITVIEWPANEL", "多编辑视图面板")
        ,WIZARDPANEL("WIZARDPANEL", "向导面板")
        ,UPDATEPANEL("UPDATEPANEL", "更新面板")
        ,SEARCHBAR("SEARCHBAR", "搜索栏")
        ,DASHBOARD("DASHBOARD", "数据看板")
        ,CALENDAR("CALENDAR", "日历部件")
        ,PANEL("PANEL", "面板部件")
        ,MAP("MAP", "地图部件")
        ,GANTT("GANTT", "甘特部件")
        ,TREEGRIDEX("TREEGRIDEX", "树表格（增强）")
        ,KANBAN("KANBAN", "看板")
        ,CALENDAREXPBAR("CALENDAREXPBAR", "日历视图导航栏")
        ,CHARTEXPBAR("CHARTEXPBAR", "图表视图导航栏")
        ,DATAVIEWEXPBAR("DATAVIEWEXPBAR", "卡片视图导航栏")
        ,GANTTEXPBAR("GANTTEXPBAR", "甘特视图导航栏")
        ,GRIDEXPBAR("GRIDEXPBAR", "表格视图导航栏")
        ,LISTEXPBAR("LISTEXPBAR", "列表视图导航栏")
        ,MAPEXPBAR("MAPEXPBAR", "地图视图导航栏")
        ,STATEWIZARDPANEL("STATEWIZARDPANEL", "状态向导面板")
        ,APPMENU("APPMENU", "应用菜单")
        ,TABEXPPANEL("TABEXPPANEL", "分页导航面板")
        ,CUSTOM("CUSTOM", "自定义部件")
;
           
        public final String text;
        public final String value;
        
        private CtrlType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlType from(String value){
            switch(value){
                case "TOOLBAR":
                    return TOOLBAR;
                case "GRID":
                    return GRID;
                case "FORM":
                    return FORM;
                case "SEARCHFORM":
                    return SEARCHFORM;
                case "DRBAR":
                    return DRBAR;
                case "VIEWPANEL":
                    return VIEWPANEL;
                case "PICKUPVIEWPANEL":
                    return PICKUPVIEWPANEL;
                case "DATAVIEW":
                    return DATAVIEW;
                case "TREEGRID":
                    return TREEGRID;
                case "WFEXPBAR":
                    return WFEXPBAR;
                case "TREEVIEW":
                    return TREEVIEW;
                case "TREEEXPBAR":
                    return TREEEXPBAR;
                case "TABVIEWPANEL":
                    return TABVIEWPANEL;
                case "DRTAB":
                    return DRTAB;
                case "CHART":
                    return CHART;
                case "REPORTPANEL":
                    return REPORTPANEL;
                case "LIST":
                    return LIST;
                case "MOBMDCTRL":
                    return MOBMDCTRL;
                case "MULTIEDITVIEWPANEL":
                    return MULTIEDITVIEWPANEL;
                case "WIZARDPANEL":
                    return WIZARDPANEL;
                case "UPDATEPANEL":
                    return UPDATEPANEL;
                case "SEARCHBAR":
                    return SEARCHBAR;
                case "DASHBOARD":
                    return DASHBOARD;
                case "CALENDAR":
                    return CALENDAR;
                case "PANEL":
                    return PANEL;
                case "MAP":
                    return MAP;
                case "GANTT":
                    return GANTT;
                case "TREEGRIDEX":
                    return TREEGRIDEX;
                case "KANBAN":
                    return KANBAN;
                case "CALENDAREXPBAR":
                    return CALENDAREXPBAR;
                case "CHARTEXPBAR":
                    return CHARTEXPBAR;
                case "DATAVIEWEXPBAR":
                    return DATAVIEWEXPBAR;
                case "GANTTEXPBAR":
                    return GANTTEXPBAR;
                case "GRIDEXPBAR":
                    return GRIDEXPBAR;
                case "LISTEXPBAR":
                    return LISTEXPBAR;
                case "MAPEXPBAR":
                    return MAPEXPBAR;
                case "STATEWIZARDPANEL":
                    return STATEWIZARDPANEL;
                case "APPMENU":
                    return APPMENU;
                case "TABEXPPANEL":
                    return TABEXPPANEL;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 边界布局位置
     * <P>
     * <ul>
     * <li>NORTH
     * <P>
     * 上方
     * <li>WEST
     * <P>
     * 左侧
     * <li>EAST
     * <P>
     * 右侧
     * <li>SOUTH
     * <P>
     * 下方
     * <li>CENTER
     * <P>
     * 中间
     * </ul>     
     */
    public static enum BorderLayoutPos{
        NORTH("NORTH", "上方")
        ,WEST("WEST", "左侧")
        ,EAST("EAST", "右侧")
        ,SOUTH("SOUTH", "下方")
        ,CENTER("CENTER", "中间")
;
           
        public final String text;
        public final String value;
        
        private BorderLayoutPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BorderLayoutPos from(String value){
            switch(value){
                case "NORTH":
                    return NORTH;
                case "WEST":
                    return WEST;
                case "EAST":
                    return EAST;
                case "SOUTH":
                    return SOUTH;
                case "CENTER":
                    return CENTER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统视图样式名称附加模式
     * <P>
     * <ul>
     * <li>APPEND
     * <P>
     * 名称附加，视图样式标记将附加发布的视图名称后面
     * <li>REPLACE
     * <P>
     * 名称替换，视图样式标记将替换发布的视图名称
     * </ul>     
     */
    public static enum SubViewTypeNameMode{
        APPEND("APPEND", "名称附加")
        ,REPLACE("REPLACE", "名称替换")
;
           
        public final String text;
        public final String value;
        
        private SubViewTypeNameMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubViewTypeNameMode from(String value){
            switch(value){
                case "APPEND":
                    return APPEND;
                case "REPLACE":
                    return REPLACE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索引擎类型
     * <P>
     * <ul>
     * <li>ELASTICSEARCH
     * <P>
     * ElasticSearch
     * <li>SOLR
     * <P>
     * Solr
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum SearchEngineType{
        ELASTICSEARCH("ELASTICSEARCH", "ElasticSearch")
        ,SOLR("SOLR", "Solr")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private SearchEngineType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchEngineType from(String value){
            switch(value){
                case "ELASTICSEARCH":
                    return ELASTICSEARCH;
                case "SOLR":
                    return SOLR;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云树视图节点类型
     * <P>
     * <ul>
     * <li>STATIC
     * <P>
     * 静态，静态定义的树节点
     * <li>DE
     * <P>
     * 动态（实体），从实体数据集加载的动态树节点
     * <li>CODELIST
     * <P>
     * 动态（代码表），从代码表加载的动态树节点
     * </ul>     
     */
    public static enum TreeNodeType{
        STATIC("STATIC", "静态")
        ,DE("DE", "动态（实体）")
        ,CODELIST("CODELIST", "动态（代码表）")
;
           
        public final String text;
        public final String value;
        
        private TreeNodeType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeType from(String value){
            switch(value){
                case "STATIC":
                    return STATIC;
                case "DE":
                    return DE;
                case "CODELIST":
                    return CODELIST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 直接内容类型
     * <P>
     * <ul>
     * <li>RAW
     * <P>
     * 直接内容，内容为直接文本
     * <li>HTML
     * <P>
     * Html内容，内容为HTML文本
     * <li>IMAGE
     * <P>
     * 图片，内容为图片对象
     * <li>MARKDOWN
     * <P>
     * Markdown
     * <li>VIDEO
     * <P>
     * 视频
     * <li>PLACEHOLDER
     * <P>
     * 占位
     * <li>DIVIDER
     * <P>
     * 分割线
     * <li>INFO
     * <P>
     * 常规提示
     * <li>WARNING
     * <P>
     * 警告提示
     * <li>ERROR
     * <P>
     * 错误提示
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum RawItemContentType{
        RAW("RAW", "直接内容")
        ,HTML("HTML", "Html内容")
        ,IMAGE("IMAGE", "图片")
        ,MARKDOWN("MARKDOWN", "Markdown")
        ,VIDEO("VIDEO", "视频")
        ,PLACEHOLDER("PLACEHOLDER", "占位")
        ,DIVIDER("DIVIDER", "分割线")
        ,INFO("INFO", "常规提示")
        ,WARNING("WARNING", "警告提示")
        ,ERROR("ERROR", "错误提示")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private RawItemContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static RawItemContentType from(String value){
            switch(value){
                case "RAW":
                    return RAW;
                case "HTML":
                    return HTML;
                case "IMAGE":
                    return IMAGE;
                case "MARKDOWN":
                    return MARKDOWN;
                case "VIDEO":
                    return VIDEO;
                case "PLACEHOLDER":
                    return PLACEHOLDER;
                case "DIVIDER":
                    return DIVIDER;
                case "INFO":
                    return INFO;
                case "WARNING":
                    return WARNING;
                case "ERROR":
                    return ERROR;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 通知子类
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>EVENTHOOK
     * <P>
     * 事件处理（运行时支持）
     * <li>FIELDCHANGEHOOK
     * <P>
     * 属性值变化处理（运行时支持）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum NotifySubType{
        NONE("NONE", "无")
        ,EVENTHOOK("EVENTHOOK", "事件处理（运行时支持）")
        ,FIELDCHANGEHOOK("FIELDCHANGEHOOK", "属性值变化处理（运行时支持）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private NotifySubType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static NotifySubType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "EVENTHOOK":
                    return EVENTHOOK;
                case "FIELDCHANGEHOOK":
                    return FIELDCHANGEHOOK;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体界面行为_操作数据范围
     * <P>
     * <ul>
     * <li>SINGLEDATA
     * <P>
     * 单项数据，界面上的单个数据（表单等单数据界面为当前界面数据，表格等多数据界面为第一个选中数据），以对象的形式传参
     * <li>SINGLEKEY
     * <P>
     * 单项数据（主键），界面上的单个数据主键（表单等单数据界面为当前界面数据主键，表格等多数据界面为第一个选中数据主键），以字符串的形式传参
     * <li>MULTIDATA
     * <P>
     * 多项数据，界面上的多个数据（表单等单数据界面为当前界面数据，表格等多数据界面为选中数据），以对象数组的形式传参
     * <li>MULTIKEY
     * <P>
     * 多项数据（主键），界面上的多个数据主键（表单等单数据界面为当前界面数据主键，表格等多数据界面为选中数据主键），以带分隔符【;】字符串的形式传参
     * <li>NONE
     * <P>
     * 无数据，无目标数据，一般为处理逻辑根据上下文环境自行计算操作参数
     * </ul>     
     */
    public static enum UIActionTarget{
        SINGLEDATA("SINGLEDATA", "单项数据")
        ,SINGLEKEY("SINGLEKEY", "单项数据（主键）")
        ,MULTIDATA("MULTIDATA", "多项数据")
        ,MULTIKEY("MULTIKEY", "多项数据（主键）")
        ,NONE("NONE", "无数据")
;
           
        public final String text;
        public final String value;
        
        private UIActionTarget(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionTarget from(String value){
            switch(value){
                case "SINGLEDATA":
                    return SINGLEDATA;
                case "SINGLEKEY":
                    return SINGLEKEY;
                case "MULTIDATA":
                    return MULTIDATA;
                case "MULTIKEY":
                    return MULTIKEY;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 外部接口对象属性预定义类型
     * <P>
     * <ul>
     * <li>RETCODE
     * <P>
     * 返回代码
     * <li>RETDATA
     * <P>
     * 返回数据
     * <li>RETINFO
     * <P>
     * 返回信息
     * <li>RETSUCCESS
     * <P>
     * 返回成功标志
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SubSysSADEFieldPredefinedType{
        RETCODE("RETCODE", "返回代码")
        ,RETDATA("RETDATA", "返回数据")
        ,RETINFO("RETINFO", "返回信息")
        ,RETSUCCESS("RETSUCCESS", "返回成功标志")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SubSysSADEFieldPredefinedType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysSADEFieldPredefinedType from(String value){
            switch(value){
                case "RETCODE":
                    return RETCODE;
                case "RETDATA":
                    return RETDATA;
                case "RETINFO":
                    return RETINFO;
                case "RETSUCCESS":
                    return RETSUCCESS;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息动态模式，数值项
     * <P>
     * <ul>
     * <li>STATIC&nbsp;(0)
     * <P>
     * 静态内容
     * <li>DEDATASET&nbsp;(1)
     * <P>
     * 实体数据集，从实体数据集获取视图消息
     * </ul>     
     */
    public static enum ViewMsgDynamicMode{
        STATIC(0, "静态内容")
        ,DEDATASET(1, "实体数据集")
;
           
        public final String text;
        public final int value;
        
        private ViewMsgDynamicMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgDynamicMode from(int value){
            switch(value){
                case 0:
                    return STATIC;
                case 1:
                    return DEDATASET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性输入提示模式
     * <P>
     * <ul>
     * <li>MODE1
     * <P>
     * 模式1
     * <li>MODE2
     * <P>
     * 模式2
     * <li>MODE3
     * <P>
     * 模式3
     * <li>MODE4
     * <P>
     * 模式4
     * <li>MODE5
     * <P>
     * 模式5
     * <li>MODE6
     * <P>
     * 模式6
     * <li>MODE7
     * <P>
     * 模式7
     * <li>MODE8
     * <P>
     * 模式8
     * <li>MODE9
     * <P>
     * 模式9
     * </ul>     
     */
    public static enum DEFInputTipMode{
        MODE1("MODE1", "模式1")
        ,MODE2("MODE2", "模式2")
        ,MODE3("MODE3", "模式3")
        ,MODE4("MODE4", "模式4")
        ,MODE5("MODE5", "模式5")
        ,MODE6("MODE6", "模式6")
        ,MODE7("MODE7", "模式7")
        ,MODE8("MODE8", "模式8")
        ,MODE9("MODE9", "模式9")
;
           
        public final String text;
        public final String value;
        
        private DEFInputTipMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFInputTipMode from(String value){
            switch(value){
                case "MODE1":
                    return MODE1;
                case "MODE2":
                    return MODE2;
                case "MODE3":
                    return MODE3;
                case "MODE4":
                    return MODE4;
                case "MODE5":
                    return MODE5;
                case "MODE6":
                    return MODE6;
                case "MODE7":
                    return MODE7;
                case "MODE8":
                    return MODE8;
                case "MODE9":
                    return MODE9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体集合返回值类型
     * <P>
     * <ul>
     * <li>PAGE
     * <P>
     * 查询分页结果（Page）
     * <li>ENTITY
     * <P>
     * 数据对象（Entity）
     * <li>ENTITIES
     * <P>
     * 数据对象数组（Entity[]）
     * <li>ASYNCACTION
     * <P>
     * 异步操作对象
     * <li>USER
     * <P>
     * 用户自定义（USER）
     * <li>USER2
     * <P>
     * 用户自定义2（USER2）
     * </ul>     
     */
    public static enum DEDataSetRetType{
        PAGE("PAGE", "查询分页结果（Page）")
        ,ENTITY("ENTITY", "数据对象（Entity）")
        ,ENTITIES("ENTITIES", "数据对象数组（Entity[]）")
        ,ASYNCACTION("ASYNCACTION", "异步操作对象")
        ,USER("USER", "用户自定义（USER）")
        ,USER2("USER2", "用户自定义2（USER2）")
;
           
        public final String text;
        public final String value;
        
        private DEDataSetRetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataSetRetType from(String value){
            switch(value){
                case "PAGE":
                    return PAGE;
                case "ENTITY":
                    return ENTITY;
                case "ENTITIES":
                    return ENTITIES;
                case "ASYNCACTION":
                    return ASYNCACTION;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表格列样式（界面行为列）
     * <P>
     * <ul>
     * <li>EXPAND
     * <P>
     * 展开模式
     * <li>MENU
     * <P>
     * 菜单模式
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum GridColStype{
        EXPAND("EXPAND", "展开模式")
        ,MENU("MENU", "菜单模式")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private GridColStype(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColStype from(String value){
            switch(value){
                case "EXPAND":
                    return EXPAND;
                case "MENU":
                    return MENU;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统消息队列类型
     * <P>
     * <ul>
     * <li>RUNTIME
     * <P>
     * Runtime
     * <li>DE
     * <P>
     * 实体
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum MsgQueueType{
        RUNTIME("RUNTIME", "Runtime")
        ,DE("DE", "实体")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private MsgQueueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MsgQueueType from(String value){
            switch(value){
                case "RUNTIME":
                    return RUNTIME;
                case "DE":
                    return DE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 逻辑子类
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>DEFIELD
     * <P>
     * 属性逻辑，面向属性的处理逻辑子类型，
     * <li>ATTACHTODEACTION
     * <P>
     * 附加到行为（运行时支持），附加到指定行为
     * <li>ATTACHTODEDATASET
     * <P>
     * 附加到数据集（运行时支持），附加到指定数据集
     * <li>WEBHOOK
     * <P>
     * WebHook（运行时支持），WEB钩子
     * <li>TIMERTASK
     * <P>
     * 定时作业（运行时支持），后台定时作业
     * <li>EVENTHOOK
     * <P>
     * 事件处理（运行时支持）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum LogicSubType{
        NONE("NONE", "无")
        ,DEFIELD("DEFIELD", "属性逻辑")
        ,ATTACHTODEACTION("ATTACHTODEACTION", "附加到行为（运行时支持）")
        ,ATTACHTODEDATASET("ATTACHTODEDATASET", "附加到数据集（运行时支持）")
        ,WEBHOOK("WEBHOOK", "WebHook（运行时支持）")
        ,TIMERTASK("TIMERTASK", "定时作业（运行时支持）")
        ,EVENTHOOK("EVENTHOOK", "事件处理（运行时支持）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private LogicSubType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LogicSubType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "DEFIELD":
                    return DEFIELD;
                case "ATTACHTODEACTION":
                    return ATTACHTODEACTION;
                case "ATTACHTODEDATASET":
                    return ATTACHTODEDATASET;
                case "WEBHOOK":
                    return WEBHOOK;
                case "TIMERTASK":
                    return TIMERTASK;
                case "EVENTHOOK":
                    return EVENTHOOK;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 开发系统类型
     * <P>
     * <ul>
     * <li>DEVSYS
     * <P>
     * 默认
     * <li>DEVSYS_PSMODELTOOL
     * <P>
     * 模型工具扩展
     * <li>DEVSYS_WORKFLOW
     * <P>
     * 工作流扩展
     * <li>DEVSYS_APP
     * <P>
     * 应用开发系统
     * <li>DEVSYS_SVR
     * <P>
     * 服务开发系统
     * <li>DEVSYS_DEPLOY
     * <P>
     * 运行开发系统
     * </ul>     
     */
    public static enum DevSysType{
        DEVSYS("DEVSYS", "默认")
        ,DEVSYS_PSMODELTOOL("DEVSYS_PSMODELTOOL", "模型工具扩展")
        ,DEVSYS_WORKFLOW("DEVSYS_WORKFLOW", "工作流扩展")
        ,DEVSYS_APP("DEVSYS_APP", "应用开发系统")
        ,DEVSYS_SVR("DEVSYS_SVR", "服务开发系统")
        ,DEVSYS_DEPLOY("DEVSYS_DEPLOY", "运行开发系统")
;
           
        public final String text;
        public final String value;
        
        private DevSysType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DevSysType from(String value){
            switch(value){
                case "DEVSYS":
                    return DEVSYS;
                case "DEVSYS_PSMODELTOOL":
                    return DEVSYS_PSMODELTOOL;
                case "DEVSYS_WORKFLOW":
                    return DEVSYS_WORKFLOW;
                case "DEVSYS_APP":
                    return DEVSYS_APP;
                case "DEVSYS_SVR":
                    return DEVSYS_SVR;
                case "DEVSYS_DEPLOY":
                    return DEVSYS_DEPLOY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据集合缓存范围
     * <P>
     * <ul>
     * <li>GLOBAL
     * <P>
     * 全局，全局使用同一个缓存
     * <li>ORG
     * <P>
     * 组织，当前组织使用同一个缓存
     * <li>USER
     * <P>
     * 用户，每个用户维持自己专有的缓存
     * </ul>     
     */
    public static enum DECacheScope{
        GLOBAL("GLOBAL", "全局")
        ,ORG("ORG", "组织")
        ,USER("USER", "用户")
;
           
        public final String text;
        public final String value;
        
        private DECacheScope(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DECacheScope from(String value){
            switch(value){
                case "GLOBAL":
                    return GLOBAL;
                case "ORG":
                    return ORG;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统服务接口类型
     * <P>
     * <ul>
     * <li>RESTFUL
     * <P>
     * RESTful API
     * <li>JAXRS
     * <P>
     * RESTful WebService
     * <li>WEBSERVICE
     * <P>
     * WebService
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum ServiceAPIType{
        RESTFUL("RESTFUL", "RESTful API")
        ,JAXRS("JAXRS", "RESTful WebService")
        ,WEBSERVICE("WEBSERVICE", "WebService")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private ServiceAPIType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceAPIType from(String value){
            switch(value){
                case "RESTFUL":
                    return RESTFUL;
                case "JAXRS":
                    return JAXRS;
                case "WEBSERVICE":
                    return WEBSERVICE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为测试行为模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无测试行为
     * <li>PROTECTED&nbsp;(1)
     * <P>
     * 有测试行为
     * <li>PUBLIC&nbsp;(3)
     * <P>
     * 公开测试行为
     * </ul>     
     */
    public static enum DEActionTestActionMode{
        NONE(0, "无测试行为")
        ,PROTECTED(1, "有测试行为")
        ,PUBLIC(3, "公开测试行为")
;
           
        public final String text;
        public final int value;
        
        private DEActionTestActionMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionTestActionMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return PROTECTED;
                case 3:
                    return PUBLIC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器值类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SIMPLES
     * <P>
     * 简单值数组
     * <li>OBJECT
     * <P>
     * 对象（Object）
     * <li>OBJECTS
     * <P>
     * 对象数组（Object[]）
     * <li>USER
     * <P>
     * 用户自定义（USER）
     * <li>USER2
     * <P>
     * 用户自定义2（USER2）
     * </ul>     
     */
    public static enum EditorValueType{
        SIMPLE("SIMPLE", "简单值")
        ,SIMPLES("SIMPLES", "简单值数组")
        ,OBJECT("OBJECT", "对象（Object）")
        ,OBJECTS("OBJECTS", "对象数组（Object[]）")
        ,USER("USER", "用户自定义（USER）")
        ,USER2("USER2", "用户自定义2（USER2）")
;
           
        public final String text;
        public final String value;
        
        private EditorValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditorValueType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "OBJECT":
                    return OBJECT;
                case "OBJECTS":
                    return OBJECTS;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据表列继承模式，数值项
     * <P>
     * <ul>
     * <li>EXCLUDE&nbsp;(1)
     * <P>
     * 忽略继承指定列
     * <li>INCLUDE&nbsp;(2)
     * <P>
     * 继承指定列
     * </ul>     
     */
    public static enum TableColInheritMode{
        EXCLUDE(1, "忽略继承指定列")
        ,INCLUDE(2, "继承指定列")
;
           
        public final String text;
        public final int value;
        
        private TableColInheritMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TableColInheritMode from(int value){
            switch(value){
                case 1:
                    return EXCLUDE;
                case 2:
                    return INCLUDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑节点事务运行模式，数值项
     * <P>
     * <ul>
     * <li>REQUIRED&nbsp;(0)
     * <P>
     * 开启
     * <li>REQUIREDNEW&nbsp;(3)
     * <P>
     * 开启新事务
     * </ul>     
     */
    public static enum DELogicNodeTSMode{
        REQUIRED(0, "开启")
        ,REQUIREDNEW(3, "开启新事务")
;
           
        public final String text;
        public final int value;
        
        private DELogicNodeTSMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicNodeTSMode from(int value){
            switch(value){
                case 0:
                    return REQUIRED;
                case 3:
                    return REQUIREDNEW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 同步输出模式，数值项
     * <P>
     * <ul>
     * <li>REALTIME&nbsp;(1)
     * <P>
     * 实时
     * <li>TIMER&nbsp;(2)
     * <P>
     * 定时
     * </ul>     
     */
    public static enum DataSyncOutMode{
        REALTIME(1, "实时")
        ,TIMER(2, "定时")
;
           
        public final String text;
        public final int value;
        
        private DataSyncOutMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSyncOutMode from(int value){
            switch(value){
                case 1:
                    return REALTIME;
                case 2:
                    return TIMER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云应用中心后台任务类型
     * <P>
     * <ul>
     * <li>PACKDEVSLNSYS
     * <P>
     * 打包开发系统
     * <li>CREATEDEVSLNSYS
     * <P>
     * 建立开发系统
     * <li>BACKUPDCDBINST
     * <P>
     * 备份应用中心数据库实例
     * <li>RESTOREDCDBINST
     * <P>
     * 恢复应用中心数据库实例
     * <li>IMPPFSTYLE
     * <P>
     * 导入前端样式模板
     * <li>IMPSFSTYLEVER
     * <P>
     * 导入后台服务框架模板
     * <li>BACKUPDEVSLNSYS
     * <P>
     * 备份开发系统
     * <li>RESTOREDEVSLNSYS
     * <P>
     * 恢复开发系统
     * <li>ONLINEDEVSLNSYS
     * <P>
     * 连线开发系统
     * <li>OFFLINEDEVSLNSYS
     * <P>
     * 离线开发系统
     * <li>CREATEDEVSLNSYS2
     * <P>
     * 建立开发系统分支
     * <li>CREATEDEVSLNSYSDEPINST
     * <P>
     * 建立系统部署模型仓库
     * <li>EXPORTDEVSYSMODEL
     * <P>
     * 导出系统模型
     * <li>IMPORTDEVSYSMODEL
     * <P>
     * 导入系统模型
     * <li>UPGRATEDEVSYSMODEL
     * <P>
     * 升级模型仓库
     * <li>WORKSPACEACTION
     * <P>
     * 中心生产线作业
     * <li>UWPROJECT
     * <P>
     * 建立项目向导
     * <li>IBIZCENTRAL
     * <P>
     * iBizCentral（中台）
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum DCBKTaskType{
        PACKDEVSLNSYS("PACKDEVSLNSYS", "打包开发系统")
        ,CREATEDEVSLNSYS("CREATEDEVSLNSYS", "建立开发系统")
        ,BACKUPDCDBINST("BACKUPDCDBINST", "备份应用中心数据库实例")
        ,RESTOREDCDBINST("RESTOREDCDBINST", "恢复应用中心数据库实例")
        ,IMPPFSTYLE("IMPPFSTYLE", "导入前端样式模板")
        ,IMPSFSTYLEVER("IMPSFSTYLEVER", "导入后台服务框架模板")
        ,BACKUPDEVSLNSYS("BACKUPDEVSLNSYS", "备份开发系统")
        ,RESTOREDEVSLNSYS("RESTOREDEVSLNSYS", "恢复开发系统")
        ,ONLINEDEVSLNSYS("ONLINEDEVSLNSYS", "连线开发系统")
        ,OFFLINEDEVSLNSYS("OFFLINEDEVSLNSYS", "离线开发系统")
        ,CREATEDEVSLNSYS2("CREATEDEVSLNSYS2", "建立开发系统分支")
        ,CREATEDEVSLNSYSDEPINST("CREATEDEVSLNSYSDEPINST", "建立系统部署模型仓库")
        ,EXPORTDEVSYSMODEL("EXPORTDEVSYSMODEL", "导出系统模型")
        ,IMPORTDEVSYSMODEL("IMPORTDEVSYSMODEL", "导入系统模型")
        ,UPGRATEDEVSYSMODEL("UPGRATEDEVSYSMODEL", "升级模型仓库")
        ,WORKSPACEACTION("WORKSPACEACTION", "中心生产线作业")
        ,UWPROJECT("UWPROJECT", "建立项目向导")
        ,IBIZCENTRAL("IBIZCENTRAL", "iBizCentral（中台）")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private DCBKTaskType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DCBKTaskType from(String value){
            switch(value){
                case "PACKDEVSLNSYS":
                    return PACKDEVSLNSYS;
                case "CREATEDEVSLNSYS":
                    return CREATEDEVSLNSYS;
                case "BACKUPDCDBINST":
                    return BACKUPDCDBINST;
                case "RESTOREDCDBINST":
                    return RESTOREDCDBINST;
                case "IMPPFSTYLE":
                    return IMPPFSTYLE;
                case "IMPSFSTYLEVER":
                    return IMPSFSTYLEVER;
                case "BACKUPDEVSLNSYS":
                    return BACKUPDEVSLNSYS;
                case "RESTOREDEVSLNSYS":
                    return RESTOREDEVSLNSYS;
                case "ONLINEDEVSLNSYS":
                    return ONLINEDEVSLNSYS;
                case "OFFLINEDEVSLNSYS":
                    return OFFLINEDEVSLNSYS;
                case "CREATEDEVSLNSYS2":
                    return CREATEDEVSLNSYS2;
                case "CREATEDEVSLNSYSDEPINST":
                    return CREATEDEVSLNSYSDEPINST;
                case "EXPORTDEVSYSMODEL":
                    return EXPORTDEVSYSMODEL;
                case "IMPORTDEVSYSMODEL":
                    return IMPORTDEVSYSMODEL;
                case "UPGRATEDEVSYSMODEL":
                    return UPGRATEDEVSYSMODEL;
                case "WORKSPACEACTION":
                    return WORKSPACEACTION;
                case "UWPROJECT":
                    return UWPROJECT;
                case "IBIZCENTRAL":
                    return IBIZCENTRAL;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程连接类型
     * <P>
     * <ul>
     * <li>TIMEOUT
     * <P>
     * 超时连接
     * <li>IAACTION
     * <P>
     * 交互连接
     * <li>ROUTE
     * <P>
     * 常规连接
     * <li>WFRETURN
     * <P>
     * 嵌入流程返回
     * </ul>     
     */
    public static enum WFLinkType{
        TIMEOUT("TIMEOUT", "超时连接")
        ,IAACTION("IAACTION", "交互连接")
        ,ROUTE("ROUTE", "常规连接")
        ,WFRETURN("WFRETURN", "嵌入流程返回")
;
           
        public final String text;
        public final String value;
        
        private WFLinkType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFLinkType from(String value){
            switch(value){
                case "TIMEOUT":
                    return TIMEOUT;
                case "IAACTION":
                    return IAACTION;
                case "ROUTE":
                    return ROUTE;
                case "WFRETURN":
                    return WFRETURN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用实体存储模式，数值项
     * <P>
     * <ul>
     * <li>NOLOCAL&nbsp;(0)
     * <P>
     * 仅远程存储
     * <li>LOCALONLY&nbsp;(1)
     * <P>
     * 仅本地存储
     * <li>LOCALANDREMOTE&nbsp;(3)
     * <P>
     * 本地及远程存储
     * <li>DTOONLY&nbsp;(4)
     * <P>
     * DTO成员（无存储）
     * </ul>     
     */
    public static enum AppDEStorageMode{
        NOLOCAL(0, "仅远程存储")
        ,LOCALONLY(1, "仅本地存储")
        ,LOCALANDREMOTE(3, "本地及远程存储")
        ,DTOONLY(4, "DTO成员（无存储）")
;
           
        public final String text;
        public final int value;
        
        private AppDEStorageMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppDEStorageMode from(int value){
            switch(value){
                case 0:
                    return NOLOCAL;
                case 1:
                    return LOCALONLY;
                case 3:
                    return LOCALANDREMOTE;
                case 4:
                    return DTOONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体界面行为类型
     * <P>
     * <ul>
     * <li>SYS
     * <P>
     * 系统预定义，系统预置界面行为
     * <li>FRONT
     * <P>
     * 前台调用，打开视图完成处理
     * <li>BACKEND
     * <P>
     * 后台调用，调用实体行为完成处理
     * <li>WFFRONT
     * <P>
     * 工作流前台调用，打开工作流视图完成处理
     * <li>WFBACKEND
     * <P>
     * 工作流后台调用，调用工作流引擎服务完成处理
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum UIActionType{
        SYS("SYS", "系统预定义")
        ,FRONT("FRONT", "前台调用")
        ,BACKEND("BACKEND", "后台调用")
        ,WFFRONT("WFFRONT", "工作流前台调用")
        ,WFBACKEND("WFBACKEND", "工作流后台调用")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private UIActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionType from(String value){
            switch(value){
                case "SYS":
                    return SYS;
                case "FRONT":
                    return FRONT;
                case "BACKEND":
                    return BACKEND;
                case "WFFRONT":
                    return WFFRONT;
                case "WFBACKEND":
                    return WFBACKEND;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据导入导出能力，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>EXPORT&nbsp;(1)
     * <P>
     * 导出
     * <li>IMPORT&nbsp;(2)
     * <P>
     * 导入
     * <li>ALL&nbsp;(3)
     * <P>
     * 导入及导出
     * </ul>     
     */
    public static enum DEDataImpExpMode{
        NONE(0, "无")
        ,EXPORT(1, "导出")
        ,IMPORT(2, "导入")
        ,ALL(3, "导入及导出")
;
           
        public final String text;
        public final int value;
        
        private DEDataImpExpMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataImpExpMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return EXPORT;
                case 2:
                    return IMPORT;
                case 3:
                    return ALL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体映射模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * </ul>     
     */
    public static enum DEMapType{
        DEFAULT("DEFAULT", "默认")
;
           
        public final String text;
        public final String value;
        
        private DEMapType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMapType from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 存储过程参数方向，数值项
     * <P>
     * <ul>
     * <li>INPUT&nbsp;(1)
     * <P>
     * Input，输入参数
     * <li>OUTPUT&nbsp;(2)
     * <P>
     * Output，输出参数
     * <li>INPUTOUTPUT&nbsp;(3)
     * <P>
     * InputOutput，输入输出参数
     * <li>RETURNVALUE&nbsp;(4)
     * <P>
     * ReturnValue
     * <li>NONE&nbsp;(5)
     * <P>
     * None
     * </ul>     
     */
    public static enum DBProcParamDir{
        INPUT(1, "Input")
        ,OUTPUT(2, "Output")
        ,INPUTOUTPUT(3, "InputOutput")
        ,RETURNVALUE(4, "ReturnValue")
        ,NONE(5, "None")
;
           
        public final String text;
        public final int value;
        
        private DBProcParamDir(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBProcParamDir from(int value){
            switch(value){
                case 1:
                    return INPUT;
                case 2:
                    return OUTPUT;
                case 3:
                    return INPUTOUTPUT;
                case 4:
                    return RETURNVALUE;
                case 5:
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体查询变量类型
     * <P>
     * <ul>
     * <li>DATACONTEXT
     * <P>
     * 数据上下文
     * <li>GLOBALCONTEXT
     * <P>
     * 全局上下文
     * <li>SESSIONCONTEXT
     * <P>
     * 用户上下文
     * <li>SYSTEMCONTEXT
     * <P>
     * 系统上下文
     * <li>WEBCONTEXT
     * <P>
     * 网页请求上下文
     * </ul>     
     */
    public static enum DEDQVarType{
        DATACONTEXT("DATACONTEXT", "数据上下文")
        ,GLOBALCONTEXT("GLOBALCONTEXT", "全局上下文")
        ,SESSIONCONTEXT("SESSIONCONTEXT", "用户上下文")
        ,SYSTEMCONTEXT("SYSTEMCONTEXT", "系统上下文")
        ,WEBCONTEXT("WEBCONTEXT", "网页请求上下文")
;
           
        public final String text;
        public final String value;
        
        private DEDQVarType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDQVarType from(String value){
            switch(value){
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "GLOBALCONTEXT":
                    return GLOBALCONTEXT;
                case "SESSIONCONTEXT":
                    return SESSIONCONTEXT;
                case "SYSTEMCONTEXT":
                    return SYSTEMCONTEXT;
                case "WEBCONTEXT":
                    return WEBCONTEXT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图片类型
     * <P>
     * <ul>
     * <li>ICON
     * <P>
     * 图标
     * <li>IMAGE
     * <P>
     * 图片
     * </ul>     
     */
    public static enum ImageType{
        ICON("ICON", "图标")
        ,IMAGE("IMAGE", "图片")
;
           
        public final String text;
        public final String value;
        
        private ImageType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ImageType from(String value){
            switch(value){
                case "ICON":
                    return ICON;
                case "IMAGE":
                    return IMAGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板数据模式，数值项
     * <P>
     * <ul>
     * <li>INPUTDATA&nbsp;(0)
     * <P>
     * 不获取（使用传入数据）
     * <li>NOINPUTDATA&nbsp;(1)
     * <P>
     * 未传入时获取
     * <li>ALWAYS&nbsp;(2)
     * <P>
     * 始终获取
     * <li>APPGLOBALPARAM&nbsp;(3)
     * <P>
     * 绑定到应用全局变量，绑定到应用全局共享变量
     * <li>ROUTEVIEWSESSIONPARAM&nbsp;(4)
     * <P>
     * 绑定到路由视图会话变量，绑定当前顶级视图（路由或弹窗模式）的会话共享变量
     * <li>VIEWSESSIONPARAM&nbsp;(5)
     * <P>
     * 绑定到当前视图会话变量，绑定当前视图（仅在当前视图范围）的会话共享变量
     * </ul>     
     */
    public static enum PanelGetDataMode{
        INPUTDATA(0, "不获取（使用传入数据）")
        ,NOINPUTDATA(1, "未传入时获取")
        ,ALWAYS(2, "始终获取")
        ,APPGLOBALPARAM(3, "绑定到应用全局变量")
        ,ROUTEVIEWSESSIONPARAM(4, "绑定到路由视图会话变量")
        ,VIEWSESSIONPARAM(5, "绑定到当前视图会话变量")
;
           
        public final String text;
        public final int value;
        
        private PanelGetDataMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelGetDataMode from(int value){
            switch(value){
                case 0:
                    return INPUTDATA;
                case 1:
                    return NOINPUTDATA;
                case 2:
                    return ALWAYS;
                case 3:
                    return APPGLOBALPARAM;
                case 4:
                    return ROUTEVIEWSESSIONPARAM;
                case 5:
                    return VIEWSESSIONPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体扩展模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无扩展
     * <li>SUBSYSEXTEND&nbsp;(2)
     * <P>
     * 子系统功能扩展
     * </ul>     
     */
    public static enum DEExtendMode{
        NONE(0, "无扩展")
        ,SUBSYSEXTEND(2, "子系统功能扩展")
;
           
        public final String text;
        public final int value;
        
        private DEExtendMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEExtendMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 2:
                    return SUBSYSEXTEND;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Flex纵轴对齐
     * <P>
     * <ul>
     * <li>FLEX_START&nbsp;(flex-start)
     * <P>
     * 上对齐
     * <li>FLEX_END&nbsp;(flex-end)
     * <P>
     * 下对齐
     * <li>CENTER&nbsp;(center)
     * <P>
     * 居中
     * <li>BASELINE&nbsp;(baseline)
     * <P>
     * baseline
     * <li>STRETCH&nbsp;(stretch)
     * <P>
     * stretch
     * </ul>     
     */
    public static enum FlexVAlign{
        FLEX_START("flex-start", "上对齐")
        ,FLEX_END("flex-end", "下对齐")
        ,CENTER("center", "居中")
        ,BASELINE("baseline", "baseline")
        ,STRETCH("stretch", "stretch")
;
           
        public final String text;
        public final String value;
        
        private FlexVAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FlexVAlign from(String value){
            switch(value){
                case "flex-start":
                    return FLEX_START;
                case "flex-end":
                    return FLEX_END;
                case "center":
                    return CENTER;
                case "baseline":
                    return BASELINE;
                case "stretch":
                    return STRETCH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法返回类型
     * <P>
     * <ul>
     * <li>VOID
     * <P>
     * 没有返回
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SIMPLES
     * <P>
     * 简单值数组
     * <li>DTO
     * <P>
     * DTO对象
     * <li>DTOS
     * <P>
     * DTO对象集合
     * <li>PAGE
     * <P>
     * 搜索分页
     * <li>ASYNCACTION
     * <P>
     * 异步操作对象
     * <li>SSE
     * <P>
     * 服务器端事件对象（SSE）
     * <li>UNKNOWN
     * <P>
     * 未知
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DEMethodReturnType{
        VOID("VOID", "没有返回")
        ,SIMPLE("SIMPLE", "简单值")
        ,SIMPLES("SIMPLES", "简单值数组")
        ,DTO("DTO", "DTO对象")
        ,DTOS("DTOS", "DTO对象集合")
        ,PAGE("PAGE", "搜索分页")
        ,ASYNCACTION("ASYNCACTION", "异步操作对象")
        ,SSE("SSE", "服务器端事件对象（SSE）")
        ,UNKNOWN("UNKNOWN", "未知")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private DEMethodReturnType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodReturnType from(String value){
            switch(value){
                case "VOID":
                    return VOID;
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "DTO":
                    return DTO;
                case "DTOS":
                    return DTOS;
                case "PAGE":
                    return PAGE;
                case "ASYNCACTION":
                    return ASYNCACTION;
                case "SSE":
                    return SSE;
                case "UNKNOWN":
                    return UNKNOWN;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统运行会话状态，数值项
     * <P>
     * <ul>
     * <li>NOTSTARTED&nbsp;(10)
     * <P>
     * 未启动
     * <li>RUNNING&nbsp;(20)
     * <P>
     * 正在运行
     * <li>TERMINATED&nbsp;(30)
     * <P>
     * 已终止
     * </ul>     
     */
    public static enum SysRunSessionState{
        NOTSTARTED(10, "未启动")
        ,RUNNING(20, "正在运行")
        ,TERMINATED(30, "已终止")
;
           
        public final String text;
        public final int value;
        
        private SysRunSessionState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRunSessionState from(int value){
            switch(value){
                case 10:
                    return NOTSTARTED;
                case 20:
                    return RUNNING;
                case 30:
                    return TERMINATED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体模型导出类别2，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>SIMPLE&nbsp;(1)
     * <P>
     * 简单
     * <li>STANDARD&nbsp;(16)
     * <P>
     * 标准
     * <li>FULL&nbsp;(128)
     * <P>
     * 完整
     * <li>USER&nbsp;(2048)
     * <P>
     * 用户自定义
     * <li>USER2&nbsp;(4096)
     * <P>
     * 用户自定义2
     * <li>USER3&nbsp;(8192)
     * <P>
     * 用户自定义3
     * </ul>     
     */
    public static enum DEExportModelScope2{
        NONE(0, "无")
        ,SIMPLE(1, "简单")
        ,STANDARD(16, "标准")
        ,FULL(128, "完整")
        ,USER(2048, "用户自定义")
        ,USER2(4096, "用户自定义2")
        ,USER3(8192, "用户自定义3")
;
           
        public final String text;
        public final int value;
        
        private DEExportModelScope2(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEExportModelScope2 from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return SIMPLE;
                case 16:
                    return STANDARD;
                case 128:
                    return FULL;
                case 2048:
                    return USER;
                case 4096:
                    return USER2;
                case 8192:
                    return USER3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件成员样式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认样式
     * <li>STYLE2
     * <P>
     * 样式2
     * <li>STYLE3
     * <P>
     * 样式3
     * <li>STYLE4
     * <P>
     * 样式4
     * </ul>     
     */
    public static enum CtrlDetailStyle{
        DEFAULT("DEFAULT", "默认样式")
        ,STYLE2("STYLE2", "样式2")
        ,STYLE3("STYLE3", "样式3")
        ,STYLE4("STYLE4", "样式4")
;
           
        public final String text;
        public final String value;
        
        private CtrlDetailStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlDetailStyle from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "STYLE2":
                    return STYLE2;
                case "STYLE3":
                    return STYLE3;
                case "STYLE4":
                    return STYLE4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性逻辑模式
     * <P>
     * <ul>
     * <li>COMPUTE
     * <P>
     * 计算值，逻辑在获取属性值时触发，计算属性值
     * <li>DEFAULT
     * <P>
     * 默认值，逻辑在获取属性默认值时触发
     * <li>ONCHANGE
     * <P>
     * 变更触发，逻辑在属性值变化时触发
     * <li>CHECK
     * <P>
     * 检查值，逻辑在检查属性值时触发
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEFLogicMode{
        COMPUTE("COMPUTE", "计算值")
        ,DEFAULT("DEFAULT", "默认值")
        ,ONCHANGE("ONCHANGE", "变更触发")
        ,CHECK("CHECK", "检查值")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEFLogicMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFLogicMode from(String value){
            switch(value){
                case "COMPUTE":
                    return COMPUTE;
                case "DEFAULT":
                    return DEFAULT;
                case "ONCHANGE":
                    return ONCHANGE;
                case "CHECK":
                    return CHECK;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 移动端多项数据控件样式
     * <P>
     * <ul>
     * <li>ICONVIEW
     * <P>
     * 图标视图
     * <li>LISTVIEW
     * <P>
     * 列表视图
     * <li>SWIPERVIEW
     * <P>
     * 图片滑动视图
     * <li>LISTVIEW2
     * <P>
     * 列表视图（无刷新）
     * <li>LISTVIEW3
     * <P>
     * 列表视图（无滑动）
     * <li>LISTVIEW4
     * <P>
     * 列表视图（无背景）
     * <li>EXTVIEW1
     * <P>
     * 扩展视图1
     * <li>EXTVIEW2
     * <P>
     * 扩展视图2
     * <li>EXTVIEW3
     * <P>
     * 扩展视图3
     * <li>EXTVIEW4
     * <P>
     * 扩展视图4
     * <li>EXTVIEW5
     * <P>
     * 扩展视图5
     * </ul>     
     */
    public static enum MobMDCtrlType{
        ICONVIEW("ICONVIEW", "图标视图")
        ,LISTVIEW("LISTVIEW", "列表视图")
        ,SWIPERVIEW("SWIPERVIEW", "图片滑动视图")
        ,LISTVIEW2("LISTVIEW2", "列表视图（无刷新）")
        ,LISTVIEW3("LISTVIEW3", "列表视图（无滑动）")
        ,LISTVIEW4("LISTVIEW4", "列表视图（无背景）")
        ,EXTVIEW1("EXTVIEW1", "扩展视图1")
        ,EXTVIEW2("EXTVIEW2", "扩展视图2")
        ,EXTVIEW3("EXTVIEW3", "扩展视图3")
        ,EXTVIEW4("EXTVIEW4", "扩展视图4")
        ,EXTVIEW5("EXTVIEW5", "扩展视图5")
;
           
        public final String text;
        public final String value;
        
        private MobMDCtrlType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobMDCtrlType from(String value){
            switch(value){
                case "ICONVIEW":
                    return ICONVIEW;
                case "LISTVIEW":
                    return LISTVIEW;
                case "SWIPERVIEW":
                    return SWIPERVIEW;
                case "LISTVIEW2":
                    return LISTVIEW2;
                case "LISTVIEW3":
                    return LISTVIEW3;
                case "LISTVIEW4":
                    return LISTVIEW4;
                case "EXTVIEW1":
                    return EXTVIEW1;
                case "EXTVIEW2":
                    return EXTVIEW2;
                case "EXTVIEW3":
                    return EXTVIEW3;
                case "EXTVIEW4":
                    return EXTVIEW4;
                case "EXTVIEW5":
                    return EXTVIEW5;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为行为级别，数值项
     * <P>
     * <ul>
     * <li>NOTOFTEN&nbsp;(50)
     * <P>
     * 不常用
     * <li>NORMAL&nbsp;(100)
     * <P>
     * 一般操作
     * <li>OFTEN&nbsp;(200)
     * <P>
     * 常用操作
     * <li>KEY&nbsp;(250)
     * <P>
     * 关键操作
     * </ul>     
     */
    public static enum UIActionLevel{
        NOTOFTEN(50, "不常用")
        ,NORMAL(100, "一般操作")
        ,OFTEN(200, "常用操作")
        ,KEY(250, "关键操作")
;
           
        public final String text;
        public final int value;
        
        private UIActionLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionLevel from(int value){
            switch(value){
                case 50:
                    return NOTOFTEN;
                case 100:
                    return NORMAL;
                case 200:
                    return OFTEN;
                case 250:
                    return KEY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性主信息模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 否
     * <li>MAJOR&nbsp;(1)
     * <P>
     * 主信息，数据的主信息
     * <li>KEYNAME&nbsp;(2)
     * <P>
     * 键名
     * </ul>     
     */
    public static enum FieldMajorMode{
        NONE(0, "否")
        ,MAJOR(1, "主信息")
        ,KEYNAME(2, "键名")
;
           
        public final String text;
        public final int value;
        
        private FieldMajorMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FieldMajorMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return MAJOR;
                case 2:
                    return KEYNAME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 多数据部件即时编辑模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>ITEM_256&nbsp;(256)
     * <P>
     * 次序调整
     * <li>ITEM_512&nbsp;(512)
     * <P>
     * 分组调整
     * </ul>     
     */
    public static enum MDCtrlEditMode{
        ITEM_256(256, "次序调整")
        ,ITEM_512(512, "分组调整")
;
           
        public final String text;
        public final int value;
        
        private MDCtrlEditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static MDCtrlEditMode from(int value){
            switch(value){
                case 256:
                    return ITEM_256;
                case 512:
                    return ITEM_512;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统消息模板类型
     * <P>
     * <ul>
     * <li>STATIC
     * <P>
     * 静态
     * <li>RUNTIME
     * <P>
     * Runtime
     * <li>DE
     * <P>
     * 实体数据集
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum MsgTemplType{
        STATIC("STATIC", "静态")
        ,RUNTIME("RUNTIME", "Runtime")
        ,DE("DE", "实体数据集")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private MsgTemplType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MsgTemplType from(String value){
            switch(value){
                case "STATIC":
                    return STATIC;
                case "RUNTIME":
                    return RUNTIME;
                case "DE":
                    return DE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单样式
     * <P>
     * <ul>
     * <li>EDITFORM
     * <P>
     * 编辑表单
     * <li>SEARCHFORM
     * <P>
     * 搜索表单
     * </ul>     
     */
    public static enum FormType{
        EDITFORM("EDITFORM", "编辑表单")
        ,SEARCHFORM("SEARCHFORM", "搜索表单")
;
           
        public final String text;
        public final String value;
        
        private FormType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormType from(String value){
            switch(value){
                case "EDITFORM":
                    return EDITFORM;
                case "SEARCHFORM":
                    return SEARCHFORM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用功能打开方式
     * <P>
     * <ul>
     * <li>INDEXVIEWTAB
     * <P>
     * 应用容器分页
     * <li>INDEXVIEWPOPUP
     * <P>
     * 应用容器弹出
     * <li>INDEXVIEWPOPUPMODAL
     * <P>
     * 应用容器弹出（模式）
     * <li>HTMLPOPUP
     * <P>
     * 独立网页弹出
     * <li>TOP
     * <P>
     * 顶级页面
     * </ul>     
     */
    public static enum AppFuncOpenMode{
        INDEXVIEWTAB("INDEXVIEWTAB", "应用容器分页")
        ,INDEXVIEWPOPUP("INDEXVIEWPOPUP", "应用容器弹出")
        ,INDEXVIEWPOPUPMODAL("INDEXVIEWPOPUPMODAL", "应用容器弹出（模式）")
        ,HTMLPOPUP("HTMLPOPUP", "独立网页弹出")
        ,TOP("TOP", "顶级页面")
;
           
        public final String text;
        public final String value;
        
        private AppFuncOpenMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppFuncOpenMode from(String value){
            switch(value){
                case "INDEXVIEWTAB":
                    return INDEXVIEWTAB;
                case "INDEXVIEWPOPUP":
                    return INDEXVIEWPOPUP;
                case "INDEXVIEWPOPUPMODAL":
                    return INDEXVIEWPOPUPMODAL;
                case "HTMLPOPUP":
                    return HTMLPOPUP;
                case "TOP":
                    return TOP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器类型（桌面端）
     * <P>
     * <ul>
     * <li>TEXTBOX
     * <P>
     * 文本框
     * <li>NUMBER
     * <P>
     * 数值框
     * <li>PASSWORD
     * <P>
     * 密码框
     * <li>HIDDEN
     * <P>
     * 隐藏表单项
     * <li>TEXTAREA
     * <P>
     * 多行输入框
     * <li>TEXTAREA_10
     * <P>
     * 多行输入框（10行）
     * <li>IPADDRESSTEXTBOX
     * <P>
     * IP地址输入框
     * <li>RAW
     * <P>
     * 直接内容
     * <li>STEPPER
     * <P>
     * 步进器
     * <li>RATING
     * <P>
     * 评分器
     * <li>SLIDER
     * <P>
     * 滑动输入条
     * <li>SPAN
     * <P>
     * 标签
     * <li>SPANEX
     * <P>
     * 标签（旧）
     * <li>SPAN_LINK
     * <P>
     * 标签（数据链接）
     * <li>DROPDOWNLIST
     * <P>
     * 下拉列表框
     * <li>DROPDOWNLIST_100
     * <P>
     * 下拉列表框（100宽度）
     * <li>MDROPDOWNLIST
     * <P>
     * 下拉列表框（多选）
     * <li>CHECKBOX
     * <P>
     * 选项框
     * <li>SWITCH
     * <P>
     * 开关部件
     * <li>RADIOBUTTONLIST
     * <P>
     * 单选项列表
     * <li>CHECKBOXLIST
     * <P>
     * 选项框列表
     * <li>LISTBOX
     * <P>
     * 列表框
     * <li>LISTBOXPICKUP
     * <P>
     * 列表框（选择）
     * <li>ADDRESSPICKUP
     * <P>
     * 地址框（选择）
     * <li>ADDRESSPICKUP_AC
     * <P>
     * 地址框（支持选择、AC）
     * <li>DATEPICKEREX
     * <P>
     * 时间选择器（旧）
     * <li>DATEPICKEREX_NOTIME
     * <P>
     * 时间选择器（YYYY-MM-DD）
     * <li>DATEPICKEREX_NODAY
     * <P>
     * 时间选择器（HH:mm:ss）
     * <li>DATEPICKEREX_HOUR
     * <P>
     * 时间选择器（YYYY-MM-DD HH）
     * <li>DATEPICKEREX_MINUTE
     * <P>
     * 时间选择器（YYYY-MM-DD HH:mm）
     * <li>DATEPICKEREX_SECOND
     * <P>
     * 时间选择器（YYYY-MM-DD HH:mm:ss）
     * <li>DATEPICKEREX_NODAY_NOSECOND
     * <P>
     * 时间选择器（HH:mm）
     * <li>DATEPICKER
     * <P>
     * 时间选择器
     * <li>PICKER
     * <P>
     * 数据选择
     * <li>PICKEREX_LINK
     * <P>
     * 数据选择（数据链接）
     * <li>PICKEREX_NOAC
     * <P>
     * 数据选择（无AC）
     * <li>PICKEREX_LINKONLY
     * <P>
     * 数据链接
     * <li>PICKEREX_NOAC_LINK
     * <P>
     * 数据选择（无AC、数据链接）
     * <li>PICKEREX_TRIGGER
     * <P>
     * 数据选择（下拉）
     * <li>PICKEREX_TRIGGER_LINK
     * <P>
     * 数据选择（下拉、数据链接）
     * <li>PICKEREX_NOBUTTON
     * <P>
     * 数据选择（无按钮）
     * <li>PICKEREX_DROPDOWNVIEW
     * <P>
     * 数据选择（下拉视图）
     * <li>PICKEREX_DROPDOWNVIEW_LINK
     * <P>
     * 数据选择（下拉视图、数据链接）
     * <li>PICKUPVIEW
     * <P>
     * 数据选择（嵌入选择视图）
     * <li>AC
     * <P>
     * 自动填充
     * <li>AC_FS
     * <P>
     * 自动填充（只能选择）
     * <li>AC_NOBUTTON
     * <P>
     * 自动填充（无按钮）
     * <li>AC_FS_NOBUTTON
     * <P>
     * 自动填充（只能选择、无按钮）
     * <li>HTMLEDITOR
     * <P>
     * HTML编辑框
     * <li>CODE
     * <P>
     * 代码编辑框
     * <li>MARKDOWN
     * <P>
     * Markdown编辑框
     * <li>OFFICEEDITOR
     * <P>
     * Office文档编辑器
     * <li>OFFICEEDITOR2
     * <P>
     * Office文档编辑器2（弹出编辑，返回内容）
     * <li>PICTURE
     * <P>
     * 图片控件
     * <li>PICTURE_ONE
     * <P>
     * 图片控件（单项）
     * <li>PICTURE_ONE_RAW
     * <P>
     * 图片控件（单项、直接内容）
     * <li>PREDEFINED
     * <P>
     * 预定义编辑器
     * <li>FILEUPLOADER
     * <P>
     * 文件控件
     * <li>FILEUPLOADER_ONE
     * <P>
     * 文件控件（单项）
     * <li>NUMBERRANGE
     * <P>
     * 数值范围编辑框
     * <li>DATERANGE
     * <P>
     * 时间范围选择器
     * <li>DATERANGE_NOTIME
     * <P>
     * 时间范围选择器（YYYY-MM-DD）
     * <li>CASCADER
     * <P>
     * 级联选择器
     * <li>ARRAY
     * <P>
     * 数组编辑器
     * <li>COLORPICKER
     * <P>
     * 颜色选择器
     * <li>MAPPICKER
     * <P>
     * 地图选择器
     * <li>USERCONTROL
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum WebEditorType{
        TEXTBOX("TEXTBOX", "文本框")
        ,NUMBER("NUMBER", "数值框")
        ,PASSWORD("PASSWORD", "密码框")
        ,HIDDEN("HIDDEN", "隐藏表单项")
        ,TEXTAREA("TEXTAREA", "多行输入框")
        ,TEXTAREA_10("TEXTAREA_10", "多行输入框（10行）")
        ,IPADDRESSTEXTBOX("IPADDRESSTEXTBOX", "IP地址输入框")
        ,RAW("RAW", "直接内容")
        ,STEPPER("STEPPER", "步进器")
        ,RATING("RATING", "评分器")
        ,SLIDER("SLIDER", "滑动输入条")
        ,SPAN("SPAN", "标签")
        ,SPANEX("SPANEX", "标签（旧）")
        ,SPAN_LINK("SPAN_LINK", "标签（数据链接）")
        ,DROPDOWNLIST("DROPDOWNLIST", "下拉列表框")
        ,DROPDOWNLIST_100("DROPDOWNLIST_100", "下拉列表框（100宽度）")
        ,MDROPDOWNLIST("MDROPDOWNLIST", "下拉列表框（多选）")
        ,CHECKBOX("CHECKBOX", "选项框")
        ,SWITCH("SWITCH", "开关部件")
        ,RADIOBUTTONLIST("RADIOBUTTONLIST", "单选项列表")
        ,CHECKBOXLIST("CHECKBOXLIST", "选项框列表")
        ,LISTBOX("LISTBOX", "列表框")
        ,LISTBOXPICKUP("LISTBOXPICKUP", "列表框（选择）")
        ,ADDRESSPICKUP("ADDRESSPICKUP", "地址框（选择）")
        ,ADDRESSPICKUP_AC("ADDRESSPICKUP_AC", "地址框（支持选择、AC）")
        ,DATEPICKEREX("DATEPICKEREX", "时间选择器（旧）")
        ,DATEPICKEREX_NOTIME("DATEPICKEREX_NOTIME", "时间选择器（YYYY-MM-DD）")
        ,DATEPICKEREX_NODAY("DATEPICKEREX_NODAY", "时间选择器（HH:mm:ss）")
        ,DATEPICKEREX_HOUR("DATEPICKEREX_HOUR", "时间选择器（YYYY-MM-DD HH）")
        ,DATEPICKEREX_MINUTE("DATEPICKEREX_MINUTE", "时间选择器（YYYY-MM-DD HH:mm）")
        ,DATEPICKEREX_SECOND("DATEPICKEREX_SECOND", "时间选择器（YYYY-MM-DD HH:mm:ss）")
        ,DATEPICKEREX_NODAY_NOSECOND("DATEPICKEREX_NODAY_NOSECOND", "时间选择器（HH:mm）")
        ,DATEPICKER("DATEPICKER", "时间选择器")
        ,PICKER("PICKER", "数据选择")
        ,PICKEREX_LINK("PICKEREX_LINK", "数据选择（数据链接）")
        ,PICKEREX_NOAC("PICKEREX_NOAC", "数据选择（无AC）")
        ,PICKEREX_LINKONLY("PICKEREX_LINKONLY", "数据链接")
        ,PICKEREX_NOAC_LINK("PICKEREX_NOAC_LINK", "数据选择（无AC、数据链接）")
        ,PICKEREX_TRIGGER("PICKEREX_TRIGGER", "数据选择（下拉）")
        ,PICKEREX_TRIGGER_LINK("PICKEREX_TRIGGER_LINK", "数据选择（下拉、数据链接）")
        ,PICKEREX_NOBUTTON("PICKEREX_NOBUTTON", "数据选择（无按钮）")
        ,PICKEREX_DROPDOWNVIEW("PICKEREX_DROPDOWNVIEW", "数据选择（下拉视图）")
        ,PICKEREX_DROPDOWNVIEW_LINK("PICKEREX_DROPDOWNVIEW_LINK", "数据选择（下拉视图、数据链接）")
        ,PICKUPVIEW("PICKUPVIEW", "数据选择（嵌入选择视图）")
        ,AC("AC", "自动填充")
        ,AC_FS("AC_FS", "自动填充（只能选择）")
        ,AC_NOBUTTON("AC_NOBUTTON", "自动填充（无按钮）")
        ,AC_FS_NOBUTTON("AC_FS_NOBUTTON", "自动填充（只能选择、无按钮）")
        ,HTMLEDITOR("HTMLEDITOR", "HTML编辑框")
        ,CODE("CODE", "代码编辑框")
        ,MARKDOWN("MARKDOWN", "Markdown编辑框")
        ,OFFICEEDITOR("OFFICEEDITOR", "Office文档编辑器")
        ,OFFICEEDITOR2("OFFICEEDITOR2", "Office文档编辑器2（弹出编辑，返回内容）")
        ,PICTURE("PICTURE", "图片控件")
        ,PICTURE_ONE("PICTURE_ONE", "图片控件（单项）")
        ,PICTURE_ONE_RAW("PICTURE_ONE_RAW", "图片控件（单项、直接内容）")
        ,PREDEFINED("PREDEFINED", "预定义编辑器")
        ,FILEUPLOADER("FILEUPLOADER", "文件控件")
        ,FILEUPLOADER_ONE("FILEUPLOADER_ONE", "文件控件（单项）")
        ,NUMBERRANGE("NUMBERRANGE", "数值范围编辑框")
        ,DATERANGE("DATERANGE", "时间范围选择器")
        ,DATERANGE_NOTIME("DATERANGE_NOTIME", "时间范围选择器（YYYY-MM-DD）")
        ,CASCADER("CASCADER", "级联选择器")
        ,ARRAY("ARRAY", "数组编辑器")
        ,COLORPICKER("COLORPICKER", "颜色选择器")
        ,MAPPICKER("MAPPICKER", "地图选择器")
        ,USERCONTROL("USERCONTROL", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private WebEditorType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WebEditorType from(String value){
            switch(value){
                case "TEXTBOX":
                    return TEXTBOX;
                case "NUMBER":
                    return NUMBER;
                case "PASSWORD":
                    return PASSWORD;
                case "HIDDEN":
                    return HIDDEN;
                case "TEXTAREA":
                    return TEXTAREA;
                case "TEXTAREA_10":
                    return TEXTAREA_10;
                case "IPADDRESSTEXTBOX":
                    return IPADDRESSTEXTBOX;
                case "RAW":
                    return RAW;
                case "STEPPER":
                    return STEPPER;
                case "RATING":
                    return RATING;
                case "SLIDER":
                    return SLIDER;
                case "SPAN":
                    return SPAN;
                case "SPANEX":
                    return SPANEX;
                case "SPAN_LINK":
                    return SPAN_LINK;
                case "DROPDOWNLIST":
                    return DROPDOWNLIST;
                case "DROPDOWNLIST_100":
                    return DROPDOWNLIST_100;
                case "MDROPDOWNLIST":
                    return MDROPDOWNLIST;
                case "CHECKBOX":
                    return CHECKBOX;
                case "SWITCH":
                    return SWITCH;
                case "RADIOBUTTONLIST":
                    return RADIOBUTTONLIST;
                case "CHECKBOXLIST":
                    return CHECKBOXLIST;
                case "LISTBOX":
                    return LISTBOX;
                case "LISTBOXPICKUP":
                    return LISTBOXPICKUP;
                case "ADDRESSPICKUP":
                    return ADDRESSPICKUP;
                case "ADDRESSPICKUP_AC":
                    return ADDRESSPICKUP_AC;
                case "DATEPICKEREX":
                    return DATEPICKEREX;
                case "DATEPICKEREX_NOTIME":
                    return DATEPICKEREX_NOTIME;
                case "DATEPICKEREX_NODAY":
                    return DATEPICKEREX_NODAY;
                case "DATEPICKEREX_HOUR":
                    return DATEPICKEREX_HOUR;
                case "DATEPICKEREX_MINUTE":
                    return DATEPICKEREX_MINUTE;
                case "DATEPICKEREX_SECOND":
                    return DATEPICKEREX_SECOND;
                case "DATEPICKEREX_NODAY_NOSECOND":
                    return DATEPICKEREX_NODAY_NOSECOND;
                case "DATEPICKER":
                    return DATEPICKER;
                case "PICKER":
                    return PICKER;
                case "PICKEREX_LINK":
                    return PICKEREX_LINK;
                case "PICKEREX_NOAC":
                    return PICKEREX_NOAC;
                case "PICKEREX_LINKONLY":
                    return PICKEREX_LINKONLY;
                case "PICKEREX_NOAC_LINK":
                    return PICKEREX_NOAC_LINK;
                case "PICKEREX_TRIGGER":
                    return PICKEREX_TRIGGER;
                case "PICKEREX_TRIGGER_LINK":
                    return PICKEREX_TRIGGER_LINK;
                case "PICKEREX_NOBUTTON":
                    return PICKEREX_NOBUTTON;
                case "PICKEREX_DROPDOWNVIEW":
                    return PICKEREX_DROPDOWNVIEW;
                case "PICKEREX_DROPDOWNVIEW_LINK":
                    return PICKEREX_DROPDOWNVIEW_LINK;
                case "PICKUPVIEW":
                    return PICKUPVIEW;
                case "AC":
                    return AC;
                case "AC_FS":
                    return AC_FS;
                case "AC_NOBUTTON":
                    return AC_NOBUTTON;
                case "AC_FS_NOBUTTON":
                    return AC_FS_NOBUTTON;
                case "HTMLEDITOR":
                    return HTMLEDITOR;
                case "CODE":
                    return CODE;
                case "MARKDOWN":
                    return MARKDOWN;
                case "OFFICEEDITOR":
                    return OFFICEEDITOR;
                case "OFFICEEDITOR2":
                    return OFFICEEDITOR2;
                case "PICTURE":
                    return PICTURE;
                case "PICTURE_ONE":
                    return PICTURE_ONE;
                case "PICTURE_ONE_RAW":
                    return PICTURE_ONE_RAW;
                case "PREDEFINED":
                    return PREDEFINED;
                case "FILEUPLOADER":
                    return FILEUPLOADER;
                case "FILEUPLOADER_ONE":
                    return FILEUPLOADER_ONE;
                case "NUMBERRANGE":
                    return NUMBERRANGE;
                case "DATERANGE":
                    return DATERANGE;
                case "DATERANGE_NOTIME":
                    return DATERANGE_NOTIME;
                case "CASCADER":
                    return CASCADER;
                case "ARRAY":
                    return ARRAY;
                case "COLORPICKER":
                    return COLORPICKER;
                case "MAPPICKER":
                    return MAPPICKER;
                case "USERCONTROL":
                    return USERCONTROL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统用户角色类型
     * <P>
     * <ul>
     * <li>CUSTOM
     * <P>
     * 自定义
     * <li>DEDATASET
     * <P>
     * 实体数据集合，指定实体数据集合
     * </ul>     
     */
    public static enum SysUserRoleType{
        CUSTOM("CUSTOM", "自定义")
        ,DEDATASET("DEDATASET", "实体数据集合")
;
           
        public final String text;
        public final String value;
        
        private SysUserRoleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysUserRoleType from(String value){
            switch(value){
                case "CUSTOM":
                    return CUSTOM;
                case "DEDATASET":
                    return DEDATASET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用集成实体属性映射类型
     * <P>
     * <ul>
     * <li>ATTRIBUTE
     * <P>
     * 属性
     * <li>ELEMENT
     * <P>
     * 简单元素
     * </ul>     
     */
    public static enum EAIDEFieldMapType{
        ATTRIBUTE("ATTRIBUTE", "属性")
        ,ELEMENT("ELEMENT", "简单元素")
;
           
        public final String text;
        public final String value;
        
        private EAIDEFieldMapType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EAIDEFieldMapType from(String value){
            switch(value){
                case "ATTRIBUTE":
                    return ATTRIBUTE;
                case "ELEMENT":
                    return ELEMENT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统后台体系动态模型模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 不使用
     * <li>PUB
     * <P>
     * 仅发布
     * <li>RUNTIME
     * <P>
     * 运行时
     * <li>GENCODE
     * <P>
     * 代码生产
     * </ul>     
     */
    public static enum SFPubDynaModelMode{
        NONE("NONE", "不使用")
        ,PUB("PUB", "仅发布")
        ,RUNTIME("RUNTIME", "运行时")
        ,GENCODE("GENCODE", "代码生产")
;
           
        public final String text;
        public final String value;
        
        private SFPubDynaModelMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SFPubDynaModelMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "PUB":
                    return PUB;
                case "RUNTIME":
                    return RUNTIME;
                case "GENCODE":
                    return GENCODE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 代码标识格式
     * <P>
     * <ul>
     * <li>LOWER_UNDERSCORE
     * <P>
     * 小写（下划线分隔）
     * <li>UPPER_UNDERSCORE
     * <P>
     * 大写（下划线分隔）
     * <li>LOWER_CAMEL
     * <P>
     * 驼峰（首字母小写）
     * <li>UPPER_CAMEL
     * <P>
     * 驼峰（首字母大写）
     * <li>LOWER
     * <P>
     * 小写（直接，不做转换）
     * <li>UPPER
     * <P>
     * 大写（直接，不做转换）
     * <li>LOWER_HYPHEN
     * <P>
     * 小写（中划线分隔）
     * <li>NONE
     * <P>
     * 无转换
     * </ul>     
     */
    public static enum CodeNameMode{
        LOWER_UNDERSCORE("LOWER_UNDERSCORE", "小写（下划线分隔）")
        ,UPPER_UNDERSCORE("UPPER_UNDERSCORE", "大写（下划线分隔）")
        ,LOWER_CAMEL("LOWER_CAMEL", "驼峰（首字母小写）")
        ,UPPER_CAMEL("UPPER_CAMEL", "驼峰（首字母大写）")
        ,LOWER("LOWER", "小写（直接，不做转换）")
        ,UPPER("UPPER", "大写（直接，不做转换）")
        ,LOWER_HYPHEN("LOWER_HYPHEN", "小写（中划线分隔）")
        ,NONE("NONE", "无转换")
;
           
        public final String text;
        public final String value;
        
        private CodeNameMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CodeNameMode from(String value){
            switch(value){
                case "LOWER_UNDERSCORE":
                    return LOWER_UNDERSCORE;
                case "UPPER_UNDERSCORE":
                    return UPPER_UNDERSCORE;
                case "LOWER_CAMEL":
                    return LOWER_CAMEL;
                case "UPPER_CAMEL":
                    return UPPER_CAMEL;
                case "LOWER":
                    return LOWER;
                case "UPPER":
                    return UPPER;
                case "LOWER_HYPHEN":
                    return LOWER_HYPHEN;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单项回写属性模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无，不回填
     * <li>ALWAYS&nbsp;(1)
     * <P>
     * 始终回写，始终回填
     * <li>ENABLED&nbsp;(2)
     * <P>
     * 启用回写，表单项处于启用状态时进行回填
     * </ul>     
     */
    public static enum EditItemWriteBackMode{
        NONE(0, "无")
        ,ALWAYS(1, "始终回写")
        ,ENABLED(2, "启用回写")
;
           
        public final String text;
        public final int value;
        
        private EditItemWriteBackMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditItemWriteBackMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return ALWAYS;
                case 2:
                    return ENABLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 外部服务接口行为返回值类型
     * <P>
     * <ul>
     * <li>VOID
     * <P>
     * 无（void）
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SIMPLES
     * <P>
     * 简单值数组
     * <li>ENTITY
     * <P>
     * 数据对象
     * <li>ENTITIES
     * <P>
     * 数据对象数组
     * <li>PAGE
     * <P>
     * 搜索分页
     * <li>USER
     * <P>
     * 用户自定义（USER）
     * <li>USER2
     * <P>
     * 用户自定义2（USER2）
     * </ul>     
     */
    public static enum SubSysSADetailRetType{
        VOID("VOID", "无（void）")
        ,SIMPLE("SIMPLE", "简单值")
        ,SIMPLES("SIMPLES", "简单值数组")
        ,ENTITY("ENTITY", "数据对象")
        ,ENTITIES("ENTITIES", "数据对象数组")
        ,PAGE("PAGE", "搜索分页")
        ,USER("USER", "用户自定义（USER）")
        ,USER2("USER2", "用户自定义2（USER2）")
;
           
        public final String text;
        public final String value;
        
        private SubSysSADetailRetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysSADetailRetType from(String value){
            switch(value){
                case "VOID":
                    return VOID;
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "ENTITY":
                    return ENTITY;
                case "ENTITIES":
                    return ENTITIES;
                case "PAGE":
                    return PAGE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 接口实体模型预定义类型
     * <P>
     * <ul>
     * <li>RESPONSERESULT
     * <P>
     * 返回结果
     * <li>PAGE
     * <P>
     * 查询分页
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SubSysSADEPredefinedType{
        RESPONSERESULT("RESPONSERESULT", "返回结果")
        ,PAGE("PAGE", "查询分页")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SubSysSADEPredefinedType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysSADEPredefinedType from(String value){
            switch(value){
                case "RESPONSERESULT":
                    return RESPONSERESULT;
                case "PAGE":
                    return PAGE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用功能配置类型
     * <P>
     * <ul>
     * <li>FILTERSTORAGE
     * <P>
     * 搜索条件存储
     * <li>DYNADASHBOARD
     * <P>
     * 动态数据看板
     * <li>DYNACHART
     * <P>
     * 动态图表
     * <li>DYNAREPORT
     * <P>
     * 动态报表
     * <li>DRAFTSTORAGE
     * <P>
     * 表单草稿存储
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum AppUtilType{
        FILTERSTORAGE("FILTERSTORAGE", "搜索条件存储")
        ,DYNADASHBOARD("DYNADASHBOARD", "动态数据看板")
        ,DYNACHART("DYNACHART", "动态图表")
        ,DYNAREPORT("DYNAREPORT", "动态报表")
        ,DRAFTSTORAGE("DRAFTSTORAGE", "表单草稿存储")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private AppUtilType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppUtilType from(String value){
            switch(value){
                case "FILTERSTORAGE":
                    return FILTERSTORAGE;
                case "DYNADASHBOARD":
                    return DYNADASHBOARD;
                case "DYNACHART":
                    return DYNACHART;
                case "DYNAREPORT":
                    return DYNAREPORT;
                case "DRAFTSTORAGE":
                    return DRAFTSTORAGE;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * AI构建状态，数值项
     * <P>
     * <ul>
     * <li>NOTSTARTED&nbsp;(0)
     * <P>
     * 未构建
     * <li>CHOICESREQUESTING&nbsp;(10)
     * <P>
     * 选项请求中
     * <li>CHOICESRESPONDED&nbsp;(11)
     * <P>
     * 选项已反馈
     * <li>CHOICESCONFIRMED&nbsp;(12)
     * <P>
     * 选项已确认
     * <li>MODELREQUESTING&nbsp;(20)
     * <P>
     * 模型请求中
     * <li>MODELRESPONDED&nbsp;(21)
     * <P>
     * 模型已反馈
     * <li>MODELCONFIRMED&nbsp;(22)
     * <P>
     * 模型已确认
     * <li>AGENTREQUESTING&nbsp;(30)
     * <P>
     * Agent请求中
     * <li>AGENTRESPONDED&nbsp;(31)
     * <P>
     * Agent已反馈
     * <li>AGENTCONFIRMED&nbsp;(32)
     * <P>
     * Agent已确认
     * <li>FINISHED&nbsp;(99)
     * <P>
     * 构建结束
     * </ul>     
     */
    public static enum AIBuildState{
        NOTSTARTED(0, "未构建")
        ,CHOICESREQUESTING(10, "选项请求中")
        ,CHOICESRESPONDED(11, "选项已反馈")
        ,CHOICESCONFIRMED(12, "选项已确认")
        ,MODELREQUESTING(20, "模型请求中")
        ,MODELRESPONDED(21, "模型已反馈")
        ,MODELCONFIRMED(22, "模型已确认")
        ,AGENTREQUESTING(30, "Agent请求中")
        ,AGENTRESPONDED(31, "Agent已反馈")
        ,AGENTCONFIRMED(32, "Agent已确认")
        ,FINISHED(99, "构建结束")
;
           
        public final String text;
        public final int value;
        
        private AIBuildState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AIBuildState from(int value){
            switch(value){
                case 0:
                    return NOTSTARTED;
                case 10:
                    return CHOICESREQUESTING;
                case 11:
                    return CHOICESRESPONDED;
                case 12:
                    return CHOICESCONFIRMED;
                case 20:
                    return MODELREQUESTING;
                case 21:
                    return MODELRESPONDED;
                case 22:
                    return MODELCONFIRMED;
                case 30:
                    return AGENTREQUESTING;
                case 31:
                    return AGENTRESPONDED;
                case 32:
                    return AGENTCONFIRMED;
                case 99:
                    return FINISHED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工具栏样式
     * <P>
     * <ul>
     * <li>TOOLBAR
     * <P>
     * 工具栏
     * <li>MENU
     * <P>
     * 菜单
     * <li>CONTEXTMENU
     * <P>
     * 上下文菜单
     * <li>MOBNAVLEFTMENU
     * <P>
     * 移动端导航栏左侧菜单
     * <li>MOBNAVRIGHTMENU
     * <P>
     * 移动端导航栏右侧菜单
     * <li>MOBWFACTIONMENU
     * <P>
     * 移动端流程操作菜单
     * <li>MOBBOTTOMMENU
     * <P>
     * 移动端视图下方菜单
     * </ul>     
     */
    public static enum ToolbarStyle{
        TOOLBAR("TOOLBAR", "工具栏")
        ,MENU("MENU", "菜单")
        ,CONTEXTMENU("CONTEXTMENU", "上下文菜单")
        ,MOBNAVLEFTMENU("MOBNAVLEFTMENU", "移动端导航栏左侧菜单")
        ,MOBNAVRIGHTMENU("MOBNAVRIGHTMENU", "移动端导航栏右侧菜单")
        ,MOBWFACTIONMENU("MOBWFACTIONMENU", "移动端流程操作菜单")
        ,MOBBOTTOMMENU("MOBBOTTOMMENU", "移动端视图下方菜单")
;
           
        public final String text;
        public final String value;
        
        private ToolbarStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ToolbarStyle from(String value){
            switch(value){
                case "TOOLBAR":
                    return TOOLBAR;
                case "MENU":
                    return MENU;
                case "CONTEXTMENU":
                    return CONTEXTMENU;
                case "MOBNAVLEFTMENU":
                    return MOBNAVLEFTMENU;
                case "MOBNAVRIGHTMENU":
                    return MOBNAVRIGHTMENU;
                case "MOBWFACTIONMENU":
                    return MOBWFACTIONMENU;
                case "MOBBOTTOMMENU":
                    return MOBBOTTOMMENU;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程常规处理类型
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 调用实体行为
     * <li>NONE
     * <P>
     * 空处理
     * </ul>     
     */
    public static enum WFServiceProcType{
        DEACTION("DEACTION", "调用实体行为")
        ,NONE("NONE", "空处理")
;
           
        public final String text;
        public final String value;
        
        private WFServiceProcType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFServiceProcType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据库对象名称转换
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>UCASE
     * <P>
     * 转换为大写
     * <li>LCASE
     * <P>
     * 转换为小写
     * </ul>     
     */
    public static enum DBObjNameCaseMode{
        DEFAULT("DEFAULT", "默认")
        ,UCASE("UCASE", "转换为大写")
        ,LCASE("LCASE", "转换为小写")
;
           
        public final String text;
        public final String value;
        
        private DBObjNameCaseMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBObjNameCaseMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "UCASE":
                    return UCASE;
                case "LCASE":
                    return LCASE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统服务接口服务类型
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>IBIZCLOUD
     * <P>
     * iBizCloud，在iBizCloud微服务平台运行的接口
     * <li>APPLICATION
     * <P>
     * 应用
     * <li>LOCAL
     * <P>
     * 本地接口，仅对本地提供服务的接口，弱安全级别
     * <li>MIDDLEPLATFORM
     * <P>
     * 中台
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum ServiceType{
        DEFAULT("DEFAULT", "默认")
        ,IBIZCLOUD("IBIZCLOUD", "iBizCloud")
        ,APPLICATION("APPLICATION", "应用")
        ,LOCAL("LOCAL", "本地接口")
        ,MIDDLEPLATFORM("MIDDLEPLATFORM", "中台")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private ServiceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceType from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "IBIZCLOUD":
                    return IBIZCLOUD;
                case "APPLICATION":
                    return APPLICATION;
                case "LOCAL":
                    return LOCAL;
                case "MIDDLEPLATFORM":
                    return MIDDLEPLATFORM;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用功能类型
     * <P>
     * <ul>
     * <li>APPVIEW
     * <P>
     * 打开应用视图
     * <li>OPENHTMLPAGE
     * <P>
     * 打开HTML页面
     * <li>PDTAPPFUNC
     * <P>
     * 预置应用功能
     * <li>UIACTION
     * <P>
     * 界面行为
     * <li>JAVASCRIPT
     * <P>
     * 执行JavaScript
     * <li>CUSTOM
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum AppFuncType{
        APPVIEW("APPVIEW", "打开应用视图")
        ,OPENHTMLPAGE("OPENHTMLPAGE", "打开HTML页面")
        ,PDTAPPFUNC("PDTAPPFUNC", "预置应用功能")
        ,UIACTION("UIACTION", "界面行为")
        ,JAVASCRIPT("JAVASCRIPT", "执行JavaScript")
        ,CUSTOM("CUSTOM", "自定义")
;
           
        public final String text;
        public final String value;
        
        private AppFuncType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppFuncType from(String value){
            switch(value){
                case "APPVIEW":
                    return APPVIEW;
                case "OPENHTMLPAGE":
                    return OPENHTMLPAGE;
                case "PDTAPPFUNC":
                    return PDTAPPFUNC;
                case "UIACTION":
                    return UIACTION;
                case "JAVASCRIPT":
                    return JAVASCRIPT;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索栏项类型
     * <P>
     * <ul>
     * <li>FILTER
     * <P>
     * 过滤项，关联属性搜索模式的查询条件输入项
     * <li>GROUP
     * <P>
     * 分组项，预置过滤条件（一项或多项）的数据查询项
     * <li>QUICKSEARCH
     * <P>
     * 快速搜索项，快速搜索条件的输入项
     * </ul>     
     */
    public static enum SearchBarItemType{
        FILTER("FILTER", "过滤项")
        ,GROUP("GROUP", "分组项")
        ,QUICKSEARCH("QUICKSEARCH", "快速搜索项")
;
           
        public final String text;
        public final String value;
        
        private SearchBarItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchBarItemType from(String value){
            switch(value){
                case "FILTER":
                    return FILTER;
                case "GROUP":
                    return GROUP;
                case "QUICKSEARCH":
                    return QUICKSEARCH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体关系子数据同步操作，数值项
     * <P>
     * <ul>
     * <li>SYNC&nbsp;(1)
     * <P>
     * 数据同步
     * <li>RESET&nbsp;(2)
     * <P>
     * 数据重置
     * </ul>     
     */
    public static enum DERDataSyncAction{
        SYNC(1, "数据同步")
        ,RESET(2, "数据重置")
;
           
        public final String text;
        public final int value;
        
        private DERDataSyncAction(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERDataSyncAction from(int value){
            switch(value){
                case 1:
                    return SYNC;
                case 2:
                    return RESET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表单按钮行为类型
     * <P>
     * <ul>
     * <li>UIACTION
     * <P>
     * 界面行为，按钮点击触发界面行为处理
     * <li>FIUPDATE
     * <P>
     * 表单项更新，按钮点击触发表单项更新处理
     * </ul>     
     */
    public static enum FormButtonActionType{
        UIACTION("UIACTION", "界面行为")
        ,FIUPDATE("FIUPDATE", "表单项更新")
;
           
        public final String text;
        public final String value;
        
        private FormButtonActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormButtonActionType from(String value){
            switch(value){
                case "UIACTION":
                    return UIACTION;
                case "FIUPDATE":
                    return FIUPDATE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性默认用户操作，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 新建，允许用户在数据新建时输入值
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新，允许用户在数据更新时输入值
     * <li>USER&nbsp;(256)
     * <P>
     * 自定义
     * <li>USER2&nbsp;(512)
     * <P>
     * 自定义2
     * </ul>     
     */
    public static enum UserInputMode{
        CREATE(1, "新建")
        ,UPDATE(2, "更新")
        ,USER(256, "自定义")
        ,USER2(512, "自定义2")
;
           
        public final String text;
        public final int value;
        
        private UserInputMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static UserInputMode from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 256:
                    return USER;
                case 512:
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体域对象属性类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SIMPLES
     * <P>
     * 简单值数组
     * <li>DOMAIN
     * <P>
     * 域对象
     * <li>DOMAINS
     * <P>
     * 域对象数组
     * </ul>     
     */
    public static enum DEDomainFieldType{
        SIMPLE("SIMPLE", "简单值")
        ,SIMPLES("SIMPLES", "简单值数组")
        ,DOMAIN("DOMAIN", "域对象")
        ,DOMAINS("DOMAINS", "域对象数组")
;
           
        public final String text;
        public final String value;
        
        private DEDomainFieldType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDomainFieldType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "DOMAIN":
                    return DOMAIN;
                case "DOMAINS":
                    return DOMAINS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 条件类型
     * <P>
     * <ul>
     * <li>GROUP
     * <P>
     * 组合条件，组条件，使用与（AND）、或（OR）逻辑计算成员条件
     * <li>SINGLE
     * <P>
     * 属性条件，面向属性的单项条件
     * <li>CUSTOM
     * <P>
     * 自定义条件
     * <li>PREDEFINED
     * <P>
     * 预置条件
     * </ul>     
     */
    public static enum CondType{
        GROUP("GROUP", "组合条件")
        ,SINGLE("SINGLE", "属性条件")
        ,CUSTOM("CUSTOM", "自定义条件")
        ,PREDEFINED("PREDEFINED", "预置条件")
;
           
        public final String text;
        public final String value;
        
        private CondType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CondType from(String value){
            switch(value){
                case "GROUP":
                    return GROUP;
                case "SINGLE":
                    return SINGLE;
                case "CUSTOM":
                    return CUSTOM;
                case "PREDEFINED":
                    return PREDEFINED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统内容类型
     * <P>
     * <ul>
     * <li>RAW
     * <P>
     * 直接内容，内容为直接文本
     * <li>HTML
     * <P>
     * Html内容，内容为HTML文本
     * </ul>     
     */
    public static enum SysContentType{
        RAW("RAW", "直接内容")
        ,HTML("HTML", "Html内容")
;
           
        public final String text;
        public final String value;
        
        private SysContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysContentType from(String value){
            switch(value){
                case "RAW":
                    return RAW;
                case "HTML":
                    return HTML;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图界面行为注册模式，数值项
     * <P>
     * <ul>
     * <li>ALWAYS&nbsp;(0)
     * <P>
     * 始终注册
     * <li>VALID&nbsp;(1)
     * <P>
     * 有效时注册
     * </ul>     
     */
    public static enum ViewUARegMode{
        ALWAYS(0, "始终注册")
        ,VALID(1, "有效时注册")
;
           
        public final String text;
        public final int value;
        
        private ViewUARegMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewUARegMode from(int value){
            switch(value){
                case 0:
                    return ALWAYS;
                case 1:
                    return VALID;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Flex横轴对齐
     * <P>
     * <ul>
     * <li>FLEX_START&nbsp;(flex-start)
     * <P>
     * 左对齐
     * <li>FLEX_END&nbsp;(flex-end)
     * <P>
     * 右对齐
     * <li>CENTER&nbsp;(center)
     * <P>
     * 居中
     * <li>SPACE_BETWEEN&nbsp;(space-between)
     * <P>
     * space-between
     * <li>SPACE_AROUND&nbsp;(space-around)
     * <P>
     * space-around
     * </ul>     
     */
    public static enum FlexAlign{
        FLEX_START("flex-start", "左对齐")
        ,FLEX_END("flex-end", "右对齐")
        ,CENTER("center", "居中")
        ,SPACE_BETWEEN("space-between", "space-between")
        ,SPACE_AROUND("space-around", "space-around")
;
           
        public final String text;
        public final String value;
        
        private FlexAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FlexAlign from(String value){
            switch(value){
                case "flex-start":
                    return FLEX_START;
                case "flex-end":
                    return FLEX_END;
                case "center":
                    return CENTER;
                case "space-between":
                    return SPACE_BETWEEN;
                case "space-around":
                    return SPACE_AROUND;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统用例关系类型
     * <P>
     * <ul>
     * <li>ASSOCIATION
     * <P>
     * 关联(Association)
     * <li>INHERITANCE
     * <P>
     * 泛化(Inheritance)
     * <li>INCLUDE
     * <P>
     * 包含(Include)
     * <li>EXTEND
     * <P>
     * 扩展(Extend)
     * </ul>     
     */
    public static enum UseCaseRSType{
        ASSOCIATION("ASSOCIATION", "关联(Association)")
        ,INHERITANCE("INHERITANCE", "泛化(Inheritance)")
        ,INCLUDE("INCLUDE", "包含(Include)")
        ,EXTEND("EXTEND", "扩展(Extend)")
;
           
        public final String text;
        public final String value;
        
        private UseCaseRSType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UseCaseRSType from(String value){
            switch(value){
                case "ASSOCIATION":
                    return ASSOCIATION;
                case "INHERITANCE":
                    return INHERITANCE;
                case "INCLUDE":
                    return INCLUDE;
                case "EXTEND":
                    return EXTEND;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 大数据表关系级别，数值项
     * <P>
     * <ul>
     * <li>LEVEL1&nbsp;(1)
     * <P>
     * 一级
     * <li>LEVEL2&nbsp;(2)
     * <P>
     * 二级
     * <li>LEVEL3&nbsp;(3)
     * <P>
     * 三级
     * <li>LEVEL4&nbsp;(4)
     * <P>
     * 四级
     * <li>LEVEL5&nbsp;(5)
     * <P>
     * 五级
     * <li>LEVEL6&nbsp;(6)
     * <P>
     * 六级
     * </ul>     
     */
    public static enum BDTableDERLevel{
        LEVEL1(1, "一级")
        ,LEVEL2(2, "二级")
        ,LEVEL3(3, "三级")
        ,LEVEL4(4, "四级")
        ,LEVEL5(5, "五级")
        ,LEVEL6(6, "六级")
;
           
        public final String text;
        public final int value;
        
        private BDTableDERLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static BDTableDERLevel from(int value){
            switch(value){
                case 1:
                    return LEVEL1;
                case 2:
                    return LEVEL2;
                case 3:
                    return LEVEL3;
                case 4:
                    return LEVEL4;
                case 5:
                    return LEVEL5;
                case 6:
                    return LEVEL6;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 模板样式引擎
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>V2
     * <P>
     * V2
     * </ul>     
     */
    public static enum PSTemplEngine{
        DEFAULT("DEFAULT", "默认")
        ,V2("V2", "V2")
;
           
        public final String text;
        public final String value;
        
        private PSTemplEngine(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PSTemplEngine from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "V2":
                    return V2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云系统部署数据库模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认连接
     * <li>DB2
     * <P>
     * 数据连接2
     * <li>DB3
     * <P>
     * 数据连接3
     * <li>DB4
     * <P>
     * 数据连接4
     * <li>DB5
     * <P>
     * 数据连接5
     * <li>DB6
     * <P>
     * 数据连接6
     * <li>DB7
     * <P>
     * 数据连接7
     * <li>DB8
     * <P>
     * 数据连接8
     * <li>DB9
     * <P>
     * 数据连接9
     * <li>DB10
     * <P>
     * 数据连接10
     * <li>DB11
     * <P>
     * 数据连接11
     * <li>DB12
     * <P>
     * 数据连接12
     * </ul>     
     */
    public static enum DataSourceLink{
        DEFAULT("DEFAULT", "默认连接")
        ,DB2("DB2", "数据连接2")
        ,DB3("DB3", "数据连接3")
        ,DB4("DB4", "数据连接4")
        ,DB5("DB5", "数据连接5")
        ,DB6("DB6", "数据连接6")
        ,DB7("DB7", "数据连接7")
        ,DB8("DB8", "数据连接8")
        ,DB9("DB9", "数据连接9")
        ,DB10("DB10", "数据连接10")
        ,DB11("DB11", "数据连接11")
        ,DB12("DB12", "数据连接12")
;
           
        public final String text;
        public final String value;
        
        private DataSourceLink(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSourceLink from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "DB2":
                    return DB2;
                case "DB3":
                    return DB3;
                case "DB4":
                    return DB4;
                case "DB5":
                    return DB5;
                case "DB6":
                    return DB6;
                case "DB7":
                    return DB7;
                case "DB8":
                    return DB8;
                case "DB9":
                    return DB9;
                case "DB10":
                    return DB10;
                case "DB11":
                    return DB11;
                case "DB12":
                    return DB12;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 内容高度模式
     * <P>
     * <ul>
     * <li>AUTO
     * <P>
     * 自动
     * <li>FULL
     * <P>
     * 全部高度
     * <li>PX
     * <P>
     * 像素
     * <li>PERCENTAGE
     * <P>
     * 百分比
     * </ul>     
     */
    public static enum HeightMode{
        AUTO("AUTO", "自动")
        ,FULL("FULL", "全部高度")
        ,PX("PX", "像素")
        ,PERCENTAGE("PERCENTAGE", "百分比")
;
           
        public final String text;
        public final String value;
        
        private HeightMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static HeightMode from(String value){
            switch(value){
                case "AUTO":
                    return AUTO;
                case "FULL":
                    return FULL;
                case "PX":
                    return PX;
                case "PERCENTAGE":
                    return PERCENTAGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 服务请求内容类型（外部接口使用）
     * <P>
     * <ul>
     * <li>APPLICATION_JSON&nbsp;(application/json)
     * <P>
     * application/json
     * <li>APPLICATION_FORM_URLENCODED&nbsp;(application/x-www-form-urlencoded)
     * <P>
     * application/x-www-form-urlencoded
     * <li>MULTIPART_FORM_DATA&nbsp;(multipart/form-data)
     * <P>
     * multipart/form-data
     * <li>TEXT_XML&nbsp;(text/xml)
     * <P>
     * text/xml
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum ServiceReqContentType{
        APPLICATION_JSON("application/json", "application/json")
        ,APPLICATION_FORM_URLENCODED("application/x-www-form-urlencoded", "application/x-www-form-urlencoded")
        ,MULTIPART_FORM_DATA("multipart/form-data", "multipart/form-data")
        ,TEXT_XML("text/xml", "text/xml")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private ServiceReqContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceReqContentType from(String value){
            switch(value){
                case "application/json":
                    return APPLICATION_JSON;
                case "application/x-www-form-urlencoded":
                    return APPLICATION_FORM_URLENCODED;
                case "multipart/form-data":
                    return MULTIPART_FORM_DATA;
                case "text/xml":
                    return TEXT_XML;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体查询连接类型
     * <P>
     * <ul>
     * <li>MAIN
     * <P>
     * 主查询
     * <li>NO&nbsp;(N1)
     * <P>
     * 相关N:1（INNER JOIN）
     * <li>ON&nbsp;(1N)
     * <P>
     * 存在1:N（EXISTS (SELECT)）
     * <li>ONNOT&nbsp;(1NNOT)
     * <P>
     * 不存在1:N（NOT EXISTS (SELECT)）
     * <li>INDEX
     * <P>
     * 索引/继承-主实体
     * <li>INDEXM
     * <P>
     * 索引/继承-附属实体
     * <li>NORIGHT&nbsp;(N1RIGHT)
     * <P>
     * 右联接N:1
     * <li>ONLEFTOUT&nbsp;(1NLEFTOUT)
     * <P>
     * 左外联接 1:N
     * </ul>     
     */
    public static enum DEDQJoinType{
        MAIN("MAIN", "主查询")
        ,NO("N1", "相关N:1（INNER JOIN）")
        ,ON("1N", "存在1:N（EXISTS (SELECT)）")
        ,ONNOT("1NNOT", "不存在1:N（NOT EXISTS (SELECT)）")
        ,INDEX("INDEX", "索引/继承-主实体")
        ,INDEXM("INDEXM", "索引/继承-附属实体")
        ,NORIGHT("N1RIGHT", "右联接N:1")
        ,ONLEFTOUT("1NLEFTOUT", "左外联接 1:N")
;
           
        public final String text;
        public final String value;
        
        private DEDQJoinType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDQJoinType from(String value){
            switch(value){
                case "MAIN":
                    return MAIN;
                case "N1":
                    return NO;
                case "1N":
                    return ON;
                case "1NNOT":
                    return ONNOT;
                case "INDEX":
                    return INDEX;
                case "INDEXM":
                    return INDEXM;
                case "N1RIGHT":
                    return NORIGHT;
                case "1NLEFTOUT":
                    return ONLEFTOUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件处理组织数据范围，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CURRENT&nbsp;(1)
     * <P>
     * 当前组织，当前用户的组织
     * <li>PARENT&nbsp;(2)
     * <P>
     * 上级组织，当前用户的组织的上级组织（递归）
     * <li>SUBORDINATE&nbsp;(4)
     * <P>
     * 下级组织，当前用户的组织的下级组织（递归）
     * <li>EMPTY&nbsp;(8)
     * <P>
     * 无组织值，数据未指定组织值
     * </ul>     
     */
    public static enum OrgScope{
        CURRENT(1, "当前组织")
        ,PARENT(2, "上级组织")
        ,SUBORDINATE(4, "下级组织")
        ,EMPTY(8, "无组织值")
;
           
        public final String text;
        public final int value;
        
        private OrgScope(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static OrgScope from(int value){
            switch(value){
                case 1:
                    return CURRENT;
                case 2:
                    return PARENT;
                case 4:
                    return SUBORDINATE;
                case 8:
                    return EMPTY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * IOS设备类型，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>IPHONE
     * <P>
     * iPhone
     * <li>IPAD
     * <P>
     * iPad
     * <li>APPLEWATCH
     * <P>
     * AppleWatch
     * </ul>     
     */
    public static enum IOSDeviceType{
        IPHONE("IPHONE", "iPhone")
        ,IPAD("IPAD", "iPad")
        ,APPLEWATCH("APPLEWATCH", "AppleWatch")
;
           
        public final String text;
        public final String value;
        
        private IOSDeviceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static IOSDeviceType from(String value){
            switch(value){
                case "IPHONE":
                    return IPHONE;
                case "IPAD":
                    return IPAD;
                case "APPLEWATCH":
                    return APPLEWATCH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 动态模型内容格式
     * <P>
     * <ul>
     * <li>JSON
     * <P>
     * JSON
     * <li>PROPERTIES
     * <P>
     * Properties
     * </ul>     
     */
    public static enum DynaModelContentType{
        JSON("JSON", "JSON")
        ,PROPERTIES("PROPERTIES", "Properties")
;
           
        public final String text;
        public final String value;
        
        private DynaModelContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DynaModelContentType from(String value){
            switch(value){
                case "JSON":
                    return JSON;
                case "PROPERTIES":
                    return PROPERTIES;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板模式，数值项
     * <P>
     * <ul>
     * <li>PANEL&nbsp;(0)
     * <P>
     * 面板部件，常规面板部件
     * <li>LAYOUTPANEL&nbsp;(1)
     * <P>
     * 布局面板，用于常规布局的布局面板
     * <li>VIEWLAYOUTPANEL&nbsp;(2)
     * <P>
     * 布局面板（视图增强），用于视图布局的布局面板
     * </ul>     
     */
    public static enum PanelMode{
        PANEL(0, "面板部件")
        ,LAYOUTPANEL(1, "布局面板")
        ,VIEWLAYOUTPANEL(2, "布局面板（视图增强）")
;
           
        public final String text;
        public final int value;
        
        private PanelMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelMode from(int value){
            switch(value){
                case 0:
                    return PANEL;
                case 1:
                    return LAYOUTPANEL;
                case 2:
                    return VIEWLAYOUTPANEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台数据通知监控行为（新建、更新、删除），数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 新建
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新
     * <li>REMVOE&nbsp;(4)
     * <P>
     * 删除
     * <li>USER&nbsp;(256)
     * <P>
     * 自定义
     * <li>USER2&nbsp;(512)
     * <P>
     * 自定义2
     * </ul>     
     */
    public static enum DataSyncInformType{
        CREATE(1, "新建")
        ,UPDATE(2, "更新")
        ,REMVOE(4, "删除")
        ,USER(256, "自定义")
        ,USER2(512, "自定义2")
;
           
        public final String text;
        public final int value;
        
        private DataSyncInformType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSyncInformType from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 4:
                    return REMVOE;
                case 256:
                    return USER;
                case 512:
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 分析维度体系层级类型
     * <P>
     * <ul>
     * <li>COMMON
     * <P>
     * 常规
     * <li>TIME_YEARS
     * <P>
     * 时间（年）
     * <li>TIME_HALFYEARS
     * <P>
     * 时间（半年）
     * <li>TIME_QUARTERS
     * <P>
     * 时间（季度）
     * <li>TIME_MONTHS
     * <P>
     * 时间（月份）
     * <li>TIME_WEEKS
     * <P>
     * 时间（周）
     * <li>TIME_DAYS
     * <P>
     * 时间（天）
     * <li>TIME_HOURS
     * <P>
     * 时间（小时）
     * <li>TIME_MINUTES
     * <P>
     * 时间（分钟）
     * </ul>     
     */
    public static enum BILevelType{
        COMMON("COMMON", "常规")
        ,TIME_YEARS("TIME_YEARS", "时间（年）")
        ,TIME_HALFYEARS("TIME_HALFYEARS", "时间（半年）")
        ,TIME_QUARTERS("TIME_QUARTERS", "时间（季度）")
        ,TIME_MONTHS("TIME_MONTHS", "时间（月份）")
        ,TIME_WEEKS("TIME_WEEKS", "时间（周）")
        ,TIME_DAYS("TIME_DAYS", "时间（天）")
        ,TIME_HOURS("TIME_HOURS", "时间（小时）")
        ,TIME_MINUTES("TIME_MINUTES", "时间（分钟）")
;
           
        public final String text;
        public final String value;
        
        private BILevelType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BILevelType from(String value){
            switch(value){
                case "COMMON":
                    return COMMON;
                case "TIME_YEARS":
                    return TIME_YEARS;
                case "TIME_HALFYEARS":
                    return TIME_HALFYEARS;
                case "TIME_QUARTERS":
                    return TIME_QUARTERS;
                case "TIME_MONTHS":
                    return TIME_MONTHS;
                case "TIME_WEEKS":
                    return TIME_WEEKS;
                case "TIME_DAYS":
                    return TIME_DAYS;
                case "TIME_HOURS":
                    return TIME_HOURS;
                case "TIME_MINUTES":
                    return TIME_MINUTES;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 屏幕解析度
     * <P>
     * <ul>
     * <li>ITEM_1&nbsp;(1080_1920)
     * <P>
     * 1080*1920
     * <li>ITEM_2&nbsp;(1536_2048)
     * <P>
     * 1536*2048
     * <li>ITEM_3&nbsp;(1125_2436)
     * <P>
     * 1125*2436
     * <li>ITEM_4&nbsp;(750_1334)
     * <P>
     * 750*1334
     * <li>ITEM_5&nbsp;(640_1136)
     * <P>
     * 640*1136
     * <li>ITEM_6&nbsp;(640_960)
     * <P>
     * 640*960
     * <li>ITEM_7&nbsp;(128_128)
     * <P>
     * 128*128
     * <li>ITEM_8&nbsp;(96_96)
     * <P>
     * 96*96
     * <li>ITEM_9&nbsp;(64_64)
     * <P>
     * 64*64
     * <li>ITEM_10&nbsp;(48_48)
     * <P>
     * 48*48
     * <li>ITEM_11&nbsp;(32_32)
     * <P>
     * 32*32
     * </ul>     
     */
    public static enum MobSceenResSpec{
        ITEM_1("1080_1920", "1080*1920")
        ,ITEM_2("1536_2048", "1536*2048")
        ,ITEM_3("1125_2436", "1125*2436")
        ,ITEM_4("750_1334", "750*1334")
        ,ITEM_5("640_1136", "640*1136")
        ,ITEM_6("640_960", "640*960")
        ,ITEM_7("128_128", "128*128")
        ,ITEM_8("96_96", "96*96")
        ,ITEM_9("64_64", "64*64")
        ,ITEM_10("48_48", "48*48")
        ,ITEM_11("32_32", "32*32")
;
           
        public final String text;
        public final String value;
        
        private MobSceenResSpec(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobSceenResSpec from(String value){
            switch(value){
                case "1080_1920":
                    return ITEM_1;
                case "1536_2048":
                    return ITEM_2;
                case "1125_2436":
                    return ITEM_3;
                case "750_1334":
                    return ITEM_4;
                case "640_1136":
                    return ITEM_5;
                case "640_960":
                    return ITEM_6;
                case "128_128":
                    return ITEM_7;
                case "96_96":
                    return ITEM_8;
                case "64_64":
                    return ITEM_9;
                case "48_48":
                    return ITEM_10;
                case "32_32":
                    return ITEM_11;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据库索引
     * <P>
     * <ul>
     * <li>NORMAL
     * <P>
     * 常规索引
     * <li>UNIQUE
     * <P>
     * 唯一索引
     * </ul>     
     */
    public static enum DBIndexType{
        NORMAL("NORMAL", "常规索引")
        ,UNIQUE("UNIQUE", "唯一索引")
;
           
        public final String text;
        public final String value;
        
        private DBIndexType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBIndexType from(String value){
            switch(value){
                case "NORMAL":
                    return NORMAL;
                case "UNIQUE":
                    return UNIQUE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板项间隔模式
     * <P>
     * <ul>
     * <li>OUTERNONE
     * <P>
     * Outer none
     * <li>OUTERSMALL
     * <P>
     * Outer small
     * <li>OUTERMEDIUM
     * <P>
     * Outer medium
     * <li>OUTERLARGE
     * <P>
     * Outer large
     * <li>INNERNONE
     * <P>
     * Inner none
     * <li>INNERSMALL
     * <P>
     * Inner small
     * <li>INNERMEDIUM
     * <P>
     * Inner medium
     * <li>INNERLARGE
     * <P>
     * Inner large
     * </ul>     
     */
    public static enum SpacingMode{
        OUTERNONE("OUTERNONE", "Outer none")
        ,OUTERSMALL("OUTERSMALL", "Outer small")
        ,OUTERMEDIUM("OUTERMEDIUM", "Outer medium")
        ,OUTERLARGE("OUTERLARGE", "Outer large")
        ,INNERNONE("INNERNONE", "Inner none")
        ,INNERSMALL("INNERSMALL", "Inner small")
        ,INNERMEDIUM("INNERMEDIUM", "Inner medium")
        ,INNERLARGE("INNERLARGE", "Inner large")
;
           
        public final String text;
        public final String value;
        
        private SpacingMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SpacingMode from(String value){
            switch(value){
                case "OUTERNONE":
                    return OUTERNONE;
                case "OUTERSMALL":
                    return OUTERSMALL;
                case "OUTERMEDIUM":
                    return OUTERMEDIUM;
                case "OUTERLARGE":
                    return OUTERLARGE;
                case "INNERNONE":
                    return INNERNONE;
                case "INNERSMALL":
                    return INNERSMALL;
                case "INNERMEDIUM":
                    return INNERMEDIUM;
                case "INNERLARGE":
                    return INNERLARGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单部件类型
     * <P>
     * <ul>
     * <li>FORMRF
     * <P>
     * 表单引用，表单部件来自设计时的其它表单
     * <li>DYNASYS
     * <P>
     * 动态系统，表单部件来自动态系统，在运行时引用
     * </ul>     
     */
    public static enum FormPartType{
        FORMRF("FORMRF", "表单引用")
        ,DYNASYS("DYNASYS", "动态系统")
;
           
        public final String text;
        public final String value;
        
        private FormPartType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormPartType from(String value){
            switch(value){
                case "FORMRF":
                    return FORMRF;
                case "DYNASYS":
                    return DYNASYS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体视图操作控制，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 支持建立
     * <li>EDIT&nbsp;(2)
     * <P>
     * 支持编辑
     * <li>VIEW&nbsp;(4)
     * <P>
     * 支持查看
     * <li>REMOVE&nbsp;(8)
     * <P>
     * 支持删除
     * <li>COPY&nbsp;(16)
     * <P>
     * 支持拷贝
     * <li>ROWEDIT&nbsp;(32)
     * <P>
     * 支持行编辑
     * <li>EXPORT&nbsp;(64)
     * <P>
     * 支持导出
     * <li>IMPORT&nbsp;(1024)
     * <P>
     * 支持导入
     * <li>PRINT&nbsp;(128)
     * <P>
     * 支持打印
     * <li>FILTER&nbsp;(256)
     * <P>
     * 支持过滤
     * <li>HELP&nbsp;(512)
     * <P>
     * 支持帮助
     * <li>STARTWF&nbsp;(2048)
     * <P>
     * 支持启动流程
     * </ul>     
     */
    public static enum DEViewAction{
        CREATE(1, "支持建立")
        ,EDIT(2, "支持编辑")
        ,VIEW(4, "支持查看")
        ,REMOVE(8, "支持删除")
        ,COPY(16, "支持拷贝")
        ,ROWEDIT(32, "支持行编辑")
        ,EXPORT(64, "支持导出")
        ,IMPORT(1024, "支持导入")
        ,PRINT(128, "支持打印")
        ,FILTER(256, "支持过滤")
        ,HELP(512, "支持帮助")
        ,STARTWF(2048, "支持启动流程")
;
           
        public final String text;
        public final int value;
        
        private DEViewAction(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEViewAction from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return EDIT;
                case 4:
                    return VIEW;
                case 8:
                    return REMOVE;
                case 16:
                    return COPY;
                case 32:
                    return ROWEDIT;
                case 64:
                    return EXPORT;
                case 1024:
                    return IMPORT;
                case 128:
                    return PRINT;
                case 256:
                    return FILTER;
                case 512:
                    return HELP;
                case 2048:
                    return STARTWF;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 索引实体类型
     * <P>
     * <ul>
     * <li>INDEX
     * <P>
     * 索引主实体，索引从实体都为独立实体，在建立、更新、删除数据时都会同步至索引主实体，索引从实体可以同时有多个索引主实体
     * <li>INHERIT
     * <P>
     * 继承主实体，顾名思义，继承主实体是继承从实体的父实体，继承从实体不独立存在，需要与主实体一起完成功能，继承从实体只允许有一个继承主实体
     * </ul>     
     */
    public static enum DEIndexType{
        INDEX("INDEX", "索引主实体")
        ,INHERIT("INHERIT", "继承主实体")
;
           
        public final String text;
        public final String value;
        
        private DEIndexType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEIndexType from(String value){
            switch(value){
                case "INDEX":
                    return INDEX;
                case "INHERIT":
                    return INHERIT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 脚本引擎
     * <P>
     * <ul>
     * <li>JAVASCRIPT&nbsp;(JavaScript)
     * <P>
     * JavaScript
     * <li>GROOVY&nbsp;(Groovy)
     * <P>
     * Groovy
     * </ul>     
     */
    public static enum ScriptEngine{
        JAVASCRIPT("JavaScript", "JavaScript")
        ,GROOVY("Groovy", "Groovy")
;
           
        public final String text;
        public final String value;
        
        private ScriptEngine(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ScriptEngine from(String value){
            switch(value){
                case "JavaScript":
                    return JAVASCRIPT;
                case "Groovy":
                    return GROOVY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体逻辑类型
     * <P>
     * <ul>
     * <li>DELOGIC
     * <P>
     * 实体处理逻辑，面向业务的处理逻辑
     * <li>VIEWLOGIC
     * <P>
     * 视图处理逻辑，面向界面的交互处理逻辑
     * <li>MAINSTATELOGIC
     * <P>
     * 主状态迁移逻辑，主状态切换路由逻辑
     * <li>DATAFLOWLOGIC
     * <P>
     * 数据流逻辑
     * </ul>     
     */
    public static enum LogicType{
        DELOGIC("DELOGIC", "实体处理逻辑")
        ,VIEWLOGIC("VIEWLOGIC", "视图处理逻辑")
        ,MAINSTATELOGIC("MAINSTATELOGIC", "主状态迁移逻辑")
        ,DATAFLOWLOGIC("DATAFLOWLOGIC", "数据流逻辑")
;
           
        public final String text;
        public final String value;
        
        private LogicType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LogicType from(String value){
            switch(value){
                case "DELOGIC":
                    return DELOGIC;
                case "VIEWLOGIC":
                    return VIEWLOGIC;
                case "MAINSTATELOGIC":
                    return MAINSTATELOGIC;
                case "DATAFLOWLOGIC":
                    return DATAFLOWLOGIC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图布局面板引用模式，数值项
     * <P>
     * <ul>
     * <li>DEFAULT&nbsp;(0)
     * <P>
     * 默认布局面板
     * <li>REF&nbsp;(1)
     * <P>
     * 指定布局面板
     * <li>REFANDADMIN&nbsp;(2)
     * <P>
     * 指定布局面板（管理）
     * </ul>     
     */
    public static enum LayoutPanelMode{
        DEFAULT(0, "默认布局面板")
        ,REF(1, "指定布局面板")
        ,REFANDADMIN(2, "指定布局面板（管理）")
;
           
        public final String text;
        public final int value;
        
        private LayoutPanelMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static LayoutPanelMode from(int value){
            switch(value){
                case 0:
                    return DEFAULT;
                case 1:
                    return REF;
                case 2:
                    return REFANDADMIN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性业务标记
     * <P>
     * <ul>
     * <li>WFINSTANCEID
     * <P>
     * 流程实例标识
     * <li>WFSTEP
     * <P>
     * 流程实例步骤值，流程实例在流程中的步骤值
     * <li>WFUSERSTATE
     * <P>
     * 流程实例业务状态
     * <li>WFVERSION
     * <P>
     * 流程实例版本，流程实例使用的工作流版本
     * <li>WFSTATE
     * <P>
     * 流程实例状态，流程实例的系统级状态
     * <li>BEGINTIME
     * <P>
     * 开始时间
     * <li>ENDTIME
     * <P>
     * 结束时间
     * <li>DURATION
     * <P>
     * 持续时间
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * <li>USER5
     * <P>
     * 用户自定义5
     * <li>USER6
     * <P>
     * 用户自定义6
     * <li>USER7
     * <P>
     * 用户自定义7
     * <li>USER8
     * <P>
     * 用户自定义8
     * <li>USER9
     * <P>
     * 用户自定义9
     * </ul>     
     */
    public static enum DEFBizTag{
        WFINSTANCEID("WFINSTANCEID", "流程实例标识")
        ,WFSTEP("WFSTEP", "流程实例步骤值")
        ,WFUSERSTATE("WFUSERSTATE", "流程实例业务状态")
        ,WFVERSION("WFVERSION", "流程实例版本")
        ,WFSTATE("WFSTATE", "流程实例状态")
        ,BEGINTIME("BEGINTIME", "开始时间")
        ,ENDTIME("ENDTIME", "结束时间")
        ,DURATION("DURATION", "持续时间")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
        ,USER5("USER5", "用户自定义5")
        ,USER6("USER6", "用户自定义6")
        ,USER7("USER7", "用户自定义7")
        ,USER8("USER8", "用户自定义8")
        ,USER9("USER9", "用户自定义9")
;
           
        public final String text;
        public final String value;
        
        private DEFBizTag(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFBizTag from(String value){
            switch(value){
                case "WFINSTANCEID":
                    return WFINSTANCEID;
                case "WFSTEP":
                    return WFSTEP;
                case "WFUSERSTATE":
                    return WFUSERSTATE;
                case "WFVERSION":
                    return WFVERSION;
                case "WFSTATE":
                    return WFSTATE;
                case "BEGINTIME":
                    return BEGINTIME;
                case "ENDTIME":
                    return ENDTIME;
                case "DURATION":
                    return DURATION;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                case "USER5":
                    return USER5;
                case "USER6":
                    return USER6;
                case "USER7":
                    return USER7;
                case "USER8":
                    return USER8;
                case "USER9":
                    return USER9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑连接条件参数类型
     * <P>
     * <ul>
     * <li>ENTITYFIELD
     * <P>
     * 目标逻辑参数属性，值来自当前数据对象的指定属性
     * <li>SRCENTITYFIELD
     * <P>
     * 源逻辑参数属性，值来自源对象的指定属性
     * <li>SRCDLPARAM
     * <P>
     * 源逻辑参数
     * <li>CURTIME
     * <P>
     * 当前时间，值为当前时间
     * </ul>     
     */
    public static enum DELLCondParamType{
        ENTITYFIELD("ENTITYFIELD", "目标逻辑参数属性")
        ,SRCENTITYFIELD("SRCENTITYFIELD", "源逻辑参数属性")
        ,SRCDLPARAM("SRCDLPARAM", "源逻辑参数")
        ,CURTIME("CURTIME", "当前时间")
;
           
        public final String text;
        public final String value;
        
        private DELLCondParamType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELLCondParamType from(String value){
            switch(value){
                case "ENTITYFIELD":
                    return ENTITYFIELD;
                case "SRCENTITYFIELD":
                    return SRCENTITYFIELD;
                case "SRCDLPARAM":
                    return SRCDLPARAM;
                case "CURTIME":
                    return CURTIME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单多数据部件遮罩模式，数值项
     * <P>
     * <ul>
     * <li>AUTO&nbsp;(-1)
     * <P>
     * 自动判断
     * <li>INVISIBLE&nbsp;(0)
     * <P>
     * 不显示
     * <li>NEWDATA&nbsp;(1)
     * <P>
     * 新建数据时遮盖
     * </ul>     
     */
    public static enum FormDRUIPartMaskMode{
        AUTO(-1, "自动判断")
        ,INVISIBLE(0, "不显示")
        ,NEWDATA(1, "新建数据时遮盖")
;
           
        public final String text;
        public final int value;
        
        private FormDRUIPartMaskMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormDRUIPartMaskMode from(int value){
            switch(value){
                case -1:
                    return AUTO;
                case 0:
                    return INVISIBLE;
                case 1:
                    return NEWDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为类型
     * <P>
     * <ul>
     * <li>USERCUSTOM
     * <P>
     * 用户自定义
     * <li>DELOGIC
     * <P>
     * 实体处理逻辑
     * <li>BUILTIN
     * <P>
     * 内置方法
     * <li>SELECTBYKEY
     * <P>
     * 通过键值获取
     * <li>USERCREATE
     * <P>
     * 用户扩展建立
     * <li>USERUPDATE
     * <P>
     * 用户扩展更新
     * <li>USERSYSUPDATE
     * <P>
     * 用户扩展系统更新
     * <li>SCRIPT
     * <P>
     * 脚本代码
     * <li>REMOTE
     * <P>
     * 远程接口行为
     * </ul>     
     */
    public static enum DEActionType{
        USERCUSTOM("USERCUSTOM", "用户自定义")
        ,DELOGIC("DELOGIC", "实体处理逻辑")
        ,BUILTIN("BUILTIN", "内置方法")
        ,SELECTBYKEY("SELECTBYKEY", "通过键值获取")
        ,USERCREATE("USERCREATE", "用户扩展建立")
        ,USERUPDATE("USERUPDATE", "用户扩展更新")
        ,USERSYSUPDATE("USERSYSUPDATE", "用户扩展系统更新")
        ,SCRIPT("SCRIPT", "脚本代码")
        ,REMOTE("REMOTE", "远程接口行为")
;
           
        public final String text;
        public final String value;
        
        private DEActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionType from(String value){
            switch(value){
                case "USERCUSTOM":
                    return USERCUSTOM;
                case "DELOGIC":
                    return DELOGIC;
                case "BUILTIN":
                    return BUILTIN;
                case "SELECTBYKEY":
                    return SELECTBYKEY;
                case "USERCREATE":
                    return USERCREATE;
                case "USERUPDATE":
                    return USERUPDATE;
                case "USERSYSUPDATE":
                    return USERSYSUPDATE;
                case "SCRIPT":
                    return SCRIPT;
                case "REMOTE":
                    return REMOTE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体搜索栏样式
     * <P>
     * <ul>
     * <li>SEARCHBAR
     * <P>
     * 搜索栏
     * <li>SEARCHBAR2
     * <P>
     * 搜索栏2
     * <li>MOBSEARCHBAR
     * <P>
     * 移动端搜索栏
     * <li>MOBSEARCHBAR2
     * <P>
     * 移动端搜索栏2
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum SearchBarStyle{
        SEARCHBAR("SEARCHBAR", "搜索栏")
        ,SEARCHBAR2("SEARCHBAR2", "搜索栏2")
        ,MOBSEARCHBAR("MOBSEARCHBAR", "移动端搜索栏")
        ,MOBSEARCHBAR2("MOBSEARCHBAR2", "移动端搜索栏2")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private SearchBarStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchBarStyle from(String value){
            switch(value){
                case "SEARCHBAR":
                    return SEARCHBAR;
                case "SEARCHBAR2":
                    return SEARCHBAR2;
                case "MOBSEARCHBAR":
                    return MOBSEARCHBAR;
                case "MOBSEARCHBAR2":
                    return MOBSEARCHBAR2;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 全部编辑器类型
     * <P>
     * <ul>
     * <li>TEXTBOX
     * <P>
     * 文本框
     * <li>NUMBER
     * <P>
     * 数值框
     * <li>PASSWORD
     * <P>
     * 密码框
     * <li>HIDDEN
     * <P>
     * 隐藏表单项
     * <li>TEXTAREA
     * <P>
     * 多行输入框
     * <li>TEXTAREA_10
     * <P>
     * 多行输入框（10行）
     * <li>IPADDRESSTEXTBOX
     * <P>
     * IP地址输入框
     * <li>RAW
     * <P>
     * 直接内容
     * <li>STEPPER
     * <P>
     * 步进器
     * <li>RATING
     * <P>
     * 评分器
     * <li>SLIDER
     * <P>
     * 滑动输入条
     * <li>SPAN
     * <P>
     * 标签
     * <li>SPANEX
     * <P>
     * 标签（旧）
     * <li>SPAN_LINK
     * <P>
     * 标签（数据链接）
     * <li>DROPDOWNLIST
     * <P>
     * 下拉列表框
     * <li>DROPDOWNLIST_100
     * <P>
     * 下拉列表框（100宽度）
     * <li>MDROPDOWNLIST
     * <P>
     * 下拉列表框（多选）
     * <li>CHECKBOX
     * <P>
     * 选项框
     * <li>SWITCH
     * <P>
     * 开关部件
     * <li>RADIOBUTTONLIST
     * <P>
     * 单选项列表
     * <li>CHECKBOXLIST
     * <P>
     * 选项框列表
     * <li>LISTBOX
     * <P>
     * 列表框
     * <li>LISTBOXPICKUP
     * <P>
     * 列表框（选择）
     * <li>ADDRESSPICKUP
     * <P>
     * 地址框（选择）
     * <li>ADDRESSPICKUP_AC
     * <P>
     * 地址框（支持选择、AC）
     * <li>DATEPICKEREX
     * <P>
     * 时间选择器（旧）
     * <li>DATEPICKEREX_NOTIME
     * <P>
     * 时间选择器（YYYY-MM-DD）
     * <li>DATEPICKEREX_NODAY
     * <P>
     * 时间选择器（HH:mm:ss）
     * <li>DATEPICKEREX_HOUR
     * <P>
     * 时间选择器（YYYY-MM-DD HH）
     * <li>DATEPICKEREX_MINUTE
     * <P>
     * 时间选择器（YYYY-MM-DD HH:mm）
     * <li>DATEPICKEREX_SECOND
     * <P>
     * 时间选择器（YYYY-MM-DD HH:mm:ss）
     * <li>DATEPICKEREX_NODAY_NOSECOND
     * <P>
     * 时间选择器（HH:mm）
     * <li>DATEPICKER
     * <P>
     * 时间选择器
     * <li>PICKER
     * <P>
     * 数据选择
     * <li>PICKEREX_LINK
     * <P>
     * 数据选择（数据链接）
     * <li>PICKEREX_NOAC
     * <P>
     * 数据选择（无AC）
     * <li>PICKEREX_LINKONLY
     * <P>
     * 数据链接
     * <li>PICKEREX_NOAC_LINK
     * <P>
     * 数据选择（无AC、数据链接）
     * <li>PICKEREX_TRIGGER
     * <P>
     * 数据选择（下拉）
     * <li>PICKEREX_TRIGGER_LINK
     * <P>
     * 数据选择（下拉、数据链接）
     * <li>PICKEREX_NOBUTTON
     * <P>
     * 数据选择（无按钮）
     * <li>PICKEREX_DROPDOWNVIEW
     * <P>
     * 数据选择（下拉视图）
     * <li>PICKEREX_DROPDOWNVIEW_LINK
     * <P>
     * 数据选择（下拉视图、数据链接）
     * <li>PICKUPVIEW
     * <P>
     * 数据选择（嵌入选择视图）
     * <li>AC
     * <P>
     * 自动填充
     * <li>AC_FS
     * <P>
     * 自动填充（只能选择）
     * <li>AC_NOBUTTON
     * <P>
     * 自动填充（无按钮）
     * <li>AC_FS_NOBUTTON
     * <P>
     * 自动填充（只能选择、无按钮）
     * <li>HTMLEDITOR
     * <P>
     * HTML编辑框
     * <li>CODE
     * <P>
     * 代码编辑框
     * <li>MARKDOWN
     * <P>
     * Markdown编辑框
     * <li>OFFICEEDITOR
     * <P>
     * Office文档编辑器
     * <li>OFFICEEDITOR2
     * <P>
     * Office文档编辑器2（弹出编辑，返回内容）
     * <li>PICTURE
     * <P>
     * 图片控件
     * <li>PICTURE_ONE
     * <P>
     * 图片控件（单项）
     * <li>PICTURE_ONE_RAW
     * <P>
     * 图片控件（单项、直接内容）
     * <li>FILEUPLOADER
     * <P>
     * 文件控件
     * <li>PREDEFINED
     * <P>
     * 预定义编辑器
     * <li>FILEUPLOADER_ONE
     * <P>
     * 文件控件（单项）
     * <li>NUMBERRANGE
     * <P>
     * 数值范围编辑框
     * <li>DATERANGE
     * <P>
     * 时间范围选择器
     * <li>DATERANGE_NOTIME
     * <P>
     * 时间范围选择器（YYYY-MM-DD）
     * <li>CASCADER
     * <P>
     * 级联选择器
     * <li>ARRAY
     * <P>
     * 数组编辑器
     * <li>COLORPICKER
     * <P>
     * 颜色选择器
     * <li>MAPPICKER
     * <P>
     * 地图选择器
     * <li>USERCONTROL
     * <P>
     * 用户自定义
     * <li>MOBTEXT
     * <P>
     * 移动端文本框
     * <li>MOBNUMBER
     * <P>
     * 移动端数值框
     * <li>MOBTEXTAREA
     * <P>
     * 移动端多行文本
     * <li>MOBBARCODEREADER
     * <P>
     * 移动端条码阅读器
     * <li>MOBSWITCH
     * <P>
     * 移动端开关部件
     * <li>MOB2DBARCODEREADER
     * <P>
     * 移动端二维码阅读器
     * <li>MOBRADIOLIST
     * <P>
     * 移动端单选项列表
     * <li>MOBDROPDOWNLIST
     * <P>
     * 移动端下拉列表（单选）
     * <li>MOBCHECKLIST
     * <P>
     * 移动端下拉列表（多选）
     * <li>MOBPICKER
     * <P>
     * 移动端数据选择
     * <li>MOBPICKER_DROPDOWNVIEW
     * <P>
     * 移动端数据选择（下拉视图）
     * <li>MOBMPICKER
     * <P>
     * 移动端多数据选择
     * <li>MOBDATE
     * <P>
     * 移动端时间选择器
     * <li>MOBDATE_HOUR
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH）
     * <li>MOBDATE_MINUTE
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH:mm）
     * <li>MOBDATE_NODAY
     * <P>
     * 移动端时间选择器（HH:mm:ss）
     * <li>MOBDATE_NODAY_NOSECOND
     * <P>
     * 移动端时间选择器（HH:mm）
     * <li>MOBDATE_NOTIME
     * <P>
     * 移动端时间选择器（YYYY-MM-DD）
     * <li>MOBDATE_SECOND
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH:mm:ss）
     * <li>MOBPICTURE
     * <P>
     * 移动端图片控件（单项）
     * <li>MOBSINGLEFILEUPLOAD
     * <P>
     * 移动端文件控件（单项）
     * <li>MOBPICTURE_RAW
     * <P>
     * 移动端图片控件（单项、直接内容）
     * <li>MOBPICTURELIST
     * <P>
     * 移动端图片控件（多项）
     * <li>MOBMULTIFILEUPLOAD
     * <P>
     * 移动端文件控件（多项）
     * <li>MOBPASSWORD
     * <P>
     * 移动端密码框
     * <li>MOBSLIDER
     * <P>
     * 移动端滑动输入条
     * <li>MOBSTEPPER
     * <P>
     * 移动端步进器
     * <li>MOBRATING
     * <P>
     * 移动端评分器
     * <li>MOBHTMLTEXT
     * <P>
     * 移动端HTML编辑框
     * <li>MOBCODE
     * <P>
     * 移动端代码编辑框
     * <li>MOBMARKDOWN
     * <P>
     * 移动端Markdown编辑框
     * <li>MOBNUMBERRANGE
     * <P>
     * 移动端数值范围编辑框
     * <li>MOBDATERANGE
     * <P>
     * 移动端时间范围选择器
     * <li>MOBDATERANGE_NOTIME
     * <P>
     * 移动端时间范围选择器（YYYY-MM-DD）
     * <li>MOBCASCADER
     * <P>
     * 移动端级联选择器
     * <li>MOBARRAY
     * <P>
     * 移动端数组编辑器
     * <li>MOBMAPPICKER
     * <P>
     * 移动端地图选择器
     * <li>MOBCOLORPICKER
     * <P>
     * 移动端颜色选择器
     * </ul>     
     */
    public static enum EditorType{
        TEXTBOX("TEXTBOX", "文本框")
        ,NUMBER("NUMBER", "数值框")
        ,PASSWORD("PASSWORD", "密码框")
        ,HIDDEN("HIDDEN", "隐藏表单项")
        ,TEXTAREA("TEXTAREA", "多行输入框")
        ,TEXTAREA_10("TEXTAREA_10", "多行输入框（10行）")
        ,IPADDRESSTEXTBOX("IPADDRESSTEXTBOX", "IP地址输入框")
        ,RAW("RAW", "直接内容")
        ,STEPPER("STEPPER", "步进器")
        ,RATING("RATING", "评分器")
        ,SLIDER("SLIDER", "滑动输入条")
        ,SPAN("SPAN", "标签")
        ,SPANEX("SPANEX", "标签（旧）")
        ,SPAN_LINK("SPAN_LINK", "标签（数据链接）")
        ,DROPDOWNLIST("DROPDOWNLIST", "下拉列表框")
        ,DROPDOWNLIST_100("DROPDOWNLIST_100", "下拉列表框（100宽度）")
        ,MDROPDOWNLIST("MDROPDOWNLIST", "下拉列表框（多选）")
        ,CHECKBOX("CHECKBOX", "选项框")
        ,SWITCH("SWITCH", "开关部件")
        ,RADIOBUTTONLIST("RADIOBUTTONLIST", "单选项列表")
        ,CHECKBOXLIST("CHECKBOXLIST", "选项框列表")
        ,LISTBOX("LISTBOX", "列表框")
        ,LISTBOXPICKUP("LISTBOXPICKUP", "列表框（选择）")
        ,ADDRESSPICKUP("ADDRESSPICKUP", "地址框（选择）")
        ,ADDRESSPICKUP_AC("ADDRESSPICKUP_AC", "地址框（支持选择、AC）")
        ,DATEPICKEREX("DATEPICKEREX", "时间选择器（旧）")
        ,DATEPICKEREX_NOTIME("DATEPICKEREX_NOTIME", "时间选择器（YYYY-MM-DD）")
        ,DATEPICKEREX_NODAY("DATEPICKEREX_NODAY", "时间选择器（HH:mm:ss）")
        ,DATEPICKEREX_HOUR("DATEPICKEREX_HOUR", "时间选择器（YYYY-MM-DD HH）")
        ,DATEPICKEREX_MINUTE("DATEPICKEREX_MINUTE", "时间选择器（YYYY-MM-DD HH:mm）")
        ,DATEPICKEREX_SECOND("DATEPICKEREX_SECOND", "时间选择器（YYYY-MM-DD HH:mm:ss）")
        ,DATEPICKEREX_NODAY_NOSECOND("DATEPICKEREX_NODAY_NOSECOND", "时间选择器（HH:mm）")
        ,DATEPICKER("DATEPICKER", "时间选择器")
        ,PICKER("PICKER", "数据选择")
        ,PICKEREX_LINK("PICKEREX_LINK", "数据选择（数据链接）")
        ,PICKEREX_NOAC("PICKEREX_NOAC", "数据选择（无AC）")
        ,PICKEREX_LINKONLY("PICKEREX_LINKONLY", "数据链接")
        ,PICKEREX_NOAC_LINK("PICKEREX_NOAC_LINK", "数据选择（无AC、数据链接）")
        ,PICKEREX_TRIGGER("PICKEREX_TRIGGER", "数据选择（下拉）")
        ,PICKEREX_TRIGGER_LINK("PICKEREX_TRIGGER_LINK", "数据选择（下拉、数据链接）")
        ,PICKEREX_NOBUTTON("PICKEREX_NOBUTTON", "数据选择（无按钮）")
        ,PICKEREX_DROPDOWNVIEW("PICKEREX_DROPDOWNVIEW", "数据选择（下拉视图）")
        ,PICKEREX_DROPDOWNVIEW_LINK("PICKEREX_DROPDOWNVIEW_LINK", "数据选择（下拉视图、数据链接）")
        ,PICKUPVIEW("PICKUPVIEW", "数据选择（嵌入选择视图）")
        ,AC("AC", "自动填充")
        ,AC_FS("AC_FS", "自动填充（只能选择）")
        ,AC_NOBUTTON("AC_NOBUTTON", "自动填充（无按钮）")
        ,AC_FS_NOBUTTON("AC_FS_NOBUTTON", "自动填充（只能选择、无按钮）")
        ,HTMLEDITOR("HTMLEDITOR", "HTML编辑框")
        ,CODE("CODE", "代码编辑框")
        ,MARKDOWN("MARKDOWN", "Markdown编辑框")
        ,OFFICEEDITOR("OFFICEEDITOR", "Office文档编辑器")
        ,OFFICEEDITOR2("OFFICEEDITOR2", "Office文档编辑器2（弹出编辑，返回内容）")
        ,PICTURE("PICTURE", "图片控件")
        ,PICTURE_ONE("PICTURE_ONE", "图片控件（单项）")
        ,PICTURE_ONE_RAW("PICTURE_ONE_RAW", "图片控件（单项、直接内容）")
        ,FILEUPLOADER("FILEUPLOADER", "文件控件")
        ,PREDEFINED("PREDEFINED", "预定义编辑器")
        ,FILEUPLOADER_ONE("FILEUPLOADER_ONE", "文件控件（单项）")
        ,NUMBERRANGE("NUMBERRANGE", "数值范围编辑框")
        ,DATERANGE("DATERANGE", "时间范围选择器")
        ,DATERANGE_NOTIME("DATERANGE_NOTIME", "时间范围选择器（YYYY-MM-DD）")
        ,CASCADER("CASCADER", "级联选择器")
        ,ARRAY("ARRAY", "数组编辑器")
        ,COLORPICKER("COLORPICKER", "颜色选择器")
        ,MAPPICKER("MAPPICKER", "地图选择器")
        ,USERCONTROL("USERCONTROL", "用户自定义")
        ,MOBTEXT("MOBTEXT", "移动端文本框")
        ,MOBNUMBER("MOBNUMBER", "移动端数值框")
        ,MOBTEXTAREA("MOBTEXTAREA", "移动端多行文本")
        ,MOBBARCODEREADER("MOBBARCODEREADER", "移动端条码阅读器")
        ,MOBSWITCH("MOBSWITCH", "移动端开关部件")
        ,MOB2DBARCODEREADER("MOB2DBARCODEREADER", "移动端二维码阅读器")
        ,MOBRADIOLIST("MOBRADIOLIST", "移动端单选项列表")
        ,MOBDROPDOWNLIST("MOBDROPDOWNLIST", "移动端下拉列表（单选）")
        ,MOBCHECKLIST("MOBCHECKLIST", "移动端下拉列表（多选）")
        ,MOBPICKER("MOBPICKER", "移动端数据选择")
        ,MOBPICKER_DROPDOWNVIEW("MOBPICKER_DROPDOWNVIEW", "移动端数据选择（下拉视图）")
        ,MOBMPICKER("MOBMPICKER", "移动端多数据选择")
        ,MOBDATE("MOBDATE", "移动端时间选择器")
        ,MOBDATE_HOUR("MOBDATE_HOUR", "移动端时间选择器（YYYY-MM-DD HH）")
        ,MOBDATE_MINUTE("MOBDATE_MINUTE", "移动端时间选择器（YYYY-MM-DD HH:mm）")
        ,MOBDATE_NODAY("MOBDATE_NODAY", "移动端时间选择器（HH:mm:ss）")
        ,MOBDATE_NODAY_NOSECOND("MOBDATE_NODAY_NOSECOND", "移动端时间选择器（HH:mm）")
        ,MOBDATE_NOTIME("MOBDATE_NOTIME", "移动端时间选择器（YYYY-MM-DD）")
        ,MOBDATE_SECOND("MOBDATE_SECOND", "移动端时间选择器（YYYY-MM-DD HH:mm:ss）")
        ,MOBPICTURE("MOBPICTURE", "移动端图片控件（单项）")
        ,MOBSINGLEFILEUPLOAD("MOBSINGLEFILEUPLOAD", "移动端文件控件（单项）")
        ,MOBPICTURE_RAW("MOBPICTURE_RAW", "移动端图片控件（单项、直接内容）")
        ,MOBPICTURELIST("MOBPICTURELIST", "移动端图片控件（多项）")
        ,MOBMULTIFILEUPLOAD("MOBMULTIFILEUPLOAD", "移动端文件控件（多项）")
        ,MOBPASSWORD("MOBPASSWORD", "移动端密码框")
        ,MOBSLIDER("MOBSLIDER", "移动端滑动输入条")
        ,MOBSTEPPER("MOBSTEPPER", "移动端步进器")
        ,MOBRATING("MOBRATING", "移动端评分器")
        ,MOBHTMLTEXT("MOBHTMLTEXT", "移动端HTML编辑框")
        ,MOBCODE("MOBCODE", "移动端代码编辑框")
        ,MOBMARKDOWN("MOBMARKDOWN", "移动端Markdown编辑框")
        ,MOBNUMBERRANGE("MOBNUMBERRANGE", "移动端数值范围编辑框")
        ,MOBDATERANGE("MOBDATERANGE", "移动端时间范围选择器")
        ,MOBDATERANGE_NOTIME("MOBDATERANGE_NOTIME", "移动端时间范围选择器（YYYY-MM-DD）")
        ,MOBCASCADER("MOBCASCADER", "移动端级联选择器")
        ,MOBARRAY("MOBARRAY", "移动端数组编辑器")
        ,MOBMAPPICKER("MOBMAPPICKER", "移动端地图选择器")
        ,MOBCOLORPICKER("MOBCOLORPICKER", "移动端颜色选择器")
;
           
        public final String text;
        public final String value;
        
        private EditorType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditorType from(String value){
            switch(value){
                case "TEXTBOX":
                    return TEXTBOX;
                case "NUMBER":
                    return NUMBER;
                case "PASSWORD":
                    return PASSWORD;
                case "HIDDEN":
                    return HIDDEN;
                case "TEXTAREA":
                    return TEXTAREA;
                case "TEXTAREA_10":
                    return TEXTAREA_10;
                case "IPADDRESSTEXTBOX":
                    return IPADDRESSTEXTBOX;
                case "RAW":
                    return RAW;
                case "STEPPER":
                    return STEPPER;
                case "RATING":
                    return RATING;
                case "SLIDER":
                    return SLIDER;
                case "SPAN":
                    return SPAN;
                case "SPANEX":
                    return SPANEX;
                case "SPAN_LINK":
                    return SPAN_LINK;
                case "DROPDOWNLIST":
                    return DROPDOWNLIST;
                case "DROPDOWNLIST_100":
                    return DROPDOWNLIST_100;
                case "MDROPDOWNLIST":
                    return MDROPDOWNLIST;
                case "CHECKBOX":
                    return CHECKBOX;
                case "SWITCH":
                    return SWITCH;
                case "RADIOBUTTONLIST":
                    return RADIOBUTTONLIST;
                case "CHECKBOXLIST":
                    return CHECKBOXLIST;
                case "LISTBOX":
                    return LISTBOX;
                case "LISTBOXPICKUP":
                    return LISTBOXPICKUP;
                case "ADDRESSPICKUP":
                    return ADDRESSPICKUP;
                case "ADDRESSPICKUP_AC":
                    return ADDRESSPICKUP_AC;
                case "DATEPICKEREX":
                    return DATEPICKEREX;
                case "DATEPICKEREX_NOTIME":
                    return DATEPICKEREX_NOTIME;
                case "DATEPICKEREX_NODAY":
                    return DATEPICKEREX_NODAY;
                case "DATEPICKEREX_HOUR":
                    return DATEPICKEREX_HOUR;
                case "DATEPICKEREX_MINUTE":
                    return DATEPICKEREX_MINUTE;
                case "DATEPICKEREX_SECOND":
                    return DATEPICKEREX_SECOND;
                case "DATEPICKEREX_NODAY_NOSECOND":
                    return DATEPICKEREX_NODAY_NOSECOND;
                case "DATEPICKER":
                    return DATEPICKER;
                case "PICKER":
                    return PICKER;
                case "PICKEREX_LINK":
                    return PICKEREX_LINK;
                case "PICKEREX_NOAC":
                    return PICKEREX_NOAC;
                case "PICKEREX_LINKONLY":
                    return PICKEREX_LINKONLY;
                case "PICKEREX_NOAC_LINK":
                    return PICKEREX_NOAC_LINK;
                case "PICKEREX_TRIGGER":
                    return PICKEREX_TRIGGER;
                case "PICKEREX_TRIGGER_LINK":
                    return PICKEREX_TRIGGER_LINK;
                case "PICKEREX_NOBUTTON":
                    return PICKEREX_NOBUTTON;
                case "PICKEREX_DROPDOWNVIEW":
                    return PICKEREX_DROPDOWNVIEW;
                case "PICKEREX_DROPDOWNVIEW_LINK":
                    return PICKEREX_DROPDOWNVIEW_LINK;
                case "PICKUPVIEW":
                    return PICKUPVIEW;
                case "AC":
                    return AC;
                case "AC_FS":
                    return AC_FS;
                case "AC_NOBUTTON":
                    return AC_NOBUTTON;
                case "AC_FS_NOBUTTON":
                    return AC_FS_NOBUTTON;
                case "HTMLEDITOR":
                    return HTMLEDITOR;
                case "CODE":
                    return CODE;
                case "MARKDOWN":
                    return MARKDOWN;
                case "OFFICEEDITOR":
                    return OFFICEEDITOR;
                case "OFFICEEDITOR2":
                    return OFFICEEDITOR2;
                case "PICTURE":
                    return PICTURE;
                case "PICTURE_ONE":
                    return PICTURE_ONE;
                case "PICTURE_ONE_RAW":
                    return PICTURE_ONE_RAW;
                case "FILEUPLOADER":
                    return FILEUPLOADER;
                case "PREDEFINED":
                    return PREDEFINED;
                case "FILEUPLOADER_ONE":
                    return FILEUPLOADER_ONE;
                case "NUMBERRANGE":
                    return NUMBERRANGE;
                case "DATERANGE":
                    return DATERANGE;
                case "DATERANGE_NOTIME":
                    return DATERANGE_NOTIME;
                case "CASCADER":
                    return CASCADER;
                case "ARRAY":
                    return ARRAY;
                case "COLORPICKER":
                    return COLORPICKER;
                case "MAPPICKER":
                    return MAPPICKER;
                case "USERCONTROL":
                    return USERCONTROL;
                case "MOBTEXT":
                    return MOBTEXT;
                case "MOBNUMBER":
                    return MOBNUMBER;
                case "MOBTEXTAREA":
                    return MOBTEXTAREA;
                case "MOBBARCODEREADER":
                    return MOBBARCODEREADER;
                case "MOBSWITCH":
                    return MOBSWITCH;
                case "MOB2DBARCODEREADER":
                    return MOB2DBARCODEREADER;
                case "MOBRADIOLIST":
                    return MOBRADIOLIST;
                case "MOBDROPDOWNLIST":
                    return MOBDROPDOWNLIST;
                case "MOBCHECKLIST":
                    return MOBCHECKLIST;
                case "MOBPICKER":
                    return MOBPICKER;
                case "MOBPICKER_DROPDOWNVIEW":
                    return MOBPICKER_DROPDOWNVIEW;
                case "MOBMPICKER":
                    return MOBMPICKER;
                case "MOBDATE":
                    return MOBDATE;
                case "MOBDATE_HOUR":
                    return MOBDATE_HOUR;
                case "MOBDATE_MINUTE":
                    return MOBDATE_MINUTE;
                case "MOBDATE_NODAY":
                    return MOBDATE_NODAY;
                case "MOBDATE_NODAY_NOSECOND":
                    return MOBDATE_NODAY_NOSECOND;
                case "MOBDATE_NOTIME":
                    return MOBDATE_NOTIME;
                case "MOBDATE_SECOND":
                    return MOBDATE_SECOND;
                case "MOBPICTURE":
                    return MOBPICTURE;
                case "MOBSINGLEFILEUPLOAD":
                    return MOBSINGLEFILEUPLOAD;
                case "MOBPICTURE_RAW":
                    return MOBPICTURE_RAW;
                case "MOBPICTURELIST":
                    return MOBPICTURELIST;
                case "MOBMULTIFILEUPLOAD":
                    return MOBMULTIFILEUPLOAD;
                case "MOBPASSWORD":
                    return MOBPASSWORD;
                case "MOBSLIDER":
                    return MOBSLIDER;
                case "MOBSTEPPER":
                    return MOBSTEPPER;
                case "MOBRATING":
                    return MOBRATING;
                case "MOBHTMLTEXT":
                    return MOBHTMLTEXT;
                case "MOBCODE":
                    return MOBCODE;
                case "MOBMARKDOWN":
                    return MOBMARKDOWN;
                case "MOBNUMBERRANGE":
                    return MOBNUMBERRANGE;
                case "MOBDATERANGE":
                    return MOBDATERANGE;
                case "MOBDATERANGE_NOTIME":
                    return MOBDATERANGE_NOTIME;
                case "MOBCASCADER":
                    return MOBCASCADER;
                case "MOBARRAY":
                    return MOBARRAY;
                case "MOBMAPPICKER":
                    return MOBMAPPICKER;
                case "MOBCOLORPICKER":
                    return MOBCOLORPICKER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件模型变量类型
     * <P>
     * <ul>
     * <li>OBJECT
     * <P>
     * 对象
     * <li>OBJECTARRAY
     * <P>
     * 对象集合
     * <li>STRING
     * <P>
     * 字符串
     * <li>STRINGARRAY
     * <P>
     * 字符串数组
     * <li>INT
     * <P>
     * 整形
     * <li>INTARRAY
     * <P>
     * 整形数组
     * <li>NUMBER
     * <P>
     * 数值
     * <li>NUMBERARRAY
     * <P>
     * 数值数组
     * <li>BOOL
     * <P>
     * 布尔值
     * </ul>     
     */
    public static enum CtrlModelDataType{
        OBJECT("OBJECT", "对象")
        ,OBJECTARRAY("OBJECTARRAY", "对象集合")
        ,STRING("STRING", "字符串")
        ,STRINGARRAY("STRINGARRAY", "字符串数组")
        ,INT("INT", "整形")
        ,INTARRAY("INTARRAY", "整形数组")
        ,NUMBER("NUMBER", "数值")
        ,NUMBERARRAY("NUMBERARRAY", "数值数组")
        ,BOOL("BOOL", "布尔值")
;
           
        public final String text;
        public final String value;
        
        private CtrlModelDataType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlModelDataType from(String value){
            switch(value){
                case "OBJECT":
                    return OBJECT;
                case "OBJECTARRAY":
                    return OBJECTARRAY;
                case "STRING":
                    return STRING;
                case "STRINGARRAY":
                    return STRINGARRAY;
                case "INT":
                    return INT;
                case "INTARRAY":
                    return INTARRAY;
                case "NUMBER":
                    return NUMBER;
                case "NUMBERARRAY":
                    return NUMBERARRAY;
                case "BOOL":
                    return BOOL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性值规则类型
     * <P>
     * <ul>
     * <li>GROUP
     * <P>
     * 条件组，组条件，使用与（AND）、或（OR）逻辑计算成员条件
     * <li>NULLRULE
     * <P>
     * 空值判断，判断指定属性值是否为空值
     * <li>VALUERANGE
     * <P>
     * 数据集范围，判断指定属性值是否在指定的数据集合中
     * <li>VALUERANGE2
     * <P>
     * 数值范围，判断指定属性值是否在指定数值范围中
     * <li>REGEX
     * <P>
     * 正则式，判断指定属性值是否符合指定正则式规则
     * <li>STRINGLENGTH
     * <P>
     * 字符长度，判断指定属性值的长度是否在指定范围中
     * <li>SIMPLE
     * <P>
     * 常规条件，进行指定属性值与目标值的逻辑判断
     * <li>VALUERANGE3
     * <P>
     * 值清单，判断指定属性值是否在指定的值清单中
     * <li>QUERYCOUNT
     * <P>
     * 查询计数，判断指定属性值的查询计数是否在指定的范围中
     * <li>VALUERECURSION
     * <P>
     * 值递归检查，判断指定属性值是否存在递归引用
     * <li>SYSVALUERULE
     * <P>
     * 系统值规则，判断指定属性值是否满足指定的系统值规则
     * </ul>     
     */
    public static enum DEFVRType{
        GROUP("GROUP", "条件组")
        ,NULLRULE("NULLRULE", "空值判断")
        ,VALUERANGE("VALUERANGE", "数据集范围")
        ,VALUERANGE2("VALUERANGE2", "数值范围")
        ,REGEX("REGEX", "正则式")
        ,STRINGLENGTH("STRINGLENGTH", "字符长度")
        ,SIMPLE("SIMPLE", "常规条件")
        ,VALUERANGE3("VALUERANGE3", "值清单")
        ,QUERYCOUNT("QUERYCOUNT", "查询计数")
        ,VALUERECURSION("VALUERECURSION", "值递归检查")
        ,SYSVALUERULE("SYSVALUERULE", "系统值规则")
;
           
        public final String text;
        public final String value;
        
        private DEFVRType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFVRType from(String value){
            switch(value){
                case "GROUP":
                    return GROUP;
                case "NULLRULE":
                    return NULLRULE;
                case "VALUERANGE":
                    return VALUERANGE;
                case "VALUERANGE2":
                    return VALUERANGE2;
                case "REGEX":
                    return REGEX;
                case "STRINGLENGTH":
                    return STRINGLENGTH;
                case "SIMPLE":
                    return SIMPLE;
                case "VALUERANGE3":
                    return VALUERANGE3;
                case "QUERYCOUNT":
                    return QUERYCOUNT;
                case "VALUERECURSION":
                    return VALUERECURSION;
                case "SYSVALUERULE":
                    return SYSVALUERULE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 微信企业应用类型
     * <P>
     * <ul>
     * <li>H5
     * <P>
     * H5主页型
     * <li>MSG
     * <P>
     * 消息响应型
     * </ul>     
     */
    public static enum WXAppType{
        H5("H5", "H5主页型")
        ,MSG("MSG", "消息响应型")
;
           
        public final String text;
        public final String value;
        
        private WXAppType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WXAppType from(String value){
            switch(value){
                case "H5":
                    return H5;
                case "MSG":
                    return MSG;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流大数据库消费节点类型
     * <P>
     * <ul>
     * <li>BDTABLE
     * <P>
     * 大数据表
     * <li>DEFGROUP
     * <P>
     * 实体属性组
     * </ul>     
     */
    public static enum DEDataFlowSysBDSchemeSinkType{
        BDTABLE("BDTABLE", "大数据表")
        ,DEFGROUP("DEFGROUP", "实体属性组")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysBDSchemeSinkType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysBDSchemeSinkType from(String value){
            switch(value){
                case "BDTABLE":
                    return BDTABLE;
                case "DEFGROUP":
                    return DEFGROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图类型
     * <P>
     * <ul>
     * <li>APPDATAUPLOADVIEW
     * <P>
     * 应用数据导入视图
     * <li>APPERRORVIEW
     * <P>
     * 应用错误显示视图
     * <li>APPFILEUPLOADVIEW
     * <P>
     * 应用文件上传视图
     * <li>APPFUNCPICKUPVIEW
     * <P>
     * 应用功能选择视图
     * <li>APPINDEXVIEW
     * <P>
     * 应用首页视图
     * <li>APPLOGINVIEW
     * <P>
     * 应用登录视图
     * <li>APPLOGOUTVIEW
     * <P>
     * 应用注销视图
     * <li>APPPANELVIEW
     * <P>
     * 应用面板视图
     * <li>APPPICUPLOADVIEW
     * <P>
     * 应用图片上传视图
     * <li>APPPORTALVIEW
     * <P>
     * 应用看板视图
     * <li>APPREDIRECTVIEW
     * <P>
     * 应用全局数据重定向视图
     * <li>APPSTARTVIEW
     * <P>
     * 应用启动视图
     * <li>APPWELCOMEVIEW
     * <P>
     * 应用欢迎视图
     * <li>APPWFADDSTEPAFTERVIEW
     * <P>
     * 应用流程后加签操作视图
     * <li>APPWFADDSTEPBEFOREVIEW
     * <P>
     * 应用流程前加签操作视图
     * <li>APPWFREDIRECTVIEW
     * <P>
     * 应用全局流程工作重定向视图
     * <li>APPWFSENDBACKVIEW
     * <P>
     * 应用流程回退操作视图
     * <li>APPWFSTEPACTORVIEW
     * <P>
     * 应用流程当前处理人视图
     * <li>APPWFSTEPDATAVIEW
     * <P>
     * 应用流程处理记录视图
     * <li>APPWFSTEPTRACEVIEW
     * <P>
     * 应用流程跟踪视图
     * <li>APPWFSUPPLYINFOVIEW
     * <P>
     * 应用流程补充信息操作视图
     * <li>APPWFTAKEADVICEVIEW
     * <P>
     * 应用流程征求意见操作视图
     * <li>DECALENDAREXPVIEW
     * <P>
     * 实体日历导航视图
     * <li>DECALENDARVIEW
     * <P>
     * 实体日历视图
     * <li>DECALENDARVIEW9
     * <P>
     * 实体日历视图（部件视图）
     * <li>DECHARTEXPVIEW
     * <P>
     * 实体图表导航视图
     * <li>DECHARTVIEW
     * <P>
     * 实体图表视图
     * <li>DECHARTVIEW9
     * <P>
     * 实体图表视图（部件视图）
     * <li>DECUSTOMVIEW
     * <P>
     * 实体自定义视图
     * <li>DEDATAVIEW
     * <P>
     * 实体数据视图
     * <li>DEDATAVIEW9
     * <P>
     * 实体数据视图（部件视图）
     * <li>DEDATAVIEWEXPVIEW
     * <P>
     * 实体卡片视图导航视图
     * <li>DEEDITVIEW
     * <P>
     * 实体编辑视图
     * <li>DEEDITVIEW2
     * <P>
     * 实体编辑视图（左右关系）
     * <li>DEEDITVIEW3
     * <P>
     * 实体编辑视图（分页关系）
     * <li>DEEDITVIEW4
     * <P>
     * 实体编辑视图（上下关系）
     * <li>DEEDITVIEW9
     * <P>
     * 实体编辑视图（部件视图）
     * <li>DEFORMPICKUPDATAVIEW
     * <P>
     * 实体表单选择数据视图（部件视图）
     * <li>DEGANTTEXPVIEW
     * <P>
     * 实体甘特图导航视图
     * <li>DEGANTTVIEW
     * <P>
     * 实体甘特视图
     * <li>DEGANTTVIEW9
     * <P>
     * 实体甘特视图（部件视图）
     * <li>DEGRIDEXPVIEW
     * <P>
     * 实体表格导航视图
     * <li>DEGRIDVIEW
     * <P>
     * 实体表格视图
     * <li>DEGRIDVIEW2
     * <P>
     * 实体表格视图（左右关系）
     * <li>DEGRIDVIEW4
     * <P>
     * 实体表格视图（上下关系）
     * <li>DEGRIDVIEW8
     * <P>
     * 实体关系数据表格视图（嵌入）
     * <li>DEGRIDVIEW9
     * <P>
     * 实体表格视图（部件视图）
     * <li>DEHTMLVIEW
     * <P>
     * 实体HTML视图
     * <li>DEINDEXPICKUPDATAVIEW
     * <P>
     * 实体索引关系选择数据视图（部件视图）
     * <li>DEINDEXVIEW
     * <P>
     * 实体首页视图
     * <li>DEKANBANVIEW
     * <P>
     * 实体看板视图
     * <li>DEKANBANVIEW9
     * <P>
     * 实体看板视图（部件视图）
     * <li>DELISTEXPVIEW
     * <P>
     * 实体列表导航视图
     * <li>DELISTVIEW
     * <P>
     * 实体列表视图
     * <li>DELISTVIEW9
     * <P>
     * 实体列表视图（部件视图）
     * <li>DEMAPEXPVIEW
     * <P>
     * 实体地图导航视图
     * <li>DEMAPVIEW
     * <P>
     * 实体地图视图
     * <li>DEMAPVIEW9
     * <P>
     * 实体地图视图（部件视图）
     * <li>DEMDCUSTOMVIEW
     * <P>
     * 实体多数据自定义视图
     * <li>DEMEDITVIEW9
     * <P>
     * 实体多表单编辑视图（部件视图）
     * <li>DEMOBCALENDAREXPVIEW
     * <P>
     * 实体移动端日历导航视图
     * <li>DEMOBCALENDARVIEW
     * <P>
     * 实体移动端日历视图
     * <li>DEMOBCALENDARVIEW9
     * <P>
     * 实体移动端日历视图（部件视图）
     * <li>DEMOBCHARTEXPVIEW
     * <P>
     * 实体移动端图表导航视图
     * <li>DEMOBCHARTVIEW
     * <P>
     * 实体移动端图表视图
     * <li>DEMOBCHARTVIEW9
     * <P>
     * 实体移动端图表视图（部件视图）
     * <li>DEMOBCUSTOMVIEW
     * <P>
     * 实体移动端自定义视图
     * <li>DEMOBDATAVIEW
     * <P>
     * 实体移动端卡片视图
     * <li>DEMOBDATAVIEWEXPVIEW
     * <P>
     * 实体移动端卡片视图导航视图
     * <li>DEMOBEDITVIEW
     * <P>
     * 实体移动端编辑视图
     * <li>DEMOBEDITVIEW3
     * <P>
     * 实体移动端编辑视图（分页关系）
     * <li>DEMOBEDITVIEW9
     * <P>
     * 实体移动端编辑视图（部件视图）
     * <li>DEMOBFORMPICKUPMDVIEW
     * <P>
     * 实体移动端表单类型选择多数据视图（部件视图）
     * <li>DEMOBGANTTEXPVIEW
     * <P>
     * 实体移动端甘特图导航视图
     * <li>DEMOBGANTTVIEW
     * <P>
     * 实体移动端甘特视图
     * <li>DEMOBGANTTVIEW9
     * <P>
     * 实体移动端甘特视图（部件视图）
     * <li>DEMOBHTMLVIEW
     * <P>
     * 实体移动端HTML视图
     * <li>DEMOBINDEXPICKUPMDVIEW
     * <P>
     * 实体移动端索引类型选择多数据视图（部件视图）
     * <li>DEMOBLISTEXPVIEW
     * <P>
     * 实体移动端列表导航视图
     * <li>DEMOBLISTVIEW
     * <P>
     * 实体移动端列表视图
     * <li>DEMOBMAPEXPVIEW
     * <P>
     * 实体移动端地图导航视图
     * <li>DEMOBMAPVIEW
     * <P>
     * 实体移动端地图视图
     * <li>DEMOBMAPVIEW9
     * <P>
     * 实体移动端地图视图（部件视图）
     * <li>DEMOBMDVIEW
     * <P>
     * 实体移动端多数据视图
     * <li>DEMOBMDVIEW9
     * <P>
     * 实体移动端多数据视图（部件视图）
     * <li>DEMOBMEDITVIEW9
     * <P>
     * 实体移动端多表单编辑视图（部件视图）
     * <li>DEMOBMPICKUPVIEW
     * <P>
     * 实体移动端多数据选择视图
     * <li>DEMOBOPTVIEW
     * <P>
     * 实体移动端选项操作视图
     * <li>DEMOBPANELVIEW
     * <P>
     * 实体移动端面板视图
     * <li>DEMOBPANELVIEW9
     * <P>
     * 实体移动端面板视图（部件视图）
     * <li>DEMOBPICKUPLISTVIEW
     * <P>
     * 实体移动端选择列表视图（部件视图）
     * <li>DEMOBPICKUPMDVIEW
     * <P>
     * 实体移动端选择多数据视图（部件视图）
     * <li>DEMOBPICKUPTREEVIEW
     * <P>
     * 实体移动端选择树视图（部件视图）
     * <li>DEMOBPICKUPVIEW
     * <P>
     * 实体移动端数据选择视图
     * <li>DEMOBPORTALVIEW
     * <P>
     * 实体移动端数据看板视图
     * <li>DEMOBPORTALVIEW9
     * <P>
     * 实体移动端数据看板视图（部件视图）
     * <li>DEMOBREDIRECTVIEW
     * <P>
     * 实体移动端数据重定向视图
     * <li>DEMOBREPORTVIEW
     * <P>
     * 实体移动端报表视图
     * <li>DEMOBTABEXPVIEW
     * <P>
     * 实体移动端分页导航视图
     * <li>DEMOBTABEXPVIEW9
     * <P>
     * 实体移动端分页导航视图（部件视图）
     * <li>DEMOBTABSEARCHVIEW
     * <P>
     * 实体移动端分页搜索视图
     * <li>DEMOBTABSEARCHVIEW9
     * <P>
     * 实体移动端分页搜索视图（部件视图）
     * <li>DEMOBTREEEXPVIEW
     * <P>
     * 实体移动端树导航视图
     * <li>DEMOBTREEEXPVIEW9
     * <P>
     * 实体移动端树导航视图（部件视图）
     * <li>DEMOBTREEVIEW
     * <P>
     * 实体移动端树视图
     * <li>DEMOBWFACTIONVIEW
     * <P>
     * 实体移动端工作流操作视图
     * <li>DEMOBWFDATAREDIRECTVIEW
     * <P>
     * 移动端实体全局流程数据重定向视图
     * <li>DEMOBWFDYNAACTIONVIEW
     * <P>
     * 实体移动端工作流动态操作视图
     * <li>DEMOBWFDYNAEDITVIEW
     * <P>
     * 实体移动端工作流动态编辑视图
     * <li>DEMOBWFDYNAEDITVIEW3
     * <P>
     * 实体移动端工作流动态编辑视图（分页关系）
     * <li>DEMOBWFDYNAEXPMDVIEW
     * <P>
     * 实体移动端工作流动态导航多数据视图
     * <li>DEMOBWFDYNASTARTVIEW
     * <P>
     * 实体移动端工作流动态启动视图
     * <li>DEMOBWFEDITVIEW
     * <P>
     * 实体移动端工作流编辑视图
     * <li>DEMOBWFEDITVIEW3
     * <P>
     * 实体移动端工作流编辑视图（分页关系）
     * <li>DEMOBWFMDVIEW
     * <P>
     * 实体移动端工作流多数据视图
     * <li>DEMOBWFPROXYRESULTVIEW
     * <P>
     * 实体移动端工作流代理应用结果视图
     * <li>DEMOBWFPROXYSTARTVIEW
     * <P>
     * 实体移动端工作流代理应用启动视图
     * <li>DEMOBWFSTARTVIEW
     * <P>
     * 实体移动端工作流启动视图
     * <li>DEMOBWIZARDVIEW
     * <P>
     * 实体移动端向导视图
     * <li>DEMPICKUPVIEW
     * <P>
     * 实体数据多项选择视图
     * <li>DEMPICKUPVIEW2
     * <P>
     * 实体多项数据选择视图（左右关系）
     * <li>DEOPTVIEW
     * <P>
     * 实体选项操作视图
     * <li>DEPANELVIEW
     * <P>
     * 实体面板视图
     * <li>DEPANELVIEW9
     * <P>
     * 实体面板视图（部件视图）
     * <li>DEPICKUPDATAVIEW
     * <P>
     * 实体选择数据视图（部件视图）
     * <li>DEPICKUPGRIDVIEW
     * <P>
     * 实体选择表格视图（部件视图）
     * <li>DEPICKUPTREEVIEW
     * <P>
     * 实体选择树视图（部件视图）
     * <li>DEPICKUPVIEW
     * <P>
     * 实体数据选择视图
     * <li>DEPICKUPVIEW2
     * <P>
     * 实体数据选择视图（左右关系）
     * <li>DEPICKUPVIEW3
     * <P>
     * 实体数据选择视图（分页关系）
     * <li>DEPORTALVIEW
     * <P>
     * 实体数据看板视图
     * <li>DEPORTALVIEW9
     * <P>
     * 实体数据看板视图（部件视图）
     * <li>DEREDIRECTVIEW
     * <P>
     * 实体数据重定向视图
     * <li>DEREPORTVIEW
     * <P>
     * 实体报表视图
     * <li>DETABEXPVIEW
     * <P>
     * 实体分页导航视图
     * <li>DETABEXPVIEW9
     * <P>
     * 实体分页导航视图（部件视图）
     * <li>DETABSEARCHVIEW
     * <P>
     * 实体分页搜索视图
     * <li>DETABSEARCHVIEW9
     * <P>
     * 实体分页搜索视图（部件视图）
     * <li>DETREEEXPVIEW
     * <P>
     * 实体树导航视图
     * <li>DETREEEXPVIEW2
     * <P>
     * 实体树导航视图（IFrame）
     * <li>DETREEEXPVIEW3
     * <P>
     * 实体树导航视图（菜单模式）
     * <li>DETREEGRIDEXVIEW
     * <P>
     * 实体树表格视图（增强）
     * <li>DETREEGRIDEXVIEW9
     * <P>
     * 实体树表格视图（增强）（部件视图）
     * <li>DETREEGRIDVIEW
     * <P>
     * 实体树表格视图
     * <li>DETREEGRIDVIEW9
     * <P>
     * 实体树表格视图（部件视图）
     * <li>DETREEVIEW
     * <P>
     * 实体树视图
     * <li>DETREEVIEW9
     * <P>
     * 实体树视图（部件视图）
     * <li>DEWFACTIONVIEW
     * <P>
     * 实体工作流操作视图
     * <li>DEWFDATAREDIRECTVIEW
     * <P>
     * 实体全局流程数据重定向视图
     * <li>DEWFDYNAACTIONVIEW
     * <P>
     * 实体工作流动态操作视图
     * <li>DEWFDYNAEDITVIEW
     * <P>
     * 实体工作流动态编辑视图
     * <li>DEWFDYNAEDITVIEW3
     * <P>
     * 实体工作流动态视图（分页关系）
     * <li>DEWFDYNAEXPGRIDVIEW
     * <P>
     * 实体工作流动态导航表格视图
     * <li>DEWFDYNASTARTVIEW
     * <P>
     * 实体工作流动态启动视图
     * <li>DEWFEDITPROXYDATAVIEW
     * <P>
     * 实体工作流编辑代理数据视图
     * <li>DEWFEDITVIEW
     * <P>
     * 实体工作流编辑视图
     * <li>DEWFEDITVIEW2
     * <P>
     * 实体工作流编辑视图（左右关系）
     * <li>DEWFEDITVIEW3
     * <P>
     * 实体工作流视图（分页关系）
     * <li>DEWFEDITVIEW9
     * <P>
     * 实体工作流视图（嵌入视图）
     * <li>DEWFEXPVIEW
     * <P>
     * 实体工作流导航视图
     * <li>DEWFGRIDVIEW
     * <P>
     * 实体工作流表格视图
     * <li>DEWFPROXYDATAVIEW
     * <P>
     * 实体工作流代理数据视图
     * <li>DEWFPROXYRESULTVIEW
     * <P>
     * 实体工作流代理应用结果视图
     * <li>DEWFPROXYSTARTVIEW
     * <P>
     * 实体工作流代理应用启动视图
     * <li>DEWFSTARTVIEW
     * <P>
     * 实体工作流启动视图
     * <li>DEWIZARDVIEW
     * <P>
     * 实体向导视图
     * <li>DESUBAPPREFVIEW
     * <P>
     * 实体子应用引用视图
     * </ul>     
     */
    public static enum AppViewType{
        APPDATAUPLOADVIEW("APPDATAUPLOADVIEW", "应用数据导入视图")
        ,APPERRORVIEW("APPERRORVIEW", "应用错误显示视图")
        ,APPFILEUPLOADVIEW("APPFILEUPLOADVIEW", "应用文件上传视图")
        ,APPFUNCPICKUPVIEW("APPFUNCPICKUPVIEW", "应用功能选择视图")
        ,APPINDEXVIEW("APPINDEXVIEW", "应用首页视图")
        ,APPLOGINVIEW("APPLOGINVIEW", "应用登录视图")
        ,APPLOGOUTVIEW("APPLOGOUTVIEW", "应用注销视图")
        ,APPPANELVIEW("APPPANELVIEW", "应用面板视图")
        ,APPPICUPLOADVIEW("APPPICUPLOADVIEW", "应用图片上传视图")
        ,APPPORTALVIEW("APPPORTALVIEW", "应用看板视图")
        ,APPREDIRECTVIEW("APPREDIRECTVIEW", "应用全局数据重定向视图")
        ,APPSTARTVIEW("APPSTARTVIEW", "应用启动视图")
        ,APPWELCOMEVIEW("APPWELCOMEVIEW", "应用欢迎视图")
        ,APPWFADDSTEPAFTERVIEW("APPWFADDSTEPAFTERVIEW", "应用流程后加签操作视图")
        ,APPWFADDSTEPBEFOREVIEW("APPWFADDSTEPBEFOREVIEW", "应用流程前加签操作视图")
        ,APPWFREDIRECTVIEW("APPWFREDIRECTVIEW", "应用全局流程工作重定向视图")
        ,APPWFSENDBACKVIEW("APPWFSENDBACKVIEW", "应用流程回退操作视图")
        ,APPWFSTEPACTORVIEW("APPWFSTEPACTORVIEW", "应用流程当前处理人视图")
        ,APPWFSTEPDATAVIEW("APPWFSTEPDATAVIEW", "应用流程处理记录视图")
        ,APPWFSTEPTRACEVIEW("APPWFSTEPTRACEVIEW", "应用流程跟踪视图")
        ,APPWFSUPPLYINFOVIEW("APPWFSUPPLYINFOVIEW", "应用流程补充信息操作视图")
        ,APPWFTAKEADVICEVIEW("APPWFTAKEADVICEVIEW", "应用流程征求意见操作视图")
        ,DECALENDAREXPVIEW("DECALENDAREXPVIEW", "实体日历导航视图")
        ,DECALENDARVIEW("DECALENDARVIEW", "实体日历视图")
        ,DECALENDARVIEW9("DECALENDARVIEW9", "实体日历视图（部件视图）")
        ,DECHARTEXPVIEW("DECHARTEXPVIEW", "实体图表导航视图")
        ,DECHARTVIEW("DECHARTVIEW", "实体图表视图")
        ,DECHARTVIEW9("DECHARTVIEW9", "实体图表视图（部件视图）")
        ,DECUSTOMVIEW("DECUSTOMVIEW", "实体自定义视图")
        ,DEDATAVIEW("DEDATAVIEW", "实体数据视图")
        ,DEDATAVIEW9("DEDATAVIEW9", "实体数据视图（部件视图）")
        ,DEDATAVIEWEXPVIEW("DEDATAVIEWEXPVIEW", "实体卡片视图导航视图")
        ,DEEDITVIEW("DEEDITVIEW", "实体编辑视图")
        ,DEEDITVIEW2("DEEDITVIEW2", "实体编辑视图（左右关系）")
        ,DEEDITVIEW3("DEEDITVIEW3", "实体编辑视图（分页关系）")
        ,DEEDITVIEW4("DEEDITVIEW4", "实体编辑视图（上下关系）")
        ,DEEDITVIEW9("DEEDITVIEW9", "实体编辑视图（部件视图）")
        ,DEFORMPICKUPDATAVIEW("DEFORMPICKUPDATAVIEW", "实体表单选择数据视图（部件视图）")
        ,DEGANTTEXPVIEW("DEGANTTEXPVIEW", "实体甘特图导航视图")
        ,DEGANTTVIEW("DEGANTTVIEW", "实体甘特视图")
        ,DEGANTTVIEW9("DEGANTTVIEW9", "实体甘特视图（部件视图）")
        ,DEGRIDEXPVIEW("DEGRIDEXPVIEW", "实体表格导航视图")
        ,DEGRIDVIEW("DEGRIDVIEW", "实体表格视图")
        ,DEGRIDVIEW2("DEGRIDVIEW2", "实体表格视图（左右关系）")
        ,DEGRIDVIEW4("DEGRIDVIEW4", "实体表格视图（上下关系）")
        ,DEGRIDVIEW8("DEGRIDVIEW8", "实体关系数据表格视图（嵌入）")
        ,DEGRIDVIEW9("DEGRIDVIEW9", "实体表格视图（部件视图）")
        ,DEHTMLVIEW("DEHTMLVIEW", "实体HTML视图")
        ,DEINDEXPICKUPDATAVIEW("DEINDEXPICKUPDATAVIEW", "实体索引关系选择数据视图（部件视图）")
        ,DEINDEXVIEW("DEINDEXVIEW", "实体首页视图")
        ,DEKANBANVIEW("DEKANBANVIEW", "实体看板视图")
        ,DEKANBANVIEW9("DEKANBANVIEW9", "实体看板视图（部件视图）")
        ,DELISTEXPVIEW("DELISTEXPVIEW", "实体列表导航视图")
        ,DELISTVIEW("DELISTVIEW", "实体列表视图")
        ,DELISTVIEW9("DELISTVIEW9", "实体列表视图（部件视图）")
        ,DEMAPEXPVIEW("DEMAPEXPVIEW", "实体地图导航视图")
        ,DEMAPVIEW("DEMAPVIEW", "实体地图视图")
        ,DEMAPVIEW9("DEMAPVIEW9", "实体地图视图（部件视图）")
        ,DEMDCUSTOMVIEW("DEMDCUSTOMVIEW", "实体多数据自定义视图")
        ,DEMEDITVIEW9("DEMEDITVIEW9", "实体多表单编辑视图（部件视图）")
        ,DEMOBCALENDAREXPVIEW("DEMOBCALENDAREXPVIEW", "实体移动端日历导航视图")
        ,DEMOBCALENDARVIEW("DEMOBCALENDARVIEW", "实体移动端日历视图")
        ,DEMOBCALENDARVIEW9("DEMOBCALENDARVIEW9", "实体移动端日历视图（部件视图）")
        ,DEMOBCHARTEXPVIEW("DEMOBCHARTEXPVIEW", "实体移动端图表导航视图")
        ,DEMOBCHARTVIEW("DEMOBCHARTVIEW", "实体移动端图表视图")
        ,DEMOBCHARTVIEW9("DEMOBCHARTVIEW9", "实体移动端图表视图（部件视图）")
        ,DEMOBCUSTOMVIEW("DEMOBCUSTOMVIEW", "实体移动端自定义视图")
        ,DEMOBDATAVIEW("DEMOBDATAVIEW", "实体移动端卡片视图")
        ,DEMOBDATAVIEWEXPVIEW("DEMOBDATAVIEWEXPVIEW", "实体移动端卡片视图导航视图")
        ,DEMOBEDITVIEW("DEMOBEDITVIEW", "实体移动端编辑视图")
        ,DEMOBEDITVIEW3("DEMOBEDITVIEW3", "实体移动端编辑视图（分页关系）")
        ,DEMOBEDITVIEW9("DEMOBEDITVIEW9", "实体移动端编辑视图（部件视图）")
        ,DEMOBFORMPICKUPMDVIEW("DEMOBFORMPICKUPMDVIEW", "实体移动端表单类型选择多数据视图（部件视图）")
        ,DEMOBGANTTEXPVIEW("DEMOBGANTTEXPVIEW", "实体移动端甘特图导航视图")
        ,DEMOBGANTTVIEW("DEMOBGANTTVIEW", "实体移动端甘特视图")
        ,DEMOBGANTTVIEW9("DEMOBGANTTVIEW9", "实体移动端甘特视图（部件视图）")
        ,DEMOBHTMLVIEW("DEMOBHTMLVIEW", "实体移动端HTML视图")
        ,DEMOBINDEXPICKUPMDVIEW("DEMOBINDEXPICKUPMDVIEW", "实体移动端索引类型选择多数据视图（部件视图）")
        ,DEMOBLISTEXPVIEW("DEMOBLISTEXPVIEW", "实体移动端列表导航视图")
        ,DEMOBLISTVIEW("DEMOBLISTVIEW", "实体移动端列表视图")
        ,DEMOBMAPEXPVIEW("DEMOBMAPEXPVIEW", "实体移动端地图导航视图")
        ,DEMOBMAPVIEW("DEMOBMAPVIEW", "实体移动端地图视图")
        ,DEMOBMAPVIEW9("DEMOBMAPVIEW9", "实体移动端地图视图（部件视图）")
        ,DEMOBMDVIEW("DEMOBMDVIEW", "实体移动端多数据视图")
        ,DEMOBMDVIEW9("DEMOBMDVIEW9", "实体移动端多数据视图（部件视图）")
        ,DEMOBMEDITVIEW9("DEMOBMEDITVIEW9", "实体移动端多表单编辑视图（部件视图）")
        ,DEMOBMPICKUPVIEW("DEMOBMPICKUPVIEW", "实体移动端多数据选择视图")
        ,DEMOBOPTVIEW("DEMOBOPTVIEW", "实体移动端选项操作视图")
        ,DEMOBPANELVIEW("DEMOBPANELVIEW", "实体移动端面板视图")
        ,DEMOBPANELVIEW9("DEMOBPANELVIEW9", "实体移动端面板视图（部件视图）")
        ,DEMOBPICKUPLISTVIEW("DEMOBPICKUPLISTVIEW", "实体移动端选择列表视图（部件视图）")
        ,DEMOBPICKUPMDVIEW("DEMOBPICKUPMDVIEW", "实体移动端选择多数据视图（部件视图）")
        ,DEMOBPICKUPTREEVIEW("DEMOBPICKUPTREEVIEW", "实体移动端选择树视图（部件视图）")
        ,DEMOBPICKUPVIEW("DEMOBPICKUPVIEW", "实体移动端数据选择视图")
        ,DEMOBPORTALVIEW("DEMOBPORTALVIEW", "实体移动端数据看板视图")
        ,DEMOBPORTALVIEW9("DEMOBPORTALVIEW9", "实体移动端数据看板视图（部件视图）")
        ,DEMOBREDIRECTVIEW("DEMOBREDIRECTVIEW", "实体移动端数据重定向视图")
        ,DEMOBREPORTVIEW("DEMOBREPORTVIEW", "实体移动端报表视图")
        ,DEMOBTABEXPVIEW("DEMOBTABEXPVIEW", "实体移动端分页导航视图")
        ,DEMOBTABEXPVIEW9("DEMOBTABEXPVIEW9", "实体移动端分页导航视图（部件视图）")
        ,DEMOBTABSEARCHVIEW("DEMOBTABSEARCHVIEW", "实体移动端分页搜索视图")
        ,DEMOBTABSEARCHVIEW9("DEMOBTABSEARCHVIEW9", "实体移动端分页搜索视图（部件视图）")
        ,DEMOBTREEEXPVIEW("DEMOBTREEEXPVIEW", "实体移动端树导航视图")
        ,DEMOBTREEEXPVIEW9("DEMOBTREEEXPVIEW9", "实体移动端树导航视图（部件视图）")
        ,DEMOBTREEVIEW("DEMOBTREEVIEW", "实体移动端树视图")
        ,DEMOBWFACTIONVIEW("DEMOBWFACTIONVIEW", "实体移动端工作流操作视图")
        ,DEMOBWFDATAREDIRECTVIEW("DEMOBWFDATAREDIRECTVIEW", "移动端实体全局流程数据重定向视图")
        ,DEMOBWFDYNAACTIONVIEW("DEMOBWFDYNAACTIONVIEW", "实体移动端工作流动态操作视图")
        ,DEMOBWFDYNAEDITVIEW("DEMOBWFDYNAEDITVIEW", "实体移动端工作流动态编辑视图")
        ,DEMOBWFDYNAEDITVIEW3("DEMOBWFDYNAEDITVIEW3", "实体移动端工作流动态编辑视图（分页关系）")
        ,DEMOBWFDYNAEXPMDVIEW("DEMOBWFDYNAEXPMDVIEW", "实体移动端工作流动态导航多数据视图")
        ,DEMOBWFDYNASTARTVIEW("DEMOBWFDYNASTARTVIEW", "实体移动端工作流动态启动视图")
        ,DEMOBWFEDITVIEW("DEMOBWFEDITVIEW", "实体移动端工作流编辑视图")
        ,DEMOBWFEDITVIEW3("DEMOBWFEDITVIEW3", "实体移动端工作流编辑视图（分页关系）")
        ,DEMOBWFMDVIEW("DEMOBWFMDVIEW", "实体移动端工作流多数据视图")
        ,DEMOBWFPROXYRESULTVIEW("DEMOBWFPROXYRESULTVIEW", "实体移动端工作流代理应用结果视图")
        ,DEMOBWFPROXYSTARTVIEW("DEMOBWFPROXYSTARTVIEW", "实体移动端工作流代理应用启动视图")
        ,DEMOBWFSTARTVIEW("DEMOBWFSTARTVIEW", "实体移动端工作流启动视图")
        ,DEMOBWIZARDVIEW("DEMOBWIZARDVIEW", "实体移动端向导视图")
        ,DEMPICKUPVIEW("DEMPICKUPVIEW", "实体数据多项选择视图")
        ,DEMPICKUPVIEW2("DEMPICKUPVIEW2", "实体多项数据选择视图（左右关系）")
        ,DEOPTVIEW("DEOPTVIEW", "实体选项操作视图")
        ,DEPANELVIEW("DEPANELVIEW", "实体面板视图")
        ,DEPANELVIEW9("DEPANELVIEW9", "实体面板视图（部件视图）")
        ,DEPICKUPDATAVIEW("DEPICKUPDATAVIEW", "实体选择数据视图（部件视图）")
        ,DEPICKUPGRIDVIEW("DEPICKUPGRIDVIEW", "实体选择表格视图（部件视图）")
        ,DEPICKUPTREEVIEW("DEPICKUPTREEVIEW", "实体选择树视图（部件视图）")
        ,DEPICKUPVIEW("DEPICKUPVIEW", "实体数据选择视图")
        ,DEPICKUPVIEW2("DEPICKUPVIEW2", "实体数据选择视图（左右关系）")
        ,DEPICKUPVIEW3("DEPICKUPVIEW3", "实体数据选择视图（分页关系）")
        ,DEPORTALVIEW("DEPORTALVIEW", "实体数据看板视图")
        ,DEPORTALVIEW9("DEPORTALVIEW9", "实体数据看板视图（部件视图）")
        ,DEREDIRECTVIEW("DEREDIRECTVIEW", "实体数据重定向视图")
        ,DEREPORTVIEW("DEREPORTVIEW", "实体报表视图")
        ,DETABEXPVIEW("DETABEXPVIEW", "实体分页导航视图")
        ,DETABEXPVIEW9("DETABEXPVIEW9", "实体分页导航视图（部件视图）")
        ,DETABSEARCHVIEW("DETABSEARCHVIEW", "实体分页搜索视图")
        ,DETABSEARCHVIEW9("DETABSEARCHVIEW9", "实体分页搜索视图（部件视图）")
        ,DETREEEXPVIEW("DETREEEXPVIEW", "实体树导航视图")
        ,DETREEEXPVIEW2("DETREEEXPVIEW2", "实体树导航视图（IFrame）")
        ,DETREEEXPVIEW3("DETREEEXPVIEW3", "实体树导航视图（菜单模式）")
        ,DETREEGRIDEXVIEW("DETREEGRIDEXVIEW", "实体树表格视图（增强）")
        ,DETREEGRIDEXVIEW9("DETREEGRIDEXVIEW9", "实体树表格视图（增强）（部件视图）")
        ,DETREEGRIDVIEW("DETREEGRIDVIEW", "实体树表格视图")
        ,DETREEGRIDVIEW9("DETREEGRIDVIEW9", "实体树表格视图（部件视图）")
        ,DETREEVIEW("DETREEVIEW", "实体树视图")
        ,DETREEVIEW9("DETREEVIEW9", "实体树视图（部件视图）")
        ,DEWFACTIONVIEW("DEWFACTIONVIEW", "实体工作流操作视图")
        ,DEWFDATAREDIRECTVIEW("DEWFDATAREDIRECTVIEW", "实体全局流程数据重定向视图")
        ,DEWFDYNAACTIONVIEW("DEWFDYNAACTIONVIEW", "实体工作流动态操作视图")
        ,DEWFDYNAEDITVIEW("DEWFDYNAEDITVIEW", "实体工作流动态编辑视图")
        ,DEWFDYNAEDITVIEW3("DEWFDYNAEDITVIEW3", "实体工作流动态视图（分页关系）")
        ,DEWFDYNAEXPGRIDVIEW("DEWFDYNAEXPGRIDVIEW", "实体工作流动态导航表格视图")
        ,DEWFDYNASTARTVIEW("DEWFDYNASTARTVIEW", "实体工作流动态启动视图")
        ,DEWFEDITPROXYDATAVIEW("DEWFEDITPROXYDATAVIEW", "实体工作流编辑代理数据视图")
        ,DEWFEDITVIEW("DEWFEDITVIEW", "实体工作流编辑视图")
        ,DEWFEDITVIEW2("DEWFEDITVIEW2", "实体工作流编辑视图（左右关系）")
        ,DEWFEDITVIEW3("DEWFEDITVIEW3", "实体工作流视图（分页关系）")
        ,DEWFEDITVIEW9("DEWFEDITVIEW9", "实体工作流视图（嵌入视图）")
        ,DEWFEXPVIEW("DEWFEXPVIEW", "实体工作流导航视图")
        ,DEWFGRIDVIEW("DEWFGRIDVIEW", "实体工作流表格视图")
        ,DEWFPROXYDATAVIEW("DEWFPROXYDATAVIEW", "实体工作流代理数据视图")
        ,DEWFPROXYRESULTVIEW("DEWFPROXYRESULTVIEW", "实体工作流代理应用结果视图")
        ,DEWFPROXYSTARTVIEW("DEWFPROXYSTARTVIEW", "实体工作流代理应用启动视图")
        ,DEWFSTARTVIEW("DEWFSTARTVIEW", "实体工作流启动视图")
        ,DEWIZARDVIEW("DEWIZARDVIEW", "实体向导视图")
        ,DESUBAPPREFVIEW("DESUBAPPREFVIEW", "实体子应用引用视图")
;
           
        public final String text;
        public final String value;
        
        private AppViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppViewType from(String value){
            switch(value){
                case "APPDATAUPLOADVIEW":
                    return APPDATAUPLOADVIEW;
                case "APPERRORVIEW":
                    return APPERRORVIEW;
                case "APPFILEUPLOADVIEW":
                    return APPFILEUPLOADVIEW;
                case "APPFUNCPICKUPVIEW":
                    return APPFUNCPICKUPVIEW;
                case "APPINDEXVIEW":
                    return APPINDEXVIEW;
                case "APPLOGINVIEW":
                    return APPLOGINVIEW;
                case "APPLOGOUTVIEW":
                    return APPLOGOUTVIEW;
                case "APPPANELVIEW":
                    return APPPANELVIEW;
                case "APPPICUPLOADVIEW":
                    return APPPICUPLOADVIEW;
                case "APPPORTALVIEW":
                    return APPPORTALVIEW;
                case "APPREDIRECTVIEW":
                    return APPREDIRECTVIEW;
                case "APPSTARTVIEW":
                    return APPSTARTVIEW;
                case "APPWELCOMEVIEW":
                    return APPWELCOMEVIEW;
                case "APPWFADDSTEPAFTERVIEW":
                    return APPWFADDSTEPAFTERVIEW;
                case "APPWFADDSTEPBEFOREVIEW":
                    return APPWFADDSTEPBEFOREVIEW;
                case "APPWFREDIRECTVIEW":
                    return APPWFREDIRECTVIEW;
                case "APPWFSENDBACKVIEW":
                    return APPWFSENDBACKVIEW;
                case "APPWFSTEPACTORVIEW":
                    return APPWFSTEPACTORVIEW;
                case "APPWFSTEPDATAVIEW":
                    return APPWFSTEPDATAVIEW;
                case "APPWFSTEPTRACEVIEW":
                    return APPWFSTEPTRACEVIEW;
                case "APPWFSUPPLYINFOVIEW":
                    return APPWFSUPPLYINFOVIEW;
                case "APPWFTAKEADVICEVIEW":
                    return APPWFTAKEADVICEVIEW;
                case "DECALENDAREXPVIEW":
                    return DECALENDAREXPVIEW;
                case "DECALENDARVIEW":
                    return DECALENDARVIEW;
                case "DECALENDARVIEW9":
                    return DECALENDARVIEW9;
                case "DECHARTEXPVIEW":
                    return DECHARTEXPVIEW;
                case "DECHARTVIEW":
                    return DECHARTVIEW;
                case "DECHARTVIEW9":
                    return DECHARTVIEW9;
                case "DECUSTOMVIEW":
                    return DECUSTOMVIEW;
                case "DEDATAVIEW":
                    return DEDATAVIEW;
                case "DEDATAVIEW9":
                    return DEDATAVIEW9;
                case "DEDATAVIEWEXPVIEW":
                    return DEDATAVIEWEXPVIEW;
                case "DEEDITVIEW":
                    return DEEDITVIEW;
                case "DEEDITVIEW2":
                    return DEEDITVIEW2;
                case "DEEDITVIEW3":
                    return DEEDITVIEW3;
                case "DEEDITVIEW4":
                    return DEEDITVIEW4;
                case "DEEDITVIEW9":
                    return DEEDITVIEW9;
                case "DEFORMPICKUPDATAVIEW":
                    return DEFORMPICKUPDATAVIEW;
                case "DEGANTTEXPVIEW":
                    return DEGANTTEXPVIEW;
                case "DEGANTTVIEW":
                    return DEGANTTVIEW;
                case "DEGANTTVIEW9":
                    return DEGANTTVIEW9;
                case "DEGRIDEXPVIEW":
                    return DEGRIDEXPVIEW;
                case "DEGRIDVIEW":
                    return DEGRIDVIEW;
                case "DEGRIDVIEW2":
                    return DEGRIDVIEW2;
                case "DEGRIDVIEW4":
                    return DEGRIDVIEW4;
                case "DEGRIDVIEW8":
                    return DEGRIDVIEW8;
                case "DEGRIDVIEW9":
                    return DEGRIDVIEW9;
                case "DEHTMLVIEW":
                    return DEHTMLVIEW;
                case "DEINDEXPICKUPDATAVIEW":
                    return DEINDEXPICKUPDATAVIEW;
                case "DEINDEXVIEW":
                    return DEINDEXVIEW;
                case "DEKANBANVIEW":
                    return DEKANBANVIEW;
                case "DEKANBANVIEW9":
                    return DEKANBANVIEW9;
                case "DELISTEXPVIEW":
                    return DELISTEXPVIEW;
                case "DELISTVIEW":
                    return DELISTVIEW;
                case "DELISTVIEW9":
                    return DELISTVIEW9;
                case "DEMAPEXPVIEW":
                    return DEMAPEXPVIEW;
                case "DEMAPVIEW":
                    return DEMAPVIEW;
                case "DEMAPVIEW9":
                    return DEMAPVIEW9;
                case "DEMDCUSTOMVIEW":
                    return DEMDCUSTOMVIEW;
                case "DEMEDITVIEW9":
                    return DEMEDITVIEW9;
                case "DEMOBCALENDAREXPVIEW":
                    return DEMOBCALENDAREXPVIEW;
                case "DEMOBCALENDARVIEW":
                    return DEMOBCALENDARVIEW;
                case "DEMOBCALENDARVIEW9":
                    return DEMOBCALENDARVIEW9;
                case "DEMOBCHARTEXPVIEW":
                    return DEMOBCHARTEXPVIEW;
                case "DEMOBCHARTVIEW":
                    return DEMOBCHARTVIEW;
                case "DEMOBCHARTVIEW9":
                    return DEMOBCHARTVIEW9;
                case "DEMOBCUSTOMVIEW":
                    return DEMOBCUSTOMVIEW;
                case "DEMOBDATAVIEW":
                    return DEMOBDATAVIEW;
                case "DEMOBDATAVIEWEXPVIEW":
                    return DEMOBDATAVIEWEXPVIEW;
                case "DEMOBEDITVIEW":
                    return DEMOBEDITVIEW;
                case "DEMOBEDITVIEW3":
                    return DEMOBEDITVIEW3;
                case "DEMOBEDITVIEW9":
                    return DEMOBEDITVIEW9;
                case "DEMOBFORMPICKUPMDVIEW":
                    return DEMOBFORMPICKUPMDVIEW;
                case "DEMOBGANTTEXPVIEW":
                    return DEMOBGANTTEXPVIEW;
                case "DEMOBGANTTVIEW":
                    return DEMOBGANTTVIEW;
                case "DEMOBGANTTVIEW9":
                    return DEMOBGANTTVIEW9;
                case "DEMOBHTMLVIEW":
                    return DEMOBHTMLVIEW;
                case "DEMOBINDEXPICKUPMDVIEW":
                    return DEMOBINDEXPICKUPMDVIEW;
                case "DEMOBLISTEXPVIEW":
                    return DEMOBLISTEXPVIEW;
                case "DEMOBLISTVIEW":
                    return DEMOBLISTVIEW;
                case "DEMOBMAPEXPVIEW":
                    return DEMOBMAPEXPVIEW;
                case "DEMOBMAPVIEW":
                    return DEMOBMAPVIEW;
                case "DEMOBMAPVIEW9":
                    return DEMOBMAPVIEW9;
                case "DEMOBMDVIEW":
                    return DEMOBMDVIEW;
                case "DEMOBMDVIEW9":
                    return DEMOBMDVIEW9;
                case "DEMOBMEDITVIEW9":
                    return DEMOBMEDITVIEW9;
                case "DEMOBMPICKUPVIEW":
                    return DEMOBMPICKUPVIEW;
                case "DEMOBOPTVIEW":
                    return DEMOBOPTVIEW;
                case "DEMOBPANELVIEW":
                    return DEMOBPANELVIEW;
                case "DEMOBPANELVIEW9":
                    return DEMOBPANELVIEW9;
                case "DEMOBPICKUPLISTVIEW":
                    return DEMOBPICKUPLISTVIEW;
                case "DEMOBPICKUPMDVIEW":
                    return DEMOBPICKUPMDVIEW;
                case "DEMOBPICKUPTREEVIEW":
                    return DEMOBPICKUPTREEVIEW;
                case "DEMOBPICKUPVIEW":
                    return DEMOBPICKUPVIEW;
                case "DEMOBPORTALVIEW":
                    return DEMOBPORTALVIEW;
                case "DEMOBPORTALVIEW9":
                    return DEMOBPORTALVIEW9;
                case "DEMOBREDIRECTVIEW":
                    return DEMOBREDIRECTVIEW;
                case "DEMOBREPORTVIEW":
                    return DEMOBREPORTVIEW;
                case "DEMOBTABEXPVIEW":
                    return DEMOBTABEXPVIEW;
                case "DEMOBTABEXPVIEW9":
                    return DEMOBTABEXPVIEW9;
                case "DEMOBTABSEARCHVIEW":
                    return DEMOBTABSEARCHVIEW;
                case "DEMOBTABSEARCHVIEW9":
                    return DEMOBTABSEARCHVIEW9;
                case "DEMOBTREEEXPVIEW":
                    return DEMOBTREEEXPVIEW;
                case "DEMOBTREEEXPVIEW9":
                    return DEMOBTREEEXPVIEW9;
                case "DEMOBTREEVIEW":
                    return DEMOBTREEVIEW;
                case "DEMOBWFACTIONVIEW":
                    return DEMOBWFACTIONVIEW;
                case "DEMOBWFDATAREDIRECTVIEW":
                    return DEMOBWFDATAREDIRECTVIEW;
                case "DEMOBWFDYNAACTIONVIEW":
                    return DEMOBWFDYNAACTIONVIEW;
                case "DEMOBWFDYNAEDITVIEW":
                    return DEMOBWFDYNAEDITVIEW;
                case "DEMOBWFDYNAEDITVIEW3":
                    return DEMOBWFDYNAEDITVIEW3;
                case "DEMOBWFDYNAEXPMDVIEW":
                    return DEMOBWFDYNAEXPMDVIEW;
                case "DEMOBWFDYNASTARTVIEW":
                    return DEMOBWFDYNASTARTVIEW;
                case "DEMOBWFEDITVIEW":
                    return DEMOBWFEDITVIEW;
                case "DEMOBWFEDITVIEW3":
                    return DEMOBWFEDITVIEW3;
                case "DEMOBWFMDVIEW":
                    return DEMOBWFMDVIEW;
                case "DEMOBWFPROXYRESULTVIEW":
                    return DEMOBWFPROXYRESULTVIEW;
                case "DEMOBWFPROXYSTARTVIEW":
                    return DEMOBWFPROXYSTARTVIEW;
                case "DEMOBWFSTARTVIEW":
                    return DEMOBWFSTARTVIEW;
                case "DEMOBWIZARDVIEW":
                    return DEMOBWIZARDVIEW;
                case "DEMPICKUPVIEW":
                    return DEMPICKUPVIEW;
                case "DEMPICKUPVIEW2":
                    return DEMPICKUPVIEW2;
                case "DEOPTVIEW":
                    return DEOPTVIEW;
                case "DEPANELVIEW":
                    return DEPANELVIEW;
                case "DEPANELVIEW9":
                    return DEPANELVIEW9;
                case "DEPICKUPDATAVIEW":
                    return DEPICKUPDATAVIEW;
                case "DEPICKUPGRIDVIEW":
                    return DEPICKUPGRIDVIEW;
                case "DEPICKUPTREEVIEW":
                    return DEPICKUPTREEVIEW;
                case "DEPICKUPVIEW":
                    return DEPICKUPVIEW;
                case "DEPICKUPVIEW2":
                    return DEPICKUPVIEW2;
                case "DEPICKUPVIEW3":
                    return DEPICKUPVIEW3;
                case "DEPORTALVIEW":
                    return DEPORTALVIEW;
                case "DEPORTALVIEW9":
                    return DEPORTALVIEW9;
                case "DEREDIRECTVIEW":
                    return DEREDIRECTVIEW;
                case "DEREPORTVIEW":
                    return DEREPORTVIEW;
                case "DETABEXPVIEW":
                    return DETABEXPVIEW;
                case "DETABEXPVIEW9":
                    return DETABEXPVIEW9;
                case "DETABSEARCHVIEW":
                    return DETABSEARCHVIEW;
                case "DETABSEARCHVIEW9":
                    return DETABSEARCHVIEW9;
                case "DETREEEXPVIEW":
                    return DETREEEXPVIEW;
                case "DETREEEXPVIEW2":
                    return DETREEEXPVIEW2;
                case "DETREEEXPVIEW3":
                    return DETREEEXPVIEW3;
                case "DETREEGRIDEXVIEW":
                    return DETREEGRIDEXVIEW;
                case "DETREEGRIDEXVIEW9":
                    return DETREEGRIDEXVIEW9;
                case "DETREEGRIDVIEW":
                    return DETREEGRIDVIEW;
                case "DETREEGRIDVIEW9":
                    return DETREEGRIDVIEW9;
                case "DETREEVIEW":
                    return DETREEVIEW;
                case "DETREEVIEW9":
                    return DETREEVIEW9;
                case "DEWFACTIONVIEW":
                    return DEWFACTIONVIEW;
                case "DEWFDATAREDIRECTVIEW":
                    return DEWFDATAREDIRECTVIEW;
                case "DEWFDYNAACTIONVIEW":
                    return DEWFDYNAACTIONVIEW;
                case "DEWFDYNAEDITVIEW":
                    return DEWFDYNAEDITVIEW;
                case "DEWFDYNAEDITVIEW3":
                    return DEWFDYNAEDITVIEW3;
                case "DEWFDYNAEXPGRIDVIEW":
                    return DEWFDYNAEXPGRIDVIEW;
                case "DEWFDYNASTARTVIEW":
                    return DEWFDYNASTARTVIEW;
                case "DEWFEDITPROXYDATAVIEW":
                    return DEWFEDITPROXYDATAVIEW;
                case "DEWFEDITVIEW":
                    return DEWFEDITVIEW;
                case "DEWFEDITVIEW2":
                    return DEWFEDITVIEW2;
                case "DEWFEDITVIEW3":
                    return DEWFEDITVIEW3;
                case "DEWFEDITVIEW9":
                    return DEWFEDITVIEW9;
                case "DEWFEXPVIEW":
                    return DEWFEXPVIEW;
                case "DEWFGRIDVIEW":
                    return DEWFGRIDVIEW;
                case "DEWFPROXYDATAVIEW":
                    return DEWFPROXYDATAVIEW;
                case "DEWFPROXYRESULTVIEW":
                    return DEWFPROXYRESULTVIEW;
                case "DEWFPROXYSTARTVIEW":
                    return DEWFPROXYSTARTVIEW;
                case "DEWFSTARTVIEW":
                    return DEWFSTARTVIEW;
                case "DEWIZARDVIEW":
                    return DEWIZARDVIEW;
                case "DESUBAPPREFVIEW":
                    return DESUBAPPREFVIEW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性重复值检查模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 不检查
     * <li>ALL
     * <P>
     * 全部检查
     * <li>NOTNULL
     * <P>
     * 非空检查
     * <li>CHECKVALUES
     * <P>
     * 指定值范围
     * <li>EXCLUDEVALUES
     * <P>
     * 排除值范围
     * </ul>     
     */
    public static enum DEFDupCheckMode{
        NONE("NONE", "不检查")
        ,ALL("ALL", "全部检查")
        ,NOTNULL("NOTNULL", "非空检查")
        ,CHECKVALUES("CHECKVALUES", "指定值范围")
        ,EXCLUDEVALUES("EXCLUDEVALUES", "排除值范围")
;
           
        public final String text;
        public final String value;
        
        private DEFDupCheckMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFDupCheckMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "ALL":
                    return ALL;
                case "NOTNULL":
                    return NOTNULL;
                case "CHECKVALUES":
                    return CHECKVALUES;
                case "EXCLUDEVALUES":
                    return EXCLUDEVALUES;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体接口数据关系模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 新建
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新
     * <li>GET&nbsp;(4)
     * <P>
     * 获取
     * <li>SELECT&nbsp;(8)
     * <P>
     * 查询
     * </ul>     
     */
    public static enum SADEDataRSMode{
        CREATE(1, "新建")
        ,UPDATE(2, "更新")
        ,GET(4, "获取")
        ,SELECT(8, "查询")
;
           
        public final String text;
        public final int value;
        
        private SADEDataRSMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEDataRSMode from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 4:
                    return GET;
                case 8:
                    return SELECT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索栏项子类型
     * <P>
     * <ul>
     * <li>INPUT_RADIOBUTTONLIST
     * <P>
     * 单选按钮列表
     * <li>INPUT_CHECKBOXLIST
     * <P>
     * 多选按钮列表
     * <li>INPUT_CHECKBOX
     * <P>
     * 选项按钮
     * <li>INPUT_TEXTBOX
     * <P>
     * 文本框
     * <li>BUTTON_SEARCH
     * <P>
     * 搜索按钮
     * <li>BUTTON_ADVSEARCH
     * <P>
     * 高级搜索按钮
     * <li>BUTTON_RESET
     * <P>
     * 重置按钮
     * </ul>     
     */
    public static enum SearchBarItemSubType{
        INPUT_RADIOBUTTONLIST("INPUT_RADIOBUTTONLIST", "单选按钮列表")
        ,INPUT_CHECKBOXLIST("INPUT_CHECKBOXLIST", "多选按钮列表")
        ,INPUT_CHECKBOX("INPUT_CHECKBOX", "选项按钮")
        ,INPUT_TEXTBOX("INPUT_TEXTBOX", "文本框")
        ,BUTTON_SEARCH("BUTTON_SEARCH", "搜索按钮")
        ,BUTTON_ADVSEARCH("BUTTON_ADVSEARCH", "高级搜索按钮")
        ,BUTTON_RESET("BUTTON_RESET", "重置按钮")
;
           
        public final String text;
        public final String value;
        
        private SearchBarItemSubType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchBarItemSubType from(String value){
            switch(value){
                case "INPUT_RADIOBUTTONLIST":
                    return INPUT_RADIOBUTTONLIST;
                case "INPUT_CHECKBOXLIST":
                    return INPUT_CHECKBOXLIST;
                case "INPUT_CHECKBOX":
                    return INPUT_CHECKBOX;
                case "INPUT_TEXTBOX":
                    return INPUT_TEXTBOX;
                case "BUTTON_SEARCH":
                    return BUTTON_SEARCH;
                case "BUTTON_ADVSEARCH":
                    return BUTTON_ADVSEARCH;
                case "BUTTON_RESET":
                    return BUTTON_RESET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用资源类型
     * <P>
     * <ul>
     * <li>IMAGE
     * <P>
     * 图片
     * <li>STRING
     * <P>
     * 字符串
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * <li>USER5
     * <P>
     * 用户自定义5
     * <li>USER6
     * <P>
     * 用户自定义6
     * <li>USER7
     * <P>
     * 用户自定义7
     * <li>USER8
     * <P>
     * 用户自定义8
     * <li>USER9
     * <P>
     * 用户自定义9
     * </ul>     
     */
    public static enum AppResourceType{
        IMAGE("IMAGE", "图片")
        ,STRING("STRING", "字符串")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
        ,USER5("USER5", "用户自定义5")
        ,USER6("USER6", "用户自定义6")
        ,USER7("USER7", "用户自定义7")
        ,USER8("USER8", "用户自定义8")
        ,USER9("USER9", "用户自定义9")
;
           
        public final String text;
        public final String value;
        
        private AppResourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppResourceType from(String value){
            switch(value){
                case "IMAGE":
                    return IMAGE;
                case "STRING":
                    return STRING;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                case "USER5":
                    return USER5;
                case "USER6":
                    return USER6;
                case "USER7":
                    return USER7;
                case "USER8":
                    return USER8;
                case "USER9":
                    return USER9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 自定义代码模式（仅模型脚本时对象代码），数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 未启用
     * <li>MODELRTSCRIPT&nbsp;(2)
     * <P>
     * 模型运行时对象脚本
     * </ul>     
     */
    public static enum ScriptMode2{
        DISABLED(0, "未启用")
        ,MODELRTSCRIPT(2, "模型运行时对象脚本")
;
           
        public final String text;
        public final int value;
        
        private ScriptMode2(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ScriptMode2 from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 2:
                    return MODELRTSCRIPT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体多表单模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 无
     * <li>DEFAULT&nbsp;(1)
     * <P>
     * 常规
     * <li>MODULEINST&nbsp;(2)
     * <P>
     * 动态实例模块副本
     * </ul>     
     */
    public static enum DEMultiFormMode{
        NO(0, "无")
        ,DEFAULT(1, "常规")
        ,MODULEINST(2, "动态实例模块副本")
;
           
        public final String text;
        public final int value;
        
        private DEMultiFormMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMultiFormMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return DEFAULT;
                case 2:
                    return MODULEINST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Flex布局方向
     * <P>
     * <ul>
     * <li>ROW&nbsp;(row)
     * <P>
     * 水平居左
     * <li>ROW_REVERSE&nbsp;(row-reverse)
     * <P>
     * 水平居右
     * <li>COLUMN&nbsp;(column)
     * <P>
     * 垂直从上往下
     * <li>COLUMN_REVERSE&nbsp;(column-reverse)
     * <P>
     * 垂直从下往上
     * </ul>     
     */
    public static enum FlexLayoutDir{
        ROW("row", "水平居左")
        ,ROW_REVERSE("row-reverse", "水平居右")
        ,COLUMN("column", "垂直从上往下")
        ,COLUMN_REVERSE("column-reverse", "垂直从下往上")
;
           
        public final String text;
        public final String value;
        
        private FlexLayoutDir(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FlexLayoutDir from(String value){
            switch(value){
                case "row":
                    return ROW;
                case "row-reverse":
                    return ROW_REVERSE;
                case "column":
                    return COLUMN;
                case "column-reverse":
                    return COLUMN_REVERSE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板布局模型
     * <P>
     * <ul>
     * <li>TABLE
     * <P>
     * 表格
     * <li>TABLE_12COL
     * <P>
     * 栅格布局（12列）
     * <li>TABLE_24COL
     * <P>
     * 栅格布局（24列）
     * <li>FLEX
     * <P>
     * Flex布局
     * <li>BORDER
     * <P>
     * 边缘布局
     * <li>ABSOLUTE
     * <P>
     * 绝对布局
     * </ul>     
     */
    public static enum LayoutMode{
        TABLE("TABLE", "表格")
        ,TABLE_12COL("TABLE_12COL", "栅格布局（12列）")
        ,TABLE_24COL("TABLE_24COL", "栅格布局（24列）")
        ,FLEX("FLEX", "Flex布局")
        ,BORDER("BORDER", "边缘布局")
        ,ABSOLUTE("ABSOLUTE", "绝对布局")
;
           
        public final String text;
        public final String value;
        
        private LayoutMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LayoutMode from(String value){
            switch(value){
                case "TABLE":
                    return TABLE;
                case "TABLE_12COL":
                    return TABLE_12COL;
                case "TABLE_24COL":
                    return TABLE_24COL;
                case "FLEX":
                    return FLEX;
                case "BORDER":
                    return BORDER;
                case "ABSOLUTE":
                    return ABSOLUTE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体属性界面模式表格列对齐
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左对齐
     * <li>CENTER
     * <P>
     * 居中
     * <li>RIGHT
     * <P>
     * 右对齐
     * </ul>     
     */
    public static enum GridColAlign{
        LEFT("LEFT", "左对齐")
        ,CENTER("CENTER", "居中")
        ,RIGHT("RIGHT", "右对齐")
;
           
        public final String text;
        public final String value;
        
        private GridColAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColAlign from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "CENTER":
                    return CENTER;
                case "RIGHT":
                    return RIGHT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统测试模块类型
     * <P>
     * <ul>
     * <li>COMMON
     * <P>
     * 常规
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TestModuleType{
        COMMON("COMMON", "常规")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TestModuleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestModuleType from(String value){
            switch(value){
                case "COMMON":
                    return COMMON;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑变量类型，数值项
     * <P>
     * <ul>
     * <li>COMMON&nbsp;(0)
     * <P>
     * 数据对象变量
     * <li>SESSION&nbsp;(1)
     * <P>
     * 会话变量，当前操作会话变量对象，支持同一操作会话多个逻辑之间的变量共享
     * <li>ENV&nbsp;(2)
     * <P>
     * 环境变量，当前的环境变量对象
     * <li>LAST&nbsp;(3)
     * <P>
     * 最后数据变量，操作之前的原有数据对象
     * <li>LASTRETURN&nbsp;(4)
     * <P>
     * 上一次调用返回
     * <li>FILTER&nbsp;(5)
     * <P>
     * 过滤器
     * <li>ENTITYLIST&nbsp;(6)
     * <P>
     * 数据对象列表变量
     * <li>ENTITYMAP&nbsp;(12)
     * <P>
     * 数据对象字典变量
     * <li>PAGE&nbsp;(7)
     * <P>
     * 分页查询结果变量
     * <li>FILE&nbsp;(8)
     * <P>
     * 文件对象变量
     * <li>FILELIST&nbsp;(9)
     * <P>
     * 文件对象列表变量
     * <li>SIMPLE&nbsp;(10)
     * <P>
     * 简单数据变量
     * <li>SIMPLELIST&nbsp;(11)
     * <P>
     * 简单数据列表变量
     * <li>CONTEXT&nbsp;(24)
     * <P>
     * 导航上下文变量，绑定当前会话导航上下文的变量
     * <li>APPGLOBALPARAM&nbsp;(27)
     * <P>
     * 应用全局变量（前端处理逻辑），绑定当前视图的导航数据参数变量
     * </ul>     
     */
    public static enum DELogicParamMode{
        COMMON(0, "数据对象变量")
        ,SESSION(1, "会话变量")
        ,ENV(2, "环境变量")
        ,LAST(3, "最后数据变量")
        ,LASTRETURN(4, "上一次调用返回")
        ,FILTER(5, "过滤器")
        ,ENTITYLIST(6, "数据对象列表变量")
        ,ENTITYMAP(12, "数据对象字典变量")
        ,PAGE(7, "分页查询结果变量")
        ,FILE(8, "文件对象变量")
        ,FILELIST(9, "文件对象列表变量")
        ,SIMPLE(10, "简单数据变量")
        ,SIMPLELIST(11, "简单数据列表变量")
        ,CONTEXT(24, "导航上下文变量")
        ,APPGLOBALPARAM(27, "应用全局变量（前端处理逻辑）")
;
           
        public final String text;
        public final int value;
        
        private DELogicParamMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicParamMode from(int value){
            switch(value){
                case 0:
                    return COMMON;
                case 1:
                    return SESSION;
                case 2:
                    return ENV;
                case 3:
                    return LAST;
                case 4:
                    return LASTRETURN;
                case 5:
                    return FILTER;
                case 6:
                    return ENTITYLIST;
                case 12:
                    return ENTITYMAP;
                case 7:
                    return PAGE;
                case 8:
                    return FILE;
                case 9:
                    return FILELIST;
                case 10:
                    return SIMPLE;
                case 11:
                    return SIMPLELIST;
                case 24:
                    return CONTEXT;
                case 27:
                    return APPGLOBALPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Pipeline阶段后续类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 未指定
     * <li>ALWAYS
     * <P>
     * 始终（Always）
     * <li>CHANGED
     * <P>
     * 构建状态变化（Changed）
     * <li>FIXED
     * <P>
     * 构建状态修复（Fixed），Only run the steps in post if the current Pipeline’s run is successful and the previous run failed or was unstable.
     * <li>REGRESSION
     * <P>
     * 构建状态倒退（Regression），Only run the steps in post if the current Pipeline’s or status is failure, unstable, or aborted and the previous run was successful.
     * <li>ABORTED
     * <P>
     * 构建被中止（Aborted），Only run the steps in post if the current Pipeline’s run has an "aborted" status, usually due to the Pipeline being manually aborted. This is typically denoted by gray in the web UI.
     * <li>FAILURE
     * <P>
     * 构建状态为失败（Failure），Only run the steps in post if the current Pipeline’s or stage’s run has a "failed" status, typically denoted by red in the web UI.
     * <li>SUCCESS
     * <P>
     * 构建状态为成功（Success），Only run the steps in post if the current Pipeline’s or stage’s run has a "success" status, typically denoted by blue or green in the web UI.
     * <li>UNSTABLE
     * <P>
     * 构建状态为不稳定（Unstable），Only run the steps in post if the current Pipeline’s run has an "unstable" status, usually caused by test failures, code violations, etc. This is typically denoted by yellow in the web UI.
     * <li>UNSUCCESSFUL
     * <P>
     * 构建状态不为成功（Unsuccessful），Only run the steps in post if the current Pipeline’s or stage’s run has not a "success" status. This is typically denoted in the web UI depending on the status previously mentioned (for stages this may fire if the build itself is unstable).
     * <li>CLEANUP
     * <P>
     * 清理（Cleanup），Run the steps in this post condition after every other post condition has been evaluated, regardless of the Pipeline or stage’s status.
     * </ul>     
     */
    public static enum PipelineStagePostType{
        NONE("NONE", "未指定")
        ,ALWAYS("ALWAYS", "始终（Always）")
        ,CHANGED("CHANGED", "构建状态变化（Changed）")
        ,FIXED("FIXED", "构建状态修复（Fixed）")
        ,REGRESSION("REGRESSION", "构建状态倒退（Regression）")
        ,ABORTED("ABORTED", "构建被中止（Aborted）")
        ,FAILURE("FAILURE", "构建状态为失败（Failure）")
        ,SUCCESS("SUCCESS", "构建状态为成功（Success）")
        ,UNSTABLE("UNSTABLE", "构建状态为不稳定（Unstable）")
        ,UNSUCCESSFUL("UNSUCCESSFUL", "构建状态不为成功（Unsuccessful）")
        ,CLEANUP("CLEANUP", "清理（Cleanup）")
;
           
        public final String text;
        public final String value;
        
        private PipelineStagePostType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PipelineStagePostType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "ALWAYS":
                    return ALWAYS;
                case "CHANGED":
                    return CHANGED;
                case "FIXED":
                    return FIXED;
                case "REGRESSION":
                    return REGRESSION;
                case "ABORTED":
                    return ABORTED;
                case "FAILURE":
                    return FAILURE;
                case "SUCCESS":
                    return SUCCESS;
                case "UNSTABLE":
                    return UNSTABLE;
                case "UNSUCCESSFUL":
                    return UNSUCCESSFUL;
                case "CLEANUP":
                    return CLEANUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体搜索表单按钮样式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认，默认样式，输出【搜索】及【重置】按钮
     * <li>NONE
     * <P>
     * 不显示，无搜索按钮，搜索表单项值发生变化时自动搜索
     * <li>SEARCHONLY
     * <P>
     * 只有搜索，仅输出【搜索】按钮
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum SearchFormButtonStyle{
        DEFAULT("DEFAULT", "默认")
        ,NONE("NONE", "不显示")
        ,SEARCHONLY("SEARCHONLY", "只有搜索")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private SearchFormButtonStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchFormButtonStyle from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "NONE":
                    return NONE;
                case "SEARCHONLY":
                    return SEARCHONLY;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统运行会话打包模式
     * <P>
     * <ul>
     * <li>DEBUG
     * <P>
     * 开发模式
     * <li>RELEASE
     * <P>
     * 生产模式
     * </ul>     
     */
    public static enum SysRunPackMode{
        DEBUG("DEBUG", "开发模式")
        ,RELEASE("RELEASE", "生产模式")
;
           
        public final String text;
        public final String value;
        
        private SysRunPackMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRunPackMode from(String value){
            switch(value){
                case "DEBUG":
                    return DEBUG;
                case "RELEASE":
                    return RELEASE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云数据库类型（静态），多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>DB2
     * <P>
     * DB2
     * <li>MYSQL5
     * <P>
     * MySQL5
     * <li>ORACLE
     * <P>
     * Oracle
     * <li>SQLSERVER
     * <P>
     * SqlServer
     * <li>POSTGRESQL
     * <P>
     * PostgreSQL
     * <li>PPAS
     * <P>
     * PPAS
     * <li>SQLITE
     * <P>
     * SQLite
     * <li>DM
     * <P>
     * DM
     * <li>HANA
     * <P>
     * HANA
     * </ul>     
     */
    public static enum DBType{
        DB2("DB2", "DB2")
        ,MYSQL5("MYSQL5", "MySQL5")
        ,ORACLE("ORACLE", "Oracle")
        ,SQLSERVER("SQLSERVER", "SqlServer")
        ,POSTGRESQL("POSTGRESQL", "PostgreSQL")
        ,PPAS("PPAS", "PPAS")
        ,SQLITE("SQLITE", "SQLite")
        ,DM("DM", "DM")
        ,HANA("HANA", "HANA")
;
           
        public final String text;
        public final String value;
        
        private DBType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBType from(String value){
            switch(value){
                case "DB2":
                    return DB2;
                case "MYSQL5":
                    return MYSQL5;
                case "ORACLE":
                    return ORACLE;
                case "SQLSERVER":
                    return SQLSERVER;
                case "POSTGRESQL":
                    return POSTGRESQL;
                case "PPAS":
                    return PPAS;
                case "SQLITE":
                    return SQLITE;
                case "DM":
                    return DM;
                case "HANA":
                    return HANA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体预置业务模式
     * <P>
     * <ul>
     * <li>DATAAUDIT
     * <P>
     * 数据审计记录
     * <li>DYNASTORAGE
     * <P>
     * 动态数据存储
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEBizTag{
        DATAAUDIT("DATAAUDIT", "数据审计记录")
        ,DYNASTORAGE("DYNASTORAGE", "动态数据存储")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEBizTag(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEBizTag from(String value){
            switch(value){
                case "DATAAUDIT":
                    return DATAAUDIT;
                case "DYNASTORAGE":
                    return DYNASTORAGE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体1：1关系主从关系类型，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>RELATED&nbsp;(1)
     * <P>
     * 附属关系，从实体是主实体的附属实体
     * <li>DAC&nbsp;(4)
     * <P>
     * 数据访问控制，从实体的操作标识将映射到主实体，由主实体进行访问控制
     * <li>NESTED&nbsp;(8)
     * <P>
     * 嵌套操作，从实体是主实体的嵌套数据成员
     * <li>NOTIFY&nbsp;(32)
     * <P>
     * 关联通知，从实体触发主实体通知
     * <li>EXTENSION&nbsp;(64)
     * <P>
     * 附属扩展
     * <li>USER&nbsp;(1048576)
     * <P>
     * 自定义
     * <li>USER2&nbsp;(2097152)
     * <P>
     * 自定义2
     * <li>USER3&nbsp;(4194304)
     * <P>
     * 自定义3
     * <li>USER4&nbsp;(8388608)
     * <P>
     * 自定义4
     * </ul>     
     */
    public static enum DER11MasterRS{
        RELATED(1, "附属关系")
        ,DAC(4, "数据访问控制")
        ,NESTED(8, "嵌套操作")
        ,NOTIFY(32, "关联通知")
        ,EXTENSION(64, "附属扩展")
        ,USER(1048576, "自定义")
        ,USER2(2097152, "自定义2")
        ,USER3(4194304, "自定义3")
        ,USER4(8388608, "自定义4")
;
           
        public final String text;
        public final int value;
        
        private DER11MasterRS(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DER11MasterRS from(int value){
            switch(value){
                case 1:
                    return RELATED;
                case 4:
                    return DAC;
                case 8:
                    return NESTED;
                case 32:
                    return NOTIFY;
                case 64:
                    return EXTENSION;
                case 1048576:
                    return USER;
                case 2097152:
                    return USER2;
                case 4194304:
                    return USER3;
                case 8388608:
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树节点关系搜索模式，数值项
     * <P>
     * <ul>
     * <li>SEARCH&nbsp;(1)
     * <P>
     * 有搜索时启用，树节点关系在存在过滤条件时启用
     * <li>NOSEARCH&nbsp;(2)
     * <P>
     * 无搜索时启用，树节点关系在不存在过滤条件时启用
     * <li>ALL&nbsp;(3)
     * <P>
     * 全部启用，树节点关系全部启用
     * </ul>     
     */
    public static enum TreeNodeRSSearchMode{
        SEARCH(1, "有搜索时启用")
        ,NOSEARCH(2, "无搜索时启用")
        ,ALL(3, "全部启用")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeRSSearchMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeRSSearchMode from(int value){
            switch(value){
                case 1:
                    return SEARCH;
                case 2:
                    return NOSEARCH;
                case 3:
                    return ALL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 内容垂直对齐方式
     * <P>
     * <ul>
     * <li>TOP
     * <P>
     * 上对齐
     * <li>MIDDLE
     * <P>
     * 居中
     * <li>BOTTOM
     * <P>
     * 下对齐
     * </ul>     
     */
    public static enum TextVAlign{
        TOP("TOP", "上对齐")
        ,MIDDLE("MIDDLE", "居中")
        ,BOTTOM("BOTTOM", "下对齐")
;
           
        public final String text;
        public final String value;
        
        private TextVAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TextVAlign from(String value){
            switch(value){
                case "TOP":
                    return TOP;
                case "MIDDLE":
                    return MIDDLE;
                case "BOTTOM":
                    return BOTTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性界面项默认值类型
     * <P>
     * <ul>
     * <li>SESSION
     * <P>
     * 用户全局对象，当前用户的上下文对象，需指定属性键名
     * <li>APPLICATION
     * <P>
     * 系统全局对象，当前系统的上下文对象，需指定属性键名
     * <li>UNIQUEID
     * <P>
     * 唯一编码，生成一个随机标识，一般使用GUID
     * <li>CONTEXT
     * <P>
     * 网页请求，当前请求的参数对象，需指定属性键名
     * <li>PARAM
     * <P>
     * 数据对象属性，当前处理的数据对象，需指定属性键名，数据对象属性的处理一般放在最后，让其它逻辑先完成数据对象填充
     * <li>OPERATOR
     * <P>
     * 当前操作用户(编号)，当前处理的用户标识
     * <li>OPERATORNAME
     * <P>
     * 当前操作用户(名称)，当前处理的用户名称
     * <li>CURTIME
     * <P>
     * 当前时间，当前系统时间
     * <li>APPDATA
     * <P>
     * 当前应用数据，当前应用的上下文对象，需指定属性键名。当前应用指正在运行的前端程序的环境变量，如应用打开的数据，使用的用户身份等
     * </ul>     
     */
    public static enum CreateDefaultValueType{
        SESSION("SESSION", "用户全局对象")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,UNIQUEID("UNIQUEID", "唯一编码")
        ,CONTEXT("CONTEXT", "网页请求")
        ,PARAM("PARAM", "数据对象属性")
        ,OPERATOR("OPERATOR", "当前操作用户(编号)")
        ,OPERATORNAME("OPERATORNAME", "当前操作用户(名称)")
        ,CURTIME("CURTIME", "当前时间")
        ,APPDATA("APPDATA", "当前应用数据")
;
           
        public final String text;
        public final String value;
        
        private CreateDefaultValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CreateDefaultValueType from(String value){
            switch(value){
                case "SESSION":
                    return SESSION;
                case "APPLICATION":
                    return APPLICATION;
                case "UNIQUEID":
                    return UNIQUEID;
                case "CONTEXT":
                    return CONTEXT;
                case "PARAM":
                    return PARAM;
                case "OPERATOR":
                    return OPERATOR;
                case "OPERATORNAME":
                    return OPERATORNAME;
                case "CURTIME":
                    return CURTIME;
                case "APPDATA":
                    return APPDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流条件值类型
     * <P>
     * <ul>
     * <li>DATASTREAM
     * <P>
     * 数据源属性，指定数据源属性
     * <li>DATASTREAM2
     * <P>
     * 数据源2属性，指定数据源2属性
     * <li>SESSION
     * <P>
     * 用户全局对象
     * <li>DATACONTEXT
     * <P>
     * 数据上下文
     * <li>ENVPARAM
     * <P>
     * 当前环境参数
     * <li>NONEVALUE
     * <P>
     * 无值（NONE）
     * <li>NULLVALUE
     * <P>
     * 空值（NULL）
     * <li>SRCVALUE
     * <P>
     * 直接值
     * <li>EXPRESSION
     * <P>
     * 计算式
     * </ul>     
     */
    public static enum DEDataFlowCondValueType{
        DATASTREAM("DATASTREAM", "数据源属性")
        ,DATASTREAM2("DATASTREAM2", "数据源2属性")
        ,SESSION("SESSION", "用户全局对象")
        ,DATACONTEXT("DATACONTEXT", "数据上下文")
        ,ENVPARAM("ENVPARAM", "当前环境参数")
        ,NONEVALUE("NONEVALUE", "无值（NONE）")
        ,NULLVALUE("NULLVALUE", "空值（NULL）")
        ,SRCVALUE("SRCVALUE", "直接值")
        ,EXPRESSION("EXPRESSION", "计算式")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowCondValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowCondValueType from(String value){
            switch(value){
                case "DATASTREAM":
                    return DATASTREAM;
                case "DATASTREAM2":
                    return DATASTREAM2;
                case "SESSION":
                    return SESSION;
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "ENVPARAM":
                    return ENVPARAM;
                case "NONEVALUE":
                    return NONEVALUE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "SRCVALUE":
                    return SRCVALUE;
                case "EXPRESSION":
                    return EXPRESSION;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性视图列级别（带属性组），数值项
     * <P>
     * <ul>
     * <li>ALL&nbsp;(0)
     * <P>
     * 全部数据
     * <li>LEVEL1&nbsp;(1)
     * <P>
     * 2级（无行外数据）
     * <li>LEVEL2&nbsp;(2)
     * <P>
     * 3级（关键数据）
     * <li>LEVEL3&nbsp;(3)
     * <P>
     * 4级（个别字段）
     * <li>DEFGROUP&nbsp;(100)
     * <P>
     * 指定属性组
     * </ul>     
     */
    public static enum DEDataQueryColLevel2{
        ALL(0, "全部数据")
        ,LEVEL1(1, "2级（无行外数据）")
        ,LEVEL2(2, "3级（关键数据）")
        ,LEVEL3(3, "4级（个别字段）")
        ,DEFGROUP(100, "指定属性组")
;
           
        public final String text;
        public final int value;
        
        private DEDataQueryColLevel2(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataQueryColLevel2 from(int value){
            switch(value){
                case 0:
                    return ALL;
                case 1:
                    return LEVEL1;
                case 2:
                    return LEVEL2;
                case 3:
                    return LEVEL3;
                case 100:
                    return DEFGROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 运行时插件模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 非运行时插件
     * <li>LOCAL&nbsp;(1)
     * <P>
     * 本地运行时插件
     * <li>REMOTE&nbsp;(2)
     * <P>
     * 远程运行时插件
     * </ul>     
     */
    public static enum PluginRTMode{
        NO(0, "非运行时插件")
        ,LOCAL(1, "本地运行时插件")
        ,REMOTE(2, "远程运行时插件")
;
           
        public final String text;
        public final int value;
        
        private PluginRTMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PluginRTMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return LOCAL;
                case 2:
                    return REMOTE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格视图编辑模式
     * <P>
     * <ul>
     * <li>MULTIFORM
     * <P>
     * 多表单
     * <li>INDEXDE
     * <P>
     * 索引实体
     * <li>NORMAL
     * <P>
     * 常规
     * </ul>     
     */
    public static enum EditDataMode{
        MULTIFORM("MULTIFORM", "多表单")
        ,INDEXDE("INDEXDE", "索引实体")
        ,NORMAL("NORMAL", "常规")
;
           
        public final String text;
        public final String value;
        
        private EditDataMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditDataMode from(String value){
            switch(value){
                case "MULTIFORM":
                    return MULTIFORM;
                case "INDEXDE":
                    return INDEXDE;
                case "NORMAL":
                    return NORMAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 开发系统引用使用模式
     * <P>
     * <ul>
     * <li>LIB
     * <P>
     * 组件
     * <li>CLOUD
     * <P>
     * 云服务
     * <li>CLOUDHUBSUBAPP
     * <P>
     * Cloud集成子应用
     * <li>ETLEXTRACT
     * <P>
     * ETL展开逻辑
     * <li>ETLTRANSFORM
     * <P>
     * ETL转换逻辑
     * <li>ETLLOAD
     * <P>
     * ETL加载逻辑
     * <li>ETLSOURCE
     * <P>
     * ETL数据源（模型同步）
     * <li>ETLMODEL
     * <P>
     * ETL模型（模型同步）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DevSysRefUsage{
        LIB("LIB", "组件")
        ,CLOUD("CLOUD", "云服务")
        ,CLOUDHUBSUBAPP("CLOUDHUBSUBAPP", "Cloud集成子应用")
        ,ETLEXTRACT("ETLEXTRACT", "ETL展开逻辑")
        ,ETLTRANSFORM("ETLTRANSFORM", "ETL转换逻辑")
        ,ETLLOAD("ETLLOAD", "ETL加载逻辑")
        ,ETLSOURCE("ETLSOURCE", "ETL数据源（模型同步）")
        ,ETLMODEL("ETLMODEL", "ETL模型（模型同步）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DevSysRefUsage(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DevSysRefUsage from(String value){
            switch(value){
                case "LIB":
                    return LIB;
                case "CLOUD":
                    return CLOUD;
                case "CLOUDHUBSUBAPP":
                    return CLOUDHUBSUBAPP;
                case "ETLEXTRACT":
                    return ETLEXTRACT;
                case "ETLTRANSFORM":
                    return ETLTRANSFORM;
                case "ETLLOAD":
                    return ETLLOAD;
                case "ETLSOURCE":
                    return ETLSOURCE;
                case "ETLMODEL":
                    return ETLMODEL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 智能报表报表项类型
     * <P>
     * <ul>
     * <li>MEASURE
     * <P>
     * 指标
     * <li>DIMENSION
     * <P>
     * 维度
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum BIReportItemType{
        MEASURE("MEASURE", "指标")
        ,DIMENSION("DIMENSION", "维度")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private BIReportItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BIReportItemType from(String value){
            switch(value){
                case "MEASURE":
                    return MEASURE;
                case "DIMENSION":
                    return DIMENSION;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 文本换行模式
     * <P>
     * <ul>
     * <li>WRAP
     * <P>
     * 换行
     * <li>NOWRAP
     * <P>
     * 不换行
     * </ul>     
     */
    public static enum WrapMode{
        WRAP("WRAP", "换行")
        ,NOWRAP("NOWRAP", "不换行")
;
           
        public final String text;
        public final String value;
        
        private WrapMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WrapMode from(String value){
            switch(value){
                case "WRAP":
                    return WRAP;
                case "NOWRAP":
                    return NOWRAP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树视图节点选中处理类型
     * <P>
     * <ul>
     * <li>PAGELINK
     * <P>
     * 页面链接
     * <li>JAVASCRIPT
     * <P>
     * 脚本执行
     * </ul>     
     */
    public static enum TreeNodeActionType{
        PAGELINK("PAGELINK", "页面链接")
        ,JAVASCRIPT("JAVASCRIPT", "脚本执行")
;
           
        public final String text;
        public final String value;
        
        private TreeNodeActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeActionType from(String value){
            switch(value){
                case "PAGELINK":
                    return PAGELINK;
                case "JAVASCRIPT":
                    return JAVASCRIPT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台核心产品功能状态，数值项
     * <P>
     * <ul>
     * <li>NOTINSTALL&nbsp;(0)
     * <P>
     * 未安装
     * <li>INSTALLED&nbsp;(1)
     * <P>
     * 已安装
     * <li>DISABLED&nbsp;(2)
     * <P>
     * 已禁用
     * </ul>     
     */
    public static enum ProductFuncState{
        NOTINSTALL(0, "未安装")
        ,INSTALLED(1, "已安装")
        ,DISABLED(2, "已禁用")
;
           
        public final String text;
        public final int value;
        
        private ProductFuncState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ProductFuncState from(int value){
            switch(value){
                case 0:
                    return NOTINSTALL;
                case 1:
                    return INSTALLED;
                case 2:
                    return DISABLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 移动端横竖屏设置
     * <P>
     * <ul>
     * <li>PORTRAIT
     * <P>
     * 竖屏显示
     * <li>LANDSCAPE
     * <P>
     * 横屏显示
     * </ul>     
     */
    public static enum MobAppOrientationMode{
        PORTRAIT("PORTRAIT", "竖屏显示")
        ,LANDSCAPE("LANDSCAPE", "横屏显示")
;
           
        public final String text;
        public final String value;
        
        private MobAppOrientationMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobAppOrientationMode from(String value){
            switch(value){
                case "PORTRAIT":
                    return PORTRAIT;
                case "LANDSCAPE":
                    return LANDSCAPE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表格排序模式
     * <P>
     * <ul>
     * <li>REMOTE
     * <P>
     * 远程排序，将排序信息发送到后台由后台对全部数据进行排序
     * <li>LOCAL
     * <P>
     * 本地排序，前端对当前加载的数据进行排序处理
     * </ul>     
     */
    public static enum SortMode{
        REMOTE("REMOTE", "远程排序")
        ,LOCAL("LOCAL", "本地排序")
;
           
        public final String text;
        public final String value;
        
        private SortMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SortMode from(String value){
            switch(value){
                case "REMOTE":
                    return REMOTE;
                case "LOCAL":
                    return LOCAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 微信逻辑事件类型
     * <P>
     * <ul>
     * <li>APP_IN&nbsp;(app_in)
     * <P>
     * 进入应用
     * <li>LOCATION_IN&nbsp;(location_in)
     * <P>
     * 上报地理位置
     * <li>ASYNCTASK_FINISH&nbsp;(asynctask_finish)
     * <P>
     * 异步任务完成事件推送
     * <li>MENU_CLICK&nbsp;(menu_click)
     * <P>
     * 菜单事件
     * <li>MESSAGE_IN&nbsp;(message_in)
     * <P>
     * 消息进入
     * </ul>     
     */
    public static enum WXLogicEventType{
        APP_IN("app_in", "进入应用")
        ,LOCATION_IN("location_in", "上报地理位置")
        ,ASYNCTASK_FINISH("asynctask_finish", "异步任务完成事件推送")
        ,MENU_CLICK("menu_click", "菜单事件")
        ,MESSAGE_IN("message_in", "消息进入")
;
           
        public final String text;
        public final String value;
        
        private WXLogicEventType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WXLogicEventType from(String value){
            switch(value){
                case "app_in":
                    return APP_IN;
                case "location_in":
                    return LOCATION_IN;
                case "asynctask_finish":
                    return ASYNCTASK_FINISH;
                case "menu_click":
                    return MENU_CLICK;
                case "message_in":
                    return MESSAGE_IN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表格树列模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>TEXT&nbsp;(1)
     * <P>
     * 文本
     * <li>VALUE&nbsp;(2)
     * <P>
     * 值
     * <li>TEXTVALUE&nbsp;(3)
     * <P>
     * 文本及值
     * <li>PTEXT&nbsp;(8)
     * <P>
     * 父文本
     * <li>PVALUE&nbsp;(4)
     * <P>
     * 父值
     * <li>PTEXTPVALUE&nbsp;(12)
     * <P>
     * 父文本及父值
     * </ul>     
     */
    public static enum GridTreeColMode{
        NONE(0, "无")
        ,TEXT(1, "文本")
        ,VALUE(2, "值")
        ,TEXTVALUE(3, "文本及值")
        ,PTEXT(8, "父文本")
        ,PVALUE(4, "父值")
        ,PTEXTPVALUE(12, "父文本及父值")
;
           
        public final String text;
        public final int value;
        
        private GridTreeColMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridTreeColMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return TEXT;
                case 2:
                    return VALUE;
                case 3:
                    return TEXTVALUE;
                case 8:
                    return PTEXT;
                case 4:
                    return PVALUE;
                case 12:
                    return PTEXTPVALUE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Pipeline阶段类型
     * <P>
     * <ul>
     * <li>NORMAL
     * <P>
     * 常规
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum PipelineStageType{
        NORMAL("NORMAL", "常规")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private PipelineStageType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PipelineStageType from(String value){
            switch(value){
                case "NORMAL":
                    return NORMAL;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Pipeline阶段代理类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 未指定
     * <li>TAGS
     * <P>
     * 指定代理标记
     * <li>IMAGE
     * <P>
     * 指定代理镜像
     * <li>REGISTRYITEM
     * <P>
     * 指定代理镜像（预置）
     * </ul>     
     */
    public static enum PipelineStageAgentType{
        NONE("NONE", "未指定")
        ,TAGS("TAGS", "指定代理标记")
        ,IMAGE("IMAGE", "指定代理镜像")
        ,REGISTRYITEM("REGISTRYITEM", "指定代理镜像（预置）")
;
           
        public final String text;
        public final String value;
        
        private PipelineStageAgentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PipelineStageAgentType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "TAGS":
                    return TAGS;
                case "IMAGE":
                    return IMAGE;
                case "REGISTRYITEM":
                    return REGISTRYITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性值序列使用模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>GETDRAFT
     * <P>
     * 草稿
     * <li>CREATE
     * <P>
     * 建立
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEFSequenceMode{
        NONE("NONE", "无")
        ,GETDRAFT("GETDRAFT", "草稿")
        ,CREATE("CREATE", "建立")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEFSequenceMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFSequenceMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "GETDRAFT":
                    return GETDRAFT;
                case "CREATE":
                    return CREATE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 门户部件HTML内容显示模式
     * <P>
     * <ul>
     * <li>INNER
     * <P>
     * 嵌入，请求指定HTML路径，将反馈的内容插入到门户部件的内容容器中
     * <li>IFRAME
     * <P>
     * IFrame，使用IFrame打开指定的HTML路径
     * </ul>     
     */
    public static enum PortletHtmlShowMode{
        INNER("INNER", "嵌入")
        ,IFRAME("IFRAME", "IFrame")
;
           
        public final String text;
        public final String value;
        
        private PortletHtmlShowMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PortletHtmlShowMode from(String value){
            switch(value){
                case "INNER":
                    return INNER;
                case "IFRAME":
                    return IFRAME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 集成元素引用元素排序模式
     * <P>
     * <ul>
     * <li>ALL
     * <P>
     * 全部（随机次序，只能出现一次）
     * <li>CHOICE
     * <P>
     * 选择一项
     * <li>SEQUENCE
     * <P>
     * 按次序
     * </ul>     
     */
    public static enum EAIElementREOrderMode{
        ALL("ALL", "全部（随机次序，只能出现一次）")
        ,CHOICE("CHOICE", "选择一项")
        ,SEQUENCE("SEQUENCE", "按次序")
;
           
        public final String text;
        public final String value;
        
        private EAIElementREOrderMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EAIElementREOrderMode from(String value){
            switch(value){
                case "ALL":
                    return ALL;
                case "CHOICE":
                    return CHOICE;
                case "SEQUENCE":
                    return SEQUENCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件逻辑类型
     * <P>
     * <ul>
     * <li>TIMER
     * <P>
     * 定时器触发，定时器定时触发逻辑，需指定定时器时间间隔
     * <li>CTRLEVENT
     * <P>
     * 部件事件触发，指定部件事件触发逻辑，需同时指定部件标识及事件名称
     * <li>ITEMVISIBLE
     * <P>
     * 项显示逻辑，成员项动态显示逻辑，控制成员是否显示
     * <li>ITEMENABLE
     * <P>
     * 项启用逻辑，成员项的动态启用逻辑，控成员及其编辑器启用禁用状态
     * <li>ITEMBLANK
     * <P>
     * 项空输入逻辑，成员项的动态空输入逻辑，控制成员项及其编辑器是否允许空输入
     * <li>ATTRIBUTE
     * <P>
     * 注入属性，向容器或相关成员注入属性
     * <li>CUSTOM
     * <P>
     * 只挂接（外部调用），仅发布逻辑，不挂接任何事件，由其它逻辑驱动或自定义代码调用
     * <li>VUE_DIRECTIVE
     * <P>
     * VUE指令
     * </ul>     
     */
    public static enum CtrlLogicTrigger{
        TIMER("TIMER", "定时器触发")
        ,CTRLEVENT("CTRLEVENT", "部件事件触发")
        ,ITEMVISIBLE("ITEMVISIBLE", "项显示逻辑")
        ,ITEMENABLE("ITEMENABLE", "项启用逻辑")
        ,ITEMBLANK("ITEMBLANK", "项空输入逻辑")
        ,ATTRIBUTE("ATTRIBUTE", "注入属性")
        ,CUSTOM("CUSTOM", "只挂接（外部调用）")
        ,VUE_DIRECTIVE("VUE_DIRECTIVE", "VUE指令")
;
           
        public final String text;
        public final String value;
        
        private CtrlLogicTrigger(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlLogicTrigger from(String value){
            switch(value){
                case "TIMER":
                    return TIMER;
                case "CTRLEVENT":
                    return CTRLEVENT;
                case "ITEMVISIBLE":
                    return ITEMVISIBLE;
                case "ITEMENABLE":
                    return ITEMENABLE;
                case "ITEMBLANK":
                    return ITEMBLANK;
                case "ATTRIBUTE":
                    return ATTRIBUTE;
                case "CUSTOM":
                    return CUSTOM;
                case "VUE_DIRECTIVE":
                    return VUE_DIRECTIVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 用例图节点类型
     * <P>
     * <ul>
     * <li>ACTOR
     * <P>
     * 操作者
     * <li>USECASE
     * <P>
     * 用例
     * </ul>     
     */
    public static enum UCMapNodeType{
        ACTOR("ACTOR", "操作者")
        ,USECASE("USECASE", "用例")
;
           
        public final String text;
        public final String value;
        
        private UCMapNodeType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UCMapNodeType from(String value){
            switch(value){
                case "ACTOR":
                    return ACTOR;
                case "USECASE":
                    return USECASE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 开发系统状态，数值项
     * <P>
     * <ul>
     * <li>UNINITIALIZED&nbsp;(10)
     * <P>
     * 未初始化
     * <li>CREATING&nbsp;(20)
     * <P>
     * 创建中
     * <li>RECOVERING&nbsp;(21)
     * <P>
     * 恢复中
     * <li>ONLINE&nbsp;(30)
     * <P>
     * 正常
     * <li>MAINTAIN&nbsp;(31)
     * <P>
     * 运维中
     * <li>OFFLINE&nbsp;(35)
     * <P>
     * 已离线
     * <li>REMOVED&nbsp;(40)
     * <P>
     * 已删除
     * <li>EXPIRED&nbsp;(41)
     * <P>
     * 已超期
     * <li>CREATEFAILED&nbsp;(42)
     * <P>
     * 创建失败
     * </ul>     
     */
    public static enum DevSysState{
        UNINITIALIZED(10, "未初始化")
        ,CREATING(20, "创建中")
        ,RECOVERING(21, "恢复中")
        ,ONLINE(30, "正常")
        ,MAINTAIN(31, "运维中")
        ,OFFLINE(35, "已离线")
        ,REMOVED(40, "已删除")
        ,EXPIRED(41, "已超期")
        ,CREATEFAILED(42, "创建失败")
;
           
        public final String text;
        public final int value;
        
        private DevSysState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DevSysState from(int value){
            switch(value){
                case 10:
                    return UNINITIALIZED;
                case 20:
                    return CREATING;
                case 21:
                    return RECOVERING;
                case 30:
                    return ONLINE;
                case 31:
                    return MAINTAIN;
                case 35:
                    return OFFLINE;
                case 40:
                    return REMOVED;
                case 41:
                    return EXPIRED;
                case 42:
                    return CREATEFAILED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为返回值类型
     * <P>
     * <ul>
     * <li>VOID
     * <P>
     * 无（void）
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SIMPLES
     * <P>
     * 简单值数组
     * <li>ENTITY
     * <P>
     * 数据对象（Entity）
     * <li>ENTITIES
     * <P>
     * 数据对象数组（Entity[]）
     * <li>OBJECT
     * <P>
     * 其它对象（Object）
     * <li>OBJECTS
     * <P>
     * 其它对象数组（Object[]）
     * <li>LINKENTITY
     * <P>
     * 外部数据对象（Entity）
     * <li>LINKENTITIES
     * <P>
     * 外部数据对象数组（Entity[]）
     * <li>ASYNCACTION
     * <P>
     * 异步操作对象
     * <li>SSE
     * <P>
     * 服务器端事件对象（SSE）
     * <li>USER
     * <P>
     * 用户自定义（USER）
     * <li>USER2
     * <P>
     * 用户自定义2（USER2）
     * </ul>     
     */
    public static enum DEActionRetType{
        VOID("VOID", "无（void）")
        ,SIMPLE("SIMPLE", "简单值")
        ,SIMPLES("SIMPLES", "简单值数组")
        ,ENTITY("ENTITY", "数据对象（Entity）")
        ,ENTITIES("ENTITIES", "数据对象数组（Entity[]）")
        ,OBJECT("OBJECT", "其它对象（Object）")
        ,OBJECTS("OBJECTS", "其它对象数组（Object[]）")
        ,LINKENTITY("LINKENTITY", "外部数据对象（Entity）")
        ,LINKENTITIES("LINKENTITIES", "外部数据对象数组（Entity[]）")
        ,ASYNCACTION("ASYNCACTION", "异步操作对象")
        ,SSE("SSE", "服务器端事件对象（SSE）")
        ,USER("USER", "用户自定义（USER）")
        ,USER2("USER2", "用户自定义2（USER2）")
;
           
        public final String text;
        public final String value;
        
        private DEActionRetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionRetType from(String value){
            switch(value){
                case "VOID":
                    return VOID;
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "ENTITY":
                    return ENTITY;
                case "ENTITIES":
                    return ENTITIES;
                case "OBJECT":
                    return OBJECT;
                case "OBJECTS":
                    return OBJECTS;
                case "LINKENTITY":
                    return LINKENTITY;
                case "LINKENTITIES":
                    return LINKENTITIES;
                case "ASYNCACTION":
                    return ASYNCACTION;
                case "SSE":
                    return SSE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 阈值组类型
     * <P>
     * <ul>
     * <li>STATIC
     * <P>
     * 静态
     * <li>DYNAMIC
     * <P>
     * 动态
     * </ul>     
     */
    public static enum ThresholdGroupType{
        STATIC("STATIC", "静态")
        ,DYNAMIC("DYNAMIC", "动态")
;
           
        public final String text;
        public final String value;
        
        private ThresholdGroupType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ThresholdGroupType from(String value){
            switch(value){
                case "STATIC":
                    return STATIC;
                case "DYNAMIC":
                    return DYNAMIC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台部服务接口处理对象
     * <P>
     * <ul>
     * <li>SAASADMIN
     * <P>
     * SaaS应用管理接口
     * <li>WFSERVICE
     * <P>
     * 工作流引擎服务接口
     * <li>WFPROXYAPP
     * <P>
     * 工作流代理应用接口
     * <li>WFCALLBACK
     * <P>
     * 工作流引擎回调接口
     * <li>USERAUTH
     * <P>
     * 用户授权服务接口
     * <li>ORGSERVICE
     * <P>
     * 组织管理服务接口
     * <li>ORGCALLBACK
     * <P>
     * 组织服务回调接口
     * <li>CORESERVICE
     * <P>
     * SaaS核心服务接口
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum ServiceAPIPredefinedType{
        SAASADMIN("SAASADMIN", "SaaS应用管理接口")
        ,WFSERVICE("WFSERVICE", "工作流引擎服务接口")
        ,WFPROXYAPP("WFPROXYAPP", "工作流代理应用接口")
        ,WFCALLBACK("WFCALLBACK", "工作流引擎回调接口")
        ,USERAUTH("USERAUTH", "用户授权服务接口")
        ,ORGSERVICE("ORGSERVICE", "组织管理服务接口")
        ,ORGCALLBACK("ORGCALLBACK", "组织服务回调接口")
        ,CORESERVICE("CORESERVICE", "SaaS核心服务接口")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private ServiceAPIPredefinedType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceAPIPredefinedType from(String value){
            switch(value){
                case "SAASADMIN":
                    return SAASADMIN;
                case "WFSERVICE":
                    return WFSERVICE;
                case "WFPROXYAPP":
                    return WFPROXYAPP;
                case "WFCALLBACK":
                    return WFCALLBACK;
                case "USERAUTH":
                    return USERAUTH;
                case "ORGSERVICE":
                    return ORGSERVICE;
                case "ORGCALLBACK":
                    return ORGCALLBACK;
                case "CORESERVICE":
                    return CORESERVICE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台数据库对象类型
     * <P>
     * <ul>
     * <li>TABLE
     * <P>
     * 表
     * <li>COLUMN
     * <P>
     * 列
     * <li>VIEW
     * <P>
     * 视图
     * <li>FKEY
     * <P>
     * 外键约束
     * <li>INDEX
     * <P>
     * 数据库索引
     * </ul>     
     */
    public static enum DBObjectType{
        TABLE("TABLE", "表")
        ,COLUMN("COLUMN", "列")
        ,VIEW("VIEW", "视图")
        ,FKEY("FKEY", "外键约束")
        ,INDEX("INDEX", "数据库索引")
;
           
        public final String text;
        public final String value;
        
        private DBObjectType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBObjectType from(String value){
            switch(value){
                case "TABLE":
                    return TABLE;
                case "COLUMN":
                    return COLUMN;
                case "VIEW":
                    return VIEW;
                case "FKEY":
                    return FKEY;
                case "INDEX":
                    return INDEX;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体1：N关系属性映射类型
     * <P>
     * <ul>
     * <li>SUM
     * <P>
     * 合计，将从实体的指定属性的值进行合计
     * <li>AVG
     * <P>
     * 平均，将从实体的指定属性的值进行平均
     * <li>MAX
     * <P>
     * 最大值，取从实体的指定属性的最大值
     * <li>MIN
     * <P>
     * 最小值，取从实体的指定属性的最小值
     * <li>COUNT
     * <P>
     * 计数，从实体计数
     * <li>EXISTS
     * <P>
     * 存在，从实体存在，1表示存在，0表示不存在
     * <li>NOTEXISTS
     * <P>
     * 不存在，从实体不存在，1表示不存在，0表示存在
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DER1NDEFMapType{
        SUM("SUM", "合计")
        ,AVG("AVG", "平均")
        ,MAX("MAX", "最大值")
        ,MIN("MIN", "最小值")
        ,COUNT("COUNT", "计数")
        ,EXISTS("EXISTS", "存在")
        ,NOTEXISTS("NOTEXISTS", "不存在")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DER1NDEFMapType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DER1NDEFMapType from(String value){
            switch(value){
                case "SUM":
                    return SUM;
                case "AVG":
                    return AVG;
                case "MAX":
                    return MAX;
                case "MIN":
                    return MIN;
                case "COUNT":
                    return COUNT;
                case "EXISTS":
                    return EXISTS;
                case "NOTEXISTS":
                    return NOTEXISTS;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统资源类型
     * <P>
     * <ul>
     * <li>IMAGE
     * <P>
     * 图片
     * <li>STRING
     * <P>
     * 字符串
     * <li>ZIPFILE
     * <P>
     * ZIP文件
     * <li>GITPROJECT
     * <P>
     * GIT项目
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * <li>USER5
     * <P>
     * 用户自定义5
     * <li>USER6
     * <P>
     * 用户自定义6
     * <li>USER7
     * <P>
     * 用户自定义7
     * <li>USER8
     * <P>
     * 用户自定义8
     * <li>USER9
     * <P>
     * 用户自定义9
     * </ul>     
     */
    public static enum ResourceType{
        IMAGE("IMAGE", "图片")
        ,STRING("STRING", "字符串")
        ,ZIPFILE("ZIPFILE", "ZIP文件")
        ,GITPROJECT("GITPROJECT", "GIT项目")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
        ,USER5("USER5", "用户自定义5")
        ,USER6("USER6", "用户自定义6")
        ,USER7("USER7", "用户自定义7")
        ,USER8("USER8", "用户自定义8")
        ,USER9("USER9", "用户自定义9")
;
           
        public final String text;
        public final String value;
        
        private ResourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ResourceType from(String value){
            switch(value){
                case "IMAGE":
                    return IMAGE;
                case "STRING":
                    return STRING;
                case "ZIPFILE":
                    return ZIPFILE;
                case "GITPROJECT":
                    return GITPROJECT;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                case "USER5":
                    return USER5;
                case "USER6":
                    return USER6;
                case "USER7":
                    return USER7;
                case "USER8":
                    return USER8;
                case "USER9":
                    return USER9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 分页视图分页栏位置
     * <P>
     * <ul>
     * <li>TOP
     * <P>
     * 上方（默认）
     * <li>TOP_EMBEDDED
     * <P>
     * 上方（嵌入）
     * <li>LEFT
     * <P>
     * 左侧
     * <li>BOTTOM
     * <P>
     * 下方
     * <li>RIGHT
     * <P>
     * 右侧
     * <li>FLOW
     * <P>
     * 流布局
     * <li>FLOW_NOHEADER
     * <P>
     * 流布局（无标题）
     * <li>NOHAEDER
     * <P>
     * 无分页栏
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum TabPanelLayout{
        TOP("TOP", "上方（默认）")
        ,TOP_EMBEDDED("TOP_EMBEDDED", "上方（嵌入）")
        ,LEFT("LEFT", "左侧")
        ,BOTTOM("BOTTOM", "下方")
        ,RIGHT("RIGHT", "右侧")
        ,FLOW("FLOW", "流布局")
        ,FLOW_NOHEADER("FLOW_NOHEADER", "流布局（无标题）")
        ,NOHAEDER("NOHAEDER", "无分页栏")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private TabPanelLayout(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TabPanelLayout from(String value){
            switch(value){
                case "TOP":
                    return TOP;
                case "TOP_EMBEDDED":
                    return TOP_EMBEDDED;
                case "LEFT":
                    return LEFT;
                case "BOTTOM":
                    return BOTTOM;
                case "RIGHT":
                    return RIGHT;
                case "FLOW":
                    return FLOW;
                case "FLOW_NOHEADER":
                    return FLOW_NOHEADER;
                case "NOHAEDER":
                    return NOHAEDER;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体服务接口属性组联合模式
     * <P>
     * <ul>
     * <li>REPLACE
     * <P>
     * 替换实体属性，直接使用属性组定义的属性集合
     * <li>OVERWRITE
     * <P>
     * 重定义实体属性，使用实体属性集合，属性组定义的属性将逐个替换默认实体属性
     * <li>EXCLUDE
     * <P>
     * 排除属性组属性，使用实体属性集合，排除属性组定义的属性
     * </ul>     
     */
    public static enum SADEDEFGroupMode{
        REPLACE("REPLACE", "替换实体属性")
        ,OVERWRITE("OVERWRITE", "重定义实体属性")
        ,EXCLUDE("EXCLUDE", "排除属性组属性")
;
           
        public final String text;
        public final String value;
        
        private SADEDEFGroupMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEDEFGroupMode from(String value){
            switch(value){
                case "REPLACE":
                    return REPLACE;
                case "OVERWRITE":
                    return OVERWRITE;
                case "EXCLUDE":
                    return EXCLUDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 文本绘制模式
     * <P>
     * <ul>
     * <li>TEXT
     * <P>
     * 文本
     * <li>HEADING1
     * <P>
     * 标题1
     * <li>HEADING2
     * <P>
     * 标题2
     * <li>HEADING3
     * <P>
     * 标题3
     * <li>HEADING4
     * <P>
     * 标题4
     * <li>HEADING5
     * <P>
     * 标题5
     * <li>HEADING6
     * <P>
     * 标题6
     * <li>PARAGRAPH
     * <P>
     * 段落
     * </ul>     
     */
    public static enum TextRenderMode{
        TEXT("TEXT", "文本")
        ,HEADING1("HEADING1", "标题1")
        ,HEADING2("HEADING2", "标题2")
        ,HEADING3("HEADING3", "标题3")
        ,HEADING4("HEADING4", "标题4")
        ,HEADING5("HEADING5", "标题5")
        ,HEADING6("HEADING6", "标题6")
        ,PARAGRAPH("PARAGRAPH", "段落")
;
           
        public final String text;
        public final String value;
        
        private TextRenderMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TextRenderMode from(String value){
            switch(value){
                case "TEXT":
                    return TEXT;
                case "HEADING1":
                    return HEADING1;
                case "HEADING2":
                    return HEADING2;
                case "HEADING3":
                    return HEADING3;
                case "HEADING4":
                    return HEADING4;
                case "HEADING5":
                    return HEADING5;
                case "HEADING6":
                    return HEADING6;
                case "PARAGRAPH":
                    return PARAGRAPH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法DTO类型
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 实体默认，从实体属性（全部或指定属性组）中构建方法DTO对象
     * <li>DEACTIONINPUT
     * <P>
     * 实体行为自定义参数，从实体行为自定义参数中构建方法DTO对象
     * <li>DEFILTER
     * <P>
     * 实体过滤器，从实体属性搜索模式中构建方法DTO对象
     * <li>DEDATASETINPUT
     * <P>
     * 实体数据集自定义参数，从实体数据集自定义参数中构建方法DTO对象
     * </ul>     
     */
    public static enum DEMethodDTOType{
        DEFAULT("DEFAULT", "实体默认")
        ,DEACTIONINPUT("DEACTIONINPUT", "实体行为自定义参数")
        ,DEFILTER("DEFILTER", "实体过滤器")
        ,DEDATASETINPUT("DEDATASETINPUT", "实体数据集自定义参数")
;
           
        public final String text;
        public final String value;
        
        private DEMethodDTOType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodDTOType from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "DEACTIONINPUT":
                    return DEACTIONINPUT;
                case "DEFILTER":
                    return DEFILTER;
                case "DEDATASETINPUT":
                    return DEDATASETINPUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树表格模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无，不启用树表格
     * <li>TREEGRID&nbsp;(1)
     * <P>
     * 常规树表格，常规树表格展现，需在树视图定义其它表格列，每种树节点也需要为每个表格列定义供数（树节点表格列）
     * <li>GANTT&nbsp;(2)
     * <P>
     * 甘特图树表格，甘特图树表格展现，在常规树表格的基础上，约定开始时间、结束时间、任务编号、前置编号等任务相关数据项
     * </ul>     
     */
    public static enum TreeGridMode{
        NONE(0, "无")
        ,TREEGRID(1, "常规树表格")
        ,GANTT(2, "甘特图树表格")
;
           
        public final String text;
        public final int value;
        
        private TreeGridMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeGridMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return TREEGRID;
                case 2:
                    return GANTT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 故事板项目类型
     * <P>
     * <ul>
     * <li>APPVIEW
     * <P>
     * 应用视图，项目指向应用视图
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum AppStoryBoardItemType{
        APPVIEW("APPVIEW", "应用视图")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private AppStoryBoardItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppStoryBoardItemType from(String value){
            switch(value){
                case "APPVIEW":
                    return APPVIEW;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用实体关系模式，数值项
     * <P>
     * <ul>
     * <li>ITEM_1&nbsp;(1)
     * <P>
     * 应用自建
     * <li>ITEM_2&nbsp;(2)
     * <P>
     * 实体服务接口关系
     * </ul>     
     */
    public static enum AppDERSMode{
        ITEM_1(1, "应用自建")
        ,ITEM_2(2, "实体服务接口关系")
;
           
        public final String text;
        public final int value;
        
        private AppDERSMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppDERSMode from(int value){
            switch(value){
                case 1:
                    return ITEM_1;
                case 2:
                    return ITEM_2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 开发方案画布类型
     * <P>
     * <ul>
     * <li>PSSYSCANVAS
     * <P>
     * 系统画布
     * <li>PSSYSERMAP
     * <P>
     * 系统ER图
     * <li>PSWORKFLOW
     * <P>
     * 系统流程图
     * </ul>     
     */
    public static enum DevSlnCanvasType{
        PSSYSCANVAS("PSSYSCANVAS", "系统画布")
        ,PSSYSERMAP("PSSYSERMAP", "系统ER图")
        ,PSWORKFLOW("PSWORKFLOW", "系统流程图")
;
           
        public final String text;
        public final String value;
        
        private DevSlnCanvasType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DevSlnCanvasType from(String value){
            switch(value){
                case "PSSYSCANVAS":
                    return PSSYSCANVAS;
                case "PSSYSERMAP":
                    return PSSYSERMAP;
                case "PSWORKFLOW":
                    return PSWORKFLOW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体映射目标类型
     * <P>
     * <ul>
     * <li>SYSCUR
     * <P>
     * 当前系统实体，映射到当前系统实体
     * </ul>     
     */
    public static enum DEMapTargetType{
        SYSCUR("SYSCUR", "当前系统实体")
;
           
        public final String text;
        public final String value;
        
        private DEMapTargetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMapTargetType from(String value){
            switch(value){
                case "SYSCUR":
                    return SYSCUR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 目标值规则类型
     * <P>
     * <ul>
     * <li>DEFVALUERULE
     * <P>
     * 实体值规则，指定来自当前实体的属性值规则对象
     * <li>SYSVALUERULE
     * <P>
     * 系统值规则，指定系统定义的值规则对象
     * </ul>     
     */
    public static enum TargetVRType{
        DEFVALUERULE("DEFVALUERULE", "实体值规则")
        ,SYSVALUERULE("SYSVALUERULE", "系统值规则")
;
           
        public final String text;
        public final String value;
        
        private TargetVRType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TargetVRType from(String value){
            switch(value){
                case "DEFVALUERULE":
                    return DEFVALUERULE;
                case "SYSVALUERULE":
                    return SYSVALUERULE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图片来源
     * <P>
     * <ul>
     * <li>FONTAWESOME
     * <P>
     * Font Awesome
     * <li>OTHER
     * <P>
     * 其它
     * </ul>     
     */
    public static enum ImageSource{
        FONTAWESOME("FONTAWESOME", "Font Awesome")
        ,OTHER("OTHER", "其它")
;
           
        public final String text;
        public final String value;
        
        private ImageSource(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ImageSource from(String value){
            switch(value){
                case "FONTAWESOME":
                    return FONTAWESOME;
                case "OTHER":
                    return OTHER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性主键模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 否
     * <li>PKEY&nbsp;(1)
     * <P>
     * 主键，数据的主键
     * <li>UNITAG&nbsp;(2)
     * <P>
     * 唯一识别标记，实体支持由多个属性的值哈希得出数据的识别标记，如果主键为文本类型，数据识别标记将作为主键进行存储，如果主键为数值，则需要额外指定一个属性来存储这个识别标记
     * </ul>     
     */
    public static enum FieldPKeyMode{
        NONE(0, "否")
        ,PKEY(1, "主键")
        ,UNITAG(2, "唯一识别标记")
;
           
        public final String text;
        public final int value;
        
        private FieldPKeyMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FieldPKeyMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return PKEY;
                case 2:
                    return UNITAG;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用无权限内容显示模式，数值项
     * <P>
     * <ul>
     * <li>EMPTY&nbsp;(1)
     * <P>
     * 显示空或*内容
     * <li>HIDE&nbsp;(2)
     * <P>
     * 隐藏
     * </ul>     
     */
    public static enum NoPrivDisplayMode{
        EMPTY(1, "显示空或*内容")
        ,HIDE(2, "隐藏")
;
           
        public final String text;
        public final int value;
        
        private NoPrivDisplayMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static NoPrivDisplayMode from(int value){
            switch(value){
                case 1:
                    return EMPTY;
                case 2:
                    return HIDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 模型导出模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>OPINFO&nbsp;(1)
     * <P>
     * 导出操作信息
     * </ul>     
     */
    public static enum ModelV2ExpMode{
        OPINFO(1, "导出操作信息")
;
           
        public final String text;
        public final int value;
        
        private ModelV2ExpMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelV2ExpMode from(int value){
            switch(value){
                case 1:
                    return OPINFO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 自定义代码模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 未启用
     * <li>RAWSCRIPT&nbsp;(1)
     * <P>
     * 直接脚本代码
     * <li>MODELRTSCRIPT&nbsp;(2)
     * <P>
     * 模型运行时对象脚本
     * </ul>     
     */
    public static enum ScriptMode{
        DISABLED(0, "未启用")
        ,RAWSCRIPT(1, "直接脚本代码")
        ,MODELRTSCRIPT(2, "模型运行时对象脚本")
;
           
        public final String text;
        public final int value;
        
        private ScriptMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ScriptMode from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return RAWSCRIPT;
                case 2:
                    return MODELRTSCRIPT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体模式删除标志，数值项
     * <P>
     * <ul>
     * <li>REJECT&nbsp;(0)
     * <P>
     * 限制删除
     * <li>ALLOW&nbsp;(1)
     * <P>
     * 允许删除（删除自身相关数据）
     * </ul>     
     */
    public static enum ModelRemoveMode{
        REJECT(0, "限制删除")
        ,ALLOW(1, "允许删除（删除自身相关数据）")
;
           
        public final String text;
        public final int value;
        
        private ModelRemoveMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelRemoveMode from(int value){
            switch(value){
                case 0:
                    return REJECT;
                case 1:
                    return ALLOW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台数据同步代理方向
     * <P>
     * <ul>
     * <li>IN
     * <P>
     * 输入，从外部系统获取数据
     * <li>OUT
     * <P>
     * 输出，向外部系统发送数据
     * <li>INOUT
     * <P>
     * 输入输出
     * </ul>     
     */
    public static enum DataSyncAgentDir{
        IN("IN", "输入")
        ,OUT("OUT", "输出")
        ,INOUT("INOUT", "输入输出")
;
           
        public final String text;
        public final String value;
        
        private DataSyncAgentDir(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSyncAgentDir from(String value){
            switch(value){
                case "IN":
                    return IN;
                case "OUT":
                    return OUT;
                case "INOUT":
                    return INOUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流数据库消费节点类型
     * <P>
     * <ul>
     * <li>DBTABLE
     * <P>
     * 数据表
     * <li>DEFGROUP
     * <P>
     * 实体属性组
     * </ul>     
     */
    public static enum DEDataFlowSysDBSchemeSinkType{
        DBTABLE("DBTABLE", "数据表")
        ,DEFGROUP("DEFGROUP", "实体属性组")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysDBSchemeSinkType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysDBSchemeSinkType from(String value){
            switch(value){
                case "DBTABLE":
                    return DBTABLE;
                case "DEFGROUP":
                    return DEFGROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统代码片段（模板类型）
     * <P>
     * <ul>
     * <li>PF
     * <P>
     * 前端应用模板
     * <li>SF
     * <P>
     * 后台服务模板
     * </ul>     
     */
    public static enum SnippetTemplType{
        PF("PF", "前端应用模板")
        ,SF("SF", "后台服务模板")
;
           
        public final String text;
        public final String value;
        
        private SnippetTemplType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SnippetTemplType from(String value){
            switch(value){
                case "PF":
                    return PF;
                case "SF":
                    return SF;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表格链接模式（应用设置），数值项
     * <P>
     * <ul>
     * <li>DISABLE&nbsp;(0)
     * <P>
     * 不启用
     * <li>AUTO&nbsp;(2)
     * <P>
     * 启用（自动判断），如果表格列存在链接视图则启用，否则不启用
     * </ul>     
     */
    public static enum AppGridColLinkMode{
        DISABLE(0, "不启用")
        ,AUTO(2, "启用（自动判断）")
;
           
        public final String text;
        public final int value;
        
        private AppGridColLinkMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppGridColLinkMode from(int value){
            switch(value){
                case 0:
                    return DISABLE;
                case 2:
                    return AUTO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台部件类型（面板项支持）
     * <P>
     * <ul>
     * <li>TOOLBAR
     * <P>
     * 工具栏
     * <li>GRID
     * <P>
     * 数据表格
     * <li>FORM
     * <P>
     * 编辑表单
     * <li>SEARCHFORM
     * <P>
     * 搜索表单
     * <li>DATAVIEW
     * <P>
     * 数据视图
     * <li>TREEVIEW
     * <P>
     * 树视图
     * <li>CHART
     * <P>
     * 数据图表
     * <li>LIST
     * <P>
     * 列表
     * <li>MOBMDCTRL
     * <P>
     * 移动端多数据视图
     * <li>DASHBOARD
     * <P>
     * 数据看板
     * <li>CALENDAR
     * <P>
     * 日历部件
     * <li>MAP
     * <P>
     * 地图部件
     * <li>GANTT
     * <P>
     * 甘特部件
     * <li>VIEWPANEL
     * <P>
     * 视图面板
     * </ul>     
     */
    public static enum PanelCtrlType{
        TOOLBAR("TOOLBAR", "工具栏")
        ,GRID("GRID", "数据表格")
        ,FORM("FORM", "编辑表单")
        ,SEARCHFORM("SEARCHFORM", "搜索表单")
        ,DATAVIEW("DATAVIEW", "数据视图")
        ,TREEVIEW("TREEVIEW", "树视图")
        ,CHART("CHART", "数据图表")
        ,LIST("LIST", "列表")
        ,MOBMDCTRL("MOBMDCTRL", "移动端多数据视图")
        ,DASHBOARD("DASHBOARD", "数据看板")
        ,CALENDAR("CALENDAR", "日历部件")
        ,MAP("MAP", "地图部件")
        ,GANTT("GANTT", "甘特部件")
        ,VIEWPANEL("VIEWPANEL", "视图面板")
;
           
        public final String text;
        public final String value;
        
        private PanelCtrlType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelCtrlType from(String value){
            switch(value){
                case "TOOLBAR":
                    return TOOLBAR;
                case "GRID":
                    return GRID;
                case "FORM":
                    return FORM;
                case "SEARCHFORM":
                    return SEARCHFORM;
                case "DATAVIEW":
                    return DATAVIEW;
                case "TREEVIEW":
                    return TREEVIEW;
                case "CHART":
                    return CHART;
                case "LIST":
                    return LIST;
                case "MOBMDCTRL":
                    return MOBMDCTRL;
                case "DASHBOARD":
                    return DASHBOARD;
                case "CALENDAR":
                    return CALENDAR;
                case "MAP":
                    return MAP;
                case "GANTT":
                    return GANTT;
                case "VIEWPANEL":
                    return VIEWPANEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统后台体系发布内容类型
     * <P>
     * <ul>
     * <li>CODE
     * <P>
     * 运行代码，发布的内容为代码
     * <li>DOC
     * <P>
     * 文档，发布的内容为文档
     * </ul>     
     */
    public static enum SFPubContentType{
        CODE("CODE", "运行代码")
        ,DOC("DOC", "文档")
;
           
        public final String text;
        public final String value;
        
        private SFPubContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SFPubContentType from(String value){
            switch(value){
                case "CODE":
                    return CODE;
                case "DOC":
                    return DOC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用门户视图部件类型
     * <P>
     * <ul>
     * <li>SYSPORTLET
     * <P>
     * 系统门户部件，数据看板中的门户部件成员，挂载系统门户部件。不支持子成员
     * <li>APPMENU
     * <P>
     * 快捷菜单栏，数据看板中的视图成员，挂载应用视图。不支持子成员
     * <li>APPVIEW
     * <P>
     * 应用视图，数据看板中的应用菜单成员，挂载应用菜单部件。不支持子成员
     * <li>CONTAINER
     * <P>
     * 布局容器，数据看板中的基本布局面板，支持子成员
     * <li>RAWITEM
     * <P>
     * 直接内容，数据看板中的直接内容项，输出文本或图片。不支持子成员
     * </ul>     
     */
    public static enum AppDashboardPartType{
        SYSPORTLET("SYSPORTLET", "系统门户部件")
        ,APPMENU("APPMENU", "快捷菜单栏")
        ,APPVIEW("APPVIEW", "应用视图")
        ,CONTAINER("CONTAINER", "布局容器")
        ,RAWITEM("RAWITEM", "直接内容")
;
           
        public final String text;
        public final String value;
        
        private AppDashboardPartType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppDashboardPartType from(String value){
            switch(value){
                case "SYSPORTLET":
                    return SYSPORTLET;
                case "APPMENU":
                    return APPMENU;
                case "APPVIEW":
                    return APPVIEW;
                case "CONTAINER":
                    return CONTAINER;
                case "RAWITEM":
                    return RAWITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统后台任务作业预置类型
     * <P>
     * <ul>
     * <li>DENOTIFY
     * <P>
     * 实体通知
     * <li>SYSDATASYNCAGENT
     * <P>
     * 系统数据同步代理（输入）
     * <li>WFCALLBACK
     * <P>
     * 工作流回调
     * <li>SYSADMIN
     * <P>
     * 系统管理
     * <li>SYSDTSQUEUE
     * <P>
     * 系统异步处理队列（取消）
     * <li>USER
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum PredefinedBackendTaskType{
        DENOTIFY("DENOTIFY", "实体通知")
        ,SYSDATASYNCAGENT("SYSDATASYNCAGENT", "系统数据同步代理（输入）")
        ,WFCALLBACK("WFCALLBACK", "工作流回调")
        ,SYSADMIN("SYSADMIN", "系统管理")
        ,SYSDTSQUEUE("SYSDTSQUEUE", "系统异步处理队列（取消）")
        ,USER("USER", "自定义")
;
           
        public final String text;
        public final String value;
        
        private PredefinedBackendTaskType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PredefinedBackendTaskType from(String value){
            switch(value){
                case "DENOTIFY":
                    return DENOTIFY;
                case "SYSDATASYNCAGENT":
                    return SYSDATASYNCAGENT;
                case "WFCALLBACK":
                    return WFCALLBACK;
                case "SYSADMIN":
                    return SYSADMIN;
                case "SYSDTSQUEUE":
                    return SYSDTSQUEUE;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据库空值排序
     * <P>
     * <ul>
     * <li>FIRST
     * <P>
     * 最先，空值优先于非空值输出
     * <li>LAST
     * <P>
     * 最后，非空值优先于空值输出
     * </ul>     
     */
    public static enum DBNullValueOrderMode{
        FIRST("FIRST", "最先")
        ,LAST("LAST", "最后")
;
           
        public final String text;
        public final String value;
        
        private DBNullValueOrderMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBNullValueOrderMode from(String value){
            switch(value){
                case "FIRST":
                    return FIRST;
                case "LAST":
                    return LAST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性组逻辑模式
     * <P>
     * <ul>
     * <li>SORT
     * <P>
     * 属性值排序
     * <li>NOTSAME
     * <P>
     * 属性值差异
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEFGroupLogicMode{
        SORT("SORT", "属性值排序")
        ,NOTSAME("NOTSAME", "属性值差异")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEFGroupLogicMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFGroupLogicMode from(String value){
            switch(value){
                case "SORT":
                    return SORT;
                case "NOTSAME":
                    return NOTSAME;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件处理部门数据范围，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CURRENT&nbsp;(1)
     * <P>
     * 当前部门，当前用户的部门
     * <li>PARENT&nbsp;(2)
     * <P>
     * 上级部门，当前用户的部门的上级的部门（递归）
     * <li>SUBORDINATE&nbsp;(4)
     * <P>
     * 下级部门，当前用户的部门的下级的部门（递归）
     * <li>EMPTY&nbsp;(8)
     * <P>
     * 无部门值，数据中未指定部门归属值
     * </ul>     
     */
    public static enum DeptScope{
        CURRENT(1, "当前部门")
        ,PARENT(2, "上级部门")
        ,SUBORDINATE(4, "下级部门")
        ,EMPTY(8, "无部门值")
;
           
        public final String text;
        public final int value;
        
        private DeptScope(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DeptScope from(int value){
            switch(value){
                case 1:
                    return CURRENT;
                case 2:
                    return PARENT;
                case 4:
                    return SUBORDINATE;
                case 8:
                    return EMPTY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流连接类型
     * <P>
     * <ul>
     * <li>DATASTREAM
     * <P>
     * 数据流，数据流1
     * <li>DATASTREAM2
     * <P>
     * 数据流2，数据流2
     * </ul>     
     */
    public static enum DEDataFlowLinkType{
        DATASTREAM("DATASTREAM", "数据流")
        ,DATASTREAM2("DATASTREAM2", "数据流2")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowLinkType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowLinkType from(String value){
            switch(value){
                case "DATASTREAM":
                    return DATASTREAM;
                case "DATASTREAM2":
                    return DATASTREAM2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体组分类
     * <P>
     * <ul>
     * <li>CUSTOM
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum DEGroupCat{
        CUSTOM("CUSTOM", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private DEGroupCat(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEGroupCat from(String value){
            switch(value){
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格样式
     * <P>
     * <ul>
     * <li>TREEGRID
     * <P>
     * 树表格，显示为带层级的树表
     * <li>GROUPGRID
     * <P>
     * 分组表格，显示分组显示的表格
     * <li>LIST
     * <P>
     * 单列无头表格（列表）
     * <li>LIST_SORT
     * <P>
     * 单列无头表格（列表），支持排序
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum GridStyle{
        TREEGRID("TREEGRID", "树表格")
        ,GROUPGRID("GROUPGRID", "分组表格")
        ,LIST("LIST", "单列无头表格（列表）")
        ,LIST_SORT("LIST_SORT", "单列无头表格（列表），支持排序")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private GridStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridStyle from(String value){
            switch(value){
                case "TREEGRID":
                    return TREEGRID;
                case "GROUPGRID":
                    return GROUPGRID;
                case "LIST":
                    return LIST;
                case "LIST_SORT":
                    return LIST_SORT;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流预置数据源类型
     * <P>
     * <ul>
     * <li>SESSION
     * <P>
     * 用户全局对象
     * <li>DATACONTEXT
     * <P>
     * 数据上下文
     * <li>ENVPARAM
     * <P>
     * 当前环境参数
     * </ul>     
     */
    public static enum DEDataFlowPredefinedSourceType{
        SESSION("SESSION", "用户全局对象")
        ,DATACONTEXT("DATACONTEXT", "数据上下文")
        ,ENVPARAM("ENVPARAM", "当前环境参数")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowPredefinedSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowPredefinedSourceType from(String value){
            switch(value){
                case "SESSION":
                    return SESSION;
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "ENVPARAM":
                    return ENVPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 卡片视图布局项类型
     * <P>
     * <ul>
     * <li>PANEL
     * <P>
     * 面板
     * <li>FORM
     * <P>
     * 表单
     * </ul>     
     */
    public static enum DataViewLayoutItemType{
        PANEL("PANEL", "面板")
        ,FORM("FORM", "表单")
;
           
        public final String text;
        public final String value;
        
        private DataViewLayoutItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataViewLayoutItemType from(String value){
            switch(value){
                case "PANEL":
                    return PANEL;
                case "FORM":
                    return FORM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体通知目标类型
     * <P>
     * <ul>
     * <li>DEFIELD
     * <P>
     * 当前实体属性
     * <li>SYSMSGTARGET
     * <P>
     * 系统消息目标
     * <li>EVENTDATAFIELD
     * <P>
     * 事件数据属性（运行时支持）
     * <li>DSTUSER
     * <P>
     * 目标用户（运行时支持）
     * <li>DSTDEPARTMENT
     * <P>
     * 目标部门（运行时支持）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DENotifyTargetType{
        DEFIELD("DEFIELD", "当前实体属性")
        ,SYSMSGTARGET("SYSMSGTARGET", "系统消息目标")
        ,EVENTDATAFIELD("EVENTDATAFIELD", "事件数据属性（运行时支持）")
        ,DSTUSER("DSTUSER", "目标用户（运行时支持）")
        ,DSTDEPARTMENT("DSTDEPARTMENT", "目标部门（运行时支持）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private DENotifyTargetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DENotifyTargetType from(String value){
            switch(value){
                case "DEFIELD":
                    return DEFIELD;
                case "SYSMSGTARGET":
                    return SYSMSGTARGET;
                case "EVENTDATAFIELD":
                    return EVENTDATAFIELD;
                case "DSTUSER":
                    return DSTUSER;
                case "DSTDEPARTMENT":
                    return DSTDEPARTMENT;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 继承关系处理模式，数值项
     * <P>
     * <ul>
     * <li>STORAGE&nbsp;(1)
     * <P>
     * 存储继承，仅对主实体的存储结构进行继承，处理逻辑由扩展实体自持
     * <li>LOGIC&nbsp;(2)
     * <P>
     * 逻辑继承、存储附加，对主实体的处理逻辑进行继承，如存在扩展的数据结构，则在调用主实体逻辑后再进行附加处理
     * </ul>     
     */
    public static enum DERInheritMode{
        STORAGE(1, "存储继承")
        ,LOGIC(2, "逻辑继承、存储附加")
;
           
        public final String text;
        public final int value;
        
        private DERInheritMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERInheritMode from(int value){
            switch(value){
                case 1:
                    return STORAGE;
                case 2:
                    return LOGIC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体树节点编辑模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>TEXT&nbsp;(1)
     * <P>
     * 名称
     * <li>DRAG&nbsp;(2)
     * <P>
     * 拖动
     * <li>DROP&nbsp;(4)
     * <P>
     * 拖入
     * <li>ORDER&nbsp;(8)
     * <P>
     * 排序
     * <li>ROWEDIT&nbsp;(16)
     * <P>
     * 行编辑
     * <li>ROWEDITCHANGEDONLY&nbsp;(2064)
     * <P>
     * 行编辑（仅提交变化值）
     * </ul>     
     */
    public static enum TreeNodeEditMode{
        TEXT(1, "名称")
        ,DRAG(2, "拖动")
        ,DROP(4, "拖入")
        ,ORDER(8, "排序")
        ,ROWEDIT(16, "行编辑")
        ,ROWEDITCHANGEDONLY(2064, "行编辑（仅提交变化值）")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeEditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeEditMode from(int value){
            switch(value){
                case 1:
                    return TEXT;
                case 2:
                    return DRAG;
                case 4:
                    return DROP;
                case 8:
                    return ORDER;
                case 16:
                    return ROWEDIT;
                case 2064:
                    return ROWEDITCHANGEDONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流属性范围
     * <P>
     * <ul>
     * <li>DATASTREAM
     * <P>
     * 数据源属性，指定数据源属性
     * <li>DATASTREAM2
     * <P>
     * 数据源2属性，指定数据源2属性
     * </ul>     
     */
    public static enum DEDataFlowFieldScope{
        DATASTREAM("DATASTREAM", "数据源属性")
        ,DATASTREAM2("DATASTREAM2", "数据源2属性")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowFieldScope(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowFieldScope from(String value){
            switch(value){
                case "DATASTREAM":
                    return DATASTREAM;
                case "DATASTREAM2":
                    return DATASTREAM2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 移动端打包类型
     * <P>
     * <ul>
     * <li>TEST
     * <P>
     * 测试版本
     * <li>OFFICIAL
     * <P>
     * 正式版
     * </ul>     
     */
    public static enum MobAppPackType{
        TEST("TEST", "测试版本")
        ,OFFICIAL("OFFICIAL", "正式版")
;
           
        public final String text;
        public final String value;
        
        private MobAppPackType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobAppPackType from(String value){
            switch(value){
                case "TEST":
                    return TEST;
                case "OFFICIAL":
                    return OFFICIAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 服务接口实体方法类型
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>SELECT
     * <P>
     * 实体数据查询（简单）
     * <li>FETCH
     * <P>
     * 获取数据集
     * <li>OTHER
     * <P>
     * 其它
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SADEMethodType{
        DEACTION("DEACTION", "实体行为")
        ,SELECT("SELECT", "实体数据查询（简单）")
        ,FETCH("FETCH", "获取数据集")
        ,OTHER("OTHER", "其它")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SADEMethodType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEMethodType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "SELECT":
                    return SELECT;
                case "FETCH":
                    return FETCH;
                case "OTHER":
                    return OTHER;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树节点字段排序方向
     * <P>
     * <ul>
     * <li>ASC
     * <P>
     * 升序
     * <li>DESC
     * <P>
     * 降序
     * </ul>     
     */
    public static enum TreeNodeSortDir{
        ASC("ASC", "升序")
        ,DESC("DESC", "降序")
;
           
        public final String text;
        public final String value;
        
        private TreeNodeSortDir(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeSortDir from(String value){
            switch(value){
                case "ASC":
                    return ASC;
                case "DESC":
                    return DESC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统标题栏样式
     * <P>
     * <ul>
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum TitleBarStyle{
        USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private TitleBarStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TitleBarStyle from(String value){
            switch(value){
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体树表格列类型
     * <P>
     * <ul>
     * <li>DEFGRIDCOLUMN
     * <P>
     * 属性列，绑定属性数据的列
     * <li>UAGRIDCOLUMN
     * <P>
     * 操作列，为行数据提供操作能力的列
     * </ul>     
     */
    public static enum TreeColType{
        DEFGRIDCOLUMN("DEFGRIDCOLUMN", "属性列")
        ,UAGRIDCOLUMN("UAGRIDCOLUMN", "操作列")
;
           
        public final String text;
        public final String value;
        
        private TreeColType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeColType from(String value){
            switch(value){
                case "DEFGRIDCOLUMN":
                    return DEFGRIDCOLUMN;
                case "UAGRIDCOLUMN":
                    return UAGRIDCOLUMN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表单表单项值处理条件（忽略），数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无，不忽略，任何情况都对值进行处理
     * <li>CREATE&nbsp;(1)
     * <P>
     * 建立，数据建立时忽略
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新，数据更新时忽略
     * <li>ALL&nbsp;(3)
     * <P>
     * 建立及更新，数据建立及更新时都忽略
     * <li>UPDATE_AND_SETORIGIN&nbsp;(18)
     * <P>
     * 更新（设置回原值），数据更新时忽略，并且将设置回原值
     * <li>ALL_AND_SETORIGIN&nbsp;(19)
     * <P>
     * 建立及更新（设置回原值），数据建立及更新时都忽略，并且将设置回原值
     * <li>DISABLE&nbsp;(4)
     * <P>
     * 表单项禁用，表单项处于禁用状态时忽略
     * <li>DISABLE_AND_NOTSETOUTPUT&nbsp;(12)
     * <P>
     * 表单项禁用（同时不输出到前端），表单项处于禁用状态时忽略，并且不填充表单项
     * </ul>     
     */
    public static enum EditItemIgnoreMode{
        NONE(0, "无")
        ,CREATE(1, "建立")
        ,UPDATE(2, "更新")
        ,ALL(3, "建立及更新")
        ,UPDATE_AND_SETORIGIN(18, "更新（设置回原值）")
        ,ALL_AND_SETORIGIN(19, "建立及更新（设置回原值）")
        ,DISABLE(4, "表单项禁用")
        ,DISABLE_AND_NOTSETOUTPUT(12, "表单项禁用（同时不输出到前端）")
;
           
        public final String text;
        public final int value;
        
        private EditItemIgnoreMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditItemIgnoreMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 3:
                    return ALL;
                case 18:
                    return UPDATE_AND_SETORIGIN;
                case 19:
                    return ALL_AND_SETORIGIN;
                case 4:
                    return DISABLE;
                case 12:
                    return DISABLE_AND_NOTSETOUTPUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性预定义属性类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * （非预置属性），指定当前属性非预置属性，与预定义类型标识同名的属性引擎会默认将该属性设置此预定义类型，设置为【非预置属性】将关闭这个特性
     * <li>LOGICVALID
     * <P>
     * 逻辑有效标识，数据逻辑有效标识的存储属性，仅在实体启用逻辑删除时使用
     * <li>ORDERVALUE
     * <P>
     * 排序值，指定属性存储数据的排序值
     * <li>VERSION
     * <P>
     * 数据版本，指定属性存储数据的版本
     * <li>VERSIONID
     * <P>
     * 数据版本标识，指定属性存储数据的版本标识
     * <li>CREATEMAN
     * <P>
     * 建立人标识，指定属性存储数据的建立人标识
     * <li>CREATEMANNAME
     * <P>
     * 建立人名称，指定属性存储数据的建立人名称
     * <li>CREATEDATE
     * <P>
     * 建立时间，指定属性存储数据的建立时间
     * <li>UPDATEMAN
     * <P>
     * 更新人标识，指定属性存储数据的更新人标识
     * <li>UPDATEMANNAME
     * <P>
     * 更新人名称，指定属性存储数据的更新人名称
     * <li>UPDATEDATE
     * <P>
     * 更新时间，指定属性存储数据的更新时间
     * <li>ORGID
     * <P>
     * 组织机构标识，指定属性存储数据的所在组织标识
     * <li>ORGNAME
     * <P>
     * 组织机构名称，指定属性存储数据的所在组织名称
     * <li>ORGSECTORID
     * <P>
     * 部门标识，指定属性存储数据的所在部门标识
     * <li>ORGSECTORNAME
     * <P>
     * 部门名称，指定属性存储数据的所在部门名称
     * <li>PARENTTYPE
     * <P>
     * 动态父类型
     * <li>PARENTSUBTYPE
     * <P>
     * 动态父子类型
     * <li>PARENTID
     * <P>
     * 动态父标识
     * <li>PARENTNAME
     * <P>
     * 动态父名称
     * <li>PARENTDATA
     * <P>
     * 动态父数据
     * <li>PARENTVERSION
     * <P>
     * 动态父版本
     * <li>PARENTVERSIONID
     * <P>
     * 动态父版本版本
     * <li>PARENTIDPATH
     * <P>
     * 父标识路径
     * <li>PARENTNAMEPATH
     * <P>
     * 父名称路径
     * <li>TIMESTAMP
     * <P>
     * 时间戳
     * <li>DYNASTORAGE
     * <P>
     * 动态存储，指定属性是当前实体动态扩展属性的存储属性
     * <li>CLOSEFLAG
     * <P>
     * 关闭标志，指定属性是当前实体数据关闭标志的存储属性
     * </ul>     
     */
    public static enum PredefinedFieldType{
        NONE("NONE", "（非预置属性）")
        ,LOGICVALID("LOGICVALID", "逻辑有效标识")
        ,ORDERVALUE("ORDERVALUE", "排序值")
        ,VERSION("VERSION", "数据版本")
        ,VERSIONID("VERSIONID", "数据版本标识")
        ,CREATEMAN("CREATEMAN", "建立人标识")
        ,CREATEMANNAME("CREATEMANNAME", "建立人名称")
        ,CREATEDATE("CREATEDATE", "建立时间")
        ,UPDATEMAN("UPDATEMAN", "更新人标识")
        ,UPDATEMANNAME("UPDATEMANNAME", "更新人名称")
        ,UPDATEDATE("UPDATEDATE", "更新时间")
        ,ORGID("ORGID", "组织机构标识")
        ,ORGNAME("ORGNAME", "组织机构名称")
        ,ORGSECTORID("ORGSECTORID", "部门标识")
        ,ORGSECTORNAME("ORGSECTORNAME", "部门名称")
        ,PARENTTYPE("PARENTTYPE", "动态父类型")
        ,PARENTSUBTYPE("PARENTSUBTYPE", "动态父子类型")
        ,PARENTID("PARENTID", "动态父标识")
        ,PARENTNAME("PARENTNAME", "动态父名称")
        ,PARENTDATA("PARENTDATA", "动态父数据")
        //,PARENTVERSION("PARENTVERSION", "动态父版本")
        ,PARENTVERSIONID("PARENTVERSIONID", "动态父版本版本")
        ,PARENTIDPATH("PARENTIDPATH", "父标识路径")
        ,PARENTNAMEPATH("PARENTNAMEPATH", "父名称路径")
        ,TIMESTAMP("TIMESTAMP", "时间戳")
        ,DYNASTORAGE("DYNASTORAGE", "动态存储")
        ,CLOSEFLAG("CLOSEFLAG", "关闭标志")
;
           
        public final String text;
        public final String value;
        
        private PredefinedFieldType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PredefinedFieldType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "LOGICVALID":
                    return LOGICVALID;
                case "ORDERVALUE":
                    return ORDERVALUE;
                case "VERSION":
                    return VERSION;
                case "VERSIONID":
                    return VERSIONID;
                case "CREATEMAN":
                    return CREATEMAN;
                case "CREATEMANNAME":
                    return CREATEMANNAME;
                case "CREATEDATE":
                    return CREATEDATE;
                case "UPDATEMAN":
                    return UPDATEMAN;
                case "UPDATEMANNAME":
                    return UPDATEMANNAME;
                case "UPDATEDATE":
                    return UPDATEDATE;
                case "ORGID":
                    return ORGID;
                case "ORGNAME":
                    return ORGNAME;
                case "ORGSECTORID":
                    return ORGSECTORID;
                case "ORGSECTORNAME":
                    return ORGSECTORNAME;
                case "PARENTTYPE":
                    return PARENTTYPE;
                case "PARENTSUBTYPE":
                    return PARENTSUBTYPE;
                case "PARENTID":
                    return PARENTID;
                case "PARENTNAME":
                    return PARENTNAME;
                case "PARENTDATA":
                    return PARENTDATA;
//                case "PARENTVERSION":
//                    return PARENTVERSION;
                case "PARENTVERSIONID":
                    return PARENTVERSIONID;
                case "PARENTIDPATH":
                    return PARENTIDPATH;
                case "PARENTNAMEPATH":
                    return PARENTNAMEPATH;
                case "TIMESTAMP":
                    return TIMESTAMP;
                case "DYNASTORAGE":
                    return DYNASTORAGE;
                case "CLOSEFLAG":
                    return CLOSEFLAG;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工具栏项显示模式
     * <P>
     * <ul>
     * <li>ICONANDSHORTWORD
     * <P>
     * 图标+短词，同时显示图标及标题
     * <li>ICON
     * <P>
     * 图标，仅显示图标
     * <li>SHORTWORD
     * <P>
     * 短词，仅显示标题
     * </ul>     
     */
    public static enum TBItemShowMode{
        ICONANDSHORTWORD("ICONANDSHORTWORD", "图标+短词")
        ,ICON("ICON", "图标")
        ,SHORTWORD("SHORTWORD", "短词")
;
           
        public final String text;
        public final String value;
        
        private TBItemShowMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TBItemShowMode from(String value){
            switch(value){
                case "ICONANDSHORTWORD":
                    return ICONANDSHORTWORD;
                case "ICON":
                    return ICON;
                case "SHORTWORD":
                    return SHORTWORD;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统开发后台任务类型
     * <P>
     * <ul>
     * <li>DEPLOYSYS
     * <P>
     * 部署系统
     * <li>PACKSFCODE
     * <P>
     * 打包服务代码
     * <li>PACKPFCODE
     * <P>
     * 打包应用代码
     * <li>PUBSFCODE
     * <P>
     * 发布服务代码
     * <li>PUBPFCODE
     * <P>
     * 发布应用代码
     * <li>STARTUPAS
     * <P>
     * 启动应用服务器
     * <li>SYNCDBMODEL
     * <P>
     * 同步数据结构
     * <li>SHUTDOWNAS
     * <P>
     * 关闭应用服务器
     * <li>STARTUPEX
     * <P>
     * 一键系统启动
     * <li>SYNCSUBSYSDBMODEL
     * <P>
     * 同步子系统数据结构
     * <li>SYNCSUBSYSMODEL
     * <P>
     * 同步子系统模型
     * <li>INITSYSMODEL
     * <P>
     * 初始化系统模型
     * <li>INITSYSDEDBCFG
     * <P>
     * 初始化系统实体数据库配置
     * <li>RESETSFCODE
     * <P>
     * 重置服务代码（前）
     * <li>RESETPFCODE
     * <P>
     * 重置应用代码
     * <li>IMPSUBSYSMODEL
     * <P>
     * 导入子系统模型
     * <li>INITAPPMODEL
     * <P>
     * 初始化应用模型
     * <li>CHECKSYSMODEL
     * <P>
     * 检查系统模型
     * <li>CHECKSYSAPPMODEL
     * <P>
     * 检查系统应用模型
     * <li>RESETSFCODE2
     * <P>
     * 重置服务代码（后）
     * <li>STARTUPEX2
     * <P>
     * 一键代码发布
     * <li>STARTUPEX3
     * <P>
     * 一键版本打包
     * <li>PACKSYSVER
     * <P>
     * 打包系统版本
     * <li>PUBSYSDBMODEL
     * <P>
     * 重新发布系统数据库结构
     * <li>DIFFSYSMODEL
     * <P>
     * 对比系统模型差异
     * <li>CREATESYS
     * <P>
     * 建立系统
     * <li>INSTALLRTDATA
     * <P>
     * 安装系统运行数据
     * <li>STARTUPEX4
     * <P>
     * 一键移动应用打包
     * <li>PACKANDROIDAPP
     * <P>
     * 打包Android应用
     * <li>PACKIOSAPP
     * <P>
     * 打包iOS应用
     * <li>REMOTEPACKSYS
     * <P>
     * 远程系统打包
     * <li>STARTUPEX5
     * <P>
     * 一键微服务接口部署
     * <li>STARTUPEX6
     * <P>
     * 一键微服务应用部署
     * <li>STARTUPEX7
     * <P>
     * 一键部署组件包
     * <li>DEPLOYPKG
     * <P>
     * 部署组件包到仓库
     * <li>CLONEDEMODEL
     * <P>
     * 克隆实体模型
     * <li>SYNCSERVICEAPICLIENTMODEL
     * <P>
     * 克隆服务接口客户端模型
     * <li>STARTUPEX8
     * <P>
     * 一键微服务功能部署
     * <li>BEGINPUBCODE
     * <P>
     * 准备发布代码
     * <li>ENDPUBCODE
     * <P>
     * 结束发布代码
     * <li>RESETPUBCODE
     * <P>
     * 重置发布代码
     * <li>PFPREVIEWACTION
     * <P>
     * 前端预览作业
     * <li>SFPREVIEWACTION
     * <P>
     * 后台预览作业
     * <li>CODEPREVIEWACTION
     * <P>
     * 代码预览作业
     * <li>SYNCSUBSYSSADEMODEL
     * <P>
     * 同步服务接口实体模型
     * <li>SYNCAPPSBMODEL
     * <P>
     * 同步应用故事板
     * <li>STARTUPEX9
     * <P>
     * 一键动态实例模型发布
     * <li>PUBDYNAINSTMODEL
     * <P>
     * 发布动态实例模型
     * <li>DYNAINSTPREVIEWACTION
     * <P>
     * 动态实例预览作业
     * <li>SYNCSYSDBSCHEMAMODEL
     * <P>
     * 同步系统数据库模型
     * <li>IMPORTJSONSCHEMAMODEL
     * <P>
     * 导入JsonSchema模型
     * <li>IBIZCENTRAL
     * <P>
     * iBizCentral（中台）
     * <li>IBIZMODELINGIA
     * <P>
     * iBizModelingIA（建模助手）
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum SysDevBKTaskType{
        DEPLOYSYS("DEPLOYSYS", "部署系统")
        ,PACKSFCODE("PACKSFCODE", "打包服务代码")
        ,PACKPFCODE("PACKPFCODE", "打包应用代码")
        ,PUBSFCODE("PUBSFCODE", "发布服务代码")
        ,PUBPFCODE("PUBPFCODE", "发布应用代码")
        ,STARTUPAS("STARTUPAS", "启动应用服务器")
        ,SYNCDBMODEL("SYNCDBMODEL", "同步数据结构")
        ,SHUTDOWNAS("SHUTDOWNAS", "关闭应用服务器")
        ,STARTUPEX("STARTUPEX", "一键系统启动")
        ,SYNCSUBSYSDBMODEL("SYNCSUBSYSDBMODEL", "同步子系统数据结构")
        ,SYNCSUBSYSMODEL("SYNCSUBSYSMODEL", "同步子系统模型")
        ,INITSYSMODEL("INITSYSMODEL", "初始化系统模型")
        ,INITSYSDEDBCFG("INITSYSDEDBCFG", "初始化系统实体数据库配置")
        ,RESETSFCODE("RESETSFCODE", "重置服务代码（前）")
        ,RESETPFCODE("RESETPFCODE", "重置应用代码")
        ,IMPSUBSYSMODEL("IMPSUBSYSMODEL", "导入子系统模型")
        ,INITAPPMODEL("INITAPPMODEL", "初始化应用模型")
        ,CHECKSYSMODEL("CHECKSYSMODEL", "检查系统模型")
        ,CHECKSYSAPPMODEL("CHECKSYSAPPMODEL", "检查系统应用模型")
        ,RESETSFCODE2("RESETSFCODE2", "重置服务代码（后）")
        ,STARTUPEX2("STARTUPEX2", "一键代码发布")
        ,STARTUPEX3("STARTUPEX3", "一键版本打包")
        ,PACKSYSVER("PACKSYSVER", "打包系统版本")
        ,PUBSYSDBMODEL("PUBSYSDBMODEL", "重新发布系统数据库结构")
        ,DIFFSYSMODEL("DIFFSYSMODEL", "对比系统模型差异")
        ,CREATESYS("CREATESYS", "建立系统")
        ,INSTALLRTDATA("INSTALLRTDATA", "安装系统运行数据")
        ,STARTUPEX4("STARTUPEX4", "一键移动应用打包")
        ,PACKANDROIDAPP("PACKANDROIDAPP", "打包Android应用")
        ,PACKIOSAPP("PACKIOSAPP", "打包iOS应用")
        ,REMOTEPACKSYS("REMOTEPACKSYS", "远程系统打包")
        ,STARTUPEX5("STARTUPEX5", "一键微服务接口部署")
        ,STARTUPEX6("STARTUPEX6", "一键微服务应用部署")
        ,STARTUPEX7("STARTUPEX7", "一键部署组件包")
        ,DEPLOYPKG("DEPLOYPKG", "部署组件包到仓库")
        ,CLONEDEMODEL("CLONEDEMODEL", "克隆实体模型")
        ,SYNCSERVICEAPICLIENTMODEL("SYNCSERVICEAPICLIENTMODEL", "克隆服务接口客户端模型")
        ,STARTUPEX8("STARTUPEX8", "一键微服务功能部署")
        ,BEGINPUBCODE("BEGINPUBCODE", "准备发布代码")
        ,ENDPUBCODE("ENDPUBCODE", "结束发布代码")
        ,RESETPUBCODE("RESETPUBCODE", "重置发布代码")
        ,PFPREVIEWACTION("PFPREVIEWACTION", "前端预览作业")
        ,SFPREVIEWACTION("SFPREVIEWACTION", "后台预览作业")
        ,CODEPREVIEWACTION("CODEPREVIEWACTION", "代码预览作业")
        ,SYNCSUBSYSSADEMODEL("SYNCSUBSYSSADEMODEL", "同步服务接口实体模型")
        ,SYNCAPPSBMODEL("SYNCAPPSBMODEL", "同步应用故事板")
        ,STARTUPEX9("STARTUPEX9", "一键动态实例模型发布")
        ,PUBDYNAINSTMODEL("PUBDYNAINSTMODEL", "发布动态实例模型")
        ,DYNAINSTPREVIEWACTION("DYNAINSTPREVIEWACTION", "动态实例预览作业")
        ,SYNCSYSDBSCHEMAMODEL("SYNCSYSDBSCHEMAMODEL", "同步系统数据库模型")
        ,IMPORTJSONSCHEMAMODEL("IMPORTJSONSCHEMAMODEL", "导入JsonSchema模型")
        ,IBIZCENTRAL("IBIZCENTRAL", "iBizCentral（中台）")
        ,IBIZMODELINGIA("IBIZMODELINGIA", "iBizModelingIA（建模助手）")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private SysDevBKTaskType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysDevBKTaskType from(String value){
            switch(value){
                case "DEPLOYSYS":
                    return DEPLOYSYS;
                case "PACKSFCODE":
                    return PACKSFCODE;
                case "PACKPFCODE":
                    return PACKPFCODE;
                case "PUBSFCODE":
                    return PUBSFCODE;
                case "PUBPFCODE":
                    return PUBPFCODE;
                case "STARTUPAS":
                    return STARTUPAS;
                case "SYNCDBMODEL":
                    return SYNCDBMODEL;
                case "SHUTDOWNAS":
                    return SHUTDOWNAS;
                case "STARTUPEX":
                    return STARTUPEX;
                case "SYNCSUBSYSDBMODEL":
                    return SYNCSUBSYSDBMODEL;
                case "SYNCSUBSYSMODEL":
                    return SYNCSUBSYSMODEL;
                case "INITSYSMODEL":
                    return INITSYSMODEL;
                case "INITSYSDEDBCFG":
                    return INITSYSDEDBCFG;
                case "RESETSFCODE":
                    return RESETSFCODE;
                case "RESETPFCODE":
                    return RESETPFCODE;
                case "IMPSUBSYSMODEL":
                    return IMPSUBSYSMODEL;
                case "INITAPPMODEL":
                    return INITAPPMODEL;
                case "CHECKSYSMODEL":
                    return CHECKSYSMODEL;
                case "CHECKSYSAPPMODEL":
                    return CHECKSYSAPPMODEL;
                case "RESETSFCODE2":
                    return RESETSFCODE2;
                case "STARTUPEX2":
                    return STARTUPEX2;
                case "STARTUPEX3":
                    return STARTUPEX3;
                case "PACKSYSVER":
                    return PACKSYSVER;
                case "PUBSYSDBMODEL":
                    return PUBSYSDBMODEL;
                case "DIFFSYSMODEL":
                    return DIFFSYSMODEL;
                case "CREATESYS":
                    return CREATESYS;
                case "INSTALLRTDATA":
                    return INSTALLRTDATA;
                case "STARTUPEX4":
                    return STARTUPEX4;
                case "PACKANDROIDAPP":
                    return PACKANDROIDAPP;
                case "PACKIOSAPP":
                    return PACKIOSAPP;
                case "REMOTEPACKSYS":
                    return REMOTEPACKSYS;
                case "STARTUPEX5":
                    return STARTUPEX5;
                case "STARTUPEX6":
                    return STARTUPEX6;
                case "STARTUPEX7":
                    return STARTUPEX7;
                case "DEPLOYPKG":
                    return DEPLOYPKG;
                case "CLONEDEMODEL":
                    return CLONEDEMODEL;
                case "SYNCSERVICEAPICLIENTMODEL":
                    return SYNCSERVICEAPICLIENTMODEL;
                case "STARTUPEX8":
                    return STARTUPEX8;
                case "BEGINPUBCODE":
                    return BEGINPUBCODE;
                case "ENDPUBCODE":
                    return ENDPUBCODE;
                case "RESETPUBCODE":
                    return RESETPUBCODE;
                case "PFPREVIEWACTION":
                    return PFPREVIEWACTION;
                case "SFPREVIEWACTION":
                    return SFPREVIEWACTION;
                case "CODEPREVIEWACTION":
                    return CODEPREVIEWACTION;
                case "SYNCSUBSYSSADEMODEL":
                    return SYNCSUBSYSSADEMODEL;
                case "SYNCAPPSBMODEL":
                    return SYNCAPPSBMODEL;
                case "STARTUPEX9":
                    return STARTUPEX9;
                case "PUBDYNAINSTMODEL":
                    return PUBDYNAINSTMODEL;
                case "DYNAINSTPREVIEWACTION":
                    return DYNAINSTPREVIEWACTION;
                case "SYNCSYSDBSCHEMAMODEL":
                    return SYNCSYSDBSCHEMAMODEL;
                case "IMPORTJSONSCHEMAMODEL":
                    return IMPORTJSONSCHEMAMODEL;
                case "IBIZCENTRAL":
                    return IBIZCENTRAL;
                case "IBIZMODELINGIA":
                    return IBIZMODELINGIA;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 微信公众号类型
     * <P>
     * <ul>
     * <li>ITEM_10&nbsp;(10)
     * <P>
     * 订阅号
     * <li>ITEM_20&nbsp;(20)
     * <P>
     * 服务号
     * <li>ITEM_30&nbsp;(30)
     * <P>
     * 企业号
     * </ul>     
     */
    public static enum WXAccountType{
        ITEM_10("10", "订阅号")
        ,ITEM_20("20", "服务号")
        ,ITEM_30("30", "企业号")
;
           
        public final String text;
        public final String value;
        
        private WXAccountType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WXAccountType from(String value){
            switch(value){
                case "10":
                    return ITEM_10;
                case "20":
                    return ITEM_20;
                case "30":
                    return ITEM_30;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统模块功能类型
     * <P>
     * <ul>
     * <li>ADMIN
     * <P>
     * 管理模块
     * <li>EXTENSION
     * <P>
     * 扩展模块
     * <li>EAI
     * <P>
     * 应用集成
     * <li>BI
     * <P>
     * 智能报表
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum ModuleUtilType{
        ADMIN("ADMIN", "管理模块")
        ,EXTENSION("EXTENSION", "扩展模块")
        ,EAI("EAI", "应用集成")
        ,BI("BI", "智能报表")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private ModuleUtilType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModuleUtilType from(String value){
            switch(value){
                case "ADMIN":
                    return ADMIN;
                case "EXTENSION":
                    return EXTENSION;
                case "EAI":
                    return EAI;
                case "BI":
                    return BI;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据看板部件类型
     * <P>
     * <ul>
     * <li>SYSPORTLET
     * <P>
     * 系统门户部件，数据看板中的门户部件成员，挂载系统门户部件。不支持子成员
     * <li>CONTAINER
     * <P>
     * 布局容器，数据看板中的基本布局面板，支持子成员
     * <li>RAWITEM
     * <P>
     * 直接内容，数据看板中的直接内容项，输出文本或图片。不支持子成员
     * </ul>     
     */
    public static enum DashboardPartType{
        SYSPORTLET("SYSPORTLET", "系统门户部件")
        ,CONTAINER("CONTAINER", "布局容器")
        ,RAWITEM("RAWITEM", "直接内容")
;
           
        public final String text;
        public final String value;
        
        private DashboardPartType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DashboardPartType from(String value){
            switch(value){
                case "SYSPORTLET":
                    return SYSPORTLET;
                case "CONTAINER":
                    return CONTAINER;
                case "RAWITEM":
                    return RAWITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体组逻辑模式
     * <P>
     * <ul>
     * <li>INITMODEL
     * <P>
     * 注入模型
     * <li>SYNCMODEL
     * <P>
     * 同步同构模型
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEGroupLogicMode{
        INITMODEL("INITMODEL", "注入模型")
        ,SYNCMODEL("SYNCMODEL", "同步同构模型")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEGroupLogicMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEGroupLogicMode from(String value){
            switch(value){
                case "INITMODEL":
                    return INITMODEL;
                case "SYNCMODEL":
                    return SYNCMODEL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表单导航栏位置
     * <P>
     * <ul>
     * <li>TOPLEFT
     * <P>
     * 左上角
     * <li>TOPRIGHT
     * <P>
     * 右上角
     * <li>BOTTOMLEFT
     * <P>
     * 左下角
     * <li>BOTTOMRIGHT
     * <P>
     * 右下角
     * <li>MIDDLELEFT
     * <P>
     * 左侧中间
     * <li>MIDDLERIGHT
     * <P>
     * 右侧中间
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum NavBarPos{
        TOPLEFT("TOPLEFT", "左上角")
        ,TOPRIGHT("TOPRIGHT", "右上角")
        ,BOTTOMLEFT("BOTTOMLEFT", "左下角")
        ,BOTTOMRIGHT("BOTTOMRIGHT", "右下角")
        ,MIDDLELEFT("MIDDLELEFT", "左侧中间")
        ,MIDDLERIGHT("MIDDLERIGHT", "右侧中间")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private NavBarPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static NavBarPos from(String value){
            switch(value){
                case "TOPLEFT":
                    return TOPLEFT;
                case "TOPRIGHT":
                    return TOPRIGHT;
                case "BOTTOMLEFT":
                    return BOTTOMLEFT;
                case "BOTTOMRIGHT":
                    return BOTTOMRIGHT;
                case "MIDDLELEFT":
                    return MIDDLELEFT;
                case "MIDDLERIGHT":
                    return MIDDLERIGHT;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为关闭视图模式，数值项
     * <P>
     * <ul>
     * <li>NOTCLOSE&nbsp;(0)
     * <P>
     * 不关闭
     * <li>CLOSE_OK&nbsp;(1)
     * <P>
     * 关闭（确认）
     * <li>CLOSE_CANCEL&nbsp;(2)
     * <P>
     * 关闭（取消）
     * </ul>     
     */
    public static enum UIActionCloseViewMode{
        NOTCLOSE(0, "不关闭")
        ,CLOSE_OK(1, "关闭（确认）")
        ,CLOSE_CANCEL(2, "关闭（取消）")
;
           
        public final String text;
        public final int value;
        
        private UIActionCloseViewMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionCloseViewMode from(int value){
            switch(value){
                case 0:
                    return NOTCLOSE;
                case 1:
                    return CLOSE_OK;
                case 2:
                    return CLOSE_CANCEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 消息框类型
     * <P>
     * <ul>
     * <li>INFO
     * <P>
     * 常规
     * <li>QUESTION
     * <P>
     * 询问
     * <li>WARNING
     * <P>
     * 警告
     * <li>ERROR
     * <P>
     * 错误
     * <li>PROMPT
     * <P>
     * 提示输入
     * </ul>     
     */
    public static enum DELNMsgBoxType{
        INFO("INFO", "常规")
        ,QUESTION("QUESTION", "询问")
        ,WARNING("WARNING", "警告")
        ,ERROR("ERROR", "错误")
        ,PROMPT("PROMPT", "提示输入")
;
           
        public final String text;
        public final String value;
        
        private DELNMsgBoxType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELNMsgBoxType from(String value){
            switch(value){
                case "INFO":
                    return INFO;
                case "QUESTION":
                    return QUESTION;
                case "WARNING":
                    return WARNING;
                case "ERROR":
                    return ERROR;
                case "PROMPT":
                    return PROMPT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 集成元素引用元素类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单元素
     * <li>COMPLEX
     * <P>
     * 复合元素
     * <li>GROUP
     * <P>
     * 元素组
     * </ul>     
     */
    public static enum EAIElementREType{
        SIMPLE("SIMPLE", "简单元素")
        ,COMPLEX("COMPLEX", "复合元素")
        ,GROUP("GROUP", "元素组")
;
           
        public final String text;
        public final String value;
        
        private EAIElementREType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EAIElementREType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "COMPLEX":
                    return COMPLEX;
                case "GROUP":
                    return GROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统面板模型类型
     * <P>
     * <ul>
     * <li>PANELMODEL
     * <P>
     * 面板定义模型
     * <li>VIEWMODEL
     * <P>
     * 视图定义模型
     * <li>CTRLMODEL
     * <P>
     * 部件定义模型
     * </ul>     
     */
    public static enum PanelModelType{
        PANELMODEL("PANELMODEL", "面板定义模型")
        ,VIEWMODEL("VIEWMODEL", "视图定义模型")
        ,CTRLMODEL("CTRLMODEL", "部件定义模型")
;
           
        public final String text;
        public final String value;
        
        private PanelModelType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelModelType from(String value){
            switch(value){
                case "PANELMODEL":
                    return PANELMODEL;
                case "VIEWMODEL":
                    return VIEWMODEL;
                case "CTRLMODEL":
                    return CTRLMODEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 外部接口DTO属性来源类型
     * <P>
     * <ul>
     * <li>SUBSYSSERVICEAPIDEFIELD
     * <P>
     * 外部服务接口实体属性，来源于当前实体属性
     * <li>SUBSYSSERVICEAPIDERS
     * <P>
     * 外部服务接口实体关系，来源于指定实体关系
     * </ul>     
     */
    public static enum SubSysServiceAPIDTOFieldSourceType{
        SUBSYSSERVICEAPIDEFIELD("SUBSYSSERVICEAPIDEFIELD", "外部服务接口实体属性")
        ,SUBSYSSERVICEAPIDERS("SUBSYSSERVICEAPIDERS", "外部服务接口实体关系")
;
           
        public final String text;
        public final String value;
        
        private SubSysServiceAPIDTOFieldSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysServiceAPIDTOFieldSourceType from(String value){
            switch(value){
                case "SUBSYSSERVICEAPIDEFIELD":
                    return SUBSYSSERVICEAPIDEFIELD;
                case "SUBSYSSERVICEAPIDERS":
                    return SUBSYSSERVICEAPIDERS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理多实例模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>PARALLEL
     * <P>
     * 并行多实例
     * <li>SEQUENTIAL
     * <P>
     * 串行多实例
     * </ul>     
     */
    public static enum WFProcMultiInstMode{
        NONE("NONE", "无")
        ,PARALLEL("PARALLEL", "并行多实例")
        ,SEQUENTIAL("SEQUENTIAL", "串行多实例")
;
           
        public final String text;
        public final String value;
        
        private WFProcMultiInstMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProcMultiInstMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "PARALLEL":
                    return PARALLEL;
                case "SEQUENTIAL":
                    return SEQUENTIAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * REST请求方式
     * <P>
     * <ul>
     * <li>GET
     * <P>
     * GET
     * <li>HEAD
     * <P>
     * HEAD
     * <li>POST
     * <P>
     * POST
     * <li>PUT
     * <P>
     * PUT
     * <li>PATCH
     * <P>
     * PATCH
     * <li>DELETE
     * <P>
     * DELETE
     * <li>OPTIONS
     * <P>
     * OPTIONS
     * <li>TRACE
     * <P>
     * TRACE
     * </ul>     
     */
    public static enum RequestMethod{
        GET("GET", "GET")
        ,HEAD("HEAD", "HEAD")
        ,POST("POST", "POST")
        ,PUT("PUT", "PUT")
        ,PATCH("PATCH", "PATCH")
        ,DELETE("DELETE", "DELETE")
        ,OPTIONS("OPTIONS", "OPTIONS")
        ,TRACE("TRACE", "TRACE")
;
           
        public final String text;
        public final String value;
        
        private RequestMethod(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static RequestMethod from(String value){
            switch(value){
                case "GET":
                    return GET;
                case "HEAD":
                    return HEAD;
                case "POST":
                    return POST;
                case "PUT":
                    return PUT;
                case "PATCH":
                    return PATCH;
                case "DELETE":
                    return DELETE;
                case "OPTIONS":
                    return OPTIONS;
                case "TRACE":
                    return TRACE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 阈值组包含值模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 不包含
     * <li>YES&nbsp;(1)
     * <P>
     * 包含
     * <li>FIRST&nbsp;(2)
     * <P>
     * 首项包含
     * <li>LAST&nbsp;(3)
     * <P>
     * 尾项包含
     * </ul>     
     */
    public static enum ThresholdIncValueMode{
        NO(0, "不包含")
        ,YES(1, "包含")
        ,FIRST(2, "首项包含")
        ,LAST(3, "尾项包含")
;
           
        public final String text;
        public final int value;
        
        private ThresholdIncValueMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ThresholdIncValueMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return YES;
                case 2:
                    return FIRST;
                case 3:
                    return LAST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流大数据库源节点类型
     * <P>
     * <ul>
     * <li>BDTABLE
     * <P>
     * 大数据表
     * <li>DEDATASET
     * <P>
     * 实体数据集
     * <li>DEDATAQUERY
     * <P>
     * 实体数据查询
     * </ul>     
     */
    public static enum DEDataFlowSysBDSchemeSourceType{
        BDTABLE("BDTABLE", "大数据表")
        ,DEDATASET("DEDATASET", "实体数据集")
        ,DEDATAQUERY("DEDATAQUERY", "实体数据查询")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysBDSchemeSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysBDSchemeSourceType from(String value){
            switch(value){
                case "BDTABLE":
                    return BDTABLE;
                case "DEDATASET":
                    return DEDATASET;
                case "DEDATAQUERY":
                    return DEDATAQUERY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 日历样式
     * <P>
     * <ul>
     * <li>DAY
     * <P>
     * 天
     * <li>WEEK
     * <P>
     * 周
     * <li>MONTH
     * <P>
     * 月
     * <li>TIMELINE
     * <P>
     * 时间轴
     * <li>WEEK_TIMELINE
     * <P>
     * 周（复合时间轴）
     * <li>MONTH_TIMELINE
     * <P>
     * 月（复合时间轴）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum CalendarStyle{
        DAY("DAY", "天")
        ,WEEK("WEEK", "周")
        ,MONTH("MONTH", "月")
        ,TIMELINE("TIMELINE", "时间轴")
        ,WEEK_TIMELINE("WEEK_TIMELINE", "周（复合时间轴）")
        ,MONTH_TIMELINE("MONTH_TIMELINE", "月（复合时间轴）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private CalendarStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CalendarStyle from(String value){
            switch(value){
                case "DAY":
                    return DAY;
                case "WEEK":
                    return WEEK;
                case "MONTH":
                    return MONTH;
                case "TIMELINE":
                    return TIMELINE;
                case "WEEK_TIMELINE":
                    return WEEK_TIMELINE;
                case "MONTH_TIMELINE":
                    return MONTH_TIMELINE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 模型用户类别
     * <P>
     * <ul>
     * <li>CAT1
     * <P>
     * 类别1
     * <li>CAT2
     * <P>
     * 类型2
     * <li>CAT3
     * <P>
     * 类别3
     * <li>CAT4
     * <P>
     * 类别4
     * <li>CAT5
     * <P>
     * 类别5
     * <li>CAT6
     * <P>
     * 类别6
     * <li>CAT7
     * <P>
     * 类别7
     * <li>CAT8
     * <P>
     * 类别8
     * <li>CAT9
     * <P>
     * 类别9
     * </ul>     
     */
    public static enum ModelUserCat{
        CAT1("CAT1", "类别1")
        ,CAT2("CAT2", "类型2")
        ,CAT3("CAT3", "类别3")
        ,CAT4("CAT4", "类别4")
        ,CAT5("CAT5", "类别5")
        ,CAT6("CAT6", "类别6")
        ,CAT7("CAT7", "类别7")
        ,CAT8("CAT8", "类别8")
        ,CAT9("CAT9", "类别9")
;
           
        public final String text;
        public final String value;
        
        private ModelUserCat(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelUserCat from(String value){
            switch(value){
                case "CAT1":
                    return CAT1;
                case "CAT2":
                    return CAT2;
                case "CAT3":
                    return CAT3;
                case "CAT4":
                    return CAT4;
                case "CAT5":
                    return CAT5;
                case "CAT6":
                    return CAT6;
                case "CAT7":
                    return CAT7;
                case "CAT8":
                    return CAT8;
                case "CAT9":
                    return CAT9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格分页大小，数值项
     * <P>
     * <ul>
     * <li>SIZE_10&nbsp;(10)
     * <P>
     * 10行
     * <li>SIZE_20&nbsp;(20)
     * <P>
     * 20行
     * <li>SIZE_30&nbsp;(30)
     * <P>
     * 30行
     * <li>SIZE_40&nbsp;(40)
     * <P>
     * 40行
     * <li>SIZE_50&nbsp;(50)
     * <P>
     * 50行
     * <li>SIZE_60&nbsp;(60)
     * <P>
     * 60行
     * <li>SIZE_70&nbsp;(70)
     * <P>
     * 70行
     * <li>SIZE_80&nbsp;(80)
     * <P>
     * 80行
     * <li>SIZE_90&nbsp;(90)
     * <P>
     * 90行
     * <li>SIZE_100&nbsp;(100)
     * <P>
     * 100行
     * <li>SIZE_500&nbsp;(500)
     * <P>
     * 500行（程序使用）
     * <li>SIZE_1000&nbsp;(1000)
     * <P>
     * 1000行（程序使用）
     * </ul>     
     */
    public static enum PagingSize{
        SIZE_10(10, "10行")
        ,SIZE_20(20, "20行")
        ,SIZE_30(30, "30行")
        ,SIZE_40(40, "40行")
        ,SIZE_50(50, "50行")
        ,SIZE_60(60, "60行")
        ,SIZE_70(70, "70行")
        ,SIZE_80(80, "80行")
        ,SIZE_90(90, "90行")
        ,SIZE_100(100, "100行")
        ,SIZE_500(500, "500行（程序使用）")
        ,SIZE_1000(1000, "1000行（程序使用）")
;
           
        public final String text;
        public final int value;
        
        private PagingSize(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PagingSize from(int value){
            switch(value){
                case 10:
                    return SIZE_10;
                case 20:
                    return SIZE_20;
                case 30:
                    return SIZE_30;
                case 40:
                    return SIZE_40;
                case 50:
                    return SIZE_50;
                case 60:
                    return SIZE_60;
                case 70:
                    return SIZE_70;
                case 80:
                    return SIZE_80;
                case 90:
                    return SIZE_90;
                case 100:
                    return SIZE_100;
                case 500:
                    return SIZE_500;
                case 1000:
                    return SIZE_1000;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体图表主题
     * <P>
     * <ul>
     * <li>THEME1
     * <P>
     * 主题1
     * <li>THEME2
     * <P>
     * 主题2
     * <li>THEME3
     * <P>
     * 主题3
     * <li>THEME4
     * <P>
     * 主题4
     * <li>THEME5
     * <P>
     * 主题5
     * </ul>     
     */
    public static enum ChartTheme{
        THEME1("THEME1", "主题1")
        ,THEME2("THEME2", "主题2")
        ,THEME3("THEME3", "主题3")
        ,THEME4("THEME4", "主题4")
        ,THEME5("THEME5", "主题5")
;
           
        public final String text;
        public final String value;
        
        private ChartTheme(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartTheme from(String value){
            switch(value){
                case "THEME1":
                    return THEME1;
                case "THEME2":
                    return THEME2;
                case "THEME3":
                    return THEME3;
                case "THEME4":
                    return THEME4;
                case "THEME5":
                    return THEME5;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 无权限按钮显示模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(1)
     * <P>
     * 禁用
     * <li>HIDE&nbsp;(2)
     * <P>
     * 隐藏
     * <li>HIDEDEFAULT&nbsp;(6)
     * <P>
     * 隐藏且默认隐藏
     * </ul>     
     */
    public static enum BtnNoPrivDisplayMode{
        DISABLED(1, "禁用")
        ,HIDE(2, "隐藏")
        ,HIDEDEFAULT(6, "隐藏且默认隐藏")
;
           
        public final String text;
        public final int value;
        
        private BtnNoPrivDisplayMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static BtnNoPrivDisplayMode from(int value){
            switch(value){
                case 1:
                    return DISABLED;
                case 2:
                    return HIDE;
                case 6:
                    return HIDEDEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 消息框显示模式
     * <P>
     * <ul>
     * <li>CENTER
     * <P>
     * 居中
     * </ul>     
     */
    public static enum DELNMsgBoxShowMode{
        CENTER("CENTER", "居中")
;
           
        public final String text;
        public final String value;
        
        private DELNMsgBoxShowMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELNMsgBoxShowMode from(String value){
            switch(value){
                case "CENTER":
                    return CENTER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 多数据部件分组方向
     * <P>
     * <ul>
     * <li>ROW
     * <P>
     * 从左往右
     * <li>COLUMN
     * <P>
     * 从上往下
     * </ul>     
     */
    public static enum MDCtrlGroupLayout{
        ROW("ROW", "从左往右")
        ,COLUMN("COLUMN", "从上往下")
;
           
        public final String text;
        public final String value;
        
        private MDCtrlGroupLayout(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MDCtrlGroupLayout from(String value){
            switch(value){
                case "ROW":
                    return ROW;
                case "COLUMN":
                    return COLUMN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格视图新建模式
     * <P>
     * <ul>
     * <li>WIZARD
     * <P>
     * 向导
     * <li>MULTIFORM
     * <P>
     * 多表单
     * <li>INDEXDE
     * <P>
     * 索引实体
     * <li>NORMAL
     * <P>
     * 常规
     * </ul>     
     */
    public static enum NewDataMode{
        WIZARD("WIZARD", "向导")
        ,MULTIFORM("MULTIFORM", "多表单")
        ,INDEXDE("INDEXDE", "索引实体")
        ,NORMAL("NORMAL", "常规")
;
           
        public final String text;
        public final String value;
        
        private NewDataMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static NewDataMode from(String value){
            switch(value){
                case "WIZARD":
                    return WIZARD;
                case "MULTIFORM":
                    return MULTIFORM;
                case "INDEXDE":
                    return INDEXDE;
                case "NORMAL":
                    return NORMAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 字体样式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>BOLD&nbsp;(1)
     * <P>
     * 粗体
     * <li>ITALIC&nbsp;(2)
     * <P>
     * 斜体
     * <li>UNDERLINE&nbsp;(4)
     * <P>
     * 下划线
     * </ul>     
     */
    public static enum FontStyle{
        BOLD(1, "粗体")
        ,ITALIC(2, "斜体")
        ,UNDERLINE(4, "下划线")
;
           
        public final String text;
        public final int value;
        
        private FontStyle(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FontStyle from(int value){
            switch(value){
                case 1:
                    return BOLD;
                case 2:
                    return ITALIC;
                case 4:
                    return UNDERLINE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试用例级别
     * <P>
     * <ul>
     * <li>P1
     * <P>
     * P1
     * <li>P2
     * <P>
     * P2
     * <li>P3
     * <P>
     * P3
     * <li>P4
     * <P>
     * P4
     * <li>P5
     * <P>
     * P5
     * </ul>     
     */
    public static enum TestCaseLevel{
        P1("P1", "P1")
        ,P2("P2", "P2")
        ,P3("P3", "P3")
        ,P4("P4", "P4")
        ,P5("P5", "P5")
;
           
        public final String text;
        public final String value;
        
        private TestCaseLevel(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestCaseLevel from(String value){
            switch(value){
                case "P1":
                    return P1;
                case "P2":
                    return P2;
                case "P3":
                    return P3;
                case "P4":
                    return P4;
                case "P5":
                    return P5;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为批操作模式，数值项
     * <P>
     * <ul>
     * <li>NOTSUPPORTED&nbsp;(0)
     * <P>
     * 不支持
     * <li>ENABLE&nbsp;(1)
     * <P>
     * 支持
     * <li>BATCHONLY&nbsp;(2)
     * <P>
     * 仅支持批操作
     * <li>ENABLEEX&nbsp;(5)
     * <P>
     * 支持（事务），支持批操作，并且要求批操作再同一个事务中
     * <li>BATCHONLYEX&nbsp;(6)
     * <P>
     * 仅支持批操作（事务）
     * </ul>     
     */
    public static enum DEActionBatchMode{
        NOTSUPPORTED(0, "不支持")
        ,ENABLE(1, "支持")
        ,BATCHONLY(2, "仅支持批操作")
        ,ENABLEEX(5, "支持（事务）")
        ,BATCHONLYEX(6, "仅支持批操作（事务）")
;
           
        public final String text;
        public final int value;
        
        private DEActionBatchMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionBatchMode from(int value){
            switch(value){
                case 0:
                    return NOTSUPPORTED;
                case 1:
                    return ENABLE;
                case 2:
                    return BATCHONLY;
                case 5:
                    return ENABLEEX;
                case 6:
                    return BATCHONLYEX;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体界面行为_前台处理类型
     * <P>
     * <ul>
     * <li>WIZARD
     * <P>
     * 打开视图或向导（模态），使用模态打开指定视图
     * <li>TOP
     * <P>
     * 打开顶级视图，在应用的主导航区打开指定视图
     * <li>PRINT
     * <P>
     * 打开打印视图
     * <li>DATAIMP
     * <P>
     * 打开数据导入视图
     * <li>DATAEXP
     * <P>
     * 打开数据导出视图
     * <li>CHAT
     * <P>
     * 打开聊天界面
     * <li>OPENHTMLPAGE
     * <P>
     * 打开HTML页面，直接打开Html网页
     * <li>EDITFORM
     * <P>
     * 打开编辑表单，打开编辑表单进行编辑
     * <li>QUICKEDIT
     * <P>
     * 打开快捷编辑，使用表单模型进行快速编辑
     * <li>OTHER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum UIActionFrontType{
        WIZARD("WIZARD", "打开视图或向导（模态）")
        ,TOP("TOP", "打开顶级视图")
        ,PRINT("PRINT", "打开打印视图")
        ,DATAIMP("DATAIMP", "打开数据导入视图")
        ,DATAEXP("DATAEXP", "打开数据导出视图")
        ,CHAT("CHAT", "打开聊天界面")
        ,OPENHTMLPAGE("OPENHTMLPAGE", "打开HTML页面")
        ,EDITFORM("EDITFORM", "打开编辑表单")
        ,QUICKEDIT("QUICKEDIT", "打开快捷编辑")
        ,OTHER("OTHER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private UIActionFrontType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionFrontType from(String value){
            switch(value){
                case "WIZARD":
                    return WIZARD;
                case "TOP":
                    return TOP;
                case "PRINT":
                    return PRINT;
                case "DATAIMP":
                    return DATAIMP;
                case "DATAEXP":
                    return DATAEXP;
                case "CHAT":
                    return CHAT;
                case "OPENHTMLPAGE":
                    return OPENHTMLPAGE;
                case "EDITFORM":
                    return EDITFORM;
                case "QUICKEDIT":
                    return QUICKEDIT;
                case "OTHER":
                    return OTHER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云系统后台任务启动模式
     * <P>
     * <ul>
     * <li>AUTO
     * <P>
     * 自动
     * <li>MANUAL
     * <P>
     * 手动
     * </ul>     
     */
    public static enum BackendTaskStartMode{
        AUTO("AUTO", "自动")
        ,MANUAL("MANUAL", "手动")
;
           
        public final String text;
        public final String value;
        
        private BackendTaskStartMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BackendTaskStartMode from(String value){
            switch(value){
                case "AUTO":
                    return AUTO;
                case "MANUAL":
                    return MANUAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体报表内容格式
     * <P>
     * <ul>
     * <li>PDF
     * <P>
     * PDF
     * <li>HTML
     * <P>
     * HTML
     * <li>DOCX
     * <P>
     * DOCX
     * <li>XLSX
     * <P>
     * XLSX
     * <li>JSON
     * <P>
     * JSON
     * <li>XML
     * <P>
     * XML
     * <li>TEXT
     * <P>
     * TEXT
     * <li>MARKDOWN
     * <P>
     * MARKDOWN
     * <li>WORD
     * <P>
     * WORD（过期）
     * <li>EXCEL
     * <P>
     * EXCEL（过期）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum ReportContentType{
        PDF("PDF", "PDF")
        ,HTML("HTML", "HTML")
        ,DOCX("DOCX", "DOCX")
        ,XLSX("XLSX", "XLSX")
        ,JSON("JSON", "JSON")
        ,XML("XML", "XML")
        ,TEXT("TEXT", "TEXT")
        ,MARKDOWN("MARKDOWN", "MARKDOWN")
        ,WORD("WORD", "WORD（过期）")
        ,EXCEL("EXCEL", "EXCEL（过期）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private ReportContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ReportContentType from(String value){
            switch(value){
                case "PDF":
                    return PDF;
                case "HTML":
                    return HTML;
                case "DOCX":
                    return DOCX;
                case "XLSX":
                    return XLSX;
                case "JSON":
                    return JSON;
                case "XML":
                    return XML;
                case "TEXT":
                    return TEXT;
                case "MARKDOWN":
                    return MARKDOWN;
                case "WORD":
                    return WORD;
                case "EXCEL":
                    return EXCEL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为对话框结果
     * <P>
     * <ul>
     * <li>OK
     * <P>
     * 确定
     * <li>CANCEL
     * <P>
     * 取消
     * <li>YES
     * <P>
     * 是
     * <li>NO
     * <P>
     * 否
     * </ul>     
     */
    public static enum UIActionDialogResult{
        OK("OK", "确定")
        ,CANCEL("CANCEL", "取消")
        ,YES("YES", "是")
        ,NO("NO", "否")
;
           
        public final String text;
        public final String value;
        
        private UIActionDialogResult(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionDialogResult from(String value){
            switch(value){
                case "OK":
                    return OK;
                case "CANCEL":
                    return CANCEL;
                case "YES":
                    return YES;
                case "NO":
                    return NO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 前端运行时插件模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 非运行时插件
     * <li>LOCAL&nbsp;(1)
     * <P>
     * 本地运行时插件
     * <li>REMOTE&nbsp;(2)
     * <P>
     * 远程运行时插件
     * <li>LAYOUTPANEL_LOCALDSL&nbsp;(11)
     * <P>
     * 布局面板（本地DSL模型）
     * </ul>     
     */
    public static enum PFPluginRTMode{
        NO(0, "非运行时插件")
        ,LOCAL(1, "本地运行时插件")
        ,REMOTE(2, "远程运行时插件")
        ,LAYOUTPANEL_LOCALDSL(11, "布局面板（本地DSL模型）")
;
           
        public final String text;
        public final int value;
        
        private PFPluginRTMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PFPluginRTMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return LOCAL;
                case 2:
                    return REMOTE;
                case 11:
                    return LAYOUTPANEL_LOCALDSL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 多数据部件类型
     * <P>
     * <ul>
     * <li>LIST
     * <P>
     * 列表，多数据部件使用实体列表绘制
     * <li>FORM
     * <P>
     * 表单，多数据部件使用表单循环绘制
     * <li>GRID
     * <P>
     * 表格，多数据部件使用表格绘制
     * <li>DATAVIEW
     * <P>
     * 卡片视图，多数据部件使用卡片视图绘制
     * <li>REPEATER
     * <P>
     * 重复器
     * </ul>     
     */
    public static enum FormDetailMDCtrlType{
        LIST("LIST", "列表")
        ,FORM("FORM", "表单")
        ,GRID("GRID", "表格")
        ,DATAVIEW("DATAVIEW", "卡片视图")
        ,REPEATER("REPEATER", "重复器")
;
           
        public final String text;
        public final String value;
        
        private FormDetailMDCtrlType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormDetailMDCtrlType from(String value){
            switch(value){
                case "LIST":
                    return LIST;
                case "FORM":
                    return FORM;
                case "GRID":
                    return GRID;
                case "DATAVIEW":
                    return DATAVIEW;
                case "REPEATER":
                    return REPEATER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据面板源（全部）
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>DEDATASET
     * <P>
     * 实体集合
     * <li>DELOGIC
     * <P>
     * 实体逻辑
     * <li>ACTIVEDATAPARAM
     * <P>
     * 绑定当前数据变量
     * <li>APPGLOBALPARAM
     * <P>
     * 绑定应用全局变量
     * <li>TOPVIEWSESSIONPARAM
     * <P>
     * 绑定顶级视图会话共享变量
     * <li>VIEWSESSIONPARAM
     * <P>
     * 绑定当前视图会话共享变量
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum DataPanelSource{
        DEACTION("DEACTION", "实体行为")
        ,DEDATASET("DEDATASET", "实体集合")
        ,DELOGIC("DELOGIC", "实体逻辑")
        ,ACTIVEDATAPARAM("ACTIVEDATAPARAM", "绑定当前数据变量")
        ,APPGLOBALPARAM("APPGLOBALPARAM", "绑定应用全局变量")
        ,TOPVIEWSESSIONPARAM("TOPVIEWSESSIONPARAM", "绑定顶级视图会话共享变量")
        ,VIEWSESSIONPARAM("VIEWSESSIONPARAM", "绑定当前视图会话共享变量")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private DataPanelSource(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataPanelSource from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "DEDATASET":
                    return DEDATASET;
                case "DELOGIC":
                    return DELOGIC;
                case "ACTIVEDATAPARAM":
                    return ACTIVEDATAPARAM;
                case "APPGLOBALPARAM":
                    return APPGLOBALPARAM;
                case "TOPVIEWSESSIONPARAM":
                    return TOPVIEWSESSIONPARAM;
                case "VIEWSESSIONPARAM":
                    return VIEWSESSIONPARAM;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 绝对布局模式
     * <P>
     * <ul>
     * <li>LTWH
     * <P>
     * 左上角+宽高
     * <li>LTRB
     * <P>
     * 左上角+右下角
     * <li>RBWH
     * <P>
     * 右下角+宽高
     * </ul>     
     */
    public static enum AbsoluteLayoutPos{
        LTWH("LTWH", "左上角+宽高")
        ,LTRB("LTRB", "左上角+右下角")
        ,RBWH("RBWH", "右下角+宽高")
;
           
        public final String text;
        public final String value;
        
        private AbsoluteLayoutPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AbsoluteLayoutPos from(String value){
            switch(value){
                case "LTWH":
                    return LTWH;
                case "LTRB":
                    return LTRB;
                case "RBWH":
                    return RBWH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统权限控制体系，数值项
     * <P>
     * <ul>
     * <li>RTSYSROLE&nbsp;(1)
     * <P>
     * 运行子系统角色体系（默认），由运行子系统提供基于角色的访问控制体系（BRAC）进行管理，模式通用
     * <li>SYSROLEANDDEROLE&nbsp;(2)
     * <P>
     * 当前系统角色及实体角色，实体操作角色定义了实体具体的能力模式，系统角色对实体操作角色进行组装。在运行环境中只需要把用户加到系统角色中就可以完成系统的赋权。这种模式贴近业务，管理简单，但由于大量的处理机制都内置在系统中，需要系统的业务及管理模式都具备相当的成熟度
     * </ul>     
     */
    public static enum AccCtrlArch{
        RTSYSROLE(1, "运行子系统角色体系（默认）")
        ,SYSROLEANDDEROLE(2, "当前系统角色及实体角色")
;
           
        public final String text;
        public final int value;
        
        private AccCtrlArch(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AccCtrlArch from(int value){
            switch(value){
                case 1:
                    return RTSYSROLE;
                case 2:
                    return SYSROLEANDDEROLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理通知消息类型，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>INTERNAL&nbsp;(1)
     * <P>
     * 系统消息
     * <li>EMAIL&nbsp;(2)
     * <P>
     * 电子邮件
     * <li>SMS&nbsp;(4)
     * <P>
     * 手机短信
     * <li>MSN&nbsp;(8)
     * <P>
     * MSN消息
     * <li>SAIM&nbsp;(16)
     * <P>
     * 检务通消息
     * <li>WT&nbsp;(32)
     * <P>
     * 微信
     * <li>DT&nbsp;(64)
     * <P>
     * 钉钉
     * <li>ENTWT&nbsp;(128)
     * <P>
     * 企业微信
     * <li>USER&nbsp;(256)
     * <P>
     * 用户自定义
     * <li>USER2&nbsp;(512)
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum InfomMsgType{
        INTERNAL(1, "系统消息")
        ,EMAIL(2, "电子邮件")
        ,SMS(4, "手机短信")
        ,MSN(8, "MSN消息")
        ,SAIM(16, "检务通消息")
        ,WT(32, "微信")
        ,DT(64, "钉钉")
        ,ENTWT(128, "企业微信")
        ,USER(256, "用户自定义")
        ,USER2(512, "用户自定义2")
;
           
        public final String text;
        public final int value;
        
        private InfomMsgType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static InfomMsgType from(int value){
            switch(value){
                case 1:
                    return INTERNAL;
                case 2:
                    return EMAIL;
                case 4:
                    return SMS;
                case 8:
                    return MSN;
                case 16:
                    return SAIM;
                case 32:
                    return WT;
                case 64:
                    return DT;
                case 128:
                    return ENTWT;
                case 256:
                    return USER;
                case 512:
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用首页视图主菜单方向
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左侧
     * <li>TOP
     * <P>
     * 上方
     * <li>CENTER
     * <P>
     * 中间
     * <li>TREEEXP
     * <P>
     * 树导航
     * <li>TABEXP_TOP
     * <P>
     * 分页导航（上方分页）
     * <li>TABEXP_LEFT
     * <P>
     * 分页导航（左侧分页）
     * <li>TABEXP_BOTTOM
     * <P>
     * 分页导航（下方分页）
     * <li>TABEXP_RIGHT
     * <P>
     * 分页导航（右侧分页）
     * <li>NONE
     * <P>
     * 不显示
     * </ul>     
     */
    public static enum AppIndexViewMenuAlign{
        LEFT("LEFT", "左侧")
        ,TOP("TOP", "上方")
        ,CENTER("CENTER", "中间")
        ,TREEEXP("TREEEXP", "树导航")
        ,TABEXP_TOP("TABEXP_TOP", "分页导航（上方分页）")
        ,TABEXP_LEFT("TABEXP_LEFT", "分页导航（左侧分页）")
        ,TABEXP_BOTTOM("TABEXP_BOTTOM", "分页导航（下方分页）")
        ,TABEXP_RIGHT("TABEXP_RIGHT", "分页导航（右侧分页）")
        ,NONE("NONE", "不显示")
;
           
        public final String text;
        public final String value;
        
        private AppIndexViewMenuAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppIndexViewMenuAlign from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "TOP":
                    return TOP;
                case "CENTER":
                    return CENTER;
                case "TREEEXP":
                    return TREEEXP;
                case "TABEXP_TOP":
                    return TABEXP_TOP;
                case "TABEXP_LEFT":
                    return TABEXP_LEFT;
                case "TABEXP_BOTTOM":
                    return TABEXP_BOTTOM;
                case "TABEXP_RIGHT":
                    return TABEXP_RIGHT;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息类型
     * <P>
     * <ul>
     * <li>INFO
     * <P>
     * 常规信息
     * <li>WARN
     * <P>
     * 警告信息
     * <li>ERROR
     * <P>
     * 错误信息
     * <li>CUSTOM
     * <P>
     * 自定义信息
     * </ul>     
     */
    public static enum ViewMsgType{
        INFO("INFO", "常规信息")
        ,WARN("WARN", "警告信息")
        ,ERROR("ERROR", "错误信息")
        ,CUSTOM("CUSTOM", "自定义信息")
;
           
        public final String text;
        public final String value;
        
        private ViewMsgType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgType from(String value){
            switch(value){
                case "INFO":
                    return INFO;
                case "WARN":
                    return WARN;
                case "ERROR":
                    return ERROR;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理逻辑连接条件类型
     * <P>
     * <ul>
     * <li>GROUP
     * <P>
     * 组逻辑
     * <li>SINGLE
     * <P>
     * 单项逻辑
     * <li>CUSTOM
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum WFLinkCondType{
        GROUP("GROUP", "组逻辑")
        ,SINGLE("SINGLE", "单项逻辑")
        ,CUSTOM("CUSTOM", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private WFLinkCondType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFLinkCondType from(String value){
            switch(value){
                case "GROUP":
                    return GROUP;
                case "SINGLE":
                    return SINGLE;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性类型，数值项
     * <P>
     * <ul>
     * <li>PHISICAL&nbsp;(1)
     * <P>
     * 物理字段[来自当前实体物理表字段]，来自实体自身且具备持久化能力的属性，持久化能力来自实体的默认存储
     * <li>FORMULA&nbsp;(2)
     * <P>
     * 逻辑字段[来自计算式]，通过实体的其它属性计算合成的属性
     * <li>LINK&nbsp;(3)
     * <P>
     * 链接字段[来自关系实体字段]，引用来自关系实体的属性
     * <li>DYNASTORAGE&nbsp;(4)
     * <P>
     * 扩展物理字段[来自动态存储实体物理表字段]，来自实体自身且具备持久化能力的属性，持久化能力来自外部的动态存储
     * <li>UI&nbsp;(5)
     * <P>
     * 应用界面字段[无存储]，用于辅助界面呈现，无默认处理逻辑
     * </ul>     
     */
    public static enum DEFType{
        PHISICAL(1, "物理字段[来自当前实体物理表字段]")
        ,FORMULA(2, "逻辑字段[来自计算式]")
        ,LINK(3, "链接字段[来自关系实体字段]")
        ,DYNASTORAGE(4, "扩展物理字段[来自动态存储实体物理表字段]")
        ,UI(5, "应用界面字段[无存储]")
;
           
        public final String text;
        public final int value;
        
        private DEFType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFType from(int value){
            switch(value){
                case 1:
                    return PHISICAL;
                case 2:
                    return FORMULA;
                case 3:
                    return LINK;
                case 4:
                    return DYNASTORAGE;
                case 5:
                    return UI;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图表坐标轴位置
     * <P>
     * <ul>
     * <li>LEFT&nbsp;(left)
     * <P>
     * 左侧
     * <li>BOTTOM&nbsp;(bottom)
     * <P>
     * 下方
     * <li>RIGHT&nbsp;(right)
     * <P>
     * 右侧
     * <li>TOP&nbsp;(top)
     * <P>
     * 上方
     * <li>RADIAL&nbsp;(radial)
     * <P>
     * 径向轴(Radial)
     * <li>ANGULAR&nbsp;(angular)
     * <P>
     * 角度轴(Angular)
     * </ul>     
     */
    public static enum ChartAxisPos{
        LEFT("left", "左侧")
        ,BOTTOM("bottom", "下方")
        ,RIGHT("right", "右侧")
        ,TOP("top", "上方")
        ,RADIAL("radial", "径向轴(Radial)")
        ,ANGULAR("angular", "角度轴(Angular)")
;
           
        public final String text;
        public final String value;
        
        private ChartAxisPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartAxisPos from(String value){
            switch(value){
                case "left":
                    return LEFT;
                case "bottom":
                    return BOTTOM;
                case "right":
                    return RIGHT;
                case "top":
                    return TOP;
                case "radial":
                    return RADIAL;
                case "angular":
                    return ANGULAR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器类型（移动端）
     * <P>
     * <ul>
     * <li>MOBTEXT
     * <P>
     * 移动端文本框
     * <li>MOBNUMBER
     * <P>
     * 移动端数值框
     * <li>MOBTEXTAREA
     * <P>
     * 移动端多行文本
     * <li>MOBBARCODEREADER
     * <P>
     * 移动端条码阅读器
     * <li>MOBSWITCH
     * <P>
     * 移动端开关部件
     * <li>MOBRADIOLIST
     * <P>
     * 移动端单选项列表
     * <li>MOB2DBARCODEREADER
     * <P>
     * 移动端二维码阅读器
     * <li>MOBDROPDOWNLIST
     * <P>
     * 移动端下拉列表（单选）
     * <li>MOBCHECKLIST
     * <P>
     * 移动端下拉列表（多选）
     * <li>MOBPICKER
     * <P>
     * 移动端数据选择
     * <li>MOBPICKER_DROPDOWNVIEW
     * <P>
     * 移动端数据选择（下拉视图）
     * <li>MOBMPICKER
     * <P>
     * 移动端多数据选择
     * <li>MOBDATE
     * <P>
     * 移动端时间选择器
     * <li>MOBDATE_HOUR
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH）
     * <li>MOBDATE_MINUTE
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH:mm）
     * <li>MOBDATE_NODAY
     * <P>
     * 移动端时间选择器（HH:mm:ss）
     * <li>MOBDATE_NODAY_NOSECOND
     * <P>
     * 移动端时间选择器（HH:mm）
     * <li>MOBDATE_NOTIME
     * <P>
     * 移动端时间选择器（YYYY-MM-DD）
     * <li>MOBDATE_SECOND
     * <P>
     * 移动端时间选择器（YYYY-MM-DD HH:mm:ss）
     * <li>MOBPICTURE
     * <P>
     * 移动端图片控件（单项）
     * <li>MOBSINGLEFILEUPLOAD
     * <P>
     * 移动端文件控件（单项）
     * <li>MOBPICTURE_RAW
     * <P>
     * 移动端图片控件（单项、直接内容）
     * <li>MOBPICTURELIST
     * <P>
     * 移动端图片控件（多项）
     * <li>MOBMULTIFILEUPLOAD
     * <P>
     * 移动端文件控件（多项）
     * <li>MOBPASSWORD
     * <P>
     * 移动端密码框
     * <li>MOBSLIDER
     * <P>
     * 移动端滑动输入条
     * <li>MOBSTEPPER
     * <P>
     * 移动端步进器
     * <li>MOBRATING
     * <P>
     * 移动端评分器
     * <li>MOBHTMLTEXT
     * <P>
     * 移动端HTML编辑框
     * <li>MOBCODE
     * <P>
     * 移动端代码编辑框
     * <li>MOBMARKDOWN
     * <P>
     * 移动端Markdown编辑框
     * <li>MOBNUMBERRANGE
     * <P>
     * 移动端数值范围编辑框
     * <li>MOBDATERANGE
     * <P>
     * 移动端时间范围选择器
     * <li>MOBDATERANGE_NOTIME
     * <P>
     * 移动端时间范围选择器（YYYY-MM-DD）
     * <li>MOBCASCADER
     * <P>
     * 移动端级联选择器
     * <li>MOBARRAY
     * <P>
     * 移动端数组编辑器
     * <li>MOBMAPPICKER
     * <P>
     * 移动端地图选择器
     * <li>MOBCOLORPICKER
     * <P>
     * 移动端颜色选择器
     * <li>USERCONTROL
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum MobEditorType{
        MOBTEXT("MOBTEXT", "移动端文本框")
        ,MOBNUMBER("MOBNUMBER", "移动端数值框")
        ,MOBTEXTAREA("MOBTEXTAREA", "移动端多行文本")
        ,MOBBARCODEREADER("MOBBARCODEREADER", "移动端条码阅读器")
        ,MOBSWITCH("MOBSWITCH", "移动端开关部件")
        ,MOBRADIOLIST("MOBRADIOLIST", "移动端单选项列表")
        ,MOB2DBARCODEREADER("MOB2DBARCODEREADER", "移动端二维码阅读器")
        ,MOBDROPDOWNLIST("MOBDROPDOWNLIST", "移动端下拉列表（单选）")
        ,MOBCHECKLIST("MOBCHECKLIST", "移动端下拉列表（多选）")
        ,MOBPICKER("MOBPICKER", "移动端数据选择")
        ,MOBPICKER_DROPDOWNVIEW("MOBPICKER_DROPDOWNVIEW", "移动端数据选择（下拉视图）")
        ,MOBMPICKER("MOBMPICKER", "移动端多数据选择")
        ,MOBDATE("MOBDATE", "移动端时间选择器")
        ,MOBDATE_HOUR("MOBDATE_HOUR", "移动端时间选择器（YYYY-MM-DD HH）")
        ,MOBDATE_MINUTE("MOBDATE_MINUTE", "移动端时间选择器（YYYY-MM-DD HH:mm）")
        ,MOBDATE_NODAY("MOBDATE_NODAY", "移动端时间选择器（HH:mm:ss）")
        ,MOBDATE_NODAY_NOSECOND("MOBDATE_NODAY_NOSECOND", "移动端时间选择器（HH:mm）")
        ,MOBDATE_NOTIME("MOBDATE_NOTIME", "移动端时间选择器（YYYY-MM-DD）")
        ,MOBDATE_SECOND("MOBDATE_SECOND", "移动端时间选择器（YYYY-MM-DD HH:mm:ss）")
        ,MOBPICTURE("MOBPICTURE", "移动端图片控件（单项）")
        ,MOBSINGLEFILEUPLOAD("MOBSINGLEFILEUPLOAD", "移动端文件控件（单项）")
        ,MOBPICTURE_RAW("MOBPICTURE_RAW", "移动端图片控件（单项、直接内容）")
        ,MOBPICTURELIST("MOBPICTURELIST", "移动端图片控件（多项）")
        ,MOBMULTIFILEUPLOAD("MOBMULTIFILEUPLOAD", "移动端文件控件（多项）")
        ,MOBPASSWORD("MOBPASSWORD", "移动端密码框")
        ,MOBSLIDER("MOBSLIDER", "移动端滑动输入条")
        ,MOBSTEPPER("MOBSTEPPER", "移动端步进器")
        ,MOBRATING("MOBRATING", "移动端评分器")
        ,MOBHTMLTEXT("MOBHTMLTEXT", "移动端HTML编辑框")
        ,MOBCODE("MOBCODE", "移动端代码编辑框")
        ,MOBMARKDOWN("MOBMARKDOWN", "移动端Markdown编辑框")
        ,MOBNUMBERRANGE("MOBNUMBERRANGE", "移动端数值范围编辑框")
        ,MOBDATERANGE("MOBDATERANGE", "移动端时间范围选择器")
        ,MOBDATERANGE_NOTIME("MOBDATERANGE_NOTIME", "移动端时间范围选择器（YYYY-MM-DD）")
        ,MOBCASCADER("MOBCASCADER", "移动端级联选择器")
        ,MOBARRAY("MOBARRAY", "移动端数组编辑器")
        ,MOBMAPPICKER("MOBMAPPICKER", "移动端地图选择器")
        ,MOBCOLORPICKER("MOBCOLORPICKER", "移动端颜色选择器")
        ,USERCONTROL("USERCONTROL", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private MobEditorType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobEditorType from(String value){
            switch(value){
                case "MOBTEXT":
                    return MOBTEXT;
                case "MOBNUMBER":
                    return MOBNUMBER;
                case "MOBTEXTAREA":
                    return MOBTEXTAREA;
                case "MOBBARCODEREADER":
                    return MOBBARCODEREADER;
                case "MOBSWITCH":
                    return MOBSWITCH;
                case "MOBRADIOLIST":
                    return MOBRADIOLIST;
                case "MOB2DBARCODEREADER":
                    return MOB2DBARCODEREADER;
                case "MOBDROPDOWNLIST":
                    return MOBDROPDOWNLIST;
                case "MOBCHECKLIST":
                    return MOBCHECKLIST;
                case "MOBPICKER":
                    return MOBPICKER;
                case "MOBPICKER_DROPDOWNVIEW":
                    return MOBPICKER_DROPDOWNVIEW;
                case "MOBMPICKER":
                    return MOBMPICKER;
                case "MOBDATE":
                    return MOBDATE;
                case "MOBDATE_HOUR":
                    return MOBDATE_HOUR;
                case "MOBDATE_MINUTE":
                    return MOBDATE_MINUTE;
                case "MOBDATE_NODAY":
                    return MOBDATE_NODAY;
                case "MOBDATE_NODAY_NOSECOND":
                    return MOBDATE_NODAY_NOSECOND;
                case "MOBDATE_NOTIME":
                    return MOBDATE_NOTIME;
                case "MOBDATE_SECOND":
                    return MOBDATE_SECOND;
                case "MOBPICTURE":
                    return MOBPICTURE;
                case "MOBSINGLEFILEUPLOAD":
                    return MOBSINGLEFILEUPLOAD;
                case "MOBPICTURE_RAW":
                    return MOBPICTURE_RAW;
                case "MOBPICTURELIST":
                    return MOBPICTURELIST;
                case "MOBMULTIFILEUPLOAD":
                    return MOBMULTIFILEUPLOAD;
                case "MOBPASSWORD":
                    return MOBPASSWORD;
                case "MOBSLIDER":
                    return MOBSLIDER;
                case "MOBSTEPPER":
                    return MOBSTEPPER;
                case "MOBRATING":
                    return MOBRATING;
                case "MOBHTMLTEXT":
                    return MOBHTMLTEXT;
                case "MOBCODE":
                    return MOBCODE;
                case "MOBMARKDOWN":
                    return MOBMARKDOWN;
                case "MOBNUMBERRANGE":
                    return MOBNUMBERRANGE;
                case "MOBDATERANGE":
                    return MOBDATERANGE;
                case "MOBDATERANGE_NOTIME":
                    return MOBDATERANGE_NOTIME;
                case "MOBCASCADER":
                    return MOBCASCADER;
                case "MOBARRAY":
                    return MOBARRAY;
                case "MOBMAPPICKER":
                    return MOBMAPPICKER;
                case "MOBCOLORPICKER":
                    return MOBCOLORPICKER;
                case "USERCONTROL":
                    return USERCONTROL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体界面行为_视图逻辑附加类型
     * <P>
     * <ul>
     * <li>REPLACE
     * <P>
     * 替换执行，替换界面行为执行逻辑
     * <li>AFTER
     * <P>
     * 执行之后，界面行为执行后触发
     * </ul>     
     */
    public static enum UIActionVLExecMode{
        REPLACE("REPLACE", "替换执行")
        ,AFTER("AFTER", "执行之后")
;
           
        public final String text;
        public final String value;
        
        private UIActionVLExecMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionVLExecMode from(String value){
            switch(value){
                case "REPLACE":
                    return REPLACE;
                case "AFTER":
                    return AFTER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体处理逻辑连接条件类型
     * <P>
     * <ul>
     * <li>GROUP
     * <P>
     * 组逻辑，组合条件，提供与（AND）、或（OR）操作
     * <li>SINGLE
     * <P>
     * 单项逻辑，单项条件
     * </ul>     
     */
    public static enum LogicLinkCondType{
        GROUP("GROUP", "组逻辑")
        ,SINGLE("SINGLE", "单项逻辑")
;
           
        public final String text;
        public final String value;
        
        private LogicLinkCondType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LogicLinkCondType from(String value){
            switch(value){
                case "GROUP":
                    return GROUP;
                case "SINGLE":
                    return SINGLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体服务接口成员类型（应用实体方法类型）
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>FETCH
     * <P>
     * 实体数据集合
     * <li>SELECT
     * <P>
     * 实体数据查询（SELECT）
     * <li>FETCHTEMP
     * <P>
     * 实体数据集合（临时）
     * <li>SELECTTEMP
     * <P>
     * 实体数据查询（SELECT）（临时）
     * <li>WFACTION
     * <P>
     * 流程行为
     * <li>FILTERACTION
     * <P>
     * 过滤器行为
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum AppDEMethodType{
        DEACTION("DEACTION", "实体行为")
        ,FETCH("FETCH", "实体数据集合")
        ,SELECT("SELECT", "实体数据查询（SELECT）")
        ,FETCHTEMP("FETCHTEMP", "实体数据集合（临时）")
        ,SELECTTEMP("SELECTTEMP", "实体数据查询（SELECT）（临时）")
        ,WFACTION("WFACTION", "流程行为")
        ,FILTERACTION("FILTERACTION", "过滤器行为")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private AppDEMethodType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppDEMethodType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "FETCH":
                    return FETCH;
                case "SELECT":
                    return SELECT;
                case "FETCHTEMP":
                    return FETCHTEMP;
                case "SELECTTEMP":
                    return SELECTTEMP;
                case "WFACTION":
                    return WFACTION;
                case "FILTERACTION":
                    return FILTERACTION;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单项值规则校验方式，数值项
     * <P>
     * <ul>
     * <li>FRONT&nbsp;(1)
     * <P>
     * 前台，仅在前端应用进行值规则校验
     * <li>BACKEND&nbsp;(2)
     * <P>
     * 后台，仅在后端服务进行值规则校验
     * <li>ALL&nbsp;(3)
     * <P>
     * 前后台，同时在前端应用及后台服务进行校验
     * </ul>     
     */
    public static enum EditItemVRCheckMode{
        FRONT(1, "前台")
        ,BACKEND(2, "后台")
        ,ALL(3, "前后台")
;
           
        public final String text;
        public final int value;
        
        private EditItemVRCheckMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditItemVRCheckMode from(int value){
            switch(value){
                case 1:
                    return FRONT;
                case 2:
                    return BACKEND;
                case 3:
                    return ALL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性标准数据类型，数值项
     * <P>
     * <ul>
     * <li>UNKNOWN&nbsp;(0)
     * <P>
     * UNKNOWN
     * <li>BIGINT&nbsp;(1)
     * <P>
     * BIGINT
     * <li>BINARY&nbsp;(2)
     * <P>
     * BINARY
     * <li>BIT&nbsp;(3)
     * <P>
     * BIT
     * <li>CHAR&nbsp;(4)
     * <P>
     * CHAR
     * <li>DATETIME&nbsp;(5)
     * <P>
     * DATETIME
     * <li>DECIMAL&nbsp;(6)
     * <P>
     * DECIMAL
     * <li>FLOAT&nbsp;(7)
     * <P>
     * FLOAT
     * <li>IMAGE&nbsp;(8)
     * <P>
     * IMAGE
     * <li>INT&nbsp;(9)
     * <P>
     * INT
     * <li>MONEY&nbsp;(10)
     * <P>
     * MONEY
     * <li>NCHAR&nbsp;(11)
     * <P>
     * NCHAR
     * <li>NTEXT&nbsp;(12)
     * <P>
     * NTEXT
     * <li>NVARCHAR&nbsp;(13)
     * <P>
     * NVARCHAR
     * <li>NUMERIC&nbsp;(14)
     * <P>
     * NUMERIC
     * <li>REAL&nbsp;(15)
     * <P>
     * REAL
     * <li>SMALLDATETIME&nbsp;(16)
     * <P>
     * SMALLDATETIME
     * <li>SMALLINT&nbsp;(17)
     * <P>
     * SMALLINT
     * <li>SMALLMONEY&nbsp;(18)
     * <P>
     * SMALLMONEY
     * <li>SQL_VARIANT&nbsp;(19)
     * <P>
     * SQL_VARIANT
     * <li>SYSNAME&nbsp;(20)
     * <P>
     * SYSNAME
     * <li>TEXT&nbsp;(21)
     * <P>
     * TEXT
     * <li>TIMESTAMP&nbsp;(22)
     * <P>
     * TIMESTAMP
     * <li>TINYINT&nbsp;(23)
     * <P>
     * TINYINT
     * <li>VARBINARY&nbsp;(24)
     * <P>
     * VARBINARY
     * <li>VARCHAR&nbsp;(25)
     * <P>
     * VARCHAR
     * <li>UNIQUEIDENTIFIER&nbsp;(26)
     * <P>
     * UNIQUEIDENTIFIER
     * <li>DATE&nbsp;(27)
     * <P>
     * DATE
     * <li>TIME&nbsp;(28)
     * <P>
     * TIME
     * <li>BIGDECIMAL&nbsp;(29)
     * <P>
     * BIGDECIMAL
     * </ul>     
     */
    public static enum StdDataType{
        UNKNOWN(0, "UNKNOWN")
        ,BIGINT(1, "BIGINT")
        ,BINARY(2, "BINARY")
        ,BIT(3, "BIT")
        ,CHAR(4, "CHAR")
        ,DATETIME(5, "DATETIME")
        ,DECIMAL(6, "DECIMAL")
        ,FLOAT(7, "FLOAT")
        ,IMAGE(8, "IMAGE")
        ,INT(9, "INT")
        ,MONEY(10, "MONEY")
        ,NCHAR(11, "NCHAR")
        ,NTEXT(12, "NTEXT")
        ,NVARCHAR(13, "NVARCHAR")
        ,NUMERIC(14, "NUMERIC")
        ,REAL(15, "REAL")
        ,SMALLDATETIME(16, "SMALLDATETIME")
        ,SMALLINT(17, "SMALLINT")
        ,SMALLMONEY(18, "SMALLMONEY")
        ,SQL_VARIANT(19, "SQL_VARIANT")
        ,SYSNAME(20, "SYSNAME")
        ,TEXT(21, "TEXT")
        ,TIMESTAMP(22, "TIMESTAMP")
        ,TINYINT(23, "TINYINT")
        ,VARBINARY(24, "VARBINARY")
        ,VARCHAR(25, "VARCHAR")
        ,UNIQUEIDENTIFIER(26, "UNIQUEIDENTIFIER")
        ,DATE(27, "DATE")
        ,TIME(28, "TIME")
        ,BIGDECIMAL(29, "BIGDECIMAL")
;
           
        public final String text;
        public final int value;
        
        private StdDataType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static StdDataType from(int value){
            switch(value){
                case 0:
                    return UNKNOWN;
                case 1:
                    return BIGINT;
                case 2:
                    return BINARY;
                case 3:
                    return BIT;
                case 4:
                    return CHAR;
                case 5:
                    return DATETIME;
                case 6:
                    return DECIMAL;
                case 7:
                    return FLOAT;
                case 8:
                    return IMAGE;
                case 9:
                    return INT;
                case 10:
                    return MONEY;
                case 11:
                    return NCHAR;
                case 12:
                    return NTEXT;
                case 13:
                    return NVARCHAR;
                case 14:
                    return NUMERIC;
                case 15:
                    return REAL;
                case 16:
                    return SMALLDATETIME;
                case 17:
                    return SMALLINT;
                case 18:
                    return SMALLMONEY;
                case 19:
                    return SQL_VARIANT;
                case 20:
                    return SYSNAME;
                case 21:
                    return TEXT;
                case 22:
                    return TIMESTAMP;
                case 23:
                    return TINYINT;
                case 24:
                    return VARBINARY;
                case 25:
                    return VARCHAR;
                case 26:
                    return UNIQUEIDENTIFIER;
                case 27:
                    return DATE;
                case 28:
                    return TIME;
                case 29:
                    return BIGDECIMAL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 报表格式
     * <P>
     * <ul>
     * <li>POI_TL
     * <P>
     * POI模板引擎
     * <li>ANTVG6
     * <P>
     * AntVG6
     * <li>LUCKYSHEET
     * <P>
     * LuckySheet
     * <li>AVUEDATA
     * <P>
     * AvueData
     * <li>AVUEDATA_CLOUD
     * <P>
     * AvueData（Cloud）
     * <li>GRAFANA
     * <P>
     * Grafana
     * <li>DATAEASE
     * <P>
     * DataEase
     * <li>JR
     * <P>
     * JasperReport
     * <li>HTML
     * <P>
     * HTML
     * <li>MARKDOWN
     * <P>
     * Markdown
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum ReportType{
        POI_TL("POI_TL", "POI模板引擎")
        ,ANTVG6("ANTVG6", "AntVG6")
        ,LUCKYSHEET("LUCKYSHEET", "LuckySheet")
        ,AVUEDATA("AVUEDATA", "AvueData")
        ,AVUEDATA_CLOUD("AVUEDATA_CLOUD", "AvueData（Cloud）")
        ,GRAFANA("GRAFANA", "Grafana")
        ,DATAEASE("DATAEASE", "DataEase")
        ,JR("JR", "JasperReport")
        ,HTML("HTML", "HTML")
        ,MARKDOWN("MARKDOWN", "Markdown")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private ReportType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ReportType from(String value){
            switch(value){
                case "POI_TL":
                    return POI_TL;
                case "ANTVG6":
                    return ANTVG6;
                case "LUCKYSHEET":
                    return LUCKYSHEET;
                case "AVUEDATA":
                    return AVUEDATA;
                case "AVUEDATA_CLOUD":
                    return AVUEDATA_CLOUD;
                case "GRAFANA":
                    return GRAFANA;
                case "DATAEASE":
                    return DATAEASE;
                case "JR":
                    return JR;
                case "HTML":
                    return HTML;
                case "MARKDOWN":
                    return MARKDOWN;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统用例关系模式
     * <P>
     * <ul>
     * <li>ACTOR2USECASE
     * <P>
     * 操作者到用例
     * <li>USECASE2USECASE
     * <P>
     * 用例到用例
     * <li>ACTOR2ACTOR
     * <P>
     * 操作者到操作者
     * <li>USECASE2ACTOR
     * <P>
     * 用例到操作者
     * </ul>     
     */
    public static enum UseCaseRSMode{
        ACTOR2USECASE("ACTOR2USECASE", "操作者到用例")
        ,USECASE2USECASE("USECASE2USECASE", "用例到用例")
        ,ACTOR2ACTOR("ACTOR2ACTOR", "操作者到操作者")
        ,USECASE2ACTOR("USECASE2ACTOR", "用例到操作者")
;
           
        public final String text;
        public final String value;
        
        private UseCaseRSMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UseCaseRSMode from(String value){
            switch(value){
                case "ACTOR2USECASE":
                    return ACTOR2USECASE;
                case "USECASE2USECASE":
                    return USECASE2USECASE;
                case "ACTOR2ACTOR":
                    return ACTOR2ACTOR;
                case "USECASE2ACTOR":
                    return USECASE2ACTOR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体接口行为关系模式，数值项
     * <P>
     * <ul>
     * <li>ITEM_0&nbsp;(0)
     * <P>
     * 无行为，不提供任何实体行为方法
     * <li>ITEM_1&nbsp;(1)
     * <P>
     * 继承行为，继承关系从实体接口的行为方法
     * <li>ITEM_2&nbsp;(2)
     * <P>
     * 指定行为，重新指定从实体接口的行为方法
     * </ul>     
     */
    public static enum SADEActionRSMode{
        ITEM_0(0, "无行为")
        ,ITEM_1(1, "继承行为")
        ,ITEM_2(2, "指定行为")
;
           
        public final String text;
        public final int value;
        
        private SADEActionRSMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEActionRSMode from(int value){
            switch(value){
                case 0:
                    return ITEM_0;
                case 1:
                    return ITEM_1;
                case 2:
                    return ITEM_2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试用例目标类型
     * <P>
     * <ul>
     * <li>DEFVR
     * <P>
     * 实体属性值规则
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>DESADETAIL
     * <P>
     * 实体接口方法
     * <li>APPVIEW
     * <P>
     * 应用视图
     * <li>CUSTOM
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum TestCaseTargetType{
        DEFVR("DEFVR", "实体属性值规则")
        ,DEACTION("DEACTION", "实体行为")
        ,DESADETAIL("DESADETAIL", "实体接口方法")
        ,APPVIEW("APPVIEW", "应用视图")
        ,CUSTOM("CUSTOM", "自定义")
;
           
        public final String text;
        public final String value;
        
        private TestCaseTargetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestCaseTargetType from(String value){
            switch(value){
                case "DEFVR":
                    return DEFVR;
                case "DEACTION":
                    return DEACTION;
                case "DESADETAIL":
                    return DESADETAIL;
                case "APPVIEW":
                    return APPVIEW;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树视图节点展开模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 否，不自动展开节点
     * <li>YES&nbsp;(1)
     * <P>
     * 是，自动展开节点
     * <li>FIRSTONLY&nbsp;(2)
     * <P>
     * 是，仅首节点，自动展开首节点
     * </ul>     
     */
    public static enum TreeNodeExpandMode{
        NO(0, "否")
        ,YES(1, "是")
        ,FIRSTONLY(2, "是，仅首节点")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeExpandMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeExpandMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return YES;
                case 2:
                    return FIRSTONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 多数据部件分组模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无分组
     * <li>AUTO
     * <P>
     * 自动分组，根据数据集中的分组数据自动出分组
     * <li>CODELIST
     * <P>
     * 分组代码表，根据分组代码表预先分组，数据集的数据再放入相应的分组中
     * </ul>     
     */
    public static enum MDCtrlGroupMode{
        NONE("NONE", "无分组")
        ,AUTO("AUTO", "自动分组")
        ,CODELIST("CODELIST", "分组代码表")
;
           
        public final String text;
        public final String value;
        
        private MDCtrlGroupMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MDCtrlGroupMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "AUTO":
                    return AUTO;
                case "CODELIST":
                    return CODELIST;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用故事板故事项关系类型
     * <P>
     * <ul>
     * <li>UIACTION
     * <P>
     * 界面行为，通过界面行为打开目标应用视图
     * <li>APPFUNC
     * <P>
     * 应用功能，通过应用功能打开目标应用视图
     * <li>APPVIEWREF
     * <P>
     * 应用视图引用，应用视图引用使用目标视图
     * <li>APPVIEWEMBED
     * <P>
     * 应用视图嵌入，应用视图嵌入目标视图
     * </ul>     
     */
    public static enum AppStoryBoardItemRSType{
        UIACTION("UIACTION", "界面行为")
        ,APPFUNC("APPFUNC", "应用功能")
        ,APPVIEWREF("APPVIEWREF", "应用视图引用")
        ,APPVIEWEMBED("APPVIEWEMBED", "应用视图嵌入")
;
           
        public final String text;
        public final String value;
        
        private AppStoryBoardItemRSType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppStoryBoardItemRSType from(String value){
            switch(value){
                case "UIACTION":
                    return UIACTION;
                case "APPFUNC":
                    return APPFUNC;
                case "APPVIEWREF":
                    return APPVIEWREF;
                case "APPVIEWEMBED":
                    return APPVIEWEMBED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体聚合数据关系属性映射类型
     * <P>
     * <ul>
     * <li>SUM
     * <P>
     * 合计，将从实体的指定属性的值进行合计
     * <li>AVG
     * <P>
     * 平均，将从实体的指定属性的值进行平均
     * <li>MAX
     * <P>
     * 最大值，取从实体的指定属性的最大值
     * <li>MIN
     * <P>
     * 最小值，取从实体的指定属性的最小值
     * <li>COUNT
     * <P>
     * 计数，从实体计数
     * <li>EXISTS
     * <P>
     * 存在，从实体存在，1表示存在，0表示不存在
     * <li>NOTEXISTS
     * <P>
     * 不存在，从实体不存在，1表示不存在，0表示存在
     * <li>GROUPBY
     * <P>
     * 分组
     * <li>GROUPBY_DAYOFWEEK
     * <P>
     * 按周天分组，周的第几天，从1开始
     * <li>GROUPBY_DAYOFMONTH
     * <P>
     * 按月天分组，月的第几天，从1开始
     * <li>GROUPBY_DAYOFYEAR
     * <P>
     * 按年天分组，年中第几天，从1开始
     * <li>GROUPBY_WEEK
     * <P>
     * 按周分组
     * <li>GROUPBY_MONTH
     * <P>
     * 按月份分组
     * <li>GROUPBY_QUARTER
     * <P>
     * 按季度分组
     * <li>GROUPBY_YEAR
     * <P>
     * 按年份分组
     * <li>GROUPBY_HOUR
     * <P>
     * 按小时分组
     * <li>GROUPBY_MINUTE
     * <P>
     * 按分钟分组
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DERAggDataDEFMapType{
        SUM("SUM", "合计")
        ,AVG("AVG", "平均")
        ,MAX("MAX", "最大值")
        ,MIN("MIN", "最小值")
        ,COUNT("COUNT", "计数")
        ,EXISTS("EXISTS", "存在")
        ,NOTEXISTS("NOTEXISTS", "不存在")
        ,GROUPBY("GROUPBY", "分组")
        ,GROUPBY_DAYOFWEEK("GROUPBY_DAYOFWEEK", "按周天分组")
        ,GROUPBY_DAYOFMONTH("GROUPBY_DAYOFMONTH", "按月天分组")
        ,GROUPBY_DAYOFYEAR("GROUPBY_DAYOFYEAR", "按年天分组")
        ,GROUPBY_WEEK("GROUPBY_WEEK", "按周分组")
        ,GROUPBY_MONTH("GROUPBY_MONTH", "按月份分组")
        ,GROUPBY_QUARTER("GROUPBY_QUARTER", "按季度分组")
        ,GROUPBY_YEAR("GROUPBY_YEAR", "按年份分组")
        ,GROUPBY_HOUR("GROUPBY_HOUR", "按小时分组")
        ,GROUPBY_MINUTE("GROUPBY_MINUTE", "按分钟分组")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DERAggDataDEFMapType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERAggDataDEFMapType from(String value){
            switch(value){
                case "SUM":
                    return SUM;
                case "AVG":
                    return AVG;
                case "MAX":
                    return MAX;
                case "MIN":
                    return MIN;
                case "COUNT":
                    return COUNT;
                case "EXISTS":
                    return EXISTS;
                case "NOTEXISTS":
                    return NOTEXISTS;
                case "GROUPBY":
                    return GROUPBY;
                case "GROUPBY_DAYOFWEEK":
                    return GROUPBY_DAYOFWEEK;
                case "GROUPBY_DAYOFMONTH":
                    return GROUPBY_DAYOFMONTH;
                case "GROUPBY_DAYOFYEAR":
                    return GROUPBY_DAYOFYEAR;
                case "GROUPBY_WEEK":
                    return GROUPBY_WEEK;
                case "GROUPBY_MONTH":
                    return GROUPBY_MONTH;
                case "GROUPBY_QUARTER":
                    return GROUPBY_QUARTER;
                case "GROUPBY_YEAR":
                    return GROUPBY_YEAR;
                case "GROUPBY_HOUR":
                    return GROUPBY_HOUR;
                case "GROUPBY_MINUTE":
                    return GROUPBY_MINUTE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工作流引擎类型
     * <P>
     * <ul>
     * <li>EMBEDDED
     * <P>
     * iBiz内置（默认）
     * <li>ACTIVITI
     * <P>
     * Java Activiti
     * </ul>     
     */
    public static enum WFEngineType{
        EMBEDDED("EMBEDDED", "iBiz内置（默认）")
        ,ACTIVITI("ACTIVITI", "Java Activiti")
;
           
        public final String text;
        public final String value;
        
        private WFEngineType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFEngineType from(String value){
            switch(value){
                case "EMBEDDED":
                    return EMBEDDED;
                case "ACTIVITI":
                    return ACTIVITI;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统消息模板引擎
     * <P>
     * <ul>
     * <li>FREEMARKER
     * <P>
     * FreeMarker
     * <li>GROOVY
     * <P>
     * Groovy
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum MsgTemplEngine{
        FREEMARKER("FREEMARKER", "FreeMarker")
        ,GROOVY("GROOVY", "Groovy")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private MsgTemplEngine(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MsgTemplEngine from(String value){
            switch(value){
                case "FREEMARKER":
                    return FREEMARKER;
                case "GROOVY":
                    return GROOVY;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 向导样式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认样式
     * <li>STYLE2
     * <P>
     * 样式2
     * <li>STYLE3
     * <P>
     * 样式3
     * <li>STYLE4
     * <P>
     * 样式4
     * </ul>     
     */
    public static enum WizardStyle{
        DEFAULT("DEFAULT", "默认样式")
        ,STYLE2("STYLE2", "样式2")
        ,STYLE3("STYLE3", "样式3")
        ,STYLE4("STYLE4", "样式4")
;
           
        public final String text;
        public final String value;
        
        private WizardStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WizardStyle from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "STYLE2":
                    return STYLE2;
                case "STYLE3":
                    return STYLE3;
                case "STYLE4":
                    return STYLE4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图表标题位置
     * <P>
     * <ul>
     * <li>TOP
     * <P>
     * 上
     * <li>BOTTOM
     * <P>
     * 下
     * <li>LEFT
     * <P>
     * 左
     * <li>RIGHT
     * <P>
     * 右
     * </ul>     
     */
    public static enum ChartTitlePos{
        TOP("TOP", "上")
        ,BOTTOM("BOTTOM", "下")
        ,LEFT("LEFT", "左")
        ,RIGHT("RIGHT", "右")
;
           
        public final String text;
        public final String value;
        
        private ChartTitlePos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartTitlePos from(String value){
            switch(value){
                case "TOP":
                    return TOP;
                case "BOTTOM":
                    return BOTTOM;
                case "LEFT":
                    return LEFT;
                case "RIGHT":
                    return RIGHT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体属性更新旧值回填模式
     * <P>
     * <ul>
     * <li>ALWAYS
     * <P>
     * 始终回填
     * <li>NOTEXISTS
     * <P>
     * 无值时回填
     * </ul>     
     */
    public static enum OldValueUpdateMode{
        ALWAYS("ALWAYS", "始终回填")
        ,NOTEXISTS("NOTEXISTS", "无值时回填")
;
           
        public final String text;
        public final String value;
        
        private OldValueUpdateMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static OldValueUpdateMode from(String value){
            switch(value){
                case "ALWAYS":
                    return ALWAYS;
                case "NOTEXISTS":
                    return NOTEXISTS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台语言资源类型
     * <P>
     * <ul>
     * <li>DE_LNAME&nbsp;(DE.LNAME)
     * <P>
     * 实体逻辑名称（DE.LNAME.*）
     * <li>DEF_LNAME&nbsp;(DEF.LNAME)
     * <P>
     * 属性逻辑名称（DEF.LNAME.*）
     * <li>CL_ITEM_LNAME&nbsp;(CL.ITEM.LNAME)
     * <P>
     * 代码表项（CL.ITEM.LNAME.*）
     * <li>CL_ITEM_TOOLTIP&nbsp;(CL.ITEM.TOOLTIP)
     * <P>
     * 代码表项提示（CL.ITEM.TOOLTIP.*）
     * <li>TBB_TEXT&nbsp;(TBB.TEXT)
     * <P>
     * 工具栏按钮文本（TBB.TEXT.*）
     * <li>TBB_TOOLTIP&nbsp;(TBB.TOOLTIP)
     * <P>
     * 工具栏按钮提示（TBB.TOOLTIP.*）
     * <li>MENUITEM_CAPTION&nbsp;(MENUITEM.CAPTION)
     * <P>
     * 菜单项文本（MENUITEM.CAPTION.*）
     * <li>PAGE_HEADER&nbsp;(PAGE.HEADER)
     * <P>
     * 界面头部标题（PAGE.HEADER.*）
     * <li>PAGE_COMMON&nbsp;(PAGE.COMMON)
     * <P>
     * 界面常规（PAGE.COMMON.*）
     * <li>PAGE
     * <P>
     * 界面文本（PAGE.*）
     * <li>CONTROL
     * <P>
     * 控件文本（CONTROL.*）
     * <li>ERROR_STD&nbsp;(ERROR.STD)
     * <P>
     * 标准错误（ERROR.STD.*）
     * <li>CTRL
     * <P>
     * 处理逻辑（CTRL.*）
     * <li>COMMON
     * <P>
     * 通用（COMMON.*）
     * <li>OTHER
     * <P>
     * 其它（OTHER.*）
     * </ul>     
     */
    public static enum LanResType{
        DE_LNAME("DE.LNAME", "实体逻辑名称（DE.LNAME.*）")
        ,DEF_LNAME("DEF.LNAME", "属性逻辑名称（DEF.LNAME.*）")
        ,CL_ITEM_LNAME("CL.ITEM.LNAME", "代码表项（CL.ITEM.LNAME.*）")
        ,CL_ITEM_TOOLTIP("CL.ITEM.TOOLTIP", "代码表项提示（CL.ITEM.TOOLTIP.*）")
        ,TBB_TEXT("TBB.TEXT", "工具栏按钮文本（TBB.TEXT.*）")
        ,TBB_TOOLTIP("TBB.TOOLTIP", "工具栏按钮提示（TBB.TOOLTIP.*）")
        ,MENUITEM_CAPTION("MENUITEM.CAPTION", "菜单项文本（MENUITEM.CAPTION.*）")
        ,PAGE_HEADER("PAGE.HEADER", "界面头部标题（PAGE.HEADER.*）")
        ,PAGE_COMMON("PAGE.COMMON", "界面常规（PAGE.COMMON.*）")
        ,PAGE("PAGE", "界面文本（PAGE.*）")
        ,CONTROL("CONTROL", "控件文本（CONTROL.*）")
        ,ERROR_STD("ERROR.STD", "标准错误（ERROR.STD.*）")
        ,CTRL("CTRL", "处理逻辑（CTRL.*）")
        ,COMMON("COMMON", "通用（COMMON.*）")
        ,OTHER("OTHER", "其它（OTHER.*）")
;
           
        public final String text;
        public final String value;
        
        private LanResType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LanResType from(String value){
            switch(value){
                case "DE.LNAME":
                    return DE_LNAME;
                case "DEF.LNAME":
                    return DEF_LNAME;
                case "CL.ITEM.LNAME":
                    return CL_ITEM_LNAME;
                case "CL.ITEM.TOOLTIP":
                    return CL_ITEM_TOOLTIP;
                case "TBB.TEXT":
                    return TBB_TEXT;
                case "TBB.TOOLTIP":
                    return TBB_TOOLTIP;
                case "MENUITEM.CAPTION":
                    return MENUITEM_CAPTION;
                case "PAGE.HEADER":
                    return PAGE_HEADER;
                case "PAGE.COMMON":
                    return PAGE_COMMON;
                case "PAGE":
                    return PAGE;
                case "CONTROL":
                    return CONTROL;
                case "ERROR.STD":
                    return ERROR_STD;
                case "CTRL":
                    return CTRL;
                case "COMMON":
                    return COMMON;
                case "OTHER":
                    return OTHER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为事务模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>REQUIRED
     * <P>
     * 需要事务（没有新建）
     * <li>MANDATORY
     * <P>
     * 需要事务（没有异常）
     * <li>NESTED
     * <P>
     * 嵌套事务（没有新建）
     * <li>REQUIRES_NEW
     * <P>
     * 挂起当前事务（没有新建）
     * <li>NOT_SUPPORTED
     * <P>
     * 无事务（存在则挂起）
     * <li>SUPPORTS
     * <P>
     * 支持事务（没有无事务）
     * <li>NONE
     * <P>
     * 无事务
     * <li>GLOBAL
     * <P>
     * 分布式事务
     * <li>USER
     * <P>
     * 自定义
     * <li>USER2
     * <P>
     * 自定义2
     * </ul>     
     */
    public static enum DEActionTSMode{
        DEFAULT("DEFAULT", "默认")
        ,REQUIRED("REQUIRED", "需要事务（没有新建）")
        ,MANDATORY("MANDATORY", "需要事务（没有异常）")
        ,NESTED("NESTED", "嵌套事务（没有新建）")
        ,REQUIRES_NEW("REQUIRES_NEW", "挂起当前事务（没有新建）")
        ,NOT_SUPPORTED("NOT_SUPPORTED", "无事务（存在则挂起）")
        ,SUPPORTS("SUPPORTS", "支持事务（没有无事务）")
        ,NONE("NONE", "无事务")
        ,GLOBAL("GLOBAL", "分布式事务")
        ,USER("USER", "自定义")
        ,USER2("USER2", "自定义2")
;
           
        public final String text;
        public final String value;
        
        private DEActionTSMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionTSMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "REQUIRED":
                    return REQUIRED;
                case "MANDATORY":
                    return MANDATORY;
                case "NESTED":
                    return NESTED;
                case "REQUIRES_NEW":
                    return REQUIRES_NEW;
                case "NOT_SUPPORTED":
                    return NOT_SUPPORTED;
                case "SUPPORTS":
                    return SUPPORTS;
                case "NONE":
                    return NONE;
                case "GLOBAL":
                    return GLOBAL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云系统后台任务作业类型
     * <P>
     * <ul>
     * <li>PREDEFINED
     * <P>
     * 预定义
     * <li>DEACTION
     * <P>
     * 触发实体行为
     * <li>USER
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum BackendTaskType{
        PREDEFINED("PREDEFINED", "预定义")
        ,DEACTION("DEACTION", "触发实体行为")
        ,USER("USER", "自定义")
;
           
        public final String text;
        public final String value;
        
        private BackendTaskType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BackendTaskType from(String value){
            switch(value){
                case "PREDEFINED":
                    return PREDEFINED;
                case "DEACTION":
                    return DEACTION;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体通知任务模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无任务
     * <li>TODO&nbsp;(1)
     * <P>
     * 待办任务，同时建立通知用户的待办事项
     * </ul>     
     */
    public static enum DENotifyTaskMode{
        NONE(0, "无任务")
        ,TODO(1, "待办任务")
;
           
        public final String text;
        public final int value;
        
        private DENotifyTaskMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DENotifyTaskMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return TODO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用表格数据激活模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>SINGLECLICK&nbsp;(1)
     * <P>
     * 单击
     * <li>DOUBLECLICK&nbsp;(2)
     * <P>
     * 双击
     * </ul>     
     */
    public static enum GridRowActiveMode{
        NONE(0, "无")
        ,SINGLECLICK(1, "单击")
        ,DOUBLECLICK(2, "双击")
;
           
        public final String text;
        public final int value;
        
        private GridRowActiveMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridRowActiveMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return SINGLECLICK;
                case 2:
                    return DOUBLECLICK;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 边框样式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无边框
     * <li>SOLID
     * <P>
     * 实线边框
     * <li>DOTTED
     * <P>
     * 点状边框
     * <li>DASHED
     * <P>
     * 虚线边框
     * <li>DOUBLE
     * <P>
     * 双线边框
     * </ul>     
     */
    public static enum BorderStyle{
        NONE("NONE", "无边框")
        ,SOLID("SOLID", "实线边框")
        ,DOTTED("DOTTED", "点状边框")
        ,DASHED("DASHED", "虚线边框")
        ,DOUBLE("DOUBLE", "双线边框")
;
           
        public final String text;
        public final String value;
        
        private BorderStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BorderStyle from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "SOLID":
                    return SOLID;
                case "DOTTED":
                    return DOTTED;
                case "DASHED":
                    return DASHED;
                case "DOUBLE":
                    return DOUBLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台系统引用类型
     * <P>
     * <ul>
     * <li>SUBSYS
     * <P>
     * 平台子系统，平台提供的运行子系统
     * <li>DEVSYS
     * <P>
     * 开发系统组件，外部系统以组件包形式提供功能
     * <li>EXTENSION_DEVSYS
     * <P>
     * 开发系统组件（扩展）
     * <li>EXTENSION_DEVSYS_PSMODELTOOL
     * <P>
     * 开发系统组件（模型工具）
     * <li>EXTENSION_DEVSYS_WORKFLOW
     * <P>
     * 开发系统组件（工作流）
     * <li>DEVSYSCLOUD
     * <P>
     * 开发系统云服务，外部系统以微服务的形式提供功能
     * <li>CLOUDHUBSUBAPP
     * <P>
     * Cloud集成子应用
     * <li>ETLEXTRACT
     * <P>
     * ETL展开逻辑
     * <li>ETLTRANSFORM
     * <P>
     * ETL转换逻辑
     * <li>ETLLOAD
     * <P>
     * ETL加载逻辑
     * <li>ETLSOURCE
     * <P>
     * ETL数据源（模型同步）
     * <li>ETLMODEL
     * <P>
     * ETL模型（模型同步）
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SysRefType{
        SUBSYS("SUBSYS", "平台子系统")
        ,DEVSYS("DEVSYS", "开发系统组件")
        ,EXTENSION_DEVSYS("EXTENSION_DEVSYS", "开发系统组件（扩展）")
        ,EXTENSION_DEVSYS_PSMODELTOOL("EXTENSION_DEVSYS_PSMODELTOOL", "开发系统组件（模型工具）")
        ,EXTENSION_DEVSYS_WORKFLOW("EXTENSION_DEVSYS_WORKFLOW", "开发系统组件（工作流）")
        ,DEVSYSCLOUD("DEVSYSCLOUD", "开发系统云服务")
        ,CLOUDHUBSUBAPP("CLOUDHUBSUBAPP", "Cloud集成子应用")
        ,ETLEXTRACT("ETLEXTRACT", "ETL展开逻辑")
        ,ETLTRANSFORM("ETLTRANSFORM", "ETL转换逻辑")
        ,ETLLOAD("ETLLOAD", "ETL加载逻辑")
        ,ETLSOURCE("ETLSOURCE", "ETL数据源（模型同步）")
        ,ETLMODEL("ETLMODEL", "ETL模型（模型同步）")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SysRefType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRefType from(String value){
            switch(value){
                case "SUBSYS":
                    return SUBSYS;
                case "DEVSYS":
                    return DEVSYS;
                case "EXTENSION_DEVSYS":
                    return EXTENSION_DEVSYS;
                case "EXTENSION_DEVSYS_PSMODELTOOL":
                    return EXTENSION_DEVSYS_PSMODELTOOL;
                case "EXTENSION_DEVSYS_WORKFLOW":
                    return EXTENSION_DEVSYS_WORKFLOW;
                case "DEVSYSCLOUD":
                    return DEVSYSCLOUD;
                case "CLOUDHUBSUBAPP":
                    return CLOUDHUBSUBAPP;
                case "ETLEXTRACT":
                    return ETLEXTRACT;
                case "ETLTRANSFORM":
                    return ETLTRANSFORM;
                case "ETLLOAD":
                    return ETLLOAD;
                case "ETLSOURCE":
                    return ETLSOURCE;
                case "ETLMODEL":
                    return ETLMODEL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体功能配置类型（系统全局）
     * <P>
     * <ul>
     * <li>DATAAUDIT
     * <P>
     * 数据审计，定义系统的数据审计功能配置，包括了记录审计信息的实体等
     * <li>FILE
     * <P>
     * 附件存储，定义系统的附件功能配置，包括了附件的存储实体等
     * <li>APPCUSTOMIZE
     * <P>
     * 应用自定义，定义系统应用的自定义功能
     * <li>SAASADMIN
     * <P>
     * SaaS应用管理
     * <li>SAASUSERAUTH
     * <P>
     * SaaS用户授权（内置）
     * <li>SAASUSERAUTHSERVICE
     * <P>
     * SaaS用户授权服务（对外）
     * <li>SAASORG
     * <P>
     * SaaS组织功能（内置）
     * <li>SAASORGSERVICE
     * <P>
     * SaaS组织服务（对外）
     * <li>SAASWF
     * <P>
     * SaaS流程引擎功能（内置）
     * <li>SAASWFSERVICE
     * <P>
     * SaaS流程引擎服务（对外）
     * <li>SAASCORESERVICE
     * <P>
     * SaaS核心服务（对外）
     * <li>LOGLISTENER
     * <P>
     * 日志侦听，定义系统日志侦听器功能配置，包括了日志的存储实体等
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum SysUtilType{
        DATAAUDIT("DATAAUDIT", "数据审计")
        ,FILE("FILE", "附件存储")
        ,APPCUSTOMIZE("APPCUSTOMIZE", "应用自定义")
        ,SAASADMIN("SAASADMIN", "SaaS应用管理")
        ,SAASUSERAUTH("SAASUSERAUTH", "SaaS用户授权（内置）")
        ,SAASUSERAUTHSERVICE("SAASUSERAUTHSERVICE", "SaaS用户授权服务（对外）")
        ,SAASORG("SAASORG", "SaaS组织功能（内置）")
        ,SAASORGSERVICE("SAASORGSERVICE", "SaaS组织服务（对外）")
        ,SAASWF("SAASWF", "SaaS流程引擎功能（内置）")
        ,SAASWFSERVICE("SAASWFSERVICE", "SaaS流程引擎服务（对外）")
        ,SAASCORESERVICE("SAASCORESERVICE", "SaaS核心服务（对外）")
        ,LOGLISTENER("LOGLISTENER", "日志侦听")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private SysUtilType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysUtilType from(String value){
            switch(value){
                case "DATAAUDIT":
                    return DATAAUDIT;
                case "FILE":
                    return FILE;
                case "APPCUSTOMIZE":
                    return APPCUSTOMIZE;
                case "SAASADMIN":
                    return SAASADMIN;
                case "SAASUSERAUTH":
                    return SAASUSERAUTH;
                case "SAASUSERAUTHSERVICE":
                    return SAASUSERAUTHSERVICE;
                case "SAASORG":
                    return SAASORG;
                case "SAASORGSERVICE":
                    return SAASORGSERVICE;
                case "SAASWF":
                    return SAASWF;
                case "SAASWFSERVICE":
                    return SAASWFSERVICE;
                case "SAASCORESERVICE":
                    return SAASCORESERVICE;
                case "LOGLISTENER":
                    return LOGLISTENER;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体图表序列类型
     * <P>
     * <ul>
     * <li>AREA&nbsp;(area)
     * <P>
     * 区域图(Area)
     * <li>BAR&nbsp;(bar)
     * <P>
     * 条形图(Bar)
     * <li>BAR3D&nbsp;(bar3d)
     * <P>
     * 条形图3D(旧)(Bar3D)
     * <li>CANDLESTICK&nbsp;(candlestick)
     * <P>
     * K线图(Candlestick)
     * <li>GAUGE&nbsp;(gauge)
     * <P>
     * 仪表盘(Gauge)
     * <li>LINE&nbsp;(line)
     * <P>
     * 折线图(Line)
     * <li>PIE&nbsp;(pie)
     * <P>
     * 饼图(Pie)
     * <li>PIE3D&nbsp;(pie3d)
     * <P>
     * 饼图3D(旧)(Pie3D)
     * <li>RADAR&nbsp;(radar)
     * <P>
     * 雷达图(Radar)
     * <li>SCATTER&nbsp;(scatter)
     * <P>
     * 散点图(Scatter)
     * <li>COLUMN&nbsp;(column)
     * <P>
     * 柱状图(Column)
     * <li>FUNNEL&nbsp;(funnel)
     * <P>
     * 漏斗图(Funnel)
     * <li>MAP&nbsp;(map)
     * <P>
     * 地图(Map)
     * <li>CUSTOM&nbsp;(custom)
     * <P>
     * 自定义(Custom)
     * </ul>     
     */
    public static enum ChartType{
        AREA("area", "区域图(Area)")
        ,BAR("bar", "条形图(Bar)")
        ,BAR3D("bar3d", "条形图3D(旧)(Bar3D)")
        ,CANDLESTICK("candlestick", "K线图(Candlestick)")
        ,GAUGE("gauge", "仪表盘(Gauge)")
        ,LINE("line", "折线图(Line)")
        ,PIE("pie", "饼图(Pie)")
        ,PIE3D("pie3d", "饼图3D(旧)(Pie3D)")
        ,RADAR("radar", "雷达图(Radar)")
        ,SCATTER("scatter", "散点图(Scatter)")
        ,COLUMN("column", "柱状图(Column)")
        ,FUNNEL("funnel", "漏斗图(Funnel)")
        ,MAP("map", "地图(Map)")
        ,CUSTOM("custom", "自定义(Custom)")
;
           
        public final String text;
        public final String value;
        
        private ChartType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartType from(String value){
            switch(value){
                case "area":
                    return AREA;
                case "bar":
                    return BAR;
                case "bar3d":
                    return BAR3D;
                case "candlestick":
                    return CANDLESTICK;
                case "gauge":
                    return GAUGE;
                case "line":
                    return LINE;
                case "pie":
                    return PIE;
                case "pie3d":
                    return PIE3D;
                case "radar":
                    return RADAR;
                case "scatter":
                    return SCATTER;
                case "column":
                    return COLUMN;
                case "funnel":
                    return FUNNEL;
                case "map":
                    return MAP;
                case "custom":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体默认数据项，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>PICKUP&nbsp;(1)
     * <P>
     * 外键属性，实体中的外键属性，方便外部功能直接使用
     * <li>ACCESSACTION&nbsp;(1024)
     * <P>
     * 行数据操作标识，当前用户对行数据具备的操作能力清单，为界面行为提供界面控制支持
     * </ul>     
     */
    public static enum GridDefDataItem{
        PICKUP(1, "外键属性")
        ,ACCESSACTION(1024, "行数据操作标识")
;
           
        public final String text;
        public final int value;
        
        private GridDefDataItem(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridDefDataItem from(int value){
            switch(value){
                case 1:
                    return PICKUP;
                case 1024:
                    return ACCESSACTION;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格列分组项
     * <P>
     * <ul>
     * <li>GROUP1
     * <P>
     * 分组1
     * <li>GROUP2
     * <P>
     * 分组2
     * <li>GROUP3
     * <P>
     * 分组3
     * <li>GROUP4
     * <P>
     * 分组4
     * </ul>     
     */
    public static enum GridColGroupMode{
        GROUP1("GROUP1", "分组1")
        ,GROUP2("GROUP2", "分组2")
        ,GROUP3("GROUP3", "分组3")
        ,GROUP4("GROUP4", "分组4")
;
           
        public final String text;
        public final String value;
        
        private GridColGroupMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColGroupMode from(String value){
            switch(value){
                case "GROUP1":
                    return GROUP1;
                case "GROUP2":
                    return GROUP2;
                case "GROUP3":
                    return GROUP3;
                case "GROUP4":
                    return GROUP4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流参数值类型
     * <P>
     * <ul>
     * <li>DATASTREAM
     * <P>
     * 数据源属性，指定数据源属性
     * <li>DATASTREAM2
     * <P>
     * 数据源2属性，指定数据源2属性
     * <li>WEBCONTEXT
     * <P>
     * 网页请求上下文
     * <li>APPDATA
     * <P>
     * 当前应用数据
     * <li>APPLICATION
     * <P>
     * 系统全局对象
     * <li>SESSION
     * <P>
     * 用户全局对象
     * <li>DATACONTEXT
     * <P>
     * 数据上下文
     * <li>ENVPARAM
     * <P>
     * 当前环境参数
     * <li>VIEWPARAM
     * <P>
     * 当前视图参数
     * <li>NONEVALUE
     * <P>
     * 无值（NONE）
     * <li>NULLVALUE
     * <P>
     * 空值（NULL）
     * <li>SRCVALUE
     * <P>
     * 直接值
     * <li>EXPRESSION
     * <P>
     * 计算式
     * <li>COUNT
     * <P>
     * 数组数量
     * <li>AGGREGATION
     * <P>
     * 数组聚合计算
     * <li>SEQUENCE
     * <P>
     * 系统值序列
     * <li>TRANSLATOR
     * <P>
     * 系统值转换器
     * </ul>     
     */
    public static enum DEDataFlowParamValueType{
        DATASTREAM("DATASTREAM", "数据源属性")
        ,DATASTREAM2("DATASTREAM2", "数据源2属性")
        ,WEBCONTEXT("WEBCONTEXT", "网页请求上下文")
        ,APPDATA("APPDATA", "当前应用数据")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,SESSION("SESSION", "用户全局对象")
        ,DATACONTEXT("DATACONTEXT", "数据上下文")
        ,ENVPARAM("ENVPARAM", "当前环境参数")
        ,VIEWPARAM("VIEWPARAM", "当前视图参数")
        ,NONEVALUE("NONEVALUE", "无值（NONE）")
        ,NULLVALUE("NULLVALUE", "空值（NULL）")
        ,SRCVALUE("SRCVALUE", "直接值")
        ,EXPRESSION("EXPRESSION", "计算式")
        ,COUNT("COUNT", "数组数量")
        ,AGGREGATION("AGGREGATION", "数组聚合计算")
        ,SEQUENCE("SEQUENCE", "系统值序列")
        ,TRANSLATOR("TRANSLATOR", "系统值转换器")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowParamValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowParamValueType from(String value){
            switch(value){
                case "DATASTREAM":
                    return DATASTREAM;
                case "DATASTREAM2":
                    return DATASTREAM2;
                case "WEBCONTEXT":
                    return WEBCONTEXT;
                case "APPDATA":
                    return APPDATA;
                case "APPLICATION":
                    return APPLICATION;
                case "SESSION":
                    return SESSION;
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "ENVPARAM":
                    return ENVPARAM;
                case "VIEWPARAM":
                    return VIEWPARAM;
                case "NONEVALUE":
                    return NONEVALUE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "SRCVALUE":
                    return SRCVALUE;
                case "EXPRESSION":
                    return EXPRESSION;
                case "COUNT":
                    return COUNT;
                case "AGGREGATION":
                    return AGGREGATION;
                case "SEQUENCE":
                    return SEQUENCE;
                case "TRANSLATOR":
                    return TRANSLATOR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 聚合列类型
     * <P>
     * <ul>
     * <li>MEASURE
     * <P>
     * 指标
     * <li>DIMENSION
     * <P>
     * 维度
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum BIAggColumnType{
        MEASURE("MEASURE", "指标")
        ,DIMENSION("DIMENSION", "维度")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private BIAggColumnType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BIAggColumnType from(String value){
            switch(value){
                case "MEASURE":
                    return MEASURE;
                case "DIMENSION":
                    return DIMENSION;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 示例数据随机模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * </ul>     
     */
    public static enum SampleDataRandomMode{
        DEFAULT("DEFAULT", "默认")
;
           
        public final String text;
        public final String value;
        
        private SampleDataRandomMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SampleDataRandomMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程版本应用模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>PART
     * <P>
     * 流程片段
     * </ul>     
     */
    public static enum WFVerMode{
        DEFAULT("DEFAULT", "默认")
        ,PART("PART", "流程片段")
;
           
        public final String text;
        public final String value;
        
        private WFVerMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFVerMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "PART":
                    return PART;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用菜单项类型（静态）
     * <P>
     * <ul>
     * <li>SEPERATOR
     * <P>
     * 分隔项
     * <li>USERITEM
     * <P>
     * 用户自定义项
     * <li>APPMENUREF
     * <P>
     * 菜单引用
     * <li>MENUITEM
     * <P>
     * 菜单项
     * <li>RAWITEM
     * <P>
     * 直接内容项
     * </ul>     
     */
    public static enum AppMenuItemType{
        SEPERATOR("SEPERATOR", "分隔项")
        ,USERITEM("USERITEM", "用户自定义项")
        ,APPMENUREF("APPMENUREF", "菜单引用")
        ,MENUITEM("MENUITEM", "菜单项")
        ,RAWITEM("RAWITEM", "直接内容项")
;
           
        public final String text;
        public final String value;
        
        private AppMenuItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppMenuItemType from(String value){
            switch(value){
                case "SEPERATOR":
                    return SEPERATOR;
                case "USERITEM":
                    return USERITEM;
                case "APPMENUREF":
                    return APPMENUREF;
                case "MENUITEM":
                    return MENUITEM;
                case "RAWITEM":
                    return RAWITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据变更日志类型，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无日志
     * <li>SELF_SYNC&nbsp;(2)
     * <P>
     * 单项数据（同步），以同步的方式日志当前数据的变更记录，日志操作在同一个事务中
     * <li>SELF_RELATED_SYNC&nbsp;(3)
     * <P>
     * 单项数据（含关联数据）（同步），以同步的方式日志当前数据的变更记录，包括关联数据，日志操作在同一个事务中
     * <li>SELF_ASYNC&nbsp;(4)
     * <P>
     * 单项数据（异步），以异步的方式日志当前数据的变更记录，性能更优，但存在日志与数据不一致的情况
     * <li>SELF_RELATED_ASYNC&nbsp;(5)
     * <P>
     * 单项数据（含关联数据）（异步），以异步的方式日志当前数据的变更记录，包括关联数据，性能更优，但存在日志与数据不一致的情况
     * </ul>     
     */
    public static enum DEDataChgLogMode{
        NONE(0, "无日志")
        ,SELF_SYNC(2, "单项数据（同步）")
        ,SELF_RELATED_SYNC(3, "单项数据（含关联数据）（同步）")
        ,SELF_ASYNC(4, "单项数据（异步）")
        ,SELF_RELATED_ASYNC(5, "单项数据（含关联数据）（异步）")
;
           
        public final String text;
        public final int value;
        
        private DEDataChgLogMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataChgLogMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 2:
                    return SELF_SYNC;
                case 3:
                    return SELF_RELATED_SYNC;
                case 4:
                    return SELF_ASYNC;
                case 5:
                    return SELF_RELATED_ASYNC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 代码表类型
     * <P>
     * <ul>
     * <li>STATIC
     * <P>
     * 静态，代码项为静态定义
     * <li>DYNAMIC
     * <P>
     * 动态，代码项定义来自外部存储，使用时进行加载
     * <li>PREDEFINED
     * <P>
     * 预定义，特定功能的的代码表，一般由内置程序提供
     * </ul>     
     */
    public static enum CodeListType{
        STATIC("STATIC", "静态")
        ,DYNAMIC("DYNAMIC", "动态")
        ,PREDEFINED("PREDEFINED", "预定义")
;
           
        public final String text;
        public final String value;
        
        private CodeListType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CodeListType from(String value){
            switch(value){
                case "STATIC":
                    return STATIC;
                case "DYNAMIC":
                    return DYNAMIC;
                case "PREDEFINED":
                    return PREDEFINED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表格聚合模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无聚合
     * <li>PAGE
     * <P>
     * 当前页本地，仅聚合当前分页显示数据，本地处理
     * <li>ALL
     * <P>
     * 全部远程，聚合符合条件的全部数据，远端处理
     * </ul>     
     */
    public static enum GridAggMode{
        NONE("NONE", "无聚合")
        ,PAGE("PAGE", "当前页本地")
        ,ALL("ALL", "全部远程")
;
           
        public final String text;
        public final String value;
        
        private GridAggMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridAggMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "PAGE":
                    return PAGE;
                case "ALL":
                    return ALL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体主状态行为允许模式
     * <P>
     * <ul>
     * <li>ALLOW
     * <P>
     * 允许，允许模式
     * <li>DENY
     * <P>
     * 拒绝，拒绝模式
     * </ul>     
     */
    public static enum DEMSActionMode{
        ALLOW("ALLOW", "允许")
        ,DENY("DENY", "拒绝")
;
           
        public final String text;
        public final String value;
        
        private DEMSActionMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMSActionMode from(String value){
            switch(value){
                case "ALLOW":
                    return ALLOW;
                case "DENY":
                    return DENY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图表坐标轴数据显示方式，数值项
     * <P>
     * <ul>
     * <li>UNDEFINED&nbsp;(0)
     * <P>
     * 未定义
     * <li>LONGITUDINAL&nbsp;(1)
     * <P>
     * 纵
     * <li>HORIZONTAL&nbsp;(2)
     * <P>
     * 横
     * <li>OBLIQUE&nbsp;(3)
     * <P>
     * 斜
     * </ul>     
     */
    public static enum ChartAxisDataShowMode{
        UNDEFINED(0, "未定义")
        ,LONGITUDINAL(1, "纵")
        ,HORIZONTAL(2, "横")
        ,OBLIQUE(3, "斜")
;
           
        public final String text;
        public final int value;
        
        private ChartAxisDataShowMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartAxisDataShowMode from(int value){
            switch(value){
                case 0:
                    return UNDEFINED;
                case 1:
                    return LONGITUDINAL;
                case 2:
                    return HORIZONTAL;
                case 3:
                    return OBLIQUE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单成员逻辑类型
     * <P>
     * <ul>
     * <li>PANELVISIBLE
     * <P>
     * 面板显示，表单成员容器的动态显示逻辑，控制成员是否显示
     * <li>ITEMENABLE
     * <P>
     * 表单项启用，表单项的动态启用逻辑，控制表单项及其编辑器的启用禁用状态
     * <li>ITEMBLANK
     * <P>
     * 表单项空输入，表单项的动态空输入逻辑，控制表单项及其编辑器是否允许空输入
     * <li>SCRIPTCODE_CHANGE
     * <P>
     * 表单项值变更（脚本处理）
     * <li>SCRIPTCODE_CLICK
     * <P>
     * 表单项点击（脚本处理）
     * <li>SCRIPTCODE_FOCUS
     * <P>
     * 表单项获取焦点（脚本处理）
     * <li>SCRIPTCODE_BLUR
     * <P>
     * 表单项失去焦点（脚本处理）
     * </ul>     
     */
    public static enum CtrlDetailLogicCat{
        PANELVISIBLE("PANELVISIBLE", "面板显示")
        ,ITEMENABLE("ITEMENABLE", "表单项启用")
        ,ITEMBLANK("ITEMBLANK", "表单项空输入")
        ,SCRIPTCODE_CHANGE("SCRIPTCODE_CHANGE", "表单项值变更（脚本处理）")
        ,SCRIPTCODE_CLICK("SCRIPTCODE_CLICK", "表单项点击（脚本处理）")
        ,SCRIPTCODE_FOCUS("SCRIPTCODE_FOCUS", "表单项获取焦点（脚本处理）")
        ,SCRIPTCODE_BLUR("SCRIPTCODE_BLUR", "表单项失去焦点（脚本处理）")
;
           
        public final String text;
        public final String value;
        
        private CtrlDetailLogicCat(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlDetailLogicCat from(String value){
            switch(value){
                case "PANELVISIBLE":
                    return PANELVISIBLE;
                case "ITEMENABLE":
                    return ITEMENABLE;
                case "ITEMBLANK":
                    return ITEMBLANK;
                case "SCRIPTCODE_CHANGE":
                    return SCRIPTCODE_CHANGE;
                case "SCRIPTCODE_CLICK":
                    return SCRIPTCODE_CLICK;
                case "SCRIPTCODE_FOCUS":
                    return SCRIPTCODE_FOCUS;
                case "SCRIPTCODE_BLUR":
                    return SCRIPTCODE_BLUR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据流连接类型
     * <P>
     * <ul>
     * <li>INNER
     * <P>
     * 内连接，返回两个数据源中满足连接条件的匹配行。只有在连接列上存在匹配的值时，才会返回结果。连接条件通常使用 ON 关键字指定
     * <li>LEFT
     * <P>
     * 左连接，返回数据源1的所有行，以及数据源2中满足连接条件的匹配行。如果数据源2中没有匹配的行，则返回 NULL 值
     * <li>RIGHT
     * <P>
     * 右连接，返回数据源2的所有行，以及数据源1中满足连接条件的匹配行。如果数据源1中没有匹配的行，则返回 NULL 值
     * <li>FULL
     * <P>
     * 全连接，返回数据源1和数据源2中的所有行，无论是否满足连接条件。如果某个数据源中没有匹配的行，则另一个数据源中的列将为 NULL 值
     * </ul>     
     */
    public static enum DEDataFlowJoinType{
        INNER("INNER", "内连接")
        ,LEFT("LEFT", "左连接")
        ,RIGHT("RIGHT", "右连接")
        ,FULL("FULL", "全连接")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowJoinType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowJoinType from(String value){
            switch(value){
                case "INNER":
                    return INNER;
                case "LEFT":
                    return LEFT;
                case "RIGHT":
                    return RIGHT;
                case "FULL":
                    return FULL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统引擎BUG修复，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>GRIDDATAITEMNAME&nbsp;(1)
     * <P>
     * 表格自定义数据项名称，修复表格数据项名称无法指定，必须与数据列一致的问题
     * <li>MDCTRLWFDATAITEMS&nbsp;(4)
     * <P>
     * 多数据部件工作流数据项，修复多数据部件未输出工作流相关数据项的问题
     * <li>GRIDCOLDATAITEM&nbsp;(2)
     * <P>
     * 表格属性列指定数据项，修复表格属性列无法指定数据项问题
     * <li>ORACLEDATETIME&nbsp;(8)
     * <P>
     * Oracle日期时间类型，修复Oracle、PostgreSQL日期类型使用DATE类型导致的精度问题
     * <li>PICKUPTEXTALLOWEMPTY&nbsp;(16)
     * <P>
     * 外键文本属性界面空输入，修复外键文本属性在表单项及表格编辑项未使用外键值属性允许为空逻辑的问题
     * <li>ACMODEITEM&nbsp;(32)
     * <P>
     * 自填模式默认数据项，修复自填模式无法定义默认数据项的问题
     * <li>DEFSFITEMCAPTION&nbsp;(64)
     * <P>
     * 属性搜索项自定义标题，修复属性搜索项自定义标题无效的问题
     * <li>V2MODELRT&nbsp;(128)
     * <P>
     * V2模型运行时模式
     * <li>SERVICEAPIMODELEX&nbsp;(256)
     * <P>
     * 服务接口模型增强，增强服务接口模型控制，包括了无默认代码标识，行为默认请求模式等
     * <li>DEFSEARCHMODEMODELEX&nbsp;(512)
     * <P>
     * 属性搜索模式模型增强，属性搜索模式增强，IN，NOTIN，EXISTS，NOTEXISTS 默认使用数组传递
     * <li>UIMODELEX&nbsp;(1024)
     * <P>
     * 界面模型增强，界面模型增强，面向DSL运行时进行增强
     * <li>CODENAMECAPITALIZE&nbsp;(2048)
     * <P>
     * 代码名首字母自动大写，代码名首字母大写
     * <li>DESAVEACTIONEX&nbsp;(8192)
     * <P>
     * 实体保存行为增强，实体保存行为增强
（1）新的行为模式（SAVE）
（2）默认操作标识（CREATE）
     * </ul>     
     */
    public static enum EngineBugFix{
        GRIDDATAITEMNAME(1, "表格自定义数据项名称")
        ,MDCTRLWFDATAITEMS(4, "多数据部件工作流数据项")
        ,GRIDCOLDATAITEM(2, "表格属性列指定数据项")
        ,ORACLEDATETIME(8, "Oracle日期时间类型")
        ,PICKUPTEXTALLOWEMPTY(16, "外键文本属性界面空输入")
        ,ACMODEITEM(32, "自填模式默认数据项")
        ,DEFSFITEMCAPTION(64, "属性搜索项自定义标题")
        ,V2MODELRT(128, "V2模型运行时模式")
        ,SERVICEAPIMODELEX(256, "服务接口模型增强")
        ,DEFSEARCHMODEMODELEX(512, "属性搜索模式模型增强")
        ,UIMODELEX(1024, "界面模型增强")
        ,CODENAMECAPITALIZE(2048, "代码名首字母自动大写")
        ,DESAVEACTIONEX(8192, "实体保存行为增强")
;
           
        public final String text;
        public final int value;
        
        private EngineBugFix(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EngineBugFix from(int value){
            switch(value){
                case 1:
                    return GRIDDATAITEMNAME;
                case 4:
                    return MDCTRLWFDATAITEMS;
                case 2:
                    return GRIDCOLDATAITEM;
                case 8:
                    return ORACLEDATETIME;
                case 16:
                    return PICKUPTEXTALLOWEMPTY;
                case 32:
                    return ACMODEITEM;
                case 64:
                    return DEFSFITEMCAPTION;
                case 128:
                    return V2MODELRT;
                case 256:
                    return SERVICEAPIMODELEX;
                case 512:
                    return DEFSEARCHMODEMODELEX;
                case 1024:
                    return UIMODELEX;
                case 2048:
                    return CODENAMECAPITALIZE;
                case 8192:
                    return DESAVEACTIONEX;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体搜索表单按钮位置
     * <P>
     * <ul>
     * <li>RIGHT
     * <P>
     * 右边
     * <li>BOTTOM
     * <P>
     * 下方
     * </ul>     
     */
    public static enum SearchFormButtonPos{
        RIGHT("RIGHT", "右边")
        ,BOTTOM("BOTTOM", "下方")
;
           
        public final String text;
        public final String value;
        
        private SearchFormButtonPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchFormButtonPos from(String value){
            switch(value){
                case "RIGHT":
                    return RIGHT;
                case "BOTTOM":
                    return BOTTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树视图节点选择模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 否，不选择节点
     * <li>YES&nbsp;(1)
     * <P>
     * 是，自动选择节点
     * <li>FIRSTONLY&nbsp;(2)
     * <P>
     * 是，仅首节点，自动选择首节点
     * </ul>     
     */
    public static enum TreeNodeSelectMode{
        NO(0, "否")
        ,YES(1, "是")
        ,FIRSTONLY(2, "是，仅首节点")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeSelectMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeSelectMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return YES;
                case 2:
                    return FIRSTONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据聚合模式
     * <P>
     * <ul>
     * <li>SUM
     * <P>
     * 合计
     * <li>AVG
     * <P>
     * 平均
     * <li>MAX
     * <P>
     * 最大值
     * <li>MIN
     * <P>
     * 最小值
     * <li>COUNT
     * <P>
     * 计数
     * <li>EXISTS
     * <P>
     * 存在，从实体存在，1表示存在，0表示不存在
     * <li>NOTEXISTS
     * <P>
     * 不存在，从实体不存在，1表示不存在，0表示存在
     * <li>GROUP
     * <P>
     * 分组项
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum AggMode{
        SUM("SUM", "合计")
        ,AVG("AVG", "平均")
        ,MAX("MAX", "最大值")
        ,MIN("MIN", "最小值")
        ,COUNT("COUNT", "计数")
        ,EXISTS("EXISTS", "存在")
        ,NOTEXISTS("NOTEXISTS", "不存在")
        ,GROUP("GROUP", "分组项")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private AggMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AggMode from(String value){
            switch(value){
                case "SUM":
                    return SUM;
                case "AVG":
                    return AVG;
                case "MAX":
                    return MAX;
                case "MIN":
                    return MIN;
                case "COUNT":
                    return COUNT;
                case "EXISTS":
                    return EXISTS;
                case "NOTEXISTS":
                    return NOTEXISTS;
                case "GROUP":
                    return GROUP;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单分组快捷操作，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 新建，界面分组提供新建操作，一般应用于分组包含多数据界面部件场合，调用多数据界面部件提供的新建操作
     * <li>MORE&nbsp;(2)
     * <P>
     * 更多操作，界面分组提供更多操作，一般应用于分组包含多数据界面部件场合，调用多数据部件界面提供的显示更多操作功能
     * <li>REFRESH&nbsp;(4)
     * <P>
     * 刷新，界面分组提供刷新操作，一般应用于分组包含多数据界面部件场合，调用多数据部件界面提供的刷新操作
     * </ul>     
     */
    public static enum GroupBarMoreAction{
        CREATE(1, "新建")
        ,MORE(2, "更多操作")
        ,REFRESH(4, "刷新")
;
           
        public final String text;
        public final int value;
        
        private GroupBarMoreAction(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GroupBarMoreAction from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return MORE;
                case 4:
                    return REFRESH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部署系统类型
     * <P>
     * <ul>
     * <li>ORGWFSYS
     * <P>
     * 机构流程运行系统
     * <li>ORGSECTORWFSYS
     * <P>
     * 部门流程运行系统
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DeploySysType{
        ORGWFSYS("ORGWFSYS", "机构流程运行系统")
        ,ORGSECTORWFSYS("ORGSECTORWFSYS", "部门流程运行系统")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private DeploySysType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DeploySysType from(String value){
            switch(value){
                case "ORGWFSYS":
                    return ORGWFSYS;
                case "ORGSECTORWFSYS":
                    return ORGSECTORWFSYS;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体逻辑处理节点类型（全部，包括界面逻辑）
     * <P>
     * <ul>
     * <li>BEGIN
     * <P>
     * 开始
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>PREPAREPARAM
     * <P>
     * 准备参数
     * <li>RESETPARAM
     * <P>
     * 重置参数，重置目标参数对象
     * <li>COPYPARAM
     * <P>
     * 拷贝参数，将源参数对象拷贝至目标参数对象
     * <li>BINDPARAM
     * <P>
     * 绑定参数，处理逻辑变量绑定指定变量
     * <li>APPENDPARAM
     * <P>
     * 附加到数组参数
     * <li>SORTPARAM
     * <P>
     * 排序数组参数
     * <li>RENEWPARAM
     * <P>
     * 重新建立参数
     * <li>FILTERPARAM
     * <P>
     * 过滤数组参数，使用数据查询逻辑进行过滤
     * <li>FILTERPARAM2
     * <P>
     * 过滤数组参数2，使用数据集逻辑进行过滤，数据集包含多个数据查询，数据查询之间使用OR逻辑
     * <li>MERGEPARAM
     * <P>
     * 合并数组参数，合并两个数组对象，将源数组合并至目标数组，如指定返回参数则将结果放入返回参数中
     * <li>AGGREGATEPARAM
     * <P>
     * 聚合数组参数，聚合源数组参数合并至目标数组
     * <li>LOOPSUBCALL
     * <P>
     * 循环子调用，循环源列表参数对象并绑定至目标参数对象，执行子调用处理
     * <li>RAWSQLCALL
     * <P>
     * 直接SQL调用
     * <li>RAWSQLANDLOOPCALL
     * <P>
     * 直接SQL并循环调用
     * <li>RAWWEBCALL
     * <P>
     * 直接Web调用
     * <li>STARTWF
     * <P>
     * 启动流程
     * <li>CANCELWF
     * <P>
     * 取消流程
     * <li>THROWEXCEPTION
     * <P>
     * 抛出异常
     * <li>SFPLUGIN
     * <P>
     * 系统服务插件
     * <li>RAWSFCODE
     * <P>
     * 直接后台代码
     * <li>SYSLOGIC
     * <P>
     * 系统逻辑处理
     * <li>SYSUTIL
     * <P>
     * 系统功能组件处理
     * <li>PREPAREJSPARAM
     * <P>
     * 准备参数
     * <li>VIEWCTRLINVOKE
     * <P>
     * 视图部件调用
     * <li>RAWJSCODE
     * <P>
     * 直接前台代码
     * <li>MSGBOX
     * <P>
     * 消息弹窗
     * <li>PFPLUGIN
     * <P>
     * 前端插件调用
     * <li>DEUIACTION
     * <P>
     * 实体界面行为调用
     * <li>MAINSTATE
     * <P>
     * 主状态
     * <li>DEDATASET
     * <P>
     * 实体数据集
     * <li>DENOTIFY
     * <P>
     * 实体通知
     * <li>DELOGIC
     * <P>
     * 实体逻辑
     * <li>COMMIT
     * <P>
     * 提交事务
     * <li>ROLLBACK
     * <P>
     * 回滚事务
     * <li>DEBUGPARAM
     * <P>
     * 调试逻辑参数
     * <li>DEDATAQUERY
     * <P>
     * 实体数据查询
     * <li>DEPRINT
     * <P>
     * 实体打印
     * <li>DEREPORT
     * <P>
     * 实体报表
     * <li>DEDTSQUEUE
     * <P>
     * 实体异步处理队列
     * <li>DEDATASYNC
     * <P>
     * 实体数据同步
     * <li>DEDATAIMP
     * <P>
     * 实体数据导入
     * <li>DEDATAEXP
     * <P>
     * 实体数据导出
     * <li>DEDATAAUDIT
     * <P>
     * 实体访问审计
     * <li>SUBSYSSAMETHOD
     * <P>
     * 外部服务接口方法
     * <li>SYSDATASYNCAGENTOUT
     * <P>
     * 系统数据同步代理输出
     * <li>SYSDBTABLEACTION
     * <P>
     * 系统数据库表操作
     * <li>SYSBDTABLEACTION
     * <P>
     * 系统大数据表操作
     * <li>SYSSEARCHDOCACTION
     * <P>
     * 系统检索文档操作
     * <li>SYSBIREPORT
     * <P>
     * 系统智能报表
     * <li>END
     * <P>
     * 结束
     * </ul>     
     */
    public static enum LogicNodeType{
        BEGIN("BEGIN", "开始")
        ,DEACTION("DEACTION", "实体行为")
        ,PREPAREPARAM("PREPAREPARAM", "准备参数")
        ,RESETPARAM("RESETPARAM", "重置参数")
        ,COPYPARAM("COPYPARAM", "拷贝参数")
        ,BINDPARAM("BINDPARAM", "绑定参数")
        ,APPENDPARAM("APPENDPARAM", "附加到数组参数")
        ,SORTPARAM("SORTPARAM", "排序数组参数")
        ,RENEWPARAM("RENEWPARAM", "重新建立参数")
        ,FILTERPARAM("FILTERPARAM", "过滤数组参数")
        ,FILTERPARAM2("FILTERPARAM2", "过滤数组参数2")
        ,MERGEPARAM("MERGEPARAM", "合并数组参数")
        ,AGGREGATEPARAM("AGGREGATEPARAM", "聚合数组参数")
        ,LOOPSUBCALL("LOOPSUBCALL", "循环子调用")
        ,RAWSQLCALL("RAWSQLCALL", "直接SQL调用")
        ,RAWSQLANDLOOPCALL("RAWSQLANDLOOPCALL", "直接SQL并循环调用")
        ,RAWWEBCALL("RAWWEBCALL", "直接Web调用")
        ,STARTWF("STARTWF", "启动流程")
        ,CANCELWF("CANCELWF", "取消流程")
        ,THROWEXCEPTION("THROWEXCEPTION", "抛出异常")
        ,SFPLUGIN("SFPLUGIN", "系统服务插件")
        ,RAWSFCODE("RAWSFCODE", "直接后台代码")
        ,SYSLOGIC("SYSLOGIC", "系统逻辑处理")
        ,SYSUTIL("SYSUTIL", "系统功能组件处理")
        ,PREPAREJSPARAM("PREPAREJSPARAM", "准备参数")
        ,VIEWCTRLINVOKE("VIEWCTRLINVOKE", "视图部件调用")
        ,RAWJSCODE("RAWJSCODE", "直接前台代码")
        ,MSGBOX("MSGBOX", "消息弹窗")
        ,PFPLUGIN("PFPLUGIN", "前端插件调用")
        ,DEUIACTION("DEUIACTION", "实体界面行为调用")
        ,MAINSTATE("MAINSTATE", "主状态")
        ,DEDATASET("DEDATASET", "实体数据集")
        ,DENOTIFY("DENOTIFY", "实体通知")
        ,DELOGIC("DELOGIC", "实体逻辑")
        ,COMMIT("COMMIT", "提交事务")
        ,ROLLBACK("ROLLBACK", "回滚事务")
        ,DEBUGPARAM("DEBUGPARAM", "调试逻辑参数")
        ,DEDATAQUERY("DEDATAQUERY", "实体数据查询")
        ,DEPRINT("DEPRINT", "实体打印")
        ,DEREPORT("DEREPORT", "实体报表")
        ,DEDTSQUEUE("DEDTSQUEUE", "实体异步处理队列")
        ,DEDATASYNC("DEDATASYNC", "实体数据同步")
        ,DEDATAIMP("DEDATAIMP", "实体数据导入")
        ,DEDATAEXP("DEDATAEXP", "实体数据导出")
        ,DEDATAAUDIT("DEDATAAUDIT", "实体访问审计")
        ,SUBSYSSAMETHOD("SUBSYSSAMETHOD", "外部服务接口方法")
        ,SYSDATASYNCAGENTOUT("SYSDATASYNCAGENTOUT", "系统数据同步代理输出")
        ,SYSDBTABLEACTION("SYSDBTABLEACTION", "系统数据库表操作")
        ,SYSBDTABLEACTION("SYSBDTABLEACTION", "系统大数据表操作")
        ,SYSSEARCHDOCACTION("SYSSEARCHDOCACTION", "系统检索文档操作")
        ,SYSBIREPORT("SYSBIREPORT", "系统智能报表")
        ,END("END", "结束")
;
           
        public final String text;
        public final String value;
        
        private LogicNodeType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LogicNodeType from(String value){
            switch(value){
                case "BEGIN":
                    return BEGIN;
                case "DEACTION":
                    return DEACTION;
                case "PREPAREPARAM":
                    return PREPAREPARAM;
                case "RESETPARAM":
                    return RESETPARAM;
                case "COPYPARAM":
                    return COPYPARAM;
                case "BINDPARAM":
                    return BINDPARAM;
                case "APPENDPARAM":
                    return APPENDPARAM;
                case "SORTPARAM":
                    return SORTPARAM;
                case "RENEWPARAM":
                    return RENEWPARAM;
                case "FILTERPARAM":
                    return FILTERPARAM;
                case "FILTERPARAM2":
                    return FILTERPARAM2;
                case "MERGEPARAM":
                    return MERGEPARAM;
                case "AGGREGATEPARAM":
                    return AGGREGATEPARAM;
                case "LOOPSUBCALL":
                    return LOOPSUBCALL;
                case "RAWSQLCALL":
                    return RAWSQLCALL;
                case "RAWSQLANDLOOPCALL":
                    return RAWSQLANDLOOPCALL;
                case "RAWWEBCALL":
                    return RAWWEBCALL;
                case "STARTWF":
                    return STARTWF;
                case "CANCELWF":
                    return CANCELWF;
                case "THROWEXCEPTION":
                    return THROWEXCEPTION;
                case "SFPLUGIN":
                    return SFPLUGIN;
                case "RAWSFCODE":
                    return RAWSFCODE;
                case "SYSLOGIC":
                    return SYSLOGIC;
                case "SYSUTIL":
                    return SYSUTIL;
                case "PREPAREJSPARAM":
                    return PREPAREJSPARAM;
                case "VIEWCTRLINVOKE":
                    return VIEWCTRLINVOKE;
                case "RAWJSCODE":
                    return RAWJSCODE;
                case "MSGBOX":
                    return MSGBOX;
                case "PFPLUGIN":
                    return PFPLUGIN;
                case "DEUIACTION":
                    return DEUIACTION;
                case "MAINSTATE":
                    return MAINSTATE;
                case "DEDATASET":
                    return DEDATASET;
                case "DENOTIFY":
                    return DENOTIFY;
                case "DELOGIC":
                    return DELOGIC;
                case "COMMIT":
                    return COMMIT;
                case "ROLLBACK":
                    return ROLLBACK;
                case "DEBUGPARAM":
                    return DEBUGPARAM;
                case "DEDATAQUERY":
                    return DEDATAQUERY;
                case "DEPRINT":
                    return DEPRINT;
                case "DEREPORT":
                    return DEREPORT;
                case "DEDTSQUEUE":
                    return DEDTSQUEUE;
                case "DEDATASYNC":
                    return DEDATASYNC;
                case "DEDATAIMP":
                    return DEDATAIMP;
                case "DEDATAEXP":
                    return DEDATAEXP;
                case "DEDATAAUDIT":
                    return DEDATAAUDIT;
                case "SUBSYSSAMETHOD":
                    return SUBSYSSAMETHOD;
                case "SYSDATASYNCAGENTOUT":
                    return SYSDATASYNCAGENTOUT;
                case "SYSDBTABLEACTION":
                    return SYSDBTABLEACTION;
                case "SYSBDTABLEACTION":
                    return SYSBDTABLEACTION;
                case "SYSSEARCHDOCACTION":
                    return SYSSEARCHDOCACTION;
                case "SYSBIREPORT":
                    return SYSBIREPORT;
                case "END":
                    return END;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 开发系统引用模式
     * <P>
     * <ul>
     * <li>DEVSYS01
     * <P>
     * 开发系统引用1
     * <li>DEVSYS02
     * <P>
     * 开发系统引用2
     * <li>DEVSYS03
     * <P>
     * 开发系统引用3
     * <li>DEVSYS04
     * <P>
     * 开发系统引用4
     * <li>DEVSYS05
     * <P>
     * 开发系统引用5
     * <li>DEVSYS06
     * <P>
     * 开发系统引用6
     * <li>DEVSYS07
     * <P>
     * 开发系统引用7
     * <li>DEVSYS08
     * <P>
     * 开发系统引用8
     * <li>DEVSYS09
     * <P>
     * 开发系统引用9
     * <li>DEVSYS10
     * <P>
     * 开发系统引用10
     * <li>DEVSYS11
     * <P>
     * 开发系统引用11
     * <li>DEVSYS12
     * <P>
     * 开发系统引用12
     * <li>DEVSYS13
     * <P>
     * 开发系统引用13
     * <li>DEVSYS14
     * <P>
     * 开发系统引用14
     * <li>DEVSYS15
     * <P>
     * 开发系统引用15
     * <li>DEVSYS16
     * <P>
     * 开发系统引用16
     * <li>DEVSYS17
     * <P>
     * 开发系统引用17
     * <li>DEVSYS18
     * <P>
     * 开发系统引用18
     * <li>DEVSYS19
     * <P>
     * 开发系统引用19
     * <li>DEVSYS20
     * <P>
     * 开发系统引用20
     * <li>DEVSYS21
     * <P>
     * 开发系统引用21
     * <li>DEVSYS22
     * <P>
     * 开发系统引用22
     * <li>DEVSYS23
     * <P>
     * 开发系统引用23
     * <li>DEVSYS24
     * <P>
     * 开发系统引用24
     * <li>DEVSYS25
     * <P>
     * 开发系统引用25
     * <li>DEVSYS26
     * <P>
     * 开发系统引用26
     * <li>DEVSYS27
     * <P>
     * 开发系统引用27
     * <li>DEVSYS28
     * <P>
     * 开发系统引用28
     * <li>DEVSYS29
     * <P>
     * 开发系统引用29
     * <li>DEVSYS30
     * <P>
     * 开发系统引用30
     * <li>DEVSYS31
     * <P>
     * 开发系统引用31
     * <li>DEVSYS32
     * <P>
     * 开发系统引用32
     * <li>DEVSYS33
     * <P>
     * 开发系统引用33
     * <li>DEVSYS34
     * <P>
     * 开发系统引用34
     * <li>DEVSYS35
     * <P>
     * 开发系统引用35
     * <li>DEVSYS36
     * <P>
     * 开发系统引用36
     * <li>DEVSYS37
     * <P>
     * 开发系统引用37
     * <li>DEVSYS38
     * <P>
     * 开发系统引用38
     * <li>DEVSYS39
     * <P>
     * 开发系统引用39
     * <li>DEVSYS40
     * <P>
     * 开发系统引用40
     * <li>DEVSYS41
     * <P>
     * 开发系统引用41
     * <li>DEVSYS42
     * <P>
     * 开发系统引用42
     * <li>DEVSYS43
     * <P>
     * 开发系统引用43
     * <li>DEVSYS44
     * <P>
     * 开发系统引用44
     * <li>DEVSYS45
     * <P>
     * 开发系统引用45
     * <li>DEVSYS46
     * <P>
     * 开发系统引用46
     * <li>DEVSYS47
     * <P>
     * 开发系统引用47
     * <li>DEVSYS48
     * <P>
     * 开发系统引用48
     * <li>DEVSYS49
     * <P>
     * 开发系统引用49
     * <li>DEVSYS50
     * <P>
     * 开发系统引用50
     * </ul>     
     */
    public static enum DevSysRefMode{
        DEVSYS01("DEVSYS01", "开发系统引用1")
        ,DEVSYS02("DEVSYS02", "开发系统引用2")
        ,DEVSYS03("DEVSYS03", "开发系统引用3")
        ,DEVSYS04("DEVSYS04", "开发系统引用4")
        ,DEVSYS05("DEVSYS05", "开发系统引用5")
        ,DEVSYS06("DEVSYS06", "开发系统引用6")
        ,DEVSYS07("DEVSYS07", "开发系统引用7")
        ,DEVSYS08("DEVSYS08", "开发系统引用8")
        ,DEVSYS09("DEVSYS09", "开发系统引用9")
        ,DEVSYS10("DEVSYS10", "开发系统引用10")
        ,DEVSYS11("DEVSYS11", "开发系统引用11")
        ,DEVSYS12("DEVSYS12", "开发系统引用12")
        ,DEVSYS13("DEVSYS13", "开发系统引用13")
        ,DEVSYS14("DEVSYS14", "开发系统引用14")
        ,DEVSYS15("DEVSYS15", "开发系统引用15")
        ,DEVSYS16("DEVSYS16", "开发系统引用16")
        ,DEVSYS17("DEVSYS17", "开发系统引用17")
        ,DEVSYS18("DEVSYS18", "开发系统引用18")
        ,DEVSYS19("DEVSYS19", "开发系统引用19")
        ,DEVSYS20("DEVSYS20", "开发系统引用20")
        ,DEVSYS21("DEVSYS21", "开发系统引用21")
        ,DEVSYS22("DEVSYS22", "开发系统引用22")
        ,DEVSYS23("DEVSYS23", "开发系统引用23")
        ,DEVSYS24("DEVSYS24", "开发系统引用24")
        ,DEVSYS25("DEVSYS25", "开发系统引用25")
        ,DEVSYS26("DEVSYS26", "开发系统引用26")
        ,DEVSYS27("DEVSYS27", "开发系统引用27")
        ,DEVSYS28("DEVSYS28", "开发系统引用28")
        ,DEVSYS29("DEVSYS29", "开发系统引用29")
        ,DEVSYS30("DEVSYS30", "开发系统引用30")
        ,DEVSYS31("DEVSYS31", "开发系统引用31")
        ,DEVSYS32("DEVSYS32", "开发系统引用32")
        ,DEVSYS33("DEVSYS33", "开发系统引用33")
        ,DEVSYS34("DEVSYS34", "开发系统引用34")
        ,DEVSYS35("DEVSYS35", "开发系统引用35")
        ,DEVSYS36("DEVSYS36", "开发系统引用36")
        ,DEVSYS37("DEVSYS37", "开发系统引用37")
        ,DEVSYS38("DEVSYS38", "开发系统引用38")
        ,DEVSYS39("DEVSYS39", "开发系统引用39")
        ,DEVSYS40("DEVSYS40", "开发系统引用40")
        ,DEVSYS41("DEVSYS41", "开发系统引用41")
        ,DEVSYS42("DEVSYS42", "开发系统引用42")
        ,DEVSYS43("DEVSYS43", "开发系统引用43")
        ,DEVSYS44("DEVSYS44", "开发系统引用44")
        ,DEVSYS45("DEVSYS45", "开发系统引用45")
        ,DEVSYS46("DEVSYS46", "开发系统引用46")
        ,DEVSYS47("DEVSYS47", "开发系统引用47")
        ,DEVSYS48("DEVSYS48", "开发系统引用48")
        ,DEVSYS49("DEVSYS49", "开发系统引用49")
        ,DEVSYS50("DEVSYS50", "开发系统引用50")
;
           
        public final String text;
        public final String value;
        
        private DevSysRefMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DevSysRefMode from(String value){
            switch(value){
                case "DEVSYS01":
                    return DEVSYS01;
                case "DEVSYS02":
                    return DEVSYS02;
                case "DEVSYS03":
                    return DEVSYS03;
                case "DEVSYS04":
                    return DEVSYS04;
                case "DEVSYS05":
                    return DEVSYS05;
                case "DEVSYS06":
                    return DEVSYS06;
                case "DEVSYS07":
                    return DEVSYS07;
                case "DEVSYS08":
                    return DEVSYS08;
                case "DEVSYS09":
                    return DEVSYS09;
                case "DEVSYS10":
                    return DEVSYS10;
                case "DEVSYS11":
                    return DEVSYS11;
                case "DEVSYS12":
                    return DEVSYS12;
                case "DEVSYS13":
                    return DEVSYS13;
                case "DEVSYS14":
                    return DEVSYS14;
                case "DEVSYS15":
                    return DEVSYS15;
                case "DEVSYS16":
                    return DEVSYS16;
                case "DEVSYS17":
                    return DEVSYS17;
                case "DEVSYS18":
                    return DEVSYS18;
                case "DEVSYS19":
                    return DEVSYS19;
                case "DEVSYS20":
                    return DEVSYS20;
                case "DEVSYS21":
                    return DEVSYS21;
                case "DEVSYS22":
                    return DEVSYS22;
                case "DEVSYS23":
                    return DEVSYS23;
                case "DEVSYS24":
                    return DEVSYS24;
                case "DEVSYS25":
                    return DEVSYS25;
                case "DEVSYS26":
                    return DEVSYS26;
                case "DEVSYS27":
                    return DEVSYS27;
                case "DEVSYS28":
                    return DEVSYS28;
                case "DEVSYS29":
                    return DEVSYS29;
                case "DEVSYS30":
                    return DEVSYS30;
                case "DEVSYS31":
                    return DEVSYS31;
                case "DEVSYS32":
                    return DEVSYS32;
                case "DEVSYS33":
                    return DEVSYS33;
                case "DEVSYS34":
                    return DEVSYS34;
                case "DEVSYS35":
                    return DEVSYS35;
                case "DEVSYS36":
                    return DEVSYS36;
                case "DEVSYS37":
                    return DEVSYS37;
                case "DEVSYS38":
                    return DEVSYS38;
                case "DEVSYS39":
                    return DEVSYS39;
                case "DEVSYS40":
                    return DEVSYS40;
                case "DEVSYS41":
                    return DEVSYS41;
                case "DEVSYS42":
                    return DEVSYS42;
                case "DEVSYS43":
                    return DEVSYS43;
                case "DEVSYS44":
                    return DEVSYS44;
                case "DEVSYS45":
                    return DEVSYS45;
                case "DEVSYS46":
                    return DEVSYS46;
                case "DEVSYS47":
                    return DEVSYS47;
                case "DEVSYS48":
                    return DEVSYS48;
                case "DEVSYS49":
                    return DEVSYS49;
                case "DEVSYS50":
                    return DEVSYS50;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台列表项类型
     * <P>
     * <ul>
     * <li>TEXTITEM
     * <P>
     * 显示内容项，列表中的内容列
     * <li>ACTIONITEM
     * <P>
     * 操作项，列表中的操作列
     * <li>DATAITEM
     * <P>
     * 数据项，仅提供数据，无显示
     * </ul>     
     */
    public static enum ListItemType{
        TEXTITEM("TEXTITEM", "显示内容项")
        ,ACTIONITEM("ACTIONITEM", "操作项")
        ,DATAITEM("DATAITEM", "数据项")
;
           
        public final String text;
        public final String value;
        
        private ListItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ListItemType from(String value){
            switch(value){
                case "TEXTITEM":
                    return TEXTITEM;
                case "ACTIONITEM":
                    return ACTIONITEM;
                case "DATAITEM":
                    return DATAITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体类型，数值项
     * <P>
     * <ul>
     * <li>MAJOR&nbsp;(1)
     * <P>
     * 主实体，实体具备有相对独立的业务能力
     * <li>ATTACHED&nbsp;(2)
     * <P>
     * 附属实体，实体不具备独立的业务能力，一般为主实体的成员数据
     * <li>RELATED&nbsp;(3)
     * <P>
     * 关系实体，用于对两个主实体进行连接的实体
     * <li>DYNAATTACHED&nbsp;(4)
     * <P>
     * 动态附属实体，实体不具备独立的业务能力，为动态指定的父实体的成员数据
     * </ul>     
     */
    public static enum DEType{
        MAJOR(1, "主实体")
        ,ATTACHED(2, "附属实体")
        ,RELATED(3, "关系实体")
        ,DYNAATTACHED(4, "动态附属实体")
;
           
        public final String text;
        public final int value;
        
        private DEType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEType from(int value){
            switch(value){
                case 1:
                    return MAJOR;
                case 2:
                    return ATTACHED;
                case 3:
                    return RELATED;
                case 4:
                    return DYNAATTACHED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体模型SaaS模型，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不启用
     * <li>STANDARD&nbsp;(1)
     * <P>
     * 标准SaaS构型，标准SaaS构型将自动调整数据结构，（1）添加自增列作为主键，用户主键调整为普通列；（2）添加租户列；（3）实体查询SQL添加租户条件
     * <li>STANDARD2&nbsp;(2)
     * <P>
     * 标准SaaS构型2，标准SaaS构型2将自动调整数据结构，（1）添加自增列作为主键，用户主键调整为普通列；（2）添加租户列；与标准构型的差别为发布的SQL为无租户相关性
     * <li>STANDARD3&nbsp;(3)
     * <P>
     * 标准SaaS构型3，标准SaaS构型3将自动调整数据结构，（1）添加租户列；（2）实体查询SQL添加租户条件
     * <li>STANDARD4&nbsp;(4)
     * <P>
     * 标准SaaS构型4，标准SaaS构型4将自动调整数据结构，（1）添加租户列；与标准构型3的差别为发布的SQL为无租户相关性
     * </ul>     
     */
    public static enum DESaaSMode{
        NONE(0, "不启用")
        ,STANDARD(1, "标准SaaS构型")
        ,STANDARD2(2, "标准SaaS构型2")
        ,STANDARD3(3, "标准SaaS构型3")
        ,STANDARD4(4, "标准SaaS构型4")
;
           
        public final String text;
        public final int value;
        
        private DESaaSMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DESaaSMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return STANDARD;
                case 2:
                    return STANDARD2;
                case 3:
                    return STANDARD3;
                case 4:
                    return STANDARD4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台部件处理器临时数据模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无临时数据模式
     * <li>MAJOR&nbsp;(1)
     * <P>
     * 主数据模式，主数据模式完成
（1）从真实数据建立临时数据的功能（包括相关子数据）
（2）从临时数据还原真实数据的功能（包括相关子数据）
     * <li>MINOR&nbsp;(2)
     * <P>
     * 从数据模式，功能操作直接面向临时数据
     * </ul>     
     */
    public static enum TempDataMode{
        NONE(0, "无临时数据模式")
        ,MAJOR(1, "主数据模式")
        ,MINOR(2, "从数据模式")
;
           
        public final String text;
        public final int value;
        
        private TempDataMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TempDataMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return MAJOR;
                case 2:
                    return MINOR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 序列应用结果集模式
     * <P>
     * <ul>
     * <li>COLUMN&nbsp;(column)
     * <P>
     * 列（Column）
     * <li>ROW&nbsp;(row)
     * <P>
     * 行（Row）
     * </ul>     
     */
    public static enum ChartSeriesLayoutBy{
        COLUMN("column", "列（Column）")
        ,ROW("row", "行（Row）")
;
           
        public final String text;
        public final String value;
        
        private ChartSeriesLayoutBy(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartSeriesLayoutBy from(String value){
            switch(value){
                case "column":
                    return COLUMN;
                case "row":
                    return ROW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试断言类型
     * <P>
     * <ul>
     * <li>RESULT
     * <P>
     * 预期结果，测试单元执行结果与预期结果一致
     * <li>EXCEPTION
     * <P>
     * 预期异常，测试单元执行发生的异常与预期异常一致
     * <li>DATAEXISTS
     * <P>
     * 预期数据存在
     * <li>NOEXCEPTION
     * <P>
     * 预期无异常，测试单元执行无任何异常
     * <li>CUSTOMCODE
     * <P>
     * 自定义代码
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TestCaseAssertType{
        RESULT("RESULT", "预期结果")
        ,EXCEPTION("EXCEPTION", "预期异常")
        ,DATAEXISTS("DATAEXISTS", "预期数据存在")
        ,NOEXCEPTION("NOEXCEPTION", "预期无异常")
        ,CUSTOMCODE("CUSTOMCODE", "自定义代码")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TestCaseAssertType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestCaseAssertType from(String value){
            switch(value){
                case "RESULT":
                    return RESULT;
                case "EXCEPTION":
                    return EXCEPTION;
                case "DATAEXISTS":
                    return DATAEXISTS;
                case "NOEXCEPTION":
                    return NOEXCEPTION;
                case "CUSTOMCODE":
                    return CUSTOMCODE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台应用框架插件类型
     * <P>
     * <ul>
     * <li>AC_ITEM
     * <P>
     * 自填列表项绘制插件
     * <li>CHART_RENDER
     * <P>
     * 图表绘制插件
     * <li>CHART_AXISRENDER
     * <P>
     * 图表坐标轴绘制插件
     * <li>CHART_SERIESRENDER
     * <P>
     * 图表序列绘制插件
     * <li>CHART_CSRENDER
     * <P>
     * 图表坐标系组件绘制插件
     * <li>CUSTOM
     * <P>
     * 自定义部件绘制插件
     * <li>DATAVIEW_ITEM
     * <P>
     * 数据视图项绘制插件
     * <li>DATAVIEW_RENDER
     * <P>
     * 数据视图绘制插件
     * <li>EDITFORM_RENDER
     * <P>
     * 编辑表单绘制插件
     * <li>EDITOR_CUSTOMSTYLE
     * <P>
     * 编辑器自定义绘制插件
     * <li>FORM_USERCONTROL
     * <P>
     * 表单自定义控件绘制插件
     * <li>GRID_COLRENDER
     * <P>
     * 数据表格列绘制插件
     * <li>GRID_RENDER
     * <P>
     * 数据表格绘制插件
     * <li>LIST_ITEMRENDER
     * <P>
     * 列表项绘制插件
     * <li>LIST_RENDER
     * <P>
     * 列表绘制插件
     * <li>PORTLET_CUSTOM
     * <P>
     * 自定义门户部件绘制插件
     * <li>PORTLET_TITLEBAR
     * <P>
     * 门户部件标题栏绘制插件
     * <li>SEARCHFORM_RENDER
     * <P>
     * 搜索表单绘制插件
     * <li>TOOLBAR_ITEM
     * <P>
     * 工具栏项绘制插件
     * <li>TOOLBAR_RENDER
     * <P>
     * 工具栏绘制插件
     * <li>TREEEXPBAR_RENDER
     * <P>
     * 树导航栏绘制插件
     * <li>TREE_RENDER
     * <P>
     * 树视图绘制插件
     * <li>UIENGINE
     * <P>
     * 界面引擎
     * <li>UILOGICNODE
     * <P>
     * 界面逻辑节点
     * <li>VIEW_CUSTOM
     * <P>
     * 实体视图绘制插件
     * <li>DEMETHOD
     * <P>
     * 应用实体方法插件
     * <li>APPUTIL
     * <P>
     * 应用功能插件
     * <li>APPCOUNTER
     * <P>
     * 应用计数器插件
     * <li>DEDATAIMPORT
     * <P>
     * 应用实体数据导入
     * <li>DEDATAEXPORT
     * <P>
     * 应用实体数据导出
     * <li>DEFVALUERULE
     * <P>
     * 应用实体属性值规则
     * <li>APPVALUERULE
     * <P>
     * 应用值规则
     * <li>SEARCHBAR_ITEM
     * <P>
     * 搜索栏项绘制插件
     * <li>SEARCHBAR_RENDER
     * <P>
     * 搜索栏绘制插件
     * <li>WIZARDPANEL_RENDER
     * <P>
     * 向导面板绘制插件
     * <li>DEUIACTION
     * <P>
     * 应用实体界面行为
     * <li>CALENDAR_ITEM
     * <P>
     * 日历部件项绘制插件
     * <li>CALENDAR_RENDER
     * <P>
     * 日历部件绘制插件
     * <li>MAPVIEW_ITEM
     * <P>
     * 地图部件项绘制插件
     * <li>MAPVIEW_RENDER
     * <P>
     * 地图部件绘制插件
     * <li>PANEL_ITEM
     * <P>
     * 面板部件成员绘制插件
     * <li>PANEL_RENDER
     * <P>
     * 面板部件绘制插件
     * <li>DASHBOARD_ITEM
     * <P>
     * 数据看板成员绘制插件
     * <li>DASHBOARD_RENDER
     * <P>
     * 数据看板绘制插件
     * <li>APPUILOGIC
     * <P>
     * 系统界面逻辑插件
     * <li>APPMENU_ITEM
     * <P>
     * 应用菜单项绘制插件
     * <li>APPMENU_RENDER
     * <P>
     * 应用菜单绘制插件
     * <li>TITLEBAR_RENDER
     * <P>
     * 标题栏绘制插件
     * </ul>     
     */
    public static enum PFPluginType{
        AC_ITEM("AC_ITEM", "自填列表项绘制插件")
        ,CHART_RENDER("CHART_RENDER", "图表绘制插件")
        ,CHART_AXISRENDER("CHART_AXISRENDER", "图表坐标轴绘制插件")
        ,CHART_SERIESRENDER("CHART_SERIESRENDER", "图表序列绘制插件")
        ,CHART_CSRENDER("CHART_CSRENDER", "图表坐标系组件绘制插件")
        ,CUSTOM("CUSTOM", "自定义部件绘制插件")
        ,DATAVIEW_ITEM("DATAVIEW_ITEM", "数据视图项绘制插件")
        ,DATAVIEW_RENDER("DATAVIEW_RENDER", "数据视图绘制插件")
        ,EDITFORM_RENDER("EDITFORM_RENDER", "编辑表单绘制插件")
        ,EDITOR_CUSTOMSTYLE("EDITOR_CUSTOMSTYLE", "编辑器自定义绘制插件")
        ,FORM_USERCONTROL("FORM_USERCONTROL", "表单自定义控件绘制插件")
        ,GRID_COLRENDER("GRID_COLRENDER", "数据表格列绘制插件")
        ,GRID_RENDER("GRID_RENDER", "数据表格绘制插件")
        ,LIST_ITEMRENDER("LIST_ITEMRENDER", "列表项绘制插件")
        ,LIST_RENDER("LIST_RENDER", "列表绘制插件")
        ,PORTLET_CUSTOM("PORTLET_CUSTOM", "自定义门户部件绘制插件")
        ,PORTLET_TITLEBAR("PORTLET_TITLEBAR", "门户部件标题栏绘制插件")
        ,SEARCHFORM_RENDER("SEARCHFORM_RENDER", "搜索表单绘制插件")
        ,TOOLBAR_ITEM("TOOLBAR_ITEM", "工具栏项绘制插件")
        ,TOOLBAR_RENDER("TOOLBAR_RENDER", "工具栏绘制插件")
        ,TREEEXPBAR_RENDER("TREEEXPBAR_RENDER", "树导航栏绘制插件")
        ,TREE_RENDER("TREE_RENDER", "树视图绘制插件")
        ,UIENGINE("UIENGINE", "界面引擎")
        ,UILOGICNODE("UILOGICNODE", "界面逻辑节点")
        ,VIEW_CUSTOM("VIEW_CUSTOM", "实体视图绘制插件")
        ,DEMETHOD("DEMETHOD", "应用实体方法插件")
        ,APPUTIL("APPUTIL", "应用功能插件")
        ,APPCOUNTER("APPCOUNTER", "应用计数器插件")
        ,DEDATAIMPORT("DEDATAIMPORT", "应用实体数据导入")
        ,DEDATAEXPORT("DEDATAEXPORT", "应用实体数据导出")
        ,DEFVALUERULE("DEFVALUERULE", "应用实体属性值规则")
        ,APPVALUERULE("APPVALUERULE", "应用值规则")
        ,SEARCHBAR_ITEM("SEARCHBAR_ITEM", "搜索栏项绘制插件")
        ,SEARCHBAR_RENDER("SEARCHBAR_RENDER", "搜索栏绘制插件")
        ,WIZARDPANEL_RENDER("WIZARDPANEL_RENDER", "向导面板绘制插件")
        ,DEUIACTION("DEUIACTION", "应用实体界面行为")
        ,CALENDAR_ITEM("CALENDAR_ITEM", "日历部件项绘制插件")
        ,CALENDAR_RENDER("CALENDAR_RENDER", "日历部件绘制插件")
        ,MAPVIEW_ITEM("MAPVIEW_ITEM", "地图部件项绘制插件")
        ,MAPVIEW_RENDER("MAPVIEW_RENDER", "地图部件绘制插件")
        ,PANEL_ITEM("PANEL_ITEM", "面板部件成员绘制插件")
        ,PANEL_RENDER("PANEL_RENDER", "面板部件绘制插件")
        ,DASHBOARD_ITEM("DASHBOARD_ITEM", "数据看板成员绘制插件")
        ,DASHBOARD_RENDER("DASHBOARD_RENDER", "数据看板绘制插件")
        ,APPUILOGIC("APPUILOGIC", "系统界面逻辑插件")
        ,APPMENU_ITEM("APPMENU_ITEM", "应用菜单项绘制插件")
        ,APPMENU_RENDER("APPMENU_RENDER", "应用菜单绘制插件")
        ,TITLEBAR_RENDER("TITLEBAR_RENDER", "标题栏绘制插件")
;
           
        public final String text;
        public final String value;
        
        private PFPluginType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PFPluginType from(String value){
            switch(value){
                case "AC_ITEM":
                    return AC_ITEM;
                case "CHART_RENDER":
                    return CHART_RENDER;
                case "CHART_AXISRENDER":
                    return CHART_AXISRENDER;
                case "CHART_SERIESRENDER":
                    return CHART_SERIESRENDER;
                case "CHART_CSRENDER":
                    return CHART_CSRENDER;
                case "CUSTOM":
                    return CUSTOM;
                case "DATAVIEW_ITEM":
                    return DATAVIEW_ITEM;
                case "DATAVIEW_RENDER":
                    return DATAVIEW_RENDER;
                case "EDITFORM_RENDER":
                    return EDITFORM_RENDER;
                case "EDITOR_CUSTOMSTYLE":
                    return EDITOR_CUSTOMSTYLE;
                case "FORM_USERCONTROL":
                    return FORM_USERCONTROL;
                case "GRID_COLRENDER":
                    return GRID_COLRENDER;
                case "GRID_RENDER":
                    return GRID_RENDER;
                case "LIST_ITEMRENDER":
                    return LIST_ITEMRENDER;
                case "LIST_RENDER":
                    return LIST_RENDER;
                case "PORTLET_CUSTOM":
                    return PORTLET_CUSTOM;
                case "PORTLET_TITLEBAR":
                    return PORTLET_TITLEBAR;
                case "SEARCHFORM_RENDER":
                    return SEARCHFORM_RENDER;
                case "TOOLBAR_ITEM":
                    return TOOLBAR_ITEM;
                case "TOOLBAR_RENDER":
                    return TOOLBAR_RENDER;
                case "TREEEXPBAR_RENDER":
                    return TREEEXPBAR_RENDER;
                case "TREE_RENDER":
                    return TREE_RENDER;
                case "UIENGINE":
                    return UIENGINE;
                case "UILOGICNODE":
                    return UILOGICNODE;
                case "VIEW_CUSTOM":
                    return VIEW_CUSTOM;
                case "DEMETHOD":
                    return DEMETHOD;
                case "APPUTIL":
                    return APPUTIL;
                case "APPCOUNTER":
                    return APPCOUNTER;
                case "DEDATAIMPORT":
                    return DEDATAIMPORT;
                case "DEDATAEXPORT":
                    return DEDATAEXPORT;
                case "DEFVALUERULE":
                    return DEFVALUERULE;
                case "APPVALUERULE":
                    return APPVALUERULE;
                case "SEARCHBAR_ITEM":
                    return SEARCHBAR_ITEM;
                case "SEARCHBAR_RENDER":
                    return SEARCHBAR_RENDER;
                case "WIZARDPANEL_RENDER":
                    return WIZARDPANEL_RENDER;
                case "DEUIACTION":
                    return DEUIACTION;
                case "CALENDAR_ITEM":
                    return CALENDAR_ITEM;
                case "CALENDAR_RENDER":
                    return CALENDAR_RENDER;
                case "MAPVIEW_ITEM":
                    return MAPVIEW_ITEM;
                case "MAPVIEW_RENDER":
                    return MAPVIEW_RENDER;
                case "PANEL_ITEM":
                    return PANEL_ITEM;
                case "PANEL_RENDER":
                    return PANEL_RENDER;
                case "DASHBOARD_ITEM":
                    return DASHBOARD_ITEM;
                case "DASHBOARD_RENDER":
                    return DASHBOARD_RENDER;
                case "APPUILOGIC":
                    return APPUILOGIC;
                case "APPMENU_ITEM":
                    return APPMENU_ITEM;
                case "APPMENU_RENDER":
                    return APPMENU_RENDER;
                case "TITLEBAR_RENDER":
                    return TITLEBAR_RENDER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单成员逻辑项类型
     * <P>
     * <ul>
     * <li>GROUP
     * <P>
     * 组逻辑，组合条件，提供与（AND）、或（OR）操作
     * <li>SINGLE
     * <P>
     * 单项逻辑，表单项的单项逻辑判断
     * </ul>     
     */
    public static enum FormDetailLogicType{
        GROUP("GROUP", "组逻辑")
        ,SINGLE("SINGLE", "单项逻辑")
;
           
        public final String text;
        public final String value;
        
        private FormDetailLogicType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormDetailLogicType from(String value){
            switch(value){
                case "GROUP":
                    return GROUP;
                case "SINGLE":
                    return SINGLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 字段排序方向
     * <P>
     * <ul>
     * <li>ASC
     * <P>
     * 升序
     * <li>DESC
     * <P>
     * 降序
     * </ul>     
     */
    public static enum SortDir{
        ASC("ASC", "升序")
        ,DESC("DESC", "降序")
;
           
        public final String text;
        public final String value;
        
        private SortDir(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SortDir from(String value){
            switch(value){
                case "ASC":
                    return ASC;
                case "DESC":
                    return DESC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 集成元素属性类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单属性
     * <li>GROUP
     * <P>
     * 属性组
     * </ul>     
     */
    public static enum EAIElementAttrType{
        SIMPLE("SIMPLE", "简单属性")
        ,GROUP("GROUP", "属性组")
;
           
        public final String text;
        public final String value;
        
        private EAIElementAttrType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EAIElementAttrType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "GROUP":
                    return GROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认应用，常规应用
     * <li>CLOUDHUBAPP
     * <P>
     * Cloud集成应用，用于提供多应用集成呈现的总线应用
     * <li>CLOUDHUBSUBAPP
     * <P>
     * Cloud集成子应用
     * <li>WFAPP
     * <P>
     * 工作流应用，专门的工作流功能应用，为外部应用提供流程代理功能
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum AppMode{
        DEFAULT("DEFAULT", "默认应用")
        ,CLOUDHUBAPP("CLOUDHUBAPP", "Cloud集成应用")
        ,CLOUDHUBSUBAPP("CLOUDHUBSUBAPP", "Cloud集成子应用")
        ,WFAPP("WFAPP", "工作流应用")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private AppMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "CLOUDHUBAPP":
                    return CLOUDHUBAPP;
                case "CLOUDHUBSUBAPP":
                    return CLOUDHUBSUBAPP;
                case "WFAPP":
                    return WFAPP;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 大数据表实体类型（V2），数值项
     * <P>
     * <ul>
     * <li>DEFAULT&nbsp;(1)
     * <P>
     * 默认实体
     * <li>RELATED&nbsp;(0)
     * <P>
     * 附属实体
     * </ul>     
     */
    public static enum DEBDTableType{
        DEFAULT(1, "默认实体")
        ,RELATED(0, "附属实体")
;
           
        public final String text;
        public final int value;
        
        private DEBDTableType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEBDTableType from(int value){
            switch(value){
                case 1:
                    return DEFAULT;
                case 0:
                    return RELATED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体图表漏斗图方向
     * <P>
     * <ul>
     * <li>CENTER&nbsp;(center)
     * <P>
     * 剧中
     * <li>LEFT&nbsp;(left)
     * <P>
     * 左侧
     * <li>RIGHT&nbsp;(right)
     * <P>
     * 右侧
     * </ul>     
     */
    public static enum ChartFunnelAlign{
        CENTER("center", "剧中")
        ,LEFT("left", "左侧")
        ,RIGHT("right", "右侧")
;
           
        public final String text;
        public final String value;
        
        private ChartFunnelAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartFunnelAlign from(String value){
            switch(value){
                case "center":
                    return CENTER;
                case "left":
                    return LEFT;
                case "right":
                    return RIGHT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体关系数据导出级别，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(-1)
     * <P>
     * 无关系
     * <li>CUSTOM&nbsp;(0)
     * <P>
     * 有关系，无默认处理，存在操作关系，但无需进行相关的处理，一般会由其它逻辑完成相应的处理
     * <li>LEVEL_10&nbsp;(10)
     * <P>
     * 一级
     * <li>LEVEL_20&nbsp;(20)
     * <P>
     * 二级
     * <li>LEVEL_30&nbsp;(30)
     * <P>
     * 三级
     * <li>LEVEL_40&nbsp;(40)
     * <P>
     * 四级
     * <li>LEVEL_50&nbsp;(50)
     * <P>
     * 五级
     * <li>LEVEL_60&nbsp;(60)
     * <P>
     * 六级
     * <li>LEVEL_70&nbsp;(70)
     * <P>
     * 七级
     * <li>LEVEL_80&nbsp;(80)
     * <P>
     * 八级
     * <li>LEVEL_90&nbsp;(90)
     * <P>
     * 九级
     * <li>LEVEL_100&nbsp;(100)
     * <P>
     * 十级
     * </ul>     
     */
    public static enum DERExportLevel{
        NONE(-1, "无关系")
        ,CUSTOM(0, "有关系，无默认处理")
        ,LEVEL_10(10, "一级")
        ,LEVEL_20(20, "二级")
        ,LEVEL_30(30, "三级")
        ,LEVEL_40(40, "四级")
        ,LEVEL_50(50, "五级")
        ,LEVEL_60(60, "六级")
        ,LEVEL_70(70, "七级")
        ,LEVEL_80(80, "八级")
        ,LEVEL_90(90, "九级")
        ,LEVEL_100(100, "十级")
;
           
        public final String text;
        public final int value;
        
        private DERExportLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERExportLevel from(int value){
            switch(value){
                case -1:
                    return NONE;
                case 0:
                    return CUSTOM;
                case 10:
                    return LEVEL_10;
                case 20:
                    return LEVEL_20;
                case 30:
                    return LEVEL_30;
                case 40:
                    return LEVEL_40;
                case 50:
                    return LEVEL_50;
                case 60:
                    return LEVEL_60;
                case 70:
                    return LEVEL_70;
                case 80:
                    return LEVEL_80;
                case 90:
                    return LEVEL_90;
                case 100:
                    return LEVEL_100;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据审计模式，数值项
     * <P>
     * <ul>
     * <li>NORMAL&nbsp;(1)
     * <P>
     * 基本审计，记录数据的基本操作记录，包括了操作人及操作时间
     * <li>ADVANCE&nbsp;(2)
     * <P>
     * 详细审计（含变化记录），记录数据的操作记录，包括了操作人及操作时间以及具体的变更内容
     * </ul>     
     */
    public static enum DEDataAuditMode{
        NORMAL(1, "基本审计")
        ,ADVANCE(2, "详细审计（含变化记录）")
;
           
        public final String text;
        public final int value;
        
        private DEDataAuditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataAuditMode from(int value){
            switch(value){
                case 1:
                    return NORMAL;
                case 2:
                    return ADVANCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 关系界面组成员类型
     * <P>
     * <ul>
     * <li>DRITEM
     * <P>
     * 关系界面，当前实体的关系界面
     * <li>PDTVIEW
     * <P>
     * 预置视图，当前系统的预定义视图
     * </ul>     
     */
    public static enum DEDRDetailType{
        DRITEM("DRITEM", "关系界面")
        ,PDTVIEW("PDTVIEW", "预置视图")
;
           
        public final String text;
        public final String value;
        
        private DEDRDetailType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDRDetailType from(String value){
            switch(value){
                case "DRITEM":
                    return DRITEM;
                case "PDTVIEW":
                    return PDTVIEW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板折叠模式，数值项
     * <P>
     * <ul>
     * <li>NOTSUPPORTED&nbsp;(0)
     * <P>
     * 不支持，固定显示，不支持折叠
     * <li>SUPPORTED&nbsp;(1)
     * <P>
     * 支持（默认显示），支持折叠，默认显示
     * <li>SUPPORTEDANDHIDE&nbsp;(2)
     * <P>
     * 支持（默认隐藏），支持折叠，默认不显示
     * </ul>     
     */
    public static enum PanelCollapsibleMode{
        NOTSUPPORTED(0, "不支持")
        ,SUPPORTED(1, "支持（默认显示）")
        ,SUPPORTEDANDHIDE(2, "支持（默认隐藏）")
;
           
        public final String text;
        public final int value;
        
        private PanelCollapsibleMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelCollapsibleMode from(int value){
            switch(value){
                case 0:
                    return NOTSUPPORTED;
                case 1:
                    return SUPPORTED;
                case 2:
                    return SUPPORTEDANDHIDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性字段查询扩展选项，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>LIKE
     * <P>
     * LIKE大小写敏感
     * <li>EQ&nbsp;(=)
     * <P>
     * =（含其它）大小写敏感
     * <li>LIKESPLIT
     * <P>
     * LIKE分解
     * </ul>     
     */
    public static enum DEFQueryCSMode{
        LIKE("LIKE", "LIKE大小写敏感")
        ,EQ("=", "=（含其它）大小写敏感")
        ,LIKESPLIT("LIKESPLIT", "LIKE分解")
;
           
        public final String text;
        public final String value;
        
        private DEFQueryCSMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFQueryCSMode from(String value){
            switch(value){
                case "LIKE":
                    return LIKE;
                case "=":
                    return EQ;
                case "LIKESPLIT":
                    return LIKESPLIT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台大数据库类型，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>MONGODB
     * <P>
     * MongoDB
     * <li>SOLR
     * <P>
     * Solr
     * <li>ES
     * <P>
     * ElasticSearch
     * <li>HBASE
     * <P>
     * HBase
     * <li>MILVUS
     * <P>
     * Milvus
     * <li>NEO4J
     * <P>
     * Neo4j
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum BDType{
        MONGODB("MONGODB", "MongoDB")
        ,SOLR("SOLR", "Solr")
        ,ES("ES", "ElasticSearch")
        ,HBASE("HBASE", "HBase")
        ,MILVUS("MILVUS", "Milvus")
        ,NEO4J("NEO4J", "Neo4j")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private BDType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BDType from(String value){
            switch(value){
                case "MONGODB":
                    return MONGODB;
                case "SOLR":
                    return SOLR;
                case "ES":
                    return ES;
                case "HBASE":
                    return HBASE;
                case "MILVUS":
                    return MILVUS;
                case "NEO4J":
                    return NEO4J;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体视图操作控制（树视图），数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 支持建立
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 支持编辑
     * <li>VIEW&nbsp;(4)
     * <P>
     * 支持查看
     * <li>REMOVE&nbsp;(8)
     * <P>
     * 支持删除
     * <li>COPY&nbsp;(16)
     * <P>
     * 支持拷贝
     * </ul>     
     */
    public static enum CtrlUIAction{
        CREATE(1, "支持建立")
        ,UPDATE(2, "支持编辑")
        ,VIEW(4, "支持查看")
        ,REMOVE(8, "支持删除")
        ,COPY(16, "支持拷贝")
;
           
        public final String text;
        public final int value;
        
        private CtrlUIAction(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlUIAction from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 4:
                    return VIEW;
                case 8:
                    return REMOVE;
                case 16:
                    return COPY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件界面引擎（全部）
     * <P>
     * <ul>
     * <li>LOADANDSEARCH
     * <P>
     * 搜索部件加载并搜索（参数可指定触发部件）
     * <li>LOADTRIGGER
     * <P>
     * 部件加载（参数可指定触发部件）
     * </ul>     
     */
    public static enum ViewCtrlRefUsageAll{
        LOADANDSEARCH("LOADANDSEARCH", "搜索部件加载并搜索（参数可指定触发部件）")
        ,LOADTRIGGER("LOADTRIGGER", "部件加载（参数可指定触发部件）")
;
           
        public final String text;
        public final String value;
        
        private ViewCtrlRefUsageAll(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewCtrlRefUsageAll from(String value){
            switch(value){
                case "LOADANDSEARCH":
                    return LOADANDSEARCH;
                case "LOADTRIGGER":
                    return LOADTRIGGER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体关系属性继承操作，数值项
     * <P>
     * <ul>
     * <li>IGNOREINHERIT&nbsp;(1)
     * <P>
     * 忽略继承指定属性
     * <li>INHERIT&nbsp;(2)
     * <P>
     * 继承指定属性
     * </ul>     
     */
    public static enum DERDEFInheritMode{
        IGNOREINHERIT(1, "忽略继承指定属性")
        ,INHERIT(2, "继承指定属性")
;
           
        public final String text;
        public final int value;
        
        private DERDEFInheritMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERDEFInheritMode from(int value){
            switch(value){
                case 1:
                    return IGNOREINHERIT;
                case 2:
                    return INHERIT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图面板项类型
     * <P>
     * <ul>
     * <li>CONTAINER
     * <P>
     * 面板容器，面板中的基本布局面板，输出标题的面板承担分类数据呈现，不输出标题的面板更多承担布局功能（默认无内、外边框）。支持子成员
     * <li>CONTROL
     * <P>
     * 部件，面板中的部件成员，挂载系统或实体定义的界面部件。不支持子成员
     * <li>CTRLPOS
     * <P>
     * 部件占位，视图布局面板中的部件占位成员。不支持子成员
     * <li>RAWITEM
     * <P>
     * 直接内容，面板中的直接内容项，输出文本或图片。不支持子成员
     * <li>TABPANEL
     * <P>
     * 分页部件，面板中的分页部件，提供分页界面容器。分页部件只能包含分页面板
     * <li>TAGPAGE
     * <P>
     * 分页面板，面板分页部件的成员部件，是基础的布局容器。只允许放置在分页部件中。支持子成员
     * <li>FIELD
     * <P>
     * 面板属性，面板模型的载体，通过编辑器控件将模型数据进行呈现。不支持子成员
     * <li>BUTTON
     * <P>
     * 面板按钮，面板中的按钮对象，为面板提供命令能力。不支持子成员
     * <li>USERCONTROL
     * <P>
     * 用户控件，面板中的自定义用户部件，需指定前端模板插件进行内容输出。不支持子成员
     * <li>PARAM
     * <P>
     * 项参数，面板项的补充参数，提供进一步定义面板项的参数能力
     * <li>RAWITEMPARAM
     * <P>
     * 直接内容参数，面板中的直接内容项参数，提供进一步定义内容项的参数能力
     * </ul>     
     */
    public static enum PanelItemType{
        CONTAINER("CONTAINER", "面板容器")
        ,CONTROL("CONTROL", "部件")
        ,CTRLPOS("CTRLPOS", "部件占位")
        ,RAWITEM("RAWITEM", "直接内容")
        ,TABPANEL("TABPANEL", "分页部件")
        ,TAGPAGE("TAGPAGE", "分页面板")
        ,FIELD("FIELD", "面板属性")
        ,BUTTON("BUTTON", "面板按钮")
        ,USERCONTROL("USERCONTROL", "用户控件")
        ,PARAM("PARAM", "项参数")
        ,RAWITEMPARAM("RAWITEMPARAM", "直接内容参数")
;
           
        public final String text;
        public final String value;
        
        private PanelItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelItemType from(String value){
            switch(value){
                case "CONTAINER":
                    return CONTAINER;
                case "CONTROL":
                    return CONTROL;
                case "CTRLPOS":
                    return CTRLPOS;
                case "RAWITEM":
                    return RAWITEM;
                case "TABPANEL":
                    return TABPANEL;
                case "TAGPAGE":
                    return TAGPAGE;
                case "FIELD":
                    return FIELD;
                case "BUTTON":
                    return BUTTON;
                case "USERCONTROL":
                    return USERCONTROL;
                case "PARAM":
                    return PARAM;
                case "RAWITEMPARAM":
                    return RAWITEMPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台门户部件类型（全部）
     * <P>
     * <ul>
     * <li>LIST
     * <P>
     * 实体列表
     * <li>CHART
     * <P>
     * 实体图表
     * <li>VIEW
     * <P>
     * 系统视图
     * <li>HTML
     * <P>
     * 网页部件
     * <li>TOOLBAR
     * <P>
     * 工具栏
     * <li>ACTIONBAR
     * <P>
     * 操作栏
     * <li>CUSTOM
     * <P>
     * 自定义
     * <li>APPMENU
     * <P>
     * 快捷菜单栏
     * <li>CONTAINER
     * <P>
     * 布局容器
     * <li>RAWITEM
     * <P>
     * 直接内容
     * </ul>     
     */
    public static enum PortletType{
        LIST("LIST", "实体列表")
        ,CHART("CHART", "实体图表")
        ,VIEW("VIEW", "系统视图")
        ,HTML("HTML", "网页部件")
        ,TOOLBAR("TOOLBAR", "工具栏")
        ,ACTIONBAR("ACTIONBAR", "操作栏")
        ,CUSTOM("CUSTOM", "自定义")
        ,APPMENU("APPMENU", "快捷菜单栏")
        ,CONTAINER("CONTAINER", "布局容器")
        ,RAWITEM("RAWITEM", "直接内容")
;
           
        public final String text;
        public final String value;
        
        private PortletType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PortletType from(String value){
            switch(value){
                case "LIST":
                    return LIST;
                case "CHART":
                    return CHART;
                case "VIEW":
                    return VIEW;
                case "HTML":
                    return HTML;
                case "TOOLBAR":
                    return TOOLBAR;
                case "ACTIONBAR":
                    return ACTIONBAR;
                case "CUSTOM":
                    return CUSTOM;
                case "APPMENU":
                    return APPMENU;
                case "CONTAINER":
                    return CONTAINER;
                case "RAWITEM":
                    return RAWITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统实体属性默认排序模式
     * <P>
     * <ul>
     * <li>NAME
     * <P>
     * 属性名称，按属性名称排序
     * <li>CREATEDATE
     * <P>
     * 创建时间，按属性创建时间排序
     * <li>NAME_PDT
     * <P>
     * 属性名称（系统属性优先），按属性名称排序，系统属性优先
     * <li>CREATEDATE_PDT
     * <P>
     * 创建时间（系统属性优先），按属性创建时间排序，系统属性优先
     * </ul>     
     */
    public static enum DEFSortMode{
        NAME("NAME", "属性名称")
        ,CREATEDATE("CREATEDATE", "创建时间")
        ,NAME_PDT("NAME_PDT", "属性名称（系统属性优先）")
        ,CREATEDATE_PDT("CREATEDATE_PDT", "创建时间（系统属性优先）")
;
           
        public final String text;
        public final String value;
        
        private DEFSortMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFSortMode from(String value){
            switch(value){
                case "NAME":
                    return NAME;
                case "CREATEDATE":
                    return CREATEDATE;
                case "NAME_PDT":
                    return NAME_PDT;
                case "CREATEDATE_PDT":
                    return CREATEDATE_PDT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树节点关系父节点层级，数值项
     * <P>
     * <ul>
     * <li>LAST&nbsp;(1)
     * <P>
     * 上一级，将上一级节点的标识作为父节点标识
     * <li>LAST2&nbsp;(2)
     * <P>
     * 上两级，将上两级节点的标识作为父节点标识
     * <li>LAST3&nbsp;(3)
     * <P>
     * 上三级，将上三级节点的标识作为父节点标识
     * </ul>     
     */
    public static enum TreeNodeRSPValueLevel{
        LAST(1, "上一级")
        ,LAST2(2, "上两级")
        ,LAST3(3, "上三级")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeRSPValueLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeRSPValueLevel from(int value){
            switch(value){
                case 1:
                    return LAST;
                case 2:
                    return LAST2;
                case 3:
                    return LAST3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表单表单项启用条件，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无，不启用
     * <li>CREATE&nbsp;(1)
     * <P>
     * 建立，建立数据时启用
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新，更新数据时启用
     * <li>ALL&nbsp;(3)
     * <P>
     * 全部，建立及更新数据时启用
     * </ul>     
     */
    public static enum EditItemEnableCond{
        NONE(0, "无")
        ,CREATE(1, "建立")
        ,UPDATE(2, "更新")
        ,ALL(3, "全部")
;
           
        public final String text;
        public final int value;
        
        private EditItemEnableCond(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditItemEnableCond from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 3:
                    return ALL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体1：1关系主实体删除关系实体操作，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无操作，从数据无任何操作，一般用于非关键的日志类数据，关系不启用外键约束
     * <li>DELETE&nbsp;(1)
     * <P>
     * 同时删除，从数据同时删除，一般用于主实体的附属实体
     * <li>REJECT&nbsp;(3)
     * <P>
     * 限制删除，从实体限制删除，中断主实体的删除操作
     * </ul>     
     */
    public static enum DER11RemoveActionType{
        NONE(0, "无操作")
        ,DELETE(1, "同时删除")
        ,REJECT(3, "限制删除")
;
           
        public final String text;
        public final int value;
        
        private DER11RemoveActionType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DER11RemoveActionType from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return DELETE;
                case 3:
                    return REJECT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 服务请求参数类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无参数
     * <li>FIELD
     * <P>
     * 指定属性
     * <li>FIELDS
     * <P>
     * 指定属性数组
     * <li>ENTITY
     * <P>
     * 数据对象
     * <li>ENTITIES
     * <P>
     * 数据对象数组
     * <li>OBJECT
     * <P>
     * 其它对象
     * <li>OBJECTS
     * <P>
     * 其它对象数组
     * </ul>     
     */
    public static enum ServiceReqParamType{
        NONE("NONE", "无参数")
        ,FIELD("FIELD", "指定属性")
        ,FIELDS("FIELDS", "指定属性数组")
        ,ENTITY("ENTITY", "数据对象")
        ,ENTITIES("ENTITIES", "数据对象数组")
        ,OBJECT("OBJECT", "其它对象")
        ,OBJECTS("OBJECTS", "其它对象数组")
;
           
        public final String text;
        public final String value;
        
        private ServiceReqParamType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceReqParamType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "FIELD":
                    return FIELD;
                case "FIELDS":
                    return FIELDS;
                case "ENTITY":
                    return ENTITY;
                case "ENTITIES":
                    return ENTITIES;
                case "OBJECT":
                    return OBJECT;
                case "OBJECTS":
                    return OBJECTS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体功能配置类型
     * <P>
     * <ul>
     * <li>DATAAUDIT
     * <P>
     * 数据审计
     * <li>DYNASTORAGE
     * <P>
     * 动态存储
     * <li>EXTENSION
     * <P>
     * 实体扩展
     * <li>NOTIFYSETTING
     * <P>
     * 通知设置
     * <li>VERSIONCONTROL
     * <P>
     * 版本控制
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum DEUtilType{
        DATAAUDIT("DATAAUDIT", "数据审计")
        ,DYNASTORAGE("DYNASTORAGE", "动态存储")
        ,EXTENSION("EXTENSION", "实体扩展")
        ,NOTIFYSETTING("NOTIFYSETTING", "通知设置")
        ,VERSIONCONTROL("VERSIONCONTROL", "版本控制")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private DEUtilType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEUtilType from(String value){
            switch(value){
                case "DATAAUDIT":
                    return DATAAUDIT;
                case "DYNASTORAGE":
                    return DYNASTORAGE;
                case "EXTENSION":
                    return EXTENSION;
                case "NOTIFYSETTING":
                    return NOTIFYSETTING;
                case "VERSIONCONTROL":
                    return VERSIONCONTROL;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板按钮行为类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无处理
     * <li>UIACTION
     * <P>
     * 界面行为，按钮点击触发界面行为处理
     * <li>UILOGIC
     * <P>
     * 界面逻辑
     * <li>OPENVIEW
     * <P>
     * 打开应用视图
     * <li>OPENDEVIEW
     * <P>
     * 打开实体视图
     * <li>OPENSYSPDTVIEW
     * <P>
     * 打开系统预置视图
     * <li>OPENHTMLPAGE
     * <P>
     * 打开链接
     * <li>DATA_CREATEOBJECT
     * <P>
     * 建立数据
     * <li>DATA_SAVECHANGES
     * <P>
     * 保存变更
     * <li>DATA_CANCELCHANGES
     * <P>
     * 取消变更
     * <li>DATA_REMOVEOBJECT
     * <P>
     * 删除数据
     * <li>DATA_SYNCHRONIZE
     * <P>
     * 同步数据
     * <li>VIEW_OKACTION
     * <P>
     * 确定（视图）
     * <li>VIEW_CANCELACTION
     * <P>
     * 取消（视图）
     * <li>VIEW_YESACTION
     * <P>
     * 是（视图）
     * <li>VIEW_NOACTION
     * <P>
     * 否（视图）
     * <li>UTIL_ADDSELECTION
     * <P>
     * 添加选中数据（数据选择）
     * <li>UTIL_REMOVESELECTION
     * <P>
     * 移除选中数据（数据选择）
     * <li>UTIL_ADDALL
     * <P>
     * 添加全部数据（数据选择）
     * <li>UTIL_REMOVEALL
     * <P>
     * 移除全部数据（数据选择）
     * <li>UTIL_PREVSTEP
     * <P>
     * 上一步（向导）
     * <li>UTIL_NEXTSTEP
     * <P>
     * 下一步（向导）
     * <li>UTIL_FINISH
     * <P>
     * 完成（向导）
     * <li>UTIL_SEARCH
     * <P>
     * 搜索（搜索栏）
     * <li>UTIL_RESET
     * <P>
     * 重置（搜索栏）
     * <li>APP_LOGIN
     * <P>
     * 登录操作
     * <li>APP_LOGOUT
     * <P>
     * 登出操作
     * <li>CUSTOM
     * <P>
     * 自定义代码
     * </ul>     
     */
    public static enum PanelButtonActionType{
        NONE("NONE", "无处理")
        ,UIACTION("UIACTION", "界面行为")
        ,UILOGIC("UILOGIC", "界面逻辑")
        ,OPENVIEW("OPENVIEW", "打开应用视图")
        ,OPENDEVIEW("OPENDEVIEW", "打开实体视图")
        ,OPENSYSPDTVIEW("OPENSYSPDTVIEW", "打开系统预置视图")
        ,OPENHTMLPAGE("OPENHTMLPAGE", "打开链接")
        ,DATA_CREATEOBJECT("DATA_CREATEOBJECT", "建立数据")
        ,DATA_SAVECHANGES("DATA_SAVECHANGES", "保存变更")
        ,DATA_CANCELCHANGES("DATA_CANCELCHANGES", "取消变更")
        ,DATA_REMOVEOBJECT("DATA_REMOVEOBJECT", "删除数据")
        ,DATA_SYNCHRONIZE("DATA_SYNCHRONIZE", "同步数据")
        ,VIEW_OKACTION("VIEW_OKACTION", "确定（视图）")
        ,VIEW_CANCELACTION("VIEW_CANCELACTION", "取消（视图）")
        ,VIEW_YESACTION("VIEW_YESACTION", "是（视图）")
        ,VIEW_NOACTION("VIEW_NOACTION", "否（视图）")
        ,UTIL_ADDSELECTION("UTIL_ADDSELECTION", "添加选中数据（数据选择）")
        ,UTIL_REMOVESELECTION("UTIL_REMOVESELECTION", "移除选中数据（数据选择）")
        ,UTIL_ADDALL("UTIL_ADDALL", "添加全部数据（数据选择）")
        ,UTIL_REMOVEALL("UTIL_REMOVEALL", "移除全部数据（数据选择）")
        ,UTIL_PREVSTEP("UTIL_PREVSTEP", "上一步（向导）")
        ,UTIL_NEXTSTEP("UTIL_NEXTSTEP", "下一步（向导）")
        ,UTIL_FINISH("UTIL_FINISH", "完成（向导）")
        ,UTIL_SEARCH("UTIL_SEARCH", "搜索（搜索栏）")
        ,UTIL_RESET("UTIL_RESET", "重置（搜索栏）")
        ,APP_LOGIN("APP_LOGIN", "登录操作")
        ,APP_LOGOUT("APP_LOGOUT", "登出操作")
        ,CUSTOM("CUSTOM", "自定义代码")
;
           
        public final String text;
        public final String value;
        
        private PanelButtonActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelButtonActionType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "UIACTION":
                    return UIACTION;
                case "UILOGIC":
                    return UILOGIC;
                case "OPENVIEW":
                    return OPENVIEW;
                case "OPENDEVIEW":
                    return OPENDEVIEW;
                case "OPENSYSPDTVIEW":
                    return OPENSYSPDTVIEW;
                case "OPENHTMLPAGE":
                    return OPENHTMLPAGE;
                case "DATA_CREATEOBJECT":
                    return DATA_CREATEOBJECT;
                case "DATA_SAVECHANGES":
                    return DATA_SAVECHANGES;
                case "DATA_CANCELCHANGES":
                    return DATA_CANCELCHANGES;
                case "DATA_REMOVEOBJECT":
                    return DATA_REMOVEOBJECT;
                case "DATA_SYNCHRONIZE":
                    return DATA_SYNCHRONIZE;
                case "VIEW_OKACTION":
                    return VIEW_OKACTION;
                case "VIEW_CANCELACTION":
                    return VIEW_CANCELACTION;
                case "VIEW_YESACTION":
                    return VIEW_YESACTION;
                case "VIEW_NOACTION":
                    return VIEW_NOACTION;
                case "UTIL_ADDSELECTION":
                    return UTIL_ADDSELECTION;
                case "UTIL_REMOVESELECTION":
                    return UTIL_REMOVESELECTION;
                case "UTIL_ADDALL":
                    return UTIL_ADDALL;
                case "UTIL_REMOVEALL":
                    return UTIL_REMOVEALL;
                case "UTIL_PREVSTEP":
                    return UTIL_PREVSTEP;
                case "UTIL_NEXTSTEP":
                    return UTIL_NEXTSTEP;
                case "UTIL_FINISH":
                    return UTIL_FINISH;
                case "UTIL_SEARCH":
                    return UTIL_SEARCH;
                case "UTIL_RESET":
                    return UTIL_RESET;
                case "APP_LOGIN":
                    return APP_LOGIN;
                case "APP_LOGOUT":
                    return APP_LOGOUT;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流数据同步代理消费节点类型
     * <P>
     * <ul>
     * <li>RAW
     * <P>
     * 直接流
     * <li>DEDATASYNC
     * <P>
     * 实体数据同步
     * </ul>     
     */
    public static enum DEDataFlowSysDataSyncAgentSinkType{
        RAW("RAW", "直接流")
        ,DEDATASYNC("DEDATASYNC", "实体数据同步")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysDataSyncAgentSinkType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysDataSyncAgentSinkType from(String value){
            switch(value){
                case "RAW":
                    return RAW;
                case "DEDATASYNC":
                    return DEDATASYNC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表对象类型
     * <P>
     * <ul>
     * <li>TABLE
     * <P>
     * 数据表
     * </ul>     
     */
    public static enum DBTableType{
        TABLE("TABLE", "数据表")
;
           
        public final String text;
        public final String value;
        
        private DBTableType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBTableType from(String value){
            switch(value){
                case "TABLE":
                    return TABLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索属性数据类型
     * <P>
     * <ul>
     * <li>TEXT
     * <P>
     * Text
     * <li>INTEGER
     * <P>
     * Integer
     * <li>LONG
     * <P>
     * Long
     * <li>DATE
     * <P>
     * Date
     * <li>FLOAT
     * <P>
     * Float
     * <li>DOUBLE
     * <P>
     * Double
     * <li>BOOLEAN
     * <P>
     * Boolean
     * <li>OBJECT
     * <P>
     * Object
     * <li>AUTO
     * <P>
     * Auto，自动判断
     * <li>NESTED
     * <P>
     * Nested
     * <li>IP
     * <P>
     * Ip
     * <li>ATTACHMENT
     * <P>
     * Attachment
     * <li>KEYWORD
     * <P>
     * Keyword
     * <li>DENSE_VECTOR
     * <P>
     * DenseVector
     * <li>GEO_POINT
     * <P>
     * GeoPoint
     * </ul>     
     */
    public static enum SearchFieldDataType{
        TEXT("TEXT", "Text")
        ,INTEGER("INTEGER", "Integer")
        ,LONG("LONG", "Long")
        ,DATE("DATE", "Date")
        ,FLOAT("FLOAT", "Float")
        ,DOUBLE("DOUBLE", "Double")
        ,BOOLEAN("BOOLEAN", "Boolean")
        ,OBJECT("OBJECT", "Object")
        ,AUTO("AUTO", "Auto")
        ,NESTED("NESTED", "Nested")
        ,IP("IP", "Ip")
        ,ATTACHMENT("ATTACHMENT", "Attachment")
        ,KEYWORD("KEYWORD", "Keyword")
        ,DENSE_VECTOR("DENSE_VECTOR", "DenseVector")
        ,GEO_POINT("GEO_POINT", "GeoPoint")
;
           
        public final String text;
        public final String value;
        
        private SearchFieldDataType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchFieldDataType from(String value){
            switch(value){
                case "TEXT":
                    return TEXT;
                case "INTEGER":
                    return INTEGER;
                case "LONG":
                    return LONG;
                case "DATE":
                    return DATE;
                case "FLOAT":
                    return FLOAT;
                case "DOUBLE":
                    return DOUBLE;
                case "BOOLEAN":
                    return BOOLEAN;
                case "OBJECT":
                    return OBJECT;
                case "AUTO":
                    return AUTO;
                case "NESTED":
                    return NESTED;
                case "IP":
                    return IP;
                case "ATTACHMENT":
                    return ATTACHMENT;
                case "KEYWORD":
                    return KEYWORD;
                case "DENSE_VECTOR":
                    return DENSE_VECTOR;
                case "GEO_POINT":
                    return GEO_POINT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 集成元素类型
     * <P>
     * <ul>
     * <li>COMPLEX
     * <P>
     * 复合元素
     * <li>ELEMENTGROUP
     * <P>
     * 元素组
     * <li>ATTRIBUTEGROUP
     * <P>
     * 属性组
     * </ul>     
     */
    public static enum EAIElementType{
        COMPLEX("COMPLEX", "复合元素")
        ,ELEMENTGROUP("ELEMENTGROUP", "元素组")
        ,ATTRIBUTEGROUP("ATTRIBUTEGROUP", "属性组")
;
           
        public final String text;
        public final String value;
        
        private EAIElementType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EAIElementType from(String value){
            switch(value){
                case "COMPLEX":
                    return COMPLEX;
                case "ELEMENTGROUP":
                    return ELEMENTGROUP;
                case "ATTRIBUTEGROUP":
                    return ATTRIBUTEGROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体示例数据类型
     * <P>
     * <ul>
     * <li>JSON
     * <P>
     * JSON数据
     * <li>XML
     * <P>
     * XML数据
     * <li>SCRIPT
     * <P>
     * 脚本
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum SampleDataType{
        JSON("JSON", "JSON数据")
        ,XML("XML", "XML数据")
        ,SCRIPT("SCRIPT", "脚本")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private SampleDataType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SampleDataType from(String value){
            switch(value){
                case "JSON":
                    return JSON;
                case "XML":
                    return XML;
                case "SCRIPT":
                    return SCRIPT;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性视图列级别（带属性组）（带-1），数值项
     * <P>
     * <ul>
     * <li>QUERYCOLUMN&nbsp;(-1)
     * <P>
     * 默认（全部查询列）
     * <li>ALL&nbsp;(0)
     * <P>
     * 全部数据
     * <li>LEVEL1&nbsp;(1)
     * <P>
     * 2级（无行外数据）
     * <li>LEVEL2&nbsp;(2)
     * <P>
     * 3级（关键数据）
     * <li>LEVEL3&nbsp;(3)
     * <P>
     * 4级（个别字段）
     * <li>DEFGROUP&nbsp;(100)
     * <P>
     * 指定属性组
     * </ul>     
     */
    public static enum DEDataQueryViewLevel{
        QUERYCOLUMN(-1, "默认（全部查询列）")
        ,ALL(0, "全部数据")
        ,LEVEL1(1, "2级（无行外数据）")
        ,LEVEL2(2, "3级（关键数据）")
        ,LEVEL3(3, "4级（个别字段）")
        ,DEFGROUP(100, "指定属性组")
;
           
        public final String text;
        public final int value;
        
        private DEDataQueryViewLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataQueryViewLevel from(int value){
            switch(value){
                case -1:
                    return QUERYCOLUMN;
                case 0:
                    return ALL;
                case 1:
                    return LEVEL1;
                case 2:
                    return LEVEL2;
                case 3:
                    return LEVEL3;
                case 100:
                    return DEFGROUP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台表单成员类型2（静态）
     * <P>
     * <ul>
     * <li>FORMPAGE
     * <P>
     * 表单分页，表单模型的顶级成员，其它成员都必须在表单分页模型中，如表单中只存在一个表单分页，则默认不输出表单分页头。只允许放置在表单对象中
     * <li>TABPANEL
     * <P>
     * 分页部件，表单中的分页部件，提供除表单默认分页外的分页界面容器。分页部件只能包含分页面板
     * <li>TABPAGE
     * <P>
     * 分页面板，表单分页部件的成员部件，是基础的布局容器。只允许放置在分页部件中
     * <li>FORMITEM
     * <P>
     * 表单项，表单数据项的载体，包括了标签及编辑器控件，负责表单数据的输入输出。表单模型中的叶子节点，不拥有其它表单成员
     * <li>USERCONTROL
     * <P>
     * 用户控件，表单中的自定义用户部件，需指定前端模板插件进行内容输出
     * <li>FORMPART
     * <P>
     * 表单部件，表单部件引用模型，表单部件引用有两种模式，一种是引入设计时的其它表单，会将引用表单的内容直接附加到当前表单（不存在表单引用部件），另一个是运行时引用，引入动态子系统的动态表单，这种表单引用部件将被输出到表单中
     * <li>GROUPPANEL
     * <P>
     * 分组面板，表单中的基本布局面板，输出标题的面板承担分类数据呈现，不输出标题的面板更多承担布局功能（默认无内、外边框）
     * <li>DRUIPART
     * <P>
     * 数据关系界面，表单中的关系数据界面容器，嵌入关系界面并进行驱动，完成加载、刷新等基本功能
     * <li>RAWITEM
     * <P>
     * 直接内容，表单中的直接内容项，输出文本或图片
     * <li>BUTTON
     * <P>
     * 表单按钮，表单中的按钮对象，为表单提供命令能力
     * <li>IFRAME
     * <P>
     * 直接页面嵌入，表单中的网页容器，嵌入网页并进行驱动，完成加载、刷新等基本功能
     * <li>FORMITEMEX
     * <P>
     * 复合表单项，表单中的复合表单项，符合表单项是将多个表单项联合进行输入及输出。只允许包含表单项成员
     * <li>MDCTRL
     * <P>
     * 多数据部件，表单中的多数据部件项，将项数据以数据的形式提供，绑定到多数据部件指定的列表部件中
     * </ul>     
     */
    public static enum FormDetailType{
        FORMPAGE("FORMPAGE", "表单分页")
        ,TABPANEL("TABPANEL", "分页部件")
        ,TABPAGE("TABPAGE", "分页面板")
        ,FORMITEM("FORMITEM", "表单项")
        ,USERCONTROL("USERCONTROL", "用户控件")
        ,FORMPART("FORMPART", "表单部件")
        ,GROUPPANEL("GROUPPANEL", "分组面板")
        ,DRUIPART("DRUIPART", "数据关系界面")
        ,RAWITEM("RAWITEM", "直接内容")
        ,BUTTON("BUTTON", "表单按钮")
        ,IFRAME("IFRAME", "直接页面嵌入")
        ,FORMITEMEX("FORMITEMEX", "复合表单项")
        ,MDCTRL("MDCTRL", "多数据部件")
;
           
        public final String text;
        public final String value;
        
        private FormDetailType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormDetailType from(String value){
            switch(value){
                case "FORMPAGE":
                    return FORMPAGE;
                case "TABPANEL":
                    return TABPANEL;
                case "TABPAGE":
                    return TABPAGE;
                case "FORMITEM":
                    return FORMITEM;
                case "USERCONTROL":
                    return USERCONTROL;
                case "FORMPART":
                    return FORMPART;
                case "GROUPPANEL":
                    return GROUPPANEL;
                case "DRUIPART":
                    return DRUIPART;
                case "RAWITEM":
                    return RAWITEM;
                case "BUTTON":
                    return BUTTON;
                case "IFRAME":
                    return IFRAME;
                case "FORMITEMEX":
                    return FORMITEMEX;
                case "MDCTRL":
                    return MDCTRL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云流程处理参数值类型
     * <P>
     * <ul>
     * <li>SESSION
     * <P>
     * 用户全局对象
     * <li>APPLICATION
     * <P>
     * 系统全局对象
     * <li>UNIQUEID
     * <P>
     * 唯一编码
     * <li>CONTEXT
     * <P>
     * 网页请求
     * <li>OPERATOR
     * <P>
     * 当前操作用户(编号)
     * <li>OPERATORNAME
     * <P>
     * 当前操作用户(名称)
     * <li>CURTIME
     * <P>
     * 当前时间
     * </ul>     
     */
    public static enum WFProcParamValueType{
        SESSION("SESSION", "用户全局对象")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,UNIQUEID("UNIQUEID", "唯一编码")
        ,CONTEXT("CONTEXT", "网页请求")
        ,OPERATOR("OPERATOR", "当前操作用户(编号)")
        ,OPERATORNAME("OPERATORNAME", "当前操作用户(名称)")
        ,CURTIME("CURTIME", "当前时间")
;
           
        public final String text;
        public final String value;
        
        private WFProcParamValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProcParamValueType from(String value){
            switch(value){
                case "SESSION":
                    return SESSION;
                case "APPLICATION":
                    return APPLICATION;
                case "UNIQUEID":
                    return UNIQUEID;
                case "CONTEXT":
                    return CONTEXT;
                case "OPERATOR":
                    return OPERATOR;
                case "OPERATORNAME":
                    return OPERATORNAME;
                case "CURTIME":
                    return CURTIME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树部件表格列即时编辑模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>ROW&nbsp;(1)
     * <P>
     * 行编辑
     * <li>CHANGEDONLY&nbsp;(2048)
     * <P>
     * 提交变化，仅提交变化值
     * </ul>     
     */
    public static enum TreeColEditMode{
        ROW(1, "行编辑")
        ,CHANGEDONLY(2048, "提交变化")
;
           
        public final String text;
        public final int value;
        
        private TreeColEditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeColEditMode from(int value){
            switch(value){
                case 1:
                    return ROW;
                case 2048:
                    return CHANGEDONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体图表坐标系统
     * <P>
     * <ul>
     * <li>XY
     * <P>
     * 直角坐标系
     * <li>POLAR
     * <P>
     * 极坐标系
     * <li>RADAR
     * <P>
     * 雷达坐标系
     * <li>PARALLEL
     * <P>
     * 平行坐标系
     * <li>SINGLE
     * <P>
     * 单轴坐标系
     * <li>CALENDAR
     * <P>
     * 日历坐标系
     * <li>MAP
     * <P>
     * 地图坐标系
     * <li>NONE
     * <P>
     * 无坐标系
     * </ul>     
     */
    public static enum ChartCoordinateSystem{
        XY("XY", "直角坐标系")
        ,POLAR("POLAR", "极坐标系")
        ,RADAR("RADAR", "雷达坐标系")
        ,PARALLEL("PARALLEL", "平行坐标系")
        ,SINGLE("SINGLE", "单轴坐标系")
        ,CALENDAR("CALENDAR", "日历坐标系")
        ,MAP("MAP", "地图坐标系")
        ,NONE("NONE", "无坐标系")
;
           
        public final String text;
        public final String value;
        
        private ChartCoordinateSystem(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartCoordinateSystem from(String value){
            switch(value){
                case "XY":
                    return XY;
                case "POLAR":
                    return POLAR;
                case "RADAR":
                    return RADAR;
                case "PARALLEL":
                    return PARALLEL;
                case "SINGLE":
                    return SINGLE;
                case "CALENDAR":
                    return CALENDAR;
                case "MAP":
                    return MAP;
                case "NONE":
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表格链接模式，数值项
     * <P>
     * <ul>
     * <li>DISABLE&nbsp;(0)
     * <P>
     * 不启用
     * <li>ENABLE&nbsp;(1)
     * <P>
     * 启用
     * <li>AUTO&nbsp;(2)
     * <P>
     * 启用（自动判断），如果表格列存在链接视图则启用，否则不启用
     * </ul>     
     */
    public static enum DEGridColLinkMode{
        DISABLE(0, "不启用")
        ,ENABLE(1, "启用")
        ,AUTO(2, "启用（自动判断）")
;
           
        public final String text;
        public final int value;
        
        private DEGridColLinkMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEGridColLinkMode from(int value){
            switch(value){
                case 0:
                    return DISABLE;
                case 1:
                    return ENABLE;
                case 2:
                    return AUTO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用菜单样式
     * <P>
     * <ul>
     * <li>ICONVIEW
     * <P>
     * 图标视图
     * <li>LISTVIEW
     * <P>
     * 列表视图
     * <li>SWIPERVIEW
     * <P>
     * 图片滑动视图
     * <li>LISTVIEW2
     * <P>
     * 列表视图（无刷新）
     * <li>LISTVIEW3
     * <P>
     * 列表视图（无滑动）
     * <li>LISTVIEW4
     * <P>
     * 列表视图（无背景）
     * <li>EXTVIEW1
     * <P>
     * 扩展视图1
     * <li>EXTVIEW2
     * <P>
     * 扩展视图2
     * <li>EXTVIEW3
     * <P>
     * 扩展视图3
     * <li>EXTVIEW4
     * <P>
     * 扩展视图4
     * <li>EXTVIEW5
     * <P>
     * 扩展视图5
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum AppMenuStyle{
        ICONVIEW("ICONVIEW", "图标视图")
        ,LISTVIEW("LISTVIEW", "列表视图")
        ,SWIPERVIEW("SWIPERVIEW", "图片滑动视图")
        ,LISTVIEW2("LISTVIEW2", "列表视图（无刷新）")
        ,LISTVIEW3("LISTVIEW3", "列表视图（无滑动）")
        ,LISTVIEW4("LISTVIEW4", "列表视图（无背景）")
        ,EXTVIEW1("EXTVIEW1", "扩展视图1")
        ,EXTVIEW2("EXTVIEW2", "扩展视图2")
        ,EXTVIEW3("EXTVIEW3", "扩展视图3")
        ,EXTVIEW4("EXTVIEW4", "扩展视图4")
        ,EXTVIEW5("EXTVIEW5", "扩展视图5")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private AppMenuStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppMenuStyle from(String value){
            switch(value){
                case "ICONVIEW":
                    return ICONVIEW;
                case "LISTVIEW":
                    return LISTVIEW;
                case "SWIPERVIEW":
                    return SWIPERVIEW;
                case "LISTVIEW2":
                    return LISTVIEW2;
                case "LISTVIEW3":
                    return LISTVIEW3;
                case "LISTVIEW4":
                    return LISTVIEW4;
                case "EXTVIEW1":
                    return EXTVIEW1;
                case "EXTVIEW2":
                    return EXTVIEW2;
                case "EXTVIEW3":
                    return EXTVIEW3;
                case "EXTVIEW4":
                    return EXTVIEW4;
                case "EXTVIEW5":
                    return EXTVIEW5;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性界面项默认值类型（更新）
     * <P>
     * <ul>
     * <li>RESET
     * <P>
     * 置空当前值，置空当前值
     * <li>SESSION
     * <P>
     * 用户全局对象，当前用户的上下文对象，需指定属性键名
     * <li>APPLICATION
     * <P>
     * 系统全局对象，当前系统的上下文对象，需指定属性键名
     * <li>UNIQUEID
     * <P>
     * 唯一编码，生成一个随机标识，一般使用GUID
     * <li>CONTEXT
     * <P>
     * 网页请求，当前请求的参数对象，需指定属性键名
     * <li>PARAM
     * <P>
     * 数据对象属性，当前处理的数据对象，需指定属性键名，数据对象属性的处理一般放在最后，让其它逻辑先完成数据对象填充
     * <li>OPERATOR
     * <P>
     * 当前操作用户(编号)，当前处理的用户标识
     * <li>OPERATORNAME
     * <P>
     * 当前操作用户(名称)，当前处理的用户名称
     * <li>CURTIME
     * <P>
     * 当前时间，当前系统时间
     * <li>APPDATA
     * <P>
     * 当前应用数据，当前应用的上下文对象，需指定属性键名。当前应用指正在运行的前端程序的环境变量，如应用打开的数据，使用的用户身份等
     * </ul>     
     */
    public static enum UpdateDefaultValueType{
        RESET("RESET", "置空当前值")
        ,SESSION("SESSION", "用户全局对象")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,UNIQUEID("UNIQUEID", "唯一编码")
        ,CONTEXT("CONTEXT", "网页请求")
        ,PARAM("PARAM", "数据对象属性")
        ,OPERATOR("OPERATOR", "当前操作用户(编号)")
        ,OPERATORNAME("OPERATORNAME", "当前操作用户(名称)")
        ,CURTIME("CURTIME", "当前时间")
        ,APPDATA("APPDATA", "当前应用数据")
;
           
        public final String text;
        public final String value;
        
        private UpdateDefaultValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UpdateDefaultValueType from(String value){
            switch(value){
                case "RESET":
                    return RESET;
                case "SESSION":
                    return SESSION;
                case "APPLICATION":
                    return APPLICATION;
                case "UNIQUEID":
                    return UNIQUEID;
                case "CONTEXT":
                    return CONTEXT;
                case "PARAM":
                    return PARAM;
                case "OPERATOR":
                    return OPERATOR;
                case "OPERATORNAME":
                    return OPERATORNAME;
                case "CURTIME":
                    return CURTIME;
                case "APPDATA":
                    return APPDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器后台处理对象类型
     * <P>
     * <ul>
     * <li>NONE&nbsp;(None)
     * <P>
     * 无处理
     * <li>CODELIST&nbsp;(CodeList)
     * <P>
     * 代码表，编辑器需要提供【代码表】界面处理模式，包括指定代码表
     * <li>PICKUPTEXT&nbsp;(PickupText)
     * <P>
     * 外键文本，编辑器需要提供【外键文本】界面处理模式，包括指定外键值项、引用的数据集合、自动填充模式等
     * <li>AC
     * <P>
     * 自动填充，编辑器需要提供【自动填充】界面处理模式编辑器，包括引用的数据集合、自动填充模式等
     * <li>CUSTOM&nbsp;(Custom)
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum EditorHandlerType{
        NONE("None", "无处理")
        ,CODELIST("CodeList", "代码表")
        ,PICKUPTEXT("PickupText", "外键文本")
        ,AC("AC", "自动填充")
        ,CUSTOM("Custom", "自定义")
;
           
        public final String text;
        public final String value;
        
        private EditorHandlerType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditorHandlerType from(String value){
            switch(value){
                case "None":
                    return NONE;
                case "CodeList":
                    return CODELIST;
                case "PickupText":
                    return PICKUPTEXT;
                case "AC":
                    return AC;
                case "Custom":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统模型仓库源
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>PS
     * <P>
     * 平台系统模型库
     * <li>DC
     * <P>
     * 中心系统模型库
     * </ul>     
     */
    public static enum ModelRepoFrom{
        NONE("NONE", "无")
        ,PS("PS", "平台系统模型库")
        ,DC("DC", "中心系统模型库")
;
           
        public final String text;
        public final String value;
        
        private ModelRepoFrom(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelRepoFrom from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "PS":
                    return PS;
                case "DC":
                    return DC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性只读模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>NOCREATE&nbsp;(1)
     * <P>
     * 无建立
     * <li>NOUPDATE&nbsp;(2)
     * <P>
     * 无更新
     * </ul>     
     */
    public static enum DEFReadOnlyMode{
        NOCREATE(1, "无建立")
        ,NOUPDATE(2, "无更新")
;
           
        public final String text;
        public final int value;
        
        private DEFReadOnlyMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFReadOnlyMode from(int value){
            switch(value){
                case 1:
                    return NOCREATE;
                case 2:
                    return NOUPDATE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件后台处理对象缓存范围，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>GLOBAL&nbsp;(1)
     * <P>
     * 系统全局，系统全局缓存界面处理响应内容
     * <li>ORG&nbsp;(2)
     * <P>
     * 组织机构全局，以当前用户身份组织机构维度缓存界面处理响应内容
     * <li>USER&nbsp;(3)
     * <P>
     * 用户全局，以当前用户身份维度缓存界面处理响应内容
     * <li>APP&nbsp;(4)
     * <P>
     * 应用全局，应用全局缓存界面处理响应内容
     * </ul>     
     */
    public static enum CtrlHandlerCacheScope{
        NONE(0, "无")
        ,GLOBAL(1, "系统全局")
        ,ORG(2, "组织机构全局")
        ,USER(3, "用户全局")
        ,APP(4, "应用全局")
;
           
        public final String text;
        public final int value;
        
        private CtrlHandlerCacheScope(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlHandlerCacheScope from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return GLOBAL;
                case 2:
                    return ORG;
                case 3:
                    return USER;
                case 4:
                    return APP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体1：N关系主从关系类型，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>RELATED&nbsp;(1)
     * <P>
     * 附属关系，从实体是主实体的附属实体
     * <li>NN&nbsp;(2)
     * <P>
     * 附属关系(N:N连接)，从实体是主实体的附属实体，是N:N关系的一边
     * <li>DAC&nbsp;(4)
     * <P>
     * 数据访问控制，从实体的操作标识将映射到主实体，由主实体进行访问控制
     * <li>NESTED&nbsp;(8)
     * <P>
     * 嵌套操作，从实体是主实体的嵌套数据成员
     * <li>RECURSIVE&nbsp;(16)
     * <P>
     * 递归关系，从实体与主实体是递归关系
     * <li>NOTIFY&nbsp;(32)
     * <P>
     * 关联通知，从实体触发父实体通知
     * <li>EXTENSION&nbsp;(64)
     * <P>
     * 附属扩展
     * <li>VERSION&nbsp;(128)
     * <P>
     * 限定版本
     * <li>USER&nbsp;(1048576)
     * <P>
     * 自定义
     * <li>USER2&nbsp;(2097152)
     * <P>
     * 自定义2
     * <li>USER3&nbsp;(4194304)
     * <P>
     * 自定义3
     * <li>USER4&nbsp;(8388608)
     * <P>
     * 自定义4
     * </ul>     
     */
    public static enum DER1NMasterRS{
        RELATED(1, "附属关系")
        ,NN(2, "附属关系(N:N连接)")
        ,DAC(4, "数据访问控制")
        ,NESTED(8, "嵌套操作")
        ,RECURSIVE(16, "递归关系")
        ,NOTIFY(32, "关联通知")
        ,EXTENSION(64, "附属扩展")
        ,VERSION(128, "限定版本")
        ,USER(1048576, "自定义")
        ,USER2(2097152, "自定义2")
        ,USER3(4194304, "自定义3")
        ,USER4(8388608, "自定义4")
;
           
        public final String text;
        public final int value;
        
        private DER1NMasterRS(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DER1NMasterRS from(int value){
            switch(value){
                case 1:
                    return RELATED;
                case 2:
                    return NN;
                case 4:
                    return DAC;
                case 8:
                    return NESTED;
                case 16:
                    return RECURSIVE;
                case 32:
                    return NOTIFY;
                case 64:
                    return EXTENSION;
                case 128:
                    return VERSION;
                case 1048576:
                    return USER;
                case 2097152:
                    return USER2;
                case 4194304:
                    return USER3;
                case 8388608:
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据流合并类型
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认，数据源和数据源2合并新的数据源，如数据源2没有找到对应数据源，则忽略
     * <li>UNION
     * <P>
     * 排重合并，数据源和数据源2排重合并形成新的数据源
     * <li>UNIONALL
     * <P>
     * 全部合并，数据源和数据源2全部合并形成新的数据源
     * <li>INTERSECTION
     * <P>
     * 交集（合并数据源和数据源2重复出现的数据），合并数据源和数据源2重复出现的数据到新数据源
     * <li>DEFFERENCE
     * <P>
     * 差集（合并数据源和数据源2没有重复出现的数据），合并数据源和数据源2没有重复出现的数据到新数据源
     * <li>MERGEINTOFIELD
     * <P>
     * 合并到属性（单项），将数据源2合并至数据源指定属性，单项模式
     * <li>MERGEINTOFIELD2
     * <P>
     * 合并到属性（列表），将数据源2合并至数据源指定属性，多项模式
     * </ul>     
     */
    public static enum DEDataFlowMergeType{
        DEFAULT("DEFAULT", "默认")
        ,UNION("UNION", "排重合并")
        ,UNIONALL("UNIONALL", "全部合并")
        ,INTERSECTION("INTERSECTION", "交集（合并数据源和数据源2重复出现的数据）")
        ,DEFFERENCE("DEFFERENCE", "差集（合并数据源和数据源2没有重复出现的数据）")
        ,MERGEINTOFIELD("MERGEINTOFIELD", "合并到属性（单项）")
        ,MERGEINTOFIELD2("MERGEINTOFIELD2", "合并到属性（列表）")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowMergeType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowMergeType from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "UNION":
                    return UNION;
                case "UNIONALL":
                    return UNIONALL;
                case "INTERSECTION":
                    return INTERSECTION;
                case "DEFFERENCE":
                    return DEFFERENCE;
                case "MERGEINTOFIELD":
                    return MERGEINTOFIELD;
                case "MERGEINTOFIELD2":
                    return MERGEINTOFIELD2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 部件后台处理行为类型
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为，界面请求由实体行为处理反馈，一般为对单项数据的操作
     * <li>DEDATASET
     * <P>
     * 实体结果集，界面请求由实体数据集处理反馈，一般为数据查询或导出
     * </ul>     
     */
    public static enum CtrlHandlerActionType{
        DEACTION("DEACTION", "实体行为")
        ,DEDATASET("DEDATASET", "实体结果集")
;
           
        public final String text;
        public final String value;
        
        private CtrlHandlerActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CtrlHandlerActionType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "DEDATASET":
                    return DEDATASET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 代码表或模式2
     * <P>
     * <ul>
     * <li>NUM
     * <P>
     * 数字或处理，多项值按位或处理，一般代码项的值对应字节的位：1、2、4、8等
     * <li>STR
     * <P>
     * 文本或模式，代码项的值使用分隔符号拼接
     * </ul>     
     */
    public static enum CodeListOrMode{
        NUM("NUM", "数字或处理")
        ,STR("STR", "文本或模式")
;
           
        public final String text;
        public final String value;
        
        private CodeListOrMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CodeListOrMode from(String value){
            switch(value){
                case "NUM":
                    return NUM;
                case "STR":
                    return STR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据流节点类型
     * <P>
     * <ul>
     * <li>DFSYSRESOURCESOURCE
     * <P>
     * 数据流预置资源源
     * <li>DFSORTPROCESS
     * <P>
     * 数据流排序处理
     * <li>DFSYSRESOURCESINK
     * <P>
     * 数据流预置资源消费，ULL 值
     * <li>DFSYSDBSCHEMESOURCE
     * <P>
     * 数据流数据库源
     * <li>DFSYSDBSCHEMESINK
     * <P>
     * 数据流数据库消费
     * <li>DFSYSDATASYNCAGENTSOURCE
     * <P>
     * 数据流数据同步代理源
     * <li>DFSYSDATASYNCAGENTSINK
     * <P>
     * 数据流数据同步代理消费
     * <li>DFSYSBDSCHEMESOURCE
     * <P>
     * 数据流大数据库源
     * <li>DFSYSBDSCHEMESINK
     * <P>
     * 数据流大数据库消费
     * <li>DFSUBSYSSERVICEAPISOURCE
     * <P>
     * 数据流外部服务接口源
     * <li>DFPREPAREPROCESS
     * <P>
     * 数据流准备处理
     * <li>DFSUBSYSSERVICEAPISINK
     * <P>
     * 数据流外部接口消费
     * <li>DFMERGEPROCESS
     * <P>
     * 数据流合并处理
     * <li>DFJOINPROCESS
     * <P>
     * 数据流连接处理
     * <li>DFDEDATASETSOURCE
     * <P>
     * 数据流实体数据集源
     * <li>DFDEDATAFLOWSINK
     * <P>
     * 数据流数据流消费
     * <li>DFAGGREGATEPROCESS
     * <P>
     * 数据流聚合处理
     * <li>DFDEACTIONSINK
     * <P>
     * 数据流实体行为消费
     * <li>DFDEDATASYNCSINK
     * <P>
     * 数据流实体数据同步消费
     * </ul>     
     */
    public static enum DEDataFlowNodeType{
        DFSYSRESOURCESOURCE("DFSYSRESOURCESOURCE", "数据流预置资源源")
        ,DFSORTPROCESS("DFSORTPROCESS", "数据流排序处理")
        ,DFSYSRESOURCESINK("DFSYSRESOURCESINK", "数据流预置资源消费")
        ,DFSYSDBSCHEMESOURCE("DFSYSDBSCHEMESOURCE", "数据流数据库源")
        ,DFSYSDBSCHEMESINK("DFSYSDBSCHEMESINK", "数据流数据库消费")
        ,DFSYSDATASYNCAGENTSOURCE("DFSYSDATASYNCAGENTSOURCE", "数据流数据同步代理源")
        ,DFSYSDATASYNCAGENTSINK("DFSYSDATASYNCAGENTSINK", "数据流数据同步代理消费")
        ,DFSYSBDSCHEMESOURCE("DFSYSBDSCHEMESOURCE", "数据流大数据库源")
        ,DFSYSBDSCHEMESINK("DFSYSBDSCHEMESINK", "数据流大数据库消费")
        ,DFSUBSYSSERVICEAPISOURCE("DFSUBSYSSERVICEAPISOURCE", "数据流外部服务接口源")
        ,DFPREPAREPROCESS("DFPREPAREPROCESS", "数据流准备处理")
        ,DFSUBSYSSERVICEAPISINK("DFSUBSYSSERVICEAPISINK", "数据流外部接口消费")
        ,DFMERGEPROCESS("DFMERGEPROCESS", "数据流合并处理")
        ,DFJOINPROCESS("DFJOINPROCESS", "数据流连接处理")
        ,DFDEDATASETSOURCE("DFDEDATASETSOURCE", "数据流实体数据集源")
        ,DFDEDATAFLOWSINK("DFDEDATAFLOWSINK", "数据流数据流消费")
        ,DFAGGREGATEPROCESS("DFAGGREGATEPROCESS", "数据流聚合处理")
        ,DFDEACTIONSINK("DFDEACTIONSINK", "数据流实体行为消费")
        ,DFDEDATASYNCSINK("DFDEDATASYNCSINK", "数据流实体数据同步消费")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowNodeType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowNodeType from(String value){
            switch(value){
                case "DFSYSRESOURCESOURCE":
                    return DFSYSRESOURCESOURCE;
                case "DFSORTPROCESS":
                    return DFSORTPROCESS;
                case "DFSYSRESOURCESINK":
                    return DFSYSRESOURCESINK;
                case "DFSYSDBSCHEMESOURCE":
                    return DFSYSDBSCHEMESOURCE;
                case "DFSYSDBSCHEMESINK":
                    return DFSYSDBSCHEMESINK;
                case "DFSYSDATASYNCAGENTSOURCE":
                    return DFSYSDATASYNCAGENTSOURCE;
                case "DFSYSDATASYNCAGENTSINK":
                    return DFSYSDATASYNCAGENTSINK;
                case "DFSYSBDSCHEMESOURCE":
                    return DFSYSBDSCHEMESOURCE;
                case "DFSYSBDSCHEMESINK":
                    return DFSYSBDSCHEMESINK;
                case "DFSUBSYSSERVICEAPISOURCE":
                    return DFSUBSYSSERVICEAPISOURCE;
                case "DFPREPAREPROCESS":
                    return DFPREPAREPROCESS;
                case "DFSUBSYSSERVICEAPISINK":
                    return DFSUBSYSSERVICEAPISINK;
                case "DFMERGEPROCESS":
                    return DFMERGEPROCESS;
                case "DFJOINPROCESS":
                    return DFJOINPROCESS;
                case "DFDEDATASETSOURCE":
                    return DFDEDATASETSOURCE;
                case "DFDEDATAFLOWSINK":
                    return DFDEDATAFLOWSINK;
                case "DFAGGREGATEPROCESS":
                    return DFAGGREGATEPROCESS;
                case "DFDEACTIONSINK":
                    return DFDEACTIONSINK;
                case "DFDEDATASYNCSINK":
                    return DFDEDATASYNCSINK;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体联合键值模式
     * <P>
     * <ul>
     * <li>DIGEST
     * <P>
     * 摘要
     * <li>DELIMITER
     * <P>
     * 分隔符
     * </ul>     
     */
    public static enum DEUnionKeyMode{
        DIGEST("DIGEST", "摘要")
        ,DELIMITER("DELIMITER", "分隔符")
;
           
        public final String text;
        public final String value;
        
        private DEUnionKeyMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEUnionKeyMode from(String value){
            switch(value){
                case "DIGEST":
                    return DIGEST;
                case "DELIMITER":
                    return DELIMITER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台移动端编辑视图类型
     * <P>
     * <ul>
     * <li>DEMOBEDITVIEW
     * <P>
     * 实体移动端编辑视图
     * <li>DEMOBEDITVIEW3
     * <P>
     * 实体移动端编辑视图（分页关系）
     * </ul>     
     */
    public static enum DEMobEditViewType{
        DEMOBEDITVIEW("DEMOBEDITVIEW", "实体移动端编辑视图")
        ,DEMOBEDITVIEW3("DEMOBEDITVIEW3", "实体移动端编辑视图（分页关系）")
;
           
        public final String text;
        public final String value;
        
        private DEMobEditViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMobEditViewType from(String value){
            switch(value){
                case "DEMOBEDITVIEW":
                    return DEMOBEDITVIEW;
                case "DEMOBEDITVIEW3":
                    return DEMOBEDITVIEW3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体关系类型
     * <P>
     * <ul>
     * <li>DER1N
     * <P>
     * 1:N关系，主实体与从实体是一对多的关系，从实体建立连接到主实体的属性（外键）
     * <li>DERINHERIT
     * <P>
     * 继承关系，继承关系不算严格的一对一关系，从实体与主实体之间是特定类型数据的一对一关系。从实体只允许存在一个继承关系，从实体需要继承主实体的存储能力或逻辑能力才能提供功能，执行功能时从实体需先操作主实体（直接存储或调用逻辑）再进行自身的存储或逻辑处理
     * <li>DERINDEX
     * <P>
     * 索引关系，从实体允许建立多个索引关系，从实体独立提供功能，功能执行后再同步至主实体
     * <li>DER11
     * <P>
     * 1:1 关系，主实体与从实体是一对一的关系，从实体的主键是连接到主实体的属性（外键）
     * <li>DERMULINH
     * <P>
     * 多继承关系（虚拟实体），虚拟实体建立多个到主实体的虚拟继承关系，从每个主实体选择相应的数据使用一对一的连接拼装出新的实体
     * <li>DERCUSTOM
     * <P>
     * 自定义关系，主实体和从实体建立自定义的关系，通过指定关系子类型进一步指定自定义关系的模式
     * <li>DERAGGDATA
     * <P>
     * 聚合数据关系，聚合数据关系主实体一般为统计数据源，从实体为业务数据。将业务数据按照统计维度进行汇聚
     * </ul>     
     */
    public static enum DERType{
        DER1N("DER1N", "1:N关系")
        ,DERINHERIT("DERINHERIT", "继承关系")
        ,DERINDEX("DERINDEX", "索引关系")
        ,DER11("DER11", "1:1 关系")
        ,DERMULINH("DERMULINH", "多继承关系（虚拟实体）")
        ,DERCUSTOM("DERCUSTOM", "自定义关系")
        ,DERAGGDATA("DERAGGDATA", "聚合数据关系")
;
           
        public final String text;
        public final String value;
        
        private DERType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERType from(String value){
            switch(value){
                case "DER1N":
                    return DER1N;
                case "DERINHERIT":
                    return DERINHERIT;
                case "DERINDEX":
                    return DERINDEX;
                case "DER11":
                    return DER11;
                case "DERMULINH":
                    return DERMULINH;
                case "DERCUSTOM":
                    return DERCUSTOM;
                case "DERAGGDATA":
                    return DERAGGDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 动态系统模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 不启用
     * <li>ENABLED&nbsp;(1)
     * <P>
     * 启用
     * </ul>     
     */
    public static enum DynaSysMode{
        DISABLED(0, "不启用")
        ,ENABLED(1, "启用")
;
           
        public final String text;
        public final int value;
        
        private DynaSysMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DynaSysMode from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return ENABLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性值规则条件参数类型
     * <P>
     * <ul>
     * <li>ENTITYFIELD
     * <P>
     * 数据对象属性，值来自当前数据对象的指定属性
     * <li>CURTIME
     * <P>
     * 当前时间，值为当前时间
     * </ul>     
     */
    public static enum DEFVRParamType{
        ENTITYFIELD("ENTITYFIELD", "数据对象属性")
        ,CURTIME("CURTIME", "当前时间")
;
           
        public final String text;
        public final String value;
        
        private DEFVRParamType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFVRParamType from(String value){
            switch(value){
                case "ENTITYFIELD":
                    return ENTITYFIELD;
                case "CURTIME":
                    return CURTIME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体属性数据类型（静态）（全部）
     * <P>
     * <ul>
     * <li>ACID
     * <P>
     * 自增标识，整数类型，用户不可见
     * <li>BIGINT
     * <P>
     * 大整型
     * <li>CODELISTTEXT
     * <P>
     * 选择项文本
     * <li>CURRENCY
     * <P>
     * 货币
     * <li>CURRENCYUNIT
     * <P>
     * 货币单位
     * <li>DATE
     * <P>
     * 日期型
     * <li>DATETIME
     * <P>
     * 日期时间型
     * <li>DATETIME_BIRTHDAY
     * <P>
     * 出生日期
     * <li>DECIMAL
     * <P>
     * 数值
     * <li>BIGDECIMAL
     * <P>
     * 大数值
     * <li>FLOAT
     * <P>
     * 浮点
     * <li>GUID
     * <P>
     * 全局唯一标识，文本类型，用户不可见
     * <li>HTMLTEXT
     * <P>
     * HTML文本，没有长度限制
     * <li>INHERIT
     * <P>
     * 继承属性
     * <li>INT
     * <P>
     * 整型
     * <li>LONGTEXT
     * <P>
     * 长文本，没有长度限制
     * <li>LONGTEXT_1000
     * <P>
     * 长文本，长度1000
     * <li>NBID
     * <P>
     * 数字串业务标识，数字类型，用户可见
     * <li>NMCODELIST
     * <P>
     * 多项选择(数值)
     * <li>NSCODELIST
     * <P>
     * 单项选择(数值)
     * <li>PICKUP
     * <P>
     * 外键值
     * <li>PICKUPDATA
     * <P>
     * 外键值附加数据
     * <li>PICKUPTEXT
     * <P>
     * 外键值文本
     * <li>SBID
     * <P>
     * 字符串业务标识，文本类型，用户可见
     * <li>SMCODELIST
     * <P>
     * 多项选择(文本值)
     * <li>SSCODELIST
     * <P>
     * 单项选择(文本值)
     * <li>TEXT
     * <P>
     * 文本，可指定长度
     * <li>TEXT_EMAIL
     * <P>
     * 电子邮件
     * <li>TIME
     * <P>
     * 时间型
     * <li>TRUEFALSE
     * <P>
     * 真假逻辑
     * <li>VARBINARY
     * <P>
     * 二进制流，没有长度限制
     * <li>WFSTATE
     * <P>
     * 工作流处理状态
     * <li>YESNO
     * <P>
     * 是否逻辑
     * <li>ONE2MANYDATA
     * <P>
     * 一对多关系数据集合
     * <li>ONE2MANYDATA_MAP
     * <P>
     * 一对多关系数据集合（MAP）
     * <li>PICKUPOBJECT
     * <P>
     * 外键值对象
     * <li>ONE2ONEDATA
     * <P>
     * 一对一关系数据对象
     * <li>FILE
     * <P>
     * 文件
     * <li>ONE2MANYOBJ
     * <P>
     * 一对多动态对象
     * <li>ONE2MANYOBJ_MAP
     * <P>
     * 一对多动态对象（MAP）
     * <li>ONE2ONEOBJ
     * <P>
     * 一对一动态对象
     * <li>FILELIST
     * <P>
     * 文件列表
     * <li>LONGFILELIST
     * <P>
     * 文件列表，没有数量限制
     * <li>PICTURE
     * <P>
     * 图片
     * <li>PICTURELIST
     * <P>
     * 图片列表
     * <li>LONGPICTURELIST
     * <P>
     * 图片列表，没有数量限制
     * <li>TEXTARRAY
     * <P>
     * 文本数组
     * <li>TEXTARRAY2
     * <P>
     * 文本数组（没有长度限制）
     * <li>INTARRAY
     * <P>
     * 整形数组
     * <li>INTARRAY2
     * <P>
     * 整形数组（没有长度限制）
     * <li>BIGINTARRAY
     * <P>
     * 大整形数组
     * <li>BIGINTARRAY2
     * <P>
     * 大整形数组（没有长度限制）
     * <li>FLOATARRAY
     * <P>
     * 浮点数组
     * <li>FLOATARRAY2
     * <P>
     * 浮点数组（没有长度限制）
     * <li>DECIMALARRAY
     * <P>
     * 数值数组
     * <li>DECIMALARRAY2
     * <P>
     * 数值数组（没有长度限制）
     * </ul>     
     */
    public static enum DEFDataType{
        ACID("ACID", "自增标识，整数类型，用户不可见")
        ,BIGINT("BIGINT", "大整型")
        ,CODELISTTEXT("CODELISTTEXT", "选择项文本")
        ,CURRENCY("CURRENCY", "货币")
        ,CURRENCYUNIT("CURRENCYUNIT", "货币单位")
        ,DATE("DATE", "日期型")
        ,DATETIME("DATETIME", "日期时间型")
        ,DATETIME_BIRTHDAY("DATETIME_BIRTHDAY", "出生日期")
        ,DECIMAL("DECIMAL", "数值")
        ,BIGDECIMAL("BIGDECIMAL", "大数值")
        ,FLOAT("FLOAT", "浮点")
        ,GUID("GUID", "全局唯一标识，文本类型，用户不可见")
        ,HTMLTEXT("HTMLTEXT", "HTML文本，没有长度限制")
        ,INHERIT("INHERIT", "继承属性")
        ,INT("INT", "整型")
        ,LONGTEXT("LONGTEXT", "长文本，没有长度限制")
        ,LONGTEXT_1000("LONGTEXT_1000", "长文本，长度1000")
        ,NBID("NBID", "数字串业务标识，数字类型，用户可见")
        ,NMCODELIST("NMCODELIST", "多项选择(数值)")
        ,NSCODELIST("NSCODELIST", "单项选择(数值)")
        ,PICKUP("PICKUP", "外键值")
        ,PICKUPDATA("PICKUPDATA", "外键值附加数据")
        ,PICKUPTEXT("PICKUPTEXT", "外键值文本")
        ,SBID("SBID", "字符串业务标识，文本类型，用户可见")
        ,SMCODELIST("SMCODELIST", "多项选择(文本值)")
        ,SSCODELIST("SSCODELIST", "单项选择(文本值)")
        ,TEXT("TEXT", "文本，可指定长度")
        ,TEXT_EMAIL("TEXT_EMAIL", "电子邮件")
        ,TIME("TIME", "时间型")
        ,TRUEFALSE("TRUEFALSE", "真假逻辑")
        ,VARBINARY("VARBINARY", "二进制流，没有长度限制")
        ,WFSTATE("WFSTATE", "工作流处理状态")
        ,YESNO("YESNO", "是否逻辑")
        ,ONE2MANYDATA("ONE2MANYDATA", "一对多关系数据集合")
        ,ONE2MANYDATA_MAP("ONE2MANYDATA_MAP", "一对多关系数据集合（MAP）")
        ,PICKUPOBJECT("PICKUPOBJECT", "外键值对象")
        ,ONE2ONEDATA("ONE2ONEDATA", "一对一关系数据对象")
        ,FILE("FILE", "文件")
        ,ONE2MANYOBJ("ONE2MANYOBJ", "一对多动态对象")
        ,ONE2MANYOBJ_MAP("ONE2MANYOBJ_MAP", "一对多动态对象（MAP）")
        ,ONE2ONEOBJ("ONE2ONEOBJ", "一对一动态对象")
        ,FILELIST("FILELIST", "文件列表")
        ,LONGFILELIST("LONGFILELIST", "文件列表，没有数量限制")
        ,PICTURE("PICTURE", "图片")
        ,PICTURELIST("PICTURELIST", "图片列表")
        ,LONGPICTURELIST("LONGPICTURELIST", "图片列表，没有数量限制")
        ,TEXTARRAY("TEXTARRAY", "文本数组")
        ,TEXTARRAY2("TEXTARRAY2", "文本数组（没有长度限制）")
        ,INTARRAY("INTARRAY", "整形数组")
        ,INTARRAY2("INTARRAY2", "整形数组（没有长度限制）")
        ,BIGINTARRAY("BIGINTARRAY", "大整形数组")
        ,BIGINTARRAY2("BIGINTARRAY2", "大整形数组（没有长度限制）")
        ,FLOATARRAY("FLOATARRAY", "浮点数组")
        ,FLOATARRAY2("FLOATARRAY2", "浮点数组（没有长度限制）")
        ,DECIMALARRAY("DECIMALARRAY", "数值数组")
        ,DECIMALARRAY2("DECIMALARRAY2", "数值数组（没有长度限制）")
;
           
        public final String text;
        public final String value;
        
        private DEFDataType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFDataType from(String value){
            switch(value){
                case "ACID":
                    return ACID;
                case "BIGINT":
                    return BIGINT;
                case "CODELISTTEXT":
                    return CODELISTTEXT;
                case "CURRENCY":
                    return CURRENCY;
                case "CURRENCYUNIT":
                    return CURRENCYUNIT;
                case "DATE":
                    return DATE;
                case "DATETIME":
                    return DATETIME;
                case "DATETIME_BIRTHDAY":
                    return DATETIME_BIRTHDAY;
                case "DECIMAL":
                    return DECIMAL;
                case "BIGDECIMAL":
                    return BIGDECIMAL;
                case "FLOAT":
                    return FLOAT;
                case "GUID":
                    return GUID;
                case "HTMLTEXT":
                    return HTMLTEXT;
                case "INHERIT":
                    return INHERIT;
                case "INT":
                    return INT;
                case "LONGTEXT":
                    return LONGTEXT;
                case "LONGTEXT_1000":
                    return LONGTEXT_1000;
                case "NBID":
                    return NBID;
                case "NMCODELIST":
                    return NMCODELIST;
                case "NSCODELIST":
                    return NSCODELIST;
                case "PICKUP":
                    return PICKUP;
                case "PICKUPDATA":
                    return PICKUPDATA;
                case "PICKUPTEXT":
                    return PICKUPTEXT;
                case "SBID":
                    return SBID;
                case "SMCODELIST":
                    return SMCODELIST;
                case "SSCODELIST":
                    return SSCODELIST;
                case "TEXT":
                    return TEXT;
                case "TEXT_EMAIL":
                    return TEXT_EMAIL;
                case "TIME":
                    return TIME;
                case "TRUEFALSE":
                    return TRUEFALSE;
                case "VARBINARY":
                    return VARBINARY;
                case "WFSTATE":
                    return WFSTATE;
                case "YESNO":
                    return YESNO;
                case "ONE2MANYDATA":
                    return ONE2MANYDATA;
                case "ONE2MANYDATA_MAP":
                    return ONE2MANYDATA_MAP;
                case "PICKUPOBJECT":
                    return PICKUPOBJECT;
                case "ONE2ONEDATA":
                    return ONE2ONEDATA;
                case "FILE":
                    return FILE;
                case "ONE2MANYOBJ":
                    return ONE2MANYOBJ;
                case "ONE2MANYOBJ_MAP":
                    return ONE2MANYOBJ_MAP;
                case "ONE2ONEOBJ":
                    return ONE2ONEOBJ;
                case "FILELIST":
                    return FILELIST;
                case "LONGFILELIST":
                    return LONGFILELIST;
                case "PICTURE":
                    return PICTURE;
                case "PICTURELIST":
                    return PICTURELIST;
                case "LONGPICTURELIST":
                    return LONGPICTURELIST;
                case "TEXTARRAY":
                    return TEXTARRAY;
                case "TEXTARRAY2":
                    return TEXTARRAY2;
                case "INTARRAY":
                    return INTARRAY;
                case "INTARRAY2":
                    return INTARRAY2;
                case "BIGINTARRAY":
                    return BIGINTARRAY;
                case "BIGINTARRAY2":
                    return BIGINTARRAY2;
                case "FLOATARRAY":
                    return FLOATARRAY;
                case "FLOATARRAY2":
                    return FLOATARRAY2;
                case "DECIMALARRAY":
                    return DECIMALARRAY;
                case "DECIMALARRAY2":
                    return DECIMALARRAY2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器应用场合
     * <P>
     * <ul>
     * <li>FORMITEM
     * <P>
     * 表单项编辑器
     * <li>GRIDCOLUMN
     * <P>
     * 表格单元格编辑器
     * <li>PANELFIELD
     * <P>
     * 面板属性编辑器
     * </ul>     
     */
    public static enum EditorContainer{
        FORMITEM("FORMITEM", "表单项编辑器")
        ,GRIDCOLUMN("GRIDCOLUMN", "表格单元格编辑器")
        ,PANELFIELD("PANELFIELD", "面板属性编辑器")
;
           
        public final String text;
        public final String value;
        
        private EditorContainer(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditorContainer from(String value){
            switch(value){
                case "FORMITEM":
                    return FORMITEM;
                case "GRIDCOLUMN":
                    return GRIDCOLUMN;
                case "PANELFIELD":
                    return PANELFIELD;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用界面模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>STYLE2
     * <P>
     * 样式2
     * <li>STYLE3
     * <P>
     * 样式3
     * <li>STYLE4
     * <P>
     * 样式4
     * <li>STYLE5
     * <P>
     * 样式5
     * <li>STYLE6
     * <P>
     * 样式6
     * <li>STYLE7
     * <P>
     * 样式7
     * <li>STYLE8
     * <P>
     * 样式8
     * <li>STYLE9
     * <P>
     * 样式9
     * <li>STYLE10
     * <P>
     * 样式10
     * </ul>     
     */
    public static enum AppUIStyle{
        DEFAULT("DEFAULT", "默认")
        ,STYLE2("STYLE2", "样式2")
        ,STYLE3("STYLE3", "样式3")
        ,STYLE4("STYLE4", "样式4")
        ,STYLE5("STYLE5", "样式5")
        ,STYLE6("STYLE6", "样式6")
        ,STYLE7("STYLE7", "样式7")
        ,STYLE8("STYLE8", "样式8")
        ,STYLE9("STYLE9", "样式9")
        ,STYLE10("STYLE10", "样式10")
;
           
        public final String text;
        public final String value;
        
        private AppUIStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppUIStyle from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "STYLE2":
                    return STYLE2;
                case "STYLE3":
                    return STYLE3;
                case "STYLE4":
                    return STYLE4;
                case "STYLE5":
                    return STYLE5;
                case "STYLE6":
                    return STYLE6;
                case "STYLE7":
                    return STYLE7;
                case "STYLE8":
                    return STYLE8;
                case "STYLE9":
                    return STYLE9;
                case "STYLE10":
                    return STYLE10;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云系统后台任务运行容器
     * <P>
     * <ul>
     * <li>SC01
     * <P>
     * 服务容器01
     * <li>SC02
     * <P>
     * 服务容器02
     * <li>SC03
     * <P>
     * 服务容器03
     * <li>SC04
     * <P>
     * 服务容器04
     * <li>USER
     * <P>
     * 自定义容器
     * </ul>     
     */
    public static enum BackendTaskContainer{
        SC01("SC01", "服务容器01")
        ,SC02("SC02", "服务容器02")
        ,SC03("SC03", "服务容器03")
        ,SC04("SC04", "服务容器04")
        ,USER("USER", "自定义容器")
;
           
        public final String text;
        public final String value;
        
        private BackendTaskContainer(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BackendTaskContainer from(String value){
            switch(value){
                case "SC01":
                    return SC01;
                case "SC02":
                    return SC02;
                case "SC03":
                    return SC03;
                case "SC04":
                    return SC04;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据流逻辑子类
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>PACKAGE
     * <P>
     * 数据流逻辑包
     * </ul>     
     */
    public static enum DataFlowSubType{
        NONE("NONE", "无")
        ,PACKAGE("PACKAGE", "数据流逻辑包")
;
           
        public final String text;
        public final String value;
        
        private DataFlowSubType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataFlowSubType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "PACKAGE":
                    return PACKAGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试数据类型
     * <P>
     * <ul>
     * <li>DATA
     * <P>
     * 数据
     * <li>CUSTOMCODE
     * <P>
     * 自定义代码
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TestDataType{
        DATA("DATA", "数据")
        ,CUSTOMCODE("CUSTOMCODE", "自定义代码")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TestDataType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestDataType from(String value){
            switch(value){
                case "DATA":
                    return DATA;
                case "CUSTOMCODE":
                    return CUSTOMCODE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统服务接口级别，数值项
     * <P>
     * <ul>
     * <li>CORE&nbsp;(0)
     * <P>
     * 核心级，核心级接口一般部署在信任环境，供内部程序使用，可以无权限控制或低权限控制
     * <li>CLOUDADMIN&nbsp;(1)
     * <P>
     * 平台管理员，运行平台管理员
     * <li>DCADMIN&nbsp;(2)
     * <P>
     * 机构管理员，机构管理员，一般指租户管理员，管理机构的组织、人员，包括系统的访问授权等
     * <li>USER&nbsp;(3)
     * <P>
     * 用户级，用户级接口需提供完整的鉴权及访问控制体系，安全要求高
     * </ul>     
     */
    public static enum ServiceAPILevel{
        CORE(0, "核心级")
        ,CLOUDADMIN(1, "平台管理员")
        ,DCADMIN(2, "机构管理员")
        ,USER(3, "用户级")
;
           
        public final String text;
        public final int value;
        
        private ServiceAPILevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ServiceAPILevel from(int value){
            switch(value){
                case 0:
                    return CORE;
                case 1:
                    return CLOUDADMIN;
                case 2:
                    return DCADMIN;
                case 3:
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统消息模板内容类型
     * <P>
     * <ul>
     * <li>TEXT
     * <P>
     * 纯文本
     * <li>HTML
     * <P>
     * HTML网页
     * <li>MARKDOWN
     * <P>
     * Markdown
     * <li>JSON
     * <P>
     * JSON
     * <li>PROPERTIES
     * <P>
     * Properties
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum MsgContentType{
        TEXT("TEXT", "纯文本")
        ,HTML("HTML", "HTML网页")
        ,MARKDOWN("MARKDOWN", "Markdown")
        ,JSON("JSON", "JSON")
        ,PROPERTIES("PROPERTIES", "Properties")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private MsgContentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MsgContentType from(String value){
            switch(value){
                case "TEXT":
                    return TEXT;
                case "HTML":
                    return HTML;
                case "MARKDOWN":
                    return MARKDOWN;
                case "JSON":
                    return JSON;
                case "PROPERTIES":
                    return PROPERTIES;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体主状态流程状态，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>PROCESSING&nbsp;(1)
     * <P>
     * 流程中
     * <li>FINISH&nbsp;(2)
     * <P>
     * 流程正常结束
     * <li>ERROR&nbsp;(3)
     * <P>
     * 流程异常退出
     * </ul>     
     */
    public static enum DEMSWFStateMode{
        NONE(0, "无")
        ,PROCESSING(1, "流程中")
        ,FINISH(2, "流程正常结束")
        ,ERROR(3, "流程异常退出")
;
           
        public final String text;
        public final int value;
        
        private DEMSWFStateMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMSWFStateMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return PROCESSING;
                case 2:
                    return FINISH;
                case 3:
                    return ERROR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台工具栏项类型
     * <P>
     * <ul>
     * <li>DEUIACTION
     * <P>
     * 界面行为项，绑定界面行为的项，提供命令功能
     * <li>SEPERATOR
     * <P>
     * 分隔项
     * <li>ITEMS
     * <P>
     * 分组项，包含子项的集合项
     * <li>RAWITEM
     * <P>
     * 直接项，输出直接内容的项
     * </ul>     
     */
    public static enum TBItemType{
        DEUIACTION("DEUIACTION", "界面行为项")
        ,SEPERATOR("SEPERATOR", "分隔项")
        ,ITEMS("ITEMS", "分组项")
        ,RAWITEM("RAWITEM", "直接项")
;
           
        public final String text;
        public final String value;
        
        private TBItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TBItemType from(String value){
            switch(value){
                case "DEUIACTION":
                    return DEUIACTION;
                case "SEPERATOR":
                    return SEPERATOR;
                case "ITEMS":
                    return ITEMS;
                case "RAWITEM":
                    return RAWITEM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据集分组模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>GROUPPARAM&nbsp;(1)
     * <P>
     * 指定分组参数
     * <li>DERAGG&nbsp;(2)
     * <P>
     * 指定聚合关系
     * </ul>     
     */
    public static enum DEDataSetGroupMode{
        NONE(0, "无")
        ,GROUPPARAM(1, "指定分组参数")
        ,DERAGG(2, "指定聚合关系")
;
           
        public final String text;
        public final int value;
        
        private DEDataSetGroupMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataSetGroupMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return GROUPPARAM;
                case 2:
                    return DERAGG;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 资源类型
     * <P>
     * <ul>
     * <li>STARTPAGE
     * <P>
     * 欢迎页
     * <li>ICON
     * <P>
     * 图标
     * </ul>     
     */
    public static enum MobAppResType{
        STARTPAGE("STARTPAGE", "欢迎页")
        ,ICON("ICON", "图标")
;
           
        public final String text;
        public final String value;
        
        private MobAppResType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobAppResType from(String value){
            switch(value){
                case "STARTPAGE":
                    return STARTPAGE;
                case "ICON":
                    return ICON;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统服务接口认证模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无认证
     * <li>AUTHORIZATION_CODE
     * <P>
     * 授权码模式
     * <li>PASSWORD
     * <P>
     * 密码模式
     * <li>CLIENT_CREDENTIALS
     * <P>
     * 客户端模式
     * <li>IMPLICIT
     * <P>
     * 简化模式
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum APIAuthMode{
        NONE("NONE", "无认证")
        ,AUTHORIZATION_CODE("AUTHORIZATION_CODE", "授权码模式")
        ,PASSWORD("PASSWORD", "密码模式")
        ,CLIENT_CREDENTIALS("CLIENT_CREDENTIALS", "客户端模式")
        ,IMPLICIT("IMPLICIT", "简化模式")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private APIAuthMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static APIAuthMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "AUTHORIZATION_CODE":
                    return AUTHORIZATION_CODE;
                case "PASSWORD":
                    return PASSWORD;
                case "CLIENT_CREDENTIALS":
                    return CLIENT_CREDENTIALS;
                case "IMPLICIT":
                    return IMPLICIT;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 智能报表引擎类型
     * <P>
     * <ul>
     * <li>KYLIN
     * <P>
     * Apache Kylin
     * <li>OLAP
     * <P>
     * OLAP
     * <li>DB
     * <P>
     * DB
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum BIEngineType{
        KYLIN("KYLIN", "Apache Kylin")
        ,OLAP("OLAP", "OLAP")
        ,DB("DB", "DB")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private BIEngineType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BIEngineType from(String value){
            switch(value){
                case "KYLIN":
                    return KYLIN;
                case "OLAP":
                    return OLAP;
                case "DB":
                    return DB;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 关系子类型
     * <P>
     * <ul>
     * <li>DER1N
     * <P>
     * 自定义1:N关系
     * <li>DER11
     * <P>
     * 自定义1:1关系
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DERSubType{
        DER1N("DER1N", "自定义1:N关系")
        ,DER11("DER11", "自定义1:1关系")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DERSubType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERSubType from(String value){
            switch(value){
                case "DER1N":
                    return DER1N;
                case "DER11":
                    return DER11;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 虚拟实体模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 不启用
     * <li>MINHERIT&nbsp;(1)
     * <P>
     * 常规多继承模式，对多个实体使用一对一关系进行剪裁组装，形成新的实体
     * <li>INHERIT&nbsp;(2)
     * <P>
     * 高级继承扩展模式，对指定实体进行虚拟继承，指定实体无需设置为继承主实体，一般用于对子系统或是外部服务实体的功能扩展
     * <li>INDEXMAJOR&nbsp;(3)
     * <P>
     * 索引主实体模式，将多个索引从实体进行数据联合，以统一的视角供外部使用
     * <li>MIXMINHERIT&nbsp;(4)
     * <P>
     * 混合多继承模式，当前实体混合多个实体使用一对一关系进行组装，形成新的实体
     * </ul>     
     */
    public static enum DEVirtualMode{
        NO(0, "不启用")
        ,MINHERIT(1, "常规多继承模式")
        ,INHERIT(2, "高级继承扩展模式")
        ,INDEXMAJOR(3, "索引主实体模式")
        ,MIXMINHERIT(4, "混合多继承模式")
;
           
        public final String text;
        public final int value;
        
        private DEVirtualMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEVirtualMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return MINHERIT;
                case 2:
                    return INHERIT;
                case 3:
                    return INDEXMAJOR;
                case 4:
                    return MIXMINHERIT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体示例数据逻辑模式
     * <P>
     * <ul>
     * <li>INSTALLDATA
     * <P>
     * 初始化数据
     * </ul>     
     */
    public static enum SampleDataLogicMode{
        INSTALLDATA("INSTALLDATA", "初始化数据")
;
           
        public final String text;
        public final String value;
        
        private SampleDataLogicMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SampleDataLogicMode from(String value){
            switch(value){
                case "INSTALLDATA":
                    return INSTALLDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 打印格式
     * <P>
     * <ul>
     * <li>POI_TL
     * <P>
     * POI模板引擎
     * <li>JR
     * <P>
     * JasperReport
     * <li>MD
     * <P>
     * Markdown
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum PrintType{
        POI_TL("POI_TL", "POI模板引擎")
        ,JR("JR", "JasperReport")
        ,MD("MD", "Markdown")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private PrintType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PrintType from(String value){
            switch(value){
                case "POI_TL":
                    return POI_TL;
                case "JR":
                    return JR;
                case "MD":
                    return MD;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 逻辑处理参数操作
     * <P>
     * <ul>
     * <li>RESET
     * <P>
     * 重置，重置数据对象
     * <li>COPY
     * <P>
     * 拷贝，将源数据对象拷贝至目标对象
     * <li>RESETANDCOPY
     * <P>
     * 重置并拷贝，将源数据对象拷贝至目标对象（目标对象先重置）
     * </ul>     
     */
    public static enum DELogicParamAction2{
        RESET("RESET", "重置")
        ,COPY("COPY", "拷贝")
        ,RESETANDCOPY("RESETANDCOPY", "重置并拷贝")
;
           
        public final String text;
        public final String value;
        
        private DELogicParamAction2(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicParamAction2 from(String value){
            switch(value){
                case "RESET":
                    return RESET;
                case "COPY":
                    return COPY;
                case "RESETANDCOPY":
                    return RESETANDCOPY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 组合条件操作
     * <P>
     * <ul>
     * <li>AND
     * <P>
     * 与(AND)
     * <li>OR
     * <P>
     * 或(OR)
     * </ul>     
     */
    public static enum GroupCondOP{
        AND("AND", "与(AND)")
        ,OR("OR", "或(OR)")
;
           
        public final String text;
        public final String value;
        
        private GroupCondOP(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GroupCondOP from(String value){
            switch(value){
                case "AND":
                    return AND;
                case "OR":
                    return OR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑调试模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不启用
     * <li>INFO&nbsp;(1)
     * <P>
     * 信息输出
     * </ul>     
     */
    public static enum DELogicDebugMode{
        NONE(0, "不启用")
        ,INFO(1, "信息输出")
;
           
        public final String text;
        public final int value;
        
        private DELogicDebugMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicDebugMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return INFO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统序列类型
     * <P>
     * <ul>
     * <li>DB
     * <P>
     * 数据库
     * <li>DE
     * <P>
     * 实体
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SequenceType{
        DB("DB", "数据库")
        ,DE("DE", "实体")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SequenceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SequenceType from(String value){
            switch(value){
                case "DB":
                    return DB;
                case "DE":
                    return DE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 后台服务插件类型
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>DELOGIC
     * <P>
     * 实体逻辑
     * <li>DELOGICNODE
     * <P>
     * 实体逻辑节点
     * <li>DEDATASET
     * <P>
     * 实体数据集
     * <li>USER
     * <P>
     * 用户自定义
     * <li>SYSREF
     * <P>
     * 系统引用，系统引用运行时插件
     * <li>MODULE
     * <P>
     * 系统模块，系统模块运行时插件
     * <li>STRFUNC
     * <P>
     * 字符串操作（废弃）
     * <li>MATHFUNC
     * <P>
     * 数学函数（废弃）
     * <li>DOCFUNC
     * <P>
     * 文档操作（废弃）
     * </ul>     
     */
    public static enum SFPluginType{
        DEACTION("DEACTION", "实体行为")
        ,DELOGIC("DELOGIC", "实体逻辑")
        ,DELOGICNODE("DELOGICNODE", "实体逻辑节点")
        ,DEDATASET("DEDATASET", "实体数据集")
        ,USER("USER", "用户自定义")
        ,SYSREF("SYSREF", "系统引用")
        ,MODULE("MODULE", "系统模块")
        ,STRFUNC("STRFUNC", "字符串操作（废弃）")
        ,MATHFUNC("MATHFUNC", "数学函数（废弃）")
        ,DOCFUNC("DOCFUNC", "文档操作（废弃）")
;
           
        public final String text;
        public final String value;
        
        private SFPluginType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SFPluginType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "DELOGIC":
                    return DELOGIC;
                case "DELOGICNODE":
                    return DELOGICNODE;
                case "DEDATASET":
                    return DEDATASET;
                case "USER":
                    return USER;
                case "SYSREF":
                    return SYSREF;
                case "MODULE":
                    return MODULE;
                case "STRFUNC":
                    return STRFUNC;
                case "MATHFUNC":
                    return MATHFUNC;
                case "DOCFUNC":
                    return DOCFUNC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台值规则类型
     * <P>
     * <ul>
     * <li>SCRIPT
     * <P>
     * 脚本，使用javascript脚本进行值校验
     * <li>REG
     * <P>
     * 正则式（废弃），使用正则式进行值校验，此代码值REG后续将调整为REGEX
     * <li>CUSTOM
     * <P>
     * 自定义，自定义
     * <li>REGEX
     * <P>
     * 正则式，使用正则式进行值校验
     * </ul>     
     */
    public static enum ValueRuleType{
        SCRIPT("SCRIPT", "脚本")
        ,REG("REG", "正则式（废弃）")
        ,CUSTOM("CUSTOM", "自定义")
        ,REGEX("REGEX", "正则式")
;
           
        public final String text;
        public final String value;
        
        private ValueRuleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ValueRuleType from(String value){
            switch(value){
                case "SCRIPT":
                    return SCRIPT;
                case "REG":
                    return REG;
                case "CUSTOM":
                    return CUSTOM;
                case "REGEX":
                    return REGEX;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 面板属性项默认状态，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>READONLY&nbsp;(1)
     * <P>
     * 只读
     * <li>DISABLED&nbsp;(2)
     * <P>
     * 禁用
     * </ul>     
     */
    public static enum PanelFieldState{
        READONLY(1, "只读")
        ,DISABLED(2, "禁用")
;
           
        public final String text;
        public final int value;
        
        private PanelFieldState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelFieldState from(int value){
            switch(value){
                case 1:
                    return READONLY;
                case 2:
                    return DISABLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法输入类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 没有输入
     * <li>KEYFIELD
     * <P>
     * 主键属性
     * <li>KEYFIELDS
     * <P>
     * 主键属性集合
     * <li>DTO
     * <P>
     * DTO对象
     * <li>DTOS
     * <P>
     * DTO对象集合
     * <li>FILTER
     * <P>
     * 搜索过滤对象
     * <li>UNKNOWN
     * <P>
     * 未知
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DEMethodInputType{
        NONE("NONE", "没有输入")
        ,KEYFIELD("KEYFIELD", "主键属性")
        ,KEYFIELDS("KEYFIELDS", "主键属性集合")
        ,DTO("DTO", "DTO对象")
        ,DTOS("DTOS", "DTO对象集合")
        ,FILTER("FILTER", "搜索过滤对象")
        ,UNKNOWN("UNKNOWN", "未知")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private DEMethodInputType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodInputType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "KEYFIELD":
                    return KEYFIELD;
                case "KEYFIELDS":
                    return KEYFIELDS;
                case "DTO":
                    return DTO;
                case "DTOS":
                    return DTOS;
                case "FILTER":
                    return FILTER;
                case "UNKNOWN":
                    return UNKNOWN;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统界面逻辑类型
     * <P>
     * <ul>
     * <li>PREDEFINED
     * <P>
     * 预定义，界面逻辑为预定义逻辑，需指定预定义的逻辑类型
     * <li>DEUILOGIC
     * <P>
     * 实体界面逻辑，界面逻辑为实体界面逻辑，需指定实体的界面处理逻辑
     * <li>PFPLUGIN
     * <P>
     * 前端插件，界面逻辑为前端模板扩展插件，需指定相应的模板插件
     * </ul>     
     */
    public static enum UILogicType{
        PREDEFINED("PREDEFINED", "预定义")
        ,DEUILOGIC("DEUILOGIC", "实体界面逻辑")
        ,PFPLUGIN("PFPLUGIN", "前端插件")
;
           
        public final String text;
        public final String value;
        
        private UILogicType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static UILogicType from(String value){
            switch(value){
                case "PREDEFINED":
                    return PREDEFINED;
                case "DEUILOGIC":
                    return DEUILOGIC;
                case "PFPLUGIN":
                    return PFPLUGIN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体数据关系项类型
     * <P>
     * <ul>
     * <li>DER1N
     * <P>
     * 1:N关系，关系界面是当前实体【一对多】关系的从实体界面
     * <li>SYSDER1N
     * <P>
     * 系统1:N关系，关系界面是当前系统【一对多】关系的从实体界面，一般指定关系的主实体与当前实体存在【一对一】的关系
     * <li>CUSTOM
     * <P>
     * 自定义关系，关系界面与当前实体并不存在显示的关系，一般用于呈现系统级别的数据，由界面自行解释关系呈现，如流程实例步骤界面等
     * </ul>     
     */
    public static enum DEDRItemType{
        DER1N("DER1N", "1:N关系")
        ,SYSDER1N("SYSDER1N", "系统1:N关系")
        ,CUSTOM("CUSTOM", "自定义关系")
;
           
        public final String text;
        public final String value;
        
        private DEDRItemType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDRItemType from(String value){
            switch(value){
                case "DER1N":
                    return DER1N;
                case "SYSDER1N":
                    return SYSDER1N;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 主状态行为控制模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不启用
     * <li>BACKEND&nbsp;(1)
     * <P>
     * 后台，将主状态行为控制逻辑附加到后台代码上，由后台进行限制
     * <li>FRONT&nbsp;(2)
     * <P>
     * 前台，将主状态行为控制逻辑附加到前端代码上，由前端进行限制
     * <li>BACKENDANDFRONT&nbsp;(3)
     * <P>
     * 后台及前台，将主状态行为控制逻辑同时附加到后台及前端代码上，同时限制
     * </ul>     
     */
    public static enum DEMSActionLogicMode{
        NONE(0, "不启用")
        ,BACKEND(1, "后台")
        ,FRONT(2, "前台")
        ,BACKENDANDFRONT(3, "后台及前台")
;
           
        public final String text;
        public final int value;
        
        private DEMSActionLogicMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMSActionLogicMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return BACKEND;
                case 2:
                    return FRONT;
                case 3:
                    return BACKENDANDFRONT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据库值模式
     * <P>
     * <ul>
     * <li>IGNORE
     * <P>
     * 忽略处理
     * <li>VERSION
     * <P>
     * 版本叠加
     * <li>CURDATETIME
     * <P>
     * 当前日期时间
     * <li>CURDATE
     * <P>
     * 当前日期
     * <li>VALUEFUNC
     * <P>
     * 值函数
     * </ul>     
     */
    public static enum DBValueMode{
        IGNORE("IGNORE", "忽略处理")
        ,VERSION("VERSION", "版本叠加")
        ,CURDATETIME("CURDATETIME", "当前日期时间")
        ,CURDATE("CURDATE", "当前日期")
        ,VALUEFUNC("VALUEFUNC", "值函数")
;
           
        public final String text;
        public final String value;
        
        private DBValueMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBValueMode from(String value){
            switch(value){
                case "IGNORE":
                    return IGNORE;
                case "VERSION":
                    return VERSION;
                case "CURDATETIME":
                    return CURDATETIME;
                case "CURDATE":
                    return CURDATE;
                case "VALUEFUNC":
                    return VALUEFUNC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 界面行为重新加载数据模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>DEFAULT&nbsp;(1)
     * <P>
     * 引用视图或树节点，当前引用视图或是树节点
     * <li>PARENTNODE&nbsp;(2)
     * <P>
     * 引用树节点父节点，刷新引用树节点的上级节点
     * <li>ROOTNODE&nbsp;(3)
     * <P>
     * 引用树节点根节点，刷新引用树节点的根节点，刷新整个树
     * </ul>     
     */
    public static enum UIActionReloadDataMode{
        NONE(0, "无")
        ,DEFAULT(1, "引用视图或树节点")
        ,PARENTNODE(2, "引用树节点父节点")
        ,ROOTNODE(3, "引用树节点根节点")
;
           
        public final String text;
        public final int value;
        
        private UIActionReloadDataMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static UIActionReloadDataMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return DEFAULT;
                case 2:
                    return PARENTNODE;
                case 3:
                    return ROOTNODE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑视图标记打开数据模式，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>OPENDATA
     * <P>
     * 登记打开数据
     * <li>EDITDATA
     * <P>
     * 登记更新数据
     * <li>DISPLAYOPPERSON
     * <P>
     * 显示操作人员
     * <li>NOTICERELOAD
     * <P>
     * 提示刷新数据
     * </ul>     
     */
    public static enum EditViewMarkOpenDataMode{
        OPENDATA("OPENDATA", "登记打开数据")
        ,EDITDATA("EDITDATA", "登记更新数据")
        ,DISPLAYOPPERSON("DISPLAYOPPERSON", "显示操作人员")
        ,NOTICERELOAD("NOTICERELOAD", "提示刷新数据")
;
           
        public final String text;
        public final String value;
        
        private EditViewMarkOpenDataMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditViewMarkOpenDataMode from(String value){
            switch(value){
                case "OPENDATA":
                    return OPENDATA;
                case "EDITDATA":
                    return EDITDATA;
                case "DISPLAYOPPERSON":
                    return DISPLAYOPPERSON;
                case "NOTICERELOAD":
                    return NOTICERELOAD;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体处理逻辑节点参数类型
     * <P>
     * <ul>
     * <li>SETPARAMVALUE
     * <P>
     * 设置变量，将源参数指定值设置到目标参数的指定属性
     * <li>RESETPARAM
     * <P>
     * 重置变量，重置目标参数对象
     * <li>COPYPARAM
     * <P>
     * 拷贝变量，将源参数对象拷贝至目标参数对象
     * <li>SQLPARAM
     * <P>
     * 数据库调用参数，将源参数指定值作为数据库调用参数
     * <li>SFPLUGINPARAM
     * <P>
     * 后台服务插件参数，将源参数指定值作为后台模板插件调用参数
     * <li>BINDPARAM
     * <P>
     * 绑定参数，处理逻辑变量绑定指定变量
     * <li>APPENDPARAM
     * <P>
     * 附加到数组变量
     * <li>SORTPARAM
     * <P>
     * 排序数组变量
     * <li>RENEWPARAM
     * <P>
     * 重新建立变量
     * <li>WEBURIPARAM
     * <P>
     * 请求Uri参数
     * <li>WEBHEADERPARAM
     * <P>
     * 请求Header参数
     * <li>MERGEMAPPARAM
     * <P>
     * 合并映射参数，指定源参数和目标参数合并的映射参数，配置源项属性与目标项属性
     * <li>AGGREGATEMAPPARAM
     * <P>
     * 聚合映射参数，指定源参数聚合至目标参数的映射参数，配置聚合模式
     * </ul>     
     */
    public static enum DELogicNodeParamType{
        SETPARAMVALUE("SETPARAMVALUE", "设置变量")
        ,RESETPARAM("RESETPARAM", "重置变量")
        ,COPYPARAM("COPYPARAM", "拷贝变量")
        ,SQLPARAM("SQLPARAM", "数据库调用参数")
        ,SFPLUGINPARAM("SFPLUGINPARAM", "后台服务插件参数")
        ,BINDPARAM("BINDPARAM", "绑定参数")
        ,APPENDPARAM("APPENDPARAM", "附加到数组变量")
        ,SORTPARAM("SORTPARAM", "排序数组变量")
        ,RENEWPARAM("RENEWPARAM", "重新建立变量")
        ,WEBURIPARAM("WEBURIPARAM", "请求Uri参数")
        ,WEBHEADERPARAM("WEBHEADERPARAM", "请求Header参数")
        ,MERGEMAPPARAM("MERGEMAPPARAM", "合并映射参数")
        ,AGGREGATEMAPPARAM("AGGREGATEMAPPARAM", "聚合映射参数")
;
           
        public final String text;
        public final String value;
        
        private DELogicNodeParamType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicNodeParamType from(String value){
            switch(value){
                case "SETPARAMVALUE":
                    return SETPARAMVALUE;
                case "RESETPARAM":
                    return RESETPARAM;
                case "COPYPARAM":
                    return COPYPARAM;
                case "SQLPARAM":
                    return SQLPARAM;
                case "SFPLUGINPARAM":
                    return SFPLUGINPARAM;
                case "BINDPARAM":
                    return BINDPARAM;
                case "APPENDPARAM":
                    return APPENDPARAM;
                case "SORTPARAM":
                    return SORTPARAM;
                case "RENEWPARAM":
                    return RENEWPARAM;
                case "WEBURIPARAM":
                    return WEBURIPARAM;
                case "WEBHEADERPARAM":
                    return WEBHEADERPARAM;
                case "MERGEMAPPARAM":
                    return MERGEMAPPARAM;
                case "AGGREGATEMAPPARAM":
                    return AGGREGATEMAPPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * IOS权限设置，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>CAMERA
     * <P>
     * Camera
     * <li>MICROPHONE
     * <P>
     * Microphone
     * <li>READIMAGE
     * <P>
     * Read Image
     * <li>ADDIMAGE
     * <P>
     * Add Image
     * <li>CONTACTS
     * <P>
     * Contacts
     * <li>LOC
     * <P>
     * Loc（while using）
     * <li>LOCATION
     * <P>
     * Location（always）
     * <li>BLUETOOTHSHARING
     * <P>
     * Bluetooth Sharing
     * <li>CALENDARS
     * <P>
     * Calendars
     * <li>HEALTHSHARING
     * <P>
     * Health Sharing
     * <li>HEALTHUPDATE
     * <P>
     * Health Update
     * <li>HOMEKIT
     * <P>
     * HomeKit
     * <li>MOTION_FITNESS
     * <P>
     * Motion & Fitness
     * <li>REMINDERS
     * <P>
     * Reminders
     * <li>SIRI
     * <P>
     * SIRI
     * <li>SPEECHRECOG
     * <P>
     * Speech Recog
     * <li>MEDIALIBRARY
     * <P>
     * Media Library
     * <li>READNFC
     * <P>
     * Read NFC
     * </ul>     
     */
    public static enum IOSPrivicy{
        CAMERA("CAMERA", "Camera")
        ,MICROPHONE("MICROPHONE", "Microphone")
        ,READIMAGE("READIMAGE", "Read Image")
        ,ADDIMAGE("ADDIMAGE", "Add Image")
        ,CONTACTS("CONTACTS", "Contacts")
        ,LOC("LOC", "Loc（while using）")
        ,LOCATION("LOCATION", "Location（always）")
        ,BLUETOOTHSHARING("BLUETOOTHSHARING", "Bluetooth Sharing")
        ,CALENDARS("CALENDARS", "Calendars")
        ,HEALTHSHARING("HEALTHSHARING", "Health Sharing")
        ,HEALTHUPDATE("HEALTHUPDATE", "Health Update")
        ,HOMEKIT("HOMEKIT", "HomeKit")
        ,MOTION_FITNESS("MOTION_FITNESS", "Motion & Fitness")
        ,REMINDERS("REMINDERS", "Reminders")
        ,SIRI("SIRI", "SIRI")
        ,SPEECHRECOG("SPEECHRECOG", "Speech Recog")
        ,MEDIALIBRARY("MEDIALIBRARY", "Media Library")
        ,READNFC("READNFC", "Read NFC")
;
           
        public final String text;
        public final String value;
        
        private IOSPrivicy(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static IOSPrivicy from(String value){
            switch(value){
                case "CAMERA":
                    return CAMERA;
                case "MICROPHONE":
                    return MICROPHONE;
                case "READIMAGE":
                    return READIMAGE;
                case "ADDIMAGE":
                    return ADDIMAGE;
                case "CONTACTS":
                    return CONTACTS;
                case "LOC":
                    return LOC;
                case "LOCATION":
                    return LOCATION;
                case "BLUETOOTHSHARING":
                    return BLUETOOTHSHARING;
                case "CALENDARS":
                    return CALENDARS;
                case "HEALTHSHARING":
                    return HEALTHSHARING;
                case "HEALTHUPDATE":
                    return HEALTHUPDATE;
                case "HOMEKIT":
                    return HOMEKIT;
                case "MOTION_FITNESS":
                    return MOTION_FITNESS;
                case "REMINDERS":
                    return REMINDERS;
                case "SIRI":
                    return SIRI;
                case "SPEECHRECOG":
                    return SPEECHRECOG;
                case "MEDIALIBRARY":
                    return MEDIALIBRARY;
                case "READNFC":
                    return READNFC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统面板逻辑类型
     * <P>
     * <ul>
     * <li>TIMER
     * <P>
     * 定时器触发，定时器定时触发逻辑，需指定定时器时间间隔
     * <li>PANELEVENT
     * <P>
     * 面板事件触发，面板事件触发逻辑，需指定事件名称，如初始化、加载等
     * <li>CTRLEVENT
     * <P>
     * 部件事件触发，指定部件事件触发逻辑，需同时指定部件标识及事件名称
     * <li>ITEMVISIBLE
     * <P>
     * 项显示逻辑，成员项动态显示逻辑，控制成员是否显示
     * <li>ITEMENABLE
     * <P>
     * 项启用逻辑，成员项的动态启用逻辑，控成员及其编辑器启用禁用状态
     * <li>ITEMBLANK
     * <P>
     * 项空输入逻辑，成员项的动态空输入逻辑，控制成员项及其编辑器是否允许空输入
     * <li>ITEMDYNACLASS
     * <P>
     * 项动态样式表，成员项的动态样式表逻辑，控制成员项的样式表
     * <li>RENDER
     * <P>
     * 绘制器，向容器或相关成员指定绘制器，绘制器包括直接面板，面板模型（DSL或运行时模型）以及前端插件
     * <li>ATTRIBUTE
     * <P>
     * 注入属性，向容器或相关成员注入属性
     * <li>CUSTOM
     * <P>
     * 自定义，仅发布逻辑，不挂接任何事件，由其它逻辑驱动或自定义代码调用
     * <li>VUE_DIRECTIVE
     * <P>
     * VUE指令
     * </ul>     
     */
    public static enum PanelLogicType{
        TIMER("TIMER", "定时器触发")
        ,PANELEVENT("PANELEVENT", "面板事件触发")
        ,CTRLEVENT("CTRLEVENT", "部件事件触发")
        ,ITEMVISIBLE("ITEMVISIBLE", "项显示逻辑")
        ,ITEMENABLE("ITEMENABLE", "项启用逻辑")
        ,ITEMBLANK("ITEMBLANK", "项空输入逻辑")
        ,ITEMDYNACLASS("ITEMDYNACLASS", "项动态样式表")
        ,RENDER("RENDER", "绘制器")
        ,ATTRIBUTE("ATTRIBUTE", "注入属性")
        ,CUSTOM("CUSTOM", "自定义")
        ,VUE_DIRECTIVE("VUE_DIRECTIVE", "VUE指令")
;
           
        public final String text;
        public final String value;
        
        private PanelLogicType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PanelLogicType from(String value){
            switch(value){
                case "TIMER":
                    return TIMER;
                case "PANELEVENT":
                    return PANELEVENT;
                case "CTRLEVENT":
                    return CTRLEVENT;
                case "ITEMVISIBLE":
                    return ITEMVISIBLE;
                case "ITEMENABLE":
                    return ITEMENABLE;
                case "ITEMBLANK":
                    return ITEMBLANK;
                case "ITEMDYNACLASS":
                    return ITEMDYNACLASS;
                case "RENDER":
                    return RENDER;
                case "ATTRIBUTE":
                    return ATTRIBUTE;
                case "CUSTOM":
                    return CUSTOM;
                case "VUE_DIRECTIVE":
                    return VUE_DIRECTIVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 逻辑所有者，数值项
     * <P>
     * <ul>
     * <li>BACKEND&nbsp;(1)
     * <P>
     * 后台，指定逻辑具备在前端模板执行的能力
     * <li>FRONT&nbsp;(2)
     * <P>
     * 前台，指定逻辑具备在后台模板执行的能力
     * <li>BACKENDANDFRONT&nbsp;(3)
     * <P>
     * 后台及前台，指定逻辑同时具备在前端及后台模板执行的能力
     * </ul>     
     */
    public static enum DELogicHolder{
        BACKEND(1, "后台")
        ,FRONT(2, "前台")
        ,BACKENDANDFRONT(3, "后台及前台")
;
           
        public final String text;
        public final int value;
        
        private DELogicHolder(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicHolder from(int value){
            switch(value){
                case 1:
                    return BACKEND;
                case 2:
                    return FRONT;
                case 3:
                    return BACKENDANDFRONT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 运行时类型
     * <P>
     * <ul>
     * <li>PSOBJECT
     * <P>
     * 模型对象
     * <li>METHOD
     * <P>
     * 模型方法
     * <li>VALUE
     * <P>
     * 模型值
     * </ul>     
     */
    public static enum ModelRTType{
        PSOBJECT("PSOBJECT", "模型对象")
        ,METHOD("METHOD", "模型方法")
        ,VALUE("VALUE", "模型值")
;
           
        public final String text;
        public final String value;
        
        private ModelRTType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelRTType from(String value){
            switch(value){
                case "PSOBJECT":
                    return PSOBJECT;
                case "METHOD":
                    return METHOD;
                case "VALUE":
                    return VALUE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单自动保存模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 禁用
     * <li>ENABLED&nbsp;(1)
     * <P>
     * 启用
     * <li>ALL&nbsp;(2)
     * <P>
     * 启用（提交全部）
     * <li>CHANGED&nbsp;(3)
     * <P>
     * 启用（提交变化）
     * </ul>     
     */
    public static enum FormAutoSaveMode{
        DISABLED(0, "禁用")
        ,ENABLED(1, "启用")
        ,ALL(2, "启用（提交全部）")
        ,CHANGED(3, "启用（提交变化）")
;
           
        public final String text;
        public final int value;
        
        private FormAutoSaveMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormAutoSaveMode from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return ENABLED;
                case 2:
                    return ALL;
                case 3:
                    return CHANGED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 菜单项状态，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>NEW&nbsp;(1)
     * <P>
     * 新功能
     * <li>HOT&nbsp;(2)
     * <P>
     * 热门功能
     * </ul>     
     */
    public static enum MenuItemState{
        NEW(1, "新功能")
        ,HOT(2, "热门功能")
;
           
        public final String text;
        public final int value;
        
        private MenuItemState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static MenuItemState from(int value){
            switch(value){
                case 1:
                    return NEW;
                case 2:
                    return HOT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工作流辅助功能类型（多选），多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>SENDBACK
     * <P>
     * 回退，将流程退回到上一步骤
     * <li>SUPPLYINFO
     * <P>
     * 补充信息，要求流程发起人进行补充信息
     * <li>ADDSTEPBEFORE
     * <P>
     * 前加签，在当前步骤之前添加审核步骤
     * <li>ADDSTEPAFTER
     * <P>
     * 后加签，在当前步骤之后添加审核步骤
     * <li>TAKEADVICE
     * <P>
     * 征求意见，发起向指定人员征求意见的操作
     * <li>SENDCOPY
     * <P>
     * 抄送
     * <li>REASSIGN
     * <P>
     * 转办
     * <li>USERACTION
     * <P>
     * 用户自定义
     * <li>USERACTION2
     * <P>
     * 用户自定义2
     * <li>USERACTION3
     * <P>
     * 用户自定义3
     * <li>USERACTION4
     * <P>
     * 用户自定义4
     * <li>USERACTION5
     * <P>
     * 用户自定义5
     * <li>USERACTION6
     * <P>
     * 用户自定义6
     * </ul>     
     */
    public static enum WFUtilUIActionType{
        SENDBACK("SENDBACK", "回退")
        ,SUPPLYINFO("SUPPLYINFO", "补充信息")
        ,ADDSTEPBEFORE("ADDSTEPBEFORE", "前加签")
        ,ADDSTEPAFTER("ADDSTEPAFTER", "后加签")
        ,TAKEADVICE("TAKEADVICE", "征求意见")
        ,SENDCOPY("SENDCOPY", "抄送")
        ,REASSIGN("REASSIGN", "转办")
        ,USERACTION("USERACTION", "用户自定义")
        ,USERACTION2("USERACTION2", "用户自定义2")
        ,USERACTION3("USERACTION3", "用户自定义3")
        ,USERACTION4("USERACTION4", "用户自定义4")
        ,USERACTION5("USERACTION5", "用户自定义5")
        ,USERACTION6("USERACTION6", "用户自定义6")
;
           
        public final String text;
        public final String value;
        
        private WFUtilUIActionType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFUtilUIActionType from(String value){
            switch(value){
                case "SENDBACK":
                    return SENDBACK;
                case "SUPPLYINFO":
                    return SUPPLYINFO;
                case "ADDSTEPBEFORE":
                    return ADDSTEPBEFORE;
                case "ADDSTEPAFTER":
                    return ADDSTEPAFTER;
                case "TAKEADVICE":
                    return TAKEADVICE;
                case "SENDCOPY":
                    return SENDCOPY;
                case "REASSIGN":
                    return REASSIGN;
                case "USERACTION":
                    return USERACTION;
                case "USERACTION2":
                    return USERACTION2;
                case "USERACTION3":
                    return USERACTION3;
                case "USERACTION4":
                    return USERACTION4;
                case "USERACTION5":
                    return USERACTION5;
                case "USERACTION6":
                    return USERACTION6;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 地图样式
     * <P>
     * <ul>
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum MapViewStyle{
        USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private MapViewStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MapViewStyle from(String value){
            switch(value){
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统开发后台任务状态，数值项
     * <P>
     * <ul>
     * <li>CREATED&nbsp;(10)
     * <P>
     * 已建立
     * <li>EXECUTING&nbsp;(20)
     * <P>
     * 执行中
     * <li>FINISHED&nbsp;(30)
     * <P>
     * 已完成
     * <li>CANCELLED&nbsp;(40)
     * <P>
     * 已取消
     * </ul>     
     */
    public static enum SysDevBKTaskState{
        CREATED(10, "已建立")
        ,EXECUTING(20, "执行中")
        ,FINISHED(30, "已完成")
        ,CANCELLED(40, "已取消")
;
           
        public final String text;
        public final int value;
        
        private SysDevBKTaskState(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysDevBKTaskState from(int value){
            switch(value){
                case 10:
                    return CREATED;
                case 20:
                    return EXECUTING;
                case 30:
                    return FINISHED;
                case 40:
                    return CANCELLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据集参数模式，数值项
     * <P>
     * <ul>
     * <li>ALL&nbsp;(1)
     * <P>
     * 默认参数（设置指定参数项值）
     * <li>SOME&nbsp;(2)
     * <P>
     * 指定参数，非启用运行时系统模型主键将默认传入，否则需要手动指定主键（如需要）
     * </ul>     
     */
    public static enum DEDataSetParamMode{
        ALL(1, "默认参数（设置指定参数项值）")
        ,SOME(2, "指定参数")
;
           
        public final String text;
        public final int value;
        
        private DEDataSetParamMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataSetParamMode from(int value){
            switch(value){
                case 1:
                    return ALL;
                case 2:
                    return SOME;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 关系界面组成员启用模式
     * <P>
     * <ul>
     * <li>ALL
     * <P>
     * 全部启用
     * <li>INWF
     * <P>
     * 流程中启用，关系界面项仅在数据处于流程流转中启用
     * <li>ALLWF
     * <P>
     * 全部流程状态启用，关系界面项在数据具备流程状态启用，包括了流程结束、错误等
     * <li>EDIT
     * <P>
     * 编辑时启用，关系界面在数据处于编辑状态时启用
     * <li>DEOPPRIV
     * <P>
     * 实体操作标识，关系界面在对当前数据具备指定操作标识时启用
     * <li>CUSTOM
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum DEDRDetailEnableMode{
        ALL("ALL", "全部启用")
        ,INWF("INWF", "流程中启用")
        ,ALLWF("ALLWF", "全部流程状态启用")
        ,EDIT("EDIT", "编辑时启用")
        ,DEOPPRIV("DEOPPRIV", "实体操作标识")
        ,CUSTOM("CUSTOM", "自定义")
;
           
        public final String text;
        public final String value;
        
        private DEDRDetailEnableMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDRDetailEnableMode from(String value){
            switch(value){
                case "ALL":
                    return ALL;
                case "INWF":
                    return INWF;
                case "ALLWF":
                    return ALLWF;
                case "EDIT":
                    return EDIT;
                case "DEOPPRIV":
                    return DEOPPRIV;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表格列聚合模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无聚合
     * <li>SUM
     * <P>
     * 合计，合计列值
     * <li>AVG
     * <P>
     * 平均，评价列值
     * <li>MAX
     * <P>
     * 最大值，最大列值
     * <li>MIN
     * <P>
     * 最小值，最小列值
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum GridColAggMode{
        NONE("NONE", "无聚合")
        ,SUM("SUM", "合计")
        ,AVG("AVG", "平均")
        ,MAX("MAX", "最大值")
        ,MIN("MIN", "最小值")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private GridColAggMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColAggMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "SUM":
                    return SUM;
                case "AVG":
                    return AVG;
                case "MAX":
                    return MAX;
                case "MIN":
                    return MIN;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台数据同步代理类型
     * <P>
     * <ul>
     * <li>KAFKA
     * <P>
     * Kafka
     * <li>RABBITMQ
     * <P>
     * RabbitMQ
     * <li>ACTIVEMQ
     * <P>
     * ActiveMQ
     * <li>MQTT
     * <P>
     * MQTT
     * <li>STOMP
     * <P>
     * STOMP
     * <li>WS
     * <P>
     * WebSocket
     * <li>INTERNAL
     * <P>
     * 内部通讯，指定用于系统内部通讯的代理
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DataSyncAgentType{
        KAFKA("KAFKA", "Kafka")
        ,RABBITMQ("RABBITMQ", "RabbitMQ")
        ,ACTIVEMQ("ACTIVEMQ", "ActiveMQ")
        ,MQTT("MQTT", "MQTT")
        ,STOMP("STOMP", "STOMP")
        ,WS("WS", "WebSocket")
        ,INTERNAL("INTERNAL", "内部通讯")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DataSyncAgentType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSyncAgentType from(String value){
            switch(value){
                case "KAFKA":
                    return KAFKA;
                case "RABBITMQ":
                    return RABBITMQ;
                case "ACTIVEMQ":
                    return ACTIVEMQ;
                case "MQTT":
                    return MQTT;
                case "STOMP":
                    return STOMP;
                case "WS":
                    return WS;
                case "INTERNAL":
                    return INTERNAL;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 移动端系统类型，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>IOS
     * <P>
     * iOS
     * <li>ANDROID
     * <P>
     * Android
     * </ul>     
     */
    public static enum MobOSType{
        IOS("IOS", "iOS")
        ,ANDROID("ANDROID", "Android")
;
           
        public final String text;
        public final String value;
        
        private MobOSType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MobOSType from(String value){
            switch(value){
                case "IOS":
                    return IOS;
                case "ANDROID":
                    return ANDROID;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流数据库源节点类型
     * <P>
     * <ul>
     * <li>DBTABLE
     * <P>
     * 数据表
     * <li>DEDATASET
     * <P>
     * 实体数据集
     * <li>DEDATAQUERY
     * <P>
     * 实体数据查询
     * <li>SQL
     * <P>
     * SQL代码
     * </ul>     
     */
    public static enum DEDataFlowSysDBSchemeSourceType{
        DBTABLE("DBTABLE", "数据表")
        ,DEDATASET("DEDATASET", "实体数据集")
        ,DEDATAQUERY("DEDATAQUERY", "实体数据查询")
        ,SQL("SQL", "SQL代码")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysDBSchemeSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysDBSchemeSourceType from(String value){
            switch(value){
                case "DBTABLE":
                    return DBTABLE;
                case "DEDATASET":
                    return DEDATASET;
                case "DEDATAQUERY":
                    return DEDATAQUERY;
                case "SQL":
                    return SQL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工作流类型
     * <P>
     * <ul>
     * <li>ORG
     * <P>
     * 机构流程，工作流为部门间流转的流程
     * <li>ORGSECTOR
     * <P>
     * 部门流程，工作流为部门内部流转的流程
     * <li>DEFAULT
     * <P>
     * 默认
     * </ul>     
     */
    public static enum WFType{
        ORG("ORG", "机构流程")
        ,ORGSECTOR("ORGSECTOR", "部门流程")
        ,DEFAULT("DEFAULT", "默认")
;
           
        public final String text;
        public final String value;
        
        private WFType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFType from(String value){
            switch(value){
                case "ORG":
                    return ORG;
                case "ORGSECTOR":
                    return ORGSECTOR;
                case "DEFAULT":
                    return DEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 接口实体模型同步模式
     * <P>
     * <ul>
     * <li>IGNORE
     * <P>
     * 不同步
     * <li>TODE
     * <P>
     * 同步到实体，将服务接口实体的信息同步至系统实体
     * </ul>     
     */
    public static enum SADESyncMode{
        IGNORE("IGNORE", "不同步")
        ,TODE("TODE", "同步到实体")
;
           
        public final String text;
        public final String value;
        
        private SADESyncMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADESyncMode from(String value){
            switch(value){
                case "IGNORE":
                    return IGNORE;
                case "TODE":
                    return TODE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性字符串转换模式
     * <P>
     * <ul>
     * <li>UCASE
     * <P>
     * 转换为大写
     * <li>LCASE
     * <P>
     * 转换为小写
     * <li>PASSWORD
     * <P>
     * 密码模式，密码模式，使用预置内容向前端输出，如果提交的内容等于预置内容，则忽略更新
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum StringCaseMode{
        UCASE("UCASE", "转换为大写")
        ,LCASE("LCASE", "转换为小写")
        ,PASSWORD("PASSWORD", "密码模式")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private StringCaseMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static StringCaseMode from(String value){
            switch(value){
                case "UCASE":
                    return UCASE;
                case "LCASE":
                    return LCASE;
                case "PASSWORD":
                    return PASSWORD;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体映射属性源值类型
     * <P>
     * <ul>
     * <li>FIELD
     * <P>
     * 属性等价，源属性与目标属性等价
     * <li>VALUE
     * <P>
     * 直接值到目标属性，直接值设置到目标属性
     * <li>EXPRESSION
     * <P>
     * 计算值到目标属性，表达式计算值设置到目标属性
     * <li>VALUE_SRC
     * <P>
     * 直接值到源属性，直接值设置到源属性
     * <li>EXPRESSION_SRC
     * <P>
     * 计算值到源属性，表达式计算值设置到源属性
     * </ul>     
     */
    public static enum DEMapFieldSrcType{
        FIELD("FIELD", "属性等价")
        ,VALUE("VALUE", "直接值到目标属性")
        ,EXPRESSION("EXPRESSION", "计算值到目标属性")
        ,VALUE_SRC("VALUE_SRC", "直接值到源属性")
        ,EXPRESSION_SRC("EXPRESSION_SRC", "计算值到源属性")
;
           
        public final String text;
        public final String value;
        
        private DEMapFieldSrcType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMapFieldSrcType from(String value){
            switch(value){
                case "FIELD":
                    return FIELD;
                case "VALUE":
                    return VALUE;
                case "EXPRESSION":
                    return EXPRESSION;
                case "VALUE_SRC":
                    return VALUE_SRC;
                case "EXPRESSION_SRC":
                    return EXPRESSION_SRC;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体界面逻辑连接模式，数值项
     * <P>
     * <ul>
     * <li>COMMON&nbsp;(0)
     * <P>
     * 常规，常规连接，满足连接条件方可进入
     * <li>DEFAULT&nbsp;(1)
     * <P>
     * 默认连接，默认连接，不做条件判断即可进入
     * <li>FULFILLED&nbsp;(2)
     * <P>
     * 异步结束，前端异步调用结束时进入
     * <li>REJECTED&nbsp;(3)
     * <P>
     * 异步拒绝，前端异步调用被拒绝时进入
     * <li>CATCH&nbsp;(9)
     * <P>
     * 异常处理，前端异步调用发生异常时进入
     * </ul>     
     */
    public static enum DEUILogicLinkMode{
        COMMON(0, "常规")
        ,DEFAULT(1, "默认连接")
        ,FULFILLED(2, "异步结束")
        ,REJECTED(3, "异步拒绝")
        ,CATCH(9, "异常处理")
;
           
        public final String text;
        public final int value;
        
        private DEUILogicLinkMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEUILogicLinkMode from(int value){
            switch(value){
                case 0:
                    return COMMON;
                case 1:
                    return DEFAULT;
                case 2:
                    return FULFILLED;
                case 3:
                    return REJECTED;
                case 9:
                    return CATCH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工作流代理模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * （不使用）
     * <li>CLIENT&nbsp;(1)
     * <P>
     * 使用流程代理服务（客户端），工作流提供启动、结束等界面操作，调用外部系统提供的功能进行启动、结束流程等操作，流程实际的流转处理在外部系统完成
     * <li>SERVER&nbsp;(2)
     * <P>
     * 提供流程代理服务（服务端），工作流提供接口接收启动、结束等指令，完成流程实际的流转处理
     * <li>SERVERCLIENT&nbsp;(3)
     * <P>
     * 提供流程代理服务（服务端及客户端），工作流同时承担客户端及服务端功能
     * </ul>     
     */
    public static enum WFProxyMode{
        NONE(0, "（不使用）")
        ,CLIENT(1, "使用流程代理服务（客户端）")
        ,SERVER(2, "提供流程代理服务（服务端）")
        ,SERVERCLIENT(3, "提供流程代理服务（服务端及客户端）")
;
           
        public final String text;
        public final int value;
        
        private WFProxyMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProxyMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return CLIENT;
                case 2:
                    return SERVER;
                case 3:
                    return SERVERCLIENT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图表坐标系统索引，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(-1)
     * <P>
     * 自动
     * <li>INDEX_0&nbsp;(0)
     * <P>
     * 0
     * <li>INDEX_1&nbsp;(1)
     * <P>
     * 1
     * <li>INDEX_2&nbsp;(2)
     * <P>
     * 2
     * <li>INDEX_3&nbsp;(3)
     * <P>
     * 3
     * <li>INDEX_4&nbsp;(4)
     * <P>
     * 4
     * <li>INDEX_5&nbsp;(5)
     * <P>
     * 5
     * <li>INDEX_6&nbsp;(6)
     * <P>
     * 6
     * <li>INDEX_7&nbsp;(7)
     * <P>
     * 7
     * </ul>     
     */
    public static enum ChartCSIndex{
        NONE(-1, "自动")
        ,INDEX_0(0, "0")
        ,INDEX_1(1, "1")
        ,INDEX_2(2, "2")
        ,INDEX_3(3, "3")
        ,INDEX_4(4, "4")
        ,INDEX_5(5, "5")
        ,INDEX_6(6, "6")
        ,INDEX_7(7, "7")
;
           
        public final String text;
        public final int value;
        
        private ChartCSIndex(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartCSIndex from(int value){
            switch(value){
                case -1:
                    return NONE;
                case 0:
                    return INDEX_0;
                case 1:
                    return INDEX_1;
                case 2:
                    return INDEX_2;
                case 3:
                    return INDEX_3;
                case 4:
                    return INDEX_4;
                case 5:
                    return INDEX_5;
                case 6:
                    return INDEX_6;
                case 7:
                    return INDEX_7;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台实体存储类型，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无存储
     * <li>SQL&nbsp;(1)
     * <P>
     * SQL，使用关系数据库进行数据持久化处理
     * <li>NOSQL&nbsp;(2)
     * <P>
     * NoSQL，使用对象数据库存储进行数据持久化处理
     * <li>SERVICEAPI&nbsp;(4)
     * <P>
     * ServiceAPI，使用外部接口进行数据持久化处理
     * <li>SQLANDMORE&nbsp;(9)
     * <P>
     * SQL（多模式支持），支持多模式数据持久化处理，默认为关系数据库
     * <li>NOSQLANDMORE&nbsp;(10)
     * <P>
     * NoSQL（多模式支持），支持多模式数据持久化处理，默认为对象数据库
     * <li>SERVICEAPIANDMORE&nbsp;(12)
     * <P>
     * ServiceAPI（多模式支持），支持多模式数据持久化处理，默认为外部接口
     * <li>USER&nbsp;(128)
     * <P>
     * 用户自定义
     * <li>USER2&nbsp;(256)
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DEStorageType{
        NONE(0, "无存储")
        ,SQL(1, "SQL")
        ,NOSQL(2, "NoSQL")
        ,SERVICEAPI(4, "ServiceAPI")
        ,SQLANDMORE(9, "SQL（多模式支持）")
        ,NOSQLANDMORE(10, "NoSQL（多模式支持）")
        ,SERVICEAPIANDMORE(12, "ServiceAPI（多模式支持）")
        ,USER(128, "用户自定义")
        ,USER2(256, "用户自定义2")
;
           
        public final String text;
        public final int value;
        
        private DEStorageType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEStorageType from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return SQL;
                case 2:
                    return NOSQL;
                case 4:
                    return SERVICEAPI;
                case 9:
                    return SQLANDMORE;
                case 10:
                    return NOSQLANDMORE;
                case 12:
                    return SERVICEAPIANDMORE;
                case 128:
                    return USER;
                case 256:
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流连接模式，数值项
     * <P>
     * <ul>
     * <li>DATASTREAM&nbsp;(11)
     * <P>
     * 数据流，数据流1
     * <li>DATASTREAM2&nbsp;(12)
     * <P>
     * 数据流2，数据流2
     * </ul>     
     */
    public static enum DEDataFlowLinkMode{
        DATASTREAM(11, "数据流")
        ,DATASTREAM2(12, "数据流2")
;
           
        public final String text;
        public final int value;
        
        private DEDataFlowLinkMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowLinkMode from(int value){
            switch(value){
                case 11:
                    return DATASTREAM;
                case 12:
                    return DATASTREAM2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性值规则模式
     * <P>
     * <ul>
     * <li>MODE
     * <P>
     * 模式1
     * <li>MODE2
     * <P>
     * 模式2
     * <li>MODE3
     * <P>
     * 模式3
     * <li>MODE4
     * <P>
     * 模式4
     * <li>MODE5
     * <P>
     * 模式5
     * <li>MODE6
     * <P>
     * 模式6
     * <li>MODE7
     * <P>
     * 模式7
     * <li>MODE8
     * <P>
     * 模式8
     * <li>MODE9
     * <P>
     * 模式9
     * </ul>     
     */
    public static enum DEFVRMode{
        MODE("MODE", "模式1")
        ,MODE2("MODE2", "模式2")
        ,MODE3("MODE3", "模式3")
        ,MODE4("MODE4", "模式4")
        ,MODE5("MODE5", "模式5")
        ,MODE6("MODE6", "模式6")
        ,MODE7("MODE7", "模式7")
        ,MODE8("MODE8", "模式8")
        ,MODE9("MODE9", "模式9")
;
           
        public final String text;
        public final String value;
        
        private DEFVRMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFVRMode from(String value){
            switch(value){
                case "MODE":
                    return MODE;
                case "MODE2":
                    return MODE2;
                case "MODE3":
                    return MODE3;
                case "MODE4":
                    return MODE4;
                case "MODE5":
                    return MODE5;
                case "MODE6":
                    return MODE6;
                case "MODE7":
                    return MODE7;
                case "MODE8":
                    return MODE8;
                case "MODE9":
                    return MODE9;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理编辑模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不支持
     * <li>EXCLUDE&nbsp;(1)
     * <P>
     * 支持（排除指定属性）
     * <li>INCLUDE&nbsp;(2)
     * <P>
     * 支持（仅指定属性）
     * </ul>     
     */
    public static enum WFProcessEditMode{
        NONE(0, "不支持")
        ,EXCLUDE(1, "支持（排除指定属性）")
        ,INCLUDE(2, "支持（仅指定属性）")
;
           
        public final String text;
        public final int value;
        
        private WFProcessEditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProcessEditMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return EXCLUDE;
                case 2:
                    return INCLUDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为组成员类型
     * <P>
     * <ul>
     * <li>DEACTION
     * <P>
     * 实体行为
     * <li>DEDATASET
     * <P>
     * 实体结果集
     * </ul>     
     */
    public static enum DEMethodGroupDetailType{
        DEACTION("DEACTION", "实体行为")
        ,DEDATASET("DEDATASET", "实体结果集")
;
           
        public final String text;
        public final String value;
        
        private DEMethodGroupDetailType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodGroupDetailType from(String value){
            switch(value){
                case "DEACTION":
                    return DEACTION;
                case "DEDATASET":
                    return DEDATASET;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统运行会话运行模式
     * <P>
     * <ul>
     * <li>STARTX
     * <P>
     * 启动系统
     * <li>PUBCODE
     * <P>
     * 代码发布
     * <li>PACKVER
     * <P>
     * 打包版本
     * <li>PACKMOBAPP
     * <P>
     * 打包移动应用
     * <li>STARTMSAPI
     * <P>
     * 启动微服务
     * <li>STARTMSAPP
     * <P>
     * 启动微服务应用
     * <li>DEPLOYPKG
     * <P>
     * 部署系统组件到仓库
     * <li>STARTMSFUNC
     * <P>
     * 启动微服务功能
     * <li>PUBCODE2
     * <P>
     * 代码发布（模板开发）
     * <li>PUBDOC
     * <P>
     * 文档发布
     * <li>PUBMODEL
     * <P>
     * 模型发布
     * </ul>     
     */
    public static enum SysRunMode{
        STARTX("STARTX", "启动系统")
        ,PUBCODE("PUBCODE", "代码发布")
        ,PACKVER("PACKVER", "打包版本")
        ,PACKMOBAPP("PACKMOBAPP", "打包移动应用")
        ,STARTMSAPI("STARTMSAPI", "启动微服务")
        ,STARTMSAPP("STARTMSAPP", "启动微服务应用")
        ,DEPLOYPKG("DEPLOYPKG", "部署系统组件到仓库")
        ,STARTMSFUNC("STARTMSFUNC", "启动微服务功能")
        ,PUBCODE2("PUBCODE2", "代码发布（模板开发）")
        ,PUBDOC("PUBDOC", "文档发布")
        ,PUBMODEL("PUBMODEL", "模型发布")
;
           
        public final String text;
        public final String value;
        
        private SysRunMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRunMode from(String value){
            switch(value){
                case "STARTX":
                    return STARTX;
                case "PUBCODE":
                    return PUBCODE;
                case "PACKVER":
                    return PACKVER;
                case "PACKMOBAPP":
                    return PACKMOBAPP;
                case "STARTMSAPI":
                    return STARTMSAPI;
                case "STARTMSAPP":
                    return STARTMSAPP;
                case "DEPLOYPKG":
                    return DEPLOYPKG;
                case "STARTMSFUNC":
                    return STARTMSFUNC;
                case "PUBCODE2":
                    return PUBCODE2;
                case "PUBDOC":
                    return PUBDOC;
                case "PUBMODEL":
                    return PUBMODEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据集类型
     * <P>
     * <ul>
     * <li>DATAQUERY
     * <P>
     * 数据查询
     * <li>INDEXDE
     * <P>
     * 索引实体，数据集来自当前实体的索引值识别属性绑定的代码表
     * <li>MULTIFORM
     * <P>
     * 多表单，数据集来自当前实体的多表单识别属性绑定的代码表
     * <li>CODELIST
     * <P>
     * 代码表，数据集来自指定的代码表
     * <li>DELOGIC
     * <P>
     * 实体逻辑，数据集来自实体逻辑计算
     * <li>SCRIPT
     * <P>
     * 脚本代码，数据集来自自定义脚本代码处理
     * <li>REMOTE
     * <P>
     * 远程接口数据集，数据集来自远程服务接口方法
     * </ul>     
     */
    public static enum DEDataSetType{
        DATAQUERY("DATAQUERY", "数据查询")
        ,INDEXDE("INDEXDE", "索引实体")
        ,MULTIFORM("MULTIFORM", "多表单")
        ,CODELIST("CODELIST", "代码表")
        ,DELOGIC("DELOGIC", "实体逻辑")
        ,SCRIPT("SCRIPT", "脚本代码")
        ,REMOTE("REMOTE", "远程接口数据集")
;
           
        public final String text;
        public final String value;
        
        private DEDataSetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataSetType from(String value){
            switch(value){
                case "DATAQUERY":
                    return DATAQUERY;
                case "INDEXDE":
                    return INDEXDE;
                case "MULTIFORM":
                    return MULTIFORM;
                case "CODELIST":
                    return CODELIST;
                case "DELOGIC":
                    return DELOGIC;
                case "SCRIPT":
                    return SCRIPT;
                case "REMOTE":
                    return REMOTE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 外部服务接口方法绑定模式，数值项
     * <P>
     * <ul>
     * <li>NOT&nbsp;(0)
     * <P>
     * 不绑定
     * <li>AUTO&nbsp;(2)
     * <P>
     * 自动绑定
     * </ul>     
     */
    public static enum SubSysSADEMethodBindingMode{
        NOT(0, "不绑定")
        ,AUTO(2, "自动绑定")
;
           
        public final String text;
        public final int value;
        
        private SubSysSADEMethodBindingMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysSADEMethodBindingMode from(int value){
            switch(value){
                case 0:
                    return NOT;
                case 2:
                    return AUTO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统运行会话重构模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无操作
     * <li>FIXMODEL&nbsp;(4)
     * <P>
     * 模型修复
     * <li>QUICK&nbsp;(1)
     * <P>
     * 快速（删除本地项目与代码仓库多余文件）
     * <li>FULL&nbsp;(2)
     * <P>
     * 完整（完全重建本地项目及代码仓库）
     * </ul>     
     */
    public static enum SysRunRebuildMode{
        NONE(0, "无操作")
        ,FIXMODEL(4, "模型修复")
        ,QUICK(1, "快速（删除本地项目与代码仓库多余文件）")
        ,FULL(2, "完整（完全重建本地项目及代码仓库）")
;
           
        public final String text;
        public final int value;
        
        private SysRunRebuildMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRunRebuildMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 4:
                    return FIXMODEL;
                case 1:
                    return QUICK;
                case 2:
                    return FULL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息删除模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无关闭
     * <li>ALWAYS&nbsp;(1)
     * <P>
     * 默认关闭，视图消息关闭掉不再出现
     * <li>ONCE&nbsp;(2)
     * <P>
     * 本次关闭，视图消息本次关闭，下次会继续显示
     * </ul>     
     */
    public static enum ViewMsgRemoveMode{
        NONE(0, "无关闭")
        ,ALWAYS(1, "默认关闭")
        ,ONCE(2, "本次关闭")
;
           
        public final String text;
        public final int value;
        
        private ViewMsgRemoveMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgRemoveMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return ALWAYS;
                case 2:
                    return ONCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑器引用视图类型
     * <P>
     * <ul>
     * <li>NORMAL
     * <P>
     * 常规
     * <li>MODAL
     * <P>
     * 模态，视图已模态的形式弹出显示
     * <li>EMBEDDED
     * <P>
     * 嵌入，视图以嵌入形式在编辑器容器内显示
     * </ul>     
     */
    public static enum EditorRefViewShowMode{
        NORMAL("NORMAL", "常规")
        ,MODAL("MODAL", "模态")
        ,EMBEDDED("EMBEDDED", "嵌入")
;
           
        public final String text;
        public final String value;
        
        private EditorRefViewShowMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditorRefViewShowMode from(String value){
            switch(value){
                case "NORMAL":
                    return NORMAL;
                case "MODAL":
                    return MODAL;
                case "EMBEDDED":
                    return EMBEDDED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表格列宽度单位
     * <P>
     * <ul>
     * <li>PX
     * <P>
     * px，像素单位
     * <li>STAR
     * <P>
     * *，剩余宽度的块，一个星代表一块，剩余宽度除以总块数得出每块的宽度，宽度乘以块宽度就是实际宽度
     * </ul>     
     */
    public static enum GridColWidthUnitType{
        PX("PX", "px")
        ,STAR("STAR", "*")
;
           
        public final String text;
        public final String value;
        
        private GridColWidthUnitType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridColWidthUnitType from(String value){
            switch(value){
                case "PX":
                    return PX;
                case "STAR":
                    return STAR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 自动填充类型
     * <P>
     * <ul>
     * <li>AUTOCOMPLETE
     * <P>
     * 自动填充
     * <li>CHATCOMPLETION
     * <P>
     * 聊天补全
     * </ul>     
     */
    public static enum DEACType{
        AUTOCOMPLETE("AUTOCOMPLETE", "自动填充")
        ,CHATCOMPLETION("CHATCOMPLETION", "聊天补全")
;
           
        public final String text;
        public final String value;
        
        private DEACType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEACType from(String value){
            switch(value){
                case "AUTOCOMPLETE":
                    return AUTOCOMPLETE;
                case "CHATCOMPLETION":
                    return CHATCOMPLETION;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 动态模型使用类型
     * <P>
     * <ul>
     * <li>DATA
     * <P>
     * 数据
     * <li>STRUCT
     * <P>
     * 结构
     * <li>JSONSCHEMA
     * <P>
     * JsonSchema
     * <li>OPENAPI3SCHEMA
     * <P>
     * OpenAPI3Schema
     * <li>LIQUIBASECHANGELOG
     * <P>
     * LiquibaseChangeLog
     * <li>IM_JSONSCHEMA
     * <P>
     * 导入模型（JsonSchema）
     * </ul>     
     */
    public static enum DynaModelUsage{
        DATA("DATA", "数据")
        ,STRUCT("STRUCT", "结构")
        ,JSONSCHEMA("JSONSCHEMA", "JsonSchema")
        ,OPENAPI3SCHEMA("OPENAPI3SCHEMA", "OpenAPI3Schema")
        ,LIQUIBASECHANGELOG("LIQUIBASECHANGELOG", "LiquibaseChangeLog")
        ,IM_JSONSCHEMA("IM_JSONSCHEMA", "导入模型（JsonSchema）")
;
           
        public final String text;
        public final String value;
        
        private DynaModelUsage(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DynaModelUsage from(String value){
            switch(value){
                case "DATA":
                    return DATA;
                case "STRUCT":
                    return STRUCT;
                case "JSONSCHEMA":
                    return JSONSCHEMA;
                case "OPENAPI3SCHEMA":
                    return OPENAPI3SCHEMA;
                case "LIQUIBASECHANGELOG":
                    return LIQUIBASECHANGELOG;
                case "IM_JSONSCHEMA":
                    return IM_JSONSCHEMA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法DTO来源类型
     * <P>
     * <ul>
     * <li>DE
     * <P>
     * 实体，来源于当前实体，支持进一步指定属性组
     * <li>DYNAMODEL
     * <P>
     * 动态模型，从动态模型中构建的域对象
     * <li>DEACTIONINPUT
     * <P>
     * 实体行为参数，从实体行为自定义参数构建
     * <li>DEFILTER
     * <P>
     * 实体过滤器，从当前实体属性搜索模式构建搜索过滤器
     * <li>REFDE
     * <P>
     * 引用实体，来源于引用实体，支持进一步指定属性组
     * <li>DEDATASETINPUT
     * <P>
     * 实体数据集参数，从实体数据集自定义参数构建
     * </ul>     
     */
    public static enum DEMethodDTOSourceType{
        DE("DE", "实体")
        ,DYNAMODEL("DYNAMODEL", "动态模型")
        ,DEACTIONINPUT("DEACTIONINPUT", "实体行为参数")
        ,DEFILTER("DEFILTER", "实体过滤器")
        ,REFDE("REFDE", "引用实体")
        ,DEDATASETINPUT("DEDATASETINPUT", "实体数据集参数")
;
           
        public final String text;
        public final String value;
        
        private DEMethodDTOSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodDTOSourceType from(String value){
            switch(value){
                case "DE":
                    return DE;
                case "DYNAMODEL":
                    return DYNAMODEL;
                case "DEACTIONINPUT":
                    return DEACTIONINPUT;
                case "DEFILTER":
                    return DEFILTER;
                case "REFDE":
                    return REFDE;
                case "DEDATASETINPUT":
                    return DEDATASETINPUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Pipeline步骤类型
     * <P>
     * <ul>
     * <li>CODEGEN
     * <P>
     * 代码生成
     * <li>CODEGEN_APP
     * <P>
     * 代码生成（前端应用）
     * <li>PACKAGE
     * <P>
     * 打包
     * <li>PACKAGE_APP
     * <P>
     * 打包（前端应用）
     * <li>DEPLOY
     * <P>
     * 部署
     * <li>DEPLOY_MSDEPFUNC
     * <P>
     * 部署（微服务平台功能）
     * <li>DEPLOY_MSDEPAPI
     * <P>
     * 部署（微服务平台接口）
     * <li>DEPLOY_MSDEPAPP
     * <P>
     * 部署（微服务平台应用）
     * <li>CUSTOM
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum PipelineStepType{
        CODEGEN("CODEGEN", "代码生成")
        ,CODEGEN_APP("CODEGEN_APP", "代码生成（前端应用）")
        ,PACKAGE("PACKAGE", "打包")
        ,PACKAGE_APP("PACKAGE_APP", "打包（前端应用）")
        ,DEPLOY("DEPLOY", "部署")
        ,DEPLOY_MSDEPFUNC("DEPLOY_MSDEPFUNC", "部署（微服务平台功能）")
        ,DEPLOY_MSDEPAPI("DEPLOY_MSDEPAPI", "部署（微服务平台接口）")
        ,DEPLOY_MSDEPAPP("DEPLOY_MSDEPAPP", "部署（微服务平台应用）")
        ,CUSTOM("CUSTOM", "自定义")
;
           
        public final String text;
        public final String value;
        
        private PipelineStepType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PipelineStepType from(String value){
            switch(value){
                case "CODEGEN":
                    return CODEGEN;
                case "CODEGEN_APP":
                    return CODEGEN_APP;
                case "PACKAGE":
                    return PACKAGE;
                case "PACKAGE_APP":
                    return PACKAGE_APP;
                case "DEPLOY":
                    return DEPLOY;
                case "DEPLOY_MSDEPFUNC":
                    return DEPLOY_MSDEPFUNC;
                case "DEPLOY_MSDEPAPI":
                    return DEPLOY_MSDEPAPI;
                case "DEPLOY_MSDEPAPP":
                    return DEPLOY_MSDEPAPP;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图访问用户
     * <P>
     * <ul>
     * <li>UNKNOWN&nbsp;(0)
     * <P>
     * 未指定
     * <li>LOGINUSER&nbsp;(2)
     * <P>
     * 登录用户，访问用户必须已经登录，具备用户身份
     * <li>ALLUSER&nbsp;(3)
     * <P>
     * 匿名用户及登录用户，全部用户
     * <li>LOGINUSERWITHKEY&nbsp;(4)
     * <P>
     * 登录用户且拥有指定资源能力，访问用户必须已经登录，且对指定的系统统一资源具备能力
     * </ul>     
     */
    public static enum AccessUserMode{
        UNKNOWN("0", "未指定")
        ,LOGINUSER("2", "登录用户")
        ,ALLUSER("3", "匿名用户及登录用户")
        ,LOGINUSERWITHKEY("4", "登录用户且拥有指定资源能力")
;
           
        public final String text;
        public final String value;
        
        private AccessUserMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AccessUserMode from(String value){
            switch(value){
                case "0":
                    return UNKNOWN;
                case "2":
                    return LOGINUSER;
                case "3":
                    return ALLUSER;
                case "4":
                    return LOGINUSERWITHKEY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 大数据表类型，数值项
     * <P>
     * <ul>
     * <li>MAJOR&nbsp;(1)
     * <P>
     * 主数据表
     * <li>MINOR&nbsp;(2)
     * <P>
     * 从数据表
     * <li>RELATED&nbsp;(3)
     * <P>
     * 关系数据表
     * <li>INHERITMINOR&nbsp;(9)
     * <P>
     * 继承从数据表
     * </ul>     
     */
    public static enum BDTableType{
        MAJOR(1, "主数据表")
        ,MINOR(2, "从数据表")
        ,RELATED(3, "关系数据表")
        ,INHERITMINOR(9, "继承从数据表")
;
           
        public final String text;
        public final int value;
        
        private BDTableType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static BDTableType from(int value){
            switch(value){
                case 1:
                    return MAJOR;
                case 2:
                    return MINOR;
                case 3:
                    return RELATED;
                case 9:
                    return INHERITMINOR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 列表项代码表转换模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 直接值，不做任何转换，界面上直接输出源值
     * <li>FRONT
     * <P>
     * 绘制时转换（前台），代码表在绘制时进行转换，控制器输出源值
     * <li>BACKEND
     * <P>
     * 控制器转换（后台），代码表在控制器进行转换，绘制时直接输出
     * </ul>     
     */
    public static enum CodeListConvertMode{
        NONE("NONE", "直接值")
        ,FRONT("FRONT", "绘制时转换（前台）")
        ,BACKEND("BACKEND", "控制器转换（后台）")
;
           
        public final String text;
        public final String value;
        
        private CodeListConvertMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static CodeListConvertMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "FRONT":
                    return FRONT;
                case "BACKEND":
                    return BACKEND;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据流数据同步代理源节点类型
     * <P>
     * <ul>
     * <li>RAW
     * <P>
     * 直接流
     * </ul>     
     */
    public static enum DEDataFlowSysDataSyncAgentSourceType{
        RAW("RAW", "直接流")
;
           
        public final String text;
        public final String value;
        
        private DEDataFlowSysDataSyncAgentSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataFlowSysDataSyncAgentSourceType from(String value){
            switch(value){
                case "RAW":
                    return RAW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表单功能模式
     * <P>
     * <ul>
     * <li>WFACTION
     * <P>
     * 流程操作，工作流交互操作表单
     * <li>WIZARDFORM
     * <P>
     * 向导表单，向导表单
     * </ul>     
     */
    public static enum FormFuncMode{
        WFACTION("WFACTION", "流程操作")
        ,WIZARDFORM("WIZARDFORM", "向导表单")
;
           
        public final String text;
        public final String value;
        
        private FormFuncMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormFuncMode from(String value){
            switch(value){
                case "WFACTION":
                    return WFACTION;
                case "WIZARDFORM":
                    return WIZARDFORM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 外部接口对象属性类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单值
     * <li>SUBSYSSADE
     * <P>
     * 引用接口对象
     * </ul>     
     */
    public static enum SubSysSADEFieldType{
        SIMPLE("SIMPLE", "简单值")
        ,SUBSYSSADE("SUBSYSSADE", "引用接口对象")
;
           
        public final String text;
        public final String value;
        
        private SubSysSADEFieldType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysSADEFieldType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "SUBSYSSADE":
                    return SUBSYSSADE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 地图项样式
     * <P>
     * <ul>
     * <li>POINT
     * <P>
     * 点
     * <li>POINT2
     * <P>
     * 点2
     * <li>POINT3
     * <P>
     * 点3
     * <li>POINT4
     * <P>
     * 点4
     * <li>LINE
     * <P>
     * 连线
     * <li>LINE2
     * <P>
     * 连线2
     * <li>LINE3
     * <P>
     * 连线3
     * <li>LINE4
     * <P>
     * 连线4
     * <li>REGION
     * <P>
     * 区域
     * <li>REGION2
     * <P>
     * 区域2
     * <li>REGION3
     * <P>
     * 区域3
     * <li>REGION4
     * <P>
     * 区域4
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum MapItemStyle{
        POINT("POINT", "点")
        ,POINT2("POINT2", "点2")
        ,POINT3("POINT3", "点3")
        ,POINT4("POINT4", "点4")
        ,LINE("LINE", "连线")
        ,LINE2("LINE2", "连线2")
        ,LINE3("LINE3", "连线3")
        ,LINE4("LINE4", "连线4")
        ,REGION("REGION", "区域")
        ,REGION2("REGION2", "区域2")
        ,REGION3("REGION3", "区域3")
        ,REGION4("REGION4", "区域4")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private MapItemStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MapItemStyle from(String value){
            switch(value){
                case "POINT":
                    return POINT;
                case "POINT2":
                    return POINT2;
                case "POINT3":
                    return POINT3;
                case "POINT4":
                    return POINT4;
                case "LINE":
                    return LINE;
                case "LINE2":
                    return LINE2;
                case "LINE3":
                    return LINE3;
                case "LINE4":
                    return LINE4;
                case "REGION":
                    return REGION;
                case "REGION2":
                    return REGION2;
                case "REGION3":
                    return REGION3;
                case "REGION4":
                    return REGION4;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 内容宽度模式
     * <P>
     * <ul>
     * <li>AUTO
     * <P>
     * 自动
     * <li>FULL
     * <P>
     * 全部宽度
     * <li>PX
     * <P>
     * 像素
     * <li>PERCENTAGE
     * <P>
     * 百分比
     * </ul>     
     */
    public static enum WidthMode{
        AUTO("AUTO", "自动")
        ,FULL("FULL", "全部宽度")
        ,PX("PX", "像素")
        ,PERCENTAGE("PERCENTAGE", "百分比")
;
           
        public final String text;
        public final String value;
        
        private WidthMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WidthMode from(String value){
            switch(value){
                case "AUTO":
                    return AUTO;
                case "FULL":
                    return FULL;
                case "PX":
                    return PX;
                case "PERCENTAGE":
                    return PERCENTAGE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体属性界面配置外键文本设置，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>IGNOREEXTRESTRICT&nbsp;(1)
     * <P>
     * 忽略附加值约束，忽略实体关系中定义的附加约束条件
     * <li>IGNORETEMPDATA&nbsp;(2)
     * <P>
     * 忽略临时数据关系，忽略实体关系中定义的临时数据关系
     * </ul>     
     */
    public static enum FieldUIPickupTextOpt{
        IGNOREEXTRESTRICT(1, "忽略附加值约束")
        ,IGNORETEMPDATA(2, "忽略临时数据关系")
;
           
        public final String text;
        public final int value;
        
        private FieldUIPickupTextOpt(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FieldUIPickupTextOpt from(int value){
            switch(value){
                case 1:
                    return IGNOREEXTRESTRICT;
                case 2:
                    return IGNORETEMPDATA;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统测试项目类型
     * <P>
     * <ul>
     * <li>SYSAPP
     * <P>
     * 前端应用
     * <li>SYSSERVICEAPI
     * <P>
     * 系统服务接口
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TestPrjType{
        SYSAPP("SYSAPP", "前端应用")
        ,SYSSERVICEAPI("SYSSERVICEAPI", "系统服务接口")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TestPrjType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestPrjType from(String value){
            switch(value){
                case "SYSAPP":
                    return SYSAPP;
                case "SYSSERVICEAPI":
                    return SYSSERVICEAPI;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法DTO对象属性来源类型
     * <P>
     * <ul>
     * <li>DEFIELD
     * <P>
     * 实体属性，来源于当前实体属性
     * <li>DEFGROUPDETAIL
     * <P>
     * 实体属性组成员，来源是实体属性组成员
     * <li>DER
     * <P>
     * 实体关系，来源于指定实体关系
     * <li>DYNAMODELATTR
     * <P>
     * 动态模型属性，从动态模型属性中构建的属性对象
     * <li>DEACTIONPARAM
     * <P>
     * 实体行为参数，从实体行为参数构建的属性对象
     * <li>DEFSEARCHMODE
     * <P>
     * 属性搜索模式，从实体属性搜索模式构建的属性对象
     * <li>DEDATASETPARAM
     * <P>
     * 实体数据集参数，从实体数据集参数构建的属性对象
     * </ul>     
     */
    public static enum DEMethodDTOFieldSourceType{
        DEFIELD("DEFIELD", "实体属性")
        ,DEFGROUPDETAIL("DEFGROUPDETAIL", "实体属性组成员")
        ,DER("DER", "实体关系")
        ,DYNAMODELATTR("DYNAMODELATTR", "动态模型属性")
        ,DEACTIONPARAM("DEACTIONPARAM", "实体行为参数")
        ,DEFSEARCHMODE("DEFSEARCHMODE", "属性搜索模式")
        ,DEDATASETPARAM("DEDATASETPARAM", "实体数据集参数")
;
           
        public final String text;
        public final String value;
        
        private DEMethodDTOFieldSourceType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodDTOFieldSourceType from(String value){
            switch(value){
                case "DEFIELD":
                    return DEFIELD;
                case "DEFGROUPDETAIL":
                    return DEFGROUPDETAIL;
                case "DER":
                    return DER;
                case "DYNAMODELATTR":
                    return DYNAMODELATTR;
                case "DEACTIONPARAM":
                    return DEACTIONPARAM;
                case "DEFSEARCHMODE":
                    return DEFSEARCHMODE;
                case "DEDATASETPARAM":
                    return DEDATASETPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Android权限设置，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>PHONE
     * <P>
     * Phone
     * <li>SMS
     * <P>
     * SMS
     * <li>LOCATION
     * <P>
     * Location
     * <li>CONTACTS
     * <P>
     * Contacts
     * <li>CAMERA
     * <P>
     * Camera
     * <li>BLUETOOTH
     * <P>
     * Bluetooth
     * <li>FLASHLIGHT
     * <P>
     * Flashlight
     * <li>SYSLOG
     * <P>
     * Sys log
     * <li>AUTOSTART
     * <P>
     * Autostart
     * <li>RECORD
     * <P>
     * Record
     * </ul>     
     */
    public static enum AndroidPermission{
        PHONE("PHONE", "Phone")
        ,SMS("SMS", "SMS")
        ,LOCATION("LOCATION", "Location")
        ,CONTACTS("CONTACTS", "Contacts")
        ,CAMERA("CAMERA", "Camera")
        ,BLUETOOTH("BLUETOOTH", "Bluetooth")
        ,FLASHLIGHT("FLASHLIGHT", "Flashlight")
        ,SYSLOG("SYSLOG", "Sys log")
        ,AUTOSTART("AUTOSTART", "Autostart")
        ,RECORD("RECORD", "Record")
;
           
        public final String text;
        public final String value;
        
        private AndroidPermission(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AndroidPermission from(String value){
            switch(value){
                case "PHONE":
                    return PHONE;
                case "SMS":
                    return SMS;
                case "LOCATION":
                    return LOCATION;
                case "CONTACTS":
                    return CONTACTS;
                case "CAMERA":
                    return CAMERA;
                case "BLUETOOTH":
                    return BLUETOOTH;
                case "FLASHLIGHT":
                    return FLASHLIGHT;
                case "SYSLOG":
                    return SYSLOG;
                case "AUTOSTART":
                    return AUTOSTART;
                case "RECORD":
                    return RECORD;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体界面操作行为，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 建立
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新
     * <li>REMOVE&nbsp;(4)
     * <P>
     * 删除
     * </ul>     
     */
    public static enum DEActionAbility{
        CREATE(1, "建立")
        ,UPDATE(2, "更新")
        ,REMOVE(4, "删除")
;
           
        public final String text;
        public final int value;
        
        private DEActionAbility(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionAbility from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 4:
                    return REMOVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单多项数据部件操作，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>CREATE&nbsp;(1)
     * <P>
     * 新建，支持建立数据操作
     * <li>UPDATE&nbsp;(2)
     * <P>
     * 更新，支持更新数据操作
     * <li>REMOVE&nbsp;(4)
     * <P>
     * 删除，支持删除数据操作
     * </ul>     
     */
    public static enum FormMDCtrlAction{
        CREATE(1, "新建")
        ,UPDATE(2, "更新")
        ,REMOVE(4, "删除")
;
           
        public final String text;
        public final int value;
        
        private FormMDCtrlAction(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormMDCtrlAction from(int value){
            switch(value){
                case 1:
                    return CREATE;
                case 2:
                    return UPDATE;
                case 4:
                    return REMOVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统消息通知目标类型
     * <P>
     * <ul>
     * <li>RUNTIME
     * <P>
     * Runtime
     * <li>DE
     * <P>
     * 实体数据集
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum MsgTargetType{
        RUNTIME("RUNTIME", "Runtime")
        ,DE("DE", "实体数据集")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private MsgTargetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static MsgTargetType from(String value){
            switch(value){
                case "RUNTIME":
                    return RUNTIME;
                case "DE":
                    return DE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息显示模式
     * <P>
     * <ul>
     * <li>LIST
     * <P>
     * 列表显示
     * <li>MARQUEE
     * <P>
     * 横向滚动显示
     * <li>MARQUEE2
     * <P>
     * 纵向滚动显示
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum ViewMsgShowMode{
        LIST("LIST", "列表显示")
        ,MARQUEE("MARQUEE", "横向滚动显示")
        ,MARQUEE2("MARQUEE2", "纵向滚动显示")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private ViewMsgShowMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgShowMode from(String value){
            switch(value){
                case "LIST":
                    return LIST;
                case "MARQUEE":
                    return MARQUEE;
                case "MARQUEE2":
                    return MARQUEE2;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体视图预置类型
     * <P>
     * <ul>
     * <li>PICKUPVIEW
     * <P>
     * 默认单选视图
     * <li>EDITVIEW
     * <P>
     * 默认编辑视图
     * <li>MAINVIEW
     * <P>
     * 默认主视图
     * <li>INDEXDEPICKUPVIEW
     * <P>
     * 默认索引实体选择视图
     * <li>FORMPICKUPVIEW
     * <P>
     * 默认多表单选择视图
     * <li>MPICKUPVIEW
     * <P>
     * 默认多选视图
     * <li>MDATAVIEW
     * <P>
     * 默认多项视图
     * <li>WFEDITVIEW
     * <P>
     * 默认流程编辑视图
     * <li>WFMDATAVIEW
     * <P>
     * 默认流程多项视图
     * <li>WFSTARTVIEW
     * <P>
     * 默认流程启动视图
     * <li>WFACTIONVIEW
     * <P>
     * 默认流程操作视图
     * <li>WFUTILACTIONVIEW
     * <P>
     * 默认流程功能操作视图
     * <li>REDIRECTVIEW
     * <P>
     * 默认数据重定向视图
     * <li>MOBPICKUPVIEW
     * <P>
     * 移动端默认单选视图
     * <li>MOBEDITVIEW
     * <P>
     * 移动端默认编辑视图
     * <li>MOBMAINVIEW
     * <P>
     * 移动端默认主视图
     * <li>MOBINDEXDEPICKUPVIEW
     * <P>
     * 移动端默认索引实体选择视图
     * <li>MOBFORMPICKUPVIEW
     * <P>
     * 移动端默认多表单选择视图
     * <li>MOBMPICKUPVIEW
     * <P>
     * 移动端默认多选视图
     * <li>MOBMDATAVIEW
     * <P>
     * 移动端默认多项视图
     * <li>MOBWFEDITVIEW
     * <P>
     * 移动端默认流程编辑视图
     * <li>MOBWFMDATAVIEW
     * <P>
     * 移动端默认流程多项视图
     * <li>MOBWFSTARTVIEW
     * <P>
     * 移动端默认流程启动视图
     * <li>MOBWFACTIONVIEW
     * <P>
     * 移动端默认流程操作视图
     * <li>MOBWFUTILACTIONVIEW
     * <P>
     * 移动端默认流程功能操作视图
     * <li>MOBREDIRECTVIEW
     * <P>
     * 移动端默认数据重定向视图
     * <li>USER
     * <P>
     * 自定义功能视图
     * <li>USER2
     * <P>
     * 自定义功能视图2
     * <li>USER3
     * <P>
     * 自定义功能视图3
     * <li>USER4
     * <P>
     * 自定义功能视图4
     * </ul>     
     */
    public static enum PredefinedViewType{
        PICKUPVIEW("PICKUPVIEW", "默认单选视图")
        ,EDITVIEW("EDITVIEW", "默认编辑视图")
        ,MAINVIEW("MAINVIEW", "默认主视图")
        ,INDEXDEPICKUPVIEW("INDEXDEPICKUPVIEW", "默认索引实体选择视图")
        ,FORMPICKUPVIEW("FORMPICKUPVIEW", "默认多表单选择视图")
        ,MPICKUPVIEW("MPICKUPVIEW", "默认多选视图")
        ,MDATAVIEW("MDATAVIEW", "默认多项视图")
        ,WFEDITVIEW("WFEDITVIEW", "默认流程编辑视图")
        ,WFMDATAVIEW("WFMDATAVIEW", "默认流程多项视图")
        ,WFSTARTVIEW("WFSTARTVIEW", "默认流程启动视图")
        ,WFACTIONVIEW("WFACTIONVIEW", "默认流程操作视图")
        ,WFUTILACTIONVIEW("WFUTILACTIONVIEW", "默认流程功能操作视图")
        ,REDIRECTVIEW("REDIRECTVIEW", "默认数据重定向视图")
        ,MOBPICKUPVIEW("MOBPICKUPVIEW", "移动端默认单选视图")
        ,MOBEDITVIEW("MOBEDITVIEW", "移动端默认编辑视图")
        ,MOBMAINVIEW("MOBMAINVIEW", "移动端默认主视图")
        ,MOBINDEXDEPICKUPVIEW("MOBINDEXDEPICKUPVIEW", "移动端默认索引实体选择视图")
        ,MOBFORMPICKUPVIEW("MOBFORMPICKUPVIEW", "移动端默认多表单选择视图")
        ,MOBMPICKUPVIEW("MOBMPICKUPVIEW", "移动端默认多选视图")
        ,MOBMDATAVIEW("MOBMDATAVIEW", "移动端默认多项视图")
        ,MOBWFEDITVIEW("MOBWFEDITVIEW", "移动端默认流程编辑视图")
        ,MOBWFMDATAVIEW("MOBWFMDATAVIEW", "移动端默认流程多项视图")
        ,MOBWFSTARTVIEW("MOBWFSTARTVIEW", "移动端默认流程启动视图")
        ,MOBWFACTIONVIEW("MOBWFACTIONVIEW", "移动端默认流程操作视图")
        ,MOBWFUTILACTIONVIEW("MOBWFUTILACTIONVIEW", "移动端默认流程功能操作视图")
        ,MOBREDIRECTVIEW("MOBREDIRECTVIEW", "移动端默认数据重定向视图")
        ,USER("USER", "自定义功能视图")
        ,USER2("USER2", "自定义功能视图2")
        ,USER3("USER3", "自定义功能视图3")
        ,USER4("USER4", "自定义功能视图4")
;
           
        public final String text;
        public final String value;
        
        private PredefinedViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PredefinedViewType from(String value){
            switch(value){
                case "PICKUPVIEW":
                    return PICKUPVIEW;
                case "EDITVIEW":
                    return EDITVIEW;
                case "MAINVIEW":
                    return MAINVIEW;
                case "INDEXDEPICKUPVIEW":
                    return INDEXDEPICKUPVIEW;
                case "FORMPICKUPVIEW":
                    return FORMPICKUPVIEW;
                case "MPICKUPVIEW":
                    return MPICKUPVIEW;
                case "MDATAVIEW":
                    return MDATAVIEW;
                case "WFEDITVIEW":
                    return WFEDITVIEW;
                case "WFMDATAVIEW":
                    return WFMDATAVIEW;
                case "WFSTARTVIEW":
                    return WFSTARTVIEW;
                case "WFACTIONVIEW":
                    return WFACTIONVIEW;
                case "WFUTILACTIONVIEW":
                    return WFUTILACTIONVIEW;
                case "REDIRECTVIEW":
                    return REDIRECTVIEW;
                case "MOBPICKUPVIEW":
                    return MOBPICKUPVIEW;
                case "MOBEDITVIEW":
                    return MOBEDITVIEW;
                case "MOBMAINVIEW":
                    return MOBMAINVIEW;
                case "MOBINDEXDEPICKUPVIEW":
                    return MOBINDEXDEPICKUPVIEW;
                case "MOBFORMPICKUPVIEW":
                    return MOBFORMPICKUPVIEW;
                case "MOBMPICKUPVIEW":
                    return MOBMPICKUPVIEW;
                case "MOBMDATAVIEW":
                    return MOBMDATAVIEW;
                case "MOBWFEDITVIEW":
                    return MOBWFEDITVIEW;
                case "MOBWFMDATAVIEW":
                    return MOBWFMDATAVIEW;
                case "MOBWFSTARTVIEW":
                    return MOBWFSTARTVIEW;
                case "MOBWFACTIONVIEW":
                    return MOBWFACTIONVIEW;
                case "MOBWFUTILACTIONVIEW":
                    return MOBWFUTILACTIONVIEW;
                case "MOBREDIRECTVIEW":
                    return MOBREDIRECTVIEW;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性审计级别，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 不审计
     * <li>LEVEL1&nbsp;(1)
     * <P>
     * 1级
     * <li>LEVEL2&nbsp;(2)
     * <P>
     * 2级（关键数据），一般指实体的主要属性
     * <li>LEVEL3&nbsp;(3)
     * <P>
     * 3级（个别字段）
     * </ul>     
     */
    public static enum DEFieldAuditLevel{
        DISABLED(0, "不审计")
        ,LEVEL1(1, "1级")
        ,LEVEL2(2, "2级（关键数据）")
        ,LEVEL3(3, "3级（个别字段）")
;
           
        public final String text;
        public final int value;
        
        private DEFieldAuditLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFieldAuditLevel from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return LEVEL1;
                case 2:
                    return LEVEL2;
                case 3:
                    return LEVEL3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统模型仓库同步
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 不同步
     * <li>NOTEXISTS
     * <P>
     * 不存在时同步
     * <li>ALWAYS
     * <P>
     * 总是同步
     * </ul>     
     */
    public static enum ModelSyncMode{
        NONE("NONE", "不同步")
        ,NOTEXISTS("NOTEXISTS", "不存在时同步")
        ,ALWAYS("ALWAYS", "总是同步")
;
           
        public final String text;
        public final String value;
        
        private ModelSyncMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelSyncMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "NOTEXISTS":
                    return NOTEXISTS;
                case "ALWAYS":
                    return ALWAYS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 导航栏位置
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左侧（默认）
     * <li>TOP
     * <P>
     * 上方
     * </ul>     
     */
    public static enum ExpBarPos{
        LEFT("LEFT", "左侧（默认）")
        ,TOP("TOP", "上方")
;
           
        public final String text;
        public final String value;
        
        private ExpBarPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ExpBarPos from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "TOP":
                    return TOP;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体结果集合预定义类型
     * <P>
     * <ul>
     * <li>CODELIST
     * <P>
     * 代码表，数据集来自指定的代码表
     * <li>INDEXDE
     * <P>
     * 索引实体，数据集来自当前实体的索引值识别属性绑定的代码表
     * <li>MULTIFORM
     * <P>
     * 多表单，数据集来自当前实体的多表单识别属性绑定的代码表
     * <li>DELOGIC
     * <P>
     * 实体处理逻辑，数据集来自实体处理逻辑
     * <li>SCRIPT
     * <P>
     * 脚本代码，数据集来自自定义脚本代码处理
     * <li>REMOTE
     * <P>
     * 远程接口数据集，数据集来自远程服务接口方法
     * </ul>     
     */
    public static enum DEDataSetPredefinedType{
        CODELIST("CODELIST", "代码表")
        ,INDEXDE("INDEXDE", "索引实体")
        ,MULTIFORM("MULTIFORM", "多表单")
        ,DELOGIC("DELOGIC", "实体处理逻辑")
        ,SCRIPT("SCRIPT", "脚本代码")
        ,REMOTE("REMOTE", "远程接口数据集")
;
           
        public final String text;
        public final String value;
        
        private DEDataSetPredefinedType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataSetPredefinedType from(String value){
            switch(value){
                case "CODELIST":
                    return CODELIST;
                case "INDEXDE":
                    return INDEXDE;
                case "MULTIFORM":
                    return MULTIFORM;
                case "DELOGIC":
                    return DELOGIC;
                case "SCRIPT":
                    return SCRIPT;
                case "REMOTE":
                    return REMOTE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台部服务接口处理对象（客户端）
     * <P>
     * <ul>
     * <li>SAASADMIN
     * <P>
     * SaaS应用管理接口
     * <li>WFSERVICE
     * <P>
     * 工作流引擎服务接口
     * <li>WFCALLBACK
     * <P>
     * 工作流引擎回调接口
     * <li>USERAUTH
     * <P>
     * 用户授权服务接口
     * <li>ORGSERVICE
     * <P>
     * 组织管理服务接口
     * <li>ORGCALLBACK
     * <P>
     * 组织服务回调接口
     * <li>CORESERVICE
     * <P>
     * SaaS核心服务接口
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum PredefinedServiceAPIClient{
        SAASADMIN("SAASADMIN", "SaaS应用管理接口")
        ,WFSERVICE("WFSERVICE", "工作流引擎服务接口")
        ,WFCALLBACK("WFCALLBACK", "工作流引擎回调接口")
        ,USERAUTH("USERAUTH", "用户授权服务接口")
        ,ORGSERVICE("ORGSERVICE", "组织管理服务接口")
        ,ORGCALLBACK("ORGCALLBACK", "组织服务回调接口")
        ,CORESERVICE("CORESERVICE", "SaaS核心服务接口")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private PredefinedServiceAPIClient(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PredefinedServiceAPIClient from(String value){
            switch(value){
                case "SAASADMIN":
                    return SAASADMIN;
                case "WFSERVICE":
                    return WFSERVICE;
                case "WFCALLBACK":
                    return WFCALLBACK;
                case "USERAUTH":
                    return USERAUTH;
                case "ORGSERVICE":
                    return ORGSERVICE;
                case "ORGCALLBACK":
                    return ORGCALLBACK;
                case "CORESERVICE":
                    return CORESERVICE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为准备上次数据模式，数值项
     * <P>
     * <ul>
     * <li>DISABLED&nbsp;(0)
     * <P>
     * 不准备
     * <li>ENABLED&nbsp;(1)
     * <P>
     * 准备
     * <li>FILLED&nbsp;(2)
     * <P>
     * 准备并填充，准备上一次的数据并将写回数据对象未提供的属性
     * </ul>     
     */
    public static enum DEActionPrepareLastMode{
        DISABLED(0, "不准备")
        ,ENABLED(1, "准备")
        ,FILLED(2, "准备并填充")
;
           
        public final String text;
        public final int value;
        
        private DEActionPrepareLastMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionPrepareLastMode from(int value){
            switch(value){
                case 0:
                    return DISABLED;
                case 1:
                    return ENABLED;
                case 2:
                    return FILLED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体数据访问控制方式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无控制，实体没有启用访问控制
     * <li>SELF&nbsp;(1)
     * <P>
     * 自控制，实体使用自身定义的访问控制策略，即需要在权限体系中显式定义该实体的访问授权
     * <li>MASTER&nbsp;(2)
     * <P>
     * 附属主实体控制，实体相关的操作标识将被映射到父实体相应的操作标识，对当前实体的访问控制将转化为父实体的访问控制
     * <li>MASTER_SELF&nbsp;(3)
     * <P>
     * 附属主实体控制（未映射自控），实体相关的操作标识将被映射到父实体相应的操作标识，未被映射的标识将使用自身的访问控制策略
     * </ul>     
     */
    public static enum DEDataAccCtrlMode{
        NONE(0, "无控制")
        ,SELF(1, "自控制")
        ,MASTER(2, "附属主实体控制")
        ,MASTER_SELF(3, "附属主实体控制（未映射自控）")
;
           
        public final String text;
        public final int value;
        
        private DEDataAccCtrlMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDataAccCtrlMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return SELF;
                case 2:
                    return MASTER;
                case 3:
                    return MASTER_SELF;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台编辑视图类型
     * <P>
     * <ul>
     * <li>DEEDITVIEW
     * <P>
     * 实体编辑视图
     * <li>DEEDITVIEW2
     * <P>
     * 实体编辑视图（左右关系）
     * <li>DEEDITVIEW3
     * <P>
     * 实体编辑视图（分页关系）
     * <li>DEEDITVIEW4
     * <P>
     * 实体编辑视图（上下关系）
     * </ul>     
     */
    public static enum DEEditViewType{
        DEEDITVIEW("DEEDITVIEW", "实体编辑视图")
        ,DEEDITVIEW2("DEEDITVIEW2", "实体编辑视图（左右关系）")
        ,DEEDITVIEW3("DEEDITVIEW3", "实体编辑视图（分页关系）")
        ,DEEDITVIEW4("DEEDITVIEW4", "实体编辑视图（上下关系）")
;
           
        public final String text;
        public final String value;
        
        private DEEditViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEEditViewType from(String value){
            switch(value){
                case "DEEDITVIEW":
                    return DEEDITVIEW;
                case "DEEDITVIEW2":
                    return DEEDITVIEW2;
                case "DEEDITVIEW3":
                    return DEEDITVIEW3;
                case "DEEDITVIEW4":
                    return DEEDITVIEW4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统动态模型值类型
     * <P>
     * <ul>
     * <li>VALUE
     * <P>
     * 直接值，值来自当前属性定义
     * <li>OBJECT
     * <P>
     * 模型对象，值为引用的动态模型对象
     * <li>DE
     * <P>
     * 实体对象
     * </ul>     
     */
    public static enum DynaModelAttrValueType{
        VALUE("VALUE", "直接值")
        ,OBJECT("OBJECT", "模型对象")
        ,DE("DE", "实体对象")
;
           
        public final String text;
        public final String value;
        
        private DynaModelAttrValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DynaModelAttrValueType from(String value){
            switch(value){
                case "VALUE":
                    return VALUE;
                case "OBJECT":
                    return OBJECT;
                case "DE":
                    return DE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体表单样式
     * <P>
     * <ul>
     * <li>INFOPANEL
     * <P>
     * 信息面板
     * <li>INFOPANEL2
     * <P>
     * 信息面板2
     * <li>MOBINFOPANEL
     * <P>
     * 移动端信息面板
     * <li>MOBINFOPANEL2
     * <P>
     * 移动端信息面板2
     * <li>SEARCHBAR
     * <P>
     * 搜索栏
     * <li>SEARCHBAR2
     * <P>
     * 搜索栏2
     * <li>MOBSEARCHBAR
     * <P>
     * 移动端搜索栏
     * <li>MOBSEARCHBAR2
     * <P>
     * 移动端搜索栏2
     * </ul>     
     */
    public static enum FormStyle{
        INFOPANEL("INFOPANEL", "信息面板")
        ,INFOPANEL2("INFOPANEL2", "信息面板2")
        ,MOBINFOPANEL("MOBINFOPANEL", "移动端信息面板")
        ,MOBINFOPANEL2("MOBINFOPANEL2", "移动端信息面板2")
        ,SEARCHBAR("SEARCHBAR", "搜索栏")
        ,SEARCHBAR2("SEARCHBAR2", "搜索栏2")
        ,MOBSEARCHBAR("MOBSEARCHBAR", "移动端搜索栏")
        ,MOBSEARCHBAR2("MOBSEARCHBAR2", "移动端搜索栏2")
;
           
        public final String text;
        public final String value;
        
        private FormStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static FormStyle from(String value){
            switch(value){
                case "INFOPANEL":
                    return INFOPANEL;
                case "INFOPANEL2":
                    return INFOPANEL2;
                case "MOBINFOPANEL":
                    return MOBINFOPANEL;
                case "MOBINFOPANEL2":
                    return MOBINFOPANEL2;
                case "SEARCHBAR":
                    return SEARCHBAR;
                case "SEARCHBAR2":
                    return SEARCHBAR2;
                case "MOBSEARCHBAR":
                    return MOBSEARCHBAR;
                case "MOBSEARCHBAR2":
                    return MOBSEARCHBAR2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体处理处理返回值类型
     * <P>
     * <ul>
     * <li>NONEVALUE
     * <P>
     * 无值（NONE）
     * <li>NULLVALUE
     * <P>
     * 空值（NULL）
     * <li>SRCVALUE
     * <P>
     * 直接值
     * <li>LOGICPARAM
     * <P>
     * 逻辑参数对象
     * <li>LOGICPARAMFIELD
     * <P>
     * 逻辑参数属性
     * <li>BREAK
     * <P>
     * 跳出循环（BREAK）
     * </ul>     
     */
    public static enum LogicReturnType{
        NONEVALUE("NONEVALUE", "无值（NONE）")
        ,NULLVALUE("NULLVALUE", "空值（NULL）")
        ,SRCVALUE("SRCVALUE", "直接值")
        ,LOGICPARAM("LOGICPARAM", "逻辑参数对象")
        ,LOGICPARAMFIELD("LOGICPARAMFIELD", "逻辑参数属性")
        ,BREAK("BREAK", "跳出循环（BREAK）")
;
           
        public final String text;
        public final String value;
        
        private LogicReturnType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static LogicReturnType from(String value){
            switch(value){
                case "NONEVALUE":
                    return NONEVALUE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "SRCVALUE":
                    return SRCVALUE;
                case "LOGICPARAM":
                    return LOGICPARAM;
                case "LOGICPARAMFIELD":
                    return LOGICPARAMFIELD;
                case "BREAK":
                    return BREAK;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 主实体模式，数值项
     * <P>
     * <ul>
     * <li>NO&nbsp;(0)
     * <P>
     * 否
     * <li>YES&nbsp;(1)
     * <P>
     * 是
     * <li>AUTO&nbsp;(2)
     * <P>
     * 自动计算
     * </ul>     
     */
    public static enum AppDEMode{
        NO(0, "否")
        ,YES(1, "是")
        ,AUTO(2, "自动计算")
;
           
        public final String text;
        public final int value;
        
        private AppDEMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppDEMode from(int value){
            switch(value){
                case 0:
                    return NO;
                case 1:
                    return YES;
                case 2:
                    return AUTO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 编辑视图多表单模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>DATATYPE&nbsp;(1)
     * <P>
     * 数据类型多表单
     * <li>MAINSTATE&nbsp;(2)
     * <P>
     * 主状态多表单
     * </ul>     
     */
    public static enum EditViewMultiFormMode{
        NONE(0, "无")
        ,DATATYPE(1, "数据类型多表单")
        ,MAINSTATE(2, "主状态多表单")
;
           
        public final String text;
        public final int value;
        
        private EditViewMultiFormMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static EditViewMultiFormMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return DATATYPE;
                case 2:
                    return MAINSTATE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为逻辑附加模式
     * <P>
     * <ul>
     * <li>PREPARE
     * <P>
     * 准备，位置1：准备行为执行环境
     * <li>CHECK
     * <P>
     * 检查，位置2：检查传入参数或环境是否满足执行要求
     * <li>BEFORE
     * <P>
     * 执行之前，位置3：行为实际作业之前
     * <li>AFTER
     * <P>
     * 执行之后，位置4：行为实际作业之后
     * </ul>     
     */
    public static enum DEActionLogicAttachMode{
        PREPARE("PREPARE", "准备")
        ,CHECK("CHECK", "检查")
        ,BEFORE("BEFORE", "执行之前")
        ,AFTER("AFTER", "执行之后")
;
           
        public final String text;
        public final String value;
        
        private DEActionLogicAttachMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionLogicAttachMode from(String value){
            switch(value){
                case "PREPARE":
                    return PREPARE;
                case "CHECK":
                    return CHECK;
                case "BEFORE":
                    return BEFORE;
                case "AFTER":
                    return AFTER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 子系统服务接口来源
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>SYSAPI
     * <P>
     * 当前系统服务接口，外部接口来自当前系统的服务接口
     * <li>DEVSYSAPI
     * <P>
     * 外部开发系统服务接口，外部接口来自当前开发方案的开发系统服务接口
     * <li>PREDEFINED
     * <P>
     * 预定义系统服务接口，外部接口来自平台预置的服务接口
     * </ul>     
     */
    public static enum SubSysAPISource{
        NONE("NONE", "无")
        ,SYSAPI("SYSAPI", "当前系统服务接口")
        ,DEVSYSAPI("DEVSYSAPI", "外部开发系统服务接口")
        ,PREDEFINED("PREDEFINED", "预定义系统服务接口")
;
           
        public final String text;
        public final String value;
        
        private SubSysAPISource(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SubSysAPISource from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "SYSAPI":
                    return SYSAPI;
                case "DEVSYSAPI":
                    return DEVSYSAPI;
                case "PREDEFINED":
                    return PREDEFINED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 多维分析指标类别
     * <P>
     * <ul>
     * <li>COMMON
     * <P>
     * 常规
     * <li>CALCULATED
     * <P>
     * 动态计算
     * </ul>     
     */
    public static enum BIMeasureType{
        COMMON("COMMON", "常规")
        ,CALCULATED("CALCULATED", "动态计算")
;
           
        public final String text;
        public final String value;
        
        private BIMeasureType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BIMeasureType from(String value){
            switch(value){
                case "COMMON":
                    return COMMON;
                case "CALCULATED":
                    return CALCULATED;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性视图列级别，数值项
     * <P>
     * <ul>
     * <li>DEFAULT&nbsp;(0)
     * <P>
     * 默认（全部数据）
     * <li>LEVEL1&nbsp;(1)
     * <P>
     * 2级（无行外数据），默认指实体的物理属性
     * <li>LEVEL2&nbsp;(2)
     * <P>
     * 3级（关键数据），一般指实体的主要属性
     * <li>LEVEL3&nbsp;(3)
     * <P>
     * 4级（个别字段）
     * </ul>     
     */
    public static enum DEFieldViewColLevel{
        DEFAULT(0, "默认（全部数据）")
        ,LEVEL1(1, "2级（无行外数据）")
        ,LEVEL2(2, "3级（关键数据）")
        ,LEVEL3(3, "4级（个别字段）")
;
           
        public final String text;
        public final int value;
        
        private DEFieldViewColLevel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFieldViewColLevel from(int value){
            switch(value){
                case 0:
                    return DEFAULT;
                case 1:
                    return LEVEL1;
                case 2:
                    return LEVEL2;
                case 3:
                    return LEVEL3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体关系导出引用数据关系，数值项
     * <P>
     * <ul>
     * <li>SIMPLE&nbsp;(1)
     * <P>
     * 导出基本数据（只建立不更新）
     * </ul>     
     */
    public static enum DERExportMajorModel{
        SIMPLE(1, "导出基本数据（只建立不更新）")
;
           
        public final String text;
        public final int value;
        
        private DERExportMajorModel(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DERExportMajorModel from(int value){
            switch(value){
                case 1:
                    return SIMPLE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体映射处理映射模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认，默认处理，在入口处进行映射，不附加当前实体的处理逻辑
     * <li>INNER
     * <P>
     * 内部处理，仅映射的实际处理操作，在当前实体中完成逻辑附加操作
     * </ul>     
     */
    public static enum DEMapObjectMapMode{
        DEFAULT("DEFAULT", "默认")
        ,INNER("INNER", "内部处理")
;
           
        public final String text;
        public final String value;
        
        private DEMapObjectMapMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMapObjectMapMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "INNER":
                    return INNER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云实体视图打开方式
     * <P>
     * <ul>
     * <li>INDEXVIEWTAB
     * <P>
     * 顶级容器分页
     * <li>INDEXVIEWTAB_POPUP
     * <P>
     * 顶级容器分页（非模态弹出）
     * <li>INDEXVIEWTAB_POPUPMODAL
     * <P>
     * 顶级容器分页（模态弹出）
     * <li>POPUP
     * <P>
     * 非模态弹出
     * <li>POPUPMODAL
     * <P>
     * 模态弹出
     * <li>POPUPAPP
     * <P>
     * 独立程序弹出
     * <li>DRAWER_LEFT
     * <P>
     * 模态左侧抽屉弹出
     * <li>DRAWER_RIGHT
     * <P>
     * 模态右侧抽屉弹出
     * <li>DRAWER_TOP
     * <P>
     * 模态上方抽屉弹出
     * <li>DRAWER_BOTTOM
     * <P>
     * 模态下方抽屉弹出
     * <li>POPOVER
     * <P>
     * 气泡卡片
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum OpenViewMode{
        INDEXVIEWTAB("INDEXVIEWTAB", "顶级容器分页")
        ,INDEXVIEWTAB_POPUP("INDEXVIEWTAB_POPUP", "顶级容器分页（非模态弹出）")
        ,INDEXVIEWTAB_POPUPMODAL("INDEXVIEWTAB_POPUPMODAL", "顶级容器分页（模态弹出）")
        ,POPUP("POPUP", "非模态弹出")
        ,POPUPMODAL("POPUPMODAL", "模态弹出")
        ,POPUPAPP("POPUPAPP", "独立程序弹出")
        ,DRAWER_LEFT("DRAWER_LEFT", "模态左侧抽屉弹出")
        ,DRAWER_RIGHT("DRAWER_RIGHT", "模态右侧抽屉弹出")
        ,DRAWER_TOP("DRAWER_TOP", "模态上方抽屉弹出")
        ,DRAWER_BOTTOM("DRAWER_BOTTOM", "模态下方抽屉弹出")
        ,POPOVER("POPOVER", "气泡卡片")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private OpenViewMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static OpenViewMode from(String value){
            switch(value){
                case "INDEXVIEWTAB":
                    return INDEXVIEWTAB;
                case "INDEXVIEWTAB_POPUP":
                    return INDEXVIEWTAB_POPUP;
                case "INDEXVIEWTAB_POPUPMODAL":
                    return INDEXVIEWTAB_POPUPMODAL;
                case "POPUP":
                    return POPUP;
                case "POPUPMODAL":
                    return POPUPMODAL;
                case "POPUPAPP":
                    return POPUPAPP;
                case "DRAWER_LEFT":
                    return DRAWER_LEFT;
                case "DRAWER_RIGHT":
                    return DRAWER_RIGHT;
                case "DRAWER_TOP":
                    return DRAWER_TOP;
                case "DRAWER_BOTTOM":
                    return DRAWER_BOTTOM;
                case "POPOVER":
                    return POPOVER;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 搜索栏快速搜索模式，数值项
     * <P>
     * <ul>
     * <li>NOTSUPPORTED&nbsp;(0)
     * <P>
     * 否，不提供
     * <li>SUPPORTED&nbsp;(1)
     * <P>
     * 默认，常规的快速搜索模式，模糊查询实体中支持快速搜索的属性
     * <li>ADVANCE&nbsp;(2)
     * <P>
     * 高级（快速搜索项），快速搜索高级模式，通过快速搜索项定义快速搜索的能力，进一步提供优化的快速搜索界面，如引导用户选择搜索项，为具体的搜索项提供自动填充等辅助输入支持
     * </ul>     
     */
    public static enum SearchBarQuickSearchMode{
        NOTSUPPORTED(0, "否")
        ,SUPPORTED(1, "默认")
        ,ADVANCE(2, "高级（快速搜索项）")
;
           
        public final String text;
        public final int value;
        
        private SearchBarQuickSearchMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchBarQuickSearchMode from(int value){
            switch(value){
                case 0:
                    return NOTSUPPORTED;
                case 1:
                    return SUPPORTED;
                case 2:
                    return ADVANCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表类型
     * <P>
     * <ul>
     * <li>MAIN
     * <P>
     * 主表
     * <li>USER
     * <P>
     * 用户扩展表
     * <li>USER2
     * <P>
     * 用户扩展表2
     * </ul>     
     */
    public static enum DEDBTableType{
        MAIN("MAIN", "主表")
        ,USER("USER", "用户扩展表")
        ,USER2("USER2", "用户扩展表2")
;
           
        public final String text;
        public final String value;
        
        private DEDBTableType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEDBTableType from(String value){
            switch(value){
                case "MAIN":
                    return MAIN;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体方法DTO属性类型
     * <P>
     * <ul>
     * <li>SIMPLE
     * <P>
     * 简单数据类型，指定DTO属性类型为简单数据类型
     * <li>SIMPLES
     * <P>
     * 简单数据类型数组，指定DTO属性类型为简单数据类型数组
     * <li>DTO
     * <P>
     * DTO对象，指定DTO属性类型为DTO对象
     * <li>DTOS
     * <P>
     * DTO对象数组，指定DTO属性类型为DTO对象数组
     * </ul>     
     */
    public static enum DEMethodDTOFieldType{
        SIMPLE("SIMPLE", "简单数据类型")
        ,SIMPLES("SIMPLES", "简单数据类型数组")
        ,DTO("DTO", "DTO对象")
        ,DTOS("DTOS", "DTO对象数组")
;
           
        public final String text;
        public final String value;
        
        private DEMethodDTOFieldType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMethodDTOFieldType from(String value){
            switch(value){
                case "SIMPLE":
                    return SIMPLE;
                case "SIMPLES":
                    return SIMPLES;
                case "DTO":
                    return DTO;
                case "DTOS":
                    return DTOS;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性值转换使用模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>DIGEST
     * <P>
     * 密码
     * <li>ENCRYPT
     * <P>
     * 加密
     * <li>TRANSLATE
     * <P>
     * 转换器处理
     * <li>TRANSLATE2
     * <P>
     * 转换器处理（双向）
     * <li>UCASE
     * <P>
     * 转换为大写
     * <li>LCASE
     * <P>
     * 转换为小写
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEFTranslatorMode{
        NONE("NONE", "无")
        ,DIGEST("DIGEST", "密码")
        ,ENCRYPT("ENCRYPT", "加密")
        ,TRANSLATE("TRANSLATE", "转换器处理")
        ,TRANSLATE2("TRANSLATE2", "转换器处理（双向）")
        ,UCASE("UCASE", "转换为大写")
        ,LCASE("LCASE", "转换为小写")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEFTranslatorMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEFTranslatorMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "DIGEST":
                    return DIGEST;
                case "ENCRYPT":
                    return ENCRYPT;
                case "TRANSLATE":
                    return TRANSLATE;
                case "TRANSLATE2":
                    return TRANSLATE2;
                case "UCASE":
                    return UCASE;
                case "LCASE":
                    return LCASE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 模型引擎版本，数值项
     * <P>
     * <ul>
     * <li>V239&nbsp;(239)
     * <P>
     * 239
     * <li>V240&nbsp;(240)
     * <P>
     * 240，（1）实体服务接口输出复数代码标识（CodeName2）
     * </ul>     
     */
    public static enum ModelEngineVer{
        V239(239, "239")
        ,V240(240, "240")
;
           
        public final String text;
        public final int value;
        
        private ModelEngineVer(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static ModelEngineVer from(int value){
            switch(value){
                case 239:
                    return V239;
                case 240:
                    return V240;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 分组标题栏关闭模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无关闭
     * <li>OPENDEFAULT&nbsp;(1)
     * <P>
     * 启用关闭（默认打开）
     * <li>CLOSEDEFAULT&nbsp;(2)
     * <P>
     * 启用关闭（默认关闭）
     * </ul>     
     */
    public static enum GroupTitleBarCloseMode{
        NONE(0, "无关闭")
        ,OPENDEFAULT(1, "启用关闭（默认打开）")
        ,CLOSEDEFAULT(2, "启用关闭（默认关闭）")
;
           
        public final String text;
        public final int value;
        
        private GroupTitleBarCloseMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GroupTitleBarCloseMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return OPENDEFAULT;
                case 2:
                    return CLOSEDEFAULT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 视图消息位置
     * <P>
     * <ul>
     * <li>TOP
     * <P>
     * 视图上方，在视图的最上方显示
     * <li>BOTTOM
     * <P>
     * 视图下方，在视图的最下方显示
     * <li>BODY
     * <P>
     * 视图内容区，在视图的内容区显示，一般在工具栏或视图标题下方
     * <li>POPUP
     * <P>
     * 弹出，模态弹出显示
     * <li>CUSTOM
     * <P>
     * 自定义
     * </ul>     
     */
    public static enum ViewMsgPos{
        TOP("TOP", "视图上方")
        ,BOTTOM("BOTTOM", "视图下方")
        ,BODY("BODY", "视图内容区")
        ,POPUP("POPUP", "弹出")
        ,CUSTOM("CUSTOM", "自定义")
;
           
        public final String text;
        public final String value;
        
        private ViewMsgPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ViewMsgPos from(String value){
            switch(value){
                case "TOP":
                    return TOP;
                case "BOTTOM":
                    return BOTTOM;
                case "BODY":
                    return BODY;
                case "POPUP":
                    return POPUP;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * Pipeline触发器类型
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>CRON
     * <P>
     * 定时
     * </ul>     
     */
    public static enum PipelineTriggerType{
        NONE("NONE", "无")
        ,CRON("CRON", "定时")
;
           
        public final String text;
        public final String value;
        
        private PipelineTriggerType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PipelineTriggerType from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "CRON":
                    return CRON;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 工具插件类别
     * <P>
     * <ul>
     * <li>CENTRAL
     * <P>
     * 中台
     * <li>MODELING
     * <P>
     * 建模
     * </ul>     
     */
    public static enum StudioPluginCat{
        CENTRAL("CENTRAL", "中台")
        ,MODELING("MODELING", "建模")
;
           
        public final String text;
        public final String value;
        
        private StudioPluginCat(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static StudioPluginCat from(String value){
            switch(value){
                case "CENTRAL":
                    return CENTRAL;
                case "MODELING":
                    return MODELING;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 是否，数值项
     * <P>
     * <ul>
     * <li>YES&nbsp;(1)
     * <P>
     * 是
     * <li>NO&nbsp;(0)
     * <P>
     * 否
     * </ul>     
     */
    public static enum YesNo{
        YES(1, "是")
        ,NO(0, "否")
;
           
        public final String text;
        public final int value;
        
        private YesNo(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static YesNo from(int value){
            switch(value){
                case 1:
                    return YES;
                case 0:
                    return NO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 临时数据处理模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不启用
     * <li>BACKEND&nbsp;(1)
     * <P>
     * 后台，后台提供显式临时数据存储能力，前端可对临时数据或真实数据进行直接操作，后台提供真实数据复制到临时数据及临时数据转为真实数据的能力
     * <li>FRONT&nbsp;(2)
     * <P>
     * 前端，前端提供临时数据存储能力，后台提供包数据获取及建立、更新能力。前端一次性将数据加载回来，在前端完成数据的加工，然后再整体提交到后台
     * <li>BACKENDANDFRONT&nbsp;(3)
     * <P>
     * 后台及前端，后台及前端都提供临时数据处理能力，由处理选择使用模式
     * </ul>     
     */
    public static enum DETempDataHolder{
        NONE(0, "不启用")
        ,BACKEND(1, "后台")
        ,FRONT(2, "前端")
        ,BACKENDANDFRONT(3, "后台及前端")
;
           
        public final String text;
        public final int value;
        
        private DETempDataHolder(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DETempDataHolder from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return BACKEND;
                case 2:
                    return FRONT;
                case 3:
                    return BACKENDANDFRONT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑合并数据参数模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认（合并到目标参数，不存在时忽略），合并至目标数组参数，忽略目标不存在的数据
     * <li>UNION
     * <P>
     * 全集（合并到目标参数，不存在时新建），源数据参数和目标数组参数进行排重合并
     * <li>INTERSECTION
     * <P>
     * 交集（合并源和目标重复出现的数据），源数据参数和目标数组参数进行交集合并，即合并两个数组重复出现的数据
     * <li>DEFFERENCE
     * <P>
     * 差集（合并源和目标没有重复出现的数据），源数据参数和目标数组参数进行差集合并，即合并两个数组没有重复出现的数据
     * </ul>     
     */
    public static enum DELNMergeParamMode{
        DEFAULT("DEFAULT", "默认（合并到目标参数，不存在时忽略）")
        ,UNION("UNION", "全集（合并到目标参数，不存在时新建）")
        ,INTERSECTION("INTERSECTION", "交集（合并源和目标重复出现的数据）")
        ,DEFFERENCE("DEFFERENCE", "差集（合并源和目标没有重复出现的数据）")
;
           
        public final String text;
        public final String value;
        
        private DELNMergeParamMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELNMergeParamMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "UNION":
                    return UNION;
                case "INTERSECTION":
                    return INTERSECTION;
                case "DEFFERENCE":
                    return DEFFERENCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 流程处理角色类型
     * <P>
     * <ul>
     * <li>WFROLE
     * <P>
     * 工作流角色，流程处理角色引用系统定义的工作流角色
     * <li>LASTTWOSTEPACTOR
     * <P>
     * 上两个步骤操作者
     * <li>LASTTHREESTEPACTOR
     * <P>
     * 上三个步骤操作者
     * <li>LASTSTEPACTOR
     * <P>
     * 上一步骤操作者
     * <li>UDACTOR
     * <P>
     * 当前数据属性，流程处理角色从流程数据的指定属性中读取
     * <li>CURACTOR
     * <P>
     * 当前操作者
     * </ul>     
     */
    public static enum WFProcRoleType{
        WFROLE("WFROLE", "工作流角色")
        ,LASTTWOSTEPACTOR("LASTTWOSTEPACTOR", "上两个步骤操作者")
        ,LASTTHREESTEPACTOR("LASTTHREESTEPACTOR", "上三个步骤操作者")
        ,LASTSTEPACTOR("LASTSTEPACTOR", "上一步骤操作者")
        ,UDACTOR("UDACTOR", "当前数据属性")
        ,CURACTOR("CURACTOR", "当前操作者")
;
           
        public final String text;
        public final String value;
        
        private WFProcRoleType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WFProcRoleType from(String value){
            switch(value){
                case "WFROLE":
                    return WFROLE;
                case "LASTTWOSTEPACTOR":
                    return LASTTWOSTEPACTOR;
                case "LASTTHREESTEPACTOR":
                    return LASTTHREESTEPACTOR;
                case "LASTSTEPACTOR":
                    return LASTSTEPACTOR;
                case "UDACTOR":
                    return UDACTOR;
                case "CURACTOR":
                    return CURACTOR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 消息框按钮类型
     * <P>
     * <ul>
     * <li>YESNO
     * <P>
     * 是、否
     * <li>YESNOCANCEL
     * <P>
     * 是、否、取消
     * <li>OK
     * <P>
     * 确定
     * <li>OKCANCEL
     * <P>
     * 确定、取消
     * </ul>     
     */
    public static enum DELNMsgBoxButtonsType{
        YESNO("YESNO", "是、否")
        ,YESNOCANCEL("YESNOCANCEL", "是、否、取消")
        ,OK("OK", "确定")
        ,OKCANCEL("OKCANCEL", "确定、取消")
;
           
        public final String text;
        public final String value;
        
        private DELNMsgBoxButtonsType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELNMsgBoxButtonsType from(String value){
            switch(value){
                case "YESNO":
                    return YESNO;
                case "YESNOCANCEL":
                    return YESNOCANCEL;
                case "OK":
                    return OK;
                case "OKCANCEL":
                    return OKCANCEL;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 平台数据同步方向
     * <P>
     * <ul>
     * <li>IN
     * <P>
     * 输入，从外部系统获取数据
     * <li>OUT
     * <P>
     * 输出，向外部系统发送数据
     * </ul>     
     */
    public static enum DataSyncDir{
        IN("IN", "输入")
        ,OUT("OUT", "输出")
;
           
        public final String text;
        public final String value;
        
        private DataSyncDir(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataSyncDir from(String value){
            switch(value){
                case "IN":
                    return IN;
                case "OUT":
                    return OUT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体搜索栏过滤分组模式
     * <P>
     * <ul>
     * <li>SINGLE
     * <P>
     * 单项
     * <li>AND
     * <P>
     * 多项（与逻辑）
     * <li>OR
     * <P>
     * 多项（或逻辑）
     * </ul>     
     */
    public static enum SearchBarGroupMode{
        SINGLE("SINGLE", "单项")
        ,AND("AND", "多项（与逻辑）")
        ,OR("OR", "多项（或逻辑）")
;
           
        public final String text;
        public final String value;
        
        private SearchBarGroupMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SearchBarGroupMode from(String value){
            switch(value){
                case "SINGLE":
                    return SINGLE;
                case "AND":
                    return AND;
                case "OR":
                    return OR;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 按钮绘制模式
     * <P>
     * <ul>
     * <li>BUTTON
     * <P>
     * 按钮
     * <li>LINK
     * <P>
     * 链接
     * </ul>     
     */
    public static enum ButtonRenderMode{
        BUTTON("BUTTON", "按钮")
        ,LINK("LINK", "链接")
;
           
        public final String text;
        public final String value;
        
        private ButtonRenderMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ButtonRenderMode from(String value){
            switch(value){
                case "BUTTON":
                    return BUTTON;
                case "LINK":
                    return LINK;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 测试用例输入类型
     * <P>
     * <ul>
     * <li>DATA
     * <P>
     * 数据
     * <li>CUSTOMCODE
     * <P>
     * 自定义代码，测试用例输入为自定义代码，对定义的数据进行进一步的加工
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum TestCaseInputType{
        DATA("DATA", "数据")
        ,CUSTOMCODE("CUSTOMCODE", "自定义代码")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private TestCaseInputType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TestCaseInputType from(String value){
            switch(value){
                case "DATA":
                    return DATA;
                case "CUSTOMCODE":
                    return CUSTOMCODE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 云平台向导步骤行为，多值模式（字符或处理）
     * <P>
     * <ul>
     * <li>PREV
     * <P>
     * 上一步
     * <li>NEXT
     * <P>
     * 下一步
     * <li>FINISH
     * <P>
     * 完成
     * </ul>     
     */
    public static enum WizardStepAction{
        PREV("PREV", "上一步")
        ,NEXT("NEXT", "下一步")
        ,FINISH("FINISH", "完成")
;
           
        public final String text;
        public final String value;
        
        private WizardStepAction(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static WizardStepAction from(String value){
            switch(value){
                case "PREV":
                    return PREV;
                case "NEXT":
                    return NEXT;
                case "FINISH":
                    return FINISH;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统ER图视图模式
     * <P>
     * <ul>
     * <li>PV
     * <P>
     * 物理视图
     * <li>LV
     * <P>
     * 逻辑视图
     * </ul>     
     */
    public static enum ERMapViewMode{
        PV("PV", "物理视图")
        ,LV("LV", "逻辑视图")
;
           
        public final String text;
        public final String value;
        
        private ERMapViewMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ERMapViewMode from(String value){
            switch(value){
                case "PV":
                    return PV;
                case "LV":
                    return LV;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体用户界面行为（关闭能力），数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>NOCREATE&nbsp;(1)
     * <P>
     * 无建立
     * <li>NOUPDATE&nbsp;(2)
     * <P>
     * 无更新
     * <li>NOREMOVE&nbsp;(4)
     * <P>
     * 无删除
     * </ul>     
     */
    public static enum DEUserUIAbility{
        NOCREATE(1, "无建立")
        ,NOUPDATE(2, "无更新")
        ,NOREMOVE(4, "无删除")
;
           
        public final String text;
        public final int value;
        
        private DEUserUIAbility(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEUserUIAbility from(int value){
            switch(value){
                case 1:
                    return NOCREATE;
                case 2:
                    return NOUPDATE;
                case 4:
                    return NOREMOVE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 门户部件使用范围，数值项
     * <P>
     * <ul>
     * <li>APP&nbsp;(1)
     * <P>
     * 应用数据看板，门户部件仅支持放置在全局的数据看板上
     * <li>DE&nbsp;(2)
     * <P>
     * 实体数据看板，门户部件仅支持放置在实体的数据看板上，门户部件需要指定当前实体的值
     * <li>APPANDDE&nbsp;(3)
     * <P>
     * 应用及实体数据看板，门户部件支持放置在系统或实体的数据看板上
     * </ul>     
     */
    public static enum DashboardScope{
        APP(1, "应用数据看板")
        ,DE(2, "实体数据看板")
        ,APPANDDE(3, "应用及实体数据看板")
;
           
        public final String text;
        public final int value;
        
        private DashboardScope(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DashboardScope from(int value){
            switch(value){
                case 1:
                    return APP;
                case 2:
                    return DE;
                case 3:
                    return APPANDDE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 分析维度体系类型
     * <P>
     * <ul>
     * <li>DE
     * <P>
     * 实体对象
     * </ul>     
     */
    public static enum BIHierarchyType{
        DE("DE", "实体对象")
;
           
        public final String text;
        public final String value;
        
        private BIHierarchyType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static BIHierarchyType from(String value){
            switch(value){
                case "DE":
                    return DE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统数据库索引来源
     * <P>
     * <ul>
     * <li>DEDBINDEX
     * <P>
     * 实体数据索引
     * <li>DER
     * <P>
     * 实体关系
     * </ul>     
     */
    public static enum DBIndexSource{
        DEDBINDEX("DEDBINDEX", "实体数据索引")
        ,DER("DER", "实体关系")
;
           
        public final String text;
        public final String value;
        
        private DBIndexSource(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DBIndexSource from(String value){
            switch(value){
                case "DEDBINDEX":
                    return DEDBINDEX;
                case "DER":
                    return DER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体处理逻辑节点参数源值类型
     * <P>
     * <ul>
     * <li>SRCDLPARAM
     * <P>
     * 源逻辑参数，指定源处理逻辑参数
     * <li>WEBCONTEXT
     * <P>
     * 网页请求上下文
     * <li>APPDATA
     * <P>
     * 当前应用数据
     * <li>APPLICATION
     * <P>
     * 系统全局对象
     * <li>SESSION
     * <P>
     * 用户全局对象
     * <li>DATACONTEXT
     * <P>
     * 数据上下文
     * <li>ENVPARAM
     * <P>
     * 当前环境参数
     * <li>VIEWPARAM
     * <P>
     * 当前视图参数
     * <li>NONEVALUE
     * <P>
     * 无值（NONE）
     * <li>NULLVALUE
     * <P>
     * 空值（NULL）
     * <li>SRCVALUE
     * <P>
     * 直接值
     * <li>EXPRESSION
     * <P>
     * 计算式
     * <li>COUNT
     * <P>
     * 数组数量
     * <li>AGGREGATION
     * <P>
     * 数组聚合计算
     * <li>SEQUENCE
     * <P>
     * 系统值序列
     * </ul>     
     */
    public static enum DELogicParamValueType{
        SRCDLPARAM("SRCDLPARAM", "源逻辑参数")
        ,WEBCONTEXT("WEBCONTEXT", "网页请求上下文")
        ,APPDATA("APPDATA", "当前应用数据")
        ,APPLICATION("APPLICATION", "系统全局对象")
        ,SESSION("SESSION", "用户全局对象")
        ,DATACONTEXT("DATACONTEXT", "数据上下文")
        ,ENVPARAM("ENVPARAM", "当前环境参数")
        ,VIEWPARAM("VIEWPARAM", "当前视图参数")
        ,NONEVALUE("NONEVALUE", "无值（NONE）")
        ,NULLVALUE("NULLVALUE", "空值（NULL）")
        ,SRCVALUE("SRCVALUE", "直接值")
        ,EXPRESSION("EXPRESSION", "计算式")
        ,COUNT("COUNT", "数组数量")
        ,AGGREGATION("AGGREGATION", "数组聚合计算")
        ,SEQUENCE("SEQUENCE", "系统值序列")
;
           
        public final String text;
        public final String value;
        
        private DELogicParamValueType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicParamValueType from(String value){
            switch(value){
                case "SRCDLPARAM":
                    return SRCDLPARAM;
                case "WEBCONTEXT":
                    return WEBCONTEXT;
                case "APPDATA":
                    return APPDATA;
                case "APPLICATION":
                    return APPLICATION;
                case "SESSION":
                    return SESSION;
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "ENVPARAM":
                    return ENVPARAM;
                case "VIEWPARAM":
                    return VIEWPARAM;
                case "NONEVALUE":
                    return NONEVALUE;
                case "NULLVALUE":
                    return NULLVALUE;
                case "SRCVALUE":
                    return SRCVALUE;
                case "EXPRESSION":
                    return EXPRESSION;
                case "COUNT":
                    return COUNT;
                case "AGGREGATION":
                    return AGGREGATION;
                case "SEQUENCE":
                    return SEQUENCE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体表单分页位置
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左边
     * <li>TOP
     * <P>
     * 上方
     * <li>RIGHT
     * <P>
     * 右边
     * <li>BOTTOM
     * <P>
     * 下方
     * </ul>     
     */
    public static enum TabHeaderPos{
        LEFT("LEFT", "左边")
        ,TOP("TOP", "上方")
        ,RIGHT("RIGHT", "右边")
        ,BOTTOM("BOTTOM", "下方")
;
           
        public final String text;
        public final String value;
        
        private TabHeaderPos(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TabHeaderPos from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "TOP":
                    return TOP;
                case "RIGHT":
                    return RIGHT;
                case "BOTTOM":
                    return BOTTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 树节点计数器类型，数值项
     * <P>
     * <ul>
     * <li>DEFAULT&nbsp;(0)
     * <P>
     * 默认
     * <li>HIDEZERO&nbsp;(1)
     * <P>
     * 0 值时隐藏，当计数值为0时隐藏所在节点
     * </ul>     
     */
    public static enum TreeNodeCounterMode{
        DEFAULT(0, "默认")
        ,HIDEZERO(1, "0 值时隐藏")
;
           
        public final String text;
        public final int value;
        
        private TreeNodeCounterMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static TreeNodeCounterMode from(int value){
            switch(value){
                case 0:
                    return DEFAULT;
                case 1:
                    return HIDEZERO;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 传入父值处理模式
     * <P>
     * <ul>
     * <li>DEFAULT
     * <P>
     * 默认
     * <li>DATACONTEXT
     * <P>
     * 数据上下文（查询）
     * <li>CHILDOF
     * <P>
     * 递归子数据（查询）
     * <li>IGNORE
     * <P>
     * 忽略，忽略传入父值
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum SADEMethodParentKeyMode{
        DEFAULT("DEFAULT", "默认")
        ,DATACONTEXT("DATACONTEXT", "数据上下文（查询）")
        ,CHILDOF("CHILDOF", "递归子数据（查询）")
        ,IGNORE("IGNORE", "忽略")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private SADEMethodParentKeyMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SADEMethodParentKeyMode from(String value){
            switch(value){
                case "DEFAULT":
                    return DEFAULT;
                case "DATACONTEXT":
                    return DATACONTEXT;
                case "CHILDOF":
                    return CHILDOF;
                case "IGNORE":
                    return IGNORE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 内容水平对齐方式
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左对齐
     * <li>CENTER
     * <P>
     * 居中
     * <li>RIGHT
     * <P>
     * 右对齐
     * <li>JUSTIFY
     * <P>
     * 两端对齐
     * </ul>     
     */
    public static enum TextAlign{
        LEFT("LEFT", "左对齐")
        ,CENTER("CENTER", "居中")
        ,RIGHT("RIGHT", "右对齐")
        ,JUSTIFY("JUSTIFY", "两端对齐")
;
           
        public final String text;
        public final String value;
        
        private TextAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static TextAlign from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "CENTER":
                    return CENTER;
                case "RIGHT":
                    return RIGHT;
                case "JUSTIFY":
                    return JUSTIFY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 图表坐标轴类型
     * <P>
     * <ul>
     * <li>NUMERIC&nbsp;(numeric)
     * <P>
     * 数值，坐标轴用于标注数字值
     * <li>TIME&nbsp;(time)
     * <P>
     * 时间，坐标轴用于标注时间值
     * <li>CATEGORY&nbsp;(category)
     * <P>
     * 分类，坐标轴用于标注分类值
     * <li>LOG&nbsp;(log)
     * <P>
     * 对数轴，坐标轴用于标注对数值
     * </ul>     
     */
    public static enum ChartAxisType{
        NUMERIC("numeric", "数值")
        ,TIME("time", "时间")
        ,CATEGORY("category", "分类")
        ,LOG("log", "对数轴")
;
           
        public final String text;
        public final String value;
        
        private ChartAxisType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ChartAxisType from(String value){
            switch(value){
                case "numeric":
                    return NUMERIC;
                case "time":
                    return TIME;
                case "category":
                    return CATEGORY;
                case "log":
                    return LOG;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据视图样式
     * <P>
     * <ul>
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum DataViewStyle{
        USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private DataViewStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataViewStyle from(String value){
            switch(value){
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体处理逻辑节点参数操作
     * <P>
     * <ul>
     * <li>SETPARAMVALUE
     * <P>
     * 设置变量
     * <li>RESETPARAM
     * <P>
     * 重置变量
     * <li>COPYPARAM
     * <P>
     * 拷贝变量
     * <li>BINDPARAM
     * <P>
     * 绑定变量
     * <li>APPENDPARAM
     * <P>
     * 附加到数组变量
     * <li>SORTPARAM
     * <P>
     * 排序数组变量
     * <li>RENEWPARAM
     * <P>
     * 重新建立变量
     * </ul>     
     */
    public static enum DELogicParamAction{
        SETPARAMVALUE("SETPARAMVALUE", "设置变量")
        ,RESETPARAM("RESETPARAM", "重置变量")
        ,COPYPARAM("COPYPARAM", "拷贝变量")
        ,BINDPARAM("BINDPARAM", "绑定变量")
        ,APPENDPARAM("APPENDPARAM", "附加到数组变量")
        ,SORTPARAM("SORTPARAM", "排序数组变量")
        ,RENEWPARAM("RENEWPARAM", "重新建立变量")
;
           
        public final String text;
        public final String value;
        
        private DELogicParamAction(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicParamAction from(String value){
            switch(value){
                case "SETPARAMVALUE":
                    return SETPARAMVALUE;
                case "RESETPARAM":
                    return RESETPARAM;
                case "COPYPARAM":
                    return COPYPARAM;
                case "BINDPARAM":
                    return BINDPARAM;
                case "APPENDPARAM":
                    return APPENDPARAM;
                case "SORTPARAM":
                    return SORTPARAM;
                case "RENEWPARAM":
                    return RENEWPARAM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为参数模式，数值项
     * <P>
     * <ul>
     * <li>ALL&nbsp;(1)
     * <P>
     * 默认参数（设置指定参数项值）
     * <li>SOME&nbsp;(2)
     * <P>
     * 指定参数，非启用运行时系统模型主键将默认传入，否则需要手动指定主键（如需要）
     * <li>OBJECT&nbsp;(3)
     * <P>
     * 其它对象
     * <li>NONE&nbsp;(99)
     * <P>
     * 无参数
     * </ul>     
     */
    public static enum DEActionParamMode{
        ALL(1, "默认参数（设置指定参数项值）")
        ,SOME(2, "指定参数")
        ,OBJECT(3, "其它对象")
        ,NONE(99, "无参数")
;
           
        public final String text;
        public final int value;
        
        private DEActionParamMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionParamMode from(int value){
            switch(value){
                case 1:
                    return ALL;
                case 2:
                    return SOME;
                case 3:
                    return OBJECT;
                case 99:
                    return NONE;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统角色默认模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>ACCESSUSER
     * <P>
     * 授权访问用户，角色中的用户将被授权访问系统
     * <li>ACCESSADMIN
     * <P>
     * 授权访问用户（管理员），角色中的用户将被授权以管理员的身份访问系统
     * <li>USER
     * <P>
     * 用户默认，用户将默认具备该角色身份
     * <li>ADMIN
     * <P>
     * 管理员默认，管理员将默认具备该角色身份
     * </ul>     
     */
    public static enum SysRoleDefaultUser{
        NONE("NONE", "无")
        ,ACCESSUSER("ACCESSUSER", "授权访问用户")
        ,ACCESSADMIN("ACCESSADMIN", "授权访问用户（管理员）")
        ,USER("USER", "用户默认")
        ,ADMIN("ADMIN", "管理员默认")
;
           
        public final String text;
        public final String value;
        
        private SysRoleDefaultUser(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static SysRoleDefaultUser from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "ACCESSUSER":
                    return ACCESSUSER;
                case "ACCESSADMIN":
                    return ACCESSADMIN;
                case "USER":
                    return USER;
                case "ADMIN":
                    return ADMIN;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 代码表预置类型
     * <P>
     * <ul>
     * <li>OPERATOR
     * <P>
     * 系统操作者，系统操作者
     * <li>RUNTIME
     * <P>
     * 运行时代码表，运行子系统代码表
     * <li>MODULEINST
     * <P>
     * 模块副本，动态实例模块副本
     * <li>DEMAINSTATE
     * <P>
     * 实体主状态
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum PredefinedCodeListType{
        OPERATOR("OPERATOR", "系统操作者")
        ,RUNTIME("RUNTIME", "运行时代码表")
        ,MODULEINST("MODULEINST", "模块副本")
        ,DEMAINSTATE("DEMAINSTATE", "实体主状态")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private PredefinedCodeListType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static PredefinedCodeListType from(String value){
            switch(value){
                case "OPERATOR":
                    return OPERATOR;
                case "RUNTIME":
                    return RUNTIME;
                case "MODULEINST":
                    return MODULEINST;
                case "DEMAINSTATE":
                    return DEMAINSTATE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用功能视图类型
     * <P>
     * <ul>
     * <li>APPSTARTVIEW
     * <P>
     * 应用启动视图
     * <li>APPWELCOMEVIEW
     * <P>
     * 应用欢迎视图
     * <li>APPLOGINVIEW
     * <P>
     * 应用登录视图
     * <li>APPLOGOUTVIEW
     * <P>
     * 应用注销视图
     * <li>APPFILEUPLOADVIEW
     * <P>
     * 应用文件上传视图
     * <li>APPPICUPLOADVIEW
     * <P>
     * 应用图片上传视图
     * <li>APPDATAUPLOADVIEW
     * <P>
     * 应用数据导入视图
     * <li>APPFUNCPICKUPVIEW
     * <P>
     * 应用功能选择视图
     * <li>APPERRORVIEW
     * <P>
     * 应用错误显示视图
     * <li>APPWFSTEPDATAVIEW
     * <P>
     * 应用流程处理记录视图
     * <li>APPWFSTEPACTORVIEW
     * <P>
     * 应用流程当前处理人视图
     * <li>APPWFSTEPTRACEVIEW
     * <P>
     * 应用流程跟踪视图
     * <li>APPWFSENDBACKVIEW
     * <P>
     * 应用流程回退操作视图
     * <li>APPWFSUPPLYINFOVIEW
     * <P>
     * 应用流程补充信息操作视图
     * <li>APPWFADDSTEPBEFOREVIEW
     * <P>
     * 应用流程前加签操作视图
     * <li>APPWFADDSTEPAFTERVIEW
     * <P>
     * 应用流程后加签操作视图
     * <li>APPWFTAKEADVICEVIEW
     * <P>
     * 应用流程征求意见操作视图
     * <li>APPWFREDIRECTVIEW
     * <P>
     * 应用全局流程工作重定向视图
     * <li>APPREDIRECTVIEW
     * <P>
     * 应用全局重定向视图
     * </ul>     
     */
    public static enum AppUtilViewType{
        APPSTARTVIEW("APPSTARTVIEW", "应用启动视图")
        ,APPWELCOMEVIEW("APPWELCOMEVIEW", "应用欢迎视图")
        ,APPLOGINVIEW("APPLOGINVIEW", "应用登录视图")
        ,APPLOGOUTVIEW("APPLOGOUTVIEW", "应用注销视图")
        ,APPFILEUPLOADVIEW("APPFILEUPLOADVIEW", "应用文件上传视图")
        ,APPPICUPLOADVIEW("APPPICUPLOADVIEW", "应用图片上传视图")
        ,APPDATAUPLOADVIEW("APPDATAUPLOADVIEW", "应用数据导入视图")
        ,APPFUNCPICKUPVIEW("APPFUNCPICKUPVIEW", "应用功能选择视图")
        ,APPERRORVIEW("APPERRORVIEW", "应用错误显示视图")
        ,APPWFSTEPDATAVIEW("APPWFSTEPDATAVIEW", "应用流程处理记录视图")
        ,APPWFSTEPACTORVIEW("APPWFSTEPACTORVIEW", "应用流程当前处理人视图")
        ,APPWFSTEPTRACEVIEW("APPWFSTEPTRACEVIEW", "应用流程跟踪视图")
        ,APPWFSENDBACKVIEW("APPWFSENDBACKVIEW", "应用流程回退操作视图")
        ,APPWFSUPPLYINFOVIEW("APPWFSUPPLYINFOVIEW", "应用流程补充信息操作视图")
        ,APPWFADDSTEPBEFOREVIEW("APPWFADDSTEPBEFOREVIEW", "应用流程前加签操作视图")
        ,APPWFADDSTEPAFTERVIEW("APPWFADDSTEPAFTERVIEW", "应用流程后加签操作视图")
        ,APPWFTAKEADVICEVIEW("APPWFTAKEADVICEVIEW", "应用流程征求意见操作视图")
        ,APPWFREDIRECTVIEW("APPWFREDIRECTVIEW", "应用全局流程工作重定向视图")
        ,APPREDIRECTVIEW("APPREDIRECTVIEW", "应用全局重定向视图")
;
           
        public final String text;
        public final String value;
        
        private AppUtilViewType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppUtilViewType from(String value){
            switch(value){
                case "APPSTARTVIEW":
                    return APPSTARTVIEW;
                case "APPWELCOMEVIEW":
                    return APPWELCOMEVIEW;
                case "APPLOGINVIEW":
                    return APPLOGINVIEW;
                case "APPLOGOUTVIEW":
                    return APPLOGOUTVIEW;
                case "APPFILEUPLOADVIEW":
                    return APPFILEUPLOADVIEW;
                case "APPPICUPLOADVIEW":
                    return APPPICUPLOADVIEW;
                case "APPDATAUPLOADVIEW":
                    return APPDATAUPLOADVIEW;
                case "APPFUNCPICKUPVIEW":
                    return APPFUNCPICKUPVIEW;
                case "APPERRORVIEW":
                    return APPERRORVIEW;
                case "APPWFSTEPDATAVIEW":
                    return APPWFSTEPDATAVIEW;
                case "APPWFSTEPACTORVIEW":
                    return APPWFSTEPACTORVIEW;
                case "APPWFSTEPTRACEVIEW":
                    return APPWFSTEPTRACEVIEW;
                case "APPWFSENDBACKVIEW":
                    return APPWFSENDBACKVIEW;
                case "APPWFSUPPLYINFOVIEW":
                    return APPWFSUPPLYINFOVIEW;
                case "APPWFADDSTEPBEFOREVIEW":
                    return APPWFADDSTEPBEFOREVIEW;
                case "APPWFADDSTEPAFTERVIEW":
                    return APPWFADDSTEPAFTERVIEW;
                case "APPWFTAKEADVICEVIEW":
                    return APPWFTAKEADVICEVIEW;
                case "APPWFREDIRECTVIEW":
                    return APPWFREDIRECTVIEW;
                case "APPREDIRECTVIEW":
                    return APPREDIRECTVIEW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体属性界面配置输出代码表配置，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无
     * <li>SELECTEDONLY&nbsp;(1)
     * <P>
     * 只输出选择项
     * <li>INCLUDECHILD&nbsp;(2)
     * <P>
     * 输出子项
     * </ul>     
     */
    public static enum OutputCodeListMode{
        NONE(0, "无")
        ,SELECTEDONLY(1, "只输出选择项")
        ,INCLUDECHILD(2, "输出子项")
;
           
        public final String text;
        public final int value;
        
        private OutputCodeListMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static OutputCodeListMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return SELECTEDONLY;
                case 2:
                    return INCLUDECHILD;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 属性实体主状态值
     * <P>
     * <ul>
     * <li>STATE1
     * <P>
     * 状态属性1
     * <li>STATE2
     * <P>
     * 状态属性2
     * <li>STATE3
     * <P>
     * 状态属性3
     * </ul>     
     */
    public static enum DEMSFieldMode{
        STATE1("STATE1", "状态属性1")
        ,STATE2("STATE2", "状态属性2")
        ,STATE3("STATE3", "状态属性3")
;
           
        public final String text;
        public final String value;
        
        private DEMSFieldMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEMSFieldMode from(String value){
            switch(value){
                case "STATE1":
                    return STATE1;
                case "STATE2":
                    return STATE2;
                case "STATE3":
                    return STATE3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 应用逻辑类型
     * <P>
     * <ul>
     * <li>TIMER
     * <P>
     * 定时器触发，定时器定时触发逻辑，需指定定时器时间间隔
     * <li>APPEVENT
     * <P>
     * 应用事件触发，应用事件触发逻辑，需指定事件名称，如初始化、加载等
     * <li>CUSTOM
     * <P>
     * 只挂接（外部调用），仅发布逻辑，不挂接任何事件，由其它逻辑驱动或自定义代码调用
     * </ul>     
     */
    public static enum AppLogicTrigger{
        TIMER("TIMER", "定时器触发")
        ,APPEVENT("APPEVENT", "应用事件触发")
        ,CUSTOM("CUSTOM", "只挂接（外部调用）")
;
           
        public final String text;
        public final String value;
        
        private AppLogicTrigger(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppLogicTrigger from(String value){
            switch(value){
                case "TIMER":
                    return TIMER;
                case "APPEVENT":
                    return APPEVENT;
                case "CUSTOM":
                    return CUSTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体逻辑节点线程运行模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 不启用
     * <li>THREAD&nbsp;(1)
     * <P>
     * 线程执行
     * <li>TIMER&nbsp;(2)
     * <P>
     * 定时执行
     * </ul>     
     */
    public static enum DELogicNodeThreadRunMode{
        NONE(0, "不启用")
        ,THREAD(1, "线程执行")
        ,TIMER(2, "定时执行")
;
           
        public final String text;
        public final int value;
        
        private DELogicNodeThreadRunMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DELogicNodeThreadRunMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return THREAD;
                case 2:
                    return TIMER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 数据面板模式
     * <P>
     * <ul>
     * <li>NONE
     * <P>
     * 无
     * <li>LOGINFORM
     * <P>
     * 登录表单，指定面板区域数据模式为登录表单，区域中定义登录名称，登录密码等相关属性
     * <li>SINGLEDATA
     * <P>
     * 单项数据，面板数据区域为单项数据区域，使用指定的数据源
     * <li>MULTIDATA
     * <P>
     * 多项数据（重复器），面板数据区域为多项数据区域，子项内容将按照重复展开，使用指定的数据源
     * <li>MULTIDATA_RAW
     * <P>
     * 多项数据（仅数据），面板数据区域为多项数据区域，使用指定的数据源
     * <li>INHERIT
     * <P>
     * 继承，面板区域数据模式继承父项定义
     * <li>USER
     * <P>
     * 用户自定义
     * </ul>     
     */
    public static enum DataPanelMode{
        NONE("NONE", "无")
        ,LOGINFORM("LOGINFORM", "登录表单")
        ,SINGLEDATA("SINGLEDATA", "单项数据")
        ,MULTIDATA("MULTIDATA", "多项数据（重复器）")
        ,MULTIDATA_RAW("MULTIDATA_RAW", "多项数据（仅数据）")
        ,INHERIT("INHERIT", "继承")
        ,USER("USER", "用户自定义")
;
           
        public final String text;
        public final String value;
        
        private DataPanelMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DataPanelMode from(String value){
            switch(value){
                case "NONE":
                    return NONE;
                case "LOGINFORM":
                    return LOGINFORM;
                case "SINGLEDATA":
                    return SINGLEDATA;
                case "MULTIDATA":
                    return MULTIDATA;
                case "MULTIDATA_RAW":
                    return MULTIDATA_RAW;
                case "INHERIT":
                    return INHERIT;
                case "USER":
                    return USER;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体行为模式
     * <P>
     * <ul>
     * <li>CREATE
     * <P>
     * 创建数据，指定行为为建立数据的操作
     * <li>READ
     * <P>
     * 读取数据，指定行为为读取数据的操作
     * <li>UPDATE
     * <P>
     * 更新数据，指定行为为更新数据的操作
     * <li>DELETE
     * <P>
     * 删除数据，指定行为为删除数据的操作
     * <li>CUSTOM
     * <P>
     * 自定义操作，指定行为为自定义功能操作
     * <li>GETDRAFT
     * <P>
     * 获取草稿，指定行为为获取草稿数据操作
     * <li>UNKNOWN
     * <P>
     * 未知操作，未知的操作
     * <li>MOVEORDER
     * <P>
     * 移动位置，移动位置
     * <li>CHECKKEY
     * <P>
     * 检查主键，检查主键
     * <li>SAVE
     * <P>
     * 保存数据，检查主键
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * <li>USER3
     * <P>
     * 用户自定义3
     * <li>USER4
     * <P>
     * 用户自定义4
     * </ul>     
     */
    public static enum DEActionMode{
        CREATE("CREATE", "创建数据")
        ,READ("READ", "读取数据")
        ,UPDATE("UPDATE", "更新数据")
        ,DELETE("DELETE", "删除数据")
        ,CUSTOM("CUSTOM", "自定义操作")
        ,GETDRAFT("GETDRAFT", "获取草稿")
        ,UNKNOWN("UNKNOWN", "未知操作")
        ,MOVEORDER("MOVEORDER", "移动位置")
        ,CHECKKEY("CHECKKEY", "检查主键")
        ,SAVE("SAVE", "保存数据")
        ,USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
        ,USER3("USER3", "用户自定义3")
        ,USER4("USER4", "用户自定义4")
;
           
        public final String text;
        public final String value;
        
        private DEActionMode(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEActionMode from(String value){
            switch(value){
                case "CREATE":
                    return CREATE;
                case "READ":
                    return READ;
                case "UPDATE":
                    return UPDATE;
                case "DELETE":
                    return DELETE;
                case "CUSTOM":
                    return CUSTOM;
                case "GETDRAFT":
                    return GETDRAFT;
                case "UNKNOWN":
                    return UNKNOWN;
                case "MOVEORDER":
                    return MOVEORDER;
                case "CHECKKEY":
                    return CHECKKEY;
                case "SAVE":
                    return SAVE;
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                case "USER3":
                    return USER3;
                case "USER4":
                    return USER4;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 系统应用功能页面目标类型
     * <P>
     * <ul>
     * <li>PAGEURL
     * <P>
     * 页面路径
     * <li>APPVIEW
     * <P>
     * 应用视图
     * </ul>     
     */
    public static enum AppUtilPageTargetType{
        PAGEURL("PAGEURL", "页面路径")
        ,APPVIEW("APPVIEW", "应用视图")
;
           
        public final String text;
        public final String value;
        
        private AppUtilPageTargetType(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static AppUtilPageTargetType from(String value){
            switch(value){
                case "PAGEURL":
                    return PAGEURL;
                case "APPVIEW":
                    return APPVIEW;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 甘特图样式
     * <P>
     * <ul>
     * <li>USER
     * <P>
     * 用户自定义
     * <li>USER2
     * <P>
     * 用户自定义2
     * </ul>     
     */
    public static enum GanttStyle{
        USER("USER", "用户自定义")
        ,USER2("USER2", "用户自定义2")
;
           
        public final String text;
        public final String value;
        
        private GanttStyle(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static GanttStyle from(String value){
            switch(value){
                case "USER":
                    return USER;
                case "USER2":
                    return USER2;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表单信息模式，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无启用
     * <li>ENABLED&nbsp;(1)
     * <P>
     * 启用
     * <li>AUTO&nbsp;(3)
     * <P>
     * 启用（选择控件自动转换），选择控件将根据引用数据是否提供信息展示视图转换为链接部件或标签部件
     * <li>READONLY&nbsp;(5)
     * <P>
     * 启用（控件以只读形式呈现），控件将默认启用只读形式
     * </ul>     
     */
    public static enum InfoFormMode{
        NONE(0, "无启用")
        ,ENABLED(1, "启用")
        ,AUTO(3, "启用（选择控件自动转换）")
        ,READONLY(5, "启用（控件以只读形式呈现）")
;
           
        public final String text;
        public final int value;
        
        private InfoFormMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static InfoFormMode from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return ENABLED;
                case 3:
                    return AUTO;
                case 5:
                    return READONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 按钮图标方向
     * <P>
     * <ul>
     * <li>LEFT
     * <P>
     * 左侧
     * <li>TOP
     * <P>
     * 上方
     * <li>RIGHT
     * <P>
     * 右侧
     * <li>BOTTOM
     * <P>
     * 下方
     * </ul>     
     */
    public static enum ButtonIconAlign{
        LEFT("LEFT", "左侧")
        ,TOP("TOP", "上方")
        ,RIGHT("RIGHT", "右侧")
        ,BOTTOM("BOTTOM", "下方")
;
           
        public final String text;
        public final String value;
        
        private ButtonIconAlign(String value, String text){
            this.value = value;
            this.text = text;
        }

        public static ButtonIconAlign from(String value){
            switch(value){
                case "LEFT":
                    return LEFT;
                case "TOP":
                    return TOP;
                case "RIGHT":
                    return RIGHT;
                case "BOTTOM":
                    return BOTTOM;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 表格部件即时编辑模式，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>ROW&nbsp;(1)
     * <P>
     * 行编辑
     * <li>NOTCREATE&nbsp;(128)
     * <P>
     * 无新建
     * <li>ORDER&nbsp;(256)
     * <P>
     * 次序调整
     * <li>CHANGEDONLY&nbsp;(2048)
     * <P>
     * 提交变化，仅提交变化值
     * </ul>     
     */
    public static enum GridEditMode{
        ROW(1, "行编辑")
        ,NOTCREATE(128, "无新建")
        ,ORDER(256, "次序调整")
        ,CHANGEDONLY(2048, "提交变化")
;
           
        public final String text;
        public final int value;
        
        private GridEditMode(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static GridEditMode from(int value){
            switch(value){
                case 1:
                    return ROW;
                case 128:
                    return NOTCREATE;
                case 256:
                    return ORDER;
                case 2048:
                    return CHANGEDONLY;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体1：N关系主实体删除关系实体操作，数值项
     * <P>
     * <ul>
     * <li>NONE&nbsp;(0)
     * <P>
     * 无操作，从数据无任何操作，一般用于非关键的日志类数据，关系不启用外键约束
     * <li>DELETE&nbsp;(1)
     * <P>
     * 同时删除，从数据同时删除，一般用于主实体的附属实体
     * <li>RESET&nbsp;(2)
     * <P>
     * 置空，置空从实体对主实体的引用
     * <li>REJECT&nbsp;(3)
     * <P>
     * 限制删除，从实体限制删除，中断主实体的删除操作
     * </ul>     
     */
    public static enum DER1NRemoveActionType{
        NONE(0, "无操作")
        ,DELETE(1, "同时删除")
        ,RESET(2, "置空")
        ,REJECT(3, "限制删除")
;
           
        public final String text;
        public final int value;
        
        private DER1NRemoveActionType(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DER1NRemoveActionType from(int value){
            switch(value){
                case 0:
                    return NONE;
                case 1:
                    return DELETE;
                case 2:
                    return RESET;
                case 3:
                    return REJECT;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

    /**
     * 实体模型导出类别，数值项，多值模式（数字或处理）
     * <P>
     * <ul>
     * <li>SIMPLE&nbsp;(1)
     * <P>
     * 简单
     * <li>STANDARD&nbsp;(17)
     * <P>
     * 标准（含简单）
     * <li>FULL&nbsp;(145)
     * <P>
     * 完整（含标准）
     * <li>USER&nbsp;(2048)
     * <P>
     * 用户自定义
     * <li>USER2&nbsp;(4096)
     * <P>
     * 用户自定义2
     * <li>USER3&nbsp;(8192)
     * <P>
     * 用户自定义3
     * </ul>     
     */
    public static enum DEExportModelScope{
        SIMPLE(1, "简单")
        ,STANDARD(17, "标准（含简单）")
        ,FULL(145, "完整（含标准）")
        ,USER(2048, "用户自定义")
        ,USER2(4096, "用户自定义2")
        ,USER3(8192, "用户自定义3")
;
           
        public final String text;
        public final int value;
        
        private DEExportModelScope(int value, String text){
            this.value = value;
            this.text = text;
        }

        public static DEExportModelScope from(int value){
            switch(value){
                case 1:
                    return SIMPLE;
                case 17:
                    return STANDARD;
                case 145:
                    return FULL;
                case 2048:
                    return USER;
                case 4096:
                    return USER2;
                case 8192:
                    return USER3;
                default:
                    throw new RuntimeException(String.format("无法识别的值[%1$s]",value));
            }
        }
    }

}