/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.wf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.PSModelException;
import net.ibizsys.model.PSObjectImpl3;
import net.ibizsys.model.wf.IPSWFLink;
import net.ibizsys.model.wf.IPSWFProcess;
import net.ibizsys.model.wf.IPSWFVersion;
import net.ibizsys.model.wf.IPSWorkflow;

public class PSWFVersionImpl
extends PSObjectImpl3
implements IPSWFVersion {
    public static final String ATTR_GETCODENAME = "codeName";
    public static final String ATTR_GETPSWFLINKS = "getPSWFLinks";
    public static final String ATTR_GETPSWFPROCESSES = "getPSWFProcesses";
    public static final String ATTR_GETPSWORKFLOW = "getPSWorkflow";
    public static final String ATTR_GETSTARTPSWFPROCESS = "getStartPSWFProcess";
    public static final String ATTR_GETWFCODENAME = "wFCodeName";
    public static final String ATTR_GETWFMODE = "wFMode";
    public static final String ATTR_GETWFVERSION = "wFVersion";
    public static final String ATTR_HASMOBSTARTVIEW = "hasMobStartView";
    public static final String ATTR_HASSTARTVIEW = "hasStartView";
    public static final String ATTR_ISVALID = "valid";
    private List<IPSWFLink> pswflinks = null;
    private List<IPSWFProcess> pswfprocesses = null;
    private IPSWFProcess startpswfprocess;

    @Override
    public String getCodeName() {
        JsonNode value = this.getObjectNode().get(ATTR_GETCODENAME);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    public List<IPSWFLink> getPSWFLinks() {
        if (this.pswflinks == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETPSWFLINKS);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<IPSWFLink> list = new ArrayList<IPSWFLink>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                IPSWFLink obj = this.getPSModelObject(IPSWFLink.class, (ObjectNode)arrayNode.get(i), ATTR_GETPSWFLINKS);
                if (obj == null) continue;
                list.add(obj);
            }
            this.pswflinks = list;
        }
        return this.pswflinks.size() == 0 ? null : this.pswflinks;
    }

    @Override
    public IPSWFLink getPSWFLink(Object objKey, boolean bTryMode) {
        return this.getPSModelObject(IPSWFLink.class, this.getPSWFLinks(), objKey, bTryMode);
    }

    @Override
    public void setPSWFLinks(List<IPSWFLink> list) {
        this.pswflinks = list;
    }

    @Override
    public List<IPSWFProcess> getPSWFProcesses() {
        if (this.pswfprocesses == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETPSWFPROCESSES);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<IPSWFProcess> list = new ArrayList<IPSWFProcess>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                IPSWFProcess obj = this.getPSModelObject(IPSWFProcess.class, (ObjectNode)arrayNode.get(i), ATTR_GETPSWFPROCESSES);
                if (obj == null) continue;
                list.add(obj);
            }
            this.pswfprocesses = list;
        }
        return this.pswfprocesses.size() == 0 ? null : this.pswfprocesses;
    }

    @Override
    public IPSWFProcess getPSWFProcess(Object objKey, boolean bTryMode) {
        return this.getPSModelObject(IPSWFProcess.class, this.getPSWFProcesses(), objKey, bTryMode);
    }

    @Override
    public void setPSWFProcesses(List<IPSWFProcess> list) {
        this.pswfprocesses = list;
    }

    @Override
    public IPSWorkflow getPSWorkflow() {
        return (IPSWorkflow)((Object)this.getParentPSModelObject());
    }

    @Override
    public IPSWorkflow getPSWorkflowMust() {
        IPSWorkflow value = this.getPSWorkflow();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u5de5\u4f5c\u6d41");
        }
        return value;
    }

    @Override
    public IPSWFProcess getStartPSWFProcess() {
        if (this.startpswfprocess != null) {
            return this.startpswfprocess;
        }
        JsonNode value = this.getObjectNode().get(ATTR_GETSTARTPSWFPROCESS);
        if (value == null) {
            return null;
        }
        this.startpswfprocess = this.getPSWFProcess(value, false);
        return this.startpswfprocess;
    }

    @Override
    public IPSWFProcess getStartPSWFProcessMust() {
        IPSWFProcess value = this.getStartPSWFProcess();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u5f00\u59cb\u5904\u7406");
        }
        return value;
    }

    @Override
    public String getWFCodeName() {
        JsonNode value = this.getObjectNode().get(ATTR_GETWFCODENAME);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    public String getWFMode() {
        JsonNode value = this.getObjectNode().get(ATTR_GETWFMODE);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    public int getWFVersion() {
        JsonNode value = this.getObjectNode().get(ATTR_GETWFVERSION);
        if (value == null) {
            return 0;
        }
        return value.asInt();
    }

    @Override
    public boolean hasMobStartView() {
        JsonNode value = this.getObjectNode().get(ATTR_HASMOBSTARTVIEW);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }

    @Override
    public boolean hasStartView() {
        JsonNode value = this.getObjectNode().get(ATTR_HASSTARTVIEW);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }

    @Override
    public boolean isValid() {
        JsonNode value = this.getObjectNode().get(ATTR_ISVALID);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }
}

