/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util;

import java.util.List;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.logic.IPSDEDEActionLogic;
import net.ibizsys.model.dataentity.logic.IPSDEEndLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkGroupCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkSingleCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.dataentity.logic.IPSDERawCodeLogic;
import net.ibizsys.model.dataentity.logic.IPSDERawSqlAndLoopCallLogic;
import net.ibizsys.model.dataentity.logic.IPSDERawSqlCallLogic;
import net.ibizsys.model.dataentity.logic.IPSDESFPluginLogic;
import net.ibizsys.model.dataentity.logic.IPSDEThrowExceptionLogic;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RuleEngineUtils {
    public static String INDENT = "    ";
    public static final String COND_EQ = "EQ";
    public static final String COND_ABSEQ = "ABSEQ";
    public static final String COND_GT = "GT";
    public static final String COND_GTANDEQ = "GTANDEQ";
    public static final String COND_LT = "LT";
    public static final String COND_LTANDEQ = "LTANDEQ";
    public static final String COND_NOTEQ = "NOTEQ";
    public static final String COND_ISNULL = "ISNULL";
    public static final String COND_ISNOTNULL = "ISNOTNULL";
    public static final String COND_USERLIKE = "USERLIKE";
    public static final String COND_LIKE = "LIKE";
    public static final String COND_LEFTLIKE = "LEFTLIKE";
    public static final String COND_RIGHTLIKE = "RIGHTLIKE";
    public static final String COND_TESTNULL = "TESTNULL";
    public static final String COND_IN = "IN";
    public static final String COND_NOTIN = "NOTIN";
    public static final String COND_OR = "OR";
    public static final String COND_AND = "AND";

    public static String toDELogicDSL(IPSDELogic iPSDELogic) throws Exception {
        String strIndent = "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(strIndent + "params {\n");
        List<IPSDELogicParam> psDELogicParamList = iPSDELogic.getPSDELogicParams();
        if (!ObjectUtils.isEmpty(psDELogicParamList)) {
            for (IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
                RuleEngineUtils.appendPSDELogicParam(stringBuilder, strIndent + INDENT, iPSDELogicParam);
            }
        }
        stringBuilder.append(strIndent + "}\n");
        stringBuilder.append(strIndent + "nodes {\n");
        List<IPSDELogicNode> psDELogicNodeList = iPSDELogic.getPSDELogicNodes();
        if (!ObjectUtils.isEmpty(psDELogicNodeList)) {
            for (IPSDELogicNode iPSDELogicNode : psDELogicNodeList) {
                RuleEngineUtils.appendPSDELogicNode(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            }
        }
        stringBuilder.append(strIndent + "}\n");
        return stringBuilder.toString();
    }

    protected static void appendPSDELogicParam(StringBuilder stringBuilder, String strIndent, IPSDELogicParam iPSDELogicParam) throws Exception {
        if (iPSDELogicParam.isEntityParam()) {
            stringBuilder.append(strIndent + "entity {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicParam.getCodeName()));
            IPSDataEntity paramPSDataEntity = iPSDELogicParam.getParamPSDataEntity();
            if (paramPSDataEntity != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dataEntity '%1$s'\n", PSModelUtils.calcUniqueTag(paramPSDataEntity.getPSSystemModule(), paramPSDataEntity.getCodeName())));
            }
            if (iPSDELogicParam.isDefault()) {
                stringBuilder.append(strIndent + INDENT + String.format("defaultParam true\n", new Object[0]));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u903b\u8f91\u53c2\u6570[%1$s]", iPSDELogicParam.getName()));
    }

    protected static void appendPSDELogicNode(StringBuilder stringBuilder, String strIndent, IPSDELogicNode iPSDELogicNode) throws Exception {
        String strLogicNodeType = iPSDELogicNode.getLogicNodeType();
        if (PSModelEnums.LogicNodeType.BEGIN.value.equals(strLogicNodeType)) {
            stringBuilder.append(strIndent + "begin {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.END.value.equals(strLogicNodeType)) {
            IPSDEEndLogic iPSDEEndLogic = (IPSDEEndLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "end {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            if (StringUtils.hasLength((String)iPSDEEndLogic.getReturnType())) {
                stringBuilder.append(strIndent + INDENT + String.format("returnType '%1$s'\n", iPSDEEndLogic.getReturnType()));
            }
            if (StringUtils.hasLength((String)iPSDEEndLogic.getRawValue())) {
                stringBuilder.append(strIndent + INDENT + String.format("rawValue '%1$s'\n", RuleEngineUtils.groovyString(iPSDEEndLogic.getRawValue())));
                if (iPSDEEndLogic.getRawValueStdDataType() > 0) {
                    stringBuilder.append(strIndent + INDENT + String.format("rawValueStdDataType %1$s\n", iPSDEEndLogic.getRawValueStdDataType()));
                }
            }
            if (iPSDEEndLogic.getReturnParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDEEndLogic.getReturnParam().getCodeName()));
                if (StringUtils.hasLength((String)iPSDEEndLogic.getDstFieldName())) {
                    stringBuilder.append(strIndent + INDENT + String.format("dstField '%1$s'\n", iPSDEEndLogic.getDstFieldName()));
                }
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.PREPAREPARAM.value.equals(strLogicNodeType)) {
            stringBuilder.append(strIndent + "prepareParam {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.RAWSQLCALL.value.equals(strLogicNodeType)) {
            IPSDERawSqlCallLogic iPSDERawSqlCallLogic = (IPSDERawSqlCallLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "rawSql {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            IPSSysDBScheme iPSSysDBScheme = iPSDERawSqlCallLogic.getPSSysDBScheme();
            if (iPSSysDBScheme != null) {
                stringBuilder.append(strIndent + INDENT + String.format("DBSchema '%1$s'\n", PSModelUtils.calcUniqueTag(iPSSysDBScheme.getPSSysModelGroup(), iPSSysDBScheme.getDSLink())));
            }
            if (StringUtils.hasLength((String)iPSDERawSqlCallLogic.getSql())) {
                stringBuilder.append(strIndent + INDENT + String.format("sql '''\n", new Object[0]));
                RuleEngineUtils.append(stringBuilder, iPSDERawSqlCallLogic.getSql(), strIndent + INDENT + INDENT);
                stringBuilder.append(strIndent + INDENT + String.format("\n", new Object[0]));
                stringBuilder.append(strIndent + INDENT + String.format("'''\n", new Object[0]));
            }
            if (iPSDERawSqlCallLogic.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDERawSqlCallLogic.getDstPSDELogicParam().getCodeName()));
                stringBuilder.append(strIndent + INDENT + String.format("fillDstParam %1$s\n", iPSDERawSqlCallLogic.isFillDstLogicParam()));
                stringBuilder.append(strIndent + INDENT + String.format("ignoreResetDstParam %1$s\n", iPSDERawSqlCallLogic.isIgnoreResetDstLogicParam()));
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.RAWSQLANDLOOPCALL.value.equals(strLogicNodeType)) {
            IPSDataEntity dstPSDataEntity;
            IPSDERawSqlAndLoopCallLogic iPSDERawSqlAndLoopCallLogic = (IPSDERawSqlAndLoopCallLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "rawSqlAndLoop {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            IPSSysDBScheme iPSSysDBScheme = iPSDERawSqlAndLoopCallLogic.getPSSysDBScheme();
            if (iPSSysDBScheme != null) {
                stringBuilder.append(strIndent + INDENT + String.format("DBSchema '%1$s'\n", PSModelUtils.calcUniqueTag(iPSSysDBScheme.getPSSysModelGroup(), iPSSysDBScheme.getDSLink())));
            }
            if (StringUtils.hasLength((String)iPSDERawSqlAndLoopCallLogic.getSql())) {
                stringBuilder.append(strIndent + INDENT + String.format("sql '''\n", new Object[0]));
                RuleEngineUtils.append(stringBuilder, iPSDERawSqlAndLoopCallLogic.getSql(), strIndent + INDENT + INDENT);
                stringBuilder.append(strIndent + INDENT + String.format("\n", new Object[0]));
                stringBuilder.append(strIndent + INDENT + String.format("'''\n", new Object[0]));
            }
            if (iPSDERawSqlAndLoopCallLogic.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDERawSqlAndLoopCallLogic.getSrcPSDELogicParam().getCodeName()));
            }
            if ((dstPSDataEntity = iPSDERawSqlAndLoopCallLogic.getDstPSDataEntity()) != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstDataEntity '%1$s'\n", PSModelUtils.calcUniqueTag(dstPSDataEntity.getPSSystemModule(), dstPSDataEntity.getCodeName())));
                if (iPSDERawSqlAndLoopCallLogic.getDstPSDEAction() != null) {
                    stringBuilder.append(strIndent + INDENT + String.format("dstDEAction '%1$s'\n", iPSDERawSqlAndLoopCallLogic.getDstPSDEAction().getCodeName()));
                }
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.DEACTION.value.equals(strLogicNodeType)) {
            IPSDEDEActionLogic iPSDEDEActionLogic = (IPSDEDEActionLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "action {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            IPSDataEntity dstPSDataEntity = iPSDEDEActionLogic.getDstPSDataEntity();
            if (dstPSDataEntity != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstDataEntity '%1$s'\n", PSModelUtils.calcUniqueTag(dstPSDataEntity.getPSSystemModule(), dstPSDataEntity.getCodeName())));
                if (iPSDEDEActionLogic.getDstPSDEAction() != null) {
                    stringBuilder.append(strIndent + INDENT + String.format("dstDEAction '%1$s'\n", iPSDEDEActionLogic.getDstPSDEAction().getCodeName()));
                }
            }
            if (iPSDEDEActionLogic.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDEDEActionLogic.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDEDEActionLogic.getRetPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("retParam '%1$s'\n", iPSDEDEActionLogic.getRetPSDELogicParam().getCodeName()));
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.RAWSFCODE.value.equals(strLogicNodeType)) {
            IPSDERawCodeLogic iPSDERawCodeLogic = (IPSDERawCodeLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "rawCode {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            if (StringUtils.hasLength((String)iPSDERawCodeLogic.getCode())) {
                stringBuilder.append(strIndent + INDENT + String.format("code '''\n", new Object[0]));
                RuleEngineUtils.append(stringBuilder, iPSDERawCodeLogic.getCode(), strIndent + INDENT + INDENT);
                stringBuilder.append(strIndent + INDENT + String.format("\n", new Object[0]));
                stringBuilder.append(strIndent + INDENT + String.format("'''\n", new Object[0]));
            }
            if (iPSDERawCodeLogic.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDERawCodeLogic.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDERawCodeLogic.getRetPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("retParam '%1$s'\n", iPSDERawCodeLogic.getRetPSDELogicParam().getCodeName()));
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.SFPLUGIN.value.equals(strLogicNodeType)) {
            IPSDESFPluginLogic iPSDESFPluginLogic = (IPSDESFPluginLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "plugin {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            if (iPSDESFPluginLogic.getPSSysSFPlugin() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("plugin '%1$s'\n", iPSDESFPluginLogic.getPSSysSFPlugin().getRTObjectName()));
            }
            if (iPSDESFPluginLogic.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDESFPluginLogic.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDESFPluginLogic.getRetPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("retParam '%1$s'\n", iPSDESFPluginLogic.getRetPSDELogicParam().getCodeName()));
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            RuleEngineUtils.appendPSDELogicLinks(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if (PSModelEnums.LogicNodeType.THROWEXCEPTION.value.equals(strLogicNodeType)) {
            IPSDEThrowExceptionLogic iPSDEThrowExceptionLogic = (IPSDEThrowExceptionLogic)iPSDELogicNode;
            stringBuilder.append(strIndent + "error {\n");
            stringBuilder.append(strIndent + INDENT + String.format("name '%1$s'\n", iPSDELogicNode.getCodeName()));
            stringBuilder.append(strIndent + INDENT + String.format("errorCode %1$s\n", iPSDEThrowExceptionLogic.getErrorCode()));
            if (StringUtils.hasLength((String)iPSDEThrowExceptionLogic.getErrorInfo())) {
                stringBuilder.append(strIndent + INDENT + String.format("errorInfo '%1$s'\n", RuleEngineUtils.groovyString(iPSDEThrowExceptionLogic.getErrorInfo())));
            }
            if (StringUtils.hasLength((String)iPSDEThrowExceptionLogic.getExceptionObj())) {
                stringBuilder.append(strIndent + INDENT + String.format("exceptionObj '%1$s'\n", RuleEngineUtils.groovyString(iPSDEThrowExceptionLogic.getExceptionObj())));
            }
            if (iPSDEThrowExceptionLogic.getExceptionParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDEThrowExceptionLogic.getExceptionParam().getCodeName()));
            }
            RuleEngineUtils.appendPSDELogicNodeParams(stringBuilder, strIndent + INDENT, iPSDELogicNode);
            stringBuilder.append(strIndent + "}\n");
            return;
        }
    }

    protected static void appendPSDELogicNodeParams(StringBuilder stringBuilder, String strIndent, IPSDELogicNode iPSDELogicNode) throws Exception {
        List<IPSDELogicNodeParam> psDELogicNodeParamList = iPSDELogicNode.getPSDELogicNodeParams();
        if (ObjectUtils.isEmpty(psDELogicNodeParamList)) {
            return;
        }
        stringBuilder.append(strIndent + "params {\n");
        for (IPSDELogicNodeParam iPSDELogicNodeParam : psDELogicNodeParamList) {
            RuleEngineUtils.appendPSDELogicNodeParam(stringBuilder, strIndent + INDENT, iPSDELogicNodeParam);
        }
        stringBuilder.append(strIndent + "}\n");
    }

    protected static void appendPSDELogicNodeParam(StringBuilder stringBuilder, String strIndent, IPSDELogicNodeParam iPSDELogicNodeParam) throws Exception {
        String strParamAction = iPSDELogicNodeParam.getParamAction();
        if ("SETPARAMVALUE".equals(strParamAction)) {
            stringBuilder.append(strIndent + "setParamValue {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("dstField '%1$s'\n", iPSDELogicNodeParam.getDstFieldName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcValueType())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValueType '%1$s'\n", iPSDELogicNodeParam.getSrcValueType()));
            }
            if (iPSDELogicNodeParam.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicNodeParam.getSrcPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcField '%1$s'\n", iPSDELogicNodeParam.getSrcFieldName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcValue())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValue '%1$s'\n", RuleEngineUtils.groovyString(iPSDELogicNodeParam.getSrcValue())));
                if (iPSDELogicNodeParam.getSrcValueStdDataType() > 0) {
                    stringBuilder.append(strIndent + INDENT + String.format("srcValueStdDataType %1$s\n", iPSDELogicNodeParam.getSrcValueStdDataType()));
                }
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getExpression())) {
                stringBuilder.append(strIndent + INDENT + String.format("expression '''\n", new Object[0]));
                RuleEngineUtils.append(stringBuilder, iPSDELogicNodeParam.getExpression(), strIndent + INDENT + INDENT);
                stringBuilder.append(strIndent + INDENT + String.format("\n", new Object[0]));
                stringBuilder.append(strIndent + INDENT + String.format("'''\n", new Object[0]));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("RESETPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "resetParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("COPYPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "copyParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDELogicNodeParam.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicNodeParam.getSrcPSDELogicParam().getCodeName()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("BINDPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "bindParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDELogicNodeParam.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicNodeParam.getSrcPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcField '%1$s'\n", iPSDELogicNodeParam.getSrcFieldName()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("RENEWPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "renewParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("APPENDPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "appendParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (iPSDELogicNodeParam.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicNodeParam.getSrcPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcField '%1$s'\n", iPSDELogicNodeParam.getSrcFieldName()));
            }
            if (iPSDELogicNodeParam.getSrcIndex() >= 0) {
                stringBuilder.append(strIndent + INDENT + String.format("srcIndex %1$s\n", iPSDELogicNodeParam.getSrcIndex()));
            }
            if (iPSDELogicNodeParam.getSrcSize() >= 0) {
                stringBuilder.append(strIndent + INDENT + String.format("srcSize %1$s\n", iPSDELogicNodeParam.getSrcSize()));
            }
            if (iPSDELogicNodeParam.getDstIndex() >= 0) {
                stringBuilder.append(strIndent + INDENT + String.format("dstIndex %1$s\n", iPSDELogicNodeParam.getDstIndex()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("SORTPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "renewParam {\n");
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("dstField '%1$s'\n", iPSDELogicNodeParam.getDstFieldName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getDstSortDir())) {
                stringBuilder.append(strIndent + INDENT + String.format("dstSortDir '%1$s'\n", iPSDELogicNodeParam.getDstSortDir()));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        if ("SQLPARAM".equals(strParamAction)) {
            stringBuilder.append(strIndent + "param {\n");
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcValueType())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValueType '%1$s'\n", iPSDELogicNodeParam.getSrcValueType()));
            }
            if (iPSDELogicNodeParam.getDstPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicNodeParam.getDstPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("dstField '%1$s'\n", iPSDELogicNodeParam.getDstFieldName()));
            }
            if (iPSDELogicNodeParam.getSrcPSDELogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicNodeParam.getSrcPSDELogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcField '%1$s'\n", iPSDELogicNodeParam.getSrcFieldName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getSrcValue())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValue '%1$s'\n", RuleEngineUtils.groovyString(iPSDELogicNodeParam.getSrcValue())));
                if (iPSDELogicNodeParam.getSrcValueStdDataType() > 0) {
                    stringBuilder.append(strIndent + INDENT + String.format("srcValueStdDataType %1$s\n", iPSDELogicNodeParam.getSrcValueStdDataType()));
                }
            }
            if (StringUtils.hasLength((String)iPSDELogicNodeParam.getExpression())) {
                stringBuilder.append(strIndent + INDENT + String.format("expression '''\n", new Object[0]));
                RuleEngineUtils.append(stringBuilder, iPSDELogicNodeParam.getExpression(), strIndent + INDENT + INDENT);
                stringBuilder.append(strIndent + INDENT + String.format("\n", new Object[0]));
                stringBuilder.append(strIndent + INDENT + String.format("'''\n", new Object[0]));
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u903b\u8f91\u8282\u70b9\u53c2\u6570\u64cd\u4f5c[%1$s]", strParamAction));
    }

    protected static void appendPSDELogicLinks(StringBuilder stringBuilder, String strIndent, IPSDELogicNode iPSDELogicNode) throws Exception {
        List<IPSDELogicLink> psDELogicLinkList = iPSDELogicNode.getPSDELogicLinks();
        if (ObjectUtils.isEmpty(psDELogicLinkList)) {
            return;
        }
        stringBuilder.append(strIndent + "routes {\n");
        stringBuilder.append(strIndent + INDENT + String.format("parallel %1$s\n", iPSDELogicNode.isParallelOutput()));
        for (IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
            RuleEngineUtils.appendPSDELogicLink(stringBuilder, strIndent + INDENT, iPSDELogicLink);
        }
        stringBuilder.append(strIndent + "}\n");
    }

    protected static void appendPSDELogicLink(StringBuilder stringBuilder, String strIndent, IPSDELogicLink iPSDELogicLink) throws Exception {
        if (iPSDELogicLink.isCatchLink()) {
            stringBuilder.append(strIndent + "error {\n");
            stringBuilder.append(strIndent + INDENT + String.format("to '%1$s'\n", iPSDELogicLink.getDstPSDELogicNodeMust().getCodeName()));
            if (iPSDELogicLink.getPSDELogicLinkGroupCond() != null) {
                RuleEngineUtils.appendPSDELogicLinkCond(stringBuilder, strIndent + INDENT, iPSDELogicLink.getPSDELogicLinkGroupCond(), true);
            }
            stringBuilder.append(strIndent + "}\n");
            return;
        }
        stringBuilder.append(strIndent + "route {\n");
        stringBuilder.append(strIndent + INDENT + String.format("to '%1$s'\n", iPSDELogicLink.getDstPSDELogicNodeMust().getCodeName()));
        if (iPSDELogicLink.getPSDELogicLinkGroupCond() != null) {
            RuleEngineUtils.appendPSDELogicLinkCond(stringBuilder, strIndent + INDENT, iPSDELogicLink.getPSDELogicLinkGroupCond(), true);
        }
        stringBuilder.append(strIndent + "}\n");
    }

    protected static void appendPSDELogicLinkCond(StringBuilder stringBuilder, String strIndent, IPSDELogicLinkCond iPSDELogicLinkCond, boolean bFirst) throws Exception {
        if (iPSDELogicLinkCond instanceof IPSDELogicLinkGroupCond) {
            IPSDELogicLinkGroupCond iPSDELogicLinkGroupCond = (IPSDELogicLinkGroupCond)iPSDELogicLinkCond;
            if (bFirst) {
                stringBuilder.append(strIndent + "cond {\n");
            } else if (COND_AND.equals(iPSDELogicLinkGroupCond.getGroupOP())) {
                stringBuilder.append(strIndent + "and {\n");
            } else {
                stringBuilder.append(strIndent + "or {\n");
            }
            if (iPSDELogicLinkGroupCond.isNotMode()) {
                stringBuilder.append(strIndent + INDENT + String.format("not true\n", new Object[0]));
            }
            if (!ObjectUtils.isEmpty(iPSDELogicLinkGroupCond.getPSDELogicLinkConds())) {
                for (IPSDELogicLinkCond item : iPSDELogicLinkGroupCond.getPSDELogicLinkConds()) {
                    RuleEngineUtils.appendPSDELogicLinkCond(stringBuilder, strIndent + INDENT, item, false);
                }
            }
            stringBuilder.append(strIndent + "}\n");
        } else {
            IPSDELogicLinkSingleCond iPSDELogicLinkSingleCond = (IPSDELogicLinkSingleCond)iPSDELogicLinkCond;
            switch (iPSDELogicLinkSingleCond.getCondOP()) {
                case "EQ": {
                    stringBuilder.append(strIndent + "eq {\n");
                    break;
                }
                case "NOTEQ": {
                    stringBuilder.append(strIndent + "ne {\n");
                    break;
                }
                case "GT": {
                    stringBuilder.append(strIndent + "gt {\n");
                    break;
                }
                case "GTANDEQ": {
                    stringBuilder.append(strIndent + "gte {\n");
                    break;
                }
                case "LT": {
                    stringBuilder.append(strIndent + "lt {\n");
                    break;
                }
                case "LTANDEQ": {
                    stringBuilder.append(strIndent + "lte {\n");
                    break;
                }
                case "LIKE": {
                    stringBuilder.append(strIndent + "like {\n");
                    break;
                }
                case "LEFTLIKE": {
                    stringBuilder.append(strIndent + "ll {\n");
                    break;
                }
                case "RIGHTLIKE": {
                    stringBuilder.append(strIndent + "rl {\n");
                    break;
                }
                case "ISNULL": {
                    stringBuilder.append(strIndent + "nvl {\n");
                    break;
                }
                case "ISNOTNULL": {
                    stringBuilder.append(strIndent + "nn {\n");
                    break;
                }
                case "IN": {
                    stringBuilder.append(strIndent + "in {\n");
                    break;
                }
                case "NOTIN": {
                    stringBuilder.append(strIndent + "ni {\n");
                    break;
                }
                default: {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6[%1$s]", iPSDELogicLinkSingleCond.getCondOP()));
                }
            }
            if (iPSDELogicLinkSingleCond.getDstLogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("dstParam '%1$s'\n", iPSDELogicLinkSingleCond.getDstLogicParam().getCodeName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicLinkSingleCond.getDstFieldName())) {
                stringBuilder.append(strIndent + INDENT + String.format("dstField '%1$s'\n", iPSDELogicLinkSingleCond.getDstFieldName()));
            }
            if (StringUtils.hasLength((String)iPSDELogicLinkSingleCond.getParamType())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValueType '%1$s'\n", iPSDELogicLinkSingleCond.getParamType()));
            }
            if (iPSDELogicLinkSingleCond.getSrcLogicParam() != null) {
                stringBuilder.append(strIndent + INDENT + String.format("srcParam '%1$s'\n", iPSDELogicLinkSingleCond.getSrcLogicParam().getCodeName()));
                if (StringUtils.hasLength((String)iPSDELogicLinkSingleCond.getParamValue())) {
                    stringBuilder.append(strIndent + INDENT + String.format("srcField '%1$s'\n", RuleEngineUtils.groovyString(iPSDELogicLinkSingleCond.getParamValue())));
                }
            } else if (StringUtils.hasLength((String)iPSDELogicLinkSingleCond.getParamValue())) {
                stringBuilder.append(strIndent + INDENT + String.format("srcValue '%1$s'\n", RuleEngineUtils.groovyString(iPSDELogicLinkSingleCond.getParamValue())));
            }
            stringBuilder.append(strIndent + "}\n");
        }
    }

    protected static void append(StringBuilder stringBuilder, String strContent, String strIndent) throws Exception {
        String[] lines = strContent.replace("\r\n", "\n").replace("\r", "\n").split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(strIndent);
            if (!StringUtils.hasLength((String)lines[i])) continue;
            stringBuilder.append(lines[i]);
        }
    }

    protected static String groovyString(String strContent) {
        if (StringUtils.hasLength((String)strContent)) {
            return strContent.replace("'", "\\'");
        }
        return "";
    }
}

