/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.util.DataTypeUtils;

public class JsonUtils {
    public static ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static void setMapper(ObjectMapper mapper) {
        MAPPER = mapper != null ? mapper : new ObjectMapper();
    }

    public static ObjectNode createObjectNode() {
        return JsonUtils.getMapper().createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return JsonUtils.getMapper().createArrayNode();
    }

    public static String toString(Object obj) {
        try {
            return JsonUtils.getMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonNode toJsonNode(Object obj) {
        try {
            if (obj instanceof String) {
                return JsonUtils.getMapper().readTree((String)obj);
            }
            return (JsonNode)JsonUtils.getMapper().convertValue(obj, JsonNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ArrayNode toArrayNode(Object obj) {
        try {
            if (obj instanceof String) {
                return (ArrayNode)JsonUtils.getMapper().readTree((String)obj);
            }
            return (ArrayNode)JsonUtils.getMapper().convertValue(obj, ArrayNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ObjectNode toObjectNode(Object obj) {
        try {
            if (obj instanceof String) {
                return (ObjectNode)JsonUtils.getMapper().readTree((String)obj);
            }
            return (ObjectNode)JsonUtils.getMapper().convertValue(obj, ObjectNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map asMap(Object obj) {
        return JsonUtils.as(obj, Map.class);
    }

    public static List asList(Object obj) {
        return JsonUtils.as(obj, List.class);
    }

    public static <T> T as(Object obj, Class<T> cls) {
        try {
            if (obj instanceof String) {
                return (T)JsonUtils.getMapper().readValue((String)obj, cls);
            }
            return (T)JsonUtils.getMapper().convertValue(obj, cls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getField(ObjectNode objectNode, String fieldName, String defaultValue) {
        if (objectNode == null) {
            return defaultValue;
        }
        JsonNode jsonNode = objectNode.get(fieldName);
        if (jsonNode == null) {
            return defaultValue;
        }
        return jsonNode.asText(defaultValue);
    }

    public static boolean getField(ObjectNode objectNode, String fieldName, boolean defaultValue) {
        if (objectNode == null) {
            return defaultValue;
        }
        JsonNode jsonNode = objectNode.get(fieldName);
        if (jsonNode == null) {
            return defaultValue;
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean(defaultValue);
        }
        return DataTypeUtils.getBooleanValue(jsonNode.asText(), defaultValue);
    }

    public static long getField(ObjectNode objectNode, String fieldName, long defaultValue) {
        if (objectNode == null) {
            return defaultValue;
        }
        JsonNode jsonNode = objectNode.get(fieldName);
        if (jsonNode == null) {
            return defaultValue;
        }
        return jsonNode.asLong(defaultValue);
    }

    public static double getField(ObjectNode objectNode, String fieldName, double defaultValue) {
        if (objectNode == null) {
            return defaultValue;
        }
        JsonNode jsonNode = objectNode.get(fieldName);
        if (jsonNode == null) {
            return defaultValue;
        }
        return jsonNode.asDouble(defaultValue);
    }

    public static int getField(ObjectNode objectNode, String fieldName, int defaultValue) {
        if (objectNode == null) {
            return defaultValue;
        }
        JsonNode jsonNode = objectNode.get(fieldName);
        if (jsonNode == null) {
            return defaultValue;
        }
        return jsonNode.asInt(defaultValue);
    }
}

