/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.PSModelException;
import net.ibizsys.model.PSSystemObjectImpl;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.model.security.IPSSysUserRoleData;
import net.ibizsys.model.security.IPSSysUserRoleRes;
import net.ibizsys.model.system.IPSSystemModule;

public class PSSysUserRoleImpl
extends PSSystemObjectImpl
implements IPSSysUserRole {
    public static final String ATTR_GETCODENAME = "codeName";
    public static final String ATTR_GETDEFAULTUSER = "defaultUser";
    public static final String ATTR_GETPSDEDATASET = "getPSDEDataSet";
    public static final String ATTR_GETPSDATAENTITY = "getPSDataEntity";
    public static final String ATTR_GETPSSYSUSERROLEDATAS = "getPSSysUserRoleDatas";
    public static final String ATTR_GETPSSYSUSERROLERESES = "getPSSysUserRoleReses";
    public static final String ATTR_GETPSSYSTEMMODULE = "getPSSystemModule";
    public static final String ATTR_GETROLETAG = "roleTag";
    public static final String ATTR_GETROLETYPE = "roleType";
    public static final String ATTR_GETUNIRESTAGS = "uniResTags";
    public static final String ATTR_ISGLOBALROLE = "globalRole";
    public static final String ATTR_ISSYSTEMRESERVED = "systemReserved";
    private IPSDEDataSet psdedataset;
    private IPSDataEntity psdataentity;
    private List<IPSSysUserRoleData> pssysuserroledatas = null;
    private List<IPSSysUserRoleRes> pssysuserrolereses = null;
    private IPSSystemModule pssystemmodule;
    private List<String> unirestags = null;

    @Override
    public String getCodeName() {
        JsonNode value = this.getObjectNode().get(ATTR_GETCODENAME);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    public String getDefaultUser() {
        JsonNode value = this.getObjectNode().get(ATTR_GETDEFAULTUSER);
        if (value == null) {
            return "NONE";
        }
        return value.asText();
    }

    @Override
    public IPSDEDataSet getPSDEDataSet() {
        if (this.psdedataset != null) {
            return this.psdedataset;
        }
        JsonNode value = this.getObjectNode().get(ATTR_GETPSDEDATASET);
        if (value == null) {
            return null;
        }
        this.psdedataset = this.getPSDataEntityMust().getPSDEDataSet(value, false);
        return this.psdedataset;
    }

    @Override
    public IPSDEDataSet getPSDEDataSetMust() {
        IPSDEDataSet value = this.getPSDEDataSet();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u5b9e\u4f53\u6570\u636e\u96c6\u5bf9\u8c61");
        }
        return value;
    }

    @Override
    public IPSDataEntity getPSDataEntity() {
        if (this.psdataentity != null) {
            return this.psdataentity;
        }
        JsonNode value = this.getObjectNode().get(ATTR_GETPSDATAENTITY);
        if (value == null) {
            return null;
        }
        this.psdataentity = this.getPSModelObject(IPSDataEntity.class, (ObjectNode)value, ATTR_GETPSDATAENTITY);
        return this.psdataentity;
    }

    @Override
    public IPSDataEntity getPSDataEntityMust() {
        IPSDataEntity value = this.getPSDataEntity();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61");
        }
        return value;
    }

    @Override
    public List<IPSSysUserRoleData> getPSSysUserRoleDatas() {
        if (this.pssysuserroledatas == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETPSSYSUSERROLEDATAS);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<IPSSysUserRoleData> list = new ArrayList<IPSSysUserRoleData>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                IPSSysUserRoleData obj = this.getPSModelObject(IPSSysUserRoleData.class, (ObjectNode)arrayNode.get(i), ATTR_GETPSSYSUSERROLEDATAS);
                if (obj == null) continue;
                list.add(obj);
            }
            this.pssysuserroledatas = list;
        }
        return this.pssysuserroledatas.size() == 0 ? null : this.pssysuserroledatas;
    }

    @Override
    public IPSSysUserRoleData getPSSysUserRoleData(Object objKey, boolean bTryMode) {
        return this.getPSModelObject(IPSSysUserRoleData.class, this.getPSSysUserRoleDatas(), objKey, bTryMode);
    }

    @Override
    public void setPSSysUserRoleData(List<IPSSysUserRoleData> list) {
        this.pssysuserroledatas = list;
    }

    @Override
    public List<IPSSysUserRoleRes> getPSSysUserRoleReses() {
        if (this.pssysuserrolereses == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETPSSYSUSERROLERESES);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<IPSSysUserRoleRes> list = new ArrayList<IPSSysUserRoleRes>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                IPSSysUserRoleRes obj = this.getPSModelObject(IPSSysUserRoleRes.class, (ObjectNode)arrayNode.get(i), ATTR_GETPSSYSUSERROLERESES);
                if (obj == null) continue;
                list.add(obj);
            }
            this.pssysuserrolereses = list;
        }
        return this.pssysuserrolereses.size() == 0 ? null : this.pssysuserrolereses;
    }

    @Override
    public IPSSysUserRoleRes getPSSysUserRoleRes(Object objKey, boolean bTryMode) {
        return this.getPSModelObject(IPSSysUserRoleRes.class, this.getPSSysUserRoleReses(), objKey, bTryMode);
    }

    @Override
    public void setPSSysUserRoleRes(List<IPSSysUserRoleRes> list) {
        this.pssysuserrolereses = list;
    }

    @Override
    public IPSSystemModule getPSSystemModule() {
        if (this.pssystemmodule != null) {
            return this.pssystemmodule;
        }
        JsonNode value = this.getObjectNode().get(ATTR_GETPSSYSTEMMODULE);
        if (value == null) {
            return null;
        }
        this.pssystemmodule = this.getPSModelObject(IPSSystemModule.class, (ObjectNode)value, ATTR_GETPSSYSTEMMODULE);
        return this.pssystemmodule;
    }

    @Override
    public IPSSystemModule getPSSystemModuleMust() {
        IPSSystemModule value = this.getPSSystemModule();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u7cfb\u7edf\u6a21\u5757");
        }
        return value;
    }

    @Override
    public String getRoleTag() {
        JsonNode value = this.getObjectNode().get(ATTR_GETROLETAG);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    public String getRoleType() {
        JsonNode value = this.getObjectNode().get(ATTR_GETROLETYPE);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    public List<String> getUniResTags() {
        if (this.unirestags == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETUNIRESTAGS);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                list.add(arrayNode.get(i).asText());
            }
            this.unirestags = list;
        }
        return this.unirestags.size() == 0 ? null : this.unirestags;
    }

    @Override
    public boolean isGlobalRole() {
        JsonNode value = this.getObjectNode().get(ATTR_ISGLOBALROLE);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }

    @Override
    public boolean isSystemReserved() {
        JsonNode value = this.getObjectNode().get(ATTR_ISSYSTEMRESERVED);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }
}

