/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.database;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.PSModelException;
import net.ibizsys.model.database.IPSDEDBTable;
import net.ibizsys.model.database.IPSSysDBTable;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.PSDataEntityObjectImpl;
import net.ibizsys.model.dataentity.defield.IPSDEField;

public class PSDEDBTableImpl
extends PSDataEntityObjectImpl
implements IPSDEDBTable {
    public static final String ATTR_GETALLPSDEFIELDS = "getAllPSDEFields";
    public static final String ATTR_GETCODENAME = "codeName";
    public static final String ATTR_GETDYNAMODELFILEPATH = "dynaModelFilePath";
    public static final String ATTR_GETPSSYSDBTABLE = "getPSSysDBTable";
    public static final String ATTR_GETTABLETYPE = "tableType";
    private List<IPSDEField> allpsdefields = null;
    private IPSSysDBTable pssysdbtable;

    @Override
    public List<IPSDEField> getAllPSDEFields() {
        if (this.allpsdefields == null) {
            JsonNode value = this.getObjectNode().get(ATTR_GETALLPSDEFIELDS);
            if (value == null) {
                return null;
            }
            ArrayNode arrayNode = (ArrayNode)value;
            if (arrayNode.size() == 0) {
                return null;
            }
            ArrayList<IPSDEField> list = new ArrayList<IPSDEField>();
            IPSDataEntity ipsdataentity = this.getParentPSModelObject(IPSDataEntity.class);
            for (int i = 0; i < arrayNode.size(); ++i) {
                list.add(ipsdataentity.getPSDEField((ObjectNode)arrayNode.get(i), false));
            }
            this.allpsdefields = list;
        }
        return this.allpsdefields.size() == 0 ? null : this.allpsdefields;
    }

    @Override
    public IPSDEField getPSDEField(Object objKey, boolean bTryMode) {
        return this.getPSModelObject(IPSDEField.class, this.getAllPSDEFields(), objKey, bTryMode);
    }

    @Override
    public void setPSDEFields(List<IPSDEField> list) {
        this.allpsdefields = list;
    }

    @Override
    public String getCodeName() {
        JsonNode value = this.getObjectNode().get(ATTR_GETCODENAME);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    @Deprecated
    public String getDynaModelFilePath() {
        JsonNode value = this.getObjectNode().get(ATTR_GETDYNAMODELFILEPATH);
        if (value == null) {
            return null;
        }
        return value.asText();
    }

    @Override
    public IPSSysDBTable getPSSysDBTable() {
        if (this.pssysdbtable != null) {
            return this.pssysdbtable;
        }
        JsonNode value = this.getObjectNode().get(ATTR_GETPSSYSDBTABLE);
        if (value == null) {
            return null;
        }
        IPSDataEntity ipsdataentity = this.getParentPSModelObject(IPSDataEntity.class);
        this.pssysdbtable = ipsdataentity.getPSSysDBSchemeMust().getPSSysDBTable(value, false);
        return this.pssysdbtable;
    }

    @Override
    public IPSSysDBTable getPSSysDBTableMust() {
        IPSSysDBTable value = this.getPSSysDBTable();
        if (value == null) {
            throw new PSModelException(this, "\u672a\u6307\u5b9a\u5173\u7cfb\u6570\u636e\u5e93\u8868");
        }
        return value;
    }

    @Override
    public String getTableType() {
        JsonNode value = this.getObjectNode().get(ATTR_GETTABLETYPE);
        if (value == null) {
            return null;
        }
        return value.asText();
    }
}

