/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSDynaInst;
import net.ibizsys.model.IPSDynaInstService;
import net.ibizsys.model.IPSDynaInstServiceRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSModelService;
import net.ibizsys.model.IPSModelServiceProxy;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSDynaInstImpl;
import net.ibizsys.model.PSDynaInstServiceGlobal;
import net.ibizsys.model.PSModelServiceException;
import net.ibizsys.model.PSModelServiceImplBase;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.PSObjectImplBase;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.PSDataEntityImpl;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.PSFormulaDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSInheritDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSLinkDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSOne2ManyDataDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSOne2ManyObjDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSOne2OneDataDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSOne2OneObjDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSPickupDEFieldImpl;
import net.ibizsys.model.dataentity.defield.PSPickupObjectDEFieldImpl;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRCondition;
import net.ibizsys.model.dataentity.der.IPSDER1NDEFieldMap;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERIndexDEFieldMap;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.print.IPSDEPrint;
import net.ibizsys.model.proxy.app.PSApplicationServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.defield.PSDEFieldServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.defield.valuerule.PSDEFVRConditionServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.der.PSDER1NDEFieldMapServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.der.PSDERIndexDEFieldMapServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.der.PSDERServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.ds.PSDEDQConditionServiceProxyImpl;
import net.ibizsys.model.proxy.dataentity.print.PSDEPrintServiceProxyImpl;
import net.ibizsys.model.proxy.res.PSSysContentImplEx;
import net.ibizsys.model.res.IPSSysContentCat;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.res.IPSSysSequence;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.model.valuerule.IPSSysValueRule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSModelServiceImpl
extends PSModelServiceImplBase
implements IPSDynaInstService,
IPSDynaInstServiceRuntime {
    private static final Log log = LogFactory.getLog(PSModelServiceImpl.class);
    private PSApplicationServiceProxyImpl psApplicationServiceProxyImpl = new PSApplicationServiceProxyImpl();
    private PSDEFieldServiceProxyImpl psDEFieldServiceProxyImpl = new PSDEFieldServiceProxyImpl();
    private PSDERIndexDEFieldMapServiceProxyImpl psDERIndexDEFieldMapServiceProxyImpl = new PSDERIndexDEFieldMapServiceProxyImpl();
    private PSDERServiceProxyImpl psDERServiceProxyImpl = new PSDERServiceProxyImpl();
    private PSDEFVRConditionServiceProxyImpl psDEFVRConditionServiceProxyImpl = new PSDEFVRConditionServiceProxyImpl();
    private PSDER1NDEFieldMapServiceProxyImpl psDER1NDEFieldMapServiceProxyImpl = new PSDER1NDEFieldMapServiceProxyImpl();
    private PSDEDQConditionServiceProxyImpl psDEDQConditionServiceProxyImpl = new PSDEDQConditionServiceProxyImpl();
    private PSDEPrintServiceProxyImpl psDEPrintServiceProxyImpl = new PSDEPrintServiceProxyImpl();
    public static final String ONE2MANYDATA = "ONE2MANYDATA";
    public static final String ONE2MANYDATA_MAP = "ONE2MANYDATA_MAP";
    public static final String PICKUPOBJECT = "PICKUPOBJECT";
    public static final String ONE2ONEDATA = "ONE2ONEDATA";
    public static final String ONE2MANYOBJ = "ONE2MANYOBJ";
    public static final String ONE2MANYOBJ_MAP = "ONE2MANYOBJ_MAP";
    public static final String ONE2ONEOBJ = "ONE2ONEOBJ";
    public static final String PICKUP = "PICKUP";
    private String strPSDynaInstId = null;
    private String strPPSDynaInstId = null;
    private int nDynaInstMode = 0;
    private String strDynaInstTag = null;
    private String strDynaInstTag2 = null;
    private List<IPSDynaInst> psDynaInstList = new ArrayList<IPSDynaInst>();
    private Map<String, Map<String, IPSDynaInst>> psDynaInstMapMap = new HashMap<String, Map<String, IPSDynaInst>>();
    private Map<String, IPSDataEntity> psDataEntityMap = new HashMap<String, IPSDataEntity>();
    private IPSSystemService iPSSystemService = null;
    private static final IPSDataEntity NotLoadPSDataEntity = new PSDataEntityImpl();
    private boolean bDataEntityMapCache = false;
    private boolean bModelFromResource = false;
    private String strModelDigest = null;
    private Map<String, Object> psModelObjectCacheMap = new HashMap<String, Object>();

    public void setPSModelFolderPath(String strPSModelFolderPath, boolean bModelFromResource) {
        super.setPSModelFolderPath(strPSModelFolderPath);
        this.bModelFromResource = bModelFromResource;
    }

    @Override
    public void setPSDynaInstId(String strPSDynaInstId) {
        this.strPSDynaInstId = strPSDynaInstId;
    }

    @Override
    public String getPSDynaInstId() {
        return this.strPSDynaInstId;
    }

    public IPSModelObject getPSModelObject(String strPath) {
        return null;
    }

    @Override
    protected void onInit(IPSSystem t, ObjectNode realNode) {
        ArrayNode arrayNode;
        JsonNode value;
        this.psDynaInstList.clear();
        this.psDynaInstMapMap.clear();
        this.psDataEntityMap.clear();
        if (realNode.has("getPSDynaInstId")) {
            this.strPSDynaInstId = realNode.get("getPSDynaInstId").asText();
        }
        if (realNode.has("getPPSDynaInstId")) {
            this.strPPSDynaInstId = realNode.get("getPPSDynaInstId").asText();
        }
        if (realNode.has("dynaInstMode")) {
            this.nDynaInstMode = realNode.get("dynaInstMode").asInt();
        }
        if (realNode.has("dynaInstTag")) {
            this.strDynaInstTag = realNode.get("dynaInstTag").asText();
        }
        if (realNode.has("dynaInstTag2")) {
            this.strDynaInstTag2 = realNode.get("dynaInstTag2").asText();
        }
        if ((value = realNode.get("getPSDynaInsts")) != null && (arrayNode = (ArrayNode)value).size() > 0) {
            for (int i = 0; i < arrayNode.size(); ++i) {
                PSDynaInstImpl psDynaInstImpl = new PSDynaInstImpl();
                psDynaInstImpl.init(this, (IPSModelObjectRuntime)((Object)t), (ObjectNode)arrayNode.get(i));
                this.psDynaInstList.add(psDynaInstImpl);
                if (!StringUtils.hasLength((String)psDynaInstImpl.getInstTag()) || !StringUtils.hasLength((String)psDynaInstImpl.getInstTag2())) continue;
                Map<String, IPSDynaInst> psDynaInstMap = this.psDynaInstMapMap.get(psDynaInstImpl.getInstTag());
                if (psDynaInstMap == null) {
                    psDynaInstMap = new HashMap<String, IPSDynaInst>();
                    this.psDynaInstMapMap.put(psDynaInstImpl.getInstTag(), psDynaInstMap);
                }
                psDynaInstMap.put(psDynaInstImpl.getInstTag2(), psDynaInstImpl);
            }
        }
        t.getAllPSSysModelGroups();
        t.getAllPSSysRefs();
        t.getAllPSSystemModules();
        t.getAllPSSysSFPlugins();
        t.getAllPSSysUtils();
        t.getAllPSSysDataSyncAgents();
        t.getAllPSSysMsgQueues();
        t.getAllPSSysMsgTempls();
        t.getAllPSSysMsgTargets();
        t.getAllPSSysLogics();
        t.getAllPSSysUserRoles();
        t.getAllPSSysUniReses();
        t.getAllPSSysDynaModels();
        t.getAllPSSysDTSQueues();
        t.getAllPSSysResources();
        List<IPSSystemModule> psSystemModuleList = t.getAllPSSystemModules();
        if (psSystemModuleList != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModuleList) {
                if (this.isModelFromHttp()) {
                    JsonNode value2 = iPSSystemModule.getObjectNode().get("getAllPSDataEntities");
                    if (value2 == null) continue;
                    ArrayNode arrayNode2 = (ArrayNode)value2;
                    for (int i = 0; i < arrayNode2.size(); ++i) {
                        ObjectNode dataEntityNode = (ObjectNode)arrayNode2.get(i);
                        JsonNode jsonNode = dataEntityNode.get("path");
                        if (jsonNode == null) continue;
                        this.psDataEntityMap.put(jsonNode.asText(), NotLoadPSDataEntity);
                    }
                    continue;
                }
                List<IPSDataEntity> psDataEntityList = iPSSystemModule.getAllPSDataEntities();
                if (psDataEntityList == null) continue;
                for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                    IPSModelObjectRuntime iPSModelObjectRuntime = (IPSModelObjectRuntime)((Object)iPSDataEntity);
                    if (StringUtils.hasLength((String)iPSModelObjectRuntime.getDynaModelFilePath())) {
                        this.psDataEntityMap.put(iPSModelObjectRuntime.getDynaModelFilePath(), iPSDataEntity);
                    }
                    if (!StringUtils.hasLength((String)iPSDataEntity.getName())) continue;
                    this.psDataEntityMap.put(iPSDataEntity.getName(), iPSDataEntity);
                }
                for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                    iPSDataEntity.getMinorPSDERs();
                    iPSDataEntity.getMajorPSDERs();
                    iPSDataEntity.getAllPSDEActions();
                    iPSDataEntity.getAllPSDELogics();
                }
            }
        }
        this.bDataEntityMapCache = true;
    }

    @Override
    public IPSSystemService getPSSystemService() {
        return this.iPSSystemService;
    }

    @Override
    public void setPSSystemService(IPSSystemService iPSSystemService) {
        this.iPSSystemService = iPSSystemService;
    }

    @Override
    public <T> T getPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode, String strTag) {
        return super.getPSModelObject(parentPSModelObject, cls, objNode, strTag);
    }

    @Override
    protected <T> T createIPSAppView(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        T t = super.createIPSAppView(parentPSModelObject, cls, objNode);
        if (t != null) {
            return t;
        }
        return this.createIPSAppDEView(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEField(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        boolean bLink;
        String strDataType = PSObjectImplBase.getString(objNode, "dataType", null);
        if (StringUtils.hasLength((String)strDataType)) {
            if (strDataType.equals(ONE2ONEDATA)) {
                return (T)new PSOne2OneDataDEFieldImpl();
            }
            if (strDataType.equals(ONE2MANYDATA) || strDataType.equals(ONE2MANYDATA_MAP)) {
                return (T)new PSOne2ManyDataDEFieldImpl();
            }
            if (strDataType.equals(ONE2ONEOBJ)) {
                return (T)new PSOne2OneObjDEFieldImpl();
            }
            if (strDataType.equals(ONE2MANYOBJ) || strDataType.equals(ONE2MANYOBJ_MAP)) {
                return (T)new PSOne2ManyObjDEFieldImpl();
            }
            if (strDataType.equals(PICKUP)) {
                return (T)new PSPickupDEFieldImpl();
            }
            if (strDataType.equals(PICKUPOBJECT)) {
                return (T)new PSPickupObjectDEFieldImpl();
            }
        }
        if (bLink = PSObjectImplBase.getBoolean(objNode, "linkDEField", false)) {
            if (PSObjectImplBase.getBoolean(objNode, "inheritDEField", false)) {
                return (T)new PSInheritDEFieldImpl();
            }
            return (T)new PSLinkDEFieldImpl();
        }
        boolean bFormula = PSObjectImplBase.getBoolean(objNode, "formulaDEField", false);
        if (bFormula) {
            return (T)new PSFormulaDEFieldImpl();
        }
        return super.createIPSDEField(parentPSModelObject, cls, objNode);
    }

    @Override
    protected IPSModelServiceProxy createPSModelServiceProxy(Class<?> cls, Object objPSModel) {
        if (objPSModel != null) {
            if (objPSModel instanceof IPSApplication) {
                return this.psApplicationServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDEField) {
                return this.psDEFieldServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDERBase) {
                return this.psDERServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDERIndexDEFieldMap) {
                return this.psDERIndexDEFieldMapServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDEFVRCondition) {
                return this.psDEFVRConditionServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDER1NDEFieldMap) {
                return this.psDER1NDEFieldMapServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDEDQCondition) {
                return this.psDEDQConditionServiceProxyImpl;
            }
            if (objPSModel instanceof IPSDEPrint) {
                return this.psDEPrintServiceProxyImpl;
            }
        }
        return super.createPSModelServiceProxy(cls, objPSModel);
    }

    @Override
    public IPSDataEntity getPSDataEntity(String strName, boolean bTryMode) {
        IPSDataEntity iPSDataEntity = this.psDataEntityMap.get(strName);
        if (iPSDataEntity != null && iPSDataEntity == NotLoadPSDataEntity && (iPSDataEntity = super.getPSModelObject(null, IPSDataEntity.class, strName)) != null) {
            iPSDataEntity.getMinorPSDERs();
            iPSDataEntity.getMajorPSDERs();
            iPSDataEntity.getAllPSDEActions();
            iPSDataEntity.getAllPSDELogics();
            this.psDataEntityMap.put(strName, iPSDataEntity);
        }
        if (iPSDataEntity == null && !bTryMode) {
            throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u6a21\u578b\uff0c\u6807\u8bc6\u4e3a[%1$s]", strName));
        }
        return iPSDataEntity;
    }

    @Override
    public IPSDataEntity getPSDataEntity(String strName, String strDynaInstTag, String strDynaInstTag2, boolean bTryMode) {
        IPSDynaInstService iPSDynaInstService = this.getChildPSDynaInstService(strDynaInstTag, strDynaInstTag2);
        IPSDataEntity iPSDataEntity = iPSDynaInstService.getPSDataEntity(strName, true);
        if (iPSDataEntity != null) {
            return iPSDataEntity;
        }
        return this.getPSDataEntity(strName, bTryMode);
    }

    @Override
    public <T> T getPSModelObject(Class<T> cls, String strModelPath) {
        return this.getPSModelObject(null, cls, strModelPath);
    }

    @Override
    protected <T> T getPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, String strModelPath) {
        if (this.bDataEntityMapCache && IPSDataEntity.class.isAssignableFrom(cls)) {
            IPSDynaInstService parentPSDynaInstService;
            IPSDataEntity iPSDataEntity = this.getPSDataEntity(strModelPath, true);
            if (iPSDataEntity != null) {
                return (T)iPSDataEntity;
            }
            if (this.getDynaInstMode() == 2 && (parentPSDynaInstService = this.getParentPSDynaInstService()) != null && (iPSDataEntity = parentPSDynaInstService.getPSDataEntity(strModelPath, false)) != null) {
                return (T)iPSDataEntity;
            }
            return null;
        }
        if (this.getDynaInstMode() == 2) {
            IPSModelObject iPSModelObject = this.getCachePSModelObject(strModelPath);
            if (iPSModelObject != null) {
                return (T)iPSModelObject;
            }
            if (!this.containsObjectNode(strModelPath)) {
                IPSDynaInstService parentPSDynaInstService = this.getParentPSDynaInstService();
                if (parentPSDynaInstService != null) {
                    iPSModelObject = (IPSModelObject)parentPSDynaInstService.getPSModelObject(cls, strModelPath);
                    this.setCachePSModelObject(strModelPath, iPSModelObject);
                    return (T)iPSModelObject;
                }
                throw new PSModelServiceException(this, "\u65e0\u6cd5\u83b7\u53d6\u526f\u672c\u5b9e\u4f8b\u7684\u9ed8\u8ba4\u5b9e\u4f8b");
            }
        } else if (this.getPSSystemService() != null) {
            IPSModelObject iPSModelObject = this.getCachePSModelObject(strModelPath);
            if (iPSModelObject != null) {
                return (T)iPSModelObject;
            }
            if (!this.containsObjectNode(strModelPath)) {
                iPSModelObject = (IPSModelObject)this.getPSSystemService().getPSModelObject(cls, strModelPath);
                this.setCachePSModelObject(strModelPath, iPSModelObject);
                return (T)iPSModelObject;
            }
        }
        return super.getPSModelObject(parentPSModelObject, cls, strModelPath);
    }

    @Override
    public IPSDynaInstService getChildPSDynaInstService(String strDynaInstTag, String strDynaInstTag2) {
        Map<String, IPSDynaInst> psDynaInstMap = this.psDynaInstMapMap.get(strDynaInstTag);
        IPSDynaInst iPSDynaInst = null;
        if (psDynaInstMap != null) {
            iPSDynaInst = psDynaInstMap.get(strDynaInstTag2);
        }
        if (iPSDynaInst == null) {
            throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b50\u52a8\u6001\u5b9e\u4f8b[%1$s][%2$s]", strDynaInstTag, strDynaInstTag2));
        }
        try {
            return PSDynaInstServiceGlobal.getInstance().getPSDynaInstService(iPSDynaInst.getId(), false);
        }
        catch (Exception ex) {
            throw new PSModelServiceException((IPSModelService)this, String.format("\u83b7\u53d6\u5b50\u5b9e\u4f8b[%1$s]\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38, %2$s", iPSDynaInst.getId(), ex.getMessage()), ex);
        }
    }

    @Override
    public IPSDynaInstService getParentPSDynaInstService() {
        if (StringUtils.hasLength((String)this.getPPSDynaInstId())) {
            try {
                return PSDynaInstServiceGlobal.getInstance().getPSDynaInstService(this.getPPSDynaInstId(), false);
            }
            catch (Exception ex) {
                throw new PSModelServiceException((IPSModelService)this, String.format("\u83b7\u53d6\u7236\u5b9e\u4f8b[%1$s]\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38, %2$s", this.getPPSDynaInstId(), ex.getMessage()), ex);
            }
        }
        return null;
    }

    @Override
    public String getPPSDynaInstId() {
        return this.strPPSDynaInstId;
    }

    @Override
    public int getDynaInstMode() {
        return this.nDynaInstMode;
    }

    @Override
    public String getDynaInstTag() {
        return this.strDynaInstTag;
    }

    @Override
    public String getDynaInstTag2() {
        return this.strDynaInstTag2;
    }

    @Override
    public IPSDynaInst getChildPSDynaInst(String strDynaInstTag, String strDynaInstTag2) {
        Map<String, IPSDynaInst> psDynaInstMap = this.psDynaInstMapMap.get(strDynaInstTag);
        IPSDynaInst iPSDynaInst = null;
        if (psDynaInstMap != null) {
            iPSDynaInst = psDynaInstMap.get(strDynaInstTag2);
        }
        return iPSDynaInst;
    }

    @Override
    public String getInstallTag() {
        if (this.isModelFromHttp()) {
            String strFullModelPath = this.getPSModelFolderPath() + "/upload.log";
            try {
                int length;
                URL remoteUrl = new URL(strFullModelPath);
                InputStream inputStream = remoteUrl.openStream();
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                String str = result.toString();
                return str;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public <T> T createAndInitPSModelObject(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        T t = this.createPSModelObject(parentPSModelObject, cls, objNode);
        ((IPSModelObjectRuntime)t).init(this.getPSModelService(t.getClass(), t), parentPSModelObject, objNode);
        return t;
    }

    @Override
    public IPSCodeList getPSCodeList(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSCodeList.class.getSimpleName(), strTag).toLowerCase();
        IPSCodeList iPSCodeList = (IPSCodeList)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSCodeList == null && (iPSCodeList = this.doGetPSCodeList(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSCodeList);
        }
        return iPSCodeList;
    }

    protected IPSCodeList doGetPSCodeList(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSCodeList> list = this.getPSSystem().getAllPSCodeLists();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSCodeList iPSCodeList : list) {
                if (!(bUniqueTag ? iPSCodeList.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSCodeList.getPSSystemModule(), iPSCodeList.getCodeName())) : strTag.equalsIgnoreCase(iPSCodeList.getCodeName()))) continue;
                return iPSCodeList;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u4ee3\u7801\u8868\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysSequence getPSSysSequence(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysSequence.class.getSimpleName(), strTag).toLowerCase();
        IPSSysSequence iPSSysSequence = (IPSSysSequence)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysSequence == null && (iPSSysSequence = this.doGetPSSysSequence(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysSequence);
        }
        return iPSSysSequence;
    }

    protected IPSSysSequence doGetPSSysSequence(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysSequence> list = this.getPSSystem().getAllPSSysSequences();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysSequence iPSSysSequence : list) {
                if (!(bUniqueTag ? iPSSysSequence.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysSequence.getPSSystemModule(), iPSSysSequence.getCodeName())) : strTag.equalsIgnoreCase(iPSSysSequence.getCodeName()))) continue;
                return iPSSysSequence;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u503c\u5e8f\u5217\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysTranslator getPSSysTranslator(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysTranslator.class.getSimpleName(), strTag).toLowerCase();
        IPSSysTranslator iPSSysTranslator = (IPSSysTranslator)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysTranslator == null && (iPSSysTranslator = this.doGetPSSysTranslator(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysTranslator);
        }
        return iPSSysTranslator;
    }

    protected IPSSysTranslator doGetPSSysTranslator(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysTranslator> list = this.getPSSystem().getAllPSSysTranslators();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysTranslator iPSSysTranslator : list) {
                if (!(bUniqueTag ? iPSSysTranslator.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysTranslator.getPSSystemModule(), iPSSysTranslator.getCodeName())) : strTag.equalsIgnoreCase(iPSSysTranslator.getCodeName()))) continue;
                return iPSSysTranslator;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u503c\u8f6c\u6362\u5668\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysServiceAPI getPSSysServiceAPI(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysServiceAPI.class.getSimpleName(), strTag).toLowerCase();
        IPSSysServiceAPI iPSSysServiceAPI = (IPSSysServiceAPI)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysServiceAPI == null && (iPSSysServiceAPI = this.doGetPSSysServiceAPI(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysServiceAPI);
        }
        return iPSSysServiceAPI;
    }

    protected IPSSysServiceAPI doGetPSSysServiceAPI(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysServiceAPI> list = this.getPSSystem().getAllPSSysServiceAPIs();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysServiceAPI iPSSysSysServiceAPI : list) {
                if (!(bUniqueTag ? iPSSysSysServiceAPI.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysSysServiceAPI.getPSSystemModule(), iPSSysSysServiceAPI.getCodeName())) : strTag.equalsIgnoreCase(iPSSysSysServiceAPI.getCodeName()))) continue;
                return iPSSysSysServiceAPI;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSubSysServiceAPI getPSSysSubSysServiceAPI(String strTag, boolean bTryMode) {
        return this.getPSSubSysServiceAPI(strTag, bTryMode);
    }

    @Override
    public IPSSubSysServiceAPI getPSSubSysServiceAPI(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSubSysServiceAPI.class.getSimpleName(), strTag).toLowerCase();
        IPSSubSysServiceAPI iPSSubSysServiceAPI = (IPSSubSysServiceAPI)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSubSysServiceAPI == null && (iPSSubSysServiceAPI = this.doGetPSSubSysServiceAPI(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSubSysServiceAPI);
        }
        return iPSSubSysServiceAPI;
    }

    protected IPSSubSysServiceAPI doGetPSSubSysServiceAPI(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSubSysServiceAPI> list = this.getPSSystem().getAllPSSubSysServiceAPIs();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSubSysServiceAPI iPSSysSubSysServiceAPI : list) {
                if (!(bUniqueTag ? iPSSysSubSysServiceAPI.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysSubSysServiceAPI.getPSSystemModule(), iPSSysSubSysServiceAPI.getCodeName())) : strTag.equalsIgnoreCase(iPSSysSubSysServiceAPI.getCodeName()))) continue;
                return iPSSysSubSysServiceAPI;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysContentCat getPSSysContentCat(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysContentCat.class.getSimpleName(), strTag).toLowerCase();
        IPSSysContentCat iPSSysContentCat = (IPSSysContentCat)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysContentCat == null && (iPSSysContentCat = this.doGetPSSysContentCat(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysContentCat);
        }
        return iPSSysContentCat;
    }

    protected IPSSysContentCat doGetPSSysContentCat(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysContentCat> list = this.getPSSystem().getAllPSSysContentCats();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysContentCat iPSSysSysContentCat : list) {
                if (!(bUniqueTag ? iPSSysSysContentCat.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysSysContentCat.getPSSystemModule(), iPSSysSysContentCat.getCodeName())) : strTag.equalsIgnoreCase(iPSSysSysContentCat.getCodeName()))) continue;
                return iPSSysSysContentCat;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u9884\u7f6e\u5185\u5bb9\u5206\u7c7b\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysValueRule getPSSysValueRule(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysValueRule.class.getSimpleName(), strTag).toLowerCase();
        IPSSysValueRule iPSSysValueRule = (IPSSysValueRule)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysValueRule == null && (iPSSysValueRule = this.doGetPSSysValueRule(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysValueRule);
        }
        return iPSSysValueRule;
    }

    protected IPSSysValueRule doGetPSSysValueRule(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysValueRule> list = this.getPSSystem().getAllPSSysValueRules();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysValueRule iPSSysSysValueRule : list) {
                if (!(bUniqueTag ? iPSSysSysValueRule.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysSysValueRule.getPSSystemModule(), iPSSysSysValueRule.getCodeName())) : strTag.equalsIgnoreCase(iPSSysSysValueRule.getCodeName()))) continue;
                return iPSSysSysValueRule;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u503c\u89c4\u5219\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysLogic getPSSysLogic(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysLogic.class.getSimpleName(), strTag).toLowerCase();
        IPSSysLogic iPSSysLogic = (IPSSysLogic)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysLogic == null && (iPSSysLogic = this.doGetPSSysLogic(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysLogic);
        }
        return iPSSysLogic;
    }

    protected IPSSysLogic doGetPSSysLogic(String strTag, boolean bTryMode) {
        List<IPSSysLogic> list = this.getPSSystem().getAllPSSysLogics();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysLogic iPSSysLogic : list) {
                if (!(bUniqueTag ? iPSSysLogic.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysLogic.getPSSystemModule(), iPSSysLogic.getCodeName())) : strTag.equalsIgnoreCase(iPSSysLogic.getCodeName()))) continue;
                return iPSSysLogic;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u9884\u7f6e\u903b\u8f91\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public IPSSysDataSyncAgent getPSSysDataSyncAgent(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        String strUniqueKey = String.format("%1$s:%2$s", IPSSysDataSyncAgent.class.getSimpleName(), strTag).toLowerCase();
        IPSSysDataSyncAgent iPSSysDataSyncAgent = (IPSSysDataSyncAgent)this.psModelObjectCacheMap.get(strUniqueKey);
        if (iPSSysDataSyncAgent == null && (iPSSysDataSyncAgent = this.doGetPSSysDataSyncAgent(strTag, bTryMode)) != null) {
            this.psModelObjectCacheMap.put(strUniqueKey, iPSSysDataSyncAgent);
        }
        return iPSSysDataSyncAgent;
    }

    protected IPSSysDataSyncAgent doGetPSSysDataSyncAgent(String strTag, boolean bTryMode) {
        Assert.hasLength((String)strTag, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        List<IPSSysDataSyncAgent> list = this.getPSSystem().getAllPSSysDataSyncAgents();
        if (list != null) {
            boolean bUniqueTag = strTag.indexOf(".") != -1;
            for (IPSSysDataSyncAgent iPSSysDataSyncAgent : list) {
                if (!(bUniqueTag ? iPSSysDataSyncAgent.getPSSystemModule() != null && strTag.equalsIgnoreCase(PSModelUtils.calcUniqueTag(iPSSysDataSyncAgent.getPSSystemModule(), iPSSysDataSyncAgent.getCodeName())) : strTag.equalsIgnoreCase(iPSSysDataSyncAgent.getCodeName()))) continue;
                return iPSSysDataSyncAgent;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    protected boolean isModelFromResource() {
        return this.bModelFromResource;
    }

    @Override
    protected boolean isModelFromHttp() {
        if (this.isModelFromResource()) {
            return false;
        }
        return super.isModelFromHttp();
    }

    @Override
    protected ObjectNode getObjectNode(String strPath) throws Exception {
        if (this.isModelFromResource()) {
            String strFullModelPath = this.getPSModelFolderPath() + "/" + strPath.replace("\\", "/");
            return (ObjectNode)MAPPER.readTree(this.getClass().getResourceAsStream(strFullModelPath));
        }
        return super.getObjectNode(strPath);
    }

    @Override
    public String getRawContent(String strPath, boolean bTryMode) throws Exception {
        if (this.isModelFromResource()) {
            String strFullModelPath = this.getPSModelFolderPath() + "/" + strPath.replace("\\", "/");
            InputStream is = this.getClass().getResourceAsStream(strFullModelPath);
            if (is != null) {
                return IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            if (bTryMode) {
                return null;
            }
            throw new Exception(String.format("\u6307\u5b9a\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728", strFullModelPath));
        }
        return super.getRawContent(strPath, bTryMode);
    }

    @Override
    public String getModelDigest() {
        return this.strModelDigest;
    }

    public void setModelDigest(String strModelDigest) {
        this.strModelDigest = strModelDigest;
    }

    @Override
    protected <T> T createIPSSysContent(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (parentPSModelObject instanceof IPSSysContentCat) {
            return (T)new PSSysContentImplEx();
        }
        return super.createIPSSysContent(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSAppDEMethodDTOField(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSAppDEMethodDTOField(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEMethodDTOField(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEMethodDTOField(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEFilterDTOField(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEFilterDTOField(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEActionInputDTOField(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEActionInputDTOField(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEMethodDTO(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEMethodDTO(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSAppDEMethodDTO(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSAppDEMethodDTO(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEFilterDTO(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEFilterDTO(parentPSModelObject, cls, objNode);
    }

    @Override
    protected <T> T createIPSDEActionInputDTO(IPSModelObjectRuntime parentPSModelObject, Class<T> cls, ObjectNode objNode) {
        if (!objNode.has("codeName")) {
            objNode.set("codeName", objNode.get("name"));
        }
        return super.createIPSDEActionInputDTO(parentPSModelObject, cls, objNode);
    }

    @Override
    public IPSModelObject getPSModelObject(String strPSModelType, String strPSModelId, boolean bTryMode) {
        List<IPSDataEntity> psDataEntityList;
        Assert.hasLength((String)strPSModelType, (String)"\u4f20\u5165\u6a21\u578b\u7c7b\u578b\u65e0\u6548");
        if ("PSSYSTEM".equals(strPSModelType)) {
            return this.getPSSystem();
        }
        Assert.hasLength((String)strPSModelId, (String)"\u4f20\u5165\u6a21\u578b\u6807\u8bb0\u65e0\u6548");
        if ("PSDATAENTITY".equals(strPSModelType) && !ObjectUtils.isEmpty(psDataEntityList = this.getPSSystem().getAllPSDataEntities())) {
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                String strModelTag = PSModelUtils.calcUniqueTag(iPSDataEntity.getPSSystemModule(), iPSDataEntity.getCodeName());
                if (!strPSModelId.equalsIgnoreCase(strModelTag)) continue;
                return iPSDataEntity;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new PSModelServiceException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b\u5bf9\u8c61[%1$s][%2$s]", strPSModelType, strPSModelId));
    }
}

