package net.ibizsys.model.dataentity.logic;



/**
 * 实体主状态逻辑节点模型对象接口
 * <P>
 * 子接口扩展识别值 {@link #getLogicNodeType}
 *
 */
public interface IPSDEMSLogicNode extends net.ibizsys.model.dataentity.logic.IPSDELogicNodeBase{

	
	
	/**
	 * 获取左侧位置
	 * @return
	 */
	int getLeftPos();
	
	
	/**
	 * 获取逻辑节点连出连接集合
	 * @return
	 */
	java.util.List<net.ibizsys.model.dataentity.logic.IPSDEMSLogicLink> getPSDEMSLogicLinks();
	
	/**
	 * 获取逻辑节点连出连接集合的指定项
	 * @param objKey 项标识
	 * @param bTryMode 是否为尝试获取
	 * @return 返回指定项，尝试模式下不存在返回null，否则抛出异常
	 */
	net.ibizsys.model.dataentity.logic.IPSDEMSLogicLink getPSDEMSLogicLink(Object objKey, boolean bTryMode);
	
	/**
	 * 设置逻辑节点连出连接集合
	 * @param list 逻辑节点连出连接集合
	 */
	void setPSDEMSLogicLinks(java.util.List<net.ibizsys.model.dataentity.logic.IPSDEMSLogicLink> list);
	
	
	/**
	 * 获取实体主状态
	 * @return
	 */
	net.ibizsys.model.dataentity.mainstate.IPSDEMainState getPSDEMainState();


	/**
	 * 获取实体主状态，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.mainstate.IPSDEMainState getPSDEMainStateMust();
	
	
	/**
	 * 获取上方位置
	 * @return
	 */
	int getTopPos();
}