package net.ibizsys.model.dataentity.dr;



/**
 * 实体关系数据项模型对象接口，标准模型{@link net.ibizsys.centralstudio.dto.PSDEDRItemDTO}运行时对象
 *
 */
public interface IPSDEDRItem extends net.ibizsys.model.IPSModelObject
		,net.ibizsys.model.control.IPSNavigateParamContainer{

	
	
	/**
	 * 获取标题语言资源
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getCapPSLanguageRes();


	/**
	 * 获取标题语言资源，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getCapPSLanguageResMust();
	
	
	/**
	 * 获取代码标识
	 * @return
	 */
	java.lang.String getCodeName();
	
	
	/**
	 * 获取计数项标识
	 * @return
	 */
	java.lang.String getCounterId();
	
	
	/**
	 * 获取启用模式
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DEDRDetailEnableMode}
	 * @return
	 */
	java.lang.String getEnableMode();
	
	
	/**
	 * 获取关系项类型
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DEDRItemType}
	 * @return
	 */
	java.lang.String getItemType();
	
	
	/**
	 * 获取项图标资源对象
	 * @return
	 */
	net.ibizsys.model.res.IPSSysImage getPSSysImage();


	/**
	 * 获取项图标资源对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSSysImage getPSSysImageMust();
	
	
	/**
	 * 获取视图父数据对象
	 * @return
	 */
	com.fasterxml.jackson.databind.node.ObjectNode getParentDataJO();
	
	
	/**
	 * 获取判断输出实体操作标识
	 * @return
	 */
	net.ibizsys.model.dataentity.priv.IPSDEOPPriv getTestPSDEOPPriv();


	/**
	 * 获取判断输出实体操作标识，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.priv.IPSDEOPPriv getTestPSDEOPPrivMust();
	
	
	/**
	 * 获取视图参数对象
	 * @return
	 */
	com.fasterxml.jackson.databind.node.ObjectNode getViewParamJO();
}