package net.ibizsys.model.dataentity.der;



/**
 * 实体自定义关系模型对象接口
 * <P>
 * 扩展父接口类型[DERCUSTOM]
 *
 */
public interface IPSDERCustom extends net.ibizsys.model.dataentity.der.IPSDERBase{

	
	
	/**
	 * 获取自定义导出次序
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_EXPORTSCOPE}
	 * @return
	 */
	int getCustomExportOrder();
	
	
	/**
	 * 获取自定义导出次序2
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_EXPORTSCOPE2}
	 * @return
	 */
	int getCustomExportOrder2();
	
	
	/**
	 * 获取关系子类型
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_DERSUBTYPE}
	 * @return
	 */
	java.lang.String getDERSubType();
	
	
	/**
	 * 获取主从关系类型
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_MASTERRS}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DER1NMasterRS}
	 * @return
	 */
	int getMasterRS();
	
	
	/**
	 * 获取嵌套成员数据集对象
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_MINORPSDEDSID}
	 * @return
	 */
	net.ibizsys.model.dataentity.ds.IPSDEDataSet getNestedPSDEDataSet();


	/**
	 * 获取嵌套成员数据集对象，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.ds.IPSDEDataSet getNestedPSDEDataSetMust();
	
	
	/**
	 * 获取一对多关系数据属性
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getOne2XDataPSDEField();


	/**
	 * 获取一对多关系数据属性，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getOne2XDataPSDEFieldMust();
	
	
	/**
	 * 获取关系属性名称
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_DERFIELDNAME}
	 * @return
	 */
	java.lang.String getPickupDEFName();
	
	
	/**
	 * 获取关系属性，使用关系属性{@link #getPickupDEFName}在从实体中尝试获取
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getPickupPSDEField();


	/**
	 * 获取关系属性，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getPickupPSDEFieldMust();
	
	
	/**
	 * 获取关系主信息属性
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getPickupTextPSDEField();


	/**
	 * 获取关系主信息属性，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.dataentity.defield.IPSDEField getPickupTextPSDEFieldMust();
	
	
	/**
	 * 获取删除拒绝消息语言标记
	 * @return
	 */
	java.lang.String getRRMLanResTag();
	
	
	/**
	 * 获取删除拒绝消息语言资源
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_REMOVEREJECTPSLANRESID}
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getRRMPSLanguageRes();


	/**
	 * 获取删除拒绝消息语言资源，不存在时抛出异常
	 * @return
	 */
	net.ibizsys.model.res.IPSLanguageRes getRRMPSLanguageResMust();
	
	
	/**
	 * 获取删除方式
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_REMOVEACTIONTYPE}
	 * <P>
	 * 返回值参考 {@link net.ibizsys.model.PSModelEnums.DER1NRemoveActionType}
	 * @return
	 */
	int getRemoveActionType();
	
	
	/**
	 * 获取删除次序
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_REMOVEORDER}
	 * @return
	 */
	int getRemoveOrder();
	
	
	/**
	 * 获取删除拒绝消息
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_REMOVEREJECTMSG}
	 * @return
	 */
	java.lang.String getRemoveRejectMsg();
	
	
	/**
	 * 获取关系识别值
	 * <P>
	 * 相关模型：{@link net.ibizsys.centralstudio.dto.PSDERDTO#FIELD_INDEXVALUE}
	 * @return
	 */
	java.lang.String getTypeValue();
}