package net.ibizsys.model;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;

public class PSModelUtils {

	
	
	/**
	 * 计算模型唯一标记
	 * @param strTag
	 * @return
	 */
	public static String calcUniqueTag(String strTag) {
		if(!StringUtils.hasLength(strTag)) {
			return null;
		}
		return strTag.toLowerCase();
	}
	
	
	/**
	 * 计算模型唯一标记
	 * @param iPSSystemModule
	 * @param strTag
	 * @return
	 */
	public static String calcUniqueTag(IPSSystemModule iPSSystemModule, String strTag) {
		if(!StringUtils.hasLength(strTag)) {
			return null;
		}
		if(iPSSystemModule == null) {
			return strTag.toLowerCase();
		}
		
		if(iPSSystemModule.getPSSysModelGroup() != null) {
			return String.format("%1$s.%2$s.%3$s", iPSSystemModule.getPSSysModelGroup().getCodeName(), iPSSystemModule.getCodeName(), strTag).toLowerCase();
		}
		else {
			return String.format("%1$s.%2$s", iPSSystemModule.getCodeName(), strTag).toLowerCase();
		}
	}
	
	
	/**
	 * 计算模型唯一标记
	 * @param iPSSysModelGroup
	 * @param strTag
	 * @return
	 */
	public static String calcUniqueTag(IPSSysModelGroup iPSSysModelGroup, String strTag) {
		if(!StringUtils.hasLength(strTag)) {
			return null;
		}
		if(iPSSysModelGroup == null) {
			return strTag.toLowerCase();
		}
		
		return String.format("%1$s.%2$s", iPSSysModelGroup.getCodeName(), strTag).toLowerCase();
	}
	
	
	/**
	 * 计算模型唯一标记
	 * @param iPSModelObject
	 * @return
	 */
	public static String calcUniqueTag(IPSModelObject iPSModelObject) {
		return calcUniqueTag(iPSModelObject, false);
	}
	
	/**
	 * 计算模型唯一标记
	 * @param iPSModelObject
	 * @param bSimple
	 * @return
	 */
	public static String calcUniqueTag(IPSModelObject iPSModelObject, boolean bSimple) {
		String strId = iPSModelObject.getId();
		if(!StringUtils.hasLength(strId)) {
			return null;
		}
		
		int nPos = strId.indexOf(".json");
		if(nPos != -1 && nPos == (strId.length() - 5)) {
			strId = strId.substring(0, strId.length() - 5);
		}
		
		if(!StringUtils.hasLength(strId)) {
			return null;
		}
		
		
		String[] ids = strId.split("[/]");
		if(ids.length > 1) {
			if(bSimple) {
				return ids[ids.length -1].toLowerCase();
			}
			StringBuilder sb = new StringBuilder();
			for(int i = 1;i<ids.length;i++) {
				if(i%2 == 0) {
					sb.append(".");
				}
				else {
					sb.append(ids[i]);
				}
			}
			return sb.toString().toLowerCase();
		}
		else {
			return strId.toLowerCase();
		}
	}
	

}
