/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.dataentity.logic;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.dataentity.logic.PSDELogicParamListTranspiler;
import net.ibizsys.psmodel.core.domain.PSDELogicParam;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDELogicParamListTranspilerEx
extends PSDELogicParamListTranspiler {
    public static final int PARAMTYPE_COMMON = 0;
    public static final int PARAMTYPE_GLOBAL = 1;
    public static final int PARAMTYPE_ENV = 2;
    public static final int PARAMTYPE_LAST = 3;
    public static final int PARAMTYPE_LASTRETURN = 4;
    public static final int PARAMTYPE_FILTER = 5;
    public static final int PARAMTYPE_ENTITYLIST = 6;
    public static final int PARAMTYPE_ENTITYPAGE = 7;
    public static final int PARAMTYPE_FILE = 8;
    public static final int PARAMTYPE_FILELIST = 9;
    public static final int PARAMTYPE_SIMPLE = 10;
    public static final int PARAMTYPE_SIMPLELIST = 11;
    public static final int PARAMTYPE_ENTITYMAP = 12;
    public static final int PARAMTYPE_APPCONTEXT = 24;
    public static final int PARAMTYPE_APPGLOBAL = 27;
    public static final int PARAMTYPE_WEBCONTEXT = 31;
    public static final int PARAMTYPE_WEBRESPONSE = 32;

    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        IPSDELogicParam iPSDELogicParam = (IPSDELogicParam)iPSModelObject;
        PSDELogicParam psDELogicParam = (PSDELogicParam)domain;
        psDELogicParam.setGlobalParam(Integer.valueOf(this.getParamType(iPSDELogicParam)));
    }

    protected int getParamType(IPSDELogicParam iPSDELogicParam) {
        if (iPSDELogicParam.isSessionParam()) {
            return 1;
        }
        if (iPSDELogicParam.isEnvParam()) {
            return 2;
        }
        if (iPSDELogicParam.isLastParam()) {
            return 3;
        }
        if (iPSDELogicParam.isLastReturnParam()) {
            return 4;
        }
        if (iPSDELogicParam.isFilterParam()) {
            return 5;
        }
        if (iPSDELogicParam.isEntityListParam()) {
            return 6;
        }
        if (iPSDELogicParam.isEntityPageParam()) {
            return 7;
        }
        if (iPSDELogicParam.isFileParam()) {
            return 8;
        }
        if (iPSDELogicParam.isFileListParam()) {
            return 9;
        }
        if (iPSDELogicParam.isSimpleParam()) {
            return 10;
        }
        if (iPSDELogicParam.isSimpleListParam()) {
            return 11;
        }
        if (iPSDELogicParam.isEntityMapParam()) {
            return 12;
        }
        if (iPSDELogicParam.isAppContextParam()) {
            return 24;
        }
        if (iPSDELogicParam.isAppGlobalParam()) {
            return 27;
        }
        if (iPSDELogicParam.isWebContextParam()) {
            return 31;
        }
        if (iPSDELogicParam.isWebResponseParam()) {
            return 32;
        }
        return 0;
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        PSDELogicParam psDELogicParam = (PSDELogicParam)domain;
        objectNode.put("codeName", psDELogicParam.getName());
        switch (DataTypeUtils.getIntegerValue((Object)psDELogicParam.getGlobalParam(), (Integer)0)) {
            case 1: {
                objectNode.put("sessionParam", true);
                break;
            }
            case 2: {
                objectNode.put("envParam", true);
                break;
            }
            case 3: {
                objectNode.put("lastParam", true);
                break;
            }
            case 4: {
                objectNode.put("lastReturnParam", true);
                break;
            }
            case 5: {
                objectNode.put("filterParam", true);
                break;
            }
            case 6: {
                objectNode.put("entityListParam", true);
                break;
            }
            case 7: {
                objectNode.put("entityPageParam", true);
                break;
            }
            case 8: {
                objectNode.put("fileParam", true);
                break;
            }
            case 9: {
                objectNode.put("fileListParam", true);
                break;
            }
            case 10: {
                objectNode.put("simpleParam", true);
                break;
            }
            case 11: {
                objectNode.put("simpleListParam", true);
                break;
            }
            case 12: {
                objectNode.put("entityMapParam", true);
                break;
            }
            case 24: {
                objectNode.put("appContextParam", true);
                break;
            }
            case 27: {
                objectNode.put("appGlobalParam", true);
                break;
            }
            case 31: {
                objectNode.put("webContextParam", true);
                break;
            }
            case 32: {
                objectNode.put("webResponseParam", true);
            }
        }
    }
}

