/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.dataentity.logic;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.dataentity.logic.PSDELogicLinkListTranspiler;
import net.ibizsys.psmodel.core.domain.PSDELLCond;
import net.ibizsys.psmodel.core.domain.PSDELogicLink;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import org.springframework.util.ObjectUtils;

public class PSDELogicLinkListTranspilerEx
extends PSDELogicLinkListTranspiler {
    public static final int LINKMODE_COMMON = 0;
    public static final int LINKMODE_DEFAULT = 1;
    public static final int LINKMODE_CATCH = 9;
    public static final int LINKMODE_SUBCALL = 10;

    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        IPSDELogicLink iPSDELogicLink = (IPSDELogicLink)iPSModelObject;
        PSDELogicLink psDELogicLink = (PSDELogicLink)domain;
        if (iPSDELogicLink.isSubCallLink()) {
            psDELogicLink.setDefaultLink(Integer.valueOf(10));
        } else if (iPSDELogicLink.isCatchLink()) {
            psDELogicLink.setDefaultLink(Integer.valueOf(9));
        } else if (iPSDELogicLink.isDefaultLink()) {
            psDELogicLink.setDefaultLink(Integer.valueOf(1));
        } else {
            psDELogicLink.setDefaultLink(Integer.valueOf(0));
        }
        if (bFullMode && iPSDELogicLink.getPSDELogicLinkGroupCond() != null && iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds() != null) {
            int nOrder = 100;
            iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLinkCond.class, false).decompile(iPSModelTranspileContext, iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds(), psDELogicLink.getPSDELLCondsIf(), bFullMode);
            for (PSDELLCond child : psDELogicLink.getPSDELLCondsIf()) {
                child.setPSDELogicLinkId(psDELogicLink.getId());
                child.setPSDELogicLinkName(psDELogicLink.getName());
                child.setOrderValue(Integer.valueOf(nOrder));
                nOrder += 100;
            }
        }
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        PSDELogicLink psDELogicLink = (PSDELogicLink)domain;
        int nDefaultLink = DataTypeUtils.getIntegerValue((Object)psDELogicLink.getDefaultLink(), (Integer)0);
        switch (nDefaultLink) {
            case 1: {
                objectNode.put("defaultLink", true);
                break;
            }
            case 10: {
                objectNode.put("subCallLink", true);
                break;
            }
            case 9: {
                objectNode.put("catchLink", true);
            }
        }
        if (!ObjectUtils.isEmpty((Object)psDELogicLink.getPSDELLConds())) {
            PSDELLCond groupPSDELLCond = new PSDELLCond();
            groupPSDELLCond.logictype(PSModelEnums.LogicLinkCondType.GROUP);
            groupPSDELLCond.groupop(PSModelEnums.GroupCondOP.AND);
            groupPSDELLCond.getPSDELLCondsIf().addAll(psDELogicLink.getPSDELLConds());
            ObjectNode groupCondNode = objectNode.putObject("getPSDELogicLinkGroupCond");
            iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLinkCond.class, false).compile(iPSModelTranspileContext, (IPSModel)groupPSDELLCond, groupCondNode);
        }
    }
}

