package net.ibizsys.model.util.transpiler.res;



import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.util.IPSModel;
import static net.ibizsys.model.res.PSSysSFPluginImpl.*;



public class PSSysSFPluginTranspiler extends net.ibizsys.model.util.transpiler.PSModelTranspilerBase{

	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		if(!(iPSModelObject instanceof net.ibizsys.model.res.PSSysSFPluginImpl)){
			super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
			return;
			
		}
		net.ibizsys.model.res.PSSysSFPluginImpl realPSModelObject = (net.ibizsys.model.res.PSSysSFPluginImpl)iPSModelObject;
		this.setDomainValue(iPSModelTranspileContext, domain, "psmoduleid", realPSModelObject.getPSSystemModule(), realPSModelObject, "getPSSystemModule");
		this.setDomainValue(iPSModelTranspileContext, domain, "pluginparams", realPSModelObject.getPluginParams(), realPSModelObject, "getPluginParams");
		this.setDomainValue(iPSModelTranspileContext, domain, "plugintype", realPSModelObject.getPluginType(), realPSModelObject, "getPluginType");
		this.setDomainValue(iPSModelTranspileContext, domain, "rtobjectname", realPSModelObject.getRTObjectName(), realPSModelObject, "getRTObjectName");
		this.setDomainValue(iPSModelTranspileContext, domain, "rtobjectrepo", realPSModelObject.getRTObjectRepo(), realPSModelObject, "getRTObjectRepo");
		this.setDomainValue(iPSModelTranspileContext, domain, "rtobjectmode", realPSModelObject.getRTObjectSource(), realPSModelObject, "getRTObjectSource");
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
	}
	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPSSYSTEMMODULE, domain, "psmoduleid", net.ibizsys.model.system.IPSSystemModule.class, false);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPLUGINPARAMS, domain, "pluginparams", com.fasterxml.jackson.databind.node.ObjectNode.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPLUGINTYPE, domain, "plugintype", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETRTOBJECTNAME, domain, "rtobjectname", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETRTOBJECTREPO, domain, "rtobjectrepo", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETRTOBJECTSOURCE, domain, "rtobjectmode", int.class, new String[]{"0"});
		super.onCompile(iPSModelTranspileContext, domain, objectNode);
	}
}