package net.ibizsys.model.util.transpiler.extend.control.form;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums.FormDetailMDCtrlType;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.IPSEditor;
import net.ibizsys.model.control.IPSNavigateContext;
import net.ibizsys.model.control.IPSNavigateParam;
import net.ibizsys.model.control.IPSRawItemBase;
import net.ibizsys.model.control.form.IPSDEFDCatGroupLogic;
import net.ibizsys.model.control.form.IPSDEFDLogic;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDEFormDRUIPart;
import net.ibizsys.model.control.form.IPSDEFormDetail;
import net.ibizsys.model.control.form.IPSDEFormGroupBase;
import net.ibizsys.model.control.form.IPSDEFormItem;
import net.ibizsys.model.control.form.IPSDEFormItemEx;
import net.ibizsys.model.control.form.IPSDEFormMDCtrl;
import net.ibizsys.model.control.form.IPSDEFormRawItem;
import net.ibizsys.model.control.form.IPSDEFormTabPage;
import net.ibizsys.model.control.form.IPSDEFormTabPanel;
import net.ibizsys.model.control.form.IPSDESearchFormItem;
import net.ibizsys.model.control.form.PSDEEditFormItemExImpl;
import net.ibizsys.model.control.form.PSDEFDCatGroupLogicImpl;
import net.ibizsys.model.control.form.PSDEFormDRUIPartImpl;
import net.ibizsys.model.control.form.PSDEFormDetailImpl;
import net.ibizsys.model.control.form.PSDEFormImpl;
import net.ibizsys.model.control.form.PSDEFormItemImpl;
import net.ibizsys.model.control.form.PSDEFormPageImpl;
import net.ibizsys.model.control.form.PSDEFormRawItemImpl;
import net.ibizsys.model.control.form.PSDEFormTabPageImpl;
import net.ibizsys.model.control.form.PSDEFormTabPanelImpl;
import net.ibizsys.model.control.layout.IPSLayout;
import net.ibizsys.model.control.layout.IPSLayoutPos;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dr.IPSDEDRItem;
import net.ibizsys.model.dataentity.dr.IPSDEDataRelation;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSDEFDLogic;
import net.ibizsys.psmodel.core.domain.PSDEFormDetail;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.PSModelEnums.FormDetailLogicType;
import net.ibizsys.psmodel.core.util.PSModelEnums.GroupCondOP;

public class PSDEFormDetailListTranspilerEx extends net.ibizsys.model.util.transpiler.control.form.PSDEFormDetailListTranspiler {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDEFormDetailListTranspilerEx.class);
	
	/**
	 * 编译参数：表单分页部件支持数据关系界面组。反编译时会将由数据关系界面组展开的分页异常
	 */
	public final static String PARAM_PSDEFORMTABPANEL_ENABLEDEDR = "PARAM.IPSDEFormTabPanel.EnableDEDR";
	
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {

		IPSDEFormDetail iPSDEFormDetail = (IPSDEFormDetail) iPSModelObject;
		PSDEFormDetail psDEFormDetail = (PSDEFormDetail) domain;

		if (iPSDEFormDetail.getPSLayout() != null) {
			iPSModelTranspileContext.getPSModelListTranspiler(IPSLayout.class, false).decompile(iPSModelTranspileContext, iPSDEFormDetail.getPSLayout(), psDEFormDetail, bFullMode);
			psDEFormDetail.setLayoutMode(iPSDEFormDetail.getPSLayout().getLayout());
		}

		if (iPSDEFormDetail.getPSLayoutPos() != null) {
			iPSModelTranspileContext.getPSModelListTranspiler(IPSLayoutPos.class, false).decompile(iPSModelTranspileContext, iPSDEFormDetail.getPSLayoutPos(), psDEFormDetail, bFullMode);
		}

		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);

		if (iPSDEFormDetail instanceof IPSDEFormItem) {
			IPSDEFormItem iPSDEFormItem = (IPSDEFormItem) iPSDEFormDetail;
			if (iPSDEFormItem.getPSEditor() != null) {
				iPSModelTranspileContext.getPSModelListTranspiler(IPSEditor.class, false).decompile(iPSModelTranspileContext, iPSDEFormItem.getPSEditor(), psDEFormDetail, bFullMode);
			}

			if (iPSDEFormItem instanceof IPSDESearchFormItem) {
				IPSDESearchFormItem iPSDESearchFormItem = (IPSDESearchFormItem) iPSDEFormItem;
				// 设置搜索模式
				String strPSDEFieldId = psDEFormDetail.getPSDEFId();
				if (StringUtils.hasLength(strPSDEFieldId)) {

				}
			}
		}

		if (iPSDEFormDetail instanceof IPSDEFormDRUIPart) {
			IPSDEFormDRUIPart iPSDEFormDRUIPart = (IPSDEFormDRUIPart) iPSDEFormDetail;
			if(StringUtils.hasLength(iPSDEFormDRUIPart.getDRItemTag())) {
				IPSDEForm iPSDEForm = iPSDEFormDRUIPart.getParentPSModelObject(IPSDEForm.class, false);
				IPSDEDRItem iPSDEDRItem = null;
				//获取应用实体
				if(iPSDEForm.getPSAppDataEntity() != null && iPSDEForm.getPSAppDataEntity().getPSDataEntity() != null) {
					List<IPSDEDRItem> list = iPSDEForm.getPSAppDataEntity().getPSDataEntity().getAllPSDEDRItems();
					if(!ObjectUtils.isEmpty(list)) {
						for(IPSDEDRItem item : list) {
							if(iPSDEFormDRUIPart.getDRItemTag().equalsIgnoreCase(item.getCodeName())) {
								iPSDEDRItem = item;
								break;
							}
						}
					}
				}
				if(iPSDEDRItem != null) {
					psDEFormDetail.setPSDEDRItemId(iPSModelTranspileContext.getPSModelUniqueTag(iPSDEDRItem));
					psDEFormDetail.setPSDEDRItemName(iPSDEDRItem.getName());
				}
				else {
					throw new Exception(String.format("无法获取关系界面项[%1$s]对应的模型对象", iPSDEFormDRUIPart.getDRItemTag()));
				}
			}
		}
		
		if (iPSDEFormDetail instanceof IPSDEFormRawItem) {
			IPSDEFormRawItem iPSDEFormRawItem = (IPSDEFormRawItem) iPSDEFormDetail;
			if (iPSDEFormRawItem.getPSRawItem() != null) {
				iPSModelTranspileContext.getPSModelListTranspiler(IPSRawItemBase.class, false).decompile(iPSModelTranspileContext, iPSDEFormRawItem.getPSRawItem(), psDEFormDetail, bFullMode);
			}
		}
		
		
		if (iPSDEFormDetail instanceof IPSDEFormTabPanel) {
			IPSDEFormTabPanel iPSDEFormTabPanel = (IPSDEFormTabPanel) iPSDEFormDetail;
			if(StringUtils.hasLength(iPSDEFormTabPanel.getDataRelationTag())) {
				//设置数据关系分组
				IPSDEForm iPSDEForm = iPSDEFormTabPanel.getParentPSModelObject(IPSDEForm.class, false);
				IPSDEDataRelation iPSDEDataRelation = null;
				//获取应用实体
				if(iPSDEForm.getPSAppDataEntity() != null && iPSDEForm.getPSAppDataEntity().getPSDataEntity() != null) {
					List<IPSDEDataRelation> list = iPSDEForm.getPSAppDataEntity().getPSDataEntity().getAllPSDEDataRelations();
					if(!ObjectUtils.isEmpty(list)) {
						for(IPSDEDataRelation item : list) {
							if(iPSDEFormTabPanel.getDataRelationTag().equalsIgnoreCase(item.getCodeName())) {
								iPSDEDataRelation = item;
								break;
							}
						}
					}
				}
				
				if(iPSDEDataRelation != null) {
					psDEFormDetail.setPSDEDRId(iPSModelTranspileContext.getPSModelUniqueTag(iPSDEDataRelation));
					psDEFormDetail.setPSDEDRName(iPSDEDataRelation.getName());
				}
				else {
					throw new Exception(String.format("无法获取关系界面分组[%1$s]对应的模型对象", iPSDEFormTabPanel.getDataRelationTag()));
				}
			}
			
		}
		
		if (iPSDEFormDetail instanceof IPSDEFormTabPage) {
			IPSDEFormTabPage iPSDEFormTabPage = (IPSDEFormTabPage) iPSDEFormDetail;
			if(StringUtils.hasLength(iPSDEFormTabPage.getDRItemTag())) {
				
			}
		}
		
		
		if (iPSDEFormDetail instanceof IPSDEFormMDCtrl) {
			IPSDEFormMDCtrl iPSDEFormMDCtrl = (IPSDEFormMDCtrl) iPSDEFormDetail;
			if(iPSDEFormMDCtrl.getContentPSControl()!=null) {
				IPSControl contentPSControl = iPSDEFormMDCtrl.getContentPSControl();
				String strPSCtrlId = iPSModelTranspileContext.getPSModelUniqueTag(contentPSControl);
				String strPSCtrlName = iPSDEFormMDCtrl.getContentPSControl().getLogicName();
				if(contentPSControl.getPSAppDataEntity() != null && contentPSControl.getPSAppDataEntity().getPSDataEntity() != null) {
					psDEFormDetail.setRefPSDEId(iPSModelTranspileContext.getPSModelUniqueTag(contentPSControl.getPSAppDataEntity().getPSDataEntity()));
					psDEFormDetail.setRefPSDEName(contentPSControl.getPSAppDataEntity().getPSDataEntity().getName());
				}
				if(FormDetailMDCtrlType.DATAVIEW.value.equals(iPSDEFormMDCtrl.getContentType())) {
					psDEFormDetail.setMDPSDEDataViewId(strPSCtrlId);
					psDEFormDetail.setMDPSDEDataViewName(strPSCtrlName);
					psDEFormDetail.setContentType(FormDetailMDCtrlType.DATAVIEW.value);
				}
				else
					if(FormDetailMDCtrlType.LIST.value.equals(iPSDEFormMDCtrl.getContentType())) {
						psDEFormDetail.setMDPSDEListId(strPSCtrlId);
						psDEFormDetail.setMDPSDEListName(strPSCtrlName);
						psDEFormDetail.setContentType(FormDetailMDCtrlType.LIST.value);
					}
					else
						if(FormDetailMDCtrlType.GRID.value.equals(iPSDEFormMDCtrl.getContentType())) {
							psDEFormDetail.setMDPSDEGridId(strPSCtrlId);
							psDEFormDetail.setMDPSDEGridName(strPSCtrlName);
							psDEFormDetail.setContentType(FormDetailMDCtrlType.GRID.value);
						}
						else
							if(FormDetailMDCtrlType.FORM.value.equals(iPSDEFormMDCtrl.getContentType())) {
								psDEFormDetail.setMDPSDEFormId(strPSCtrlId);
								psDEFormDetail.setMDPSDEFormName(strPSCtrlName);
								psDEFormDetail.setContentType(FormDetailMDCtrlType.FORM.value);
							}
							
				
			}
		}

		if (bFullMode) {

			if (iPSDEFormDetail.getPSDEFDGroupLogics() != null) {
				for (IPSDEFDCatGroupLogic iPSDEFDGroupLogic : iPSDEFormDetail.getPSDEFDGroupLogics()) {
					if (iPSDEFDGroupLogic.getPSDEFDLogics() != null) {
						int nOrder = 100;
						List<PSDEFDLogic> psDEFDLogicList = new ArrayList<PSDEFDLogic>();
						iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFDLogic.class, false).decompile(iPSModelTranspileContext, iPSDEFDGroupLogic.getPSDEFDLogics(), psDEFDLogicList, bFullMode);
						for (PSDEFDLogic child : psDEFDLogicList) {
							child.setLogicCat(iPSDEFDGroupLogic.getLogicCat());
							child.setPSDEFormDetailId(psDEFormDetail.getId());
							child.setPSDEFormDetailName(psDEFormDetail.getName());
							child.setOrderValue(nOrder);
							nOrder += 100;
						}
						psDEFormDetail.getPSDEFDLogicsIf().addAll(psDEFDLogicList);
					}
				}
			}

			if (iPSDEFormDetail instanceof IPSDEFormTabPanel) {
				IPSDEFormTabPanel iPSDEFormTabPanel = (IPSDEFormTabPanel) iPSDEFormDetail;
				if (iPSDEFormTabPanel.getPSDEFormTabPages() != null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormTabPanel.getPSDEFormTabPages(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for (PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
					
					if(iPSModelTranspileContext.getParam(PARAM_PSDEFORMTABPANEL_ENABLEDEDR, false)) {
						//移除来自关系界面组的分页
						List<PSDEFormDetail> details = new ArrayList<PSDEFormDetail>();
						details.addAll(psDEFormDetail.getPSDEFormDetailsIf());
						psDEFormDetail.getPSDEFormDetailsIf().clear();
						for (PSDEFormDetail child : details) {
							String dritemtag = (String)child.get("dritemtag");
							if(StringUtils.hasLength(dritemtag)) {
								continue;
							}
							psDEFormDetail.getPSDEFormDetailsIf().add(child);
						}
						
					}
				}
				return;
			}
			if (iPSDEFormDetail instanceof IPSDEFormGroupBase) {
				IPSDEFormGroupBase iPSDEFormGroupBase = (IPSDEFormGroupBase) iPSDEFormDetail;
				if (iPSDEFormGroupBase.getPSDEFormDetails() != null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormGroupBase.getPSDEFormDetails(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for (PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
			if (iPSDEFormDetail instanceof IPSDEFormItemEx) {
				IPSDEFormItemEx iPSDEFormItemEx = (IPSDEFormItemEx) iPSDEFormDetail;
				if (iPSDEFormItemEx.getPSDEFormItems() != null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormItemEx.getPSDEFormItems(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for (PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
			
			if (iPSDEFormDetail instanceof IPSDEFormMDCtrl) {
				IPSDEFormMDCtrl iPSDEFormMDCtrl = (IPSDEFormMDCtrl) iPSDEFormDetail;
				if(FormDetailMDCtrlType.REPEATER.value.equals(iPSDEFormMDCtrl.getContentType())
						&& iPSDEFormMDCtrl.getPSDEFormDetails()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormMDCtrl.getPSDEFormDetails(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for (PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
		}
	}

	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		super.onCompile(iPSModelTranspileContext, domain, objectNode);

		// 去除ID
		objectNode.remove(PSDEFormImpl.ATTR_GETID);

		// 判断类型，输出布局信息
		PSDEFormDetail psDEFormDetail = (PSDEFormDetail) domain;

		String strLayoutPos = (String) psDEFormDetail.get("layoutpos");
		String strLayoutMode = psDEFormDetail.getLayoutMode();
		// if(!StringUtils.hasLength(strLayoutMode)) {
		// strLayoutMode = strPLayoutMode;
		// }
		if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
			for (PSDEFormDetail item : psDEFormDetail.getPSDEFormDetails()) {
				if (!StringUtils.hasLength(item.getLayoutMode())) {
					item.setLayoutMode(strLayoutMode);
				}
				item.set("layoutpos", strLayoutMode);
			}
		}

		if (StringUtils.hasLength(strLayoutPos)) {
			switch (psDEFormDetail.getDetailType()) {
			case "BUTTON":
			case "DRUIPART":
			case "FORMITEM":
			case "FORMITEMEX":
			case "GROUPPANEL":
			case "IFRAME":
			case "MDCTRL":
			case "RAWITEM":
			case "TABPANEL":
			case "USERCONTROL":

				ObjectNode layoutPosNode = objectNode.putObject(PSDEFormDetailImpl.ATTR_GETPSLAYOUTPOS);
				psDEFormDetail.set("layout", strLayoutPos);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSLayoutPos.class, false).compile(iPSModelTranspileContext, psDEFormDetail, layoutPosNode);
			default:
				break;
			}
		}

		if (StringUtils.hasLength(strLayoutMode)) {
			switch (psDEFormDetail.getDetailType()) {
			case "FORMPAGE":
			case "GROUPPANEL":
			case "TABPAGE":
				ObjectNode layoutNode = objectNode.putObject(PSDEFormDetailImpl.ATTR_GETPSLAYOUT);
				psDEFormDetail.set("layout", strLayoutMode);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSLayout.class, false).compile(iPSModelTranspileContext, psDEFormDetail, layoutNode);
			default:
				break;
			}
		}

		switch (psDEFormDetail.getDetailType()) {
		case "BUTTON":
			// ArrayNode arrayNode =
			// objectNode.putArray(PSDEFormButtonImpl.attr_getpsde);
			// iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class,
			// false).compile(iPSModelTranspileContext,
			// psDEFormDetail.getPSDEFormDetails(), arrayNode);
			break;
		case "DRUIPART":{
			if(StringUtils.hasLength(psDEFormDetail.getPSDEDRItemId())) {
				//获取对应的实体
			//	iPSModelTranspileContext.getPSSystemService().getPSDataEntity(strName, bTryMode);
				String strParentId = PSModelUtils.getParentId(psDEFormDetail.getPSDEDRItemId());
				if(StringUtils.hasLength(strParentId)) {
					IPSDataEntity iPSDataEntity = null;
					if(!ObjectUtils.isEmpty(iPSModelTranspileContext.getPSSystem().getAllPSDataEntities())) {
						for(IPSDataEntity item : iPSModelTranspileContext.getPSSystem().getAllPSDataEntities()) {
							
							String strPSDEId = PSModelUtils.calcFullUniqueTag2(item);
							if(!strParentId.equalsIgnoreCase(strPSDEId)) {
								continue;
							}

							iPSDataEntity = item;
							break;
						}
					}
					
					if(iPSDataEntity == null) {
						throw new Exception(String.format("无法获取指定实体对象[%1$s]", strParentId));
					}
					
					
					IPSDEDRItem iPSDEDRItem = null;
					if(!ObjectUtils.isEmpty(iPSDataEntity.getAllPSDEDRItems())) {
						String strCodeName = PSModelUtils.getSimpleId(psDEFormDetail.getPSDEDRItemId());
						for(IPSDEDRItem item : iPSDataEntity.getAllPSDEDRItems()) {
							if(!strCodeName.equalsIgnoreCase(item.getCodeName())) {
								continue;
							}

							iPSDEDRItem = item;
							break;
						}
					}
					
					if(iPSDEDRItem == null) {
						throw new Exception(String.format("无法获取指定实体关系界面[%1$s]", psDEFormDetail.getPSDEDRItemId()));
					}
					
					if(iPSDEDRItem.getPSNavigateContexts()!=null) {
						ArrayNode arrayNode = objectNode.putArray(PSDEFormDRUIPartImpl.ATTR_GETPSNAVIGATECONTEXTS);
						for(IPSNavigateContext iPSNavigateContext : iPSDEDRItem.getPSNavigateContexts()) {
							arrayNode.add(iPSNavigateContext.getObjectNode().deepCopy());
						}
					}
					
					if(iPSDEDRItem.getPSNavigateParams()!=null) {
						ArrayNode arrayNode = objectNode.putArray(PSDEFormDRUIPartImpl.ATTR_GETPSNAVIGATEPARAMS);
						for(IPSNavigateParam iPSNavigateParam : iPSDEDRItem.getPSNavigateParams()) {
							arrayNode.add(iPSNavigateParam.getObjectNode().deepCopy());
						}
					}
					
					if(iPSDEDRItem.getParentDataJO()!=null) {
						objectNode.set(PSDEFormDRUIPartImpl.ATTR_GETPARENTDATAJO, iPSDEDRItem.getParentDataJO().deepCopy());
					}
					
					//计算视图
					//if(StringUtils.hasLength(iPSDEDRItem.get))
				}
			}
		}
			break;
		case "FORMITEM": {
			ObjectNode editorNode = objectNode.putObject(PSDEFormItemImpl.ATTR_GETPSEDITOR);
			iPSModelTranspileContext.getPSModelListTranspiler(IPSEditor.class, false).compile(iPSModelTranspileContext, psDEFormDetail, editorNode);

			// objectNode.get(index)
			// 缺 默认 labelWidth，ItemHeight，ItemWidth
		}
			break;
		case "FORMITEMEX": {
			ObjectNode editorNode = objectNode.putObject(PSDEFormItemImpl.ATTR_GETPSEDITOR);
			iPSModelTranspileContext.getPSModelListTranspiler(IPSEditor.class, false).compile(iPSModelTranspileContext, psDEFormDetail, editorNode);

			if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
				ArrayNode arrayNode = objectNode.putArray(PSDEEditFormItemExImpl.ATTR_GETPSDEFORMITEMS);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).compile(iPSModelTranspileContext, psDEFormDetail.getPSDEFormDetails(), arrayNode);
			}

		}
			break;
		case "FORMPAGE": {
			objectNode.put(PSDEFormPageImpl.ATTR_ISSHOWCAPTION, true);

			if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
				ArrayNode arrayNode = objectNode.putArray(PSDEFormPageImpl.ATTR_GETPSDEFORMDETAILS);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).compile(iPSModelTranspileContext, psDEFormDetail.getPSDEFormDetails(), arrayNode);
			}
		}
			break;
		case "GROUPPANEL": {
			if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
				ArrayNode arrayNode = objectNode.putArray(PSDEFormPageImpl.ATTR_GETPSDEFORMDETAILS);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).compile(iPSModelTranspileContext, psDEFormDetail.getPSDEFormDetails(), arrayNode);
			}
		}
			break;
		case "IFRAME":
			break;
		case "MDCTRL":
			break;
		case "RAWITEM":
			{
				ObjectNode rawItemNode = objectNode.putObject(PSDEFormRawItemImpl.ATTR_GETPSRAWITEM);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSRawItemBase.class, false).compile(iPSModelTranspileContext, psDEFormDetail, rawItemNode);
			}
			break;
		case "TABPAGE": {
			if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
				ArrayNode arrayNode = objectNode.putArray(PSDEFormTabPageImpl.ATTR_GETPSDEFORMDETAILS);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).compile(iPSModelTranspileContext, psDEFormDetail.getPSDEFormDetails(), arrayNode);
			}
		}
			break;
		case "TABPANEL": {
			if (StringUtils.hasLength(psDEFormDetail.getPSDEDRId())) {
				objectNode.put(PSDEFormTabPanelImpl.ATTR_GETDATARELATIONTAG, getSimpleId(psDEFormDetail.getPSDEDRId()));
			}
			if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFormDetails())) {
				ArrayNode arrayNode = objectNode.putArray(PSDEFormTabPanelImpl.ATTR_GETPSDEFORMTABPAGES);
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).compile(iPSModelTranspileContext, psDEFormDetail.getPSDEFormDetails(), arrayNode);
			}
		}
			break;
		case "USERCONTROL":
			break;
		default:
			break;
		}

		if (!ObjectUtils.isEmpty(psDEFormDetail.getPSDEFDLogics())) {

			Map<String, PSDEFDLogic> catPSDEFDLogicMap = new LinkedHashMap<String, PSDEFDLogic>();
			for(PSDEFDLogic psDEFDLogic : psDEFormDetail.getPSDEFDLogics()) {
				if(!StringUtils.hasLength(psDEFDLogic.getLogicCat())){
					continue;
				}
				
				PSDEFDLogic groupPSDEFDLogic = catPSDEFDLogicMap.get(psDEFDLogic.getLogicCat());
				if(groupPSDEFDLogic == null) {
					groupPSDEFDLogic = new PSDEFDLogic();
					groupPSDEFDLogic.setName(String.format("表单成员[%1$s][%2$s]逻辑", psDEFormDetail.getName(), psDEFDLogic.getLogicCat()));
					groupPSDEFDLogic.setGroupOP(GroupCondOP.AND.value);
					groupPSDEFDLogic.logictype(FormDetailLogicType.GROUP);
					groupPSDEFDLogic.setLogicCat(psDEFDLogic.getLogicCat());
					catPSDEFDLogicMap.put(psDEFDLogic.getLogicCat(), groupPSDEFDLogic);
				}
				groupPSDEFDLogic.getPSDEFDLogicsIf().add(psDEFDLogic);
			}
			
			
			if(!ObjectUtils.isEmpty(catPSDEFDLogicMap)) {
				ArrayNode arrayNode = objectNode.putArray(PSDEFormDetailImpl.ATTR_GETPSDEFDGROUPLOGICS);
				for(java.util.Map.Entry<String, PSDEFDLogic> entry : catPSDEFDLogicMap.entrySet()) {
					ObjectNode psDEFDLogicNode = iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFDLogic.class, false).compile(iPSModelTranspileContext, entry.getValue(), null);
					psDEFDLogicNode.put(PSDEFDCatGroupLogicImpl.ATTR_GETLOGICCAT, entry.getKey());
					
					//获取相关的项集合
					Map<String, String> nameMap = new LinkedHashMap<String, String>();
					fillPSDEFDLogicItemNames(entry.getValue(), nameMap);
					if(!ObjectUtils.isEmpty(nameMap)) {
						ArrayNode nameArray = psDEFDLogicNode.putArray(PSDEFDCatGroupLogicImpl.ATTR_GETRELATEDDETAILNAMES);
						for(String strName : nameMap.keySet()) {
							nameArray.add(strName);
						}
					}
					
					arrayNode.add(psDEFDLogicNode);
				}
			}
		}

	}
	
	
	protected void fillPSDEFDLogicItemNames(PSDEFDLogic groupPSDEFDLogic, Map<String, String> map) {
		
		List<PSDEFDLogic> psDEFDLogics = groupPSDEFDLogic.getPSDEFDLogics();
		if(ObjectUtils.isEmpty(psDEFDLogics)) {
			return;
		}
		
		for(PSDEFDLogic psDEFDLogic : psDEFDLogics) {
			if(FormDetailLogicType.GROUP.value.equalsIgnoreCase(psDEFDLogic.getLogicType())) {
				fillPSDEFDLogicItemNames(psDEFDLogic, map);
				continue;
			}
			
			if(FormDetailLogicType.SINGLE.value.equalsIgnoreCase(psDEFDLogic.getLogicType())) {
				if(StringUtils.hasLength(psDEFDLogic.getFDName())) {
					map.put(psDEFDLogic.getFDName(), "");
				}
				continue;
			}
		}
		
	}
}