package net.ibizsys.model.util.transpiler.app.view;



import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.util.IPSModel;
import static net.ibizsys.model.app.view.PSAppViewMsgImpl.*;



public class PSAppViewMsgTranspiler extends net.ibizsys.model.util.transpiler.app.PSApplicationObjectTranspiler{

	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		if(!(iPSModelObject instanceof net.ibizsys.model.app.view.PSAppViewMsgImpl)){
			super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
			return;
			
		}
		net.ibizsys.model.app.view.PSAppViewMsgImpl realPSModelObject = (net.ibizsys.model.app.view.PSAppViewMsgImpl)iPSModelObject;
		this.setDomainValue(iPSModelTranspileContext, domain, "contentpslanresid", realPSModelObject.getContentPSLanguageRes(), realPSModelObject, "getContentPSLanguageRes");
		this.setDomainValue(iPSModelTranspileContext, domain, "dynamicmode", realPSModelObject.getDynamicMode(), realPSModelObject, "getDynamicMode");
		this.setDomainValue(iPSModelTranspileContext, domain, "msgtype", realPSModelObject.getMessageType(), realPSModelObject, "getMessageType");
		this.setDomainValue(iPSModelTranspileContext, domain, "pssysmsgtemplid", realPSModelObject.getPSAppMsgTempl(), realPSModelObject, "getPSAppMsgTempl");
		this.setDomainValue(iPSModelTranspileContext, domain, "msgpos", realPSModelObject.getPosition(), realPSModelObject, "getPosition");
		this.setDomainValue(iPSModelTranspileContext, domain, "enableremove", realPSModelObject.getRemoveMode(), realPSModelObject, "getRemoveMode");
		this.setDomainValue(iPSModelTranspileContext, domain, "title", realPSModelObject.getTitle(), realPSModelObject, "getTitle");
		this.setDomainValue(iPSModelTranspileContext, domain, "titlepslanresid", realPSModelObject.getTitlePSLanguageRes(), realPSModelObject, "getTitlePSLanguageRes");
		this.setDomainValue(iPSModelTranspileContext, domain, "enableremove", realPSModelObject.isEnableRemove(), realPSModelObject, "isEnableRemove");
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
	}
	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETCONTENTPSLANGUAGERES, domain, "contentpslanresid", net.ibizsys.model.res.IPSLanguageRes.class, false);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETDYNAMICMODE, domain, "dynamicmode", int.class, new String[]{"0"});
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETMESSAGETYPE, domain, "msgtype", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPSAPPMSGTEMPL, domain, "pssysmsgtemplid", net.ibizsys.model.app.msg.IPSAppMsgTempl.class, false);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPOSITION, domain, "msgpos", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETREMOVEMODE, domain, "enableremove", int.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETTITLE, domain, "title", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETTITLEPSLANGUAGERES, domain, "titlepslanresid", net.ibizsys.model.res.IPSLanguageRes.class, false);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_ISENABLEREMOVE, domain, "enableremove", boolean.class);
		super.onCompile(iPSModelTranspileContext, domain, objectNode);
	}
}