package net.ibizsys.model.util.transpiler.app.control;



import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.util.IPSModel;
import static net.ibizsys.model.app.control.PSAppPortletImpl.*;



public class PSAppPortletTranspiler extends net.ibizsys.model.util.transpiler.app.PSApplicationObjectTranspiler{

	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		if(!(iPSModelObject instanceof net.ibizsys.model.app.control.PSAppPortletImpl)){
			super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
			return;
			
		}
		net.ibizsys.model.app.control.PSAppPortletImpl realPSModelObject = (net.ibizsys.model.app.control.PSAppPortletImpl)iPSModelObject;
		this.setDomainValue(iPSModelTranspileContext, domain, "psdeid", realPSModelObject.getPSAppDataEntity(), realPSModelObject, "getPSAppDataEntity");
		this.setDomainValue(iPSModelTranspileContext, domain, "pssysportletcatid", realPSModelObject.getPSAppPortletCat(), realPSModelObject, "getPSAppPortletCat");
		this.setDomainValue(iPSModelTranspileContext, domain, "dashboardscope", realPSModelObject.isEnableAppDashboard(), realPSModelObject, "isEnableAppDashboard");
		this.setDomainValue(iPSModelTranspileContext, domain, "dashboardscope", realPSModelObject.isEnableDEDashboard(), realPSModelObject, "isEnableDEDashboard");
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
	}
	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPSAPPDATAENTITY, domain, "psdeid", net.ibizsys.model.app.dataentity.IPSAppDataEntity.class, false);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETPSAPPPORTLETCAT, domain, "pssysportletcatid", net.ibizsys.model.app.control.IPSAppPortletCat.class, true);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_ISENABLEAPPDASHBOARD, domain, "dashboardscope", boolean.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_ISENABLEDEDASHBOARD, domain, "dashboardscope", boolean.class);
		super.onCompile(iPSModelTranspileContext, domain, objectNode);
	}
}