/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.wf;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.wf.PSWFLinkListTranspiler;
import net.ibizsys.model.wf.IPSWFDE;
import net.ibizsys.model.wf.IPSWFLink;
import net.ibizsys.model.wf.IPSWFLinkCond;
import net.ibizsys.model.wf.IPSWFProcess;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.psmodel.core.domain.PSWFDE;
import net.ibizsys.psmodel.core.domain.PSWFLink;
import net.ibizsys.psmodel.core.domain.PSWFLinkCond;
import net.ibizsys.psmodel.core.domain.PSWFProcess;
import net.ibizsys.psmodel.core.util.DataTypeUtils;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSWFLinkListTranspilerEx
extends PSWFLinkListTranspiler {
    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        if (bFullMode) {
            IPSWFLink iPSWFLink = (IPSWFLink)iPSModelObject;
            PSWFLink psWFLink = (PSWFLink)domain;
            IPSWorkflow iPSWorkflow = (IPSWorkflow)iPSWFLink.getParentPSModelObject(IPSWorkflow.class);
            HashMap<String, PSWFDE> psWFDEMap = new HashMap<String, PSWFDE>();
            PSWFDE defaultPSWFDE = null;
            if (!ObjectUtils.isEmpty((Object)iPSWorkflow.getPSWFDEs())) {
                ArrayList psWFDEList = new ArrayList();
                iPSModelTranspileContext.getPSModelListTranspiler(IPSWFDE.class, false).decompile(iPSModelTranspileContext, iPSWorkflow.getPSWFDEs(), psWFDEList, bFullMode);
                for (PSWFDE psWFDE : psWFDEList) {
                    psWFDEMap.put(psWFDE.getPSDEId(), psWFDE);
                    if (!DataTypeUtils.getBooleanValue((Object)psWFDE.getDefaultMode(), (Boolean)false).booleanValue()) continue;
                    defaultPSWFDE = psWFDE;
                }
                if (defaultPSWFDE == null && psWFDEList.size() > 0) {
                    defaultPSWFDE = (PSWFDE)psWFDEList.get(0);
                }
            }
            PSWFProcess psWFProcess = new PSWFProcess();
            iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcess.class, false).decompile(iPSModelTranspileContext, (IPSModelObject)iPSWFLink.getFromPSWFProcessMust(), (IPSModel)psWFProcess, bFullMode);
            PSWFDE psWFDE = null;
            if (StringUtils.hasLength((String)psWFProcess.getPSDEId())) {
                psWFDE = (PSWFDE)psWFDEMap.get(psWFProcess.getPSDEId());
            }
            if (psWFDE == null) {
                psWFDE = defaultPSWFDE;
            }
            if (psWFDE != null) {
                psWFLink.setPSWFDEId(psWFDE.getId());
                psWFLink.setPSDEId(psWFDE.getPSDEId());
                if (StringUtils.hasLength((String)psWFLink.getFormCodeName())) {
                    psWFLink.setPSDEFormId(String.format("%1$s.%2$s", psWFDE.getPSDEId(), psWFLink.getFormCodeName()));
                    if (!StringUtils.hasLength((String)psWFLink.getPSDEFormName())) {
                        psWFLink.setPSDEFormName(psWFLink.getFormCodeName());
                    }
                }
                if (StringUtils.hasLength((String)psWFLink.getMobFormCodeName())) {
                    psWFLink.setMobPSDEFormId(String.format("%1$s.%2$s", psWFDE.getPSDEId(), psWFLink.getMobFormCodeName()));
                    if (!StringUtils.hasLength((String)psWFLink.getMobPSDEFormName())) {
                        psWFLink.setMobPSDEFormName(psWFLink.getMobFormCodeName());
                    }
                }
                if (StringUtils.hasLength((String)psWFLink.getViewCodeName())) {
                    psWFLink.setPSDEViewBaseId(String.format("%1$s.%2$s", psWFDE.getPSDEId(), psWFLink.getViewCodeName()));
                    if (!StringUtils.hasLength((String)psWFLink.getPSDEViewBaseName())) {
                        psWFLink.setPSDEViewBaseName(psWFLink.getViewCodeName());
                    }
                }
                if (StringUtils.hasLength((String)psWFLink.getMobViewCodeName())) {
                    psWFLink.setMobPSDEViewId(String.format("%1$s.%2$s", psWFDE.getPSDEId(), psWFLink.getMobViewCodeName()));
                    if (!StringUtils.hasLength((String)psWFLink.getMobPSDEViewName())) {
                        psWFLink.setMobPSDEViewName(psWFLink.getMobViewCodeName());
                    }
                }
            }
            if (iPSWFLink.getPSWFLinkGroupCond() != null && iPSWFLink.getPSWFLinkGroupCond().getPSWFLinkConds() != null) {
                iPSModelTranspileContext.getPSModelListTranspiler(IPSWFLinkCond.class, false).decompile(iPSModelTranspileContext, iPSWFLink.getPSWFLinkGroupCond().getPSWFLinkConds(), psWFLink.getPSWFLinkCondsIf(), bFullMode);
                int nOrder = 100;
                for (PSWFLinkCond child : psWFLink.getPSWFLinkCondsIf()) {
                    child.setPSWFLinkId(psWFLink.getId());
                    child.setPSWFLinkName(psWFLink.getName());
                    child.setOrderValue(Integer.valueOf(nOrder));
                    nOrder += 100;
                }
            }
        }
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        PSWFLink psWFLink = (PSWFLink)domain;
        if (StringUtils.hasLength((String)psWFLink.getPSDEFormId())) {
            objectNode.put("formCodeName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getPSDEFormId()));
            if (StringUtils.hasLength((String)psWFLink.getPSDEFormName())) {
                objectNode.put("formName", psWFLink.getPSDEFormName());
            } else {
                objectNode.put("formName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getPSDEFormId()));
            }
        }
        if (StringUtils.hasLength((String)psWFLink.getMobPSDEFormId())) {
            objectNode.put("mobFormCodeName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getMobPSDEFormId()));
            if (StringUtils.hasLength((String)psWFLink.getMobPSDEFormName())) {
                objectNode.put("mobFormName", psWFLink.getMobPSDEFormName());
            } else {
                objectNode.put("mobFormName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getMobPSDEFormId()));
            }
        }
        if (StringUtils.hasLength((String)psWFLink.getPSDEViewBaseId())) {
            objectNode.put("viewCodeName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getPSDEViewBaseId()));
            if (StringUtils.hasLength((String)psWFLink.getPSDEViewBaseName())) {
                objectNode.put("viewName", psWFLink.getPSDEViewBaseName());
            } else {
                objectNode.put("viewName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getPSDEViewBaseId()));
            }
        }
        if (StringUtils.hasLength((String)psWFLink.getMobPSDEViewId())) {
            objectNode.put("mobViewCodeName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getMobPSDEViewId()));
            if (StringUtils.hasLength((String)psWFLink.getMobPSDEViewName())) {
                objectNode.put("mobViewName", psWFLink.getMobPSDEViewName());
            } else {
                objectNode.put("mobViewName", PSWFLinkListTranspilerEx.getSimpleId(psWFLink.getMobPSDEViewId()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)psWFLink.getPSWFLinkConds())) {
            PSWFLinkCond groupPSWFLinkCond = new PSWFLinkCond();
            groupPSWFLinkCond.logictype(PSModelEnums.WFLinkCondType.GROUP);
            groupPSWFLinkCond.groupop(PSModelEnums.GroupCondOP.AND);
            groupPSWFLinkCond.getPSWFLinkCondsIf().addAll(psWFLink.getPSWFLinkConds());
            ObjectNode groupCondNode = objectNode.putObject("getPSWFLinkGroupCond");
            iPSModelTranspileContext.getPSModelListTranspiler(IPSWFLinkCond.class, false).compile(iPSModelTranspileContext, (IPSModel)groupPSWFLinkCond, groupCondNode);
        }
    }
}

