/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.dataentity.logic;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.dataentity.logic.PSDELogicListTranspiler;
import net.ibizsys.psmodel.core.domain.PSDELogic;
import net.ibizsys.psmodel.core.domain.PSDELogicLink;
import net.ibizsys.psmodel.core.domain.PSDELogicNode;
import net.ibizsys.psmodel.core.domain.PSDELogicParam;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import org.springframework.util.ObjectUtils;

public class PSDELogicListTranspilerEx
extends PSDELogicListTranspiler {
    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        IPSDELogic iPSDELogic = (IPSDELogic)iPSModelObject;
        PSDELogic psDELogic = (PSDELogic)domain;
        int logicHolder = 0;
        if (iPSDELogic.isEnableFront()) {
            logicHolder |= PSModelEnums.DELogicHolder.FRONT.value;
        }
        if (iPSDELogic.isEnableBackend()) {
            logicHolder |= PSModelEnums.DELogicHolder.BACKEND.value;
        }
        psDELogic.setLogicHolder(Integer.valueOf(logicHolder));
        if (bFullMode) {
            if (iPSDELogic.getPSDELogicParams() != null) {
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicParam.class, false).decompile(iPSModelTranspileContext, iPSDELogic.getPSDELogicParams(), psDELogic.getPSDELogicParamsIf(), bFullMode);
                for (PSDELogicParam child : psDELogic.getPSDELogicParamsIf()) {
                    child.setPSDELogicId(psDELogic.getId());
                    child.setPSDELogicName(psDELogic.getName());
                }
            }
            if (iPSDELogic.getPSDELogicNodes() != null) {
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicNode.class, false).decompile(iPSModelTranspileContext, iPSDELogic.getPSDELogicNodes(), psDELogic.getPSDELogicNodesIf(), bFullMode);
                for (PSDELogicParam child : psDELogic.getPSDELogicNodesIf()) {
                    child.setPSDELogicId(psDELogic.getId());
                    child.setPSDELogicName(psDELogic.getName());
                }
                for (IPSDELogicNode iPSDELogicNode : iPSDELogic.getPSDELogicNodes()) {
                    if (iPSDELogicNode.getPSDELogicLinks() == null) continue;
                    iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLink.class, false).decompile(iPSModelTranspileContext, iPSDELogicNode.getPSDELogicLinks(), psDELogic.getPSDELogicLinksIf(), bFullMode);
                    int nOrder = 100;
                    for (PSDELogicLink child : psDELogic.getPSDELogicLinksIf()) {
                        child.setPSDELogicId(psDELogic.getId());
                        child.setPSDELogicName(psDELogic.getName());
                        child.setOrderValue(Integer.valueOf(nOrder));
                        nOrder += 100;
                    }
                }
            }
        }
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        ArrayNode arrayNode;
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        PSDELogic psDELogic = (PSDELogic)domain;
        int logicHolder = DataTypeUtils.getIntegerValue((Object)psDELogic.getLogicHolder(), (Integer)0);
        if ((logicHolder & PSModelEnums.DELogicHolder.FRONT.value) == PSModelEnums.DELogicHolder.FRONT.value) {
            objectNode.put("enableFront", true);
        } else {
            objectNode.put("enableFront", false);
        }
        if ((logicHolder & PSModelEnums.DELogicHolder.BACKEND.value) == PSModelEnums.DELogicHolder.BACKEND.value) {
            objectNode.put("enableBackend", true);
        } else {
            objectNode.put("enableBackend", false);
        }
        if (!ObjectUtils.isEmpty((Object)psDELogic.getPSDELogicParams())) {
            arrayNode = objectNode.putArray("getPSDELogicParams");
            iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicParam.class, false).compile(iPSModelTranspileContext, psDELogic.getPSDELogicParams(), arrayNode);
        }
        if (!ObjectUtils.isEmpty((Object)psDELogic.getPSDELogicNodes())) {
            arrayNode = objectNode.putArray("getPSDELogicNodes");
            iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicNode.class, false).compile(iPSModelTranspileContext, psDELogic.getPSDELogicNodes(), arrayNode);
            for (int i = 0; i < psDELogic.getPSDELogicNodes().size(); ++i) {
                PSDELogicNode psDELogicNode = (PSDELogicNode)psDELogic.getPSDELogicNodes().get(i);
                if (PSModelEnums.LogicNodeType.BEGIN.value.equalsIgnoreCase(psDELogicNode.getLogicNodeType())) {
                    iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicNode.class, false).getModelRef(iPSModelTranspileContext, psDELogicNode.getId(), false, objectNode.putObject("getStartPSDELogicNode"));
                }
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                ArrayList<PSDELogicLink> psDELogicLinkList = new ArrayList<PSDELogicLink>();
                if (!ObjectUtils.isEmpty((Object)psDELogic.getPSDELogicLinks())) {
                    for (PSDELogicLink psDELogicLink : psDELogic.getPSDELogicLinks()) {
                        if (!psDELogicNode.getId().equals(psDELogicLink.getSrcPSDELogicNodeId())) continue;
                        psDELogicLinkList.add(psDELogicLink);
                    }
                }
                if (ObjectUtils.isEmpty(psDELogicLinkList)) continue;
                ArrayNode arrayNode2 = node.putArray("getPSDELogicLinks");
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLink.class, false).compile(iPSModelTranspileContext, psDELogicLinkList, arrayNode2);
            }
        }
    }

    @Override
    protected String[] getModelFolders() {
        return PSDELogicListTranspilerEx.getDataEntityModelFolder("PSDELOGICS");
    }
}

