/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.control;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSRawItemBase;
import net.ibizsys.model.control.rawitem.IPSHtmlItem;
import net.ibizsys.model.control.rawitem.IPSMarkdownItem;
import net.ibizsys.model.control.rawitem.IPSTextItem;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.control.PSRawItemBaseListTranspiler;
import net.ibizsys.psmodel.core.domain.PSDEFormDetail;
import net.ibizsys.psmodel.core.util.IPSModel;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSRawItemBaseListTranspilerEx
extends PSRawItemBaseListTranspiler {
    static final String PARAM_WRAPMODE = "WRAPMODE";
    static final String PARAM_VALIGN = "VALIGN";
    static final String PARAM_HALIGN = "HALIGN";

    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        if (domain instanceof PSDEFormDetail) {
            String strRawParams;
            PSDEFormDetail psDEFormDetail = (PSDEFormDetail)domain;
            if (iPSModelObject instanceof IPSRawItemBase) {
                IPSRawItemBase iPSRawItemBase = (IPSRawItemBase)iPSModelObject;
                psDEFormDetail.setContentType(iPSRawItemBase.getContentType());
                if (StringUtils.hasLength((String)iPSRawItemBase.getPredefinedType())) {
                    psDEFormDetail.setPredefinedType(iPSRawItemBase.getPredefinedType());
                }
                if (StringUtils.hasLength((String)iPSRawItemBase.getCssStyle())) {
                    psDEFormDetail.setRawCssStyle(iPSRawItemBase.getCssStyle());
                }
                if (StringUtils.hasLength((String)iPSRawItemBase.getDynaClass())) {
                    psDEFormDetail.setDynaClass(iPSRawItemBase.getDynaClass());
                }
                if (iPSRawItemBase.getRawItemWidth() > 0.0) {
                    psDEFormDetail.setCtrlWidth(Integer.valueOf((int)iPSRawItemBase.getRawItemWidth()));
                }
                if (iPSRawItemBase.getRawItemHeight() > 0.0) {
                    psDEFormDetail.setCtrlHeight(Integer.valueOf((int)iPSRawItemBase.getRawItemHeight()));
                }
                if (iPSRawItemBase.isTemplateMode()) {
                    psDEFormDetail.setTemplateMode(Integer.valueOf(1));
                }
            }
            if (iPSModelObject instanceof IPSHtmlItem) {
                IPSHtmlItem iPSHtmlItem = (IPSHtmlItem)iPSModelObject;
                psDEFormDetail.setHtmlContent(iPSHtmlItem.getContent());
            }
            if (iPSModelObject instanceof IPSMarkdownItem) {
                IPSMarkdownItem iPSMarkdownItem = (IPSMarkdownItem)iPSModelObject;
                psDEFormDetail.setRawContent(iPSMarkdownItem.getContent());
            }
            if (iPSModelObject instanceof IPSTextItem) {
                IPSTextItem iPSTextItem = (IPSTextItem)iPSModelObject;
                psDEFormDetail.setRawContent(iPSTextItem.getCaption());
            }
            if (StringUtils.hasLength((String)(strRawParams = PSRawItemBaseListTranspilerEx.getPSRawItemParams(iPSModelTranspileContext, iPSModelObject)))) {
                psDEFormDetail.setEditorParams(strRawParams);
            }
        }
    }

    public static String getPSRawItemParams(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (iPSModelObject instanceof IPSTextItem) {
            IPSTextItem iPSTextItem = (IPSTextItem)iPSModelObject;
            if (StringUtils.hasLength((String)iPSTextItem.getWrapMode())) {
                params.put(PARAM_WRAPMODE, iPSTextItem.getWrapMode());
            }
            if (StringUtils.hasLength((String)iPSTextItem.getVAlign())) {
                params.put(PARAM_VALIGN, iPSTextItem.getVAlign());
            }
            if (StringUtils.hasLength((String)iPSTextItem.getHAlign())) {
                params.put(PARAM_HALIGN, iPSTextItem.getHAlign());
            }
        }
        if (ObjectUtils.isEmpty(params)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean bFirst = true;
        for (Map.Entry entry : params.entrySet()) {
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("\r\n");
            }
            sb.append(String.format("%1$s=%2$s", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        objectNode.remove("id");
        objectNode.remove("codeName");
        String strContentType = (String)domain.get("contenttype");
        objectNode.put("contentType", strContentType);
        if (domain instanceof PSDEFormDetail) {
            String strContent;
            PSDEFormDetail psDEFormDetail = (PSDEFormDetail)domain;
            if (StringUtils.hasLength((String)psDEFormDetail.getPredefinedType())) {
                objectNode.put("predefinedType", psDEFormDetail.getPredefinedType());
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getRawCssStyle())) {
                objectNode.put("cssStyle", psDEFormDetail.getRawCssStyle());
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getDynaClass())) {
                objectNode.put("dynaClass", psDEFormDetail.getDynaClass());
            }
            if (DataTypeUtils.getIntegerValue((Object)psDEFormDetail.getCtrlWidth(), (Integer)0) > 0) {
                objectNode.put("rawItemWidth", psDEFormDetail.getCtrlWidth());
            }
            if (DataTypeUtils.getIntegerValue((Object)psDEFormDetail.getCtrlHeight(), (Integer)0) > 0) {
                objectNode.put("rawItemHeight", psDEFormDetail.getCtrlHeight());
            }
            if (DataTypeUtils.getBooleanValue((Object)psDEFormDetail.getTemplateMode(), (Boolean)false).booleanValue()) {
                objectNode.put("templateMode", true);
            }
            if (!StringUtils.hasLength((String)(strContent = psDEFormDetail.getRawContent()))) {
                strContent = psDEFormDetail.getHtmlContent();
            }
            switch (strContentType) {
                case "HTML": {
                    objectNode.put("content", strContent);
                    break;
                }
                case "IMAGE": {
                    break;
                }
                case "MARKDOWN": {
                    objectNode.put("content", strContent);
                    break;
                }
                case "PLACEHOLDER": {
                    break;
                }
                case "RAW": {
                    objectNode.put("caption", strContent);
                    if (!StringUtils.hasLength((String)psDEFormDetail.getEditorParams())) break;
                    PSRawItemBaseListTranspilerEx.setPSRawItemParams(iPSModelTranspileContext, domain, objectNode, psDEFormDetail.getEditorParams());
                    break;
                }
                case "VIDEO": {
                    break;
                }
            }
        }
    }

    public static void setPSRawItemParams(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode, String strPSRawItemParams) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strPSRawItemParams.getBytes("utf8"));
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Object key : properties.keySet()) {
            String strValue = (String)properties.get(key);
            if (!StringUtils.hasLength((String)strValue)) continue;
            params.put((String)key, new String(strValue.getBytes("ISO-8859-1"), "utf8"));
        }
        if (params.containsKey(PARAM_WRAPMODE)) {
            objectNode.put("wrapMode", (String)params.get(PARAM_WRAPMODE));
        }
        if (params.containsKey(PARAM_VALIGN)) {
            objectNode.put("vAlign", (String)params.get(PARAM_VALIGN));
        }
        if (params.containsKey(PARAM_HALIGN)) {
            objectNode.put("hAlign", (String)params.get(PARAM_HALIGN));
        }
    }
}

