/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.codelist.IPSAppCodeList;
import net.ibizsys.model.app.dataentity.IPSAppDEACMode;
import net.ibizsys.model.app.dataentity.IPSAppDEDataSet;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.app.view.IPSAppDEView;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.control.IPSEditor;
import net.ibizsys.model.control.IPSNavigateContext;
import net.ibizsys.model.control.IPSNavigateParam;
import net.ibizsys.model.control.IPSNavigateParamContainer;
import net.ibizsys.model.control.IPSTextBase;
import net.ibizsys.model.control.editor.IPSAutoComplete;
import net.ibizsys.model.control.editor.IPSCode;
import net.ibizsys.model.control.editor.IPSCodeListEditor;
import net.ibizsys.model.control.editor.IPSDatePicker;
import net.ibizsys.model.control.editor.IPSFileUploader;
import net.ibizsys.model.control.editor.IPSMailAddress;
import net.ibizsys.model.control.editor.IPSMarkdown;
import net.ibizsys.model.control.editor.IPSNumberEditor;
import net.ibizsys.model.control.editor.IPSPicker;
import net.ibizsys.model.control.editor.IPSPickerEditor;
import net.ibizsys.model.control.editor.IPSPicture;
import net.ibizsys.model.control.editor.IPSSpan;
import net.ibizsys.model.control.editor.IPSStepper;
import net.ibizsys.model.control.editor.IPSTextEditor;
import net.ibizsys.model.control.editor.IPSValueItemEditor;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.control.PSEditorListTranspiler;
import net.ibizsys.model.util.transpiler.extend.app.view.PSAppViewListTranspilerEx;
import net.ibizsys.psmodel.core.domain.PSDEFormDetail;
import net.ibizsys.psmodel.core.domain.PSEditorType;
import net.ibizsys.psmodel.core.util.IPSModel;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSEditorListTranspilerEx
extends PSEditorListTranspiler {
    static Map<String, PSEditorType> PSEditorTypeMap = new HashMap<String, PSEditorType>();
    public static final String EDITORPARAM_READONLY = "READONLY";
    public static final String EDITORPARAM_DEFAULTREADONLY = "DEFAULTREADONLY";
    public static final String EDITORPARAM_DISABLED = "DISABLED";
    public static final String EDITORPARAM_DEFAULTDISABLED = "DEFAULTDISABLED";
    public static final String EDITORPARAM_VALUETYPE = "VALUETYPE";
    public static final String EDITORPARAM_DEFAULTVALUETYPE = "DEFAULTVALUETYPE";
    public static final String EDITORPARAM_OBJECTNAMEFIELD = "OBJECTNAMEFIELD";
    public static final String EDITORPARAM_OBJECTIDFIELD = "OBJECTIDFIELD";
    public static final String EDITORPARAM_OBJECTVALUEFIELD = "OBJECTVALUEFIELD";
    public static final String EDITORPARAM_DEFAULTOBJECTNAMEFIELD = "DEFAULTOBJECTNAMEFIELD";
    public static final String EDITORPARAM_DEFAULTOBJECTIDFIELD = "DEFAULTOBJECTIDFIELD";
    public static final String EDITORPARAM_DEFAULTOBJECTVALUEFIELD = "DEFAULTOBJECTVALUEFIELD";
    public static final String EDITORPARAM_VALUESEPARATOR = "VALUESEPARATOR";
    public static final String EDITORPARAM_TEXTSEPARATOR = "TEXTSEPARATOR";
    public static final String EDITORPARAM_DEFAULTVALUESEPARATOR = "DEFAULTVALUESEPARATOR";
    public static final String EDITORPARAM_DEFAULTTEXTSEPARATOR = "DEFAULTTEXTSEPARATOR";
    public static final String EDITORPARAM_MAXLENGTH = "MAXLENGTH";
    public static final String EDITORPARAM_MINLENGTH = "MINLENGTH";
    public static final String EDITORPARAM_DEFAULTMAXLENGTH = "DEFAULTMAXLENGTH";
    public static final String EDITORPARAM_DEFAULTMINLENGTH = "DEFAULTMINLENGTH";
    public static final String EDITORPARAM_SHOWMAXLENGTH = "SHOWMAXLENGTH";
    public static final String EDITORPARAM_MAXVALUE = "MAXVALUE";
    public static final String EDITORPARAM_MINVALUE = "MINVALUE";
    public static final String EDITORPARAM_PRECISION = "PRECISION";
    public static final String EDITORPARAM_STEPVALUE = "STEPVALUE";
    public static final String EDITORPARAM_LINKVIEW = "LINKVIEW";
    public static final String EDITORPARAM_WRAPMODE = "WRAPMODE";
    public static final String EDITORPARAM_VALIGN = "VALIGN";
    public static final String EDITORPARAM_HALIGN = "HALIGN";
    public static final String EDITORPARAM_RAWCONTENT = "RAWCONTENT";
    public static final String EDITORPARAM_FORCESELECTION = "FORCESELECTION";
    public static final String EDITORPARAM_TRIGGER = "TRIGGER";
    public static final String EDITORPARAM_ACMINCHARS = "ACMINCHARS";
    public static final String EDITORPARAM_AC = "AC";
    public static final String EDITORPARAM_MODE = "MODE";
    public static final String EDITORPARAM_PICKUPVIEW = "PICKUPVIEW";
    public static final String EDITORPARAM_MINFILECNT = "MINFILECNT";
    public static final String EDITORPARAM_FILEEXTS = "FILEEXTS";
    public static final String EDITORPARAM_MAXFILECNT = "MAXFILECNT";
    public static final String EDITORPARAM_MAXFILESIZE = "MAXFILESIZE";
    public static final String EDITORPARAM_OSSCAT = "OSSCAT";
    public static final String EDITORPARAM_TIMEFMT = "TIMEFMT";
    public static final String EDITORPARAM_CODETYPE = "CODETYPE";
    public static final String EDITORVALUETYPE_SIMPLE = "SIMPLE";
    public static final String EDITORVALUETYPE_SIMPLES = "SIMPLES";
    public static final String EDITORVALUETYPE_OBJECT = "OBJECT";
    public static final String EDITORVALUETYPE_OBJECTS = "OBJECTS";
    public static final String VIEWPARAM_NAVCONTEXT = "SRFNAVCTX.";
    public static final String VIEWPARAM_NAVPARAM = "SRFNAVPARAM.";

    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        this.getPSModelTranspiler(iPSModelTranspileContext, iPSModelObject).decompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        IPSEditor iPSEditor = (IPSEditor)iPSModelObject;
        if (domain instanceof PSDEFormDetail) {
            IPSSpan iPSSpan;
            IPSPicker iPSPicker;
            IPSPickerEditor iPSPickerEditor;
            IPSValueItemEditor iPSValueItemEditor;
            IPSCodeListEditor iPSCodeListEditor;
            String strPSEditorParams;
            PSDEFormDetail psDEFormDetail = (PSDEFormDetail)domain;
            psDEFormDetail.setEditorType(iPSEditor.getEditorType());
            PSEditorType psEditorType = PSEditorTypeMap.get(iPSEditor.getEditorType());
            if (psEditorType != null) {
                psDEFormDetail.set("editortypename", (Object)psEditorType.getName());
            } else {
                psDEFormDetail.set("editortypename", (Object)iPSEditor.getEditorType());
            }
            if (iPSEditor.getPlaceHolder() != null) {
                psDEFormDetail.setPlaceHolder(iPSEditor.getPlaceHolder());
            }
            if (iPSEditor.getCssStyle() != null) {
                psDEFormDetail.setCtrlRawCssStyle(iPSEditor.getCssStyle());
            }
            if (iPSEditor.getDynaClass() != null) {
                psDEFormDetail.setCtrlDynaClass(iPSEditor.getDynaClass());
            }
            if (iPSEditor.getPredefinedType() != null) {
                psDEFormDetail.setPredefinedType(iPSEditor.getPredefinedType());
            }
            if (iPSEditor.getEditorWidth() > 0.0) {
                psDEFormDetail.setCtrlWidth(Integer.valueOf((int)iPSEditor.getEditorWidth()));
            }
            if (iPSEditor.getEditorHeight() > 0.0) {
                psDEFormDetail.setCtrlHeight(Integer.valueOf((int)iPSEditor.getEditorHeight()));
            }
            if (StringUtils.hasLength((String)(strPSEditorParams = PSEditorListTranspilerEx.getPSEditorParams(iPSModelTranspileContext, iPSEditor)))) {
                psDEFormDetail.setEditorParams(strPSEditorParams);
            }
            if (iPSEditor instanceof IPSCodeListEditor && (iPSCodeListEditor = (IPSCodeListEditor)iPSEditor).getPSAppCodeList() != null) {
                psDEFormDetail.setPSCodeListId(iPSModelTranspileContext.getPSModelUniqueTag((IPSModelObject)iPSCodeListEditor.getPSAppCodeList()));
                psDEFormDetail.setPSCodeListName(iPSCodeListEditor.getPSAppCodeList().getName());
            }
            if (iPSEditor instanceof IPSAutoComplete) {
                IPSAutoComplete iPSAutoComplete = (IPSAutoComplete)iPSEditor;
                if (iPSAutoComplete.getPSAppDataEntity() != null && iPSAutoComplete.getPSAppDataEntity().getPSDataEntity() != null) {
                    psDEFormDetail.setRefPSDEId(iPSModelTranspileContext.getPSModelUniqueTag((IPSModelObject)iPSAutoComplete.getPSAppDataEntity().getPSDataEntity()));
                    psDEFormDetail.setRefPSDEName(iPSAutoComplete.getPSAppDataEntity().getPSDataEntity().getName());
                }
                if (iPSAutoComplete.getPSAppDEACMode() != null) {
                    psDEFormDetail.setRefPSDEACModeId(iPSModelTranspileContext.getPSModelUniqueTag((IPSModelObject)iPSAutoComplete.getPSAppDEACMode()));
                    psDEFormDetail.setRefPSDEACModeName(iPSAutoComplete.getPSAppDEACMode().getName());
                }
                if (iPSAutoComplete.getPSAppDEDataSet() != null) {
                    psDEFormDetail.setRefPSDEDataSetId(iPSModelTranspileContext.getPSModelUniqueTag((IPSModelObject)iPSAutoComplete.getPSAppDEDataSet()));
                    psDEFormDetail.setRefPSDEDataSetName(iPSAutoComplete.getPSAppDEDataSet().getName());
                }
            }
            if (iPSEditor instanceof IPSValueItemEditor && StringUtils.hasLength((String)(iPSValueItemEditor = (IPSValueItemEditor)iPSEditor).getValueItemName())) {
                psDEFormDetail.setValueItemName(iPSValueItemEditor.getValueItemName());
            }
            if (iPSEditor instanceof IPSPickerEditor && (iPSPickerEditor = (IPSPickerEditor)iPSEditor).getPickupPSAppView() instanceof IPSAppDEView) {
                psDEFormDetail.setPickupPSDEViewId(PSAppViewListTranspilerEx.getPSDEViewBaseId(iPSModelTranspileContext, (IPSAppDEView)iPSPickerEditor.getPickupPSAppView()));
                psDEFormDetail.setPickupPSDEViewName(iPSPickerEditor.getPickupPSAppView().getTitle());
            }
            if (iPSEditor instanceof IPSPicker && (iPSPicker = (IPSPicker)iPSEditor).getLinkPSAppView() instanceof IPSAppDEView) {
                psDEFormDetail.setLinkPSDEViewId(PSAppViewListTranspilerEx.getPSDEViewBaseId(iPSModelTranspileContext, (IPSAppDEView)iPSPicker.getLinkPSAppView()));
                psDEFormDetail.setLinkPSDEViewName(iPSPicker.getLinkPSAppView().getTitle());
            }
            if (iPSEditor instanceof IPSSpan && (iPSSpan = (IPSSpan)iPSEditor).getLinkPSAppView() instanceof IPSAppDEView) {
                psDEFormDetail.setLinkPSDEViewId(PSAppViewListTranspilerEx.getPSDEViewBaseId(iPSModelTranspileContext, (IPSAppDEView)iPSSpan.getLinkPSAppView()));
                psDEFormDetail.setLinkPSDEViewName(iPSSpan.getLinkPSAppView().getTitle());
            }
        }
    }

    public static String getPSEditorParams(IPSModelTranspileContext ipsModelTranspileContext, IPSEditor iPSEditor) throws Exception {
        IPSCode iPSCode;
        IPSDatePicker iPSDatePicker;
        IPSMailAddress iPSMailAddress;
        IPSMarkdown iPSMarkdown;
        IPSNumberEditor iPSTextBox;
        Iterator fieldNames;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ObjectNode objectNode = iPSEditor.getEditorParams();
        if (objectNode != null && (fieldNames = objectNode.fieldNames()) != null) {
            while (fieldNames.hasNext()) {
                String strFieldName = (String)fieldNames.next();
                JsonNode jsonNode = objectNode.get(strFieldName);
                if (jsonNode == null || jsonNode instanceof NullNode) continue;
                params.put(strFieldName, jsonNode.asText(""));
            }
        }
        if (iPSEditor.getValueType() != null && !EDITORVALUETYPE_SIMPLE.contains(iPSEditor.getValueType())) {
            params.put(EDITORPARAM_VALUETYPE, iPSEditor.getValueType());
        }
        if (iPSEditor.getObjectIdField() != null) {
            params.put(EDITORPARAM_OBJECTIDFIELD, iPSEditor.getObjectIdField());
        }
        if (iPSEditor.getObjectNameField() != null) {
            params.put(EDITORPARAM_OBJECTNAMEFIELD, iPSEditor.getObjectNameField());
        }
        if (iPSEditor.getObjectValueField() != null) {
            params.put(EDITORPARAM_OBJECTVALUEFIELD, iPSEditor.getObjectValueField());
        }
        if (iPSEditor.getValueSeparator() != null) {
            params.put(EDITORPARAM_VALUESEPARATOR, iPSEditor.getValueSeparator());
        }
        if (iPSEditor.getTextSeparator() != null) {
            params.put(EDITORPARAM_TEXTSEPARATOR, iPSEditor.getTextSeparator());
        }
        if (iPSEditor.getValueSeparator() != null) {
            params.put(EDITORPARAM_VALUESEPARATOR, iPSEditor.getValueSeparator());
        }
        if (iPSEditor instanceof IPSTextEditor) {
            IPSTextEditor iPSTextEditor = (IPSTextEditor)iPSEditor;
            if (iPSTextEditor.getMaxLength() != null && iPSTextEditor.getMaxLength() > 0) {
                params.put(EDITORPARAM_MAXLENGTH, Integer.toString(iPSTextEditor.getMaxLength()));
            }
            if (iPSTextEditor.getMinLength() != null && iPSTextEditor.getMinLength() > 0) {
                params.put(EDITORPARAM_MINLENGTH, Integer.toString(iPSTextEditor.getMinLength()));
            }
            if (iPSTextEditor.isShowMaxLength()) {
                params.put(EDITORPARAM_SHOWMAXLENGTH, "TRUE");
            }
        }
        if (iPSEditor instanceof IPSNumberEditor) {
            iPSTextBox = (IPSNumberEditor)iPSEditor;
            if (iPSTextBox.getMaxValue() != null) {
                params.put(EDITORPARAM_MAXVALUE, Double.toString(iPSTextBox.getMaxValue()));
            }
            if (iPSTextBox.getMinValue() != null) {
                params.put(EDITORPARAM_MINVALUE, Double.toString(iPSTextBox.getMinValue()));
            }
            if (iPSTextBox.getPrecision() != null && iPSTextBox.getPrecision() > 0) {
                params.put(EDITORPARAM_PRECISION, Integer.toString(iPSTextBox.getPrecision()));
            }
        }
        if (iPSEditor instanceof IPSTextBase) {
            iPSTextBox = (IPSTextBase)iPSEditor;
            if (iPSTextBox.getWrapMode() != null) {
                params.put(EDITORPARAM_WRAPMODE, iPSTextBox.getWrapMode());
            }
            if (iPSTextBox.getHAlign() != null) {
                params.put(EDITORPARAM_HALIGN, iPSTextBox.getHAlign());
            }
            if (iPSTextBox.getVAlign() != null) {
                params.put(EDITORPARAM_VALIGN, iPSTextBox.getVAlign());
            }
        }
        if (iPSEditor instanceof IPSAutoComplete) {
            IPSAutoComplete iPSAutoComplete = (IPSAutoComplete)iPSEditor;
            if (iPSAutoComplete.isEnableAC()) {
                params.put(EDITORPARAM_AC, "TRUE");
            }
            if (iPSAutoComplete.isForceSelection()) {
                params.put(EDITORPARAM_FORCESELECTION, "TRUE");
            }
            if (iPSAutoComplete.isShowTrigger()) {
                params.put(EDITORPARAM_TRIGGER, "TRUE");
            }
            if (iPSAutoComplete.getACMinChars() > 0) {
                params.put(EDITORPARAM_ACMINCHARS, Integer.toString(iPSAutoComplete.getACMinChars()));
            }
        }
        if (iPSEditor instanceof IPSPicture) {
            iPSTextBox = (IPSPicture)iPSEditor;
            if (iPSTextBox.isRawContent()) {
                params.put(EDITORPARAM_RAWCONTENT, "TRUE");
            }
            if (iPSTextBox.getOSSCat() != null) {
                params.put(EDITORPARAM_OSSCAT, iPSTextBox.getOSSCat());
            }
        }
        if (iPSEditor instanceof IPSStepper && (iPSTextBox = (IPSStepper)iPSEditor).getStepValue() != null) {
            params.put(EDITORPARAM_STEPVALUE, Double.toString(iPSTextBox.getStepValue()));
        }
        if (iPSEditor instanceof IPSSpan) {
            IPSSpan iPSSpan = (IPSSpan)iPSEditor;
            if (iPSSpan.isEnableLinkView()) {
                params.put(EDITORPARAM_LINKVIEW, "TRUE");
            }
            if (iPSSpan.getPrecision() != null && iPSSpan.getPrecision() > 0) {
                params.put(EDITORPARAM_PRECISION, Integer.toString(iPSSpan.getPrecision()));
            }
        }
        if (iPSEditor instanceof IPSMarkdown && (iPSMarkdown = (IPSMarkdown)iPSEditor).getMode() != null) {
            params.put(EDITORPARAM_MODE, iPSMarkdown.getMode());
        }
        if (iPSEditor instanceof IPSMailAddress && (iPSMailAddress = (IPSMailAddress)iPSEditor).isEnablePickupView()) {
            params.put(EDITORPARAM_PICKUPVIEW, "TRUE");
        }
        if (iPSEditor instanceof IPSFileUploader) {
            IPSFileUploader iPSFileUploader = (IPSFileUploader)iPSEditor;
            if (iPSFileUploader.getFileExts() != null) {
                params.put(EDITORPARAM_FILEEXTS, iPSFileUploader.getFileExts());
            }
            if (iPSFileUploader.getMaxFileCount() > 0) {
                params.put(EDITORPARAM_MAXFILECNT, Integer.toString(iPSFileUploader.getMaxFileCount()));
            }
            if (iPSFileUploader.getMinFileCount() > 0) {
                params.put(EDITORPARAM_MINFILECNT, Integer.toString(iPSFileUploader.getMinFileCount()));
            }
            if (iPSFileUploader.getMaxFileSize() > 0) {
                params.put(EDITORPARAM_MAXFILESIZE, Integer.toString(iPSFileUploader.getMaxFileSize()));
            }
            if (iPSFileUploader.getOSSCat() != null) {
                params.put(EDITORPARAM_OSSCAT, iPSFileUploader.getOSSCat());
            }
        }
        if (iPSEditor instanceof IPSDatePicker && (iPSDatePicker = (IPSDatePicker)iPSEditor).getDateTimeFormat() != null) {
            params.put(EDITORPARAM_TIMEFMT, iPSDatePicker.getDateTimeFormat());
        }
        if (iPSEditor instanceof IPSCode && (iPSCode = (IPSCode)iPSEditor).getCodeType() != null) {
            params.put(EDITORPARAM_CODETYPE, iPSCode.getCodeType());
        }
        if (iPSEditor instanceof IPSNavigateParamContainer) {
            IPSNavigateParamContainer iPSNavigateParamContainer = (IPSNavigateParamContainer)iPSEditor;
            if (!ObjectUtils.isEmpty((Object)iPSNavigateParamContainer.getPSNavigateParams())) {
                for (IPSNavigateParam iPSNavigateParam : iPSNavigateParamContainer.getPSNavigateParams()) {
                    if (iPSNavigateParam.isRawValue()) {
                        params.put(String.format("%1$s%2$s", VIEWPARAM_NAVPARAM, iPSNavigateParam.getKey()), iPSNavigateParam.getValue());
                        continue;
                    }
                    params.put(String.format("%1$s%2$s", VIEWPARAM_NAVPARAM, iPSNavigateParam.getKey()), String.format("%%%1$s%%", iPSNavigateParam.getValue()));
                }
            }
            if (!ObjectUtils.isEmpty((Object)iPSNavigateParamContainer.getPSNavigateContexts())) {
                for (IPSNavigateContext iPSNavigateContext : iPSNavigateParamContainer.getPSNavigateContexts()) {
                    if (iPSNavigateContext.isRawValue()) {
                        params.put(String.format("%1$s%2$s", VIEWPARAM_NAVCONTEXT, iPSNavigateContext.getKey()), iPSNavigateContext.getValue());
                        continue;
                    }
                    params.put(String.format("%1$s%2$s", VIEWPARAM_NAVCONTEXT, iPSNavigateContext.getKey()), String.format("%%%1$s%%", iPSNavigateContext.getValue()));
                }
            }
        }
        if (ObjectUtils.isEmpty(params)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean bFirst = true;
        for (Map.Entry entry : params.entrySet()) {
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("\r\n");
            }
            sb.append(String.format("%1$s=%2$s", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
        objectNode.remove("id");
        objectNode.remove("codeName");
        String strEditorType = (String)domain.get("editortype");
        String strEditorStyle = (String)domain.get("editorstyle");
        objectNode.put("editorType", strEditorType);
        if (StringUtils.hasLength((String)strEditorStyle)) {
            objectNode.put("editorStyle", strEditorStyle);
        }
        LinkedHashMap<String, String> editorItemMap = new LinkedHashMap<String, String>();
        if (domain instanceof PSDEFormDetail) {
            String strPSEditorParams;
            PSDEFormDetail psDEFormDetail = (PSDEFormDetail)domain;
            if (StringUtils.hasLength((String)psDEFormDetail.getPlaceHolder())) {
                objectNode.put("placeHolder", psDEFormDetail.getPlaceHolder());
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getCtrlRawCssStyle())) {
                objectNode.put("cssStyle", psDEFormDetail.getCtrlRawCssStyle());
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getCtrlDynaClass())) {
                objectNode.put("dynaClass", psDEFormDetail.getCtrlDynaClass());
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getPredefinedType())) {
                objectNode.put("predefinedType", psDEFormDetail.getPredefinedType());
            }
            if (DataTypeUtils.getIntegerValue((Object)psDEFormDetail.getCtrlWidth(), (Integer)-1) > 0) {
                objectNode.put("editorWidth", psDEFormDetail.getCtrlWidth());
            }
            if (DataTypeUtils.getIntegerValue((Object)psDEFormDetail.getCtrlHeight(), (Integer)-1) > 0) {
                objectNode.put("editorHeight", psDEFormDetail.getCtrlHeight());
            }
            if (StringUtils.hasLength((String)(strPSEditorParams = psDEFormDetail.getEditorParams()))) {
                PSEditorListTranspilerEx.setPSEditorParams(iPSModelTranspileContext, domain, objectNode, strPSEditorParams);
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getPSCodeListId())) {
                objectNode.set("getPSAppCodeList", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppCodeList.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getPSCodeListId(), false, null));
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getRefPSDEId())) {
                objectNode.set("getPSAppDataEntity", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppDataEntity.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getRefPSDEId(), false, null));
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getRefPSDEACModeId())) {
                objectNode.set("getPSAppDEACMode", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppDEACMode.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getRefPSDEACModeId(), false, null));
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getRefPSDEDataSetId())) {
                objectNode.set("getPSAppDEDataSet", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppDEDataSet.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getRefPSDEDataSetId(), false, null));
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getValueItemName())) {
                objectNode.put("valueItemName", psDEFormDetail.getValueItemName());
                editorItemMap.put(psDEFormDetail.getValueItemName(), "");
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getPickupPSDEViewId())) {
                objectNode.set("getPickupPSAppView", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppView.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getPickupPSDEViewId(), false, null));
            }
            if (StringUtils.hasLength((String)psDEFormDetail.getLinkPSDEViewId())) {
                objectNode.set("getLinkPSAppView", (JsonNode)iPSModelTranspileContext.getPSModelListTranspiler(IPSAppView.class, false).getModelRef(iPSModelTranspileContext, psDEFormDetail.getLinkPSDEViewId(), false, null));
            }
            if (!ObjectUtils.isEmpty(editorItemMap)) {
                ArrayNode editorItems = objectNode.putArray("getPSEditorItems");
                for (String item : editorItemMap.keySet()) {
                    ObjectNode node = editorItems.addObject();
                    node.put("name", item);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setPSEditorParams(IPSModelTranspileContext ipsModelTranspileContext, IPSModel domain, ObjectNode objectNode, String strPSEditorParams) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strPSEditorParams.getBytes("utf8"));
        Properties properties = new Properties();
        properties.load(inputStream);
        for (Object object : properties.keySet()) {
            String strValue = (String)properties.get(object);
            if (!StringUtils.hasLength((String)strValue)) continue;
            params.put((String)object, new String(strValue.getBytes("ISO-8859-1"), "utf8"));
        }
        ObjectNode editorParamsNode = objectNode.putObject("editorParams");
        for (Map.Entry entry : params.entrySet()) {
            editorParamsNode.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (params.containsKey(EDITORPARAM_VALUETYPE)) {
            objectNode.put("valueType", (String)params.get(EDITORPARAM_VALUETYPE));
        }
        if (params.containsKey(EDITORPARAM_OBJECTIDFIELD)) {
            objectNode.put("objectIdField", (String)params.get(EDITORPARAM_OBJECTIDFIELD));
        }
        if (params.containsKey(EDITORPARAM_OBJECTNAMEFIELD)) {
            objectNode.put("objectNameField", (String)params.get(EDITORPARAM_OBJECTNAMEFIELD));
        }
        if (params.containsKey(EDITORPARAM_OBJECTVALUEFIELD)) {
            objectNode.put("objectValueField", (String)params.get(EDITORPARAM_OBJECTVALUEFIELD));
        }
        if (params.containsKey(EDITORPARAM_VALUESEPARATOR)) {
            objectNode.put("valueSeparator", (String)params.get(EDITORPARAM_VALUESEPARATOR));
        }
        if (params.containsKey(EDITORPARAM_TEXTSEPARATOR)) {
            objectNode.put("textSeparator", (String)params.get(EDITORPARAM_TEXTSEPARATOR));
        }
        if (params.containsKey(EDITORPARAM_MAXLENGTH)) {
            objectNode.put("maxLength", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_MAXLENGTH), null));
        }
        if (params.containsKey(EDITORPARAM_MINLENGTH)) {
            objectNode.put("minLength", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_MINLENGTH), null));
        }
        if (params.containsKey(EDITORPARAM_SHOWMAXLENGTH)) {
            objectNode.put("showMaxLength", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_SHOWMAXLENGTH), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_MAXVALUE)) {
            objectNode.put("maxValue", DataTypeUtils.getDoubleValue(params.get(EDITORPARAM_MAXVALUE), null));
        }
        if (params.containsKey(EDITORPARAM_MINVALUE)) {
            objectNode.put("minValue", DataTypeUtils.getDoubleValue(params.get(EDITORPARAM_MINVALUE), null));
        }
        if (params.containsKey(EDITORPARAM_PRECISION)) {
            objectNode.put("precision", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_PRECISION), null));
        }
        if (params.containsKey(EDITORPARAM_WRAPMODE)) {
            objectNode.put("wrapMode", (String)params.get(EDITORPARAM_WRAPMODE));
        }
        if (params.containsKey(EDITORPARAM_HALIGN)) {
            objectNode.put("hAlign", (String)params.get(EDITORPARAM_HALIGN));
        }
        if (params.containsKey(EDITORPARAM_VALIGN)) {
            objectNode.put("vAlign", (String)params.get(EDITORPARAM_VALIGN));
        }
        if (params.containsKey(EDITORPARAM_AC)) {
            objectNode.put("enableAC", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_AC), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_FORCESELECTION)) {
            objectNode.put("forceSelection", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_FORCESELECTION), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_TRIGGER)) {
            objectNode.put("showTrigger", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_TRIGGER), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_ACMINCHARS)) {
            objectNode.put("aCMinChars", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_ACMINCHARS), null));
        }
        if (params.containsKey(EDITORPARAM_RAWCONTENT)) {
            objectNode.put("rawContent", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_RAWCONTENT), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_OSSCAT)) {
            objectNode.put("oSSCat", (String)params.get(EDITORPARAM_OSSCAT));
        }
        if (params.containsKey(EDITORPARAM_STEPVALUE)) {
            objectNode.put("stepValue", DataTypeUtils.getDoubleValue(params.get(EDITORPARAM_STEPVALUE), null));
        }
        if (params.containsKey(EDITORPARAM_LINKVIEW)) {
            objectNode.put("enableLinkView", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_LINKVIEW), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_MODE)) {
            objectNode.put("mode", (String)params.get(EDITORPARAM_MODE));
        }
        if (params.containsKey(EDITORPARAM_PICKUPVIEW)) {
            objectNode.put("enablePickupView", DataTypeUtils.getBooleanValue(params.get(EDITORPARAM_PICKUPVIEW), (Boolean)false));
        }
        if (params.containsKey(EDITORPARAM_FILEEXTS)) {
            objectNode.put("fileExts", (String)params.get(EDITORPARAM_FILEEXTS));
        }
        if (params.containsKey(EDITORPARAM_MAXFILECNT)) {
            objectNode.put("maxFileCount", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_MAXFILECNT), null));
        }
        if (params.containsKey(EDITORPARAM_MINFILECNT)) {
            objectNode.put("minFileCount", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_MINFILECNT), null));
        }
        if (params.containsKey(EDITORPARAM_MAXFILESIZE)) {
            objectNode.put("maxFileSize", DataTypeUtils.getIntegerValue(params.get(EDITORPARAM_MAXFILESIZE), null));
        }
        if (params.containsKey(EDITORPARAM_TIMEFMT)) {
            objectNode.put("dateTimeFormat", (String)params.get(EDITORPARAM_TIMEFMT));
        }
        if (params.containsKey(EDITORPARAM_CODETYPE)) {
            objectNode.put("codeType", (String)params.get(EDITORPARAM_CODETYPE));
        }
        Object var8_10 = null;
        ArrayNode psNavigateParamArray = null;
        for (Map.Entry entry : params.entrySet()) {
            boolean bRawValue;
            String strKey = (String)entry.getKey();
            String strValue = (String)entry.getValue();
            String strTag = strKey.toUpperCase();
            if (strTag.indexOf(VIEWPARAM_NAVCONTEXT) == 0) {
                void var8_11;
                bRawValue = true;
                strTag = strKey.substring(VIEWPARAM_NAVCONTEXT.length()).toUpperCase();
                if (!ObjectUtils.isEmpty((Object)strValue) && strValue.charAt(0) == '%' && strValue.charAt(strValue.length() - 1) == '%') {
                    strValue = strValue.replace("%", "");
                    bRawValue = false;
                }
                if (var8_11 == null) {
                    ArrayNode arrayNode = objectNode.putArray("getPSNavigateContexts");
                }
                ObjectNode psNavigateContextNode = var8_11.addObject();
                psNavigateContextNode.put("key", strTag);
                psNavigateContextNode.put("name", strTag);
                psNavigateContextNode.put("value", strValue);
                psNavigateContextNode.put("rawValue", bRawValue);
                continue;
            }
            if (strTag.indexOf(VIEWPARAM_NAVPARAM) != 0) continue;
            bRawValue = true;
            strTag = strKey.substring(VIEWPARAM_NAVPARAM.length()).toLowerCase();
            if (!ObjectUtils.isEmpty((Object)strValue) && strValue.charAt(0) == '%' && strValue.charAt(strValue.length() - 1) == '%') {
                strValue = strValue.replace("%", "");
                bRawValue = false;
            }
            if (psNavigateParamArray == null) {
                psNavigateParamArray = objectNode.putArray("getPSNavigateParams");
            }
            ObjectNode psNavigateParamNode = psNavigateParamArray.addObject();
            psNavigateParamNode.put("key", strTag);
            psNavigateParamNode.put("name", strTag);
            psNavigateParamNode.put("value", strValue);
            psNavigateParamNode.put("rawValue", bRawValue);
        }
    }

    static {
        ArrayList<PSEditorType> PSEditorTypes = new ArrayList<PSEditorType>();
        PSEditorTypes.add(new PSEditorType().id("TEXTBOX").validflag(Integer.valueOf(1)).name("\u6587\u672c\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("NUMBER").validflag(Integer.valueOf(1)).name("\u6570\u503c\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("PASSWORD").validflag(Integer.valueOf(1)).name("\u5bc6\u7801\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("HIDDEN").validflag(Integer.valueOf(1)).name("\u9690\u85cf\u8868\u5355\u9879").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("TEXTAREA").validflag(Integer.valueOf(1)).name("\u591a\u884c\u8f93\u5165\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("TEXTAREA_10").validflag(Integer.valueOf(1)).name("\u591a\u884c\u8f93\u5165\u6846\uff0810\u884c\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("TEXTAREA"));
        PSEditorTypes.add(new PSEditorType().id("IPADDRESSTEXTBOX").validflag(Integer.valueOf(1)).name("IP\u5730\u5740\u8f93\u5165\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("RAW").validflag(Integer.valueOf(1)).name("\u76f4\u63a5\u5185\u5bb9").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("STEPPER").validflag(Integer.valueOf(1)).name("\u6b65\u8fdb\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("RATING").validflag(Integer.valueOf(1)).name("\u8bc4\u5206\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("SLIDER").validflag(Integer.valueOf(1)).name("\u6ed1\u52a8\u8f93\u5165\u6761").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("SPAN").validflag(Integer.valueOf(1)).name("\u6807\u7b7e").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("SPANEX").validflag(Integer.valueOf(1)).name("\u6807\u7b7e\uff08\u65e7\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("SPAN"));
        PSEditorTypes.add(new PSEditorType().id("SPAN_LINK").validflag(Integer.valueOf(1)).name("\u6807\u7b7e\uff08\u6570\u636e\u94fe\u63a5\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("SPAN"));
        PSEditorTypes.add(new PSEditorType().id("DROPDOWNLIST").validflag(Integer.valueOf(1)).name("\u4e0b\u62c9\u5217\u8868\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("DROPDOWNLIST_100").validflag(Integer.valueOf(1)).name("\u4e0b\u62c9\u5217\u8868\u6846\uff08100\u5bbd\u5ea6\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DROPDOWNLIST"));
        PSEditorTypes.add(new PSEditorType().id("MDROPDOWNLIST").validflag(Integer.valueOf(1)).name("\u4e0b\u62c9\u5217\u8868\u6846\uff08\u591a\u9009\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("CHECKBOX").validflag(Integer.valueOf(1)).name("\u9009\u9879\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("SWITCH").validflag(Integer.valueOf(1)).name("\u5f00\u5173\u90e8\u4ef6").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("RADIOBUTTONLIST").validflag(Integer.valueOf(1)).name("\u5355\u9009\u9879\u5217\u8868").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("CHECKBOXLIST").validflag(Integer.valueOf(1)).name("\u9009\u9879\u6846\u5217\u8868").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("LISTBOX").validflag(Integer.valueOf(1)).name("\u5217\u8868\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("LISTBOXPICKUP").validflag(Integer.valueOf(1)).name("\u5217\u8868\u6846\uff08\u9009\u62e9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("ADDRESSPICKUP").validflag(Integer.valueOf(1)).name("\u5730\u5740\u6846\uff08\u9009\u62e9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("ADDRESSPICKUP_AC").validflag(Integer.valueOf(1)).name("\u5730\u5740\u6846\uff08\u652f\u6301\u9009\u62e9\u3001AC\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("ADDRESSPICKUP"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08\u65e7\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_NOTIME").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_NODAY").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08HH:mm:ss\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_HOUR").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_MINUTE").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH:mm\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_SECOND").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH:mm:ss\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKEREX_NODAY_NOSECOND").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668\uff08HH:mm\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("DATEPICKER"));
        PSEditorTypes.add(new PSEditorType().id("DATEPICKER").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("PICKER").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_LINK").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u6570\u636e\u94fe\u63a5\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_NOAC").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u65e0AC\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_LINKONLY").validflag(Integer.valueOf(1)).name("\u6570\u636e\u94fe\u63a5").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_NOAC_LINK").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u65e0AC\u3001\u6570\u636e\u94fe\u63a5\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_TRIGGER").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u4e0b\u62c9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_TRIGGER_LINK").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u4e0b\u62c9\u3001\u6570\u636e\u94fe\u63a5\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_NOBUTTON").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u65e0\u6309\u94ae\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_DROPDOWNVIEW").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u4e0b\u62c9\u89c6\u56fe\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id("PICKEREX_DROPDOWNVIEW_LINK").validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u4e0b\u62c9\u89c6\u56fe\u3001\u6570\u636e\u94fe\u63a5\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("PICKER"));
        PSEditorTypes.add(new PSEditorType().id(EDITORPARAM_PICKUPVIEW).validflag(Integer.valueOf(1)).name("\u6570\u636e\u9009\u62e9\uff08\u5d4c\u5165\u9009\u62e9\u89c6\u56fe\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id(EDITORPARAM_AC).validflag(Integer.valueOf(1)).name("\u81ea\u52a8\u586b\u5145").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("AC_FS").validflag(Integer.valueOf(1)).name("\u81ea\u52a8\u586b\u5145\uff08\u53ea\u80fd\u9009\u62e9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor(EDITORPARAM_AC));
        PSEditorTypes.add(new PSEditorType().id("AC_NOBUTTON").validflag(Integer.valueOf(1)).name("\u81ea\u52a8\u586b\u5145\uff08\u65e0\u6309\u94ae\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor(EDITORPARAM_AC));
        PSEditorTypes.add(new PSEditorType().id("AC_FS_NOBUTTON").validflag(Integer.valueOf(1)).name("\u81ea\u52a8\u586b\u5145\uff08\u53ea\u80fd\u9009\u62e9\u3001\u65e0\u6309\u94ae\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor(EDITORPARAM_AC));
        PSEditorTypes.add(new PSEditorType().id("HTMLEDITOR").validflag(Integer.valueOf(1)).name("HTML\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("CODE").validflag(Integer.valueOf(1)).name("\u4ee3\u7801\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MARKDOWN").validflag(Integer.valueOf(1)).name("Markdown\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("OFFICEEDITOR").validflag(Integer.valueOf(1)).name("Office\u6587\u6863\u7f16\u8f91\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("OFFICEEDITOR2").validflag(Integer.valueOf(1)).name("Office\u6587\u6863\u7f16\u8f91\u56682\uff08\u5f39\u51fa\u7f16\u8f91\uff0c\u8fd4\u56de\u5185\u5bb9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("PICTURE").validflag(Integer.valueOf(1)).name("\u56fe\u7247\u63a7\u4ef6").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("PICTURE_ONE").validflag(Integer.valueOf(1)).name("\u56fe\u7247\u63a7\u4ef6\uff08\u5355\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("PICTURE"));
        PSEditorTypes.add(new PSEditorType().id("PICTURE_ONE_RAW").validflag(Integer.valueOf(1)).name("\u56fe\u7247\u63a7\u4ef6\uff08\u5355\u9879\u3001\u76f4\u63a5\u5185\u5bb9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("PICTURE"));
        PSEditorTypes.add(new PSEditorType().id("PREDEFINED").validflag(Integer.valueOf(1)).name("\u9884\u5b9a\u4e49\u7f16\u8f91\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("FILEUPLOADER").validflag(Integer.valueOf(1)).name("\u6587\u4ef6\u63a7\u4ef6").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("FILEUPLOADER_ONE").validflag(Integer.valueOf(1)).name("\u6587\u4ef6\u63a7\u4ef6\uff08\u5355\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("FILEUPLOADER"));
        PSEditorTypes.add(new PSEditorType().id("NUMBERRANGE").validflag(Integer.valueOf(1)).name("\u6570\u503c\u8303\u56f4\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("DATERANGE").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u8303\u56f4\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("DATERANGE_NOTIME").validflag(Integer.valueOf(1)).name("\u65f6\u95f4\u8303\u56f4\u9009\u62e9\u5668\uff08YYYY-MM-DD\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("DATERANGE"));
        PSEditorTypes.add(new PSEditorType().id("CASCADER").validflag(Integer.valueOf(1)).name("\u7ea7\u8054\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("ARRAY").validflag(Integer.valueOf(1)).name("\u6570\u7ec4\u7f16\u8f91\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MAPPICKER").validflag(Integer.valueOf(1)).name("\u5730\u56fe\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("COLORPICKER").validflag(Integer.valueOf(1)).name("\u989c\u8272\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("USERCONTROL").validflag(Integer.valueOf(1)).name("\u7528\u6237\u81ea\u5b9a\u4e49").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBTEXT").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6587\u672c\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBNUMBER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6570\u503c\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBTEXTAREA").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u591a\u884c\u6587\u672c").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBSWITCH").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u5f00\u5173\u90e8\u4ef6").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBBARCODEREADER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6761\u7801\u9605\u8bfb\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBRADIOLIST").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u5355\u9009\u9879\u5217\u8868").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOB2DBARCODEREADER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u4e8c\u7ef4\u7801\u9605\u8bfb\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBDROPDOWNLIST").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u4e0b\u62c9\u5217\u8868\uff08\u5355\u9009\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBCHECKLIST").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u4e0b\u62c9\u5217\u8868\uff08\u591a\u9009\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBPICKER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6570\u636e\u9009\u62e9").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBPICKER_DROPDOWNVIEW").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6570\u636e\u9009\u62e9\uff08\u4e0b\u62c9\u89c6\u56fe\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBMPICKER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u591a\u6570\u636e\u9009\u62e9").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_HOUR").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_MINUTE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH:mm\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_NODAY").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08HH:mm:ss\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_NODAY_NOSECOND").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08HH:mm\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_NOTIME").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBDATE_SECOND").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u9009\u62e9\u5668\uff08YYYY-MM-DD HH:mm:ss\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(1)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATE"));
        PSEditorTypes.add(new PSEditorType().id("MOBPICTURE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u56fe\u7247\u63a7\u4ef6\uff08\u5355\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBSINGLEFILEUPLOAD").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6587\u4ef6\u63a7\u4ef6\uff08\u5355\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBPICTURE_RAW").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u56fe\u7247\u63a7\u4ef6\uff08\u5355\u9879\u3001\u76f4\u63a5\u5185\u5bb9\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("MOBPICTURE"));
        PSEditorTypes.add(new PSEditorType().id("MOBPICTURELIST").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u56fe\u7247\u63a7\u4ef6\uff08\u591a\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBMULTIFILEUPLOAD").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6587\u4ef6\u63a7\u4ef6\uff08\u591a\u9879\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBPASSWORD").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u5bc6\u7801\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBSLIDER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6ed1\u52a8\u8f93\u5165\u6761").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBSTEPPER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6b65\u8fdb\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBRATING").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u8bc4\u5206\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(0)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBHTMLTEXT").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aefHTML\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBCODE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u4ee3\u7801\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBMARKDOWN").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aefMarkdown\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBNUMBERRANGE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6570\u503c\u8303\u56f4\u7f16\u8f91\u6846").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBDATERANGE").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u8303\u56f4\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBDATERANGE_NOTIME").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u65f6\u95f4\u8303\u56f4\u9009\u62e9\u5668\uff08YYYY-MM-DD\uff09").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(0)).standardeditor("MOBDATERANGE"));
        PSEditorTypes.add(new PSEditorType().id("MOBCASCADER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u7ea7\u8054\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBARRAY").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u6570\u7ec4\u7f16\u8f91\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBMAPPICKER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u5730\u56fe\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        PSEditorTypes.add(new PSEditorType().id("MOBCOLORPICKER").validflag(Integer.valueOf(1)).name("\u79fb\u52a8\u7aef\u989c\u8272\u9009\u62e9\u5668").mobfieditor(Integer.valueOf(0)).fieditor(Integer.valueOf(1)).gceditor(Integer.valueOf(0)).standardtype(Integer.valueOf(1)));
        for (PSEditorType psEditorType : PSEditorTypes) {
            PSEditorTypeMap.put(psEditorType.getId(), psEditorType);
        }
    }
}

