/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.model.PSSystemImpl;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDEUIActionGroup;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.app.func.IPSAppFunc;
import net.ibizsys.model.app.view.IPSAppIndexView;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.control.menu.IPSAppMenu;
import net.ibizsys.model.control.menu.IPSAppMenuItem;
import net.ibizsys.model.dataentity.IPSDEGroup;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionGroup;
import net.ibizsys.model.dataentity.datasync.IPSDEDataSync;
import net.ibizsys.model.dataentity.defield.IPSDEFGroup;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERGroup;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.print.IPSDEPrint;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.model.dataentity.report.IPSDEReport;
import net.ibizsys.model.util.merger.IPSModelMergeContext;
import net.ibizsys.model.util.merger.IPSModelMerger;
import net.ibizsys.model.util.merger.PSModelListMergerBase;
import net.ibizsys.model.util.merger.PSModelMergerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSModelMergeUtils {
    private static final Log log = LogFactory.getLog(PSModelMergeUtils.class);
    protected static Map<String, String> IgnoreCheckMethodMap = new HashMap<String, String>();

    public static void merge(IPSModelMergeContext iPSModelMergeContext) throws Exception {
        List psApplications;
        IPSModelMerger iPSModelMerger = PSModelMergerFactory.getInstance().getPSModelMerger(PSSystemImpl.class, false);
        ObjectNode objectNode = (ObjectNode)PSModelListMergerBase.MAPPER.readTree(new File(iPSModelMergeContext.getPSModelFolderPath() + File.separator + "PSSYSTEM.json"));
        ObjectNode mergeObjectNode = (ObjectNode)PSModelListMergerBase.MAPPER.readTree(new File(iPSModelMergeContext.getMergePSModelFolderPath() + File.separator + "PSSYSTEM.json"));
        iPSModelMerger.merge(iPSModelMergeContext, objectNode, mergeObjectNode);
        File modelFile = new File(iPSModelMergeContext.getDstPSModelFolderPath() + File.separator + "PSSYSTEM.json");
        modelFile.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(modelFile);){
            PSModelListMergerBase.MAPPER.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, (Object)objectNode);
        }
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(iPSModelMergeContext.getDstPSModelFolderPath(), false);
        IPSSystem iPSSystem = psModelServiceImpl.getPSSystem();
        List psDataEntityList = iPSSystem.getAllPSDataEntities();
        if (!ObjectUtils.isEmpty((Object)psDataEntityList)) {
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                PSModelMergeUtils.pubPSDataEntityModel(iPSDataEntity, iPSModelMergeContext.getDstPSModelFolderPath());
            }
        }
        if (iPSModelMergeContext.isEnableMergeChild(IPSApplication.class).booleanValue() && !ObjectUtils.isEmpty((Object)(psApplications = iPSSystem.getAllPSApps()))) {
            for (IPSApplication iPSApplication : psApplications) {
                if (!PSModelMergeUtils.buildPSApplicationCache(iPSApplication)) continue;
                modelFile = new File(iPSModelMergeContext.getDstPSModelFolderPath() + File.separator + iPSApplication.getDynaModelFilePath());
                modelFile.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(modelFile);
                Throwable throwable = null;
                try {
                    PSModelListMergerBase.MAPPER.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, (Object)iPSApplication.getObjectNode());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    os.close();
                }
            }
        }
    }

    protected static boolean buildPSApplicationCache(IPSApplication iPSApplication) throws Exception {
        ArrayNode arrayNode;
        if (iPSApplication.getObjectNode().has("cache")) {
            return false;
        }
        LinkedHashMap<String, Object> cachePSAppViewMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, IPSAppDataEntity> cachePSDataEntityMap = new LinkedHashMap<String, IPSAppDataEntity>();
        IPSAppIndexView iPSAppIndexView = iPSApplication.getDefaultPSAppIndexView();
        if (iPSApplication.getDefaultPSAppIndexView() != null) {
            iPSAppIndexView = iPSApplication.getDefaultPSAppIndexView();
        } else {
            List psAppViews = iPSApplication.getAllPSAppViews();
            if (!ObjectUtils.isEmpty((Object)psAppViews)) {
                for (Object iPSAppView : psAppViews) {
                    if (!(iPSAppView instanceof IPSAppIndexView)) continue;
                    iPSAppIndexView = (IPSAppIndexView)iPSAppView;
                    break;
                }
            }
        }
        if (iPSAppIndexView != null) {
            List psAppMenuItems;
            cachePSAppViewMap.put(iPSAppIndexView.getId(), iPSAppIndexView);
            IPSAppMenu defaultPSAppMenu = null;
            List psControls = iPSAppIndexView.getPSControls();
            if (!ObjectUtils.isEmpty((Object)psControls)) {
                for (Object iPSControl : psControls) {
                    if (!(iPSControl instanceof IPSAppMenu)) continue;
                    defaultPSAppMenu = (IPSAppMenu)iPSControl;
                    break;
                }
            }
            if (defaultPSAppMenu != null && !ObjectUtils.isEmpty((Object)(psAppMenuItems = defaultPSAppMenu.getPSAppMenuItems()))) {
                for (IPSAppMenuItem iPSAppMenuItem : psAppMenuItems) {
                    IPSAppFunc iPSAppFunc = iPSAppMenuItem.getPSAppFunc();
                    if (iPSAppFunc == null || iPSAppFunc.getPSAppView() == null) continue;
                    cachePSAppViewMap.put(iPSAppFunc.getPSAppView().getId(), iPSAppFunc.getPSAppView());
                }
            }
        }
        for (IPSAppView iPSAppView : cachePSAppViewMap.values()) {
            IPSAppDataEntity iPSAppDataEntity = iPSAppView.getPSAppDataEntity();
            if (iPSAppDataEntity == null) continue;
            cachePSDataEntityMap.put(iPSAppDataEntity.getId(), iPSAppDataEntity);
        }
        ObjectNode cacheNode = iPSApplication.getObjectNode().putObject("cache");
        if (cachePSAppViewMap != null) {
            arrayNode = cacheNode.putArray("getPSAppViews");
            for (IPSAppView iPSAppView : cachePSAppViewMap.values()) {
                arrayNode.add((JsonNode)iPSAppView.getObjectNode());
            }
        }
        if (cachePSDataEntityMap != null) {
            arrayNode = cacheNode.putArray("getPSAppDataEntities");
            for (IPSAppDataEntity iPSAppDataEntity : cachePSDataEntityMap.values()) {
                arrayNode.add((JsonNode)iPSAppDataEntity.getObjectNode());
            }
        }
        return true;
    }

    protected static void pubPSDataEntityModel(IPSDataEntity iPSDataEntity, String strDstPModelFolderPath) throws Exception {
        List psDEActionGroups;
        List psDERGroups;
        List psDEGroups;
        List psDEFGroups;
        Object psDEDataQueries;
        List psDEUserRoles;
        List psDEReports;
        List psDEPrints;
        List minorPSDERs;
        List majorPSDERs;
        List psDEDataSyncs;
        List psDELogics;
        List psDEActions = iPSDataEntity.getAllPSDEActions();
        if (psDEActions != null) {
            for (IPSDEAction iPSDEAction : psDEActions) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEAction, strDstPModelFolderPath);
            }
        }
        if ((psDELogics = iPSDataEntity.getAllPSDELogics()) != null) {
            for (IPSDELogic iPSDELogic : psDELogics) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDELogic, strDstPModelFolderPath);
            }
        }
        if ((psDEDataSyncs = iPSDataEntity.getAllPSDEDataSyncs()) != null) {
            for (IPSDEDataSync iPSDEDataSync : psDEDataSyncs) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEDataSync, strDstPModelFolderPath);
            }
        }
        if ((majorPSDERs = iPSDataEntity.getMajorPSDERs()) != null) {
            for (IPSDERBase iPSDERBase : majorPSDERs) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDERBase, strDstPModelFolderPath);
            }
        }
        if ((minorPSDERs = iPSDataEntity.getMinorPSDERs()) != null) {
            for (IPSDERBase iPSDERBase : minorPSDERs) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDERBase, strDstPModelFolderPath);
            }
        }
        if ((psDEPrints = iPSDataEntity.getAllPSDEPrints()) != null) {
            for (IPSDEPrint iPSDEPrint : psDEPrints) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEPrint, strDstPModelFolderPath);
            }
        }
        if ((psDEReports = iPSDataEntity.getAllPSDEReports()) != null) {
            for (IPSDEReport iPSDEReport : psDEReports) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEReport, strDstPModelFolderPath);
            }
        }
        if ((psDEUserRoles = iPSDataEntity.getAllPSDEUserRoles()) != null) {
            for (IPSDEUserRole iPSDEUserRole : psDEUserRoles) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEUserRole, strDstPModelFolderPath);
            }
        }
        if ((psDEDataQueries = iPSDataEntity.getAllPSDEDataQueries()) != null) {
            // empty if block
        }
        if ((psDEFGroups = iPSDataEntity.getAllPSDEFGroups()) != null) {
            for (IPSDEFGroup iPSDEFGroup : psDEFGroups) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEFGroup, strDstPModelFolderPath);
            }
        }
        if ((psDEGroups = iPSDataEntity.getAllPSDEGroups()) != null) {
            for (IPSDEGroup iPSDEGroup : psDEGroups) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEGroup, strDstPModelFolderPath);
            }
        }
        if ((psDERGroups = iPSDataEntity.getAllPSDERGroups()) != null) {
            for (IPSDERGroup iPSDERGroup : psDERGroups) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDERGroup, strDstPModelFolderPath);
            }
        }
        if ((psDEActionGroups = iPSDataEntity.getAllPSDEActionGroups()) != null) {
            for (IPSDEActionGroup iPSDEActionGroup : psDEActionGroups) {
                PSModelMergeUtils.pubPSModelObjectModel((IPSModelObject)iPSDEActionGroup, strDstPModelFolderPath);
            }
        }
    }

    protected static void pubPSModelObjectModel(IPSModelObject iPSModelObject, String strDstPModelFolderPath) throws Exception {
        String strDynaModelFilePath = iPSModelObject.getDynaModelFilePath();
        if (!StringUtils.hasLength((String)strDynaModelFilePath)) {
            return;
        }
        File modelFile = new File(strDstPModelFolderPath + File.separator + strDynaModelFilePath);
        modelFile.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(modelFile);){
            PSModelListMergerBase.MAPPER.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, (Object)iPSModelObject.getObjectNode());
        }
    }

    public static void verify(String strPSModelFolderPath) throws Exception {
        long nStart = System.currentTimeMillis();
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strPSModelFolderPath, false);
        IPSSystem iPSSystem = psModelServiceImpl.getPSSystem();
        HashMap<Object, String> map = new HashMap<Object, String>();
        PSModelMergeUtils.verify(iPSSystem, map);
        System.out.print(String.format("\u6821\u9a8c\u8017\u65f6[%1$s]ms\uff0c\u5bf9\u8c61\u6570[%2$s]", System.currentTimeMillis() - nStart, map.size()));
    }

    public static void verify(IPSModelObject iPSModelObject) throws Exception {
        PSModelMergeUtils.verify(iPSModelObject, false);
    }

    public static void verify(IPSModelObject iPSModelObject, boolean bQuick) throws Exception {
        HashMap<Object, String> map = new HashMap<Object, String>();
        PSModelMergeUtils.verify(iPSModelObject, map, bQuick);
    }

    private static void verify(Object iPSModelObject, Map<Object, String> map) throws Exception {
        PSModelMergeUtils.verify(iPSModelObject, map, false);
    }

    private static void verify(Object iPSModelObject, Map<Object, String> map, boolean bQuick) throws Exception {
        String strDynaModelFilePath;
        if (map.containsKey(iPSModelObject)) {
            return;
        }
        if (bQuick && iPSModelObject instanceof IPSModelObject && map.size() != 0 && StringUtils.hasLength((String)(strDynaModelFilePath = ((IPSModelObject)iPSModelObject).getDynaModelFilePath()))) {
            map.put(iPSModelObject, "");
            return;
        }
        map.put(iPSModelObject, "");
        Object[] methods = iPSModelObject.getClass().getMethods();
        if (ObjectUtils.isEmpty((Object[])methods)) {
            return;
        }
        for (Object method : methods) {
            if (((Method)method).getParameterCount() != 0 || IgnoreCheckMethodMap.containsKey(((Method)method).getName()) || ((Method)method).getName().indexOf("Must") == ((Method)method).getName().length() - 4 || !IPSModelObject.class.isAssignableFrom(((Method)method).getDeclaringClass())) continue;
            Object ret = ((Method)method).invoke(iPSModelObject, new Object[0]);
            if (ret == null) continue;
            if (ret instanceof List) {
                List list = (List)ret;
                for (Object item : list) {
                    if (!(item instanceof IPSModelObject)) continue;
                    PSModelMergeUtils.verify(item, map, bQuick);
                }
                continue;
            }
            if (!(ret instanceof IPSModelObject)) continue;
            PSModelMergeUtils.verify(ret, map, bQuick);
        }
    }

    public static <T> void forEach(Object iPSModelObject, Class<T> cls, Consumer<T> consumer) throws Exception {
        HashMap<Object, String> map = new HashMap<Object, String>();
        PSModelMergeUtils.forEach(iPSModelObject, cls, consumer, map);
    }

    private static <T> void forEach(Object iPSModelObject, Class<T> cls, Consumer<T> consumer, Map<Object, String> map) throws Exception {
        Object[] methods;
        if (map.containsKey(iPSModelObject)) {
            return;
        }
        map.put(iPSModelObject, "");
        if (cls.isAssignableFrom(iPSModelObject.getClass())) {
            consumer.accept(iPSModelObject);
        }
        if (ObjectUtils.isEmpty((Object[])(methods = iPSModelObject.getClass().getMethods()))) {
            return;
        }
        for (Object method : methods) {
            if (((Method)method).getParameterCount() != 0 || IgnoreCheckMethodMap.containsKey(((Method)method).getName()) || ((Method)method).getName().indexOf("Must") == ((Method)method).getName().length() - 4 || !IPSModelObject.class.isAssignableFrom(((Method)method).getDeclaringClass())) continue;
            Object ret = ((Method)method).invoke(iPSModelObject, new Object[0]);
            if (ret == null) continue;
            if (ret instanceof List) {
                List list = (List)ret;
                for (Object item : list) {
                    if (!(item instanceof IPSModelObject)) continue;
                    PSModelMergeUtils.forEach(item, cls, consumer, map);
                }
                continue;
            }
            if (!(ret instanceof IPSModelObject)) continue;
            PSModelMergeUtils.forEach(ret, cls, consumer, map);
        }
    }

    public static void mergeCloudSubApp(String strPSModelFolderPath, String strMergePSModelFolderPath, String strAppCodeName) throws Exception {
        ObjectNode objectNode;
        JsonNode allPSAppDEUIActionGroupsNode;
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strPSModelFolderPath, false);
        IPSSystem iPSSystem = psModelServiceImpl.getPSSystem();
        IPSApplication iPSApplication = null;
        IPSApplication mergePSApplication = null;
        List list = iPSSystem.getAllPSApps();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (IPSApplication item : list) {
                if (!strAppCodeName.equals(item.getCodeName())) continue;
                iPSApplication = item;
                break;
            }
        }
        if (iPSApplication == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5e94\u7528[%1$s]", strAppCodeName));
        }
        String strModelPath = String.format("%1$s%2$sPSSYSAPPS%2$s%3$s%2$sPSSYSAPP.hubsubapp.json", strMergePSModelFolderPath, File.separator, strAppCodeName);
        File hubsubappFile = new File(strModelPath);
        if (hubsubappFile.exists() && (allPSAppDEUIActionGroupsNode = (objectNode = (ObjectNode)PSModelListMergerBase.MAPPER.readTree(hubsubappFile)).get("getAllPSAppDEUIActionGroups")) instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)allPSAppDEUIActionGroupsNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode psAppDEUIActionGroupNode = (ObjectNode)arrayNode.get(i);
                JsonNode uniqueTagNode = psAppDEUIActionGroupNode.get("uniqueTag");
                if (uniqueTagNode == null || !StringUtils.hasLength((String)uniqueTagNode.asText())) continue;
                final String strUniqueId = uniqueTagNode.asText();
                PSModelMergeUtils.forEach(iPSApplication, IPSAppDEUIActionGroup.class, new Consumer<IPSAppDEUIActionGroup>(){

                    @Override
                    public void accept(IPSAppDEUIActionGroup t) {
                        if (strUniqueId.equals(t.getUniqueTag())) {
                            System.out.println(t);
                        }
                    }
                });
            }
        }
        PSModelServiceImpl mergePSModelServiceImpl = new PSModelServiceImpl();
        mergePSModelServiceImpl.setPSModelFolderPath(strMergePSModelFolderPath, false);
        IPSSystem mergePSSystem = mergePSModelServiceImpl.getPSSystem();
        list = mergePSSystem.getAllPSApps();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (IPSApplication item : list) {
                if (!strAppCodeName.equalsIgnoreCase(item.getCodeName())) continue;
                mergePSApplication = item;
                break;
            }
        }
        if (mergePSApplication == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5408\u5165\u5e94\u7528[%1$s]", strAppCodeName));
        }
    }

    static {
        IgnoreCheckMethodMap.put("getKeyPSDEServiceAPIField", "");
    }
}

