package net.ibizsys.model.util.transpiler.extend.dataentity.logic;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSDELLCond;
import net.ibizsys.psmodel.core.domain.PSDELogicLink;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDELogicLinkListTranspilerEx extends net.ibizsys.model.util.transpiler.dataentity.logic.PSDELogicLinkListTranspiler{
	
	/**
	 * 常规连接
	 */
	public final static int LINKMODE_COMMON = 0;
	
	/**
	 * 默认连接
	 */
	public final static int LINKMODE_DEFAULT = 1;
	
	
	/**
	 * 异常连接
	 */
	public final static int LINKMODE_CATCH = 9;
	
	
	/**
	 * 子调用
	 */
	public final static int LINKMODE_SUBCALL = 10;
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		
		IPSDELogicLink iPSDELogicLink = (IPSDELogicLink)iPSModelObject;
		PSDELogicLink psDELogicLink = (PSDELogicLink)domain;
		if(iPSDELogicLink.isSubCallLink()) {
			psDELogicLink.setDefaultLink(LINKMODE_SUBCALL);
		}
		else
			if(iPSDELogicLink.isCatchLink()) {
				psDELogicLink.setDefaultLink(LINKMODE_CATCH);
			}
			else
				if(iPSDELogicLink.isDefaultLink()) {
					psDELogicLink.setDefaultLink(LINKMODE_DEFAULT);
				}
				else
					psDELogicLink.setDefaultLink(LINKMODE_COMMON);
		
		if(bFullMode) {
			if(iPSDELogicLink.getPSDELogicLinkGroupCond()!=null && iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds()!=null) {
				int nOrder = 100;
				iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLinkCond.class, false).decompile(iPSModelTranspileContext, iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds(), psDELogicLink.getPSDELLCondsIf(), bFullMode);
				for(PSDELLCond child : psDELogicLink.getPSDELLCondsIf()) {
					child.setPSDELogicLinkId(psDELogicLink.getId());
					child.setPSDELogicLinkName(psDELogicLink.getName());
					child.setOrderValue(nOrder);
					nOrder += 100;
				}
			}
		}
	}
	
	
}