package net.ibizsys.model.util.transpiler.extend.dataentity.defield;

import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums.DEFDataType;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.defield.IPSFormulaDEField;
import net.ibizsys.model.dataentity.defield.IPSInheritDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2ManyDataDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2ManyObjDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2OneDataDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2OneObjDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDataDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupObjectDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupTextDEField;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.IPSModelTranspiler;
import net.ibizsys.psmodel.core.domain.PSDEField;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDEFieldListTranspilerEx extends net.ibizsys.model.util.transpiler.dataentity.defield.PSDEFieldListTranspiler{
	
	
	
	@Override
	protected IPSModelTranspiler getPSModelTranspiler(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject) throws Exception {
		if(iPSModelObject instanceof IPSFormulaDEField) {
			
			if(iPSModelObject instanceof IPSOne2ManyDataDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSFormulaOne2ManyDataDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSOne2ManyObjDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSFormulaOne2ManyObjDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSOne2OneDataDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSFormulaOne2ManyObjDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSOne2OneObjDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSFormulaOne2OneObjDEFieldImpl.class, false);
			}
			
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSFormulaDEFieldImpl.class, false);
		}
		
		if(iPSModelObject instanceof IPSLinkDEField) {
			
			if(iPSModelObject instanceof IPSPickupTextDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSPickupTextDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSPickupDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSPickupDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSPickupObjectDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSPickupObjectDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSPickupDataDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSPickupDataDEFieldImpl.class, false);
			}
			
			if(iPSModelObject instanceof IPSInheritDEField) {
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSInheritDEFieldImpl.class, false);
			}
			
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSLinkDEFieldImpl.class, false);
		}

		if(iPSModelObject instanceof IPSOne2ManyDataDEField) {
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSOne2ManyDataDEFieldImpl.class, false);
		}
		
		if(iPSModelObject instanceof IPSOne2ManyObjDEField) {
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSOne2ManyObjDEFieldImpl.class, false);
		}
		
		if(iPSModelObject instanceof IPSOne2OneDataDEField) {
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSOne2ManyObjDEFieldImpl.class, false);
		}
		
		if(iPSModelObject instanceof IPSOne2OneObjDEField) {
			return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.dataentity.defield.PSOne2OneObjDEFieldImpl.class, false);
		}
		
		return super.getPSModelTranspiler(iPSModelTranspileContext, iPSModelObject);
	}
	
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		
		PSDEField psDEField = (PSDEField)domain;
		if(StringUtils.hasLength(psDEField.getPSDataTypeId())) {
			psDEField.setPSDataTypeName(DEFDataType.from(psDEField.getPSDataTypeId()).text);
		}
		
		if(iPSModelObject.getParentPSModelObject()!=null) {
			domain.set("psdeid", PSModelUtils.calcFullUniqueTag(iPSModelObject.getParentPSModelObject()));
			domain.set("psdename", iPSModelObject.getParentPSModelObject().getName());
		}
	}
}