package net.ibizsys.model.util.transpiler.control.tree;



import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.IPSModelTranspiler;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDETreeNodeListTranspiler extends net.ibizsys.model.util.transpiler.PSModelListTranspilerBase{

	@Override
	protected net.ibizsys.psmodel.core.domain.PSDETreeNode createDomain(IPSModelObject iPSModelObject) throws Exception{
		return new net.ibizsys.psmodel.core.domain.PSDETreeNode();
	}

	protected IPSModelTranspiler getPSModelTranspiler(IPSModelTranspileContext iPSModelTranspileContext, Object type) throws Exception {
		String strTypeValue = (type == null)?"":type.toString();
		switch(strTypeValue){
			case "CODELIST":
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.control.tree.PSDETreeCodeListNodeImpl.class, false);
			case "DE":
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.control.tree.PSDETreeDataSetNodeImpl.class, false);
			case "STATIC":
				return iPSModelTranspileContext.getPSModelTranspiler(net.ibizsys.model.control.tree.PSDETreeStaticNodeImpl.class, false);
			default:
				throw new Exception("未提供默认模型合并器");
		}
	}
	
	@Override
	protected IPSModelTranspiler getPSModelTranspiler(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject) throws Exception {
		net.ibizsys.model.control.tree.IPSDETreeNode iPSDETreeNode = (net.ibizsys.model.control.tree.IPSDETreeNode)iPSModelObject;
		Object type = iPSDETreeNode.getTreeNodeType();
		return getPSModelTranspiler(iPSModelTranspileContext, type);
	}
	
	@Override
	protected IPSModelTranspiler getPSModelTranspiler(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain) throws Exception {
		Object type = domain.get("treenodetype");
		return getPSModelTranspiler(iPSModelTranspileContext, type);
	}
}