package net.ibizsys.model.util.transpiler.control.counter;



import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.util.IPSModel;
import static net.ibizsys.model.control.counter.PSSysCounterImpl.*;



public class PSSysCounterTranspiler extends net.ibizsys.model.util.transpiler.PSModelTranspilerBase{

	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		if(!(iPSModelObject instanceof net.ibizsys.model.control.counter.PSSysCounterImpl)){
			super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
			return;
			
		}
		net.ibizsys.model.control.counter.PSSysCounterImpl realPSModelObject = (net.ibizsys.model.control.counter.PSSysCounterImpl)iPSModelObject;
		this.setDomainValue(iPSModelTranspileContext, domain, "countertype", realPSModelObject.getCounterType(), realPSModelObject, "getCounterType");
		this.setDomainValue(iPSModelTranspileContext, domain, "reloadtimer", realPSModelObject.getTimer(), realPSModelObject, "getTimer");
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
	}
	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETCOUNTERTYPE, domain, "countertype", java.lang.String.class);
		this.setModelValue(iPSModelTranspileContext, objectNode, ATTR_GETTIMER, domain, "reloadtimer", int.class, new String[]{"0","-1"});
		super.onCompile(iPSModelTranspileContext, domain, objectNode);
	}
}