/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler.extend.control;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.calendar.IPSSysCalendar;
import net.ibizsys.model.control.chart.IPSDEChart;
import net.ibizsys.model.control.dashboard.IPSDashboard;
import net.ibizsys.model.control.dataview.IPSDEDataView;
import net.ibizsys.model.control.drctrl.IPSDEDRBar;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDEFormDetail;
import net.ibizsys.model.control.form.IPSDEFormItemUpdate;
import net.ibizsys.model.control.form.IPSDEFormItemVR;
import net.ibizsys.model.control.form.IPSDESearchForm;
import net.ibizsys.model.control.grid.IPSDEGrid;
import net.ibizsys.model.control.grid.IPSDEGridColumn;
import net.ibizsys.model.control.list.IPSDEList;
import net.ibizsys.model.control.map.IPSSysMap;
import net.ibizsys.model.control.panel.IPSPanel;
import net.ibizsys.model.control.toolbar.IPSDEContextMenu;
import net.ibizsys.model.control.toolbar.IPSDEToolbar;
import net.ibizsys.model.control.toolbar.IPSDEToolbarItem;
import net.ibizsys.model.control.tree.IPSDETree;
import net.ibizsys.model.control.tree.IPSDETreeColumn;
import net.ibizsys.model.control.tree.IPSDETreeNode;
import net.ibizsys.model.control.tree.IPSDETreeNodeRS;
import net.ibizsys.model.control.wizardpanel.IPSDEStateWizardPanel;
import net.ibizsys.model.control.wizardpanel.IPSWizardPanel;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.control.PSControlListTranspiler;
import net.ibizsys.psmodel.core.domain.PSDEChart;
import net.ibizsys.psmodel.core.domain.PSDEDataRelation;
import net.ibizsys.psmodel.core.domain.PSDEDataView;
import net.ibizsys.psmodel.core.domain.PSDEFIUpdate;
import net.ibizsys.psmodel.core.domain.PSDEForm;
import net.ibizsys.psmodel.core.domain.PSDEFormDetail;
import net.ibizsys.psmodel.core.domain.PSDEGrid;
import net.ibizsys.psmodel.core.domain.PSDEGridCol;
import net.ibizsys.psmodel.core.domain.PSDEList;
import net.ibizsys.psmodel.core.domain.PSDETBItem;
import net.ibizsys.psmodel.core.domain.PSDEToolbar;
import net.ibizsys.psmodel.core.domain.PSDETreeNode;
import net.ibizsys.psmodel.core.domain.PSDETreeView;
import net.ibizsys.psmodel.core.domain.PSDEWizard;
import net.ibizsys.psmodel.core.domain.PSSysDashboard;
import net.ibizsys.psmodel.core.domain.PSSysMapView;
import net.ibizsys.psmodel.core.domain.PSSysViewPanel;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import org.springframework.util.StringUtils;

public class PSControlListTranspilerEx
extends PSControlListTranspiler {
    @Override
    protected IPSModel createDomain(IPSModelObject iPSModelObject) throws Exception {
        if (iPSModelObject instanceof IPSDashboard) {
            return new PSSysDashboard();
        }
        if (iPSModelObject instanceof IPSDEForm) {
            return new PSDEForm();
        }
        if (iPSModelObject instanceof IPSDEGrid) {
            return new PSDEGrid();
        }
        if (iPSModelObject instanceof IPSPanel) {
            return new PSSysViewPanel();
        }
        if (iPSModelObject instanceof IPSDEToolbar || iPSModelObject instanceof IPSDEContextMenu) {
            return new PSDEToolbar();
        }
        if (iPSModelObject instanceof IPSSysCalendar) {
            return new PSSysDashboard();
        }
        if (iPSModelObject instanceof IPSDEChart) {
            return new PSDEChart();
        }
        if (iPSModelObject instanceof IPSDEDataView) {
            return new PSDEDataView();
        }
        if (iPSModelObject instanceof IPSDEDRBar) {
            return new PSDEDataRelation();
        }
        if (iPSModelObject instanceof IPSDETree) {
            return new PSDETreeView();
        }
        if (iPSModelObject instanceof IPSDEList) {
            return new PSDEList();
        }
        if (iPSModelObject instanceof IPSSysMap) {
            return new PSSysMapView();
        }
        if (iPSModelObject instanceof IPSWizardPanel || iPSModelObject instanceof IPSDEStateWizardPanel) {
            return new PSDEWizard();
        }
        return super.createDomain(iPSModelObject);
    }

    @Override
    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        IPSControl iPSControl = (IPSControl)iPSModelObject;
        if (StringUtils.hasLength((String)iPSControl.getLogicName())) {
            domain.setName(iPSControl.getLogicName());
        }
        if (iPSModelObject instanceof IPSDEForm) {
            IPSDEForm iPSDEForm = (IPSDEForm)iPSModelObject;
            PSDEForm psDEForm = (PSDEForm)domain;
            this.doDecompile(iPSModelTranspileContext, iPSDEForm, psDEForm, bFullMode);
            return;
        }
        if (iPSModelObject instanceof IPSDEToolbar) {
            IPSDEToolbar iPSDEToolbar = (IPSDEToolbar)iPSModelObject;
            PSDEToolbar psDEToolbar = (PSDEToolbar)domain;
            if (bFullMode && iPSDEToolbar.getPSDEToolbarItems() != null) {
                int nOrder = 100;
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDEToolbarItem.class, false).decompile(iPSModelTranspileContext, iPSDEToolbar.getPSDEToolbarItems(), psDEToolbar.getPSDETBItemsIf(), bFullMode);
                for (PSDETBItem child : psDEToolbar.getPSDETBItemsIf()) {
                    child.setPSDEToolbarId(psDEToolbar.getId());
                    child.setPSDEToolbarName(psDEToolbar.getName());
                    child.setOrderValue(Integer.valueOf(nOrder));
                    nOrder += 100;
                }
            }
            return;
        }
        if (iPSModelObject instanceof IPSDEGrid) {
            IPSDEGrid iPSDEGrid = (IPSDEGrid)iPSModelObject;
            PSDEGrid psDEGrid = (PSDEGrid)domain;
            if (bFullMode && iPSDEGrid.getPSDEGridColumns() != null) {
                int nOrder = 100;
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDEGridColumn.class, false).decompile(iPSModelTranspileContext, iPSDEGrid.getPSDEGridColumns(), psDEGrid.getPSDEGridColsIf(), bFullMode);
                for (PSDEGridCol child : psDEGrid.getPSDEGridColsIf()) {
                    child.setPSDEGridId(psDEGrid.getId());
                    child.setPSDEGridName(psDEGrid.getName());
                    child.setOrderValue(Integer.valueOf(nOrder));
                    nOrder += 100;
                }
            }
            return;
        }
        if (iPSModelObject instanceof IPSDETree) {
            IPSDETree iPSDETree = (IPSDETree)iPSModelObject;
            PSDETreeView psDETreeView = (PSDETreeView)domain;
            if (bFullMode) {
                int nOrder;
                if (iPSDETree.getPSDETreeNodes() != null) {
                    nOrder = 100;
                    iPSModelTranspileContext.getPSModelListTranspiler(IPSDETreeNode.class, false).decompile(iPSModelTranspileContext, iPSDETree.getPSDETreeNodes(), psDETreeView.getPSDETreeNodesIf(), bFullMode);
                    for (PSDETreeNode child : psDETreeView.getPSDETreeNodesIf()) {
                        child.setPSDETreeViewId(psDETreeView.getId());
                        child.setPSDETreeViewName(psDETreeView.getName());
                        nOrder += 100;
                    }
                }
                if (iPSDETree.getPSDETreeNodeRSs() != null) {
                    nOrder = 100;
                    iPSModelTranspileContext.getPSModelListTranspiler(IPSDETreeNodeRS.class, false).decompile(iPSModelTranspileContext, iPSDETree.getPSDETreeNodeRSs(), psDETreeView.getPSDETreeNodeRsIf(), bFullMode);
                    for (PSDETreeNode child : psDETreeView.getPSDETreeNodeRsIf()) {
                        child.setPSDETreeViewId(psDETreeView.getId());
                        child.setPSDETreeViewName(psDETreeView.getName());
                        child.setOrderValue(Integer.valueOf(nOrder));
                        nOrder += 100;
                    }
                }
                if (iPSDETree.getPSDETreeColumns() != null) {
                    nOrder = 100;
                    iPSModelTranspileContext.getPSModelListTranspiler(IPSDETreeColumn.class, false).decompile(iPSModelTranspileContext, iPSDETree.getPSDETreeColumns(), psDETreeView.getPSDETreeColsIf(), bFullMode);
                    for (PSDETreeNode child : psDETreeView.getPSDETreeColsIf()) {
                        child.setPSDETreeViewId(psDETreeView.getId());
                        child.setPSDETreeViewName(psDETreeView.getName());
                        child.setOrderValue(Integer.valueOf(nOrder));
                        nOrder += 100;
                    }
                }
            }
            return;
        }
    }

    protected void doDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSDEForm iPSDEForm, PSDEForm psDEForm, boolean bFullMode) throws Exception {
        if (iPSDEForm instanceof IPSDESearchForm) {
            psDEForm.formtype(PSModelEnums.FormType.SEARCHFORM);
        } else {
            psDEForm.formtype(PSModelEnums.FormType.EDITFORM);
        }
        if (bFullMode) {
            int nOrder;
            if (iPSDEForm.getPSDEFormPages() != null) {
                nOrder = 100;
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEForm.getPSDEFormPages(), psDEForm.getPSDEFormDetailsIf(), bFullMode);
                for (PSDEFormDetail child : psDEForm.getPSDEFormDetailsIf()) {
                    child.setPSDEFormId(psDEForm.getId());
                    child.setPSDEFormName(psDEForm.getName());
                    child.setOrderValue(Integer.valueOf(nOrder));
                    nOrder += 100;
                }
            }
            if (iPSDEForm.getPSDEFormItemUpdates() != null) {
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormItemUpdate.class, false).decompile(iPSModelTranspileContext, iPSDEForm.getPSDEFormItemUpdates(), psDEForm.getPSDEFIUpdatesIf(), bFullMode);
                for (PSDEFIUpdate child : psDEForm.getPSDEFIUpdatesIf()) {
                    child.setPSDEFormId(psDEForm.getId());
                    child.setPSDEFormName(psDEForm.getName());
                }
            }
            if (iPSDEForm.getPSDEFormItemVRs() != null) {
                nOrder = 100;
                iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormItemVR.class, false).decompile(iPSModelTranspileContext, iPSDEForm.getPSDEFormItemVRs(), psDEForm.getPSDEFIVRsIf(), bFullMode);
                for (PSDEFormDetail child : psDEForm.getPSDEFIVRsIf()) {
                    child.setPSDEFormId(psDEForm.getId());
                    child.setPSDEFormName(psDEForm.getName());
                    child.setOrderValue(Integer.valueOf(nOrder));
                    nOrder += 100;
                }
            }
        }
    }

    @Override
    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        super.onCompile(iPSModelTranspileContext, domain, objectNode);
    }
}

