/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspiler;

public abstract class PSModelTranspilerFactoryBase {
    private Map<Class<?>, IPSModelTranspiler> psModelTranspilerMap = new HashMap();
    private Map<Class<?>, IPSModelListTranspiler> psModelListTranspilerMap = new HashMap();
    private Map<Class<?>, Class<?>> psModelTranspilerClsMap = new HashMap();
    private Map<Class<?>, Class<?>> psModelListTranspilerClsMap = new HashMap();

    public void registerPSModelTranspiler(Class<?> cls, IPSModelTranspiler iPSModelTranspiler) {
        this.psModelTranspilerMap.put(cls, iPSModelTranspiler);
    }

    public void registerPSModelListTranspiler(Class<?> cls, IPSModelListTranspiler iPSModelListTranspiler) {
        this.psModelListTranspilerMap.put(cls, iPSModelListTranspiler);
    }

    public void registerPSModelTranspiler(Class<?> cls, Class<?> psModelTranspilerCls) {
        this.psModelTranspilerClsMap.put(cls, psModelTranspilerCls);
    }

    public void registerPSModelListTranspiler(Class<?> cls, Class<?> psModelListTranspilerCls) {
        this.psModelListTranspilerClsMap.put(cls, psModelListTranspilerCls);
    }

    public IPSModelTranspiler getPSModelTranspiler(Class<?> cls, boolean bTryMode) throws Exception {
        IPSModelTranspiler iPSModelTranspiler = this.psModelTranspilerMap.get(cls);
        if (iPSModelTranspiler == null) {
            iPSModelTranspiler = this.psModelListTranspilerMap.get(cls);
        }
        if (iPSModelTranspiler != null || bTryMode) {
            return iPSModelTranspiler;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b[%1$s]\u5408\u5e76\u5668", cls.getName()));
    }

    public IPSModelListTranspiler getPSModelListTranspiler(Class<?> cls, boolean bTryMode) throws Exception {
        IPSModelListTranspiler iPSModelListTranspiler = this.psModelListTranspilerMap.get(cls);
        if (iPSModelListTranspiler != null || bTryMode) {
            return iPSModelListTranspiler;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b[%1$s]\u5217\u8868\u5408\u5e76\u5668", cls.getName()));
    }
}

