/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.StringJoiner;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.dataentity.IPSAppDEField;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.IPSModelTranspiler;
import net.ibizsys.psmodel.core.util.IPSModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSModelTranspilerBase
implements IPSModelTranspiler {
    private static final Log log = LogFactory.getLog(PSModelTranspilerBase.class);

    @Override
    public IPSModel decompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        Assert.notNull((Object)iPSModelTranspileContext, (String)"\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSModelObject, (String)"\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)domain, (String)"\u57df\u5bf9\u8c61\u65e0\u6548");
        this.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
        return domain;
    }

    protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
        if (StringUtils.hasLength((String)iPSModelObject.getName())) {
            domain.setName(iPSModelObject.getName());
        }
        if (StringUtils.hasLength((String)iPSModelObject.getMemo())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "memo", iPSModelObject.getMemo(), iPSModelObject, "getMemo");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getCodeName())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "codename", iPSModelObject.getCodeName(), iPSModelObject, "getCodeName");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getUserCat())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "usercat", iPSModelObject.getUserCat(), iPSModelObject, "getUserCat");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getUserTag())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "usertag", iPSModelObject.getUserTag(), iPSModelObject, "getUserTag");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getUserTag2())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "usertag2", iPSModelObject.getUserTag2(), iPSModelObject, "getUserTag2");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getUserTag3())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "usertag3", iPSModelObject.getUserTag3(), iPSModelObject, "getUserTag3");
        }
        if (StringUtils.hasLength((String)iPSModelObject.getUserTag4())) {
            this.setDomainValue(iPSModelTranspileContext, domain, "usertag4", iPSModelObject.getUserTag4(), iPSModelObject, "getUserTag4");
        }
    }

    protected void setDomainValue(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, String strPropertyName, Object objValue, IPSModelObject iPSModelObject, String strMethodName) throws Exception {
        this.setDomainValue(iPSModelTranspileContext, domain, strPropertyName, objValue, iPSModelObject, strMethodName, null);
    }

    protected void setDomainValue(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, String strPropertyName, Object objValue, IPSModelObject iPSModelObject, String strMethodName, String[] ignoreValues) throws Exception {
        if (objValue == null) {
            return;
        }
        if (objValue instanceof Boolean) {
            domain.set(strPropertyName, (Object)((Boolean)objValue != false ? 1 : 0));
            return;
        }
        if (objValue instanceof IPSModelObject) {
            IPSModelObject realPSModelObject = this.getRealPSModelObject((IPSModelObject)objValue);
            if (realPSModelObject != null) {
                domain.set(strPropertyName, (Object)iPSModelTranspileContext.getPSModelUniqueTag(realPSModelObject));
                if (strPropertyName.lastIndexOf("id") == strPropertyName.length() - 2) {
                    domain.set(strPropertyName.substring(0, strPropertyName.length() - 2) + "name", (Object)realPSModelObject.getName());
                }
            }
            return;
        }
        if (ignoreValues != null) {
            String strValue = objValue.toString();
            for (String strItem : ignoreValues) {
                if (!strItem.equals(strValue)) continue;
                return;
            }
        }
        domain.set(strPropertyName, objValue);
    }

    protected void setDomainListValue(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, String strPropertyName, Object objValue, IPSModelObject iPSModelObject, String strMethodName, Class<?> cls) throws Exception {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return;
        }
        if (objValue instanceof List) {
            List list = (List)objValue;
            StringJoiner sj = new StringJoiner(";");
            for (Object o : list) {
                sj.add(String.valueOf(o));
            }
            domain.set(strPropertyName, (Object)sj.toString());
            return;
        }
        log.error((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u7ec4\u503c\u5bf9\u8c61[%1$s]", objValue));
    }

    protected IPSModelObject getRealPSModelObject(IPSModelObject iPSModelObject) {
        if (iPSModelObject instanceof IPSAppDEField) {
            IPSAppDataEntity iPSAppDataEntity = (IPSAppDataEntity)iPSModelObject.getParentPSModelObject(IPSAppDataEntity.class, false);
            if (iPSAppDataEntity.getPSDataEntity() != null) {
                return iPSAppDataEntity.getPSDataEntity().getPSDEField((Object)iPSModelObject.getId(), false);
            }
            return null;
        }
        return iPSModelObject;
    }

    @Override
    public ObjectNode compile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        Assert.notNull((Object)iPSModelTranspileContext, (String)"\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)domain, (String)"\u57df\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)objectNode, (String)"\u6a21\u578b\u8282\u70b9\u65e0\u6548");
        this.onCompile(iPSModelTranspileContext, domain, objectNode);
        return objectNode;
    }

    protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
        String value;
        String codeName;
        String name;
        if (!objectNode.has("name") && StringUtils.hasLength((String)(name = domain.getName()))) {
            objectNode.put("name", name);
        }
        if (!objectNode.has("codeName") && StringUtils.hasLength((String)(codeName = (String)domain.get("codename")))) {
            objectNode.put("codeName", codeName);
        }
        if (!objectNode.has("userCat") && StringUtils.hasLength((String)(value = (String)domain.get("usercat")))) {
            objectNode.put("userCat", value);
        }
        if (!objectNode.has("userTag") && StringUtils.hasLength((String)(value = (String)domain.get("usertag")))) {
            objectNode.put("userTag", value);
        }
        if (!objectNode.has("userTag2") && StringUtils.hasLength((String)(value = (String)domain.get("usertag2")))) {
            objectNode.put("userTag2", value);
        }
        if (!objectNode.has("userTag3") && StringUtils.hasLength((String)(value = (String)domain.get("usertag3")))) {
            objectNode.put("userTag3", value);
        }
        if (!objectNode.has("userTag4") && StringUtils.hasLength((String)(value = (String)domain.get("usertag4")))) {
            objectNode.put("userTag4", value);
        }
    }

    protected void setModelValue(IPSModelTranspileContext iPSModelTranspileContext, ObjectNode objectNode, String strPropertyName, IPSModel iPSModel, String strFieldName, Class<?> cls) throws Exception {
        this.setModelValue(iPSModelTranspileContext, objectNode, strPropertyName, iPSModel, strFieldName, cls, null);
    }

    protected void setModelValue(IPSModelTranspileContext iPSModelTranspileContext, ObjectNode objectNode, String strPropertyName, IPSModel iPSModel, String strFieldName, Class<?> cls, String[] ignoreValues) throws Exception {
        Object objValue = iPSModel.get(strFieldName);
        this.setModelValue(iPSModelTranspileContext, objectNode, strPropertyName, objValue, cls, ignoreValues);
    }

    protected void setModelValue(IPSModelTranspileContext iPSModelTranspileContext, ObjectNode objectNode, String strPropertyName, Object objValue, Class<?> cls, String[] ignoreValues) throws Exception {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return;
        }
        if (ignoreValues != null) {
            if (Boolean.class.isAssignableFrom(cls) || Boolean.TYPE.isAssignableFrom(cls)) {
                objValue = DataTypeUtils.getBooleanValue((Object)objValue, null);
            }
            String strValue = objValue.toString();
            for (String strItem : ignoreValues) {
                if (!strItem.equals(strValue)) continue;
                return;
            }
        }
        if (String.class.isAssignableFrom(cls)) {
            objValue = DataTypeUtils.getStringValue((Object)objValue, null);
            objectNode.put(strPropertyName, (String)objValue);
            return;
        }
        if (Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls)) {
            objValue = DataTypeUtils.getIntegerValue((Object)objValue, null);
            objectNode.put(strPropertyName, (Integer)objValue);
            return;
        }
        if (Boolean.class.isAssignableFrom(cls) || Boolean.TYPE.isAssignableFrom(cls)) {
            objValue = DataTypeUtils.getBooleanValue((Object)objValue, null);
            objectNode.put(strPropertyName, (Boolean)objValue);
            return;
        }
        if (Double.class.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls)) {
            objValue = DataTypeUtils.getDoubleValue((Object)objValue, null);
            objectNode.put(strPropertyName, (Double)objValue);
            return;
        }
        if (Float.class.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls)) {
            objValue = DataTypeUtils.getFloatValue((Object)objValue, null);
            objectNode.put(strPropertyName, (Float)objValue);
            return;
        }
        objectNode.put(strPropertyName, objValue.toString());
        log.error((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u503c\u5bf9\u8c61[%1$s]", objValue));
    }

    protected void setModelValue(IPSModelTranspileContext iPSModelTranspileContext, ObjectNode objectNode, String strPropertyName, IPSModel iPSModel, String strFieldName, Class<? extends IPSModelObject> cls, boolean childMode) throws Exception {
        Object objValue = iPSModel.get(strFieldName);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return;
        }
        iPSModelTranspileContext.getPSModelListTranspiler(cls, false).getModelRef(objValue.toString(), childMode, objectNode.putObject(strPropertyName));
    }

    protected void setModelListValue(IPSModelTranspileContext iPSModelTranspileContext, ObjectNode objectNode, String strPropertyName, IPSModel iPSModel, String strFieldName, Class<?> cls) throws Exception {
        Object objValue = iPSModel.get(strFieldName);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return;
        }
        String strValue = objValue.toString();
        String[] items = strValue.split("[;,]");
        if (String.class.isAssignableFrom(cls)) {
            ArrayNode arrayNode = objectNode.putArray(strPropertyName);
            for (String item : items) {
                arrayNode.add(item);
            }
            return;
        }
        if (Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls)) {
            ArrayNode arrayNode = objectNode.putArray(strPropertyName);
            for (String item : items) {
                arrayNode.add(Integer.parseInt(item));
            }
            return;
        }
        log.error((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u7ec4\u503c\u5bf9\u8c61[%1$s]", objValue));
    }
}

